/*
 * NewJApplet.java
 *
 * Created on December 8, 2008, 12:17 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet implements ActionListener {

    Timer timer;
    DecimalFormat df, df1;
    double P, H,Peq,Heq;
    double rp_val = 0.1;
    double Kp_val = 0.2;
    double Kh_val = 500;
    double rh_val = 0.2;
    double a_val = 0.3;
    double Th_val = 0.5;
    double m_val = 0.0;
    double timestep = 0.01;
    int nsteps = 100;
    double P_0 = 1;
    double H_0 = 1;
    int[] ip, ih, ii;
    int npoints = 500;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                    init_arrays();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        //jPanel1.repaint();
        timer.restart();

    }

    public void init_arrays() {

        ip = new int[npoints];
        ih = new int[npoints];
        ii = new int[npoints];
        df = new DecimalFormat("0.000");
        df1 = new DecimalFormat("0.000");
        rh_val = jSlider1.getValue() * 0.001;
        jLabel1.setText("rH=" + df.format(rh_val));
        Kp_val = jSlider2.getValue() * 0.01;
        jLabel3.setText("k=" + df.format(Kp_val));
        rp_val = jSlider3.getValue() * 0.001;
        jLabel4.setText("rP=" + df.format(rp_val));
        Kh_val = jSlider4.getValue();
        jLabel2.setText("KH=" + df.format(Kh_val));
        nsteps = jSlider5.getValue();
        jLabel5.setText("steps" + nsteps);
        P_0 = jSlider6.getValue();
        jLabel6.setForeground(Color.red);
        jLabel6.setText("P(0)=" + df.format(P_0));
        jLabel7.setForeground(Color.blue);
        H_0 = jSlider7.getValue();
        jLabel7.setText("H(0)=" + df.format(H_0));
        a_val = jSlider8.getValue() * 0.01;
        jLabel8.setText("alpha=" + df.format(a_val));
        Th_val = jSlider9.getValue() * 0.01;
        jLabel9.setText("Th=" + df.format(Th_val));


    }

    public void rk2() {
        double pp, hp, dp, dh;

        dp = rp_val * P * (1 - P / (Kp_val * H));
        dh = rh_val * H * (1 - H / Kh_val) - a_val * H * P / (1 + a_val * Th_val * H);

        pp = P + dp * timestep * 0.5;
        hp = H + dh * timestep * 0.5;

        dp = rp_val * pp * (1 - pp / (Kp_val * hp));
        dh = rh_val * hp * (1 - hp / Kh_val) - a_val * hp * pp / (1 + a_val * Th_val * hp);


        P += dp * timestep;
        H += dh * timestep;




    }

    public void euler() {

        double dp, dh;

        dp = rh_val * H * P - Kh_val * P;
        dh = rp_val * H - Kp_val * H * P;

        P += dp * timestep;
        H += dh * timestep;


    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jSlider3 = new javax.swing.JSlider();
        jSlider4 = new javax.swing.JSlider();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jSlider6 = new javax.swing.JSlider();
        jSlider7 = new javax.swing.JSlider();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jSlider2 = new javax.swing.JSlider();
        jSlider8 = new javax.swing.JSlider();
        jSlider9 = new javax.swing.JSlider();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jSlider5 = new javax.swing.JSlider();
        jLabel5 = new javax.swing.JLabel();

        jPanel1.setMaximumSize(new java.awt.Dimension(500, 700));
        jPanel1.setMinimumSize(new java.awt.Dimension(500, 700));

        jLabel10.setText("jLabel10");

        jLabel11.setText("jLabel10");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addGroup(jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel10, javax.swing.GroupLayout.PREFERRED_SIZE, 351, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel1Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel11, javax.swing.GroupLayout.PREFERRED_SIZE, 351, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(137, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel10)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel11)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jSlider1.setMaximum(1000);
        jSlider1.setValue(100);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jSlider3.setMajorTickSpacing(1);
        jSlider3.setMaximum(2000);
        jSlider3.setValue(200);
        jSlider3.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider3MouseDragged(evt);
            }
        });

        jSlider4.setMaximum(1000);
        jSlider4.setValue(500);
        jSlider4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider4MouseDragged(evt);
            }
        });

        jLabel1.setText("jLabel1");

        jLabel2.setText("jLabel1");

        jLabel4.setText("jLabel1");

        jSlider6.setMaximum(500);
        jSlider6.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider6MouseDragged(evt);
            }
        });

        jSlider7.setMaximum(500);
        jSlider7.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider7MouseDragged(evt);
            }
        });

        jLabel6.setText("jLabel6");

        jLabel7.setText("jLabel7");

        jLabel3.setText("jLabel1");

        jSlider2.setMinimum(1);
        jSlider2.setValue(20);
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jSlider8.setMaximum(150);
        jSlider8.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider8MouseDragged(evt);
            }
        });

        jSlider9.setMaximum(150);
        jSlider9.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider9MouseDragged(evt);
            }
        });

        jLabel8.setText("jLabel8");

        jLabel9.setText("jLabel9");

        jButton1.setText("eq");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jSlider5.setMaximumSize(new java.awt.Dimension(200, 24));
        jSlider5.setMinimumSize(new java.awt.Dimension(200, 24));
        jSlider5.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider5MouseDragged(evt);
            }
        });

        jLabel5.setText("jLabel5");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                        .addGroup(layout.createSequentialGroup()
                            .addGap(80, 80, 80)
                            .addComponent(jLabel1))
                        .addComponent(jSlider1, javax.swing.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE)
                        .addComponent(jSlider3, javax.swing.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE)
                        .addComponent(jSlider2, javax.swing.GroupLayout.DEFAULT_SIZE, 153, Short.MAX_VALUE)
                        .addComponent(jSlider4, 0, 0, Short.MAX_VALUE)
                        .addComponent(jSlider8, 0, 0, Short.MAX_VALUE)
                        .addComponent(jSlider9, 0, 0, Short.MAX_VALUE)
                        .addComponent(jSlider6, javax.swing.GroupLayout.DEFAULT_SIZE, 145, Short.MAX_VALUE)
                        .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                        .addGroup(layout.createSequentialGroup()
                            .addGap(78, 78, 78)
                            .addComponent(jLabel3))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(77, 77, 77)
                            .addComponent(jLabel2))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(74, 74, 74)
                            .addComponent(jLabel4))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(74, 74, 74)
                            .addComponent(jLabel8))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(75, 75, 75)
                            .addComponent(jLabel9))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(79, 79, 79)
                            .addComponent(jLabel6))
                        .addGroup(layout.createSequentialGroup()
                            .addGap(76, 76, 76)
                            .addComponent(jLabel7))
                        .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, 156, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(jButton1, javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(63, 63, 63)
                        .addComponent(jLabel5)))
                .addContainerGap(68, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jSlider1, jSlider2, jSlider3, jSlider4, jSlider6, jSlider7, jSlider8, jSlider9});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 606, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1)
                        .addGap(2, 2, 2)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel8)
                        .addGap(5, 5, 5)
                        .addComponent(jSlider8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(56, 56, 56)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel7)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jButton1)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        rh_val = jSlider1.getValue() * 0.001;
        jLabel1.setText("rH=" + df.format(rh_val));
        jPanel1.repaint();
    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
        Kp_val = jSlider2.getValue() * 0.01;
        jLabel3.setText("k=" + df.format(Kp_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jSlider3MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseDragged
        rp_val = jSlider3.getValue() * 0.001;
        jLabel4.setText("rP=" + df.format(rp_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider3MouseDragged

    private void jSlider4MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseDragged
        Kh_val = jSlider4.getValue();
        jLabel2.setText("KH=" + df.format(Kh_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider4MouseDragged

    private void jSlider5MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider5MouseDragged
        nsteps = jSlider5.getValue();
        jLabel5.setText("steps " + nsteps);
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider5MouseDragged

    private void jSlider6MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider6MouseDragged
        P_0 = jSlider6.getValue();
        jLabel6.setText("P(0)=" + df.format(P_0));
        jPanel1.repaint();  // TODO add your handling code here:
    }//GEN-LAST:event_jSlider6MouseDragged

    private void jSlider7MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider7MouseDragged
        H_0 = jSlider7.getValue();
        jLabel7.setText("H(0)=" + df.format(H_0));
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider7MouseDragged

private void jSlider8MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider8MouseDragged
    a_val = jSlider8.getValue() * 0.01;
    jLabel8.setText("alpha=" + df.format(a_val));
    jPanel1.repaint(); // TODO add your handling code here:
}//GEN-LAST:event_jSlider8MouseDragged

private void jSlider9MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider9MouseDragged
    Th_val = jSlider9.getValue() * 0.01;
    jLabel9.setText("Th=" + df.format(Th_val));
    jPanel1.repaint(); // TODO add your handling code here:
}//GEN-LAST:event_jSlider9MouseDragged

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
H_0=Heq+0.01;
P_0=Peq;
jLabel7.setText("H=" + df.format(H_0));
 jLabel6.setText("P=" + df.format(P_0));
 jPanel1.repaint(); 
// TODO add your handling code here:
}//GEN-LAST:event_jButton1ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider jSlider3;
    private javax.swing.JSlider jSlider4;
    private javax.swing.JSlider jSlider5;
    private javax.swing.JSlider jSlider6;
    private javax.swing.JSlider jSlider7;
    private javax.swing.JSlider jSlider8;
    private javax.swing.JSlider jSlider9;
    // End of variables declaration//GEN-END:variables

    public class myPanel extends javax.swing.JPanel {

        public void paintComponent(Graphics g) {
            int i,   k,   ix,   iy,   ix1,   iy1,   ix2,   iy2,   i2;
            double    qa,   qb,   re1,   re2,   im1,   im2,   ss;
            double a,b,c,app,aph,ahp,ahh,a1,a2,a0,tr,det;

            super.paintComponent(g);

           
            a=1/Kh_val;
            b=a_val*Th_val;
            c=a_val*Kp_val/rh_val;

            re1 = (b-a-c) ;
            re2 = re1;
            im1 = 0;
            im2 = 0;

            ss = (a+b+c)*(a+b+c)-4*b*c;

            if (ss > 0) {
                re1 = re1 + Math.sqrt(ss);
                re2 = re2 - Math.sqrt(ss);
            } else {
                im1 = Math.sqrt(-ss);
                im2 = -im1;
            }
            re1/=(2*a*b);
            re2/=(2*a*b);
            im1/=(2*a*b);
            im2/=(2*a*b);


            a0=-rh_val*Kh_val;
            a1=rh_val+a_val*Kp_val*Kh_val-rh_val*Kh_val*a_val*Th_val;
            a2=rh_val*a_val*Th_val;

            Heq=(Math.sqrt(a1*a1-4*a0*a2)-a1 )/(2*a2);
            Peq=Kp_val*Heq;

            app=-rp_val;
            aph=rp_val*Kp_val;
            ahp=-a_val*Heq/(1+a_val*Th_val*Heq);
            a0=a_val*Heq/(1+a_val*Th_val*Heq);
            ahh=rh_val-2*rh_val*Heq/Kh_val -a_val*Kp_val*Heq/(1+a_val*Th_val*Heq)+Kp_val*Th_val*a0*a0;

            tr=app+ahh;
            det=app*ahh-aph*ahp;


            re1=0.5*tr;
            re2=0.5*tr;
            im1=0;
            im2=0;
            ss=tr*tr-4*det ;
            if (ss > 0) {
                re1 = re1 + 0.5*Math.sqrt(ss);
                re2 = re2 - 0.5*Math.sqrt(ss);
            } else {
                im1 = 0.5*Math.sqrt(-ss);
                im2 = -im1;
            }
            
            jLabel10.setText("  Heq=" + df.format(Heq) +"  Peq="+df.format(Peq));
            
            if(ss>0)
            jLabel11.setText("  eigv1=" + df.format(re1) +"  eigv2="+df.format(re2));
            else
                jLabel11.setText("  eigv=" + df.format(re1)+" +-I* "+df.format(im1));
            
           



            P = P_0;
            H = H_0;
            
                iy1 = 300 - (int) ( P*0.3);
                iy2 = 300 - (int) (H*0.3);
                ii[0] = 0;
                ih[0] = iy2;
                ip[0] = iy1;
            
            for (i = 1; i < npoints; i++) {

                for (k = 0; k < nsteps; k++) {
                    rk2();
                }
                iy1 = 300 - (int) ( P*0.3);
                iy2 = 300 - (int) (H*0.3);
                ii[i] = i;
                ih[i] = iy2;
                ip[i] = iy1;
            }


            iy1 = 300 - (int) (0.3*Peq);
            iy2 = 300 - (int) (0.3*Heq);
            g.setColor(Color.darkGray);
            g.drawLine(0, iy1, npoints, iy1);
            g.drawLine(0, iy2, npoints, iy2);

            g.setColor(Color.blue);
            g.drawPolyline(ii, ih, npoints);
            g.setColor(Color.red);
            //g.drawLine(0, iy1, npoints, iy1);
            g.drawPolyline(ii, ip, npoints);


            for(i=0;i<npoints;i++){ih[i]=(iy2-ih[i])*2+200;ip[i]=(ip[i]-iy1)*2+500;}

            g.drawPolyline(ih, ip, npoints);
            
            g.setColor(Color.BLACK);
            g.drawLine(100,500,300,500);
            g.drawString(" H-Heq",300,500);
            g.drawLine(200,400,200,600);
            g.drawString(" P-Peq",200,400);




        }
    }
}
