/*
 * NewJApplet.java
 *
 * Created on December 8, 2008, 12:17 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet implements ActionListener {

    Timer timer;
    DecimalFormat df, df1;
    double P, H;
    double r_val = 1;
    double a_val = 1;
    double m_val = 0.1;
    double b_val = 0.1;
    double timestep = 0.01;
    int nsteps = 100;
    double P_0 = 1;
    double H_0 = 1;
    double P_eq,H_eq;
    int[] ip, ih, ii;
    int npoints = 500;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                    init_arrays();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        //jPanel1.repaint();
        timer.restart();

    }

    public void init_arrays() {

        ip = new int[npoints];
        ih = new int[npoints];
        ii = new int[npoints];
        df = new DecimalFormat("0.00");
        df1 = new DecimalFormat("0.000");
        r_val = jSlider1.getValue() * 0.01;
        jLabel1.setText("r=" + df.format(r_val));
        a_val = jSlider2.getValue() * 0.01;
        jLabel3.setText("a=" + df.format(a_val));
        b_val = jSlider3.getValue() * 0.01;
        jLabel4.setText("b=" + df.format(b_val));
        m_val = jSlider4.getValue() * 0.01;
        jLabel2.setText("m=" + df.format(m_val));
        nsteps = jSlider5.getValue();
        jLabel5.setText("steps" + nsteps);
        P_0 = jSlider6.getValue() * 0.02;
        jLabel6.setForeground(Color.blue);
        jLabel8.setForeground(Color.blue);
        jLabel6.setText("P(0)=" + df.format(P_0));
        H_0 = jSlider7.getValue() * 0.02;
        jLabel7.setForeground(Color.red);
        jLabel9.setForeground(Color.red);
        jLabel7.setText("H(0)=" + df.format(H_0));
    }

    public void rk2() {
        double pp, hp, dp, dh;

        dp = b_val * H * P - m_val * P;
        dh = r_val * H - a_val * H * P;

        pp = P + dp * timestep * 0.5;
        hp = H + dh * timestep * 0.5;

        dp = b_val * hp * pp - m_val * pp;
        dh = r_val * hp - a_val * hp * pp;

        P += dp * timestep;
        H += dh * timestep;




    }

    public void euler() {

        double dp, dh;

        dp = b_val * H * P - m_val * P;
        dh = r_val * H - a_val * H * P;

        P += dp * timestep;
        H += dh * timestep;


    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jSlider1 = new javax.swing.JSlider();
        jSlider2 = new javax.swing.JSlider();
        jSlider3 = new javax.swing.JSlider();
        jSlider4 = new javax.swing.JSlider();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jSlider5 = new javax.swing.JSlider();
        jLabel5 = new javax.swing.JLabel();
        jSlider6 = new javax.swing.JSlider();
        jSlider7 = new javax.swing.JSlider();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 364, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );

        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jSlider2.setMinimum(1);
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jSlider3.setMajorTickSpacing(1);
        jSlider3.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider3MouseDragged(evt);
            }
        });

        jSlider4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider4MouseDragged(evt);
            }
        });

        jLabel1.setText("jLabel1");

        jLabel2.setText("jLabel1");

        jLabel3.setText("jLabel1");

        jLabel4.setText("jLabel1");

        jSlider5.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider5MouseDragged(evt);
            }
        });

        jLabel5.setText("jLabel5");

        jSlider6.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider6MouseDragged(evt);
            }
        });

        jSlider7.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider7MouseDragged(evt);
            }
        });

        jLabel6.setText("jLabel6");

        jLabel7.setText("jLabel7");

        jLabel8.setText("jLabel8");

        jLabel9.setText("jLabel9");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 150, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(57, 57, 57)
                        .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(97, 97, 97)
                        .addComponent(jLabel1))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(76, 76, 76)
                                .addComponent(jLabel6))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(77, 77, 77)
                                .addComponent(jLabel7))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(81, 81, 81)
                                .addComponent(jLabel3))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(82, 82, 82)
                                .addComponent(jLabel4))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(85, 85, 85)
                                .addComponent(jLabel2))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(84, 84, 84)
                                .addComponent(jLabel5))
                            .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 153, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(328, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(jLabel8)
                    .addComponent(jLabel9))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(8, 8, 8)
                        .addComponent(jLabel3)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel4)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(56, 56, 56)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(26, 26, 26)
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel7)
                        .addGap(12, 12, 12)
                        .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 49, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(1, 1, 1)
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        r_val = jSlider1.getValue() * 0.01;
        jLabel1.setText("r=" + df.format(r_val));
        jPanel1.repaint();
    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
        a_val = jSlider2.getValue() * 0.01;
        jLabel3.setText("a=" + df.format(a_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jSlider3MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseDragged
        b_val = jSlider3.getValue() * 0.01;
        jLabel4.setText("b=" + df.format(b_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider3MouseDragged

    private void jSlider4MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseDragged
        m_val = jSlider4.getValue() * 0.01;
        jLabel2.setText("m=" + df.format(m_val));
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider4MouseDragged

    private void jSlider5MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider5MouseDragged
        nsteps = jSlider5.getValue();
        jLabel5.setText("steps" + nsteps);
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider5MouseDragged

    private void jSlider6MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider6MouseDragged
        P_0 = jSlider6.getValue() * 0.02;
        jLabel6.setText("P(0)=" + df.format(P_0));
        jPanel1.repaint();  // TODO add your handling code here:
    }//GEN-LAST:event_jSlider6MouseDragged

    private void jSlider7MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider7MouseDragged
        H_0 = jSlider7.getValue() * 0.02;
        jLabel7.setText("H(0)=" + df.format(H_0));
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider7MouseDragged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider jSlider3;
    private javax.swing.JSlider jSlider4;
    private javax.swing.JSlider jSlider5;
    private javax.swing.JSlider jSlider6;
    private javax.swing.JSlider jSlider7;
    // End of variables declaration//GEN-END:variables

    public class myPanel extends javax.swing.JPanel {

        public void paintComponent(Graphics g) {
            int i, k, ix, iy, ix1, iy1, ix2, iy2, i2, iPeq,iHeq;
            double Heq, Peq;

            super.paintComponent(g);
            
            
            
           
            P = P_0;
            H = H_0;
            
                iy1 = 300 - (int) (50 * P);
                iy2 = 300 - (int) (50 * H);
                ii[0] = 0;
                ih[0] = iy2;
                ip[0] = iy1;
            
            for (i = 1; i < npoints; i++) {
                for (k = 0; k < nsteps; k++) {
                    rk2();
                }
                iy1 = 300 - (int) (50 * P);
                iy2 = 300 - (int) (50 * H);
                ii[i] = i;
                ih[i] = iy2;
                ip[i] = iy1;
            }

            Heq = m_val / b_val;
            Peq = r_val / a_val;
            
             jLabel8.setText("eq P= "+df.format(Peq));
            jLabel9.setText("eq H= "+df.format(Heq));

            
            iy1 = 300 - (int) (50 * Peq);
            iy2 = 300 - (int) (50 * Heq);
            g.setColor(Color.red);
            g.drawLine(0, iy2, npoints, iy2);

            g.drawPolyline(ii, ih, npoints);
            g.setColor(Color.blue);
            g.drawLine(0, iy1, npoints, iy1);
            g.drawPolyline(ii, ip, npoints);

            for(i=0;i<npoints;i++){ih[i]=200+iy2-ih[i];ip[i]=(ip[i]-iy1)+500;}

            g.drawPolyline(ih, ip, npoints);
            //g.fillOval(200, 500, 4, 4);
            g.drawLine(100,500,300,500);
            g.drawString(" H-Heq",300,500);
            g.drawLine(200,400,200,600);
            g.drawString(" P-Peq",200,400);

        }
    }
}
