/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * NewJApplet.java
 *
 * Created on 15.10.2009, 16:40:58
 */
import java.awt.Graphics2D;
import java.awt.*;
import java.text.*;

/**
 *
 * @author poj
 */
public class NewJApplet extends javax.swing.JApplet {

    double xmin = -2.0;
    double xmax = 5.0;
    double ymin = -1.0;
    double ymax = 1.0;
    double pxmin, pxmax, pymin, pymax;
    int nmaxpoints = 20;
    int ndraw = 400;
    int draw_off=10;
    int npoints = 0;
    int[] ixp, iyp;
    double[] xval, yval;
    double[] xdat, ydat;
    double[] a, t;
    double newvalue;
    double[][] coeff;
    double[] weight;
    int method = 2;

    /**
     * Initializes the applet NewJApplet
     */
    public void init() {
        int i;





        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        xval = new double[ndraw];
        yval = new double[ndraw];
        ixp = new int[ndraw];
        iyp = new int[ndraw];
        xdat = new double[nmaxpoints];
        ydat = new double[nmaxpoints];
        a = new double[nmaxpoints];
        t = new double[nmaxpoints];
        coeff = new double[nmaxpoints][4];
        weight = new double[nmaxpoints];



        for (i = 0; i < ndraw; i++) {
            xval[i] = xmin + ((xmax - xmin) * i) / ndraw;
            yval[i] = Math.sin(xval[i]);

            npoints = 4;
            xdat[0] = -1.5;
            ydat[0] = -3.375;
            xdat[1] = -1.0;
            ydat[1] = -1.0;
            xdat[2] = -0.500;
            ydat[2] = -0.125;
            xdat[3] = 0.00;
            ydat[3] = 0.00;

            minmax();
            xf0.setText("" + xdat[0]);
            yf0.setText("" + ydat[0]);
            xf1.setText("" + xdat[1]);
            yf1.setText("" + ydat[1]);
            xf2.setText("" + xdat[2]);
            yf2.setText("" + ydat[2]);
            xf3.setText("" + xdat[3]);
            yf3.setText("" + ydat[3]);

            xf4.setText("");
            yf4.setText("");

            xf5.setText("");
            yf5.setText("");

            xf6.setText("");
            yf6.setText("");

            xf7.setText("");
            yf7.setText("");

            xf8.setText("");
            yf8.setText("");

            xf9.setText("");
            yf9.setText("");

            xf10.setText("");
            yf10.setText("");

        }

    }

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jRadioButton3 = new javax.swing.JRadioButton();
        xf0 = new javax.swing.JTextField();
        yf0 = new javax.swing.JTextField();
        yf1 = new javax.swing.JTextField();
        xf1 = new javax.swing.JTextField();
        xf2 = new javax.swing.JTextField();
        yf2 = new javax.swing.JTextField();
        xf3 = new javax.swing.JTextField();
        yf3 = new javax.swing.JTextField();
        xf4 = new javax.swing.JTextField();
        yf4 = new javax.swing.JTextField();
        xf5 = new javax.swing.JTextField();
        yf5 = new javax.swing.JTextField();
        yf6 = new javax.swing.JTextField();
        xf6 = new javax.swing.JTextField();
        xf7 = new javax.swing.JTextField();
        yf7 = new javax.swing.JTextField();
        yf8 = new javax.swing.JTextField();
        xf8 = new javax.swing.JTextField();
        xf9 = new javax.swing.JTextField();
        yf9 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();
        xf10 = new javax.swing.JTextField();
        yf10 = new javax.swing.JTextField();
        jRadioButton4 = new javax.swing.JRadioButton();
        jRadioButton5 = new javax.swing.JRadioButton();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 507, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 434, Short.MAX_VALUE)
        );

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("polynomial");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("linear spline");
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton3);
        jRadioButton3.setText("cubic spline");
        jRadioButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton3ActionPerformed(evt);
            }
        });

        xf0.setText("jTextField1");

        yf0.setText("jTextField2");

        yf1.setText("jTextField2");

        xf1.setText("jTextField1");

        xf2.setText("jTextField1");

        yf2.setText("jTextField2");

        xf3.setText("jTextField1");

        yf3.setText("jTextField2");

        xf4.setText("jTextField1");

        yf4.setText("jTextField2");

        xf5.setText("jTextField1");

        yf5.setText("jTextField2");

        yf6.setText("jTextField2");

        xf6.setText("jTextField1");

        xf7.setText("jTextField1");

        yf7.setText("jTextField2");

        yf8.setText("jTextField2");

        xf8.setText("jTextField1");

        xf9.setText("jTextField1");

        yf9.setText("jTextField2");

        jButton1.setText("refresh");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        xf10.setText("jTextField1");

        yf10.setText("jTextField2");

        buttonGroup1.add(jRadioButton4);
        jRadioButton4.setText("rational FH");
        jRadioButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton4ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton5);
        jRadioButton5.setText("rational B");
        jRadioButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton5ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(37, 37, 37)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(xf0)
                                    .addComponent(xf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(xf10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(yf0, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(yf10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addContainerGap(107, Short.MAX_VALUE))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton1)
                                .addContainerGap())))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jRadioButton1)
                        .addGap(18, 18, 18)
                        .addComponent(jRadioButton2)
                        .addGap(18, 18, 18)
                        .addComponent(jRadioButton3)
                        .addGap(18, 18, 18)
                        .addComponent(jRadioButton4)
                        .addGap(18, 18, 18)
                        .addComponent(jRadioButton5)
                        .addGap(0, 0, Short.MAX_VALUE))))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {xf0, xf1, xf10, xf2, xf3, xf4, xf5, xf6, xf7, xf8, xf9, yf0, yf1, yf10, yf2, yf3, yf4, yf5, yf6, yf7, yf8, yf9});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jRadioButton1, jRadioButton2, jRadioButton3});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(yf0, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(yf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(25, 25, 25)
                                        .addComponent(yf10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addComponent(yf9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(xf0, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf9, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(xf10, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                        .addGap(18, 18, 18)
                        .addComponent(jButton1)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButton1)
                    .addComponent(jRadioButton2)
                    .addComponent(jRadioButton3)
                    .addComponent(jRadioButton4)
                    .addComponent(jRadioButton5))
                .addContainerGap(121, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {xf0, xf1, xf10, xf2, xf3, xf4, xf5, xf6, xf7, xf8, xf9, yf0, yf1, yf10, yf2, yf3, yf4, yf5, yf6, yf7, yf8, yf9});

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jRadioButton1, jRadioButton2, jRadioButton3});

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        getvalues();
        minmax();
        minmaxp();
        jPanel1.repaint();
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        jRadioButton1.setSelected(true);
        method = 0;

        jPanel1.repaint();       // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
        jRadioButton2.setSelected(true);
        method = 1;
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    private void jRadioButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton3ActionPerformed
        jRadioButton3.setSelected(true);
        method = 2;
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton3ActionPerformed

    private void jRadioButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton4ActionPerformed

        jRadioButton4.setSelected(true);
        method = 3;
        jPanel1.repaint();
    }//GEN-LAST:event_jRadioButton4ActionPerformed

    private void jRadioButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton5ActionPerformed
       jRadioButton5.setSelected(true);
        method = 4;
        jPanel1.repaint();
        
    }//GEN-LAST:event_jRadioButton5ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JRadioButton jRadioButton3;
    private javax.swing.JRadioButton jRadioButton4;
    private javax.swing.JRadioButton jRadioButton5;
    private javax.swing.JTextField xf0;
    private javax.swing.JTextField xf1;
    private javax.swing.JTextField xf10;
    private javax.swing.JTextField xf2;
    private javax.swing.JTextField xf3;
    private javax.swing.JTextField xf4;
    private javax.swing.JTextField xf5;
    private javax.swing.JTextField xf6;
    private javax.swing.JTextField xf7;
    private javax.swing.JTextField xf8;
    private javax.swing.JTextField xf9;
    private javax.swing.JTextField yf0;
    private javax.swing.JTextField yf1;
    private javax.swing.JTextField yf10;
    private javax.swing.JTextField yf2;
    private javax.swing.JTextField yf3;
    private javax.swing.JTextField yf4;
    private javax.swing.JTextField yf5;
    private javax.swing.JTextField yf6;
    private javax.swing.JTextField yf7;
    private javax.swing.JTextField yf8;
    private javax.swing.JTextField yf9;
    // End of variables declaration//GEN-END:variables

    public int check(javax.swing.JTextField xf) {

        // check if xf contains a valid number

        double d;
        String s;
        int valid;

        d = 0;
        valid = 1;

        try {
            s = xf.getText();
            d = Double.parseDouble(s);
        } catch (NumberFormatException e) {
            xf.setText("");

            valid = 0;
        } finally {

            if (valid > 0) {
                newvalue = d;
            }

        }
        return valid;
    }

    public void getvalues() {

        double d;
        int i, validx, validy;
        int change;
        String s;

        npoints = 0;

        checkpair(xf0, yf0);
        checkpair(xf1, yf1);
        checkpair(xf2, yf2);
        checkpair(xf3, yf3);
        checkpair(xf4, yf4);
        checkpair(xf5, yf5);
        checkpair(xf6, yf6);
        checkpair(xf7, yf7);
        checkpair(xf8, yf8);
        checkpair(xf9, yf9);
        checkpair(xf10, yf10);


    }

    public void checkpair(javax.swing.JTextField xf, javax.swing.JTextField yf) {
        double d;
        int i, validx, validy;
        int change;
        String s;

        // check if xf,yf are a valid data pair, if so store

        validx = check(xf);
        if (validx > 0) {
            xdat[npoints] = newvalue;
        }

        validy = check(yf);
        if (validy > 0) {
            ydat[npoints] = newvalue;
        }

        if (validx > 0 && validy > 0) {
            npoints += 1;
        }

    }

    public void minmax() {
        int i;
        double a, dx, dy, mx, my;

        a = 1000;
        for (i = 0; i < npoints; i++) {
            if (xdat[i] < a) {
                a = xdat[i];
            }
        }
        xmin = a;
        a = 1000;
        for (i = 0; i < npoints; i++) {
            if (ydat[i] < a) {
                a = ydat[i];
            }
        }
        ymin = a;
        a = -1000;
        for (i = 0; i < npoints; i++) {
            if (xdat[i] > a) {
                a = xdat[i];
            }
        }
        xmax = a;
        a = -1000;
        for (i = 0; i < npoints; i++) {
            if (ydat[i] > a) {
                a = ydat[i];
            }
        }
        ymax = a;



        pxmin=xmin;
        pxmax=xmax;
        pymin=ymin;
        pymax=ymax;


    }

    public void minmaxp() {
        int i;
        double a, dx, dy, mx, my;


        a = pymin;
        for (i = 0; i < ndraw; i++) {
            if (yval[i] < a) {
                a = yval[i];
            }
        }
        pymin = a;

        a = pymax;
        for (i = 0; i < ndraw; i++) {
            if (yval[i] > a) {
                a = yval[i];
            }
        }
        pymax = a;







    }
    public double getz(int ix)
    {
    
    return pxmin+ix*(pxmax-pxmin)/ndraw;
    
    }

    public int ytrans(double y) {
        return ndraw - (int) (ndraw * (y - pymin) / (pymax - pymin));

    }

    public int xtrans(double x) {
        return (int) (ndraw * (x - pxmin) / (pxmax - pxmin));

    }

// use Newtons divided differences
    public void divdif() {
        int i, k;
        for (i = 0; i < npoints; i++) {
            t[i] = ydat[i];
            for (k = i - 1; k >= 0; k--) {
                t[k] = (t[k + 1] - t[k]) / (xdat[i] - xdat[k]);
            }
            a[i] = t[0];
        }
    }

// evaluate the polynomial
    public double poly(double z) {
        int i;
        double p;
        p = a[npoints - 1];
        for (i = npoints - 2; i >= 0; i--) {
            p = p * (z - xdat[i]) + a[i];
        }
        return p;
    }

    public void interpol() {
        int i;
        double x, y, z;
        divdif();
        for (i = 0; i < ndraw; i++) {
            z = xmin + i * (xmax - xmin) / ndraw;
            y = poly(z);
            xval[i] = z;
            yval[i] = y;
        }
    }

    public void intersplinel() {
        int i;
        double x, y, z;
        divdif();
        for (i = 0; i < ndraw; i++) {
            z = xmin + i * (xmax - xmin) / ndraw;
            y = evalsplinel(z);
            xval[i] = z;
            yval[i] = y;
        }
    }

    public void interspline() {
        int i;
        double x, y, z;
        divdif();
        for (i = 0; i < ndraw; i++) {
            //z = xmin + i * (xmax - xmin) / ndraw;
            z=getz(i);
            y = evalspline(z);
            xval[i] = z;
            yval[i] = y;
        }
    }

    // interpolation with cubic spline
    void spline() {
        int i;

        double[] h, lam, mu, d;
        double[] p, q, u, m;

        h = new double[nmaxpoints];
        lam = new double[nmaxpoints];
        mu = new double[nmaxpoints];
        d = new double[nmaxpoints];
        p = new double[nmaxpoints];
        q = new double[nmaxpoints];
        u = new double[nmaxpoints];
        m = new double[nmaxpoints];


// calculate h,lambda,mu,d

        for (i = 1; i < npoints; i++) {
            h[i] = xdat[i] - xdat[i - 1];
        }

        for (i = 1; i < npoints - 1; i++) {
            lam[i] = h[i + 1] / (h[i] + h[i + 1]);
            mu[i] = 1.0 - lam[i];
        }
        for (i = 1; i < npoints - 1; i++) {
            d[i] = (ydat[i + 1] - ydat[i]) / h[i + 1] - (ydat[i] - ydat[i - 1]) / h[i];
            d[i] = d[i] * 6.0 / (h[i] + h[i + 1]);
        }

// natural b.c.

        d[0] = 0.0;
        lam[0] = 0.0;
        mu[0] = 1.0;


// calculate M=s''(i)

        q[0] = -lam[0] * 0.5;
        u[0] = d[0] * 0.5;

        for (i = 1; i < npoints; i++) {
            p[i] = mu[i] * q[i - 1] + 2.0;
            q[i] = -(lam[i] / p[i]);
            u[i] = (d[i] - mu[i] * u[i - 1]) / p[i];
        }
        m[npoints - 1] = u[npoints - 1];

        for (i = npoints - 2; i >= 0; i--) {
            m[i] = q[i] * m[i + 1] + u[i];
        }

// calculate the coefficients of the Spline function



        for (i = 0; i < npoints - 1; i++) {
            coeff[i][0] = ydat[i];
            coeff[i][2] = m[i] * 0.5;
            coeff[i][1] = (ydat[i + 1] - ydat[i]) / h[i + 1] - h[i + 1] * (2.0 * m[i] + m[i + 1]) / 6.0;
            coeff[i][3] = (m[i + 1] - m[i]) / (6.0 * h[i + 1]);

        }


    }

    double evalsplinel(double z) // evaluate the Spline function
    {
        int i, j;
        double hij, hyij, sp, dz;

        sp = 0;


// look for interval containing z

        for (i = 0; i < npoints - 1; i++) {
            if (z >= xdat[i] && z < xdat[i + 1]) {



                hij = xdat[i + 1] - xdat[i];
                hyij = ydat[i + 1] - ydat[i];


                dz = z - xdat[i];

                sp = ydat[i] + hyij * dz / hij;



            }
        }
        return sp;
    }

    double evalspline(double z) // evaluate the Spline function
    {
        int i, j;
        double hij, sp, dz;

        sp = 0;


// look for interval containing z

        for (i = 0; i < npoints - 1; i++) {
            if (z >= xdat[i] && z < xdat[i + 1]) {



                hij = xdat[i + 1] - xdat[i];


                dz = z - xdat[i];
                sp = coeff[i][3] * dz;
                sp = (sp + coeff[i][2]) * dz;
                sp = (sp + coeff[i][1]) * dz;
                sp += coeff[i][0];



            }
        }
        return sp;
    }

    void evalweights() {
        double wsig;
        int i;
        for(i=0;i<npoints;i++)weight[i]=0;
        wsig = -1;
        weight[0] = wsig / (xdat[1] - xdat[0]);
        for (i = 1; i < npoints - 1; i++) {
            wsig = -wsig;
            weight[i] = wsig * (1 / (xdat[i] - xdat[i - 1]) + 1 / (xdat[i + 1] - xdat[i]));
        }
        wsig = -wsig;
        weight[npoints - 1] = wsig / (xdat[npoints - 1] - xdat[npoints-2]);


    }
    void Berrweights(){
    double wsig;
    int i;
    wsig=1;
    for(i=0;i<npoints;i++) {weight[i]=wsig;wsig=-wsig;}
    
    }

    double ratint(double x) {
        int i;
        double r, rnum, rden;
        double eps = 1.0E-12;
        boolean close;
        double pr;
        r = 0;
        close = false;

        for (i = 0; i < npoints; i++) {
            if (Math.abs(x - xdat[i]) < eps) {
                close = true;
                r = ydat[i];

            }}
            if (!close) {
                rnum = 0;
                rden = 0;

                for (i = 0; i < npoints; i++) {
                    pr = weight[i] / (x - xdat[i]);
                    rnum = rnum + ydat[i] * pr;
                    rden = rden + pr;

                }
                r=rnum/rden;


            }



        

        return r;
    }
     public void interrat(int wkind) {
        int i;
        double x, y, z;
        
        if(wkind==0) evalweights(); else Berrweights();
        for (i = 0; i < ndraw; i++) {
            z = xmin + i * (xmax - xmin) / ndraw;
            y = ratint(z);
            xval[i] = z;
            yval[i] = y;
        }
    }

    public class myPanel extends javax.swing.JPanel {

        int i, ix, iy, ix0, iy0;

        public void paintComponent(Graphics g) {

            super.paintComponent(g);

            if (method == 0) {
                interpol();
            }
            if (method == 1) {
                spline();
                intersplinel();
            }

            if (method == 2) {
                spline();
                interspline();
            }
            if (method == 3) {
                
                interrat(0);
                
            }
            if (method == 4) {
                
                interrat(1);
                
            }

            //minmaxp();

            for (i = 0; i < npoints; i++) {
                ix = xtrans(xdat[i]);
                iy = ytrans(ydat[i]);

                g.fillOval(ix - 7+draw_off, iy - 7+draw_off, 15, 15);
            }
            for (i = 0; i < ndraw; i++) {
                ixp[i] = i+draw_off;
                iyp[i] = ytrans(yval[i])+draw_off;

            }

            ix0 = xtrans(0)+draw_off;
            iy0 = ytrans(0)+draw_off;

            g.drawPolyline(ixp, iyp, ndraw);


            g.drawLine(ix0, 0, ix0, ndraw);
            g.drawLine(0, iy0, ndraw, iy0);


            for (i = -10; i <= 10; i++) {
                if (i >= xmin && i <= xmax) {
                    ix0 = xtrans(i)+draw_off;
                    iy0 = ytrans(0)+draw_off;
                    g.drawLine(ix0, iy0 - 10, ix0, iy0 + 10);
                    g.drawString("" + i, ix0 - 5, iy0 + 20);
                }
            }

            for (i = -10; i <= 10; i++) {
                if (i >= pymin && i <= pymax) {
                    ix0 = xtrans(0)+draw_off;
                    iy0 = ytrans(i)+draw_off;
                    g.drawLine(ix0 - 10, iy0, ix0 + 10, iy0);
                    g.drawString("" + i, ix0 - 30, iy0 + 5);
                }
            }

        }
    }
}
