/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * NewJApplet.java
 *
 * Created on 15.10.2009, 16:40:58
 */
import java.awt.Graphics2D;
import java.awt.*;
import java.text.*;

/**
 *
 * @author poj
 */
public class NewJApplet extends javax.swing.JApplet {

    double xmin = -2.0;
    double xmax = 5.0;
    double ymin = -1.0;
    double ymax = 1.0;
    double zmin = -1.0;
    double zmax = 1.0;
    double pxmin, pxmax, pymin, pymax, pzmin, pzmax;
    int nmaxpoints = 21;
    int ndraw = 101;  // fine grid
    int nscale = 400;
    int npoints = 0;  // total number of data points
    int ngpoints;     // gridpoints in 1 dimension
    int[] ixp, iyp;
    double[][] zval;
    double[][] zgdat;
    double[][] xfgdat;
    double[][] yfgdat;
    double[][] zfgdat;
    double[] work;
    double[] xdat, ydat, zdat;
    double[] a, t;
    double newvalue;
    double[][] coeff;
    int method = 0;
    double[] h, lam, mu, d, p, q, u, m, xgdat;

    /** Initializes the applet NewJApplet */
    public void init() {
        int i;





        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        zval = new double[ndraw][ndraw];

        ixp = new int[ndraw];
        iyp = new int[ndraw];
        xdat = new double[nmaxpoints];
        ydat = new double[nmaxpoints];
        zdat = new double[nmaxpoints];
        zfgdat = new double[ndraw][ndraw];
        xfgdat = new double[ndraw][ndraw];
        yfgdat = new double[ndraw][ndraw];
        zgdat = new double[nmaxpoints][nmaxpoints];


        a = new double[nmaxpoints];
        t = new double[nmaxpoints];
        coeff = new double[nmaxpoints][4];

        work = new double[ndraw];
        
        h = new double[nmaxpoints];
        lam = new double[nmaxpoints];
        mu = new double[nmaxpoints];
        d = new double[nmaxpoints];
        p = new double[nmaxpoints];
        q = new double[nmaxpoints];
        u = new double[nmaxpoints];
        m = new double[nmaxpoints];
        xgdat = new double[nmaxpoints];




        for (i = 0; i < ndraw; i++) {


            npoints = 9;
            ngpoints=3;

            xgdat[0] = 0;
            xgdat[1] = 1;
            xgdat[2] = 2;

            xdat[0] = 0;
            ydat[0] = 0;
            zdat[0] = 1;
            zgdat[0][0] = 1;

            xdat[1] = 1;
            ydat[1] = 0;
            zdat[1] = 0;
            zgdat[1][0] = 0;

            xdat[2] = 2;
            ydat[2] = 0;
            zdat[2] = -1;
            zgdat[2][0] = -1;


            xdat[3] = 0;
            ydat[3] = 1;
            zdat[3] = 0;
            zgdat[0][1] = 0;

            xdat[4] = 1;
            ydat[4] = 1;
            zdat[4] = 0;
            zgdat[1][1] = 0;

            xdat[5] = 2;
            ydat[5] = 1;
            zdat[5] = 0;
            zgdat[2][1] = 0;

            xdat[6] = 0;
            ydat[6] = 2;
            zdat[6] = -1;
            zgdat[0][2] = -1;

            xdat[7] = 1;
            ydat[7] = 2;
            zdat[7] = 0;
            zgdat[1][2] = 0;

            xdat[8] = 2;
            ydat[8] = 2;
            zdat[8] = 1;
            zgdat[2][2] = 1;





            minmax();

            zf0.setText("" + zdat[0]);

            zf1.setText("" + zdat[1]);

            zf2.setText("" + zdat[2]);

            zf3.setText("" + zdat[3]);

            zf4.setText("" + zdat[4]);

            zf5.setText("" + zdat[5]);

            zf6.setText("" + zdat[6]);

            zf7.setText("" + zdat[7]);

            zf8.setText("" + zdat[8]);


            minmax();
            method=0;
            bilin();
            jPanel1.repaint();
        }

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jButton1 = new javax.swing.JButton();
        zf0 = new javax.swing.JTextField();
        zf1 = new javax.swing.JTextField();
        zf2 = new javax.swing.JTextField();
        zf3 = new javax.swing.JTextField();
        zf4 = new javax.swing.JTextField();
        zf5 = new javax.swing.JTextField();
        zf6 = new javax.swing.JTextField();
        zf7 = new javax.swing.JTextField();
        zf8 = new javax.swing.JTextField();
        label1 = new java.awt.Label();
        label2 = new java.awt.Label();
        label3 = new java.awt.Label();
        label4 = new java.awt.Label();
        label5 = new java.awt.Label();
        label6 = new java.awt.Label();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 507, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 434, Short.MAX_VALUE)
        );

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("bilinear");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("bispline");
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        jButton1.setText("refresh");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        zf0.setText("jTextField1");

        zf1.setText("jTextField1");

        zf2.setText("jTextField1");

        zf3.setText("jTextField1");

        zf4.setText("jTextField1");

        zf5.setText("jTextField1");

        zf6.setText("jTextField1");

        zf7.setText("jTextField1");

        zf8.setText("jTextField1");

        label1.setText("0");

        label2.setText("1");

        label3.setText("2   ");

        label4.setText("0");

        label5.setText("1   ");

        label6.setText("2   ");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(30, 30, 30)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jRadioButton1)
                        .addGap(18, 18, 18)
                        .addComponent(jRadioButton2))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(label2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(label3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(label1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addComponent(jButton1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                .addGroup(layout.createSequentialGroup()
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(label4, javax.swing.GroupLayout.DEFAULT_SIZE, 32, Short.MAX_VALUE)
                                            .addGap(55, 55, 55))
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(zf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGap(18, 18, 18))
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(zf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGap(18, 18, 18)))
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                        .addGroup(layout.createSequentialGroup()
                                            .addComponent(zf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGap(18, 18, 18)
                                            .addComponent(zf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addGroup(layout.createSequentialGroup()
                                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addGroup(layout.createSequentialGroup()
                                                    .addComponent(label5, javax.swing.GroupLayout.DEFAULT_SIZE, 32, Short.MAX_VALUE)
                                                    .addGap(55, 55, 55))
                                                .addGroup(layout.createSequentialGroup()
                                                    .addComponent(zf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                    .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)))
                                            .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                                .addComponent(zf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                                .addComponent(label6, javax.swing.GroupLayout.DEFAULT_SIZE, 32, Short.MAX_VALUE)))))
                                .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                    .addComponent(zf0)
                                    .addGap(18, 18, 18)
                                    .addComponent(zf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGap(18, 18, 18)
                                    .addComponent(zf2, javax.swing.GroupLayout.PREFERRED_SIZE, 69, javax.swing.GroupLayout.PREFERRED_SIZE))))))
                .addContainerGap(74, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jRadioButton1, jRadioButton2});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {label2, label3, label4, label5, label6});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {zf0, zf1, zf2, zf3, zf4, zf5, zf6, zf7, zf8});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(12, 12, 12)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(27, 27, 27)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jRadioButton1)
                            .addComponent(jRadioButton2)))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(3, 3, 3)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(label1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(12, 12, 12)
                                .addComponent(label2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(label3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(label4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(label5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(label6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                    .addComponent(zf8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(zf6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(zf7, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(30, 30, 30)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                            .addComponent(zf0, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(zf1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addComponent(zf2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                                        .addComponent(zf4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(zf3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addComponent(zf5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))))
                        .addGap(93, 93, 93)
                        .addComponent(jButton1)))
                .addContainerGap(152, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jRadioButton1, jRadioButton2});

    }// </editor-fold>//GEN-END:initComponents

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        getvalues();
        minmax();

        if(method==1)bispline();
        if(method==0)bilin();
        //minmaxp();
        jPanel1.repaint();
    // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        jRadioButton1.setSelected(true);
        method = 0;
        bilin();

        jPanel1.repaint();       // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
        jRadioButton2.setSelected(true);
        method = 1;
        bispline();
        jPanel1.repaint(); // TODO add your handling code here:
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private java.awt.Label label1;
    private java.awt.Label label2;
    private java.awt.Label label3;
    private java.awt.Label label4;
    private java.awt.Label label5;
    private java.awt.Label label6;
    private javax.swing.JTextField zf0;
    private javax.swing.JTextField zf1;
    private javax.swing.JTextField zf2;
    private javax.swing.JTextField zf3;
    private javax.swing.JTextField zf4;
    private javax.swing.JTextField zf5;
    private javax.swing.JTextField zf6;
    private javax.swing.JTextField zf7;
    private javax.swing.JTextField zf8;
    // End of variables declaration//GEN-END:variables

    public int check(javax.swing.JTextField xf) {

        // check if xf contains a valid number

        double d;
        String s;
        int valid;

        d = 0;
        valid = 1;

        try {
            s = xf.getText();
            d = Double.parseDouble(s);
        } catch (NumberFormatException e) {
            xf.setText("");

            valid = 0;
        } finally {

            if (valid > 0) {
                newvalue = d;
            }

        }
        return valid;
    }

    public void getvalues() {

        double d;
        int i, validx, validy;
        int change;
        String s;

        npoints = 0;

        checksingl(zf0);
        checksingl(zf1);
        checksingl(zf2);
        checksingl(zf3);
        checksingl(zf4);
        checksingl(zf5);
        checksingl(zf6);
        checksingl(zf7);
        checksingl(zf8);


    }

    public void checktripl(javax.swing.JTextField xf, javax.swing.JTextField yf, javax.swing.JTextField zf) {
        double d;
        int i, validx, validy, validz;
        int change;
        String s;

        // check if xf,yf,zf are a valid data triple, if so store it

        validx = check(xf);
        if (validx > 0) {
            xdat[npoints] = newvalue;
        }

        validy = check(yf);
        if (validy > 0) {
            ydat[npoints] = newvalue;
        }

        validz = check(zf);
        if (validz > 0) {
            zdat[npoints] = newvalue;
        }


        if (validx > 0 && validy > 0 && validz > 0) {
            npoints += 1;
        }

    }

    public void checkpair(javax.swing.JTextField xf, javax.swing.JTextField yf) {
        double d;
        int i, validx, validy;
        int change;
        String s;

        // check if xf,yf are a valid data pair, if so store

        validx = check(xf);
        if (validx > 0) {
            xdat[npoints] = newvalue;
        }

        validy = check(yf);
        if (validy > 0) {
            ydat[npoints] = newvalue;
        }

        if (validx > 0 && validy > 0) {
            npoints += 1;
        }

    }

    public void checksingl(javax.swing.JTextField xf) {
        double d;
        int i, validx, validy, ix, iy;
        int change;
        String s;

        // check if xf,yf are a valid data pair, if so store

        validx = check(xf);
        if (validx > 0) {
            zdat[npoints] = newvalue;
            npoints++;
        }

        for (i = 0; i < npoints; i++) {

            ix = (int) xdat[i];
            iy = (int) ydat[i];
            zgdat[ix][iy] = zdat[i];

        }



    }

    public void minmax() {
        int i;
        double a, dx, dy, mx, my, dz, mz;

        a = 1000;
        for (i = 0; i < npoints; i++) {
            if (xdat[i] < a) {
                a = xdat[i];
            }
        }
        xmin = a;
        a = 1000;
        for (i = 0; i < npoints; i++) {
            if (ydat[i] < a) {
                a = ydat[i];
            }
        }
        ymin = a;
        a = 1000;
        for (i = 0; i < npoints; i++) {
            if (zdat[i] < a) {
                a = zdat[i];
            }
        }
        zmin = a;



        a = -1000;
        for (i = 0; i < npoints; i++) {
            if (xdat[i] > a) {
                a = xdat[i];
            }
        }
        xmax = a;
        a = -1000;
        for (i = 0; i < npoints; i++) {
            if (ydat[i] > a) {
                a = ydat[i];
            }
        }
        ymax = a;
        a = -1000;
        for (i = 0; i < npoints; i++) {
            if (zdat[i] > a) {
                a = zdat[i];
            }
        }
        zmax = a;

        dx = (xmax - xmin) / 2;
        dy = (ymax - ymin) / 2;
        dz = (zmax - zmin) / 2;
        mx = (xmax + xmin) / 2;
        my = (ymax + ymin) / 2;
        mz = (zmax + zmin) / 2;

        if (zmin == zmax) {
            dz = 0.5;
        }

        // the range is eventually enlargened for the graphics:

        pxmin = mx - dx * 1.2;
        pxmax = mx + dx * 1.2;

        pymin = my - dy * 1.2;
        pymax = my + dy * 1.2;


        pzmin = mz - dz * 1.4;
        pzmax = mz + dz * 1.4;

        a = 0;




    }

    public int ytrans(double x, double y, double z) {
        double ix, iz, iy;


        iy = ((y - pymin) / (pymax - pymin));
        iz = ((z - pzmin) / (pzmax - pzmin));



        return nscale - (int) (nscale * (0.7 * iz + 0.25 * iy));

    }

    public int xtrans(double x, double y, double z) {
        double ix, iy;
        ix = ((x - pxmin) / (pxmax - pxmin));
        iy = ((y - pymin) / (pymax - pymin));

        return (int) (nscale * (0.7 * ix + 0.25 * iy));

    }

    public void bilin() {
        double x, y, a00, a01, a10, a11, z;
        int i, j, k, ig, jg, ifg, jfg,il,jl;
        int ndgrid = ngpoints-1;

        for (ig = 0; ig < ndgrid; ig++) {
            for (jg = 0; jg < ndgrid; jg++) {
                a00 = zgdat[ig][jg];
                a01 = zgdat[ig][jg + 1] - zgdat[ig][jg];
                a10 = zgdat[ig + 1][jg] - zgdat[ig][jg];
                a11 = zgdat[ig + 1][jg + 1] + zgdat[ig][jg] - zgdat[ig + 1][jg] - zgdat[ig][jg + 1];




                il=(ig==ndgrid-1 ? 51:50);
                jl=(jg==ndgrid-1 ? 51:50);

                for (ifg = 0; ifg < il; ifg++) {
                    for (jfg = 0; jfg < jl; jfg++) {

                        i = ifg + ig * 50;
                        j = jfg + jg * 50;

                        x = ifg * 0.02;
                        y = jfg * 0.02;

                        z = a00 + a10 * x + a01 * y + a11 * x * y;


                        xfgdat[i][j] = ig + x;
                        yfgdat[i][j] = jg + y;
                        zfgdat[i][j] = z;




                    }
                }

            }
        }


    }

    void copyrow(int row, int ncols) {
        int j;
        for (j = 0; j < ncols; j++) {
            work[j] = zfgdat[j][row];
        }
    }

    void copycol(int col, int nrows) {
        int j;
        for (j = 0; j < nrows; j++) {
            work[j] = zfgdat[col][j];
        }
    }

    void storerow(int row, int ncols) {
        int j;
        for (j = 0; j < ncols; j++) {
            zfgdat[j][row] = work[j];
        }
    }

    void storecol(int col, int nrows) {
        int j;
        for (j = 0; j < nrows; j++) {
            zfgdat[col][j] = work[j];
        }
    }

    void spline() {
        int i;



        /*Berechne h,lambda,mu,d*/


        {
            for (i = 1; i < ngpoints; i++) {
                h[i] = xgdat[i] - xgdat[i - 1];
            }
        }




        for (i = 1; i < ngpoints - 1; i++) {
            lam[i] = h[i + 1] / (h[i] + h[i + 1]);
            mu[i] = 1.0 - lam[i];
        }
        for (i = 1; i < ngpoints - 1; i++) {
            d[i] = (work[i + 1] - work[i]) / h[i + 1] - (work[i] - work[i - 1]) / h[i];
            d[i] = d[i] * 6.0 / (h[i] + h[i + 1]);
        }

        /* Randwerte fuer Fall (a) s''(0)=s''(n)=0  */

        d[0] = 0.0;
        lam[0] = 0.0;
        mu[0] = 1.0;


        /*Berechne M=s''(i) */

        q[0] = -lam[0] * 0.5;
        u[0] = d[0] * 0.5;

        for (i = 1; i < ngpoints; i++) {
            p[i] = mu[i] * q[i - 1] + 2.0;
            q[i] = -(lam[i] / p[i]);
            u[i] = (d[i] - mu[i] * u[i - 1]) / p[i];
        }
        m[ngpoints - 1] = u[ngpoints - 1];

        for (i = ngpoints - 2; i >= 0; i--) {
            m[i] = q[i] * m[i + 1] + u[i];
        }


        /*Berechne Splinekoeffizienten*/



        for (i = 0; i < ngpoints - 1; i++) {
            coeff[i][0] = work[i];
            coeff[i][2] = m[i] * 0.5;
            coeff[i][1] = (work[i + 1] - work[i]) / h[i + 1] - h[i + 1] * (2.0 * m[i] + m[i + 1]) / 6.0;
            coeff[i][3] = (m[i + 1] - m[i]) / (6.0 * h[i + 1]);


        }


    }

    void interpolate() {
        int i, j, index, jl;
        double z, hij, sp;


        index = 0;
        for (i = 0; i < ngpoints - 1; i++) {
            hij = xgdat[i + 1] - xgdat[i];
            jl = ( i == (ngpoints-2) ? 51 : 50 );

            for (j = 0; j < jl; j++) {

                z = hij * j * 0.02; /* = x -x[i] */
                sp = coeff[i][3] * z;
                sp = (sp + coeff[i][2]) * z;
                sp = (sp + coeff[i][1]) * z;
                sp += coeff[i][0];
                work[index] = sp;
                index++;
            //  printf("    %lf    %lf  \n",x[i]+z,y[index]);
            }
        }


    }

    void bispline() {
        int i,j,ig,jg,ifg,jfg;
        int ndgrid = ngpoints-1;
        double x,y;
        
        for(i=0;i<ngpoints;i++)for(j=0;j<ngpoints;j++)
        {
        zfgdat[i][j]=zgdat[i][j];
        }

        for (i = 0; i < 3; i++) {
            copyrow(i, 3);
            spline();
            interpolate();
            storerow(i, 101);
        }



        for (i = 0; i < 101; i++) {
            copycol(i, 3);
            spline();
            interpolate();
            storecol(i, 101);
        }


          for (ig = 0; ig < ndgrid; ig++) {
            for (jg = 0; jg < ndgrid; jg++) {

                for (ifg = 0; ifg < 50; ifg++) {
                    for (jfg = 0; jfg < 50; jfg++) {

                        i = ifg + ig * 50;
                        j = jfg + jg * 50;

                        x = ifg * 0.02;
                        y = jfg * 0.02;



                        xfgdat[i][j] = ig + x;
                        yfgdat[i][j] = jg + y;





                    }
                }

            }
        }

    }

    public class myPanel extends javax.swing.JPanel {

        int i, ix, iy, ix0, iy0, ix1, iy1, ix2, iy2, ix3, iy3;

        public void paintComponent(Graphics g) {

            super.paintComponent(g);

            

            minmax();
            //minmaxp();

            for (i = 0; i < npoints; i++) {
                ix = xtrans(xdat[i], ydat[i], zdat[i]);
                iy = ytrans(xdat[i], ydat[i], zdat[i]);

                g.fillOval(ix - 7, iy - 7, 15, 15);
            }


            g.setColor(Color.black);

            for (iy = 0; iy < ndraw; iy += 5) {
                for (ix = 0; ix < ndraw - 1; ix++) {

                    ix0 = xtrans(xfgdat[ix][iy], yfgdat[ix][iy], zfgdat[ix][iy]);
                    iy0 = ytrans(xfgdat[ix][iy], yfgdat[ix][iy], zfgdat[ix][iy]);

                    ix1 = xtrans(xfgdat[ix + 1][iy], yfgdat[ix + 1][iy], zfgdat[ix + 1][iy]);
                    iy1 = ytrans(xfgdat[ix + 1][iy], yfgdat[ix + 1][iy], zfgdat[ix + 1][iy]);


                    g.drawLine(ix0, iy0, ix1, iy1);

                }

            }
            for (iy = 0; iy < ndraw - 1; iy++) {
                for (ix = 0; ix < ndraw; ix += 5) {


                    ix0 = xtrans(xfgdat[ix][iy], yfgdat[ix][iy], zfgdat[ix][iy]);
                    iy0 = ytrans(xfgdat[ix][iy], yfgdat[ix][iy], zfgdat[ix][iy]);

                    ix1 = xtrans(xfgdat[ix][iy + 1], yfgdat[ix][iy + 1], zfgdat[ix][iy + 1]);
                    iy1 = ytrans(xfgdat[ix][iy + 1], yfgdat[ix][iy + 1], zfgdat[ix][iy + 1]);


                    g.drawLine(ix0, iy0, ix1, iy1);

                }

            }




            for (i = 0; i < ndraw; i++) {
            }
            g.setColor(Color.red);
            ix0 = xtrans(0, 0, 0);
            iy0 = ytrans(0, 0, 0);

            // 2,0,0

            ix1 = xtrans(2, 0, 0);
            iy1 = ytrans(2, 0, 0);
            g.drawLine(ix0, iy0, ix1, iy1);
            g.drawString("x", ix1 + 10, iy1 + 10);

            // 0,2,0

            ix2 = xtrans(0, 2, 0);
            iy2 = ytrans(0, 2, 0);

            g.drawLine(ix0, iy0, ix2, iy2);
            g.drawString("y", ix2 + 10, iy2 + 10);

            // 0,0,1

            ix3 = xtrans(0, 0, 1);
            iy3 = ytrans(0, 0, 1);

            g.drawLine(ix0, iy0, ix3, iy3);
            g.drawString("z", ix3 + 10, iy3 + 10);
        //g.drawPolyline(ixp, iyp, ndraw);





        }
    }
}
