/*
 * NewJApplet.java
 *
 * Created on January 23, 2008, 10:25 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet
        implements ActionListener {

    Timer timer;
    double r_value, x_zero, x_fix, r_min, r_max, ljap;
    int n_r, max_it, count;
    BufferedImage image;
    Graphics2D gb;
    double x, y, x1, y1;
    double window_w = 400.0;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        timer = new Timer(1, this);
        timer.setInitialDelay(1);
        timer.start();


        image =
                new BufferedImage(400, 600, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 400, 600);

        r_min = 0.01;
        r_max = 3.99;
        x_zero = 0.01;
        jTextField1.setText("" + r_min);
        jTextField3.setText("" + r_max);
        jTextField2.setText("" + x_zero);
        max_it = 1000;
        count = 0;
        n_r = 1000;
    }

    public void actionPerformed(ActionEvent e) {

        if (count >= n_r) {
            return;
        }
        iterate();
        jPanel1.repaint();
        timer.restart();

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jTextField1 = new javax.swing.JTextField();
        jTextField3 = new javax.swing.JTextField();
        jLabel2 = new javax.swing.JLabel();
        jTextField2 = new javax.swing.JTextField();
        jButton1 = new javax.swing.JButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setDoubleBuffered(false);
        jPanel1.setMaximumSize(new java.awt.Dimension(400, 600));
        jPanel1.setMinimumSize(new java.awt.Dimension(400, 600));
        jPanel1.setPreferredSize(new java.awt.Dimension(400, 600));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 398, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 598, Short.MAX_VALUE)
        );

        jLabel1.setText("min r ");

        jLabel3.setText("max r");

        jTextField1.setText("jTextField1");
        jTextField1.setMaximumSize(new java.awt.Dimension(100, 22));
        jTextField1.setMinimumSize(new java.awt.Dimension(100, 22));
        jTextField1.setPreferredSize(new java.awt.Dimension(100, 22));

        jTextField3.setText("jTextField3");

        jLabel2.setText("x0");

        jTextField2.setText("jTextField2");

        jButton1.setText("Start");
        jButton1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jButton1MouseClicked(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jTextField1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 99, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextField3))
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 18, Short.MAX_VALUE)
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jLabel1)
                                    .addComponent(jLabel3))
                                .addGap(132, 132, 132))
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addGap(18, 18, 18)
                                .addComponent(jLabel2)
                                .addContainerGap())))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addComponent(jButton1, javax.swing.GroupLayout.PREFERRED_SIZE, 73, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap(211, Short.MAX_VALUE))))
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(50, 50, 50)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel3))
                .addGap(18, 18, 18)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 22, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2))
                .addGap(76, 76, 76)
                .addComponent(jButton1)
                .addContainerGap(358, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(38, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jButton1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jButton1MouseClicked
        r_min = Double.parseDouble(jTextField1.getText());
        x_zero = Double.parseDouble(jTextField2.getText());
        r_max = Double.parseDouble(jTextField3.getText());
        count = 0;
         gb.clearRect(0, 0, 400, 600);
        jPanel1.repaint();
        timer.restart();
    }//GEN-LAST:event_jButton1MouseClicked
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    private javax.swing.JTextField jTextField3;
    // End of variables declaration//GEN-END:variables

    public void iterate() {
        int i, ix, iy;
        int n_settle = 1000;
        Graphics g;
        
        g=jPanel1.getGraphics();

        r_value = r_min + count * (r_max - r_min) / n_r;
        x = x_zero;


        count++;
         ljap=0;
        iy = 0;


        // make some iterations to settle the orbit

        for (i = 0; i < n_settle; i++) {
            x = fun(x);

        }

        iy = (int) (window_w * (r_value - r_min) / (r_max - r_min));

        for (i = 0; i < max_it; i++) {
            x = fun(x);
            ix = (int) (x * window_w);
           

            gb.setColor(Color.red);
            gb.drawOval(iy, ix, 1, 1);

            ljap += funder(x);


        }
       
        ix = (int) (-ljap * 50 / max_it + 500);
        gb.setColor(Color.blue);
        gb.drawOval(iy, ix, 2, 2);
        
        //g.drawImage(image, 0, 0, null);
        
    }

    double fun(double x) {
        double y;
        y = r_value * (x - x * x);
        return (y);
    }

    double funder(double x) {
        double dy;
        dy = r_value * (1.0 - 2.0 * x);
        dy = Math.abs(dy);
        dy = Math.log(dy);
        return (dy);
    }

    void initialize() {
        x1 = x_zero;
        y1 = fun(x1);
        ljap = 0.0;
    }

    public class myPanel extends javax.swing.JPanel {

        int ix, iy, ix1, iy1, ix2, iy2, i2, i, ixo, iyo;

        public void paintComponent(Graphics g) {
            int ic;




            //super.paintComponent(g);


              g.drawImage(image, 0, 0, null);



            {


                g.setColor(Color.GRAY);
                g.drawLine(0, 500, (int) window_w, 500);
                //g.drawLine(0, 500-50, (int)window_w, 500-50);
                g.drawString("0", 50, 500);
                //g.drawString("1",50,450);


                for (i = 0; i < 11; i++) {
                    iy = (int) (window_w * (0.5 * i - r_min) / (r_max - r_min));
                    g.drawLine(iy, 0, iy, 500);
                    g.drawString("" + i * 0.5, iy, 50);
                }


            }

            g.drawString(" r ",380,20);
            g.setColor(Color.BLUE);
            g.drawString("exponent", 50, 550);
        }
    }
}

