/*
 * NewJApplet.java
 *
 * Created on October 27, 2008, 9:11 AM
 */
package normvert;

import javax.swing.SwingUtilities;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.BorderFactory;
import java.awt.Color;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet implements ActionListener {

    Timer timer;
    int[] histo;
    int[] cumulative;
    int naver, nshots, maxshots, keep_shooting;
    double xav, x2av;
    DecimalFormat df, df2;
    int gaussian = 1;

    public void actionPerformed(ActionEvent e) {

        int i;
        double s, xs, x2s;

        //xs=0;
        //s=0;

        if (nshots == maxshots) {
            keep_shooting = 0;
        }

        if (keep_shooting == 1) {
            if (nshots < maxshots) {
                for (i = 0; i < 10; i++) {
                    shoot();
                    nshots++;
                }
            }

            xs = xav / nshots;
            x2s = x2av / nshots;
            s = Math.sqrt(x2s - xs * xs);


            jPanel1.repaint();
            jLabel1.setText("average:" + df.format(xs));
            jLabel2.setText("sigma :" + df.format(s));
            timer.restart();
        }
    }

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                    init_variables();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jSlider1 = new javax.swing.JSlider();
        jButton1 = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setMaximumSize(new java.awt.Dimension(300, 300));
        jPanel1.setMinimumSize(new java.awt.Dimension(300, 300));
        jPanel1.setPreferredSize(new java.awt.Dimension(300, 300));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 531, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 298, Short.MAX_VALUE)
        );

        jSlider1.setMajorTickSpacing(10);
        jSlider1.setMinorTickSpacing(5);
        jSlider1.setPaintTicks(true);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jButton1.setText("start/stop");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jLabel1.setText("average");
        jLabel1.setMaximumSize(new java.awt.Dimension(150, 15));
        jLabel1.setMinimumSize(new java.awt.Dimension(150, 15));
        jLabel1.setPreferredSize(new java.awt.Dimension(150, 15));

        jLabel2.setText("sigma");
        jLabel2.setMaximumSize(new java.awt.Dimension(100, 15));
        jLabel2.setMinimumSize(new java.awt.Dimension(100, 15));
        jLabel2.setPreferredSize(new java.awt.Dimension(100, 15));

        jLabel3.setText("jLabel3");

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("Gaussian");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("Coin");
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(54, 54, 54)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(45, 45, 45)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addComponent(jRadioButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                    .addComponent(jButton1)
                                    .addComponent(jRadioButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(27, 27, 27)
                                .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, 249, javax.swing.GroupLayout.PREFERRED_SIZE))))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(137, 137, 137)
                        .addComponent(jLabel3))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 533, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap(82, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jRadioButton1, jRadioButton2});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(51, 51, 51)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(25, 25, 25)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel3)
                    .addComponent(jButton1))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jRadioButton1))
                .addGap(1, 1, 1)
                .addComponent(jRadioButton2)
                .addGap(4, 4, 4)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(34, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        int i;
        if(keep_shooting==1)keep_shooting=0;
        else{
        nshots = 0;
        for (i = 0; i < 200; i++) {
            histo[i] = 0; cumulative[i]=0;
        }
        xav = 0;
        x2av = 0;
        keep_shooting = 1;
        }
// TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        int i;
        naver = jSlider1.getValue();

        if (naver == 0) {
            naver = 1;
        }
        jLabel3.setText("average over:" + naver);
        nshots = 0;
        //xav = 0;
        //x2av = 0;
        //for (i = 0; i < 200; i++) {
        //    histo[i] = 0;
        //}
        maxshots = (int) (10000 * Math.sqrt(1.0 / naver));
        keep_shooting = 0;
    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
    gaussian = 1;// TODO add your handling code here:
}//GEN-LAST:event_jRadioButton1ActionPerformed

private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
    gaussian = 0;// TODO add your handling code here:
}//GEN-LAST:event_jRadioButton2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JSlider jSlider1;
    // End of variables declaration//GEN-END:variables

    public void init_variables() {
        int i;
        histo = new int[200];
        cumulative=new int[200];
        timer = new Timer(1, this);
        timer.setInitialDelay(1);
        timer.start();
        naver = 1;
        for (i = 0; i < 200; i++) {
            histo[i] = 0;
            cumulative[i]=0;
        }
        xav = 0;
        x2av = 0;
        DecimalFormatSymbols unusualSymbols =
                new DecimalFormatSymbols();

        unusualSymbols.setDecimalSeparator('.');

        df = new DecimalFormat("##0.00000", unusualSymbols);
        df2 = new DecimalFormat("##0.00", unusualSymbols);

        maxshots = 10000;
        keep_shooting = 0;
        jSlider1.setValue(0);
        jLabel3.setText("average over:" + naver);
    }

    public double randgauss() {
        double x, r, phi, rho;

        r = Math.random();
        phi = 2.0 * Math.PI * r;

        r = Math.random();
        rho = Math.sqrt(-Math.log(1 - r));

        x = rho * Math.cos(phi) * Math.sqrt(2.0);

        return x;
    }

    public double randcoin() {
        double r, x;
        r = Math.random();
        if (r > 0.5) {
            x = 1;
        } else {
            x = -1;
        }
        return x;
    }

    public void shoot() {
        int i,ic, index;
        double r, rav;

        rav = 0;

        if (gaussian == 1) {
            for (i = 0; i < naver; i++) {
                r = randgauss();
                rav += r;

            }
        } else {
            for (i = 0; i < naver; i++) {
                r = randcoin();
                rav += r;

            }
        }


        rav = rav / naver;

        xav += rav;
        x2av += rav * rav;

        index = (int) ((rav + 3.0) * 33.0);

        if ((index >= 0) && (index < 200)) {
            histo[index]++;
            for(ic=index;ic<200;ic++) cumulative[ic]++;
        }


    }

    class myPanel extends javax.swing.JPanel { 
        
        

        int i;

        public void paintComponent(Graphics g) {

            super.paintComponent(g);
            g.drawString("-2", 33+45, 280);  
            g.drawString("-1", 66+45, 280);
            g.drawString("0", 99+45,280);
            g.drawString("1",132+45,280);
            g.drawString("2", 165+45, 280);
            
            
            g.drawString("-2", 33+295, 280);  
            g.drawString("-1", 66+295, 280);
            g.drawString("0", 99+295,280);
            g.drawString("1",132+295,280);
            g.drawString("2", 165+295, 280);
            
            
            g.drawString("Histogram",70,20);
            
            g.drawString("Cumulative distribution",350,20);
            
            g.drawLine(300,250,500,250);
            
            
            
            for (i = 0; i < 200; i++) {
                g.drawLine(i + 50, 250, i + 50, 250 - histo[i]);
            }
            
            
            if(nshots>1)
            for (i = 0; i < 199; i++) {
                g.drawLine(i + 300, 250-cumulative[i]*150/nshots, i + 301, 250 - cumulative[i+1]*150/nshots);
            }

        }
    }
}
