/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;


/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet {
    
    double [] RealC,ImagC,RealC2,ImagC2,RealC3,ImagC3,RealC4,ImagC4;
    double [] RealF1,ImagF1,RealF2,ImagF2,RealF3,ImagF3,RealF4,ImagF4;
    int nstates=2;
    double V=0.4;
    double DeltaE=10.0;
    double tstep=0.001;
    double velo=0.3;
    double LZProb;
    DecimalFormat df,df2;
    
    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {
                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        
        RealC = new double[nstates];
        ImagC = new double[nstates];
        RealC2 = new double[nstates];
        ImagC2 = new double[nstates];
        RealC3 = new double[nstates];
        ImagC3 = new double[nstates];        
        RealC4 = new double[nstates];
        ImagC4 = new double[nstates];
        RealF1 = new double[nstates];
        ImagF1 = new double[nstates];        
        RealF2 = new double[nstates];
        ImagF2 = new double[nstates];
        RealF3 = new double[nstates];
        ImagF3 = new double[nstates];        
        RealF4 = new double[nstates];
        ImagF4 = new double[nstates];
        
        df= new DecimalFormat("##0.0");
        df2= new DecimalFormat("##0.000");
        VS.setValue((int)(V*20.0));
        DES.setValue((int)(DeltaE*20.0));
        veloS.setValue((int)(velo*20.0));
        VL.setText("V="+df.format(V));
        DEL.setText("Energy gap="+df.format(DeltaE));
        
        veloL.setText("velocity="+df.format(velo));
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        VS = new javax.swing.JSlider();
        DES = new javax.swing.JSlider();
        veloL = new javax.swing.JLabel();
        DEL = new javax.swing.JLabel();
        veloS = new javax.swing.JSlider();
        VL = new javax.swing.JLabel();
        DEL1 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 420, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 365, Short.MAX_VALUE)
        );

        VS.setMaximum(60);
        VS.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                VSMouseDragged(evt);
            }
        });

        DES.setMaximum(1200);
        DES.setValue(200);
        DES.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                DESMouseDragged(evt);
            }
        });

        veloL.setText("velocity");

        DEL.setText("-DeltaE (t=0) ");

        veloS.setMaximum(60);
        veloS.setMinimum(1);
        veloS.setValue(30);
        veloS.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                veloSMouseDragged(evt);
            }
        });

        VL.setText("V          ");

        DEL1.setText("-DeltaE (t=0) ");

        jLabel1.setText("blue = occupation of initial state   red = occupation of final state");

        jLabel2.setText("jLabel2");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(veloS, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(46, 46, 46)
                                .addComponent(VL))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(51, 51, 51)
                                .addComponent(veloL))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(DEL))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(DEL1)))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addComponent(jLabel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(60, 60, 60)
                        .addComponent(veloL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(veloS, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(30, 30, 30)
                        .addComponent(VL)
                        .addGap(18, 18, 18)
                        .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(107, 107, 107)
                        .addComponent(DEL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(DEL1)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel2)
                .addContainerGap(65, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void VSMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_VSMouseDragged
        // TODO add your handling code here:
        V=VS.getValue()*0.05;
        VL.setText("V="+df.format(V));        
        jPanel1.repaint();
}//GEN-LAST:event_VSMouseDragged

    private void DESMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_DESMouseDragged

         DeltaE=DES.getValue()*0.05;
         DEL.setText("Energy gap="+df.format(DeltaE));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_DESMouseDragged

    private void veloSMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_veloSMouseDragged
        velo=veloS.getValue()*0.05;
         veloL.setText("velocity="+df.format(velo));
         jPanel1.repaint();
        // TODO add your handling code here:
}//GEN-LAST:event_veloSMouseDragged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel DEL;
    private javax.swing.JLabel DEL1;
    private javax.swing.JSlider DES;
    private javax.swing.JLabel VL;
    private javax.swing.JSlider VS;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel veloL;
    private javax.swing.JSlider veloS;
    // End of variables declaration//GEN-END:variables
    
    void grad(double[]RC,double[]IC,double[]RF,double[]IF,double t)
    {   double DEt;
        
        DEt=-DeltaE+velo*t;
    
        RF[0]=V*IC[1];
        IF[0]=-V*RC[1];
        RF[1]=V*IC[0]+DEt*IC[1];
        IF[1]=-V*RC[0]-DEt*RC[1];
    
    
    }
    
    void advance(double[]RC,double[]IC,double[]RF,double[]IF,
                 double[]RC1,double[]IC1,double step)
    { int i;
    
      for(i=0;i<nstates;i++)
      {
      RC1[i]=RC[i]+RF[i]*step;
      IC1[i]=IC[i]+IF[i]*step;
      
      }
    
    }
    
    
    void rk4(double t)
    { int i;
    grad(RealC,ImagC,RealF1,ImagF1,t);
    advance(RealC,ImagC,RealF1,ImagF1,RealC2,ImagC2,tstep*0.5);
    grad(RealC2,ImagC2,RealF2,ImagF2,t+tstep*0.5);
    advance(RealC,ImagC,RealF2,ImagF2,RealC3,ImagC3,tstep*0.5);
    grad(RealC3,ImagC3,RealF3,ImagF3,t+tstep*0.5);
    advance(RealC,ImagC,RealF3,ImagF3,RealC4,ImagC4,tstep);
    grad(RealC4,ImagC4,RealF4,ImagF4,t+tstep);
    
    for(i=0;i<nstates;i++)
    {
    
    RealC[i]=RealC[i]+tstep*(RealF1[i]+2.0*RealF2[i]+2.0*RealF3[i]+RealF4[i])/6.0;
    ImagC[i]=ImagC[i]+tstep*(ImagF1[i]+2.0*ImagF2[i]+2.0*ImagF3[i]+ImagF4[i])/6.0;
    
    }
    
    }
    
    
    double LZ_app()
    {
    double e,r;
    double hbar=8.582E-4;
    
    e=2*Math.PI*V*V/velo;
   
    return 1-Math.exp(-e);
    
   
    
    }
    
    public class myPanel extends javax.swing.JPanel{
       
    int iy0,iy1,i,ix0,ix1,i1;
    void iterate()
    {
      
    }
 
    public void paintComponent(Graphics g)
{   double t;     
    
     super.paintComponent(g);  
     
     LZProb=LZ_app();
     jLabel2.setText("LZ probability= "+df2.format(LZProb));
     
     g.setColor(Color.red);
     iy0=(int)(LZProb*250);
     g.drawLine(0, 300-iy0, 400, 300-iy0);
     g.setColor(Color.blue);
     iy0=250-iy0;
     g.drawLine(0, 300-iy0, 400, 300-iy0);
     
     
     RealC[0]=1.0; ImagC[0]=0.0;
     RealC[1]=0.0; ImagC[1]=0.0;
     
     iy0=150;
     ix0=0;
     
     t=0.0;
     
     for (i=0;i<400;i++)
     {
     for(i1=0;i1<200;i1++)
     {t+=tstep;
     rk4(t);
     }
     g.setColor(Color.black);
     g.drawRect(0,50,400,250);
     
     iy1=(int) ( (RealC[0]*RealC[0]+ImagC[0]*ImagC[0])*250.0);
     ix1=(int) ( (RealC[1]*RealC[1]+ImagC[1]*ImagC[1])*250.0);
     
     g.setColor(Color.blue);
     g.drawLine(i, 300-iy0, i+1, 300-iy1);
     iy0=iy1;

     g.setColor(Color.red);
     g.drawLine(i, 300-ix0, i+1, 300-ix1);
     ix0=ix1;
     
     g.setColor(Color.black);
     g.drawString("time",200,320);
     
     
     
     }
     
}
     }
}
     
     
     
