/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;
import java.awt.Graphics2D;
import java.awt.geom.*;




/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet {
    
    double [] RealC,ImagC,RealC2,ImagC2,RealC3,ImagC3,RealC4,ImagC4;
    double [] RealF1,ImagF1,RealF2,ImagF2,RealF3,ImagF3,RealF4,ImagF4;
    int nstates=50;
    double V=0.01;
    double DeltaE=2.0;
    double tstep=0.002;
    double E0=0.0;
     double EN;
     int stepin=20;
     int scale=200;
    DecimalFormat df,df2;
    
    
     static float dash1[] = {5.0f};
     static BasicStroke dashed = new BasicStroke(1.0f, 
                                          BasicStroke.CAP_BUTT, 
                                          BasicStroke.JOIN_MITER, 
                                          10.0f, dash1, 0.0f);
        
    
    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {
                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        
        RealC = new double[nstates];
        ImagC = new double[nstates];
        RealC2 = new double[nstates];
        ImagC2 = new double[nstates];
        RealC3 = new double[nstates];
        ImagC3 = new double[nstates];        
        RealC4 = new double[nstates];
        ImagC4 = new double[nstates];
        RealF1 = new double[nstates];
        ImagF1 = new double[nstates];        
        RealF2 = new double[nstates];
        ImagF2 = new double[nstates];
        RealF3 = new double[nstates];
        ImagF3 = new double[nstates];        
        RealF4 = new double[nstates];
        ImagF4 = new double[nstates];
        
        df= new DecimalFormat("##0.0000");
        df2= new DecimalFormat("0.0");
        VS.setValue((int)(V*2000.0));
        DES.setValue((int)(DeltaE*20.0));
        E0S.setValue((int)(E0*40.0));
        scales.setValue(scale);
        tims.setValue(stepin);
        
        VL.setText("V="+df.format(V));
        DEL.setText("Energy gap="+df.format(DeltaE));
        
        E0L.setText("E0="+df.format(E0));
        timl.setText("steps="+stepin);
        scalel.setText("scale="+scale);
        
      
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jLabel1 = new javax.swing.JLabel();
        VS = new javax.swing.JSlider();
        DES = new javax.swing.JSlider();
        E0L = new javax.swing.JLabel();
        timl = new javax.swing.JLabel();
        E0S = new javax.swing.JSlider();
        VL = new javax.swing.JLabel();
        tims = new javax.swing.JSlider();
        DEL = new javax.swing.JLabel();
        scales = new javax.swing.JSlider();
        scalel = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();

        jLabel1.setText("occupation of initial state");

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 296, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(150, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel1Layout.createSequentialGroup()
                .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 15, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(0, 349, Short.MAX_VALUE))
        );

        VS.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                VSMouseDragged(evt);
            }
        });

        DES.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                DESMouseDragged(evt);
            }
        });

        E0L.setText("E0");

        timl.setText("timescale");

        E0S.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                E0SMouseDragged(evt);
            }
        });

        VL.setText("V          ");

        tims.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                timsMouseDragged(evt);
            }
        });

        DEL.setText("DeltaE ");

        scales.setMaximum(200);
        scales.setMinimum(20);
        scales.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                scalesMouseDragged(evt);
            }
        });

        scalel.setText("scale");

        jLabel2.setText("time");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(404, 404, 404)
                        .addComponent(jLabel2))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(E0S, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(tims, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(scales, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(46, 46, 46)
                        .addComponent(VL))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(51, 51, 51)
                        .addComponent(E0L))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(37, 37, 37)
                        .addComponent(DEL))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(37, 37, 37)
                        .addComponent(timl))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(38, 38, 38)
                        .addComponent(scalel)))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(60, 60, 60)
                        .addComponent(E0L)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(E0S, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(30, 30, 30)
                        .addComponent(VL)
                        .addGap(18, 18, 18)
                        .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(48, 48, 48)
                        .addComponent(DEL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(27, 27, 27)
                        .addComponent(timl)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(tims, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(scalel)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(scales, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(21, 21, 21)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jLabel2)
                .addContainerGap(84, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void VSMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_VSMouseDragged
        // TODO add your handling code here:
        V=VS.getValue()*0.0005;
        VL.setText("V="+df.format(V));        
        jPanel1.repaint();
}//GEN-LAST:event_VSMouseDragged

    private void DESMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_DESMouseDragged

         DeltaE=DES.getValue()*0.05;
         DEL.setText("Energy gap="+df.format(DeltaE));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_DESMouseDragged

    private void E0SMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_E0SMouseDragged
        E0=E0S.getValue()*0.025;
         E0L.setText("E0="+df.format(E0));
         jPanel1.repaint();
        // TODO add your handling code here:
}//GEN-LAST:event_E0SMouseDragged

    private void timsMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_timsMouseDragged
        stepin=tims.getValue();
        timl.setText("steps="+stepin);
        jPanel1.repaint();
        
        // TODO add your handling code here:
}//GEN-LAST:event_timsMouseDragged

    private void scalesMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_scalesMouseDragged
        scale=scales.getValue();
        scalel.setText("scale="+scale);
        jPanel1.repaint(); // TODO add your handling code here:
}//GEN-LAST:event_scalesMouseDragged
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel DEL;
    private javax.swing.JSlider DES;
    private javax.swing.JLabel E0L;
    private javax.swing.JSlider E0S;
    private javax.swing.JLabel VL;
    private javax.swing.JSlider VS;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel scalel;
    private javax.swing.JSlider scales;
    private javax.swing.JLabel timl;
    private javax.swing.JSlider tims;
    // End of variables declaration//GEN-END:variables
    
    void grad(double[]RC,double[]IC,double[]RF,double[]IF,double t)
    {  
        int i;
        
      
    
        RF[0]=E0*IC[0]; IF[0]=-E0*RC[0];
        
        for(i=1;i<nstates;i++) {RF[0]+=V*IC[i]; IF[0]-=V*RC[i];}
        
         for(i=1;i<nstates;i++) 
         {     
        EN=((i-nstates/2)*DeltaE)/nstates;
        
        RF[i]=V*IC[0]+EN*IC[i];
        IF[i]=-V*RC[0]-EN*RC[i];
         }
    
    }
    
    void advance(double[]RC,double[]IC,double[]RF,double[]IF,
                 double[]RC1,double[]IC1,double step)
    { int i;
    
      for(i=0;i<nstates;i++)
      {
      RC1[i]=RC[i]+RF[i]*step;
      IC1[i]=IC[i]+IF[i]*step;
      
      }
    
    }
    
    
    void rk4(double t)
    { int i;
    grad(RealC,ImagC,RealF1,ImagF1,t);
    advance(RealC,ImagC,RealF1,ImagF1,RealC2,ImagC2,tstep*0.5);
    grad(RealC2,ImagC2,RealF2,ImagF2,t+tstep*0.5);
    advance(RealC,ImagC,RealF2,ImagF2,RealC3,ImagC3,tstep*0.5);
    grad(RealC3,ImagC3,RealF3,ImagF3,t+tstep*0.5);
    advance(RealC,ImagC,RealF3,ImagF3,RealC4,ImagC4,tstep);
    grad(RealC4,ImagC4,RealF4,ImagF4,t+tstep);
    
    for(i=0;i<nstates;i++)
    {
    
    RealC[i]=RealC[i]+tstep*(RealF1[i]+2.0*RealF2[i]+2.0*RealF3[i]+RealF4[i])/6.0;
    ImagC[i]=ImagC[i]+tstep*(ImagF1[i]+2.0*ImagF2[i]+2.0*ImagF3[i]+ImagF4[i])/6.0;
    
    }
    
    }
    
    public class myPanel extends javax.swing.JPanel{
       
    int iy0,iy1,i,ix0,ix1,i1;
    void iterate()
    {
      
    }
 
    public void paintComponent(Graphics g)
{   double t,tt;     int iy2,itick;
     Graphics2D g2=(Graphics2D) g;
      
     super.paintComponent(g);  
     
     RealC[0]=1.0; ImagC[0]=0.0;
     for(i=1;i<nstates;i++){RealC[i]=0.0; ImagC[i]=0.0;}
     
     iy0=0;
     ix0=0;
     
     t=0.0;
     g.setColor(Color.black);
     g.drawRect(0,50,400,300);
     g.setColor(Color.gray);
     g2.setStroke(dashed);    
     
     for(itick=1;itick<10;itick++){iy2=50-(int)(Math.log(itick*0.1)*scale);
      if(iy2<350) {g2.draw(new Line2D.Double(0, iy2, 400, iy2)); 
     }
     }
     for(itick=1;itick<10;itick++){iy2=50-(int)(Math.log(itick*0.01)*scale);
      if(iy2<350) {g2.draw(new Line2D.Double(0, iy2, 400, iy2));  }
     }
     
      for(itick=1;itick<10;itick++){iy2=50-(int)(Math.log(itick*0.001)*scale);
      if(iy2<350) {g2.draw(new Line2D.Double(0, iy2, 400, iy2));  }
     }
     
      for(itick=1;itick<10;itick++){iy2=50-(int)(Math.log(itick*0.0001)*scale);
      if(iy2<350) {g2.draw(new Line2D.Double(0, iy2, 400, iy2));  }
     }
     
      for(itick=1;itick<10;itick++){iy2=50-(int)(Math.log(itick*0.00001)*scale);
      if(iy2<350) {g2.draw(new Line2D.Double(0, iy2, 400, iy2));  }
     }
     
      for(itick=0;itick<10;itick++){iy2=itick*50;
      if(iy2<400) {g2.draw(new Line2D.Double(iy2, 50, iy2, 350));  
     
     }}
      g2.setColor(Color.black); 
      g2.drawString("1.0",400,50);
      iy2=50-(int)(Math.log(0.1)*scale);
     if(iy2<350)  g2.drawString("0.1",400,iy2);
      iy2=50-(int)(Math.log(0.01)*scale);
      if(iy2<350) g2.drawString("0.01",400,iy2);
       iy2=50-(int)(Math.log(0.001)*scale);
      if(iy2<350) g2.drawString("0.001",400,iy2);
      iy2=50-(int)(Math.log(0.0001)*scale);
      if(iy2<350) g2.drawString("0.0001",400,iy2);
       iy2=50-(int)(Math.log(0.00001)*scale);
      if(iy2<350) g2.drawString("0.00001",400,iy2);
      
      iy2=50-(int)(Math.log(0.2)*scale);
       if(iy2<350) g2.drawString("0.2",400,iy2);
      iy2=50-(int)(Math.log(0.02)*scale);
      if(iy2<350) g2.drawString("0.02",400,iy2);
       iy2=50-(int)(Math.log(0.002)*scale);
     if(iy2<350)  g2.drawString("0.002",400,iy2);
      iy2=50-(int)(Math.log(0.0002)*scale);
     if(iy2<350)  g2.drawString("0.0002",400,iy2);
       iy2=50-(int)(Math.log(0.00002)*scale);
      if(iy2<350) g2.drawString("0.00002",400,iy2);
        iy2=50-(int)(Math.log(0.5)*scale);
       if(iy2<350) g2.drawString("0.5",400,iy2);
      iy2=50-(int)(Math.log(0.05)*scale);
      if(iy2<350) g2.drawString("0.05",400,iy2);
       iy2=50-(int)(Math.log(0.005)*scale);
      if(iy2<350) g2.drawString("0.005",400,iy2);
      iy2=50-(int)(Math.log(0.0005)*scale);
      if(iy2<350) g2.drawString("0.0005",400,iy2);
       iy2=50-(int)(Math.log(0.00005)*scale);
      if(iy2<350) g2.drawString("0.00005",400,iy2);
     for (i=0;i<400;i++)
     {
     for(i1=0;i1<stepin;i1++)
     {t+=tstep;
     rk4(t);
     }
     
     if ((i %100) ==0) g2.drawString(df2.format (t),i,360);
   

     
     iy1=(int) ( Math.log(RealC[0]*RealC[0]+ImagC[0]*ImagC[0])*scale);
    
     
     g.setColor(Color.blue);
     g.drawLine(i, 50-iy0, i+1, 50-iy1);
     iy0=iy1;
     
    
     

   
     
     g.setColor(Color.black); 
    
     
     
     
     }
     
}
     }
}
     
     
     
