/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;


/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet implements ActionListener {
    Timer timer;
    double [][] RealC,ImagC,RealC2,ImagC2,RealC3,ImagC3,RealC4,ImagC4;
    double [][] RealF1,ImagF1,RealF2,ImagF2,RealF3,ImagF3,RealF4,ImagF4;
    int nstates=2;
    int imeas=0;
    double V=0.2;
    double DeltaE=5.0;
    double tstep=0.002;
    double freq=0.0;
    double tp=10.0;
    double t1r=0.1;
    double t2pr=0.0;
    double t2r=0.1;
    double t0=10.0;
    double average=0.0;
    
    
    DecimalFormat df;
    
    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {
                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        timer = new Timer(1000, this);
        timer.setInitialDelay(100);
      
       
        RealC = new double[nstates][nstates];
        ImagC = new double[nstates][nstates];
        RealC2 = new double[nstates][nstates];
        ImagC2 = new double[nstates][nstates];
        RealC3 = new double[nstates][nstates];
        ImagC3 = new double[nstates][nstates];        
        RealC4 = new double[nstates][nstates];
        ImagC4 = new double[nstates][nstates];
        RealF1 = new double[nstates][nstates];
        ImagF1 = new double[nstates][nstates];        
        RealF2 = new double[nstates][nstates];
        ImagF2 = new double[nstates][nstates];
        RealF3 = new double[nstates][nstates];
        ImagF3 = new double[nstates][nstates];        
        RealF4 = new double[nstates][nstates];
        ImagF4 = new double[nstates][nstates];
        
        df= new DecimalFormat("##0.000");
        
        VS.setValue((int)(V*200.0));
        DES.setValue((int)(DeltaE*20.0));
      
       
        
        t2rslider.setValue((int)(t2r*50.0));
        
        
        VL.setText("V="+df.format(V));
        DEL.setText("Energy gap="+df.format(DeltaE));        
        freqL.setText("frequency="+df.format(freq));
       
        
        t2rlab.setText("1/t2="+df.format(t2r));
        
    }
     public void actionPerformed(ActionEvent e) {
           
          if(imeas >=200) {return;}
          jPanel1.repaint();
          timer.setInitialDelay(10);
          timer.restart();
          
      }
    
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        VS = new javax.swing.JSlider();
        DES = new javax.swing.JSlider();
        freqL = new javax.swing.JLabel();
        DEL = new javax.swing.JLabel();
        VL = new javax.swing.JLabel();
        t2rslider = new javax.swing.JSlider();
        t2rlab = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 420, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 597, Short.MAX_VALUE)
        );

        VS.setMaximum(200);
        VS.setToolTipText("magnitude of the coupling");
        VS.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                VSMouseDragged(evt);
            }
        });

        DES.setMaximum(200);
        DES.setToolTipText("energy gap of the two states");
        DES.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                DESMouseDragged(evt);
            }
        });

        freqL.setText("freq  ");

        DEL.setText("DeltaE ");

        VL.setText("V          ");

        t2rslider.setMaximum(200);
        t2rslider.setMinimum(20);
        t2rslider.setToolTipText("relaxation rate 1/t2");
        t2rslider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                t2rsliderMouseDragged(evt);
            }
        });

        t2rlab.setText("1/t2");

        jButton1.setText("Go");
        jButton1.setToolTipText("start new scan");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(t2rslider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addGap(46, 46, 46)
                                .addComponent(VL))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(40, 40, 40)
                                .addComponent(DEL))))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(55, 55, 55)
                        .addComponent(t2rlab))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(37, 37, 37)
                        .addComponent(jButton1))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(35, 35, 35)
                        .addComponent(freqL)))
                .addContainerGap(34, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(43, 43, 43)
                        .addComponent(freqL)
                        .addGap(65, 65, 65)
                        .addComponent(VL)
                        .addGap(18, 18, 18)
                        .addComponent(VS, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(46, 46, 46)
                        .addComponent(DEL)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(DES, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(62, 62, 62)
                        .addComponent(t2rlab)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(t2rslider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(52, 52, 52)
                        .addComponent(jButton1))
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void VSMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_VSMouseDragged
        // TODO add your handling code here:
        V=VS.getValue()*0.005;
        VL.setText("V="+df.format(V));        
 
}//GEN-LAST:event_VSMouseDragged

    private void DESMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_DESMouseDragged

         DeltaE=DES.getValue()*0.05;
         DEL.setText("Energy gap="+df.format(DeltaE));
        
}//GEN-LAST:event_DESMouseDragged

    private void t2rsliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_t2rsliderMouseDragged
        // TODO add your handling code here:
         t2r=t2rslider.getValue()*0.002; t1r=t2r;
         t2rlab.setText("1/t2="+df.format(t2r));
         
       
}//GEN-LAST:event_t2rsliderMouseDragged

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        // TODO add your handling code here:
          imeas=0;
          timer.start(); jPanel1.repaint();
    }//GEN-LAST:event_jButton1ActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel DEL;
    private javax.swing.JSlider DES;
    private javax.swing.JLabel VL;
    private javax.swing.JSlider VS;
    private javax.swing.JLabel freqL;
    private javax.swing.JButton jButton1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JLabel t2rlab;
    private javax.swing.JSlider t2rslider;
    // End of variables declaration//GEN-END:variables
    
   
    double pulse(double t)
    { double arg,fac;
      
      fac= Math.sin(freq*t);;
      if(t<10) fac=fac*(1.0-Math.exp(-t*0.5));
       
     return fac;
        
    }
    
    void grad(double[][]RC,double[][]IC,double[][]RF,double[][]IF,double t)
    {   double Vt,arg;
        
        
       
        
        Vt=V*pulse(t);
    
        RF[0][0]=Vt*(IC[1][0]-IC[0][1]) -t1r*(RC[0][0]-1.0);
        RF[1][1]=Vt*(IC[0][1]-IC[1][0]) -t1r*(RC[1][1]);
        
        RF[0][1]=Vt*(IC[1][1]-IC[0][0]) -DeltaE*IC[0][1] -t2r*RC[0][1];         
        RF[1][0]=Vt*(IC[0][0]-IC[1][1]) +DeltaE*IC[1][0] -t2r*RC[1][0];
        
        
        IF[0][0]=-Vt*(RC[1][0]-RC[0][1]) -t1r*IC[0][0];
        IF[1][1]=-Vt*(RC[0][1]-RC[1][0]) -t1r*IC[1][1];
        
        IF[0][1]=-Vt*(RC[1][1]-RC[0][0]) +DeltaE*RC[0][1] -t2r*IC[0][1];         
        IF[1][0]=-Vt*(RC[0][0]-RC[1][1]) -DeltaE*RC[1][0] -t2r*IC[1][0];
        
        
    
    
    }
    
    void advance(double[][]RC,double[][]IC,double[][]RF,double[][]IF,
                 double[][]RC1,double[][]IC1,double step)
    { int i,j;
    
      for(i=0;i<nstates;i++)for(j=0;j<nstates;j++)
      {
      RC1[i][j]=RC[i][j]+RF[i][j]*step;
      IC1[i][j]=IC[i][j]+IF[i][j]*step;
      
      }
    
    }
    
    
    void rk4(double t)
    { int i,j;
    grad(RealC,ImagC,RealF1,ImagF1,t);
    advance(RealC,ImagC,RealF1,ImagF1,RealC2,ImagC2,tstep*0.5);
    grad(RealC2,ImagC2,RealF2,ImagF2,t+tstep*0.5);
    advance(RealC,ImagC,RealF2,ImagF2,RealC3,ImagC3,tstep*0.5);
    grad(RealC3,ImagC3,RealF3,ImagF3,t+tstep*0.5);
    advance(RealC,ImagC,RealF3,ImagF3,RealC4,ImagC4,tstep);
    grad(RealC4,ImagC4,RealF4,ImagF4,t+tstep);
    
    for(i=0;i<nstates;i++)for(j=0;j<nstates;j++)
    {
    
    RealC[i][j]=RealC[i][j]+tstep*(RealF1[i][j]+2.0*RealF2[i][j]+2.0*RealF3[i][j]+RealF4[i][j])/6.0;
    ImagC[i][j]=ImagC[i][j]+tstep*(ImagF1[i][j]+2.0*ImagF2[i][j]+2.0*ImagF3[i][j]+ImagF4[i][j])/6.0;
    
    }
    
    }
    
    public class myPanel extends javax.swing.JPanel{
       
    int iy0,iy1,i,ix0,ix1,i1,iz0,iz1,ip0,ip1;
    void iterate()
    {
      
    }
    
    public double cabs(double x,double y)
    { double r;
      r=Math.sqrt(x*x+y*y);
      return r;
        
    }
            
 
    public void paintComponent(Graphics g)
{   double t;     
    
     
     
     if(imeas==0) {super.paintComponent(g);
      g.clearRect(0,300,400,100);}
   
    
     if(imeas<200)
     {
     g.clearRect(0,50,400,200);  
     freq=imeas*0.05;    
     freqL.setText("frequency="+df.format(freq));
     
     RealC[0][0]=1.0; ImagC[0][0]=0.0;
     RealC[1][0]=0.0; ImagC[1][0]=0.0;
     RealC[0][1]=0.0; ImagC[0][1]=0.0;
     RealC[1][1]=0.0; ImagC[1][1]=0.0;
     
     iy0=250;
     ix0=100;
     iz0=0;
     
     t=0.0;
     
     average=0.0;
     
     for (i=0;i<400;i++)
     {
     for(i1=0;i1<100;i1++)
     {t+=tstep;
     rk4(t);
     
     }
     if(i>=200)average+=
             (cabs(RealC[0][0],ImagC[0][0])-cabs(RealC[1][1],ImagC[1][1]));
     
     g.setColor(Color.black);
     g.drawRect(0,50,400,200);  
     g.drawRect(0,300,400,100);
     
     
     g.drawString("occupation of initial state",10,45);
     g.drawString("time",200,270);
     g.drawString("stationary value",10,295);
     g.drawString("frequency",180,450);
     
     g.drawLine(80,400,80,405);
     g.drawLine(120,400,120,405);
     g.drawLine(160,400,160,405);
     g.drawLine(200,400,200,405);
     g.drawLine(240,400,240,405);
     g.drawLine(280,400,280,405);
     g.drawLine(320,400,320,405);
     
     g.drawString("0",0,420); 
     g.drawString("2",76,420);
     g.drawString("4",156,420);
     g.drawString("6",236,420);
     g.drawString("8",316,420);
     g.drawString("10",396,420);
    
     ix1=(int) 
        ( (cabs(RealC[0][0],ImagC[0][0])-cabs(RealC[1][1],ImagC[1][1]))*100.0);
     
     
   

     g.setColor(Color.red);
     g.drawLine(i, 150-ix0, i+1, 150-ix1);
     ix0=ix1;
     
  
     
     
     }
     

     
     average=average/200.0;
     ix1=(int) (average*100.0);
     g.drawLine(1,150-ix1,400,150-ix1);
     
     ix0=(int) (freq*40.0);
     g.drawOval(ix0,300+ix1,5,5);
     
     
     imeas++;
     
}}
     }
}
     
     
     
