/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.awt.image.BufferedImage;
/*
 * NewJApplet.java
 *
 * Created on 22.03.2010, 14:51:43
 */

/**
 *
 * @author poj
 */
public class NewJApplet extends javax.swing.JApplet {

    boolean fixed = true;
    int[] ix, iy, iy2,ip1,ip2,ip3;
    double[] x2;
    int nsampl = 100;
    int count = 0;
    int il;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        ix = new int[nsampl];
        iy = new int[nsampl];
        iy2 = new int[nsampl];
        x2 = new double[nsampl];
        
        ip1=new int[nsampl];
        ip2=new int[nsampl];
        ip3=new int[nsampl];

        for(il=0;il<nsampl;il++)
        {ip1[il]=4*il;
         ip2[il]=200-(int)(4* Math.sqrt(il));
         ip3[il]=400-ip2[il];
        }
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jButton1 = new javax.swing.JButton();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jLabel1 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 477, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 374, Short.MAX_VALUE)
        );

        jButton1.setText("GO");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("fixed step");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("variable step");
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        jLabel1.setText("jLabel1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jRadioButton2, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE)
                    .addComponent(jRadioButton1, javax.swing.GroupLayout.DEFAULT_SIZE, 193, Short.MAX_VALUE)
                    .addComponent(jButton1)
                    .addComponent(jLabel1))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jRadioButton2)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jRadioButton1)
                        .addGap(18, 18, 18)
                        .addComponent(jButton1)
                        .addGap(42, 42, 42)
                        .addComponent(jLabel1)))
                .addContainerGap(78, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        fixed = true;
        count = 0; 
        clear();
        jPanel1.repaint();
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
        fixed = false;
        count = 0;
        clear();
        jPanel1.repaint();
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        walk();
        jPanel1.repaint();
    
    }//GEN-LAST:event_jButton1ActionPerformed
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JButton jButton1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    // End of variables declaration//GEN-END:variables

    public void clear()
    {int i;
     for (i = 0; i < nsampl; i++) {
     x2[i]=0;
     iy[i]=0;
     count=0;
    
     }
    }
    public void walk() {
        int i, j;
        double x, r, s;

        x = 0;
        for (i = 0; i < nsampl; i++) {
            r = 4.0 * Math.sqrt(3.0) * (Math.random() - 0.5);

            if (fixed) {
                s = 2 * Math.signum(r);
            } else {
                s = r;
            }

            x = x + s;


            iy[i] = 200 - (int) (2.0 * x);

            x2[i] += x * x;

        }

        count++;
        jLabel1.setText("walks:" + count);

    }

    public class myPanel extends javax.swing.JPanel {

        int i, i1, i2;

        public void paintComponent(Graphics g) {


            super.paintComponent(g);
            if(count>0){
            for (i = 0; i < nsampl - 1; i++) {

                i1 = 4 * i;
                i2 = i1 + 4;

                g.setColor(Color.RED);
                g.drawLine(i1, iy[i], i2, iy[i]);
                g.setColor(Color.BLACK);
                g.drawLine(i2, iy[i], i2, iy[i + 1]);

            }
            }
            g.setColor(Color.green);
            g.drawPolyline(ip1, ip2, nsampl);
            g.drawPolyline(ip1, ip3, nsampl);
            g.setColor(Color.black);
            g.drawLine(0, 200, 400, 200);
            g.drawString("steps", 10, 370);
            
            g.drawString("20",80,370);
            g.drawString("40",160,370);
            g.drawString("60",240,370);
            g.drawString("80",320,370);
            g.drawString("100",400,370);

            g.drawLine(400, 0, 400, 400);
            
            g.drawString("x", 410, 20);
            g.drawString("0",420,200);

            g.drawString("+20",410,200-40);
            g.drawString("-20",410,200+40);
             g.drawString("+40",410,200-80);
            g.drawString("-40",410,200+80);
            
            
            if (count > 0) {
                for (i = 0; i < nsampl; i++) {
                    ix[i] = 4 * i;
                    iy2[i] = 200 - (int) (2.0 * Math.sqrt(x2[i] / count));


                }


                g.setColor(Color.BLUE);
                g.drawPolyline(ix, iy2, nsampl);
            
            for (i = 0; i < nsampl; i++) {
                iy2[i] = 400 - iy2[i];
            }
            g.drawPolyline(ix, iy2, nsampl);
            }

            g.drawString("RMS", 50, 50);

        }
    }
}
