/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    DecimalFormat df;
    DecimalFormat df1;
    double P;
    double H;
    double r_val = 1.0;
    double a_val = 1.0;
    double m_val = 0.1;
    double b_val = 0.1;
    double timestep = 0.01;
    int nsteps = 100;
    double P_0 = 1.0;
    double H_0 = 1.0;
    double P_eq;
    double H_eq;
    int[] ip;
    int[] ih;
    int[] ii;
    int npoints = 500;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JSlider jSlider5;
    private JSlider jSlider6;
    private JSlider jSlider7;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.init_arrays();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.timer.restart();
    }

    public void init_arrays() {
        this.ip = new int[this.npoints];
        this.ih = new int[this.npoints];
        this.ii = new int[this.npoints];
        this.df = new DecimalFormat("0.00");
        this.df1 = new DecimalFormat("0.000");
        this.r_val = (double)this.jSlider1.getValue() * 0.01;
        this.jLabel1.setText("r=" + this.df.format(this.r_val));
        this.a_val = (double)this.jSlider2.getValue() * 0.01;
        this.jLabel3.setText("a=" + this.df.format(this.a_val));
        this.b_val = (double)this.jSlider3.getValue() * 0.01;
        this.jLabel4.setText("b=" + this.df.format(this.b_val));
        this.m_val = (double)this.jSlider4.getValue() * 0.01;
        this.jLabel2.setText("m=" + this.df.format(this.m_val));
        this.nsteps = this.jSlider5.getValue();
        this.jLabel5.setText("steps" + this.nsteps);
        this.P_0 = (double)this.jSlider6.getValue() * 0.02;
        this.jLabel6.setForeground(Color.blue);
        this.jLabel8.setForeground(Color.blue);
        this.jLabel6.setText("P(0)=" + this.df.format(this.P_0));
        this.H_0 = (double)this.jSlider7.getValue() * 0.02;
        this.jLabel7.setForeground(Color.red);
        this.jLabel9.setForeground(Color.red);
        this.jLabel7.setText("H(0)=" + this.df.format(this.H_0));
    }

    public void rk2() {
        double dp = this.b_val * this.H * this.P - this.m_val * this.P;
        double dh = this.r_val * this.H - this.a_val * this.H * this.P;
        double pp = this.P + dp * this.timestep * 0.5;
        double hp = this.H + dh * this.timestep * 0.5;
        dp = this.b_val * hp * pp - this.m_val * pp;
        dh = this.r_val * hp - this.a_val * hp * pp;
        this.P += dp * this.timestep;
        this.H += dh * this.timestep;
    }

    public void euler() {
        double dp = this.b_val * this.H * this.P - this.m_val * this.P;
        double dh = this.r_val * this.H - this.a_val * this.H * this.P;
        this.P += dp * this.timestep;
        this.H += dh * this.timestep;
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jSlider4 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSlider5 = new JSlider();
        this.jLabel5 = new JLabel();
        this.jSlider6 = new JSlider();
        this.jSlider7 = new JSlider();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 364, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.setMinimum(1);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jSlider3.setMajorTickSpacing(1);
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("jLabel1");
        this.jLabel3.setText("jLabel1");
        this.jLabel4.setText("jLabel1");
        this.jSlider5.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider5MouseDragged(evt);
            }
        });
        this.jLabel5.setText("jLabel5");
        this.jSlider6.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider6MouseDragged(evt);
            }
        });
        this.jSlider7.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider7MouseDragged(evt);
            }
        });
        this.jLabel6.setText("jLabel6");
        this.jLabel7.setText("jLabel7");
        this.jLabel8.setText("jLabel8");
        this.jLabel9.setText("jLabel9");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel8, -2, 150, -2).addGap(57, 57, 57).addComponent(this.jLabel9, -2, 146, -2).addGap(97, 97, 97).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(76, 76, 76).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addGap(77, 77, 77).addComponent(this.jLabel7)).addGroup(layout.createSequentialGroup().addGap(81, 81, 81).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addGap(82, 82, 82).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addGap(85, 85, 85).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addGap(84, 84, 84).addComponent(this.jLabel5)).addComponent(this.jSlider3, -2, 153, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider4, -2, 153, -2).addComponent(this.jSlider5, -2, 153, -2).addComponent(this.jSlider6, -2, 153, -2).addComponent(this.jSlider7, -2, 153, -2)).addComponent(this.jSlider2, -2, 153, -2).addComponent(this.jSlider1, -2, 153, -2)))).addContainerGap(328, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel8).addComponent(this.jLabel9)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSlider1, -2, -1, -2).addGap(8, 8, 8).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, -1, -2).addGap(56, 56, 56).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider5, -2, -1, -2).addGap(26, 26, 26).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel7).addGap(12, 12, 12).addComponent(this.jSlider7, -2, -1, -2).addGap(0, 49, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(1, 1, 1).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE))).addContainerGap()));
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.r_val = (double)this.jSlider1.getValue() * 0.01;
        this.jLabel1.setText("r=" + this.df.format(this.r_val));
        this.jPanel1.repaint();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.a_val = (double)this.jSlider2.getValue() * 0.01;
        this.jLabel3.setText("a=" + this.df.format(this.a_val));
        this.jPanel1.repaint();
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.b_val = (double)this.jSlider3.getValue() * 0.01;
        this.jLabel4.setText("b=" + this.df.format(this.b_val));
        this.jPanel1.repaint();
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.m_val = (double)this.jSlider4.getValue() * 0.01;
        this.jLabel2.setText("m=" + this.df.format(this.m_val));
        this.jPanel1.repaint();
    }

    private void jSlider5MouseDragged(MouseEvent evt) {
        this.nsteps = this.jSlider5.getValue();
        this.jLabel5.setText("steps" + this.nsteps);
        this.jPanel1.repaint();
    }

    private void jSlider6MouseDragged(MouseEvent evt) {
        this.P_0 = (double)this.jSlider6.getValue() * 0.02;
        this.jLabel6.setText("P(0)=" + this.df.format(this.P_0));
        this.jPanel1.repaint();
    }

    private void jSlider7MouseDragged(MouseEvent evt) {
        this.H_0 = (double)this.jSlider7.getValue() * 0.02;
        this.jLabel7.setText("H(0)=" + this.df.format(this.H_0));
        this.jPanel1.repaint();
    }

    public class myPanel
    extends JPanel {
        public void paintComponent(Graphics g) {
            int i;
            super.paintComponent(g);
            NewJApplet.this.P = NewJApplet.this.P_0;
            NewJApplet.this.H = NewJApplet.this.H_0;
            int iy1 = 300 - (int)(50.0 * NewJApplet.this.P);
            int iy2 = 300 - (int)(50.0 * NewJApplet.this.H);
            NewJApplet.this.ii[0] = 0;
            NewJApplet.this.ih[0] = iy2;
            NewJApplet.this.ip[0] = iy1;
            for (i = 1; i < NewJApplet.this.npoints; ++i) {
                for (int k = 0; k < NewJApplet.this.nsteps; ++k) {
                    NewJApplet.this.rk2();
                }
                iy1 = 300 - (int)(50.0 * NewJApplet.this.P);
                iy2 = 300 - (int)(50.0 * NewJApplet.this.H);
                NewJApplet.this.ii[i] = i;
                NewJApplet.this.ih[i] = iy2;
                NewJApplet.this.ip[i] = iy1;
            }
            double Heq = NewJApplet.this.m_val / NewJApplet.this.b_val;
            double Peq = NewJApplet.this.r_val / NewJApplet.this.a_val;
            NewJApplet.this.jLabel8.setText("eq P= " + NewJApplet.this.df.format(Peq));
            NewJApplet.this.jLabel9.setText("eq H= " + NewJApplet.this.df.format(Heq));
            iy1 = 300 - (int)(50.0 * Peq);
            iy2 = 300 - (int)(50.0 * Heq);
            g.setColor(Color.red);
            g.drawLine(0, iy2, NewJApplet.this.npoints, iy2);
            g.drawPolyline(NewJApplet.this.ii, NewJApplet.this.ih, NewJApplet.this.npoints);
            g.setColor(Color.blue);
            g.drawLine(0, iy1, NewJApplet.this.npoints, iy1);
            g.drawPolyline(NewJApplet.this.ii, NewJApplet.this.ip, NewJApplet.this.npoints);
            for (i = 0; i < NewJApplet.this.npoints; ++i) {
                NewJApplet.this.ih[i] = 200 + iy2 - NewJApplet.this.ih[i];
                NewJApplet.this.ip[i] = NewJApplet.this.ip[i] - iy1 + 500;
            }
            g.drawPolyline(NewJApplet.this.ih, NewJApplet.this.ip, NewJApplet.this.npoints);
            g.drawLine(100, 500, 300, 500);
            g.drawString(" H-Heq", 300, 500);
            g.drawLine(200, 400, 200, 600);
            g.drawString(" P-Peq", 200, 400);
        }
    }
}

