/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    DecimalFormat df;
    double[][] Rmat;
    double xx;
    double xy;
    double xz;
    double yx;
    double yy;
    double yz;
    double zx;
    double zy;
    double zz;
    double[] xc;
    double[] yc;
    double[] zc;
    double[] bondl;
    double[] phi;
    double[] theta;
    double[] xc0;
    double[] yc0;
    double[] zc0;
    double[] xcc;
    double[] ycc;
    double[] zcc;
    double[] gradx;
    double[] grady;
    double[] gradz;
    double[] grad0x;
    double[] grad0y;
    double[] grad0z;
    double[] sx;
    double[] sy;
    double[] sz;
    double[] s0x;
    double[] s0y;
    double[] s0z;
    int[] nat;
    double[] amass;
    double[] dvec;
    double[] evec;
    int[][] bondats;
    int[][] phiats;
    int[][] thetaats;
    double[][] ffbond;
    double[][] ffang;
    double[][] ffthet;
    int[][] ffbondats;
    int[][] ffangats;
    int[][] ffthetats;
    int natmax = 25;
    int nbondmax = 50;
    int nphimax = 100;
    int nthetamax = 100;
    int natoms;
    int nbonds;
    int nphi;
    int ntheta;
    int indexb;
    int indexa;
    int indexc;
    int nffbond;
    int nffang;
    int nffthet;
    double linepos = 0.0;
    double rotx = 0.0;
    double roty = 0.0;
    double rotz = 0.0;
    double[][] rmat;
    Point oldp;
    Point newp;
    boolean isfirst = true;
    double gbet = 0.0;
    double gbetold = 0.0;
    int countsteps = 0;
    double[][] Hessian;
    double[][] zmat;
    boolean animation = false;
    boolean modes_available = false;
    int dirflag = 1;
    int plotmode = 0;
    double modf = 1.0;
    int phase = 0;
    int xfrom = 0;
    int yfrom = 0;
    int xto = 0;
    int yto = 0;
    double fac = 4.192771084337349E26;
    double s2cm = 5.0E-12;
    double h;
    double gnorm;
    double gnorm0;
    double lasth;
    double lastgrad;
    double gnormd;
    int animation_mode = 3;
    boolean dihedrals_on = true;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton13;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane3;
    private JSlider jSlider2;
    private JTextArea jTextArea1;
    private JTextArea jTextArea3;
    private JToggleButton jToggleButton1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.init_arrays();
                    NewJApplet.this.set_ic();
                    NewJApplet.this.set_ff();
                    NewJApplet.this.prepare_minim();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void init_arrays() {
        this.nat = new int[this.natmax];
        this.bondats = new int[this.nbondmax][2];
        this.phiats = new int[this.nphimax][3];
        this.thetaats = new int[this.nthetamax][4];
        this.xc = new double[this.natmax];
        this.yc = new double[this.natmax];
        this.zc = new double[this.natmax];
        this.xcc = new double[this.natmax];
        this.ycc = new double[this.natmax];
        this.zcc = new double[this.natmax];
        this.xc0 = new double[this.natmax];
        this.yc0 = new double[this.natmax];
        this.zc0 = new double[this.natmax];
        this.sx = new double[this.natmax];
        this.sy = new double[this.natmax];
        this.sz = new double[this.natmax];
        this.s0x = new double[this.natmax];
        this.s0y = new double[this.natmax];
        this.s0z = new double[this.natmax];
        this.dvec = new double[3 * this.natmax];
        this.evec = new double[3 * this.natmax];
        this.gradx = new double[this.natmax];
        this.grady = new double[this.natmax];
        this.gradz = new double[this.natmax];
        this.grad0x = new double[this.natmax];
        this.grad0y = new double[this.natmax];
        this.grad0z = new double[this.natmax];
        this.bondl = new double[this.nbondmax];
        this.phi = new double[this.nphimax];
        this.theta = new double[this.nthetamax];
        this.ffbond = new double[this.nbondmax][2];
        this.ffbondats = new int[this.nbondmax][2];
        this.ffang = new double[this.nbondmax][2];
        this.ffangats = new int[this.nbondmax][3];
        this.ffthet = new double[this.nbondmax][2];
        this.ffangats = new int[this.nbondmax][3];
        this.ffthetats = new int[this.nbondmax][4];
        this.Hessian = new double[3 * this.natmax][3 * this.natmax];
        this.zmat = new double[3 * this.natmax][3 * this.natmax];
        this.zz = 1.0;
        this.yy = 1.0;
        this.xx = 1.0;
        this.zy = 0.0;
        this.zx = 0.0;
        this.yz = 0.0;
        this.yx = 0.0;
        this.xz = 0.0;
        this.xy = 0.0;
        this.amass = new double[this.natmax];
        this.timer = new Timer(100, this);
        this.timer.setInitialDelay(100);
        this.timer.start();
        this.jLabel2.setText("" + this.plotmode);
        this.df = new DecimalFormat("########0.0");
    }

    public void actionPerformed(ActionEvent e) {
        if (this.animation) {
            if (this.animation_mode == 0) {
                this.animate_modes();
            }
            if (this.animation_mode == 1) {
                this.verlet();
            }
            if (this.animation_mode == 2) {
                this.steepest(true);
            }
            if (this.animation_mode == 3) {
                this.steepest(false);
            }
        }
        this.jPanel1.repaint();
        this.timer.restart();
    }

    public void animate_modes() {
        double cp = Math.cos((double)this.phase * Math.PI / 4.0);
        for (int i = 0; i < this.natoms; ++i) {
            double fm = cp / Math.sqrt(this.amass[i]);
            this.xcc[i] = this.xc[i] + this.Hessian[i * 3][this.plotmode] * this.modf * fm;
            this.ycc[i] = this.yc[i] + this.Hessian[i * 3 + 1][this.plotmode] * this.modf * fm;
            this.zcc[i] = this.zc[i] + this.Hessian[i * 3 + 2][this.plotmode] * this.modf * fm;
        }
        ++this.phase;
        if (this.phase == 8) {
            this.phase = 0;
        }
    }

    public void addbond(int i1, int i2, double b) {
        this.bondl[this.nbonds] = b;
        this.bondats[this.nbonds][0] = i1;
        this.bondats[this.nbonds][1] = i2;
        ++this.nbonds;
    }

    public void addphi(int i1, int i2, int i3, double p) {
        this.phi[this.nphi] = p;
        this.phiats[this.nphi][0] = i1;
        this.phiats[this.nphi][1] = i2;
        this.phiats[this.nphi][2] = i3;
        ++this.nphi;
    }

    public void addtheta(int i1, int i2, int i3, int i4, double t) {
        this.theta[this.ntheta] = t;
        this.thetaats[this.ntheta][0] = i1;
        this.thetaats[this.ntheta][1] = i2;
        this.thetaats[this.ntheta][2] = i3;
        this.thetaats[this.ntheta][3] = i4;
        ++this.ntheta;
    }

    public void addatom(int na, int n1, int n2, int n3, double b, double p, double t) {
        this.nat[this.natoms] = na;
        switch (na) {
            case 1: {
                this.amass[this.natoms] = 1.0;
                break;
            }
            case 6: {
                this.amass[this.natoms] = 12.0;
                break;
            }
            case 7: {
                this.amass[this.natoms] = 14.0;
                break;
            }
            case 8: {
                this.amass[this.natoms] = 16.0;
                break;
            }
            default: {
                this.amass[this.natoms] = 1.0;
            }
        }
        this.addbond(this.natoms, n1, b);
        this.addphi(this.natoms, n1, n2, p);
        this.addtheta(this.natoms, n1, n2, n3, t);
        double x1 = this.xc[n1] - this.xc[n2];
        double x2 = this.yc[n1] - this.yc[n2];
        double x3 = this.zc[n1] - this.zc[n2];
        double xb = x1 * x1 + x2 * x2 + x3 * x3;
        xb = Math.sqrt(xb);
        double y1 = this.xc[n2] - this.xc[n3];
        double y2 = this.yc[n2] - this.yc[n3];
        double y3 = this.zc[n2] - this.zc[n3];
        double sp = (x1 /= xb) * y1 + (x2 /= xb) * y2 + (x3 /= xb) * y3;
        double yb = y1 * y1 + y2 * y2 + y3 * y3;
        yb = (y1 -= x1 * sp) * y1 + (y2 -= x2 * sp) * y2 + (y3 -= x3 * sp) * y3;
        yb = Math.sqrt(yb);
        double z1 = x2 * (y3 /= yb) - x3 * (y2 /= yb);
        double z2 = x3 * (y1 /= yb) - x1 * y3;
        double z3 = x1 * y2 - x2 * y1;
        double zb = z1 * z1 + z2 * z2 + z3 * z3;
        zb = Math.sqrt(zb);
        z1 /= zb;
        z2 /= zb;
        z3 /= zb;
        double c1 = Math.cos((180.0 - p) * Math.PI / 180.0);
        double c2 = Math.cos((180.0 - t) * Math.PI / 180.0);
        double s1 = Math.sin((180.0 - p) * Math.PI / 180.0);
        double s2 = Math.sin((180.0 - t) * Math.PI / 180.0);
        double xn = c1 * x1 + s1 * c2 * y1 + s1 * s2 * z1;
        double yn = c1 * x2 + s1 * c2 * y2 + s1 * s2 * z2;
        double zn = c1 * x3 + s1 * c2 * y3 + s1 * s2 * z3;
        this.xc[this.natoms] = this.xc[n1] + b * xn;
        this.yc[this.natoms] = this.yc[n1] + b * yn;
        this.zc[this.natoms] = this.zc[n1] + b * zn;
        ++this.natoms;
    }

    public void set_ic() {
        int i;
        double rcn = 1.44;
        double rcc = 1.45;
        double rco = 1.22;
        double rch = 1.089;
        double rnh = 1.008;
        double roh = 0.95;
        double phincc = 109.5;
        double phicco = 120.0;
        double phih = 109.5;
        double thetncco = -180.0;
        double thetccnc = 180.0;
        this.natoms = 0;
        this.nbonds = 0;
        this.nphi = 0;
        this.ntheta = 0;
        this.nat[0] = 7;
        this.zc[0] = 0.0;
        this.yc[0] = 0.0;
        this.xc[0] = 0.0;
        this.amass[0] = 14.0;
        this.nat[1] = 6;
        this.amass[1] = 12.0;
        this.yc[1] = 0.0;
        this.xc[1] = 0.0;
        this.zc[1] = rcn;
        this.addbond(0, 1, 1.43);
        this.nat[2] = 6;
        this.amass[2] = 12.0;
        this.xc[2] = 0.0;
        this.zc[2] = this.zc[1] + rcc * Math.cos((180.0 - phincc) * Math.PI / 180.0);
        this.yc[2] = this.yc[1] + rcc * Math.sin((180.0 - phincc) * Math.PI / 180.0);
        this.addbond(1, 2, rcc);
        this.addphi(0, 1, 2, phincc);
        this.natoms = 3;
        this.addatom(7, 2, 1, 0, rcn, phincc, 180.0);
        this.addatom(6, 3, 2, 1, rcn, phincc, 180.0);
        this.addatom(6, 4, 3, 2, rcc, phincc, 180.0);
        this.addatom(8, 2, 1, 0, rco, phicco, -60.0);
        this.addatom(8, 5, 4, 3, rco, phicco, 180.0);
        this.addatom(8, 5, 4, 3, rco, phicco, -60.0);
        this.addatom(1, 0, 1, 2, rnh, phih, -60.0);
        this.addatom(1, 0, 1, 2, rnh, phih, 60.0);
        this.addatom(1, 1, 2, 3, rch, phih, -60.0);
        this.addatom(1, 1, 2, 3, rch, phih, 60.0);
        this.addatom(1, 3, 2, 1, rnh, phih, 0.0);
        this.addatom(1, 4, 3, 2, rch, phih, 0.0);
        this.addatom(1, 4, 3, 2, rch, phih, 120.0);
        this.addatom(1, 8, 5, 4, roh, phih, 180.0);
        double zce = 0.0;
        double yce = 0.0;
        double xce = 0.0;
        for (i = 0; i < this.natoms; ++i) {
            xce += this.xc[i];
            yce += this.yc[i];
            zce += this.zc[i];
        }
        xce /= (double)this.natoms;
        yce /= (double)this.natoms;
        zce /= (double)this.natoms;
        for (i = 0; i < this.natoms; ++i) {
            this.xc[i] = this.xc[i] - xce;
            this.yc[i] = this.yc[i] - yce;
            this.zc[i] = this.zc[i] - zce;
        }
        this.copycoo();
    }

    public void zmat() {
        this.jTextArea3.append("" + this.nat[0] + "\n");
        this.jTextArea3.append("" + this.nat[1] + " 0  " + this.getbondl(1, 0) + "\n");
        this.jTextArea3.append("" + this.nat[2] + "  1  0  " + this.getbondl(1, 2) + "  " + this.getphi(0, 1, 2) + "\n");
        this.listatom(3, 2, 1, 0);
        this.listatom(4, 3, 2, 1);
        this.listatom(5, 4, 3, 2);
        this.listatom(6, 2, 1, 0);
        this.listatom(7, 5, 4, 3);
        this.listatom(8, 5, 4, 3);
        this.listatom(9, 0, 1, 2);
        this.listatom(10, 0, 1, 2);
        this.listatom(11, 1, 2, 3);
        this.listatom(12, 1, 2, 3);
        this.listatom(13, 3, 2, 1);
        this.listatom(14, 4, 3, 2);
        this.listatom(15, 4, 3, 2);
        this.listatom(16, 8, 5, 4);
    }

    public void listatom(int n1, int n2, int n3, int n4) {
        this.jTextArea3.append("" + this.nat[n1] + "  " + n2 + " " + n3 + " " + n4 + " " + this.getbondl(n1, n2) + "  " + this.getphi(n1, n2, n3) + "  " + this.gettheta(n1, n2, n3, n4) + "\n");
    }

    public void add_ffbond(int i, int j, double r, double k) {
        this.ffbond[this.indexb][0] = r;
        this.ffbond[this.indexb][1] = k;
        this.ffbondats[this.indexb][0] = i;
        this.ffbondats[this.indexb][1] = j;
        ++this.indexb;
    }

    public void add_ffang(int n1, int n2, int n3, double phi, double k) {
        double kdeg = 57.29577951308232;
        kdeg *= kdeg;
        this.ffang[this.indexa][0] = phi;
        this.ffang[this.indexa][1] = k / kdeg;
        this.ffangats[this.indexa][0] = n1;
        this.ffangats[this.indexa][1] = n2;
        this.ffangats[this.indexa][2] = n3;
        ++this.indexa;
    }

    public void add_ffthet(int n1, int n2, int n3, int n4, double phi, double k) {
        double kdeg = 57.29577951308232;
        kdeg *= kdeg;
        this.ffthet[this.indexc][0] = phi;
        this.ffthet[this.indexc][1] = k / kdeg;
        this.ffthetats[this.indexc][0] = n1;
        this.ffthetats[this.indexc][1] = n2;
        this.ffthetats[this.indexc][2] = n3;
        this.ffthetats[this.indexc][3] = n4;
        ++this.indexc;
    }

    public void set_ff() {
        double rcn = 1.346;
        double rc1n = 1.438;
        double rc1n2 = 1.452;
        double rc2c1 = 1.51;
        double rcc1 = 1.528;
        double rc2o2 = 1.211;
        double rco = 1.229;
        double rc2o1 = 1.339;
        double rnh = 1.016;
        double rn2h3 = 1.02;
        double rc1h1 = 1.098;
        double ro1h2 = 0.974;
        double kcn = 1296.3;
        double kc1n = 935.5;
        double kc1n2 = 887.7;
        double kc2c1 = 818.9;
        double kcc1 = 767.9;
        double kc2o2 = 2154.5;
        double kco = 1945.7;
        double kc2o1 = 1162.1;
        double knh = 1132.4;
        double kn2h3 = 1104.5;
        double kc1h1 = 900.0;
        double ko1h2 = 1214.6;
        double phincc1 = 115.0;
        double kncc1 = 160.9;
        double phic1nc = 122.3;
        double kc1nc = 160.1;
        double phic1c2o1 = 111.5;
        double kc1c2o1 = 156.0;
        double phic1c2o2 = 124.4;
        double kc1c2o2 = 123.8;
        double phic1co = 121.4;
        double kc1co = 127.5;
        double phio2c2o1 = 124.1;
        double ko2c2o1 = 146.5;
        double phinco = 123.2;
        double knco = 132.7;
        double phicc1h1 = 110.1;
        double kcc1h1 = 74.6;
        double phic2c1h1 = 109.4;
        double kc2c1h1 = 69.6;
        double phicnh = 123.1;
        double kcnh = 72.0;
        double phic1nh = 114.6;
        double kc1nh = 68.3;
        double phic1n2h3 = 108.7;
        double kc1n2h3 = 71.7;
        double phih1c1h1 = 106.6;
        double kh1c1h1 = 48.3;
        double phih3n2h3 = 107.7;
        double kh3n2h3 = 45.2;
        double phicc1n = 107.4;
        double kcc1n = 145.4;
        double phicc1n2 = 109.0;
        double kcc1n2 = 139.8;
        double phic2c1n = 108.6;
        double kc2c1n = 129.0;
        double phic2o1h2 = 106.9;
        double kc2o1h2 = 72.0;
        double phinc1h1 = 111.1;
        double knc1h1 = 73.3;
        double phin2c1h1 = 112.6;
        double kn2c1h1 = 80.1;
        this.indexb = 0;
        this.add_ffbond(0, 1, rc1n2, kc1n2);
        this.add_ffbond(1, 2, rcc1, kcc1);
        this.add_ffbond(2, 3, rcn, kcn);
        this.add_ffbond(3, 4, rc1n, kc1n);
        this.add_ffbond(4, 5, rc2c1, kc2c1);
        this.add_ffbond(5, 7, rc2o2, kc2o2);
        this.add_ffbond(5, 8, rc2o1, kc2o1);
        this.add_ffbond(2, 6, rco, kco);
        this.add_ffbond(0, 9, rn2h3, kn2h3);
        this.add_ffbond(0, 10, rn2h3, kn2h3);
        this.add_ffbond(1, 11, rc1h1, kc1h1);
        this.add_ffbond(1, 12, rc1h1, kc1h1);
        this.add_ffbond(3, 13, rnh, knh);
        this.add_ffbond(4, 14, rc1h1, kc1h1);
        this.add_ffbond(4, 15, rc1h1, kc1h1);
        this.add_ffbond(8, 16, ro1h2, ko1h2);
        this.nffbond = this.indexb;
        this.indexa = 0;
        this.add_ffang(0, 1, 2, phicc1n2, kcc1n2);
        this.add_ffang(1, 2, 3, phincc1, kncc1);
        this.add_ffang(2, 3, 4, phic1nc, kc1nc);
        this.add_ffang(3, 4, 5, phic2c1n, kc2c1n);
        this.add_ffang(4, 5, 7, phic1c2o2, kc1c2o2);
        this.add_ffang(4, 5, 8, phic1c2o1, kc1c2o1);
        this.add_ffang(7, 5, 8, phio2c2o1, ko2c2o1);
        this.add_ffang(1, 2, 6, phic1co, kc1co);
        this.add_ffang(3, 2, 6, phinco, knco);
        this.add_ffang(9, 0, 1, phic1n2h3, kc1n2h3);
        this.add_ffang(10, 0, 1, phic1n2h3, kc1n2h3);
        this.add_ffang(9, 0, 10, phih3n2h3, kh3n2h3);
        this.add_ffang(15, 4, 3, phinc1h1, knc1h1);
        this.add_ffang(14, 4, 3, phinc1h1, knc1h1);
        this.add_ffang(15, 4, 5, phic2c1h1, kc2c1h1);
        this.add_ffang(14, 4, 5, phic2c1h1, kc2c1h1);
        this.add_ffang(16, 8, 5, phic2o1h2, kc2o1h2);
        this.add_ffang(13, 3, 2, phicnh, kcnh);
        this.add_ffang(12, 1, 0, phin2c1h1, kn2c1h1);
        this.add_ffang(11, 1, 0, phin2c1h1, kn2c1h1);
        this.add_ffang(11, 1, 2, phicc1h1, kcc1h1);
        this.add_ffang(12, 1, 2, phicc1h1, kcc1h1);
        this.add_ffang(12, 1, 11, phih1c1h1, kh1c1h1);
        this.add_ffang(14, 4, 15, phih1c1h1, kh1c1h1);
        this.add_ffang(4, 3, 13, phic1nh, kc1nh);
        this.nffang = this.indexa;
        this.indexc = 0;
        this.add_ffthet(9, 0, 1, 2, -67.6, 1.0);
        this.add_ffthet(13, 3, 2, 1, 27.5, 1.0);
        this.add_ffthet(16, 8, 5, 4, -147.4, 1.0);
        this.add_ffthet(3, 2, 1, 0, 160.74, 1.0);
        this.add_ffthet(4, 3, 2, 1, -152.3, 1.0);
        this.add_ffthet(5, 4, 3, 2, -153.1, 1.0);
        this.add_ffthet(7, 5, 4, 3, 123.7, 1.0);
        this.add_ffthet(8, 5, 4, 3, -56.5, 1.0);
        this.add_ffthet(14, 4, 3, 2, -32.5, 1.0);
        this.add_ffthet(15, 4, 3, 2, 86.3, 1.0);
        this.add_ffthet(6, 2, 1, 0, -26.3, 1.0);
        this.nffthet = this.indexc;
    }

    public void ic2cart() {
    }

    public void cart2ic() {
    }

    public double getbondl(int i, int j) {
        double dx = this.xc[i] - this.xc[j];
        double dy = this.yc[i] - this.yc[j];
        double dz = this.zc[i] - this.zc[j];
        double r = dx * dx + dy * dy + dz * dz;
        r = Math.sqrt(r);
        return r;
    }

    public double getphi(int i, int j, int k) {
        double x1 = this.xc[i] - this.xc[j];
        double x2 = this.xc[k] - this.xc[j];
        double y1 = this.yc[i] - this.yc[j];
        double y2 = this.yc[k] - this.yc[j];
        double z1 = this.zc[i] - this.zc[j];
        double z2 = this.zc[k] - this.zc[j];
        double b1 = x1 * x1 + y1 * y1 + z1 * z1;
        double b2 = x2 * x2 + y2 * y2 + z2 * z2;
        double cc = (x1 * x2 + y1 * y2 + z1 * z2) / Math.sqrt(b1 * b2);
        if (cc > 1.0) {
            cc = 1.0;
        }
        if (cc < -1.0) {
            cc = -1.0;
        }
        cc = Math.acos(cc) * 180.0 / Math.PI;
        return cc;
    }

    public double gettheta(int i, int j, int k, int l) {
        double bm;
        double bn;
        double mz;
        double nz;
        double my;
        double ny;
        double mx;
        double sp;
        double x12 = this.xc[i] - this.xc[j];
        double y12 = this.yc[i] - this.yc[j];
        double z12 = this.zc[i] - this.zc[j];
        double x23 = this.xc[k] - this.xc[j];
        double y23 = this.yc[k] - this.yc[j];
        double z23 = this.zc[k] - this.zc[j];
        double x34 = this.xc[k] - this.xc[l];
        double y34 = this.yc[k] - this.yc[l];
        double z34 = this.zc[k] - this.zc[l];
        double b12 = x12 * x12 + y12 * y12 + z12 * z12;
        b12 = Math.sqrt(b12);
        double b23 = x23 * x23 + y23 * y23 + z23 * z23;
        b23 = Math.sqrt(b23);
        double b34 = x34 * x34 + y34 * y34 + z34 * z34;
        double nx = (y12 /= b12) * (z23 /= b23) - (z12 /= b12) * (y23 /= b23);
        if ((sp = (nx * (mx = -(y34 /= (b34 = Math.sqrt(b34))) * z23 + (z34 /= b34) * y23) + (ny = z12 * (x23 /= b23) - (x12 /= b12) * z23) * (my = -z34 * x23 + (x34 /= b34) * z23) + (nz = x12 * y23 - y12 * x23) * (mz = -x34 * y23 + y34 * x23)) / Math.sqrt((bn = nx * nx + ny * ny + nz * nz) * (bm = mx * mx + my * my + mz * mz))) > 1.0) {
            sp = 1.0;
        }
        if (sp < -1.0) {
            sp = -1.0;
        }
        sp = Math.acos(sp) * 180.0 / Math.PI;
        double det = x23 * ny * mz + y23 * nz * mx + z23 * nx * my;
        det = det - x23 * my * nz - y23 * mz * nx - z23 * mx * ny;
        sp = -sp * Math.signum(det);
        return sp;
    }

    public void mode_shift(double cp, int imode) {
        for (int i = 0; i < this.natoms; ++i) {
            double fm = cp / Math.sqrt(this.amass[i]);
            this.xc[i] = this.xc[i] + this.Hessian[i * 3][imode] * this.modf * fm;
            this.yc[i] = this.yc[i] + this.Hessian[i * 3 + 1][imode] * this.modf * fm;
            this.zc[i] = this.zc[i] + this.Hessian[i * 3 + 2][imode] * this.modf * fm;
        }
    }

    public double mode_energy(double cp, int imode) {
        double fm;
        int i;
        for (i = 0; i < this.natoms; ++i) {
            fm = cp / Math.sqrt(this.amass[i]);
            this.xc[i] = this.xc[i] + this.Hessian[i * 3][imode] * this.modf * fm;
            this.yc[i] = this.yc[i] + this.Hessian[i * 3 + 1][imode] * this.modf * fm;
            this.zc[i] = this.zc[i] + this.Hessian[i * 3 + 2][imode] * this.modf * fm;
        }
        double e = this.energy();
        for (i = 0; i < this.natoms; ++i) {
            fm = cp / Math.sqrt(this.amass[i]);
            this.xc[i] = this.xc[i] - this.Hessian[i * 3][imode] * this.modf * fm;
            this.yc[i] = this.yc[i] - this.Hessian[i * 3 + 1][imode] * this.modf * fm;
            this.zc[i] = this.zc[i] - this.Hessian[i * 3 + 2][imode] * this.modf * fm;
        }
        return e;
    }

    public double line_energy(double xla) {
        this.linestep(xla);
        double el = this.energy();
        this.linestep(-xla);
        return el;
    }

    public double check_energy() {
        double e1;
        double k;
        double b0;
        double b;
        int i;
        double e = 0.0;
        for (i = 0; i < this.nffbond; ++i) {
            b = this.getbondl(this.ffbondats[i][0], this.ffbondats[i][1]);
            b0 = this.ffbond[i][0];
            k = this.ffbond[i][1];
            e1 = b - b0;
            e1 = e1 * e1 * k * 0.5;
            e += e1;
        }
        for (i = 0; i < this.nffang; ++i) {
            b = this.getphi(this.ffangats[i][0], this.ffangats[i][1], this.ffangats[i][2]);
            b0 = this.ffang[i][0];
            k = this.ffang[i][1];
            e1 = b - b0;
            e1 = e1 * e1 * k;
            e += e1;
        }
        for (i = 0; i < this.nffthet; ++i) {
            b = this.gettheta(this.ffthetats[i][0], this.ffthetats[i][1], this.ffthetats[i][2], this.ffthetats[i][3]);
            b0 = this.ffthet[i][0];
            k = this.ffthet[i][1];
            e1 = b - b0;
            e1 = k * (1.0 - Math.cos(e1));
            e += e1;
        }
        return e;
    }

    public double energy() {
        double e1;
        double k;
        double b0;
        double b;
        int i;
        double e = 0.0;
        for (i = 0; i < this.nffbond; ++i) {
            b = this.getbondl(this.ffbondats[i][0], this.ffbondats[i][1]);
            b0 = this.ffbond[i][0];
            k = this.ffbond[i][1];
            e1 = b - b0;
            e1 = e1 * e1 * k * 0.5;
            e += e1;
        }
        for (i = 0; i < this.nffang; ++i) {
            b = this.getphi(this.ffangats[i][0], this.ffangats[i][1], this.ffangats[i][2]);
            b0 = this.ffang[i][0];
            k = this.ffang[i][1];
            e1 = b - b0;
            e1 = e1 * e1 * k;
            e += e1;
        }
        if (this.dihedrals_on) {
            for (i = 0; i < this.nffthet; ++i) {
                b = this.gettheta(this.ffthetats[i][0], this.ffthetats[i][1], this.ffthetats[i][2], this.ffthetats[i][3]);
                b0 = this.ffthet[i][0];
                k = this.ffthet[i][1];
                e1 = b - b0;
                e1 = k * (1.0 - Math.cos(e1));
                e += e1;
            }
        }
        return e;
    }

    public void gradients() {
        this.calc_grad();
    }

    public void ana_gradients() {
        double gz;
        double gy;
        double gx;
        double f;
        double b;
        double dz;
        double dy;
        double dx;
        double k;
        double b0;
        int n2;
        int n1;
        int i;
        for (i = 0; i < this.natmax; ++i) {
            this.gradz[i] = 0.0;
            this.grady[i] = 0.0;
            this.gradx[i] = 0.0;
        }
        for (i = 0; i < this.nffbond; ++i) {
            n1 = this.ffbondats[i][0];
            n2 = this.ffbondats[i][1];
            b0 = this.ffbond[i][0];
            k = this.ffbond[i][1];
            dx = this.xc[n1] - this.xc[n2];
            dy = this.yc[n1] - this.yc[n2];
            dz = this.zc[n1] - this.zc[n2];
            b = this.getbondl(n1, n2);
            f = k * (1.0 - b0 / b);
            gx = f * dx;
            gy = f * dy;
            gz = f * dz;
            int n = n1;
            this.gradx[n] = this.gradx[n] + gx;
            int n3 = n1;
            this.grady[n3] = this.grady[n3] + gy;
            int n4 = n1;
            this.gradz[n4] = this.gradz[n4] + gz;
            int n5 = n2;
            this.gradx[n5] = this.gradx[n5] - gx;
            int n6 = n2;
            this.grady[n6] = this.grady[n6] - gy;
            int n7 = n2;
            this.gradz[n7] = this.gradz[n7] - gz;
        }
        for (i = 0; i < this.nffang; ++i) {
            n1 = this.ffangats[i][0];
            n2 = this.ffangats[i][1];
            int n3 = this.ffangats[i][2];
            b0 = this.ffang[i][0];
            k = this.ffang[i][1];
            b = this.getphi(n1, n2, n3);
            dx = this.xc[n1] - this.xc[n2];
            dy = this.yc[n1] - this.yc[n2];
            dz = this.zc[n1] - this.zc[n2];
            double dx2 = this.xc[n3] - this.xc[n2];
            double dy2 = this.yc[n3] - this.yc[n2];
            double dz2 = this.zc[n3] - this.zc[n2];
            double b1 = Math.sqrt(dx * dx + dy * dy + dz * dz);
            double b2 = Math.sqrt(dx2 * dx2 + dy2 * dy2 + dz2 * dz2);
            double sp = dx * dx2 + dy * dy2 + dz * dz2;
            double c = sp / (b1 * b2);
            double s = Math.sqrt(1.0 - c * c);
            f = 1.0 / (b1 * b2);
            double f2 = sp / (b1 * b1 * b1 * b2);
            gx = f * dx2 - f2 * dx;
            gy = f * dy2 - f2 * dy;
            gz = f * dz2 - f2 * dz;
            f2 = sp / (b2 * b2 * b2 * b1);
            double gx2 = f * dx - f2 * dx2;
            double gy2 = f * dy - f2 * dy2;
            double gz2 = f * dz - f2 * dz2;
            double f0 = -2.0 * k * (b - b0) * 57.29577951308232 / s;
            int n = n1;
            this.gradx[n] = this.gradx[n] + f0 * gx;
            int n8 = n1;
            this.grady[n8] = this.grady[n8] + f0 * gy;
            int n9 = n1;
            this.gradz[n9] = this.gradz[n9] + f0 * gz;
            int n10 = n3;
            this.gradx[n10] = this.gradx[n10] + f0 * gx2;
            int n11 = n3;
            this.grady[n11] = this.grady[n11] + f0 * gy2;
            int n12 = n3;
            this.gradz[n12] = this.gradz[n12] + f0 * gz2;
            int n13 = n2;
            this.gradx[n13] = this.gradx[n13] - f0 * (gx + gx2);
            int n14 = n2;
            this.grady[n14] = this.grady[n14] - f0 * (gy + gy2);
            int n15 = n2;
            this.gradz[n15] = this.gradz[n15] - f0 * (gz + gz2);
        }
    }

    public void prepare_minim() {
        this.h = this.energy();
        this.gradients();
        for (int i = 0; i < this.natoms; ++i) {
            this.s0x[i] = this.sx[i] = -this.gradx[i];
            this.s0y[i] = this.sy[i] = -this.grady[i];
            this.s0z[i] = this.sz[i] = -this.gradz[i];
            this.grad0x[i] = this.gradx[i];
            this.grad0y[i] = this.grady[i];
            this.grad0z[i] = this.gradz[i];
        }
        this.gnorm0 = this.gnorm = Math.sqrt(this.gradbet());
    }

    public void steepest(boolean conjug) {
        int nmax = 5;
        int i200 = 1;
        while (i200 < nmax - 2 && this.gnorm > 1.0E-14) {
            double xd;
            double xc;
            double fd;
            double fc;
            double xb;
            int countl;
            double xa;
            double f1;
            int i;
            for (i = 0; i < this.natoms; ++i) {
                this.s0x[i] = this.sx[i];
                this.s0y[i] = this.sy[i];
                this.s0z[i] = this.sz[i];
            }
            this.h = this.energy();
            this.gradients();
            this.gnorm = Math.sqrt(this.gradbet());
            this.gnormd = this.gradbet2();
            if (conjug) {
                double beta = this.gnormd / (this.gnorm0 * this.gnorm0);
                for (i = 0; i < this.natoms; ++i) {
                    this.sx[i] = beta * this.s0x[i] - this.gradx[i];
                    this.sy[i] = beta * this.s0y[i] - this.grady[i];
                    this.sz[i] = beta * this.s0z[i] - this.gradz[i];
                }
            } else {
                for (i = 0; i < this.natoms; ++i) {
                    this.sx[i] = -this.gradx[i];
                    this.sy[i] = -this.grady[i];
                    this.sz[i] = -this.gradz[i];
                }
            }
            double gnorm2 = this.gradbet();
            double f0 = this.h;
            double xl = (1.0E-15 + 1.0E-14 * this.h) / gnorm2;
            if (xl > 0.0 && xl < 1.0E-8) {
                xl = 1.0E-8;
            }
            if (xl < 0.0 && xl > -1.0E-8) {
                xl = -1.0E-8;
            }
            double f2 = f1 = this.line_energy(xl);
            if (f1 > f0) {
                xa = xl;
                countl = 0;
                do {
                    xl = 0.5 * xl;
                    f1 = this.line_energy(xl);
                } while (++countl < 100 && f1 > f0);
                if (f1 > f0) break;
                xb = xl;
                if (xb < xa) {
                    xb = xa;
                    xa = xl;
                }
                do {
                    xc = (2.0 * xa + xb) / 3.0;
                    xd = (xa + 2.0 * xb) / 3.0;
                    fc = this.line_energy(xc);
                    if (fc < (fd = this.line_energy(xd))) {
                        xb = xd;
                        continue;
                    }
                    xa = xc;
                } while (Math.abs(xb - xa) > 1.0E-14 && fc != fd);
                xl = (xa + xb) / 2.0;
            } else {
                f2 = f1;
                if (f1 < f0) {
                    countl = 0;
                    do {
                        f1 = f2;
                        xl = 2.0 * xl;
                        f2 = this.line_energy(xl);
                    } while (++countl < 100 && f2 < f1);
                }
                if (xl < 0.0) {
                    xa = xl;
                    xb = xl * 0.5;
                } else {
                    xa = xl * 0.5;
                    xb = xl;
                }
                do {
                    xc = (2.0 * xa + xb) / 3.0;
                    xd = (xa + 2.0 * xb) / 3.0;
                    fc = this.line_energy(xc);
                    if (fc < (fd = this.line_energy(xd))) {
                        xb = xd;
                        continue;
                    }
                    xa = xc;
                } while (Math.abs(xb - xa) > 1.0E-14 && fc != fd);
                xl = (xa + xb) / 2.0;
            }
            this.linestep(xl);
            for (i = 0; i < this.natoms; ++i) {
                this.grad0x[i] = this.gradx[i];
                this.grad0y[i] = this.grady[i];
                this.grad0z[i] = this.gradz[i];
            }
            this.gnorm0 = this.gnorm;
            this.h = this.energy();
            this.gradients();
            this.jLabel4.setText(" Energy:  " + this.energy());
            this.jLabel3.setText(" RMS grad: " + Math.sqrt(this.gradbet()));
            ++i200;
            ++this.countsteps;
            this.jLabel1.setText("steps " + this.countsteps);
        }
        boolean ix = false;
        this.h = this.energy();
        this.lastgrad = this.gnorm = Math.sqrt(this.gradbet());
        this.lasth = this.h;
        this.copycoo();
    }

    public void linestep(double step) {
        for (int i = 0; i < this.natoms; ++i) {
            int n = i;
            this.xc[n] = this.xc[n] + this.sx[i] * step;
            int n2 = i;
            this.yc[n2] = this.yc[n2] + this.sy[i] * step;
            int n3 = i;
            this.zc[n3] = this.zc[n3] + this.sz[i] * step;
        }
        this.linepos += step;
    }

    public void followgrad() {
        double fm;
        double stepsize0 = 1.0E-8;
        int count = 0;
        double stepsize = 1.0E-6;
        for (int i = 0; i < this.natoms; ++i) {
            this.sx[i] = -this.gradx[i];
            this.sy[i] = -this.grady[i];
            this.sz[i] = -this.gradz[i];
        }
        do {
            this.linestep(stepsize);
            fm = this.analytgrad();
            stepsize *= 2.0;
            ++count;
            if (!(fm > 0.0)) continue;
        } while (fm < 0.0 && count < 20);
        double right = this.linepos;
        double left = this.linepos - stepsize * 0.5;
        double fl = -1.0;
        double fr = 1.0;
        this.linestep(-0.25 * stepsize);
        count = 0;
        do {
            double step;
            if ((fm = this.analytgrad() * 1.0E7) < 0.0) {
                step = 0.25 * (right - left);
                left = this.linepos;
                this.linestep(step);
            } else {
                step = -0.25 * (right - left);
                right = this.linepos;
                this.linestep(step);
            }
            this.gradients();
        } while (++count < 30 && Math.abs(fm) > 1.0E-8);
    }

    public void conjgrad() {
        double fm;
        int i;
        double stepsize0 = 1.0E-8;
        int count = 0;
        double stepsize = 1.0E-6;
        if (this.isfirst) {
            this.gbetold = 0.0;
            this.isfirst = false;
            this.gradients();
            this.gbetold = this.gbet = this.gradbet();
            for (i = 0; i < this.natoms; ++i) {
                this.s0x[i] = this.sx[i] = -this.gradx[i];
                this.s0y[i] = this.sy[i] = -this.grady[i];
                this.s0z[i] = this.sz[i] = -this.gradz[i];
            }
        } else {
            double beta = 0.0;
            for (i = 0; i < this.natoms; ++i) {
                beta += this.gradx[i] * (this.gradx[i] + this.s0x[i]) + this.grady[i] * (this.grady[i] + this.s0y[i]) + this.gradz[i] * (this.gradz[i] + this.s0z[i]);
            }
            double deold = beta;
            beta /= this.gbetold;
            for (i = 0; i < this.natoms; ++i) {
                this.sx[i] = beta * this.sx[i] - this.gradx[i];
                this.sy[i] = beta * this.sy[i] - this.grady[i];
                this.sz[i] = beta * this.sz[i] - this.gradz[i];
            }
        }
        for (i = 0; i < this.natoms; ++i) {
            this.s0x[i] = -this.gradx[i];
            this.s0y[i] = -this.grady[i];
            this.s0z[i] = -this.gradz[i];
        }
        this.gbetold = this.gbet;
        do {
            this.linestep(stepsize);
            fm = this.analytgrad();
            stepsize *= 2.0;
            ++count;
            if (!(fm > 0.0)) continue;
        } while (fm < 0.0 && count < 20);
        double right = this.linepos;
        double left = this.linepos - stepsize * 0.5;
        double fl = -1.0;
        double fr = 1.0;
        this.linestep(-0.25 * stepsize);
        count = 0;
        do {
            double step;
            if ((fm = this.analytgrad() * 1.0E7) < 0.0) {
                step = 0.25 * (right - left);
                left = this.linepos;
                this.linestep(step);
            } else {
                step = -0.25 * (right - left);
                right = this.linepos;
                this.linestep(step);
            }
            this.gradients();
            this.gbet = this.gradbet();
        } while (++count < 30 && Math.abs(fm) > 1.0E-8);
    }

    public double numgrad() {
        double stepsize0 = 1.0E-8;
        this.linestep(-stepsize0);
        double e1 = this.energy();
        this.linestep(2.0 * stepsize0);
        double e2 = this.energy();
        double ng = e2 - e1;
        this.linestep(-stepsize0);
        double ag = this.analytgrad() * 2.0 * stepsize0;
        this.jTextArea3.append(" " + ng + "  " + ag + "\n");
        return ng;
    }

    public double analytgrad() {
        this.gradients();
        double s = 0.0;
        for (int i = 0; i < this.natoms; ++i) {
            s += this.gradx[i] * this.sx[i] + this.grady[i] * this.sy[i] + this.gradz[i] * this.sz[i];
        }
        return s;
    }

    public double gradbet() {
        double s = 0.0;
        for (int i = 0; i < this.natoms; ++i) {
            s = s + this.gradx[i] * this.gradx[i] + this.grady[i] * this.grady[i] + this.gradz[i] * this.gradz[i];
        }
        return s;
    }

    public double gradbet2() {
        double s = 0.0;
        for (int i = 0; i < this.natoms; ++i) {
            s = s + this.gradx[i] * (this.gradx[i] - this.grad0x[i]) + this.grady[i] * (this.grady[i] - this.grad0y[i]) + this.gradz[i] * (this.gradz[i] - this.grad0z[i]);
        }
        return s;
    }

    public double maxgrad() {
        double m = 0.0;
        for (int i = 0; i < this.natoms; ++i) {
            if (Math.abs(this.gradx[i]) > m) {
                m = Math.abs(this.gradx[i]);
            }
            if (Math.abs(this.grady[i]) > m) {
                m = Math.abs(this.grady[i]);
            }
            if (!(Math.abs(this.gradz[i]) > m)) continue;
            m = Math.abs(this.gradz[i]);
        }
        return m;
    }

    public double eshift(int n, int c, double dx) {
        double e = 0.0;
        switch (c) {
            case 0: {
                int n2 = n;
                this.xc[n2] = this.xc[n2] + dx;
                e = this.energy();
                int n3 = n;
                this.xc[n3] = this.xc[n3] - dx;
                break;
            }
            case 1: {
                int n4 = n;
                this.yc[n4] = this.yc[n4] + dx;
                e = this.energy();
                int n5 = n;
                this.yc[n5] = this.yc[n5] - dx;
                break;
            }
            case 2: {
                int n6 = n;
                this.zc[n6] = this.zc[n6] + dx;
                e = this.energy();
                int n7 = n;
                this.zc[n7] = this.zc[n7] - dx;
            }
        }
        return e;
    }

    public double eshift12(int n, int c, int n2, int c2, double dx, double dy) {
        int sel = 0;
        double e = 0.0;
        sel = c * 3 + c2;
        switch (sel) {
            case 0: {
                int n3 = n;
                this.xc[n3] = this.xc[n3] + dx;
                int n4 = n2;
                this.xc[n4] = this.xc[n4] + dy;
                e = this.energy();
                int n5 = n;
                this.xc[n5] = this.xc[n5] - dx;
                int n6 = n2;
                this.xc[n6] = this.xc[n6] - dy;
                break;
            }
            case 1: {
                int n7 = n;
                this.xc[n7] = this.xc[n7] + dx;
                int n8 = n2;
                this.yc[n8] = this.yc[n8] + dy;
                e = this.energy();
                int n9 = n;
                this.xc[n9] = this.xc[n9] - dx;
                int n10 = n2;
                this.yc[n10] = this.yc[n10] - dy;
                break;
            }
            case 2: {
                int n11 = n;
                this.xc[n11] = this.xc[n11] + dx;
                int n12 = n2;
                this.zc[n12] = this.zc[n12] + dy;
                e = this.energy();
                int n13 = n;
                this.xc[n13] = this.xc[n13] - dx;
                int n14 = n2;
                this.zc[n14] = this.zc[n14] - dy;
                break;
            }
            case 3: {
                int n15 = n;
                this.yc[n15] = this.yc[n15] + dx;
                int n16 = n2;
                this.xc[n16] = this.xc[n16] + dy;
                e = this.energy();
                int n17 = n;
                this.yc[n17] = this.yc[n17] - dx;
                int n18 = n2;
                this.xc[n18] = this.xc[n18] - dy;
                break;
            }
            case 4: {
                int n19 = n;
                this.yc[n19] = this.yc[n19] + dx;
                int n20 = n2;
                this.yc[n20] = this.yc[n20] + dy;
                e = this.energy();
                int n21 = n;
                this.yc[n21] = this.yc[n21] - dx;
                int n22 = n2;
                this.yc[n22] = this.yc[n22] - dy;
                break;
            }
            case 5: {
                int n23 = n;
                this.yc[n23] = this.yc[n23] + dx;
                int n24 = n2;
                this.zc[n24] = this.zc[n24] + dy;
                e = this.energy();
                int n25 = n;
                this.yc[n25] = this.yc[n25] - dx;
                int n26 = n2;
                this.zc[n26] = this.zc[n26] - dy;
                break;
            }
            case 6: {
                int n27 = n;
                this.zc[n27] = this.zc[n27] + dx;
                int n28 = n2;
                this.xc[n28] = this.xc[n28] + dy;
                e = this.energy();
                int n29 = n;
                this.zc[n29] = this.zc[n29] - dx;
                int n30 = n2;
                this.xc[n30] = this.xc[n30] - dy;
                break;
            }
            case 7: {
                int n31 = n;
                this.zc[n31] = this.zc[n31] + dx;
                int n32 = n2;
                this.yc[n32] = this.yc[n32] + dy;
                e = this.energy();
                int n33 = n;
                this.zc[n33] = this.zc[n33] - dx;
                int n34 = n2;
                this.yc[n34] = this.yc[n34] - dy;
                break;
            }
            case 8: {
                int n35 = n;
                this.zc[n35] = this.zc[n35] + dx;
                int n36 = n2;
                this.zc[n36] = this.zc[n36] + dy;
                e = this.energy();
                int n37 = n;
                this.zc[n37] = this.zc[n37] - dx;
                int n38 = n2;
                this.zc[n38] = this.zc[n38] - dy;
            }
        }
        return e;
    }

    public void calc_H() {
        double e4;
        double e3;
        double de;
        double e2;
        double e1;
        int ind2;
        int ind1;
        int c2;
        int c1;
        int n1;
        double xstep = 1.0E-6;
        double e0 = this.energy();
        for (int i = 0; i < 3 * this.natoms; ++i) {
            for (int j = 0; j < 3 * this.natoms; ++j) {
                this.Hessian[i][j] = 0.0;
            }
        }
        for (n1 = 0; n1 < this.natoms; ++n1) {
            for (c1 = 0; c1 < 3; ++c1) {
                for (c2 = 0; c2 < 3; ++c2) {
                    ind1 = 3 * n1 + c1;
                    ind2 = 3 * n1 + c2;
                    if (ind1 == ind2) {
                        e1 = this.eshift(n1, c1, xstep);
                        e2 = this.eshift(n1, c1, -xstep);
                        de = e1 - e0 + (e2 - e0);
                        de /= xstep * xstep;
                    } else {
                        e1 = this.eshift12(n1, c1, n1, c2, xstep, xstep);
                        e2 = this.eshift12(n1, c1, n1, c2, -xstep, -xstep);
                        e3 = this.eshift12(n1, c1, n1, c2, xstep, -xstep);
                        e4 = this.eshift12(n1, c1, n1, c2, -xstep, xstep);
                        de = e1 + e2 - e3 - e4;
                        de = 0.25 * de / (xstep * xstep);
                    }
                    this.Hessian[ind1][ind2] = de;
                }
            }
        }
        for (n1 = 0; n1 < this.natoms; ++n1) {
            for (int n2 = n1 + 1; n2 < this.natoms; ++n2) {
                for (c1 = 0; c1 < 3; ++c1) {
                    for (c2 = 0; c2 < 3; ++c2) {
                        ind1 = 3 * n1 + c1;
                        ind2 = 3 * n2 + c2;
                        e1 = this.eshift12(n1, c1, n2, c2, xstep, xstep);
                        e2 = this.eshift12(n1, c1, n2, c2, -xstep, -xstep);
                        e3 = this.eshift12(n1, c1, n2, c2, xstep, -xstep);
                        e4 = this.eshift12(n1, c1, n2, c2, -xstep, xstep);
                        de = e1 + e2 - e3 - e4;
                        this.Hessian[ind1][ind2] = de = 0.25 * de / (xstep * xstep);
                        this.Hessian[ind2][ind1] = de;
                    }
                }
            }
        }
    }

    public void calc_grad() {
        double xstep = 1.0E-6;
        double e0 = this.energy();
        for (int i = 0; i < this.natoms; ++i) {
        }
        for (int n1 = 0; n1 < this.natoms; ++n1) {
            for (int c1 = 0; c1 < 3; ++c1) {
                double e1 = this.eshift(n1, c1, xstep);
                double e2 = this.eshift(n1, c1, -xstep);
                double de = e1 - e2;
                de /= xstep * 2.0;
                if (c1 == 0) {
                    this.gradx[n1] = de;
                }
                if (c1 == 1) {
                    this.grady[n1] = de;
                }
                if (c1 != 2) continue;
                this.gradz[n1] = de;
            }
        }
    }

    public void modes() {
        int i;
        int ierr = 0;
        this.calc_H();
        for (i = 0; i < this.natoms; ++i) {
            for (int j = 0; j < this.natoms; ++j) {
                for (int c1 = 0; c1 < 3; ++c1) {
                    for (int c2 = 0; c2 < 3; ++c2) {
                        int ind1 = i * 3 + c1;
                        int ind2 = j * 3 + c2;
                        double[] dArray = this.Hessian[ind1];
                        int n = ind2;
                        dArray[n] = dArray[n] / Math.sqrt(this.amass[i] * this.amass[j]);
                    }
                }
            }
        }
        i = 0;
        this.tred2(3 * this.natoms, this.Hessian, this.dvec, this.evec, this.zmat);
        i = 0;
        this.tql2(3 * this.natoms, this.dvec, this.evec, this.Hessian, ierr);
        for (i = 0; i < 3 * this.natoms; ++i) {
            if (this.dvec[i] > 0.0) {
                this.jTextArea3.append("mode" + i + "    " + ierr + " " + this.s2cm * Math.sqrt(this.fac * this.dvec[i]) + "\n");
                continue;
            }
            this.jTextArea3.append("mode" + i + " I  " + ierr + " " + this.s2cm * Math.sqrt(-this.fac * this.dvec[i]) + "\n");
        }
        this.labelmode();
        this.modes_available = true;
    }

    private void labelmode() {
        if (this.dvec[this.plotmode] > 0.0) {
            this.jLabel2.setText("" + this.plotmode + " " + this.df.format(this.s2cm * Math.sqrt(this.fac * this.dvec[this.plotmode])));
        } else {
            this.jLabel2.setText("" + this.plotmode + " I " + this.df.format(this.s2cm * Math.sqrt(-this.fac * this.dvec[this.plotmode])));
        }
    }

    public void verlet() {
        double tst2 = 4.1867469879518075E-4;
        this.gradients();
        for (int i = 0; i < this.natoms; ++i) {
            double xn = 2.0 * this.xc[i] - this.xc0[i] - this.gradx[i] * tst2 / this.amass[i];
            double yn = 2.0 * this.yc[i] - this.yc0[i] - this.grady[i] * tst2 / this.amass[i];
            double zn = 2.0 * this.zc[i] - this.zc0[i] - this.gradz[i] * tst2 / this.amass[i];
            this.xc0[i] = this.xc[i];
            this.xc[i] = xn;
            this.yc0[i] = this.yc[i];
            this.yc[i] = yn;
            this.zc0[i] = this.zc[i];
            this.zc[i] = zn;
        }
    }

    public void copycoo() {
        for (int i = 0; i < this.natoms; ++i) {
            this.xc0[i] = this.xc[i];
            this.yc0[i] = this.yc[i];
            this.zc0[i] = this.zc[i];
        }
    }

    public void stretch() {
        double x4 = this.xc[0];
        double y4 = this.yc[0];
        double z4 = this.zc[0];
        double x15 = this.xc[9];
        double y15 = this.yc[9];
        double z15 = this.zc[9];
        double dx = (x15 - x4) * 0.5;
        double dy = (y15 - y4) * 0.5;
        double dz = (z15 - z4) * 0.5;
        this.xc[9] = this.xc[9] + dx;
        this.yc[9] = this.yc[9] + dy;
        this.zc[9] = this.zc[9] + dz;
        this.copycoo();
    }

    public void stretch2() {
        double x4 = this.xc[2];
        double y4 = this.yc[2];
        double z4 = this.zc[2];
        double x15 = this.xc[6];
        double y15 = this.yc[6];
        double z15 = this.zc[6];
        double dx = (x15 - x4) * 0.3;
        double dy = (y15 - y4) * 0.3;
        double dz = (z15 - z4) * 0.3;
        this.xc[6] = this.xc[6] + dx;
        this.yc[6] = this.yc[6] + dy;
        this.zc[6] = this.zc[6] + dz;
        this.copycoo();
    }

    public void addnoise() {
        int i = 0;
        while (i < this.natoms) {
            int n = i;
            this.xc[n] = this.xc[n] + 0.2 * (Math.random() - 0.5);
            int n2 = i;
            this.yc[n2] = this.yc[n2] + 0.2 * (Math.random() - 0.5);
            int n3 = i++;
            this.zc[n3] = this.zc[n3] + 0.2 * (Math.random() - 0.5);
        }
        this.copycoo();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new myPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jToggleButton1 = new JToggleButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jLabel2 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.jButton13 = new JButton();
        this.jLabel5 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jPanel1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                NewJApplet.this.jPanel1MouseClicked(evt);
            }

            public void mousePressed(MouseEvent evt) {
                NewJApplet.this.jPanel1MousePressed(evt);
            }

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.jPanel1MouseReleased(evt);
            }
        });
        this.jPanel1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jPanel1MouseDragged(evt);
            }
        });
        this.jButton1.setText("SD");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("print zmat");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jButton3.setText("CG");
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton3ActionPerformed(evt);
            }
        });
        this.jButton4.setText("Reset");
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("calc Hessian");
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton5ActionPerformed(evt);
            }
        });
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.setText("dihedrals on");
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.jButton6.setText("dwn");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton6ActionPerformed(evt);
            }
        });
        this.jButton7.setText("up");
        this.jButton7.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton7ActionPerformed(evt);
            }
        });
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jButton8.setText("stretch");
        this.jButton8.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton8ActionPerformed(evt);
            }
        });
        this.jButton9.setText("animate modes");
        this.jButton9.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton9ActionPerformed(evt);
            }
        });
        this.jButton10.setText("Verlet");
        this.jButton10.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton10ActionPerformed(evt);
            }
        });
        this.jButton11.setText("STOP");
        this.jButton11.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton11ActionPerformed(evt);
            }
        });
        this.jButton12.setText("stretch");
        this.jButton12.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton12ActionPerformed(evt);
            }
        });
        this.jButton13.setText("rand");
        this.jButton13.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton13ActionPerformed(evt);
            }
        });
        this.jLabel5.setText("click to rotate");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 305, -2).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6)).addComponent(this.jButton9)).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton12)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton10))))).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 37, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.jToggleButton1, GroupLayout.Alignment.TRAILING)).addGap(6, 6, 6)).addGroup(jPanel1Layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton11).addComponent(this.jButton13, -2, 79, -2)).addContainerGap(-1, Short.MAX_VALUE)))).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider2, -2, 131, -2).addGroup(jPanel1Layout.createSequentialGroup().addGap(206, 206, 206).addComponent(this.jLabel5))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jButton2, this.jButton5, this.jToggleButton1);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(317, 317, 317).addComponent(this.jButton2).addGap(18, 18, 18).addComponent(this.jButton5).addGap(18, 18, 18).addComponent(this.jToggleButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2, -2, 27, -2).addGap(8, 8, 8).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton7).addComponent(this.jButton6).addComponent(this.jButton4).addComponent(this.jButton8).addComponent(this.jButton12).addComponent(this.jButton13)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton9).addComponent(this.jButton3).addComponent(this.jButton1).addComponent(this.jButton10).addComponent(this.jButton11, -1, -1, Short.MAX_VALUE)).addGap(183, 183, 183)));
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1, -2, 470, -2).addGap(0, 0, Short.MAX_VALUE)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane3, -2, 358, -2).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(19, 19, 19).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jScrollPane3).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, 571, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1))).addContainerGap(186, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.animation_mode = 3;
        this.animation = true;
        this.jButton1.setBackground(Color.red);
        this.jButton3.setBackground(Color.LIGHT_GRAY);
        this.jButton9.setBackground(Color.LIGHT_GRAY);
        this.jButton10.setBackground(Color.LIGHT_GRAY);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.zmat();
    }

    private void jPanel1MouseDragged(MouseEvent evt) {
        this.xfrom = this.xto;
        this.yfrom = this.yto;
        this.xto = evt.getX();
        this.yto = evt.getY();
        int dx = this.xto - this.xfrom;
        int dy = this.yto - this.yfrom;
        double c = Math.cos((double)dx * Math.PI / 180.0);
        double s = Math.sin((double)dx * Math.PI / 180.0);
        double a1 = c * this.xx + s * this.zx;
        double b1 = -s * this.xx + c * this.zx;
        double a2 = c * this.xz + s * this.zz;
        double b2 = -s * this.xz + c * this.zz;
        double a3 = c * this.xy + s * this.zy;
        double b3 = -s * this.xy + c * this.zy;
        this.xx = a1;
        this.xz = a2;
        this.zx = b1;
        this.zz = b2;
        this.xy = a3;
        this.zy = b3;
        c = Math.cos((double)dy * Math.PI / 180.0);
        s = Math.sin((double)dy * Math.PI / 180.0);
        a1 = c * this.yy + s * this.zy;
        b1 = -s * this.yy + c * this.zy;
        a2 = c * this.yz + s * this.zz;
        b2 = -s * this.yz + c * this.zz;
        a3 = c * this.yx + s * this.zx;
        b3 = -s * this.yx + c * this.zx;
        this.yy = a1;
        this.yz = a2;
        this.zy = b1;
        this.zz = b2;
        this.yx = a3;
        this.zx = b3;
        this.jPanel1.repaint();
    }

    private void jPanel1MouseClicked(MouseEvent evt) {
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.animation_mode = 2;
        this.animation = true;
        this.jButton1.setBackground(Color.LIGHT_GRAY);
        this.jButton3.setBackground(Color.red);
        this.jButton9.setBackground(Color.LIGHT_GRAY);
        this.jButton10.setBackground(Color.LIGHT_GRAY);
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        if (!this.animation) {
            this.isfirst = true;
            this.countsteps = 0;
            this.set_ic();
            this.prepare_minim();
            this.jPanel1.repaint();
        }
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        if (!this.animation) {
            this.modes();
        }
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.dihedrals_on = this.jToggleButton1.isSelected();
    }

    private void jButton7ActionPerformed(ActionEvent evt) {
        if (this.plotmode < 3 * this.natoms - 1) {
            ++this.plotmode;
            this.labelmode();
        }
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        if (this.plotmode > 0) {
            --this.plotmode;
            this.labelmode();
        }
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.modf = (double)this.jSlider2.getValue() * 0.01;
    }

    private void jButton8ActionPerformed(ActionEvent evt) {
        this.stretch();
    }

    private void jPanel1MouseReleased(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
    }

    private void jPanel1MousePressed(MouseEvent evt) {
        this.xto = this.xfrom = evt.getX();
        this.yto = this.yfrom = evt.getY();
    }

    private void jButton9ActionPerformed(ActionEvent evt) {
        this.animation_mode = 0;
        this.animation = true;
        this.jButton1.setBackground(Color.LIGHT_GRAY);
        this.jButton3.setBackground(Color.LIGHT_GRAY);
        this.jButton9.setBackground(Color.red);
        this.jButton10.setBackground(Color.LIGHT_GRAY);
    }

    private void jButton10ActionPerformed(ActionEvent evt) {
        this.animation_mode = 1;
        this.animation = true;
        this.jButton1.setBackground(Color.LIGHT_GRAY);
        this.jButton3.setBackground(Color.LIGHT_GRAY);
        this.jButton10.setBackground(Color.red);
        this.jButton9.setBackground(Color.LIGHT_GRAY);
    }

    private void jButton11ActionPerformed(ActionEvent evt) {
        this.animation = false;
        this.jButton1.setBackground(Color.LIGHT_GRAY);
        this.jButton3.setBackground(Color.LIGHT_GRAY);
        this.jButton9.setBackground(Color.LIGHT_GRAY);
        this.jButton10.setBackground(Color.LIGHT_GRAY);
    }

    private void jButton12ActionPerformed(ActionEvent evt) {
        this.stretch2();
    }

    private void jButton13ActionPerformed(ActionEvent evt) {
        this.addnoise();
    }

    public void tql2(int n, double[] d, double[] e, double[][] a, int ierr) {
        ierr = 0;
        if (n > 1) {
            int k;
            double p;
            int i;
            for (i = 1; i < n; ++i) {
                e[i - 1] = e[i];
            }
            double f = 0.0;
            double tst1 = 0.0;
            e[n - 1] = 0.0;
            for (int l = 0; l < n; ++l) {
                double tst2;
                int count = 0;
                double h = Math.abs(d[l]) + Math.abs(e[l]);
                if (tst1 < h) {
                    tst1 = h;
                }
                int m = l;
                boolean iterate = true;
                do {
                    if ((tst2 = tst1 + Math.abs(e[m])) == tst1) {
                        iterate = false;
                    }
                    if (m >= n - 1) {
                        iterate = false;
                    }
                    if (!iterate || m >= n - 1) continue;
                    ++m;
                } while (iterate);
                if (m > l) {
                    count = 0;
                    iterate = true;
                    do {
                        double c;
                        ++count;
                        double g = d[l];
                        p = (d[l + 1] - g) / (2.0 * e[l]);
                        double r = this.pythag(p, 1.0);
                        d[l] = e[l] / (p + Math.copySign(r, p));
                        d[l + 1] = e[l] * (p + Math.copySign(r, p));
                        double dl1 = d[l + 1];
                        h = g - d[l];
                        i = l + 2;
                        while (i < n) {
                            int n2 = i++;
                            d[n2] = d[n2] - h;
                        }
                        f += h;
                        p = d[m];
                        double c2 = c = 1.0;
                        double c3 = c;
                        double el1 = e[l + 1];
                        double s = 0.0;
                        double s2 = 0.0;
                        for (i = m - 1; i >= l; --i) {
                            c3 = c2;
                            c2 = c;
                            s2 = s;
                            g = c * e[i];
                            h = c * p;
                            r = this.pythag(p, e[i]);
                            e[i + 1] = s * r;
                            s = e[i] / r;
                            c = p / r;
                            p = c * d[i] - s * g;
                            d[i + 1] = h + s * (c * g + s * d[i]);
                            for (k = 0; k < n; ++k) {
                                h = a[k][i + 1];
                                a[k][i + 1] = s * a[k][i] + c * h;
                                a[k][i] = c * a[k][i] - s * h;
                            }
                        }
                        p = -s * s2 * c3 * el1 * e[l] / dl1;
                        e[l] = s * p;
                        d[l] = c * p;
                        tst2 = tst1 + Math.abs(e[l]);
                        if (tst2 <= tst1) {
                            iterate = false;
                        }
                        if (count < 30) continue;
                        iterate = false;
                    } while (iterate);
                    if (count >= 30) {
                        ierr = l;
                        break;
                    }
                }
                d[l] = d[l] + f;
                e[l] = 0.0;
            }
            for (i = 0; i < n - 1; ++i) {
                int j;
                k = i;
                p = d[i];
                for (j = i + 1; j < n; ++j) {
                    if (!(d[j] < p)) continue;
                    k = j;
                    p = d[j];
                }
                if (k == i) continue;
                d[k] = d[i];
                d[i] = p;
                for (j = 0; j < n; ++j) {
                    p = a[j][i];
                    a[j][i] = a[j][k];
                    a[j][k] = p;
                }
            }
        }
    }

    private double pythag(double x, double y) {
        double r = Math.sqrt(x * x + y * y);
        return r;
    }

    public void tred2(int n, double[][] a, double[] d, double[] e, double[][] z) {
        int i;
        for (i = 0; i < n; ++i) {
            d[i] = a[n - 1][i];
        }
        if (n > 1) {
            double g;
            int j;
            int k;
            double h;
            for (i = n - 1; i > 0; --i) {
                h = 0.0;
                double scale = 0.0;
                for (k = 0; k < i; ++k) {
                    scale += Math.abs(d[k]);
                }
                if (scale == 0.0) {
                    e[i] = d[i - 1];
                    for (j = 0; j < i; ++j) {
                        d[j] = a[i - 1][j];
                        a[i][j] = 0.0;
                        a[j][i] = 0.0;
                    }
                } else {
                    for (k = 0; k < i; ++k) {
                        d[k] = d[k] / scale;
                        h += d[k] * d[k];
                    }
                    double f = d[i - 1];
                    g = Math.sqrt(h);
                    if (f > 0.0) {
                        g = -g;
                    }
                    e[i] = scale * g;
                    h -= f * g;
                    d[i - 1] = f - g;
                    for (j = 0; j < i; ++j) {
                        e[j] = 0.0;
                    }
                    for (j = 0; j < i; ++j) {
                        a[j][i] = f = d[j];
                        g = e[j] + a[j][j] * f;
                        for (k = j + 1; k < i; ++k) {
                            g += a[k][j] * d[k];
                            e[k] = e[k] + a[k][j] * f;
                        }
                        e[j] = g;
                    }
                    f = 0.0;
                    for (j = 0; j < i; ++j) {
                        e[j] = e[j] / h;
                        f += e[j] * d[j];
                    }
                    double hh = f / (h + h);
                    for (j = 0; j < i; ++j) {
                        e[j] = e[j] - hh * d[j];
                    }
                    for (j = 0; j < i; ++j) {
                        f = d[j];
                        g = e[j];
                        for (k = j; k < i; ++k) {
                            a[k][j] = a[k][j] - f * e[k] - g * d[k];
                        }
                        d[j] = a[i - 1][j];
                        a[i][j] = 0.0;
                    }
                }
                d[i] = h;
            }
            for (i = 0; i < n - 1; ++i) {
                a[n - 1][i] = a[i][i];
                a[i][i] = 1.0;
                h = d[i + 1];
                if (h != 0.0) {
                    for (k = 0; k <= i; ++k) {
                        d[k] = a[k][i + 1] / h;
                    }
                    for (j = 0; j <= i; ++j) {
                        g = 0.0;
                        for (k = 0; k <= i; ++k) {
                            g += a[k][i + 1] * a[k][j];
                        }
                        for (k = 0; k <= i; ++k) {
                            a[k][j] = a[k][j] - g * d[k];
                        }
                    }
                }
                for (k = 0; k <= i; ++k) {
                    a[k][i + 1] = 0.0;
                }
            }
        }
        for (i = 0; i < n; ++i) {
            d[i] = a[n - 1][i];
            a[n - 1][i] = 0.0;
        }
        a[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    public class myPanel
    extends JPanel {
        int i;
        int ia;
        int ix1;
        int ix2;
        int iy1;
        int iy2;
        int n1;
        int n2;
        double stepsize = 1.0E-6;
        double en;
        double energy_0;
        double mg;
        double cz;
        double sz;
        int ixor = 230;
        int iyor = 210;

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.mg = NewJApplet.this.maxgrad();
            this.cz = Math.cos(NewJApplet.this.rotz * Math.PI / 180.0);
            this.sz = Math.sin(NewJApplet.this.rotz * Math.PI / 180.0);
            if (NewJApplet.this.animation && NewJApplet.this.animation_mode == 0) {
                this.i = 0;
                while (this.i < NewJApplet.this.nbonds) {
                    this.n1 = NewJApplet.this.bondats[this.i][0];
                    this.n2 = NewJApplet.this.bondats[this.i][1];
                    this.ix1 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xcc[this.n1] + NewJApplet.this.xy * NewJApplet.this.ycc[this.n1] + NewJApplet.this.xz * NewJApplet.this.zcc[this.n1]));
                    this.iy1 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xcc[this.n1] + NewJApplet.this.yy * NewJApplet.this.ycc[this.n1] + NewJApplet.this.yz * NewJApplet.this.zcc[this.n1]));
                    this.ix2 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xcc[this.n2] + NewJApplet.this.xy * NewJApplet.this.ycc[this.n2] + NewJApplet.this.xz * NewJApplet.this.zcc[this.n2]));
                    this.iy2 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xcc[this.n2] + NewJApplet.this.yy * NewJApplet.this.ycc[this.n2] + NewJApplet.this.yz * NewJApplet.this.zcc[this.n2]));
                    g.drawLine(this.ix1 + this.ixor, this.iy1 + this.iyor, this.ix2 + this.ixor, this.iy2 + this.iyor);
                    ++this.i;
                }
                this.i = 0;
                while (this.i < NewJApplet.this.natoms) {
                    this.ix1 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xcc[this.i] + NewJApplet.this.xy * NewJApplet.this.ycc[this.i] + NewJApplet.this.xz * NewJApplet.this.zcc[this.i]));
                    this.iy1 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xcc[this.i] + NewJApplet.this.yy * NewJApplet.this.ycc[this.i] + NewJApplet.this.yz * NewJApplet.this.zcc[this.i]));
                    if (NewJApplet.this.nat[this.i] == 8) {
                        g.setColor(Color.red);
                    }
                    if (NewJApplet.this.nat[this.i] == 7) {
                        g.setColor(Color.blue);
                    }
                    if (NewJApplet.this.nat[this.i] == 6) {
                        g.setColor(Color.green);
                    }
                    if (NewJApplet.this.nat[this.i] == 1) {
                        g.setColor(Color.black);
                    }
                    g.fillOval(this.ix1 + this.ixor - 5, this.iy1 + this.iyor - 5, 10, 10);
                    ++this.i;
                }
            } else {
                this.i = 0;
                while (this.i < NewJApplet.this.nbonds) {
                    this.n1 = NewJApplet.this.bondats[this.i][0];
                    this.n2 = NewJApplet.this.bondats[this.i][1];
                    this.ix1 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xc[this.n1] + NewJApplet.this.xy * NewJApplet.this.yc[this.n1] + NewJApplet.this.xz * NewJApplet.this.zc[this.n1]));
                    this.iy1 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xc[this.n1] + NewJApplet.this.yy * NewJApplet.this.yc[this.n1] + NewJApplet.this.yz * NewJApplet.this.zc[this.n1]));
                    this.ix2 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xc[this.n2] + NewJApplet.this.xy * NewJApplet.this.yc[this.n2] + NewJApplet.this.xz * NewJApplet.this.zc[this.n2]));
                    this.iy2 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xc[this.n2] + NewJApplet.this.yy * NewJApplet.this.yc[this.n2] + NewJApplet.this.yz * NewJApplet.this.zc[this.n2]));
                    g.drawLine(this.ix1 + this.ixor, this.iy1 + this.iyor, this.ix2 + this.ixor, this.iy2 + this.iyor);
                    ++this.i;
                }
                this.i = 0;
                while (this.i < NewJApplet.this.natoms) {
                    this.ix1 = (int)(50.0 * (NewJApplet.this.xx * NewJApplet.this.xc[this.i] + NewJApplet.this.xy * NewJApplet.this.yc[this.i] + NewJApplet.this.xz * NewJApplet.this.zc[this.i]));
                    this.iy1 = (int)(50.0 * (NewJApplet.this.yx * NewJApplet.this.xc[this.i] + NewJApplet.this.yy * NewJApplet.this.yc[this.i] + NewJApplet.this.yz * NewJApplet.this.zc[this.i]));
                    if (NewJApplet.this.nat[this.i] == 8) {
                        g.setColor(Color.red);
                    }
                    if (NewJApplet.this.nat[this.i] == 7) {
                        g.setColor(Color.blue);
                    }
                    if (NewJApplet.this.nat[this.i] == 6) {
                        g.setColor(Color.green);
                    }
                    if (NewJApplet.this.nat[this.i] == 1) {
                        g.setColor(Color.black);
                    }
                    g.fillOval(this.ix1 + this.ixor - 5, this.iy1 + this.iyor - 5, 10, 10);
                    ++this.i;
                }
            }
        }
    }
}

