/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Ellipse2D;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    DecimalFormat df2;
    Timer timer;
    int loops = 25000;
    int loops_i = 100;
    int NMAX = 1000;
    int size = 300;
    int POINTS = 5;
    int NHISTO = 300;
    int NCORR = 300;
    int meastype = 0;
    double DISTANCE = 4.5;
    double TEMP_0 = 100.0;
    double mass = 12.5;
    double vdwe = 8.5E-22;
    double vdws = 2.95;
    double dvdwmin2 = 100.0;
    double TIMESTEP = 5.0E-4;
    double BOXSIZE = 50.0;
    double NEW_BOXSIZE = 50.0;
    double vscale = 0.1;
    double[] xc;
    double[] yc;
    double[] zc;
    double[] vx;
    double[] vy;
    double[] vz;
    double[] xc0;
    double[] yc0;
    double[] zc0;
    double[] vx0;
    double[] vy0;
    double[] vz0;
    double[] xcold;
    double[] ycold;
    double[] zcold;
    double[] dxc;
    double[] dyc;
    double[] dzc;
    double[] dvx;
    double[] dvy;
    double[] dvz;
    double[] ax0;
    double[] ay0;
    double[] az0;
    double[] ax1;
    double[] ay1;
    double[] az1;
    double[] axm1;
    double[] aym1;
    double[] azm1;
    double pressav;
    double ktav;
    double pvs;
    double viri;
    double virisum;
    double virav;
    double vv0;
    int i;
    int j;
    int k;
    int iloop;
    int il2;
    int count1;
    int countall;
    int ia;
    int collected;
    int coll2;
    int[] histo;
    double[] corrf;
    double vdws6;
    double vdws12;
    double fox;
    double foy;
    double foz;
    double ekin;
    double epot;
    double etot;
    double temper;
    double ttime;
    double tsf;
    double DEkin;
    double epot_0;
    double ekin_0;
    double pressure;
    double vmol;
    double densty;
    int NATOMS;
    boolean equilibrate = true;
    boolean showhisto = false;
    boolean showdist = false;
    boolean showvcor = false;
    boolean showxsq = false;
    private JToggleButton equilbutton;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSlider jSlider1;
    private JSlider jSlider2;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.xc = new double[this.NMAX];
        this.yc = new double[this.NMAX];
        this.zc = new double[this.NMAX];
        this.xcold = new double[this.NMAX];
        this.ycold = new double[this.NMAX];
        this.zcold = new double[this.NMAX];
        this.xc0 = new double[this.NMAX];
        this.yc0 = new double[this.NMAX];
        this.zc0 = new double[this.NMAX];
        this.dxc = new double[this.NMAX];
        this.dyc = new double[this.NMAX];
        this.dzc = new double[this.NMAX];
        this.vx = new double[this.NMAX];
        this.vy = new double[this.NMAX];
        this.vz = new double[this.NMAX];
        this.vx0 = new double[this.NMAX];
        this.vy0 = new double[this.NMAX];
        this.vz0 = new double[this.NMAX];
        this.dvx = new double[this.NMAX];
        this.dvy = new double[this.NMAX];
        this.dvz = new double[this.NMAX];
        this.ax0 = new double[this.NMAX];
        this.ay0 = new double[this.NMAX];
        this.az0 = new double[this.NMAX];
        this.ax1 = new double[this.NMAX];
        this.ay1 = new double[this.NMAX];
        this.az1 = new double[this.NMAX];
        this.axm1 = new double[this.NMAX];
        this.aym1 = new double[this.NMAX];
        this.azm1 = new double[this.NMAX];
        this.histo = new int[this.NHISTO];
        this.corrf = new double[this.NCORR];
        this.vdws6 = this.vdws * this.vdws * this.vdws * this.vdws * this.vdws * this.vdws;
        this.vdws12 = this.vdws6 * this.vdws6;
        this.tsf = this.TIMESTEP * 1.0E-14 / 1.66E-27;
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("00.000");
        this.df2 = new DecimalFormat("0.0");
        this.reset_all();
        this.jPanel1.repaint();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.count1 >= this.loops) {
            return;
        }
        this.jPanel1.repaint();
        this.timer.restart();
    }

    public void reset_all() {
        this.ttime = 0.0;
        this.DISTANCE = this.BOXSIZE / 5.0;
        this.set_coord();
        this.set_velocities();
        this.set_accel();
        this.vmol = this.BOXSIZE / (double)this.POINTS;
        this.vmol = 1.0E-30 * this.vmol * this.vmol * this.vmol;
        this.densty = this.mass * 1.6E-27 / this.vmol;
        this.reset_counters();
        this.timer = new Timer(1, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
        this.equilbutton.setSelected(true);
        this.jSlider1.setValue((int)(this.TEMP_0 * 0.25));
        this.jSlider2.setValue((int)(this.BOXSIZE * 2.0));
        this.jLabel12.setText("T0=" + this.TEMP_0);
        this.jLabel13.setText("BOX=" + this.BOXSIZE);
    }

    public void reset_counters() {
        this.epot_0 = 0.0;
        this.ekin_0 = 0.0;
        this.pressav = 0.0;
        this.ktav = 0.0;
        this.virav = 0.0;
        this.count1 = 0;
        this.countall = 0;
        this.collected = 0;
        this.coll2 = 0;
        this.ttime = 0.0;
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel14 = new JLabel();
        this.jLabel15 = new JLabel();
        this.jPanel3 = new JPanel();
        this.equilbutton = new JToggleButton();
        this.jLabel12 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSlider2 = new JSlider();
        this.jLabel13 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(350, 550));
        this.jPanel1.setMinimumSize(new Dimension(350, 550));
        this.jPanel1.setPreferredSize(new Dimension(350, 550));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 367, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 548, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(120, 550));
        this.jPanel2.setMinimumSize(new Dimension(120, 550));
        this.jPanel2.setPreferredSize(new Dimension(120, 550));
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("jLabel2");
        this.jLabel3.setText("jLabel3");
        this.jLabel4.setText("jLabel4");
        this.jLabel5.setText("jLabel5");
        this.jLabel6.setText("jLabel6");
        this.jLabel7.setText("jLabel7");
        this.jLabel8.setText("jLabel8");
        this.jLabel9.setText("jLabel8");
        this.jLabel10.setText("jLabel8");
        this.jLabel11.setText("Label11");
        this.jLabel14.setText("jLabel14");
        this.jLabel15.setText("jLabel15");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2).addComponent(this.jLabel7).addComponent(this.jLabel5).addComponent(this.jLabel4).addComponent(this.jLabel11).addComponent(this.jLabel10).addComponent(this.jLabel8).addComponent(this.jLabel3).addComponent(this.jLabel14).addComponent(this.jLabel15).addComponent(this.jLabel6).addComponent(this.jLabel9)).addContainerGap(106, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(23, 23, 23).addComponent(this.jLabel1).addGap(19, 19, 19).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel8).addGap(18, 18, 18).addComponent(this.jLabel10).addGap(18, 18, 18).addComponent(this.jLabel11).addGap(42, 42, 42).addComponent(this.jLabel4).addGap(18, 18, 18).addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jLabel7).addGap(18, 18, 18).addComponent(this.jLabel2).addGap(18, 18, 18).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 65, Short.MAX_VALUE).addComponent(this.jLabel6).addGap(40, 40, 40).addComponent(this.jLabel14).addGap(18, 18, 18).addComponent(this.jLabel15).addGap(20, 20, 20)));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel3.setMaximumSize(new Dimension(Short.MAX_VALUE, 550));
        this.jPanel3.setMinimumSize(new Dimension(0, 550));
        this.equilbutton.setText("Thermostat");
        this.equilbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.equilbuttonActionPerformed(evt);
            }
        });
        this.jLabel12.setText("jLabel1");
        this.jSlider1.setMaximum(200);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jButton1.setText("Reset av");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Restart");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jLabel13.setText("jLabel1");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"nothing", "velocities", "distances", "vcorrel", "xsquare"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.equilbutton)).addGroup(jPanel3Layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jLabel12)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton1, -2, 105, -2)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jButton2)).addComponent(this.jSlider1, -2, 125, -2).addComponent(this.jSlider2, -2, 125, -2).addGroup(jPanel3Layout.createSequentialGroup().addGap(42, 42, 42).addComponent(this.jLabel13)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE))).addGap(24, 24, 24)));
        jPanel3Layout.linkSize(0, this.equilbutton, this.jButton1, this.jButton2);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.equilbutton).addGap(18, 18, 18).addComponent(this.jLabel12).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(44, 44, 44).addComponent(this.jButton1).addGap(43, 43, 43).addComponent(this.jButton2).addGap(32, 32, 32).addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, 24, -2).addGap(37, 37, 37).addComponent(this.jComboBox1, -2, -1, -2).addContainerGap(181, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 369, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 173, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel3, -2, -1, -2).addContainerGap(385, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE)).addContainerGap(206, Short.MAX_VALUE)));
        layout.linkSize(1, this.jPanel1, this.jPanel2, this.jPanel3);
    }

    private void equilbuttonActionPerformed(ActionEvent evt) {
        this.equilibrate = this.equilbutton.isSelected();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.TEMP_0 = (double)this.jSlider1.getValue() * 5.0;
        this.jLabel12.setText("T0=" + this.TEMP_0);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reset_counters();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.reset_all();
        this.jPanel1.repaint();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.BOXSIZE = (double)this.jSlider2.getValue() * 0.5;
        this.jLabel13.setText("BOX=" + this.BOXSIZE);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.meastype = this.jComboBox1.getSelectedIndex();
        this.showhisto = this.meastype == 1;
        this.showdist = this.meastype == 2;
        this.showvcor = this.meastype == 3;
        this.showxsq = this.meastype == 4;
        this.collected = 0;
        this.coll2 = 0;
    }

    void vel_corr() {
        int i;
        if (this.collected == 0) {
            for (i = 0; i < this.NATOMS; ++i) {
                this.vx0[i] = this.vx[i];
            }
            this.vy0[i] = this.vy[i];
            this.vz0[i] = this.vz[i];
        }
        if (this.collected >= 0 && this.collected < this.NCORR) {
            double vv = 0.0;
            for (i = 0; i < this.NATOMS; ++i) {
                vv = vv + this.vx[i] * this.vx0[i] + this.vy[i] * this.vy0[i] + this.vz[i] * this.vz0[i];
            }
            int n = this.collected;
            this.corrf[n] = this.corrf[n] + vv;
        }
    }

    void x_sq() {
        int i;
        if (this.collected == 0) {
            for (i = 0; i < this.NATOMS; ++i) {
                this.xc0[i] = this.xc[i];
                this.yc0[i] = this.yc[i];
                this.zc0[i] = this.zc[i];
            }
        }
        if (this.collected >= 0 && this.collected < this.NCORR) {
            for (i = 0; i < this.NATOMS; ++i) {
                double dx = this.xc[i] - this.xc0[i];
                double dy = this.yc[i] - this.yc0[i];
                double dz = this.zc[i] - this.zc0[i];
                double xsq = dx * dx + dy * dy + dz * dz;
                int n = this.collected;
                this.corrf[n] = this.corrf[n] + xsq;
            }
        }
    }

    void vel_histo() {
        for (int i = 0; i < this.NATOMS; ++i) {
            double vabs = Math.sqrt(this.vx[i] * this.vx[i] + this.vy[i] * this.vy[i] + this.vz[i] * this.vz[i]);
            int index = (int)(vabs / this.vscale);
            if (index < 0 || index >= this.NHISTO) continue;
            int n = index;
            this.histo[n] = this.histo[n] + 1;
        }
    }

    void dist_histo() {
        for (int i = 0; i < this.NATOMS; ++i) {
            for (int j = i + 1; j < this.NATOMS; ++j) {
                double dx = this.xc[i] - this.xc[j];
                double dy = this.yc[i] - this.yc[j];
                double dz = this.zc[i] - this.zc[j];
                double rij = Math.sqrt(dx * dx + dy * dy + dz * dz);
                int index = (int)(rij * 20.0);
                if (index < 0 || index >= this.NHISTO) continue;
                int n = index;
                this.histo[n] = this.histo[n] + 1;
            }
        }
    }

    int vdwforce(int i, int j) {
        int notzero;
        double dx = this.xc[i] - this.xc[j];
        double dy = this.yc[i] - this.yc[j];
        double dz = this.zc[i] - this.zc[j];
        double d2 = dx * dx + dy * dy + dz * dz;
        if (d2 < 0.09) {
            d2 = 0.09;
        }
        if (d2 < this.dvdwmin2) {
            double d6 = d2 * d2 * d2;
            double d8 = d6 * d2;
            double d14 = d6 * d6 * d2;
            double fac12 = 4.8E11 * this.vdwe * this.vdws12 / d14;
            double fac6 = -2.4E11 * this.vdwe * this.vdws6 / d8;
            double facall = fac6 + fac12;
            this.fox = facall * dx;
            this.foy = facall * dy;
            this.foz = facall * dz;
            notzero = 1;
        } else {
            notzero = 0;
            this.fox = 0.0;
            this.foy = 0.0;
            this.foz = 0.0;
        }
        return notzero;
    }

    double vdwen(int i, int j) {
        double dx = this.xc[i] - this.xc[j];
        double dy = this.yc[i] - this.yc[j];
        double dz = this.zc[i] - this.zc[j];
        double d2 = dx * dx + dy * dy + dz * dz;
        if (d2 < 0.09) {
            d2 = 0.09;
        }
        if (d2 < this.dvdwmin2) {
            double d6 = d2 * d2 * d2;
            double d12 = d6 * d6;
            double fac12 = 4.0 * this.vdwe * this.vdws12 / d12;
            double fac6 = -4.0 * this.vdwe * this.vdws6 / d6;
            double facall = fac6 + fac12;
            return facall;
        }
        return 0.0;
    }

    double vdwsum() {
        double sum = 0.0;
        for (int i = 0; i < this.NATOMS - 1; ++i) {
            for (int j = i + 1; j < this.NATOMS; ++j) {
                sum += this.vdwen(i, j);
            }
        }
        return sum;
    }

    void set_coord() {
        int i;
        double xm = 0.0;
        double ym = 0.0;
        double zm = 0.0;
        this.NATOMS = 0;
        for (i = 0; i < this.POINTS; ++i) {
            for (int j = 0; j < this.POINTS; ++j) {
                for (int k = 0; k < this.POINTS; ++k) {
                    if (this.NATOMS < this.NMAX) {
                        this.xc[this.NATOMS] = (double)i * this.DISTANCE;
                        this.yc[this.NATOMS] = (double)j * this.DISTANCE;
                        this.zc[this.NATOMS] = (double)k * this.DISTANCE;
                        xm += this.xc[this.NATOMS];
                        ym += this.yc[this.NATOMS];
                        zm += this.zc[this.NATOMS];
                    } else {
                        this.stop();
                    }
                    ++this.NATOMS;
                }
            }
        }
        xm /= (double)this.NATOMS;
        ym /= (double)this.NATOMS;
        zm /= (double)this.NATOMS;
        for (i = 0; i < this.NATOMS; ++i) {
            this.xc[i] = this.xc[i] - xm;
            this.yc[i] = this.yc[i] - ym;
            this.zc[i] = this.zc[i] - zm;
        }
    }

    double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    void set_velocities() {
        double vterm = Math.sqrt(this.TEMP_0 * 1.38 / (1.66 * this.mass));
        for (int i = 0; i < this.NATOMS; ++i) {
            this.vx[i] = vterm * this.randgauss();
            this.vy[i] = vterm * this.randgauss();
            this.vz[i] = vterm * this.randgauss();
            this.xcold[i] = this.xc[i] - this.vx[i] * this.TIMESTEP;
            this.ycold[i] = this.yc[i] - this.vy[i] * this.TIMESTEP;
            this.zcold[i] = this.zc[i] - this.vz[i] * this.TIMESTEP;
        }
    }

    void set_accel() {
        for (int i = 0; i < this.NATOMS; ++i) {
            double foxs = 0.0;
            double foys = 0.0;
            double fozs = 0.0;
            for (int j = 0; j < this.NATOMS; ++j) {
                int notzero;
                if (i == j || (notzero = this.vdwforce(i, j)) != 1) continue;
                foxs += this.fox;
                foys += this.foy;
                fozs += this.foz;
            }
            this.ax0[i] = this.axm1[i] = foxs * this.tsf / this.mass;
            this.ax1[i] = this.axm1[i];
            this.ay0[i] = this.aym1[i] = foys * this.tsf / this.mass;
            this.ay1[i] = this.aym1[i];
            this.az0[i] = this.azm1[i] = fozs * this.tsf / this.mass;
            this.az1[i] = this.azm1[i];
        }
    }

    void beeman() {
        int i;
        for (i = 0; i < this.NATOMS; ++i) {
            this.dxc[i] = this.vx[i] * this.TIMESTEP + (4.0 * this.ax0[i] - this.axm1[i]) * this.TIMESTEP / 6.0;
            this.dyc[i] = this.vy[i] * this.TIMESTEP + (4.0 * this.ay0[i] - this.aym1[i]) * this.TIMESTEP / 6.0;
            this.dzc[i] = this.vz[i] * this.TIMESTEP + (4.0 * this.az0[i] - this.azm1[i]) * this.TIMESTEP / 6.0;
            this.xc[i] = this.xc[i] + this.dxc[i];
            this.yc[i] = this.yc[i] + this.dyc[i];
            this.zc[i] = this.zc[i] + this.dzc[i];
            this.xcold[i] = this.xc[i];
            this.ycold[i] = this.yc[i];
            this.zcold[i] = this.zc[i];
        }
        this.DEkin = 0.0;
        this.virisum = 0.0;
        for (i = 0; i < this.NATOMS; ++i) {
            double foxs = 0.0;
            double foys = 0.0;
            double fozs = 0.0;
            for (int j = 0; j < this.NATOMS; ++j) {
                int notzero;
                if (i == j || (notzero = this.vdwforce(i, j)) != 1) continue;
                foxs += this.fox;
                foys += this.foy;
                fozs += this.foz;
                this.viri = (this.xc[i] - this.xc[j]) * this.fox + (this.yc[i] - this.yc[j]) * this.foy + (this.zc[i] - this.zc[j]) * this.foz;
                this.virisum += this.viri;
            }
            this.ax1[i] = foxs * this.tsf / this.mass;
            this.ay1[i] = foys * this.tsf / this.mass;
            this.az1[i] = fozs * this.tsf / this.mass;
        }
        this.virisum = this.virisum * 5.0E-11 / (double)this.NATOMS;
        for (i = 0; i < this.NATOMS; ++i) {
            this.dvx[i] = (2.0 * this.ax1[i] + 5.0 * this.ax0[i] - this.axm1[i]) / 6.0;
            this.dvy[i] = (2.0 * this.ay1[i] + 5.0 * this.ay0[i] - this.aym1[i]) / 6.0;
            this.dvz[i] = (2.0 * this.az1[i] + 5.0 * this.az0[i] - this.azm1[i]) / 6.0;
            this.vx[i] = this.vx[i] + this.dvx[i];
            this.vy[i] = this.vy[i] + this.dvy[i];
            this.vz[i] = this.vz[i] + this.dvz[i];
        }
        for (i = 0; i < this.NATOMS; ++i) {
            this.axm1[i] = this.ax0[i];
            this.aym1[i] = this.ay0[i];
            this.azm1[i] = this.az0[i];
            this.ax0[i] = this.ax1[i];
            this.ay0[i] = this.ay1[i];
            this.az0[i] = this.az1[i];
        }
    }

    void verlet() {
        int i;
        this.DEkin = 0.0;
        this.virisum = 0.0;
        for (i = 0; i < this.NATOMS; ++i) {
            double foxs = 0.0;
            double foys = 0.0;
            double fozs = 0.0;
            for (int j = 0; j < this.NATOMS; ++j) {
                int notzero;
                if (i == j || (notzero = this.vdwforce(i, j)) != 1) continue;
                foxs += this.fox;
                foys += this.foy;
                fozs += this.foz;
                this.viri = (this.xc[i] - this.xc[j]) * this.fox + (this.yc[i] - this.yc[j]) * this.foy + (this.zc[i] - this.zc[j]) * this.foz;
                this.virisum += this.viri;
            }
            this.dvx[i] = foxs * this.tsf / this.mass;
            this.dvy[i] = foys * this.tsf / this.mass;
            this.dvz[i] = fozs * this.tsf / this.mass;
        }
        for (i = 0; i < this.NATOMS; ++i) {
            this.dxc[i] = this.xc[i] - this.xcold[i] + this.dvx[i] * this.TIMESTEP;
            this.dyc[i] = this.yc[i] - this.ycold[i] + this.dvy[i] * this.TIMESTEP;
            this.dzc[i] = this.zc[i] - this.zcold[i] + this.dvz[i] * this.TIMESTEP;
            this.xcold[i] = this.xc[i];
            this.ycold[i] = this.yc[i];
            this.zcold[i] = this.zc[i];
            this.xc[i] = this.xc[i] + this.dxc[i];
            this.yc[i] = this.yc[i] + this.dyc[i];
            this.zc[i] = this.zc[i] + this.dzc[i];
            this.vx[i] = this.dxc[i] / this.TIMESTEP + 0.5 * this.dvx[i];
            this.vy[i] = this.dyc[i] / this.TIMESTEP + 0.5 * this.dvy[i];
            this.vz[i] = this.dzc[i] / this.TIMESTEP + 0.5 * this.dvz[i];
        }
        this.virisum = this.virisum * 5.0E-11 / (double)this.NATOMS;
    }

    double ekinsum() {
        double sum = 0.0;
        for (int i = 0; i < this.NATOMS; ++i) {
            sum += this.vx[i] * this.vx[i];
            sum += this.vy[i] * this.vy[i];
            sum += this.vz[i] * this.vz[i];
        }
        sum = sum * 0.5 * this.mass * 1.66E-23;
        return sum;
    }

    void rescale_velocities() {
        double Ekin_now = this.ekinsum();
        double T_now = Ekin_now / (2.07E-23 * (double)this.NATOMS);
        double s_factor = T_now < 0.8 * this.TEMP_0 || T_now > 1.2 * this.TEMP_0 ? Math.sqrt(this.TEMP_0 / T_now) : 1.0 + (this.TEMP_0 / T_now - 1.0) / 20.0;
        for (int ia = 0; ia < this.NATOMS; ++ia) {
            this.vx[ia] = (this.xc[ia] - this.xcold[ia]) / this.TIMESTEP;
            this.vy[ia] = (this.yc[ia] - this.ycold[ia]) / this.TIMESTEP;
            this.vz[ia] = (this.zc[ia] - this.zcold[ia]) / this.TIMESTEP;
            this.vx[ia] = this.vx[ia] * s_factor;
            this.vy[ia] = this.vy[ia] * s_factor;
            this.vz[ia] = this.vz[ia] * s_factor;
            this.xcold[ia] = this.xc[ia] - this.vx[ia] * this.TIMESTEP;
            this.ycold[ia] = this.yc[ia] - this.vy[ia] * this.TIMESTEP;
            this.zcold[ia] = this.zc[ia] - this.vz[ia] * this.TIMESTEP;
        }
    }

    void rescale_velocitiesb() {
        double Ekin_now = this.ekinsum();
        double T_now = Ekin_now / (2.07E-23 * (double)this.NATOMS);
        double s_factor = T_now < 0.8 * this.TEMP_0 || T_now > 1.2 * this.TEMP_0 ? Math.sqrt(this.TEMP_0 / T_now) : 1.0 + (this.TEMP_0 / T_now - 1.0) / 20.0;
        for (int ia = 0; ia < this.NATOMS; ++ia) {
            this.vx[ia] = this.vx[ia] * s_factor;
            this.vy[ia] = this.vy[ia] * s_factor;
            this.vz[ia] = this.vz[ia] * s_factor;
        }
    }

    void swapx(int i) {
        double stor = this.xc[i];
        this.xc[i] = this.xcold[i];
        this.xcold[i] = stor;
        this.ax1[i] = -this.ax1[i];
        this.ax0[i] = -this.ax0[i];
        this.axm1[i] = -this.axm1[i];
    }

    void swapy(int i) {
        double stor = this.yc[i];
        this.yc[i] = this.ycold[i];
        this.ycold[i] = stor;
        this.ay1[i] = -this.ay1[i];
        this.ay0[i] = -this.ay0[i];
        this.aym1[i] = -this.aym1[i];
    }

    void swapz(int i) {
        double stor = this.zc[i];
        this.zc[i] = this.zcold[i];
        this.zcold[i] = stor;
        this.az1[i] = -this.az1[i];
        this.az0[i] = -this.az0[i];
        this.azm1[i] = -this.azm1[i];
    }

    double check_box() {
        double impact = 0.0;
        for (int i = 0; i < this.NATOMS; ++i) {
            if (this.xc[i] < -this.BOXSIZE / 2.0 && this.vx[i] < 0.0) {
                this.vx[i] = Math.abs(this.vx[i]);
                impact += Math.abs(this.vx[i]);
                this.swapx(i);
            }
            if (this.yc[i] < -this.BOXSIZE / 2.0 && this.vy[i] < 0.0) {
                this.vy[i] = Math.abs(this.vy[i]);
                impact += Math.abs(this.vy[i]);
                this.swapy(i);
            }
            if (this.zc[i] < -this.BOXSIZE / 2.0 && this.vz[i] < 0.0) {
                this.vz[i] = Math.abs(this.vz[i]);
                impact += Math.abs(this.vz[i]);
                this.swapz(i);
            }
            if (this.xc[i] > this.BOXSIZE / 2.0 && this.vx[i] > 0.0) {
                this.vx[i] = -Math.abs(this.vx[i]);
                impact += Math.abs(this.vx[i]);
                this.swapx(i);
            }
            if (this.yc[i] > this.BOXSIZE / 2.0 && this.vy[i] > 0.0) {
                this.vy[i] = -Math.abs(this.vy[i]);
                impact += Math.abs(this.vy[i]);
                this.swapy(i);
            }
            if (!(this.zc[i] > this.BOXSIZE / 2.0) || !(this.vz[i] > 0.0)) continue;
            this.vz[i] = -Math.abs(this.vz[i]);
            impact += Math.abs(this.vz[i]);
            this.swapz(i);
        }
        return impact / 3.0;
    }

    void simulate() {
        double impact = 0.0;
        ++this.count1;
        this.il2 = 0;
        while (this.il2 < this.loops_i) {
            ++this.countall;
            if (this.equilibrate) {
                this.rescale_velocitiesb();
            }
            impact += this.check_box();
            this.beeman();
            this.ttime += this.TIMESTEP;
            ++this.il2;
        }
        this.epot = this.vdwsum();
        this.ekin = this.ekinsum();
        this.etot = this.ekin + this.epot;
        this.temper = this.ekin / (2.07E-23 * (double)this.NATOMS);
        this.ktav += this.temper * 1.38E-23;
        this.virav += this.virisum;
        this.pressure = 1.0E34 * (1.0 / (double)this.loops_i) * impact * this.mass * 1.66E-27 / (this.TIMESTEP * this.BOXSIZE * this.BOXSIZE);
        this.pressav += this.pressure;
        this.pvs = 0.0;
        this.ia = 0;
        while (this.ia < this.NATOMS) {
            if (this.vx[this.ia] > 0.0) {
                this.pvs += this.vx[this.ia] * this.vx[this.ia];
            }
            ++this.ia;
        }
        this.pvs = this.pvs * 2.0 * this.mass * 1.6E-27 * 10000.0 / (double)this.NATOMS;
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        double tscale;

        public void paintComponent(Graphics g) {
            int ix;
            double yp;
            double xp;
            int i;
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g);
            g.clearRect(0, 0, NewJApplet.this.size, NewJApplet.this.size);
            if ((NewJApplet.this.showhisto || NewJApplet.this.showdist) && NewJApplet.this.collected == 0) {
                for (i = 0; i < NewJApplet.this.NHISTO; ++i) {
                    NewJApplet.this.histo[i] = 0;
                }
            }
            if (NewJApplet.this.showvcor && NewJApplet.this.coll2 == 0) {
                for (i = 0; i < NewJApplet.this.NCORR; ++i) {
                    NewJApplet.this.corrf[i] = 0.0;
                }
                NewJApplet.this.coll2 = 1;
                NewJApplet.this.corrf[0] = 1.0;
            }
            if (NewJApplet.this.showxsq && NewJApplet.this.coll2 == 0) {
                for (i = 0; i < NewJApplet.this.NCORR; ++i) {
                    NewJApplet.this.corrf[i] = 0.0;
                }
                NewJApplet.this.coll2 = 1;
            }
            NewJApplet.this.simulate();
            if (NewJApplet.this.showhisto) {
                NewJApplet.this.vel_histo();
                ++NewJApplet.this.collected;
            }
            if (NewJApplet.this.showdist) {
                NewJApplet.this.dist_histo();
                ++NewJApplet.this.collected;
            }
            if (NewJApplet.this.showvcor) {
                NewJApplet.this.vel_corr();
                ++NewJApplet.this.collected;
            }
            if (NewJApplet.this.showxsq) {
                NewJApplet.this.x_sq();
                ++NewJApplet.this.collected;
            }
            for (i = 0; i < NewJApplet.this.NATOMS; ++i) {
                xp = (NewJApplet.this.xc[i] + NewJApplet.this.BOXSIZE / 2.0) * (double)NewJApplet.this.size / NewJApplet.this.BOXSIZE;
                yp = (NewJApplet.this.yc[i] + NewJApplet.this.BOXSIZE / 2.0) * (double)NewJApplet.this.size / NewJApplet.this.BOXSIZE;
                int ir = (int)((NewJApplet.this.zc[i] + NewJApplet.this.BOXSIZE / 2.0) * 10.0 / NewJApplet.this.BOXSIZE) + 1;
                g.setColor(Color.red);
                g2.fill(new Ellipse2D.Double(xp - (double)(ir / 2), yp - (double)(ir / 2), ir, ir));
            }
            if (NewJApplet.this.showhisto) {
                g.setColor(Color.black);
                g.drawLine(1, 500, NewJApplet.this.NHISTO, 500);
                g.drawString("Angstrom/psec", 150, 530);
                for (i = 1; i < 8; ++i) {
                    ix = i * 40;
                    g.drawString("" + (double)(i * 40) * NewJApplet.this.vscale, ix - 5, 520);
                    g.drawLine(ix, 500, ix, 510);
                }
                xp = Math.sqrt(2.0 * NewJApplet.this.TEMP_0 * 1.38 / (1.66 * NewJApplet.this.mass));
                ix = (int)(xp / NewJApplet.this.vscale);
                g.setColor(Color.green);
                g.drawLine(ix, 500, ix, 300);
                g.setColor(Color.black);
                for (i = 0; i < NewJApplet.this.NHISTO; ++i) {
                    g.drawRect(i, 500 - 20 * NewJApplet.this.histo[i] / NewJApplet.this.collected, 1, 20 * NewJApplet.this.histo[i] / NewJApplet.this.collected);
                }
                if (NewJApplet.this.collected >= 200) {
                    NewJApplet.this.collected = 0;
                }
            }
            if (NewJApplet.this.showdist) {
                g.setColor(Color.black);
                g.drawLine(1, 500, NewJApplet.this.NHISTO, 500);
                g.drawString("Angstrom", 150, 530);
                for (i = 1; i < 15; ++i) {
                    ix = i * 20;
                    g.drawString("" + i, ix - 5, 520);
                    g.drawLine(ix, 500, ix, 510);
                }
                for (i = 0; i < NewJApplet.this.NHISTO; ++i) {
                    yp = 0.2 * NewJApplet.this.BOXSIZE * (double)NewJApplet.this.histo[i] / (double)NewJApplet.this.collected;
                    this.iy0 = (int)yp;
                    g.drawRect(i, 500 - this.iy0, 1, this.iy0);
                }
                if (NewJApplet.this.collected >= 200) {
                    NewJApplet.this.collected = 0;
                }
            }
            if (NewJApplet.this.showvcor) {
                g.setColor(Color.blue);
                for (i = 1; i < NewJApplet.this.collected; ++i) {
                    if (!(NewJApplet.this.corrf[0] > 0.0) || i <= 0) continue;
                    g.drawLine(i - 1, 510 - (int)(200.0 * NewJApplet.this.corrf[i - 1] / NewJApplet.this.corrf[0]), i, 510 - (int)(200.0 * NewJApplet.this.corrf[i] / NewJApplet.this.corrf[0]));
                }
                g.setColor(Color.black);
                g.drawLine(1, 510, NewJApplet.this.NCORR, 510);
                g.drawLine(1, 310, NewJApplet.this.NCORR, 310);
                g.drawLine(1, 510 - (int)(200.0 * Math.exp(-1.0)), NewJApplet.this.NCORR, 510 - (int)(200.0 * Math.exp(-1.0)));
                if (NewJApplet.this.collected >= NewJApplet.this.NCORR) {
                    NewJApplet.this.collected = 0;
                    ++NewJApplet.this.coll2;
                    NewJApplet.this.vv0 = NewJApplet.this.corrf[0];
                }
                if (NewJApplet.this.coll2 > 1) {
                    for (i = NewJApplet.this.collected + 1; i < NewJApplet.this.NCORR; ++i) {
                        g.drawLine(i - 1, 510 - (int)(200.0 * NewJApplet.this.corrf[i - 1] / NewJApplet.this.vv0), i, 510 - (int)(200.0 * NewJApplet.this.corrf[i] / NewJApplet.this.vv0));
                    }
                }
                this.tscale = NewJApplet.this.TIMESTEP * (double)NewJApplet.this.loops_i;
                for (i = 0; i < 7; ++i) {
                    g.drawLine(1 + i * 50, 510, 1 + i * 50, 310);
                    g.drawString("" + NewJApplet.this.df2.format(this.tscale * (double)i * 50.0), 1 + i * 50, 520);
                }
                g.drawString("psec", 150, 530);
                g.drawString("1.0", 320, 310);
                g.drawString("1/e", 320, 510 - (int)(200.0 * Math.exp(-1.0)));
            }
            if (NewJApplet.this.showxsq) {
                g.setColor(Color.blue);
                for (i = 1; i < NewJApplet.this.collected; ++i) {
                    g.drawLine(i - 1, 510 - (int)(0.3 * NewJApplet.this.corrf[i - 1] / (double)(NewJApplet.this.coll2 * NewJApplet.this.NATOMS)), i, 510 - (int)(0.3 * NewJApplet.this.corrf[i] / (double)(NewJApplet.this.coll2 * NewJApplet.this.NATOMS)));
                }
                if (NewJApplet.this.coll2 > 1) {
                    for (i = NewJApplet.this.collected + 1; i < NewJApplet.this.NCORR; ++i) {
                        g.drawLine(i - 1, 510 - (int)(0.3 * NewJApplet.this.corrf[i - 1] / (double)((NewJApplet.this.coll2 - 1) * NewJApplet.this.NATOMS)), i, 510 - (int)(0.3 * NewJApplet.this.corrf[i] / (double)((NewJApplet.this.coll2 - 1) * NewJApplet.this.NATOMS)));
                    }
                }
                g.drawOval(NewJApplet.this.collected - 1, 510 - (int)(0.3 * NewJApplet.this.corrf[NewJApplet.this.collected - 1] / (double)(NewJApplet.this.coll2 * NewJApplet.this.NATOMS)), 3, 3);
                g.setColor(Color.black);
                g.drawLine(1, 510, NewJApplet.this.NCORR, 510);
                g.drawLine(1, 310, NewJApplet.this.NCORR, 310);
                if (NewJApplet.this.collected >= NewJApplet.this.NCORR) {
                    NewJApplet.this.collected = 0;
                    ++NewJApplet.this.coll2;
                }
                this.tscale = NewJApplet.this.TIMESTEP * (double)NewJApplet.this.loops_i;
                for (i = 0; i < 7; ++i) {
                    g.drawLine(1 + i * 50, 510, 1 + i * 50, 310);
                    g.drawString("" + NewJApplet.this.df2.format(this.tscale * (double)i * 50.0), 1 + i * 50, 520);
                }
                g.drawString("psec", 150, 530);
                int ix5 = 503;
                int ix10 = 480;
                int ix15 = 443;
                int ix20 = 390;
                int ix25 = 323;
                g.drawString("(5A)^2", 305, ix5);
                g.drawString("(10A)^2", 305, ix10);
                g.drawString("(15A)^2", 305, ix15);
                g.drawString("(20A)^2", 305, ix20);
                g.drawString("(25A)^2", 305, ix25);
                g.drawLine(1, ix5, NewJApplet.this.NCORR, ix5);
                g.drawLine(1, ix10, NewJApplet.this.NCORR, ix10);
                g.drawLine(1, ix15, NewJApplet.this.NCORR, ix15);
                g.drawLine(1, ix20, NewJApplet.this.NCORR, ix20);
                g.drawLine(1, ix25, NewJApplet.this.NCORR, ix25);
            }
            NewJApplet.this.jLabel1.setText("T=" + NewJApplet.this.df1.format(NewJApplet.this.temper));
            NewJApplet.this.jLabel2.setText("Virial=" + NewJApplet.this.df.format(NewJApplet.this.virav / (double)(3 * NewJApplet.this.count1)));
            NewJApplet.this.jLabel3.setText("p=" + NewJApplet.this.df.format(NewJApplet.this.pressav / (double)NewJApplet.this.count1));
            NewJApplet.this.jLabel4.setText("pV=" + NewJApplet.this.df.format(NewJApplet.this.vmol * NewJApplet.this.pressav / (double)NewJApplet.this.count1));
            NewJApplet.this.jLabel5.setText("kT=" + NewJApplet.this.df.format(NewJApplet.this.ktav / (double)NewJApplet.this.count1));
            NewJApplet.this.jLabel6.setText("rho=" + NewJApplet.this.df1.format(NewJApplet.this.densty));
            NewJApplet.this.jLabel7.setText("pvs=" + NewJApplet.this.df.format(NewJApplet.this.pvs));
            NewJApplet.this.jLabel8.setText("ETOT=" + NewJApplet.this.df.format(NewJApplet.this.etot));
            NewJApplet.this.jLabel9.setText("TIME=" + NewJApplet.this.df1.format(NewJApplet.this.ttime));
            NewJApplet.this.jLabel10.setText("EKIN=" + NewJApplet.this.df.format(NewJApplet.this.ekin));
            NewJApplet.this.jLabel11.setText("EPOT=" + NewJApplet.this.df.format(NewJApplet.this.epot));
            NewJApplet.this.jLabel14.setText("count1=" + NewJApplet.this.collected);
            NewJApplet.this.jLabel15.setText("count2=" + NewJApplet.this.coll2);
        }
    }
}

