/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    int natoms = 10;
    int natoms1 = 5;
    int nmols = 2;
    int count;
    double[][] rcg;
    double[][] vcg;
    double[][] rbod;
    double[][] omega;
    double[][] omega_ad;
    double[][] ombod;
    double[][] angmom;
    double[][] inertia;
    double[][] force;
    double[][] torque;
    double[][] rlab;
    double[][] quat;
    double[] dr;
    double[] fij;
    double tstep = 5.0E-4;
    double tsf;
    int[] nat;
    double[][][] amat;
    double[] mass;
    double[][] values;
    double drtx;
    double drty;
    double drtz;
    BufferedImage image;
    BufferedImage imagea;
    Graphics2D gb;
    Graphics2D gba;
    double zz;
    double totaltime;
    double yoffset = 0.0;
    double inimom1 = 0.0;
    double inimom2 = 0.0;
    double inimom1a = 0.0;
    double inimom2a = 0.0;
    double inivel = 0.0;
    double erot1;
    double erot2;
    double ekin1;
    double ekin2;
    double etot1;
    double etot2;
    double vdwen;
    boolean simulating = false;
    boolean attractive = true;
    double etot;
    double escale = 100.0;
    int timescale = 20;
    int innerloops = 20;
    double energyscale = 100.0;
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel12;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JSlider jSlider5;
    private JSlider jSlider6;
    private JSlider jSlider7;
    private JSlider jSlider8;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.init_variables();
        this.reset();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.simulating) {
            if (this.count == 0) {
                this.innerloops = this.timescale;
                this.advance();
                this.calc_en();
                this.etot = this.ekin1 + this.ekin2 + this.erot1 + this.erot2 + this.vdwen;
            }
            ++this.count;
        }
        this.escale = this.energyscale / this.etot;
        if (this.count < 1000) {
            for (int j = 0; j < this.innerloops; ++j) {
                this.advance();
            }
            this.jLabel3.setText("time=" + this.df.format(this.totaltime));
        }
        this.draw();
        this.jPanel1.repaint();
        this.timer.restart();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel3 = new JLabel();
        this.jPanel2 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jLabel5 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jLabel8 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jSlider7 = new JSlider();
        this.jSlider8 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jLabel12 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jSlider1 = new JSlider();
        this.jPanel3 = new myPanel2();
        this.jSlider5 = new JSlider();
        this.jLabel9 = new JLabel();
        this.jSlider6 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jPanel1.setMaximumSize(new Dimension(500, 250));
        this.jPanel1.setMinimumSize(new Dimension(500, 250));
        this.jPanel1.setPreferredSize(new Dimension(500, 250));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 500, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 250, Short.MAX_VALUE));
        this.jLabel3.setText("jLabel1");
        this.jLabel4.setFont(new Font("Courier", 1, 12));
        this.jLabel4.setText("jLabel1");
        this.jLabel6.setFont(new Font("Courier", 1, 12));
        this.jLabel6.setText("jLabel6");
        this.jSlider2.setMajorTickSpacing(20);
        this.jSlider2.setMinimum(-100);
        this.jSlider2.setOrientation(1);
        this.jSlider2.setPaintTicks(true);
        this.jSlider2.setSnapToTicks(true);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jSlider3.setMajorTickSpacing(20);
        this.jSlider3.setMinimum(-100);
        this.jSlider3.setOrientation(1);
        this.jSlider3.setPaintTicks(true);
        this.jSlider3.setSnapToTicks(true);
        this.jSlider3.setValue(0);
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel5.setText("angular momenta");
        this.jSlider4.setMajorTickSpacing(20);
        this.jSlider4.setMaximum(200);
        this.jSlider4.setOrientation(1);
        this.jSlider4.setPaintTicks(true);
        this.jSlider4.setSnapToTicks(true);
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel8.setText("velocity");
        this.jCheckBox1.setSelected(true);
        this.jCheckBox1.setText("attractive forces on");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jSlider7.setMajorTickSpacing(20);
        this.jSlider7.setMinimum(-100);
        this.jSlider7.setOrientation(1);
        this.jSlider7.setPaintTicks(true);
        this.jSlider7.setSnapToTicks(true);
        this.jSlider7.setValue(0);
        this.jSlider7.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider7MouseDragged(evt);
            }
        });
        this.jSlider8.setMajorTickSpacing(20);
        this.jSlider8.setMinimum(-100);
        this.jSlider8.setOrientation(1);
        this.jSlider8.setPaintTicks(true);
        this.jSlider8.setSnapToTicks(true);
        this.jSlider8.setValue(0);
        this.jSlider8.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider8MouseDragged(evt);
            }
        });
        this.jLabel2.setText("Lz1");
        this.jLabel7.setText("Ly1");
        this.jLabel10.setText("Lz2");
        this.jLabel11.setText("Ly2");
        this.jLabel12.setText("vx1");
        this.jButton1.setText("start");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("prepare");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4, -2, 323, -2).addComponent(this.jLabel6).addGroup(jPanel2Layout.createSequentialGroup().addGap(7, 7, 7).addComponent(this.jCheckBox1)).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jSlider2, -2, 48, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel2).addGap(24, 24, 24))).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel7)).addComponent(this.jSlider7, -2, 48, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel10)).addComponent(this.jSlider3, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider8, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel11))).addGap(17, 17, 17).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider4, -2, -1, -2).addGroup(jPanel2Layout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.jLabel12)))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jButton2)))).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.jLabel5).addGap(54, 54, 54).addComponent(this.jLabel8).addGap(12, 12, 12))))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(0, this.jSlider2, this.jSlider3, this.jSlider4, this.jSlider7, this.jSlider8);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(56, 56, 56).addComponent(this.jLabel4).addGap(26, 26, 26).addComponent(this.jLabel6).addGap(78, 78, 78).addComponent(this.jCheckBox1).addGap(46, 46, 46).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.jLabel8)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider3, -2, 0, Short.MAX_VALUE).addComponent(this.jSlider2, -2, 0, Short.MAX_VALUE).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider4, -2, 180, -2).addComponent(this.jSlider7, -2, 172, -2).addComponent(this.jSlider8, -2, 172, -2)).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel10)).addComponent(this.jLabel11).addComponent(this.jLabel12).addComponent(this.jLabel7)).addGap(60, 60, 60).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addGap(55, 55, 55)));
        jPanel2Layout.linkSize(1, this.jSlider2, this.jSlider3, this.jSlider7, this.jSlider8);
        this.jSlider1.setMinimum(-100);
        this.jSlider1.setOrientation(1);
        this.jSlider1.setValue(0);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jPanel3.setMaximumSize(new Dimension(500, 250));
        this.jPanel3.setMinimumSize(new Dimension(500, 250));
        this.jPanel3.setPreferredSize(new Dimension(500, 250));
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 500, Short.MAX_VALUE));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 250, Short.MAX_VALUE));
        this.jSlider5.setMajorTickSpacing(10);
        this.jSlider5.setMinimum(5);
        this.jSlider5.setPaintTicks(true);
        this.jSlider5.setSnapToTicks(true);
        this.jSlider5.setValue(20);
        this.jSlider5.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider5MouseDragged(evt);
            }
        });
        this.jLabel9.setText("timescale");
        this.jSlider6.setMaximum(200);
        this.jSlider6.setOrientation(1);
        this.jSlider6.setValue(100);
        this.jSlider6.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider6MouseDragged(evt);
            }
        });
        this.jLabel1.setText("energy   red=translation   blue=rotation   green=potential   black=total");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jSlider1, -2, -1, -2).addComponent(this.jSlider6, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(26, 26, 26).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSlider5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel3, -2, 146, -2).addGap(0, 0, Short.MAX_VALUE))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel2, -2, 311, -2).addGap(411, 411, 411)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel1)).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addComponent(this.jSlider1, -2, -1, -2).addGap(61, 61, 61).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel3, -2, -1, -2).addComponent(this.jSlider6, -2, -1, -2)))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider5, -2, -1, -2).addComponent(this.jLabel9).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE))).addGap(253, 253, 253)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.simulating = true;
        this.reset();
        this.timer.restart();
        this.draw();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.yoffset = (double)this.jSlider1.getValue() * 0.1;
        if (!this.simulating) {
            this.rcg[1][0] = this.yoffset;
            this.labcoords();
            this.draw();
        }
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.inimom1 = (double)this.jSlider2.getValue() * 0.2;
        if (!this.simulating) {
            this.angmom[2][0] = this.inimom1;
        }
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.inimom2 = (double)this.jSlider3.getValue() * 0.2;
        if (!this.simulating) {
            this.angmom[2][1] = this.inimom2;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.timer.stop();
        this.simulating = false;
        this.reset();
        this.vcg[0][0] = 0.0;
        this.timer.restart();
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.inivel = (double)this.jSlider4.getValue() * 0.1;
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.attractive = this.jCheckBox1.isSelected();
    }

    private void jSlider5MouseDragged(MouseEvent evt) {
        this.timescale = this.jSlider5.getValue();
    }

    private void jSlider6MouseDragged(MouseEvent evt) {
        this.energyscale = this.jSlider6.getValue();
        this.escale = this.energyscale / this.etot;
        this.draw();
    }

    private void jSlider7MouseDragged(MouseEvent evt) {
        this.angmom[0][0] = this.inimom1a = (double)this.jSlider7.getValue() * 0.2;
    }

    private void jSlider8MouseDragged(MouseEvent evt) {
        this.angmom[0][1] = this.inimom2a = (double)this.jSlider8.getValue() * 0.2;
    }

    void init_variables() {
        this.rcg = new double[3][this.nmols];
        this.vcg = new double[3][this.nmols];
        this.ombod = new double[3][this.nmols];
        this.omega = new double[3][this.nmols];
        this.omega_ad = new double[3][this.nmols];
        this.angmom = new double[3][this.nmols];
        this.inertia = new double[3][this.nmols];
        this.rlab = new double[3][this.natoms];
        this.rbod = new double[3][this.natoms];
        this.force = new double[3][this.nmols];
        this.torque = new double[3][this.nmols];
        this.quat = new double[4][this.nmols];
        this.amat = new double[3][3][this.nmols];
        this.dr = new double[3];
        this.fij = new double[3];
        this.nat = new int[this.natoms];
        this.mass = new double[this.nmols];
        this.image = new BufferedImage(500, 250, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 500, 250);
        this.imagea = new BufferedImage(500, 250, 1);
        this.gba = this.imagea.createGraphics();
        this.gba.setBackground(Color.white);
        this.gba.clearRect(0, 0, 500, 250);
        this.timer = new Timer(1, this);
        this.df = new DecimalFormat("+0.000000;-0.000000");
        this.df1 = new DecimalFormat("+0.00000000;-0.00000000");
        this.values = new double[5][500];
    }

    void reset() {
        int i;
        this.tsf = this.tstep * 1.0E-14 / 1.66E-27;
        if (this.simulating) {
            this.inivel = (double)this.jSlider4.getValue() * 0.1;
        }
        this.inimom1 = (double)this.jSlider2.getValue() * 0.2;
        this.inimom2 = (double)this.jSlider3.getValue() * 0.2;
        this.nat[0] = 6;
        this.nat[1] = 1;
        this.nat[2] = 1;
        this.nat[3] = 1;
        this.nat[4] = 1;
        this.nat[5] = 6;
        this.nat[6] = 1;
        this.nat[7] = 1;
        this.nat[8] = 1;
        this.nat[9] = 1;
        this.rcg[0][0] = -5.0;
        this.rcg[1][0] = this.yoffset;
        this.rcg[2][0] = 0.0;
        this.rcg[0][1] = 7.0;
        this.rcg[1][1] = 0.0;
        this.rcg[2][1] = 0.0;
        this.vcg[0][0] = this.inivel;
        this.vcg[1][0] = 0.0;
        this.vcg[2][0] = 0.0;
        this.vcg[0][1] = 0.0;
        this.vcg[1][1] = 0.0;
        this.vcg[2][1] = 0.0;
        this.inertia[0][0] = 3.15;
        this.inertia[1][0] = 3.15;
        this.inertia[2][0] = 3.15;
        this.inertia[0][1] = 3.15;
        this.inertia[1][1] = 3.15;
        this.inertia[2][1] = 3.15;
        this.rbod[0][0] = 0.0;
        this.rbod[1][0] = 0.0;
        this.rbod[2][0] = 0.0;
        this.rbod[0][1] = -0.848;
        this.rbod[1][1] = 0.396;
        this.rbod[2][1] = -0.544;
        this.rbod[0][2] = -0.217;
        this.rbod[1][2] = 0.009;
        this.rbod[2][2] = 1.06;
        this.rbod[0][3] = 0.872;
        this.rbod[1][3] = 0.611;
        this.rbod[2][3] = -0.195;
        this.rbod[0][4] = 0.192;
        this.rbod[1][4] = -1.016;
        this.rbod[2][4] = -0.32;
        this.rbod[0][5] = 0.0;
        this.rbod[1][5] = 0.0;
        this.rbod[2][5] = 0.0;
        this.rbod[0][6] = 0.848;
        this.rbod[1][6] = 0.396;
        this.rbod[2][6] = -0.544;
        this.rbod[0][7] = 0.217;
        this.rbod[1][7] = 0.009;
        this.rbod[2][7] = 1.06;
        this.rbod[0][8] = -0.872;
        this.rbod[1][8] = 0.611;
        this.rbod[2][8] = -0.195;
        this.rbod[0][9] = -0.192;
        this.rbod[1][9] = -1.016;
        this.rbod[2][9] = -0.32;
        this.quat[0][0] = 0.0243;
        this.quat[1][0] = -0.3578;
        this.quat[2][0] = 0.6899;
        this.quat[3][0] = 0.6182;
        this.quat[0][1] = 0.0243;
        this.quat[1][1] = -0.3578;
        this.quat[2][1] = -0.6899;
        this.quat[3][1] = -0.6182;
        this.mass[0] = 16.0;
        this.mass[1] = 16.0;
        this.angmom[0][0] = this.inimom1a;
        this.angmom[1][0] = 0.0;
        this.angmom[2][0] = this.inimom1;
        this.angmom[0][1] = this.inimom2a;
        this.angmom[1][1] = 0.0;
        this.angmom[2][1] = this.inimom2;
        double qnorm1 = 0.0;
        double qnorm2 = 0.0;
        for (i = 0; i < 4; ++i) {
            qnorm1 += this.quat[i][0] * this.quat[i][0];
            qnorm2 += this.quat[i][1] * this.quat[i][1];
        }
        for (i = 0; i < 4; ++i) {
            this.quat[i][0] = this.quat[i][0] / Math.sqrt(qnorm1);
            this.quat[i][1] = this.quat[i][1] / Math.sqrt(qnorm2);
        }
        this.newmatrix(0);
        this.newmatrix(1);
        this.labcoords();
        this.calc_forces();
        this.count = 0;
        this.prepare();
        this.draw();
        this.totaltime = 0.0;
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    double vdwedat(int atype) {
        double ve = atype == 1 ? 1.1868E-22 : 7.065600000000001E-22;
        return ve;
    }

    double vdwsdat(int atype) {
        double vs = atype == 1 ? 2.81 : 3.35;
        return vs;
    }

    void calc_forces() {
        int k;
        for (k = 0; k < 3; ++k) {
            this.force[k][0] = 0.0;
            this.force[k][1] = 0.0;
            this.torque[k][0] = 0.0;
            this.torque[k][1] = 0.0;
        }
        for (int i = 0; i < this.natoms1; ++i) {
            for (int j = this.natoms1; j < this.natoms; ++j) {
                double f12;
                for (k = 0; k < 3; ++k) {
                    this.dr[k] = this.rlab[k][i] - this.rlab[k][j];
                    this.fij[k] = 0.0;
                }
                double d2 = this.dr[0] * this.dr[0] + this.dr[1] * this.dr[1] + this.dr[2] * this.dr[2];
                double vdwe = Math.sqrt(this.vdwedat(this.nat[i]) * this.vdwedat(this.nat[j]));
                double vdws = 0.5 * (this.vdwsdat(this.nat[i]) + this.vdwsdat(this.nat[j]));
                double d6 = d2 * d2 * d2;
                double d8 = d6 * d2;
                double d14 = d6 * d6 * d2;
                double fac = f12 = 4.8E11 * vdwe * Math.pow(vdws, 12.0) / d14;
                if (this.attractive) {
                    double f6 = -2.4E11 * vdwe * Math.pow(vdws, 6.0) / d8;
                    fac += f6;
                }
                for (k = 0; k < 3; ++k) {
                    double[] dArray = this.force[k];
                    dArray[0] = dArray[0] + fac * this.dr[k];
                    double[] dArray2 = this.force[k];
                    dArray2[1] = dArray2[1] - fac * this.dr[k];
                    this.fij[k] = fac * this.dr[k];
                }
                for (k = 0; k < 3; ++k) {
                    this.dr[k] = this.rlab[k][i] - this.rcg[k][0];
                }
                double[] dArray = this.torque[0];
                dArray[0] = dArray[0] + (this.dr[1] * this.fij[2] - this.dr[2] * this.fij[1]);
                double[] dArray3 = this.torque[1];
                dArray3[0] = dArray3[0] + (this.dr[2] * this.fij[0] - this.dr[0] * this.fij[2]);
                double[] dArray4 = this.torque[2];
                dArray4[0] = dArray4[0] + (this.dr[0] * this.fij[1] - this.dr[1] * this.fij[0]);
                for (k = 0; k < 3; ++k) {
                    this.dr[k] = this.rlab[k][j] - this.rcg[k][1];
                }
                double[] dArray5 = this.torque[0];
                dArray5[1] = dArray5[1] - (this.dr[1] * this.fij[2] - this.dr[2] * this.fij[1]);
                double[] dArray6 = this.torque[1];
                dArray6[1] = dArray6[1] - (this.dr[2] * this.fij[0] - this.dr[0] * this.fij[2]);
                double[] dArray7 = this.torque[2];
                dArray7[1] = dArray7[1] - (this.dr[0] * this.fij[1] - this.dr[1] * this.fij[0]);
            }
        }
    }

    void newmatrix(int im) {
        this.amat[0][0][im] = this.quat[0][im] * this.quat[0][im] + this.quat[1][im] * this.quat[1][im] - this.quat[2][im] * this.quat[2][im] - this.quat[3][im] * this.quat[3][im];
        this.amat[1][1][im] = this.quat[0][im] * this.quat[0][im] - this.quat[1][im] * this.quat[1][im] + this.quat[2][im] * this.quat[2][im] - this.quat[3][im] * this.quat[3][im];
        this.amat[2][2][im] = this.quat[0][im] * this.quat[0][im] - this.quat[1][im] * this.quat[1][im] - this.quat[2][im] * this.quat[2][im] + this.quat[3][im] * this.quat[3][im];
        this.amat[0][1][im] = 2.0 * (this.quat[1][im] * this.quat[2][im] + this.quat[0][im] * this.quat[3][im]);
        this.amat[1][0][im] = 2.0 * (this.quat[1][im] * this.quat[2][im] - this.quat[0][im] * this.quat[3][im]);
        this.amat[0][2][im] = 2.0 * (this.quat[1][im] * this.quat[3][im] - this.quat[0][im] * this.quat[2][im]);
        this.amat[2][0][im] = 2.0 * (this.quat[1][im] * this.quat[3][im] + this.quat[0][im] * this.quat[2][im]);
        this.amat[1][2][im] = 2.0 * (this.quat[2][im] * this.quat[3][im] + this.quat[0][im] * this.quat[1][im]);
        this.amat[2][1][im] = 2.0 * (this.quat[2][im] * this.quat[3][im] - this.quat[0][im] * this.quat[1][im]);
    }

    void labcoords() {
        int j;
        double s;
        int i;
        int ia;
        for (ia = 0; ia < this.natoms1; ++ia) {
            for (i = 0; i < 3; ++i) {
                s = 0.0;
                for (j = 0; j < 3; ++j) {
                    s += this.amat[i][j][0] * this.rbod[j][ia];
                }
                this.rlab[i][ia] = this.rcg[i][0] + s;
            }
        }
        for (ia = this.natoms1; ia < this.natoms; ++ia) {
            for (i = 0; i < 3; ++i) {
                s = 0.0;
                for (j = 0; j < 3; ++j) {
                    s += this.amat[i][j][1] * this.rbod[j][ia];
                }
                this.rlab[i][ia] = this.rcg[i][1] + s;
            }
        }
    }

    void draw() {
        int iy1;
        int iy;
        int ix;
        int base = 150;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        Graphics ga = this.jPanel3.getGraphics();
        Graphics2D g2a = (Graphics2D)ga;
        this.gb.setColor(Color.white);
        this.gb.clearRect(0, 0, 500, 250);
        this.gb.setColor(Color.black);
        for (int ia = 0; ia < this.natoms; ++ia) {
            ix = (int)(this.rlab[0][ia] * 10.0 + 100.0);
            iy = (int)(100.0 - this.rlab[1][ia] * 10.0);
            if (ia == 4 || ia == 9) {
                this.gb.setColor(Color.red);
            } else {
                this.gb.setColor(Color.blue);
            }
            this.gb.drawOval(ix, iy, 10, 10);
        }
        this.gba.setColor(Color.white);
        this.gba.clearRect(0, 0, 500, 250);
        this.gba.setColor(Color.red);
        int count1 = Math.min(this.count, 500);
        for (ix = 0; ix < count1 - 1; ++ix) {
            iy = base - (int)(this.values[0][ix] * this.escale);
            iy1 = base - (int)(this.values[0][ix + 1] * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        for (ix = 0; ix < count1 - 1; ++ix) {
            iy = base - (int)(this.values[1][ix] * this.escale);
            iy1 = base - (int)(this.values[1][ix + 1] * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        this.gba.setColor(Color.blue);
        for (ix = 0; ix < count1 - 1; ++ix) {
            iy = base - (int)(this.values[2][ix] * this.escale);
            iy1 = base - (int)(this.values[2][ix + 1] * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        for (ix = 0; ix < count1 - 1; ++ix) {
            iy = base - (int)(this.values[3][ix] * this.escale);
            iy1 = base - (int)(this.values[3][ix + 1] * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        this.gba.setColor(Color.green);
        for (ix = 0; ix < count1 - 1; ++ix) {
            iy = base - (int)(this.values[4][ix] * this.escale);
            iy1 = base - (int)(this.values[4][ix + 1] * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        this.gba.setColor(Color.black);
        for (ix = 0; ix < count1 - 1; ++ix) {
            double vs = this.values[0][ix] + this.values[1][ix] + this.values[2][ix] + this.values[3][ix] + this.values[4][ix];
            double vs1 = this.values[0][ix + 1] + this.values[1][ix + 1] + this.values[2][ix + 1] + this.values[3][ix + 1] + this.values[4][ix + 1];
            iy = base - (int)(vs * this.escale);
            iy1 = base - (int)(vs1 * this.escale);
            this.gba.drawLine(ix, iy, ix + 1, iy1);
        }
        g2.drawImage((Image)this.image, 0, 0, null);
        g2a.drawImage((Image)this.imagea, 0, 0, null);
    }

    void rotate(int im) {
        double ombod2 = this.omega[0][im] * this.omega[0][im] + this.omega[1][im] * this.omega[1][im] + this.omega[2][im] * this.omega[2][im];
        ombod2 = ombod2 * this.tstep * this.tstep / 16.0;
        double fdiag = (1.0 - ombod2) / (1.0 + ombod2);
        double fndia = 0.5 * this.tstep / (1.0 + ombod2);
        double dq0 = this.omega[0][im] * this.quat[1][im] + this.omega[1][im] * this.quat[2][im] + this.omega[2][im] * this.quat[3][im];
        dq0 = dq0 * fndia + this.quat[0][im] * fdiag;
        double dq1 = -this.omega[0][im] * this.quat[0][im] + this.omega[2][im] * this.quat[2][im] - this.omega[1][im] * this.quat[3][im];
        dq1 = dq1 * fndia + this.quat[1][im] * fdiag;
        double dq2 = -this.omega[1][im] * this.quat[0][im] - this.omega[2][im] * this.quat[1][im] + this.omega[0][im] * this.quat[3][im];
        dq2 = dq2 * fndia + this.quat[2][im] * fdiag;
        double dq3 = -this.omega[2][im] * this.quat[0][im] + this.omega[1][im] * this.quat[1][im] - this.omega[0][im] * this.quat[2][im];
        dq3 = dq3 * fndia + this.quat[3][im] * fdiag;
        this.quat[0][im] = dq0;
        this.quat[1][im] = dq1;
        this.quat[2][im] = dq2;
        this.quat[3][im] = dq3;
    }

    void calc_angmom() {
        int im;
        for (im = 0; im < this.nmols; ++im) {
            for (int ic = 0; ic < 3; ++ic) {
                this.ombod[ic][im] = (this.amat[0][ic][im] * this.angmom[0][im] + this.amat[1][ic][im] * this.angmom[1][im] + this.amat[2][ic][im] * this.angmom[2][im]) / this.inertia[ic][im];
            }
        }
        for (im = 0; im < this.nmols; ++im) {
            double xaob = this.angmom[0][im] * (this.amat[0][1][im] * this.ombod[2][im] - this.amat[0][2][im] * this.ombod[1][im]);
            xaob += this.angmom[1][im] * (this.amat[1][1][im] * this.ombod[2][im] - this.amat[1][2][im] * this.ombod[1][im]);
            xaob += this.angmom[2][im] * (this.amat[2][1][im] * this.ombod[2][im] - this.amat[2][2][im] * this.ombod[1][im]);
            xaob = xaob + this.amat[0][0][im] * this.torque[0][im] + this.amat[1][0][im] * this.torque[1][im] + this.amat[2][0][im] * this.torque[2][im];
            xaob /= this.inertia[0][im];
            double yaob = this.angmom[0][im] * (this.amat[0][0][im] * this.ombod[2][im] - this.amat[0][2][im] * this.ombod[0][im]);
            yaob += this.angmom[1][im] * (this.amat[1][0][im] * this.ombod[2][im] - this.amat[1][2][im] * this.ombod[0][im]);
            yaob += this.angmom[2][im] * (this.amat[2][0][im] * this.ombod[2][im] - this.amat[2][2][im] * this.ombod[0][im]);
            yaob = yaob + this.amat[0][1][im] * this.torque[0][im] + this.amat[1][1][im] * this.torque[1][im] + this.amat[2][1][im] * this.torque[2][im];
            yaob = -yaob / this.inertia[1][im];
            double zaob = this.angmom[0][im] * (this.amat[0][0][im] * this.ombod[1][im] - this.amat[0][1][im] * this.ombod[0][im]);
            zaob += this.angmom[1][im] * (this.amat[1][0][im] * this.ombod[1][im] - this.amat[1][1][im] * this.ombod[0][im]);
            zaob += this.angmom[2][im] * (this.amat[2][0][im] * this.ombod[1][im] - this.amat[2][1][im] * this.ombod[0][im]);
            zaob = zaob + this.amat[0][2][im] * this.torque[0][im] + this.amat[1][2][im] * this.torque[1][im] + this.amat[2][2][im] * this.torque[2][im];
            this.omega[0][im] = this.ombod[0][im] + 0.5 * this.tstep * xaob;
            this.omega[1][im] = this.ombod[1][im] + 0.5 * this.tstep * yaob;
            this.omega[2][im] = this.ombod[2][im] + 0.5 * this.tstep * (zaob /= this.inertia[2][im]);
        }
    }

    void prepare() {
        this.calc_forces();
        for (int im = 0; im < this.nmols; ++im) {
            for (int ic = 0; ic < 3; ++ic) {
                double[] dArray = this.vcg[ic];
                int n = im;
                dArray[n] = dArray[n] + this.force[ic][im] * 0.5 * this.tsf / this.mass[im];
            }
        }
        this.calc_angmom();
    }

    void calc_en() {
        int i;
        this.ekin1 = this.vcg[0][0] * this.vcg[0][0] + this.vcg[1][0] * this.vcg[1][0] + this.vcg[2][0] * this.vcg[2][0];
        this.ekin1 = this.ekin1 * 0.5 * this.mass[0];
        this.ekin2 = this.vcg[0][1] * this.vcg[0][1] + this.vcg[1][1] * this.vcg[1][1] + this.vcg[2][1] * this.vcg[2][1];
        this.ekin2 = this.ekin2 * 0.5 * this.mass[1];
        this.erot1 = 0.0;
        this.erot2 = 0.0;
        for (i = 0; i < 3; ++i) {
            this.erot1 += this.ombod[i][0] * this.ombod[i][0] * this.inertia[i][0] * 0.5;
            this.erot2 += this.ombod[i][1] * this.ombod[i][1] * this.inertia[i][1] * 0.5;
        }
        this.vdwen = 0.0;
        for (i = 0; i < this.natoms1; ++i) {
            for (int j = this.natoms1; j < this.natoms; ++j) {
                double f12;
                for (int k = 0; k < 3; ++k) {
                    this.dr[k] = this.rlab[k][i] - this.rlab[k][j];
                    this.fij[k] = 0.0;
                }
                double d2 = this.dr[0] * this.dr[0] + this.dr[1] * this.dr[1] + this.dr[2] * this.dr[2];
                double vdwe = Math.sqrt(this.vdwedat(this.nat[i]) * this.vdwedat(this.nat[j]));
                double vdws = 0.5 * (this.vdwsdat(this.nat[i]) + this.vdwsdat(this.nat[j]));
                double d6 = d2 * d2 * d2;
                double d12 = d6 * d6;
                double fac = f12 = 4.0 * vdwe * Math.pow(vdws, 12.0) / d12;
                if (this.attractive) {
                    double f6 = -4.0 * vdwe * Math.pow(vdws, 6.0) / d6;
                    fac += f6;
                }
                this.vdwen += fac;
            }
        }
        this.vdwen /= 1.66E-23;
    }

    void advance() {
        int ic;
        int im;
        this.totaltime += this.tstep;
        this.drtx = 0.0;
        this.drty = 0.0;
        this.drtz = 0.0;
        for (im = 0; im < this.nmols; ++im) {
            for (ic = 0; ic < 3; ++ic) {
                double[] dArray = this.rcg[ic];
                int n = im;
                dArray[n] = dArray[n] + this.vcg[ic][im] * this.tstep;
            }
            this.rotate(im);
            this.newmatrix(im);
        }
        this.labcoords();
        this.calc_forces();
        for (im = 0; im < this.nmols; ++im) {
            for (ic = 0; ic < 3; ++ic) {
                double[] dArray = this.vcg[ic];
                int n = im;
                dArray[n] = dArray[n] + this.force[ic][im] * 0.5 * this.tsf / this.mass[im];
            }
        }
        this.calc_en();
        this.jLabel6.setText("Energy=" + this.df1.format(this.erot1 + this.erot2 + this.ekin1 + this.ekin2 + this.vdwen));
        for (im = 0; im < this.nmols; ++im) {
            for (ic = 0; ic < 3; ++ic) {
                this.angmom[ic][im] = this.angmom[ic][im] + this.torque[ic][im] * this.tsf;
            }
            this.drtx += this.mass[im] * (this.rcg[1][im] * this.vcg[2][im] - this.rcg[2][im] * this.vcg[1][im]);
            this.drty += this.mass[im] * (this.rcg[2][im] * this.vcg[0][im] - this.rcg[0][im] * this.vcg[2][im]);
            this.drtz += this.mass[im] * (this.rcg[0][im] * this.vcg[1][im] - this.rcg[1][im] * this.vcg[0][im]);
            this.zz = this.rcg[1][im] * this.vcg[0][im];
        }
        this.calc_angmom();
        for (im = 0; im < this.nmols; ++im) {
            for (ic = 0; ic < 3; ++ic) {
                double[] dArray = this.vcg[ic];
                int n = im;
                dArray[n] = dArray[n] + this.force[ic][im] * 0.5 * this.tsf / this.mass[im];
            }
        }
        this.jLabel4.setText("ang mom " + this.df.format(this.angmom[0][0] + this.angmom[0][1] + this.drtx) + " " + this.df.format(this.angmom[1][0] + this.angmom[1][1] + this.drty) + " " + this.df.format(this.angmom[2][0] + this.angmom[2][1] + this.drtz));
        if (this.count < 500) {
            this.values[0][this.count] = this.ekin1;
            this.values[1][this.count] = this.ekin2;
            this.values[2][this.count] = this.erot1;
            this.values[3][this.count] = this.erot2;
            this.values[4][this.count] = this.vdwen;
        }
    }

    public class myPanel2
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.imagea, 0, 0, null);
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

