/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    DecimalFormat df;
    DecimalFormat df1;
    double P;
    double H;
    double Peq;
    double Heq;
    double rp_val = 0.1;
    double Kp_val = 0.2;
    double Kh_val = 500.0;
    double rh_val = 0.2;
    double a_val = 0.3;
    double Th_val = 0.5;
    double m_val = 0.0;
    double timestep = 0.01;
    int nsteps = 100;
    double P_0 = 1.0;
    double H_0 = 1.0;
    int[] ip;
    int[] ih;
    int[] ii;
    int npoints = 500;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel11;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;
    private JSlider jSlider5;
    private JSlider jSlider6;
    private JSlider jSlider7;
    private JSlider jSlider8;
    private JSlider jSlider9;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.init_arrays();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent e) {
        this.timer.restart();
    }

    public void init_arrays() {
        this.ip = new int[this.npoints];
        this.ih = new int[this.npoints];
        this.ii = new int[this.npoints];
        this.df = new DecimalFormat("0.000");
        this.df1 = new DecimalFormat("0.000");
        this.rh_val = (double)this.jSlider1.getValue() * 0.001;
        this.jLabel1.setText("rH=" + this.df.format(this.rh_val));
        this.Kp_val = (double)this.jSlider2.getValue() * 0.01;
        this.jLabel3.setText("k=" + this.df.format(this.Kp_val));
        this.rp_val = (double)this.jSlider3.getValue() * 0.001;
        this.jLabel4.setText("rP=" + this.df.format(this.rp_val));
        this.Kh_val = this.jSlider4.getValue();
        this.jLabel2.setText("KH=" + this.df.format(this.Kh_val));
        this.nsteps = this.jSlider5.getValue();
        this.jLabel5.setText("steps" + this.nsteps);
        this.P_0 = this.jSlider6.getValue();
        this.jLabel6.setForeground(Color.red);
        this.jLabel6.setText("P(0)=" + this.df.format(this.P_0));
        this.jLabel7.setForeground(Color.blue);
        this.H_0 = this.jSlider7.getValue();
        this.jLabel7.setText("H(0)=" + this.df.format(this.H_0));
        this.a_val = (double)this.jSlider8.getValue() * 0.01;
        this.jLabel8.setText("alpha=" + this.df.format(this.a_val));
        this.Th_val = (double)this.jSlider9.getValue() * 0.01;
        this.jLabel9.setText("Th=" + this.df.format(this.Th_val));
    }

    public void rk2() {
        double dp = this.rp_val * this.P * (1.0 - this.P / (this.Kp_val * this.H));
        double dh = this.rh_val * this.H * (1.0 - this.H / this.Kh_val) - this.a_val * this.H * this.P / (1.0 + this.a_val * this.Th_val * this.H);
        double pp = this.P + dp * this.timestep * 0.5;
        double hp = this.H + dh * this.timestep * 0.5;
        dp = this.rp_val * pp * (1.0 - pp / (this.Kp_val * hp));
        dh = this.rh_val * hp * (1.0 - hp / this.Kh_val) - this.a_val * hp * pp / (1.0 + this.a_val * this.Th_val * hp);
        this.P += dp * this.timestep;
        this.H += dh * this.timestep;
    }

    public void euler() {
        double dp = this.rh_val * this.H * this.P - this.Kh_val * this.P;
        double dh = this.rp_val * this.H - this.Kp_val * this.H * this.P;
        this.P += dp * this.timestep;
        this.H += dh * this.timestep;
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel10 = new JLabel();
        this.jLabel11 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jSlider4 = new JSlider();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jSlider6 = new JSlider();
        this.jSlider7 = new JSlider();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSlider2 = new JSlider();
        this.jSlider8 = new JSlider();
        this.jSlider9 = new JSlider();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jButton1 = new JButton();
        this.jSlider5 = new JSlider();
        this.jLabel5 = new JLabel();
        this.jPanel1.setMaximumSize(new Dimension(500, 700));
        this.jPanel1.setMinimumSize(new Dimension(500, 700));
        this.jLabel10.setText("jLabel10");
        this.jLabel11.setText("jLabel10");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10, -2, 351, -2)).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel11, -2, 351, -2))).addContainerGap(137, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel10).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel11).addContainerGap(-1, Short.MAX_VALUE)));
        this.jSlider1.setMaximum(1000);
        this.jSlider1.setValue(100);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider3.setMajorTickSpacing(1);
        this.jSlider3.setMaximum(2000);
        this.jSlider3.setValue(200);
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jSlider4.setMaximum(1000);
        this.jSlider4.setValue(500);
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel1.setText("jLabel1");
        this.jLabel2.setText("jLabel1");
        this.jLabel4.setText("jLabel1");
        this.jSlider6.setMaximum(500);
        this.jSlider6.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider6MouseDragged(evt);
            }
        });
        this.jSlider7.setMaximum(500);
        this.jSlider7.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider7MouseDragged(evt);
            }
        });
        this.jLabel6.setText("jLabel6");
        this.jLabel7.setText("jLabel7");
        this.jLabel3.setText("jLabel1");
        this.jSlider2.setMinimum(1);
        this.jSlider2.setValue(20);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jSlider8.setMaximum(150);
        this.jSlider8.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider8MouseDragged(evt);
            }
        });
        this.jSlider9.setMaximum(150);
        this.jSlider9.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider9MouseDragged(evt);
            }
        });
        this.jLabel8.setText("jLabel8");
        this.jLabel9.setText("jLabel9");
        this.jButton1.setText("eq");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jSlider5.setMaximumSize(new Dimension(200, 24));
        this.jSlider5.setMinimumSize(new Dimension(200, 24));
        this.jSlider5.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider5MouseDragged(evt);
            }
        });
        this.jLabel5.setText("jLabel5");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(80, 80, 80).addComponent(this.jLabel1)).addComponent(this.jSlider1, -1, 153, Short.MAX_VALUE).addComponent(this.jSlider3, -1, 153, Short.MAX_VALUE).addComponent(this.jSlider2, -1, 153, Short.MAX_VALUE).addComponent(this.jSlider4, 0, 0, Short.MAX_VALUE).addComponent(this.jSlider8, 0, 0, Short.MAX_VALUE).addComponent(this.jSlider9, 0, 0, Short.MAX_VALUE).addComponent(this.jSlider6, -1, 145, Short.MAX_VALUE).addComponent(this.jSlider7, -2, 0, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(78, 78, 78).addComponent(this.jLabel3)).addGroup(layout.createSequentialGroup().addGap(77, 77, 77).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addGap(74, 74, 74).addComponent(this.jLabel4)).addGroup(layout.createSequentialGroup().addGap(74, 74, 74).addComponent(this.jLabel8)).addGroup(layout.createSequentialGroup().addGap(75, 75, 75).addComponent(this.jLabel9)).addGroup(layout.createSequentialGroup().addGap(79, 79, 79).addComponent(this.jLabel6)).addGroup(layout.createSequentialGroup().addGap(76, 76, 76).addComponent(this.jLabel7)).addComponent(this.jSlider5, -2, 156, -2)).addComponent(this.jButton1, GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addGap(63, 63, 63).addComponent(this.jLabel5))).addContainerGap(68, Short.MAX_VALUE)));
        layout.linkSize(0, this.jSlider1, this.jSlider2, this.jSlider3, this.jSlider4, this.jSlider6, this.jSlider7, this.jSlider8, this.jSlider9);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, 606, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addGap(2, 2, 2).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel8).addGap(5, 5, 5).addComponent(this.jSlider8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel9).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider9, -2, -1, -2).addGap(56, 56, 56).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider7, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider5, -2, -1, -2))).addContainerGap()));
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.rh_val = (double)this.jSlider1.getValue() * 0.001;
        this.jLabel1.setText("rH=" + this.df.format(this.rh_val));
        this.jPanel1.repaint();
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.Kp_val = (double)this.jSlider2.getValue() * 0.01;
        this.jLabel3.setText("k=" + this.df.format(this.Kp_val));
        this.jPanel1.repaint();
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.rp_val = (double)this.jSlider3.getValue() * 0.001;
        this.jLabel4.setText("rP=" + this.df.format(this.rp_val));
        this.jPanel1.repaint();
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.Kh_val = this.jSlider4.getValue();
        this.jLabel2.setText("KH=" + this.df.format(this.Kh_val));
        this.jPanel1.repaint();
    }

    private void jSlider5MouseDragged(MouseEvent evt) {
        this.nsteps = this.jSlider5.getValue();
        this.jLabel5.setText("steps " + this.nsteps);
        this.jPanel1.repaint();
    }

    private void jSlider6MouseDragged(MouseEvent evt) {
        this.P_0 = this.jSlider6.getValue();
        this.jLabel6.setText("P(0)=" + this.df.format(this.P_0));
        this.jPanel1.repaint();
    }

    private void jSlider7MouseDragged(MouseEvent evt) {
        this.H_0 = this.jSlider7.getValue();
        this.jLabel7.setText("H(0)=" + this.df.format(this.H_0));
        this.jPanel1.repaint();
    }

    private void jSlider8MouseDragged(MouseEvent evt) {
        this.a_val = (double)this.jSlider8.getValue() * 0.01;
        this.jLabel8.setText("alpha=" + this.df.format(this.a_val));
        this.jPanel1.repaint();
    }

    private void jSlider9MouseDragged(MouseEvent evt) {
        this.Th_val = (double)this.jSlider9.getValue() * 0.01;
        this.jLabel9.setText("Th=" + this.df.format(this.Th_val));
        this.jPanel1.repaint();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.H_0 = this.Heq + 0.01;
        this.P_0 = this.Peq;
        this.jLabel7.setText("H=" + this.df.format(this.H_0));
        this.jLabel6.setText("P=" + this.df.format(this.P_0));
        this.jPanel1.repaint();
    }

    public class myPanel
    extends JPanel {
        public void paintComponent(Graphics g) {
            int i;
            double re1;
            super.paintComponent(g);
            double a = 1.0 / NewJApplet.this.Kh_val;
            double b = NewJApplet.this.a_val * NewJApplet.this.Th_val;
            double c = NewJApplet.this.a_val * NewJApplet.this.Kp_val / NewJApplet.this.rh_val;
            double re2 = re1 = b - a - c;
            double im1 = 0.0;
            double im2 = 0.0;
            double ss = (a + b + c) * (a + b + c) - 4.0 * b * c;
            if (ss > 0.0) {
                re1 += Math.sqrt(ss);
                re2 -= Math.sqrt(ss);
            } else {
                im1 = Math.sqrt(-ss);
                im2 = -im1;
            }
            re1 /= 2.0 * a * b;
            re2 /= 2.0 * a * b;
            im1 /= 2.0 * a * b;
            im2 /= 2.0 * a * b;
            double a0 = -NewJApplet.this.rh_val * NewJApplet.this.Kh_val;
            double a1 = NewJApplet.this.rh_val + NewJApplet.this.a_val * NewJApplet.this.Kp_val * NewJApplet.this.Kh_val - NewJApplet.this.rh_val * NewJApplet.this.Kh_val * NewJApplet.this.a_val * NewJApplet.this.Th_val;
            double a2 = NewJApplet.this.rh_val * NewJApplet.this.a_val * NewJApplet.this.Th_val;
            NewJApplet.this.Heq = (Math.sqrt(a1 * a1 - 4.0 * a0 * a2) - a1) / (2.0 * a2);
            NewJApplet.this.Peq = NewJApplet.this.Kp_val * NewJApplet.this.Heq;
            double app = -NewJApplet.this.rp_val;
            double aph = NewJApplet.this.rp_val * NewJApplet.this.Kp_val;
            double ahp = -NewJApplet.this.a_val * NewJApplet.this.Heq / (1.0 + NewJApplet.this.a_val * NewJApplet.this.Th_val * NewJApplet.this.Heq);
            a0 = NewJApplet.this.a_val * NewJApplet.this.Heq / (1.0 + NewJApplet.this.a_val * NewJApplet.this.Th_val * NewJApplet.this.Heq);
            double ahh = NewJApplet.this.rh_val - 2.0 * NewJApplet.this.rh_val * NewJApplet.this.Heq / NewJApplet.this.Kh_val - NewJApplet.this.a_val * NewJApplet.this.Kp_val * NewJApplet.this.Heq / (1.0 + NewJApplet.this.a_val * NewJApplet.this.Th_val * NewJApplet.this.Heq) + NewJApplet.this.Kp_val * NewJApplet.this.Th_val * a0 * a0;
            double tr = app + ahh;
            double det = app * ahh - aph * ahp;
            re1 = 0.5 * tr;
            re2 = 0.5 * tr;
            im1 = 0.0;
            im2 = 0.0;
            ss = tr * tr - 4.0 * det;
            if (ss > 0.0) {
                re1 += 0.5 * Math.sqrt(ss);
                re2 -= 0.5 * Math.sqrt(ss);
            } else {
                im1 = 0.5 * Math.sqrt(-ss);
                im2 = -im1;
            }
            NewJApplet.this.jLabel10.setText("  Heq=" + NewJApplet.this.df.format(NewJApplet.this.Heq) + "  Peq=" + NewJApplet.this.df.format(NewJApplet.this.Peq));
            if (ss > 0.0) {
                NewJApplet.this.jLabel11.setText("  eigv1=" + NewJApplet.this.df.format(re1) + "  eigv2=" + NewJApplet.this.df.format(re2));
            } else {
                NewJApplet.this.jLabel11.setText("  eigv=" + NewJApplet.this.df.format(re1) + " +-I* " + NewJApplet.this.df.format(im1));
            }
            NewJApplet.this.P = NewJApplet.this.P_0;
            NewJApplet.this.H = NewJApplet.this.H_0;
            int iy1 = 300 - (int)(NewJApplet.this.P * 0.3);
            int iy2 = 300 - (int)(NewJApplet.this.H * 0.3);
            NewJApplet.this.ii[0] = 0;
            NewJApplet.this.ih[0] = iy2;
            NewJApplet.this.ip[0] = iy1;
            for (i = 1; i < NewJApplet.this.npoints; ++i) {
                for (int k = 0; k < NewJApplet.this.nsteps; ++k) {
                    NewJApplet.this.rk2();
                }
                iy1 = 300 - (int)(NewJApplet.this.P * 0.3);
                iy2 = 300 - (int)(NewJApplet.this.H * 0.3);
                NewJApplet.this.ii[i] = i;
                NewJApplet.this.ih[i] = iy2;
                NewJApplet.this.ip[i] = iy1;
            }
            iy1 = 300 - (int)(0.3 * NewJApplet.this.Peq);
            iy2 = 300 - (int)(0.3 * NewJApplet.this.Heq);
            g.setColor(Color.darkGray);
            g.drawLine(0, iy1, NewJApplet.this.npoints, iy1);
            g.drawLine(0, iy2, NewJApplet.this.npoints, iy2);
            g.setColor(Color.blue);
            g.drawPolyline(NewJApplet.this.ii, NewJApplet.this.ih, NewJApplet.this.npoints);
            g.setColor(Color.red);
            g.drawPolyline(NewJApplet.this.ii, NewJApplet.this.ip, NewJApplet.this.npoints);
            for (i = 0; i < NewJApplet.this.npoints; ++i) {
                NewJApplet.this.ih[i] = (iy2 - NewJApplet.this.ih[i]) * 2 + 200;
                NewJApplet.this.ip[i] = (NewJApplet.this.ip[i] - iy1) * 2 + 500;
            }
            g.drawPolyline(NewJApplet.this.ih, NewJApplet.this.ip, NewJApplet.this.npoints);
            g.setColor(Color.BLACK);
            g.drawLine(100, 500, 300, 500);
            g.drawString(" H-Heq", 300, 500);
            g.drawLine(200, 400, 200, 600);
            g.drawString(" P-Peq", 200, 400);
        }
    }
}

