/*
 * Decompiled with CFR 0.152.
 */
package gpoly;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    Timer timer;
    public int number_segments;
    public int numb_loops;
    public int n_aver;
    public int iav;
    public int ndata;
    public int window_w = 10;
    public double emin;
    public double elast;
    public double etot;
    public double xharm;
    public double kT;
    public double kappa;
    public double length;
    public double ekin;
    public double epot;
    public double tstep;
    public double damp;
    public double[] xcoor;
    public double[] ycoor;
    public double[] xtry;
    public double[] ytry;
    public double[] forcx;
    public double[] forcy;
    public double[] vx;
    public double[] vy;
    public double[] datax;
    public double[] datay;
    public double eq_distance;
    double stdv;
    double ekinav;
    double epotav;
    double lengav;
    double extensav;
    double extensavn;
    double extenq;
    DecimalFormat df;
    DecimalFormat df2;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSlider1;
    private JSlider jSlider2;
    private JSlider jSlider3;
    private JSlider jSlider4;

    public void actionPerformed(ActionEvent e) {
        this.jPanel1.repaint();
        this.jPanel2.repaint();
        this.timer.restart();
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                    NewJApplet.this.setupsegments();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        DecimalFormatSymbols unusualSymbols = new DecimalFormatSymbols();
        unusualSymbols.setDecimalSeparator('.');
        this.df = new DecimalFormat("##0.00000000", unusualSymbols);
        this.df2 = new DecimalFormat("##0.00", unusualSymbols);
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jSlider2 = new JSlider();
        this.jSlider3 = new JSlider();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jSlider4 = new JSlider();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jPanel2 = new myPanel2();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(400, 350));
        this.jPanel1.setMinimumSize(new Dimension(400, 350));
        this.jPanel1.setOpaque(false);
        this.jPanel1.setPreferredSize(new Dimension(400, 350));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 348, Short.MAX_VALUE));
        this.jLabel1.setText("Epot");
        this.jLabel2.setText("length");
        this.jLabel3.setText("extension");
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jSlider2.setMinimum(-100);
        this.jSlider2.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider2MouseDragged(evt);
            }
        });
        this.jSlider3.setMaximum(500);
        this.jSlider3.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider3MouseDragged(evt);
            }
        });
        this.jLabel4.setText("jLabel1");
        this.jLabel5.setText("jLabel1");
        this.jLabel6.setText("jLabel1");
        this.jSlider4.setMaximum(200);
        this.jSlider4.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider4MouseDragged(evt);
            }
        });
        this.jLabel7.setText("jLabel1");
        this.jLabel8.setText("Ekin");
        this.jLabel9.setText("Etot");
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(400, 200));
        this.jPanel2.setMinimumSize(new Dimension(400, 200));
        this.jPanel2.setPreferredSize(new Dimension(400, 200));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 398, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 198, Short.MAX_VALUE));
        this.jButton1.setText("store");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("reset");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addComponent(this.jSlider2, -2, -1, -2)).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel2, -2, -1, -2).addComponent(this.jPanel1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -2, 183, -2).addComponent(this.jLabel4, -2, 180, -2).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE)).addGap(24, 24, 24)).addComponent(this.jLabel1, -2, 213, -2).addComponent(this.jLabel8, -2, 202, -2).addComponent(this.jLabel9, -2, 204, -2).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel2, GroupLayout.Alignment.LEADING, -1, 213, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addGap(18, 18, 18).addComponent(this.jButton2))))).addContainerGap(394, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGap(432, 432, 432).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jSlider1, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jSlider3, -1, -1, Short.MAX_VALUE).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jSlider4, -1, -1, Short.MAX_VALUE).addContainerGap()))));
        layout.linkSize(0, this.jSlider1, this.jSlider2, this.jSlider3, this.jSlider4);
        layout.linkSize(0, this.jLabel1, this.jLabel2, this.jLabel3, this.jLabel8, this.jLabel9);
        layout.linkSize(0, this.jLabel4, this.jLabel5, this.jLabel6, this.jLabel7);
        layout.linkSize(0, this.jButton1, this.jButton2);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(28, 28, 28).addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel9).addGap(85, 85, 85).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3).addGap(71, 71, 71).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addGap(39, 39, 39).addComponent(this.jLabel4, -2, 16, -2))).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(2, 2, 2).addComponent(this.jSlider1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jLabel5).addGap(1, 1, 1).addComponent(this.jSlider2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6).addGap(1, 1, 1).addComponent(this.jSlider3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel7).addGap(1, 1, 1).addComponent(this.jSlider4, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addComponent(this.jPanel2, -2, -1, -2))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.jSlider1, this.jSlider2, this.jSlider3, this.jSlider4);
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.damp = (double)this.jSlider1.getValue() * 0.1;
    }

    private void jSlider2MouseDragged(MouseEvent evt) {
        this.kappa = (double)this.jSlider2.getValue() * 0.1;
    }

    private void jSlider3MouseDragged(MouseEvent evt) {
        this.xharm = this.jSlider3.getValue();
    }

    private void jSlider4MouseDragged(MouseEvent evt) {
        this.kT = (double)this.jSlider4.getValue() * 0.01;
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.ndata < 99) {
            this.datax[this.ndata] = this.kappa;
            this.datay[this.ndata] = this.extensavn;
            ++this.ndata;
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.ndata = 0;
    }

    public void setupsegments() {
        this.number_segments = 20;
        this.eq_distance = 1.0;
        this.kT = 0.0;
        this.tstep = 0.01;
        this.damp = 0.1;
        this.emin = 1000.0;
        this.elast = 1000.0;
        this.etot = 1000.0;
        this.xharm = 10.0;
        this.kT = 10.0;
        this.kappa = 0.0;
        this.numb_loops = 10;
        this.n_aver = 250;
        this.iav = 0;
        this.ekinav = 0.0;
        this.epotav = 0.0;
        this.lengav = 0.0;
        this.extensav = 0.0;
        this.extensavn = 0.0;
        this.extenq = 0.0;
        this.xcoor = new double[this.number_segments];
        this.ycoor = new double[this.number_segments];
        this.xtry = new double[this.number_segments];
        this.ytry = new double[this.number_segments];
        this.forcx = new double[this.number_segments];
        this.forcy = new double[this.number_segments];
        this.vx = new double[this.number_segments];
        this.vy = new double[this.number_segments];
        this.xcoor[0] = 0.0;
        this.ycoor[0] = 0.0;
        this.vx[0] = 0.0;
        this.vy[0] = 0.0;
        this.datax = new double[100];
        this.datay = new double[100];
        this.ndata = 0;
        for (int i = 1; i < this.number_segments; ++i) {
            this.xcoor[i] = (double)i * this.eq_distance;
            this.ycoor[i] = Math.random() * 0.2 - 0.1;
            this.vx[i] = 0.0;
            this.vy[i] = 0.0;
        }
        this.jSlider1.setValue((int)(10.0 * this.damp));
        this.jSlider2.setValue((int)(this.kappa * 10.0));
        this.jSlider3.setValue((int)this.xharm);
        this.jSlider4.setValue((int)(100.0 * this.kT));
    }

    public double randgauss() {
        double r = Math.random();
        double phi = Math.PI * 2 * r;
        r = Math.random();
        double rho = Math.sqrt(-Math.log(1.0 - r));
        double x = rho * Math.cos(phi) * Math.sqrt(2.0);
        return x;
    }

    class myPanel
    extends JPanel {
        int ix;
        int iy;
        int ix1;
        int iy1;
        int i2;
        int i;
        double sx;
        double sy;
        double rx;
        double ry;
        double r2;
        double r2s;
        double r;
        double edel;
        double bofa;
        double rn;

        myPanel() {
        }

        public void verlet() {
            NewJApplet.this.elast = NewJApplet.this.etot;
            NewJApplet.this.etot = 0.0;
            NewJApplet.this.length = 0.0;
            NewJApplet.this.epot = 0.0;
            NewJApplet.this.ekin = 0.0;
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                NewJApplet.this.xcoor[this.i] = NewJApplet.this.xcoor[this.i] + NewJApplet.this.vx[this.i] * NewJApplet.this.tstep * 0.5;
                NewJApplet.this.ycoor[this.i] = NewJApplet.this.ycoor[this.i] + NewJApplet.this.vy[this.i] * NewJApplet.this.tstep * 0.5;
                ++this.i;
            }
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                NewJApplet.this.forcx[this.i] = NewJApplet.this.randgauss() * Math.sqrt(2.0 * NewJApplet.this.kT * NewJApplet.this.damp / NewJApplet.this.tstep);
                NewJApplet.this.forcy[this.i] = NewJApplet.this.randgauss() * Math.sqrt(2.0 * NewJApplet.this.kT * NewJApplet.this.damp / NewJApplet.this.tstep);
                ++this.i;
            }
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                this.rx = NewJApplet.this.xcoor[this.i] - NewJApplet.this.xcoor[this.i - 1];
                this.ry = NewJApplet.this.ycoor[this.i] - NewJApplet.this.ycoor[this.i - 1];
                this.r2 = this.rx * this.rx + this.ry * this.ry;
                this.r2s = Math.sqrt(this.r2);
                this.r = this.r2s - NewJApplet.this.eq_distance;
                NewJApplet.this.forcx[this.i] = NewJApplet.this.forcx[this.i] - NewJApplet.this.xharm * this.r * this.rx / this.r2s - NewJApplet.this.damp * NewJApplet.this.vx[this.i];
                NewJApplet.this.forcy[this.i] = NewJApplet.this.forcy[this.i] - NewJApplet.this.xharm * this.r * this.ry / this.r2s - NewJApplet.this.damp * NewJApplet.this.vy[this.i];
                if (this.i > 1) {
                    NewJApplet.this.forcx[this.i - 1] = NewJApplet.this.forcx[this.i - 1] + NewJApplet.this.xharm * this.r * this.rx / this.r2s;
                    NewJApplet.this.forcy[this.i - 1] = NewJApplet.this.forcy[this.i - 1] + NewJApplet.this.xharm * this.r * this.ry / this.r2s;
                }
                ++this.i;
            }
            int n = NewJApplet.this.number_segments - 1;
            NewJApplet.this.forcx[n] = NewJApplet.this.forcx[n] + NewJApplet.this.kappa * 0.1;
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                NewJApplet.this.vx[this.i] = NewJApplet.this.vx[this.i] + NewJApplet.this.forcx[this.i] * NewJApplet.this.tstep;
                NewJApplet.this.vy[this.i] = NewJApplet.this.vy[this.i] + NewJApplet.this.forcy[this.i] * NewJApplet.this.tstep;
                ++this.i;
            }
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                NewJApplet.this.xcoor[this.i] = NewJApplet.this.xcoor[this.i] + NewJApplet.this.vx[this.i] * NewJApplet.this.tstep * 0.5;
                NewJApplet.this.ycoor[this.i] = NewJApplet.this.ycoor[this.i] + NewJApplet.this.vy[this.i] * NewJApplet.this.tstep * 0.5;
                ++this.i;
            }
        }

        public void calc_energy() {
            NewJApplet.this.epot = 0.0;
            NewJApplet.this.length = 0.0;
            NewJApplet.this.ekin = 0.0;
            this.i = 1;
            while (this.i < NewJApplet.this.number_segments) {
                this.rx = NewJApplet.this.xcoor[this.i] - NewJApplet.this.xcoor[this.i - 1];
                this.ry = NewJApplet.this.ycoor[this.i] - NewJApplet.this.ycoor[this.i - 1];
                this.r2 = this.rx * this.rx + this.ry * this.ry;
                this.r2s = Math.sqrt(this.r2);
                this.r = this.r2s - NewJApplet.this.eq_distance;
                NewJApplet.this.epot += 0.5 * NewJApplet.this.xharm * this.r * this.r;
                NewJApplet.this.length += this.r2s;
                NewJApplet.this.ekin += NewJApplet.this.vx[this.i] * NewJApplet.this.vx[this.i] + NewJApplet.this.vy[this.i] * NewJApplet.this.vy[this.i];
                ++this.i;
            }
            NewJApplet.this.ekin *= 0.5;
            NewJApplet.this.epot -= NewJApplet.this.kappa * 0.1 * NewJApplet.this.xcoor[NewJApplet.this.number_segments - 1];
        }

        public void paintComponent(Graphics g) {
            int iy;
            int ix;
            super.paintComponent(g);
            Graphics g2 = NewJApplet.this.jPanel2.getGraphics();
            NewJApplet.this.jLabel7.setText("" + NewJApplet.this.kT * 1.0);
            NewJApplet.this.xtry[0] = 0.0;
            NewJApplet.this.ytry[0] = 0.0;
            if (NewJApplet.this.iav == 0) {
                NewJApplet.this.ekinav = 0.0;
                NewJApplet.this.epotav = 0.0;
                NewJApplet.this.lengav = 0.0;
                NewJApplet.this.extensav = 0.0;
                NewJApplet.this.extenq = 0.0;
            }
            for (int iverl = 0; iverl < NewJApplet.this.numb_loops; ++iverl) {
                this.verlet();
            }
            this.calc_energy();
            NewJApplet.this.ekinav += NewJApplet.this.ekin;
            NewJApplet.this.epotav += NewJApplet.this.epot;
            NewJApplet.this.lengav += NewJApplet.this.length;
            NewJApplet.this.extensav += NewJApplet.this.xcoor[NewJApplet.this.number_segments - 1];
            NewJApplet.this.extenq += NewJApplet.this.xcoor[NewJApplet.this.number_segments - 1] * NewJApplet.this.xcoor[NewJApplet.this.number_segments - 1];
            ++NewJApplet.this.iav;
            if (NewJApplet.this.iav >= NewJApplet.this.n_aver) {
                NewJApplet.this.iav = 0;
                NewJApplet.this.extensavn = NewJApplet.this.extensav / (double)NewJApplet.this.n_aver;
                NewJApplet.this.extenq /= (double)NewJApplet.this.n_aver;
                NewJApplet.this.stdv = Math.sqrt(NewJApplet.this.extenq - NewJApplet.this.extensavn * NewJApplet.this.extensavn);
                NewJApplet.this.lengav /= (double)NewJApplet.this.n_aver;
                NewJApplet.this.jLabel1.setText("Epot:" + NewJApplet.this.df.format(NewJApplet.this.epotav / (double)NewJApplet.this.n_aver));
                NewJApplet.this.jLabel8.setText("Ekin:" + NewJApplet.this.df.format(NewJApplet.this.ekinav / (double)NewJApplet.this.n_aver));
                NewJApplet.this.jLabel9.setText("Etot:" + NewJApplet.this.df.format((NewJApplet.this.ekinav + NewJApplet.this.epotav) / (double)NewJApplet.this.n_aver));
                NewJApplet.this.jLabel2.setText("length:" + NewJApplet.this.df.format(NewJApplet.this.lengav));
                NewJApplet.this.jLabel3.setText("extension:" + NewJApplet.this.df2.format(NewJApplet.this.extensavn) + " +- " + NewJApplet.this.df2.format(NewJApplet.this.stdv));
            }
            NewJApplet.this.jLabel5.setText("force:" + NewJApplet.this.df2.format(NewJApplet.this.kappa * 0.1));
            NewJApplet.this.jLabel4.setText("friction:" + NewJApplet.this.df2.format(NewJApplet.this.damp));
            NewJApplet.this.jLabel6.setText("spring:" + NewJApplet.this.df2.format(NewJApplet.this.xharm));
            NewJApplet.this.jLabel7.setText("temperature:" + NewJApplet.this.df2.format(NewJApplet.this.kT));
            NewJApplet.this.jPanel2.repaint();
            g.setColor(Color.black);
            this.i = 0;
            while (this.i < NewJApplet.this.number_segments) {
                ix = (int)(NewJApplet.this.xcoor[this.i] * (double)NewJApplet.this.window_w + 200.0);
                iy = (int)(200.0 - NewJApplet.this.ycoor[this.i] * (double)NewJApplet.this.window_w);
                if (this.i == NewJApplet.this.number_segments - 1) {
                    g.setColor(Color.red);
                }
                g.drawOval(ix - 5, iy - 5, 10, 10);
                ++this.i;
            }
            g.setColor(Color.black);
            this.i = 0;
            while (this.i < NewJApplet.this.number_segments - 1) {
                ix = (int)(NewJApplet.this.xcoor[this.i] * (double)NewJApplet.this.window_w + 200.0);
                iy = (int)(200.0 - NewJApplet.this.ycoor[this.i] * (double)NewJApplet.this.window_w);
                this.ix1 = (int)(NewJApplet.this.xcoor[this.i + 1] * (double)NewJApplet.this.window_w + 200.0);
                this.iy1 = (int)(200.0 - NewJApplet.this.ycoor[this.i + 1] * (double)NewJApplet.this.window_w);
                g.drawLine(ix, iy, this.ix1, this.iy1);
                ++this.i;
            }
        }
    }

    class myPanel2
    extends JPanel {
        myPanel2() {
        }

        public void paintComponent(Graphics g) {
            int iy;
            int ix;
            g.clearRect(1, 1, 400, 200);
            g.drawLine(0, 100, 400, 100);
            g.drawLine(200, 0, 200, 200);
            g.drawString("force", 350, 90);
            g.drawString("extension", 210, 10);
            g.setColor(Color.black);
            for (int ida = 0; ida < NewJApplet.this.ndata; ++ida) {
                ix = (int)(NewJApplet.this.datax[ida] * 15.0);
                iy = (int)(NewJApplet.this.datay[ida] * 5.0);
                g.drawOval(200 + ix - 5, 100 - iy - 5, 10, 10);
            }
            g.setColor(Color.red);
            ix = (int)(NewJApplet.this.kappa * 15.0);
            iy = (int)(NewJApplet.this.extensavn * 5.0);
            g.drawOval(200 + ix - 5, 100 - iy - 5, 10, 10);
            iy = (int)((NewJApplet.this.extensavn - NewJApplet.this.stdv) * 5.0);
            int iy1 = (int)((NewJApplet.this.extensavn + NewJApplet.this.stdv) * 5.0);
            g.drawLine(200 + ix, 100 - iy, 200 + ix, 100 - iy1);
        }
    }
}

