/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int i;
    int j;
    int k;
    int l;
    int loop;
    double dxxt;
    double tt;
    double sp2;
    double time_now;
    double dxx;
    double dv;
    double da;
    double[] ampl;
    double[] velo;
    double[] oldsd;
    int NDIM = 500;
    int NITER = 10000;
    double space_grid = 0.001;
    double time_grid = 0.001;
    double c0s = 0.05;
    double c00s = 0.05;
    double dc = -0.005;
    double omega = 20.0;
    double omega0 = 20.0;
    double damp = 2.0;
    double TP = 0.1;
    double TP0 = 0.1;
    double cutoff = 0.4;
    double phase = 0.0;
    double refr = 1.0;
    double refr0 = 1.0;
    boolean nonlinear = false;
    int pulsetype = 0;
    int boundtype = 0;
    int anispeed = 1;
    private JLabel c0lab;
    private JSlider c0slider;
    private JButton clearbutton;
    private JLabel cutofflabel;
    private JSlider cutoffslider;
    private JLabel damplab;
    private JSlider dampslider;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JSlider jSlider1;
    private JLabel refrlabel;
    private JSlider refrslider;

    public void actionPerformed(ActionEvent e) {
        for (int iw = 0; iw < this.anispeed; ++iw) {
            this.waves();
        }
        this.draw();
        this.timer.setInitialDelay(1);
        this.timer.setDelay(1);
        this.timer.restart();
    }

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("0.000");
        this.ampl = new double[this.NDIM];
        this.velo = new double[this.NDIM];
        this.oldsd = new double[this.NDIM];
        this.image = new BufferedImage(550, 650, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 550, 650);
        this.cutofflabel.setText("pulse width=" + this.df1.format(this.TP));
        this.cutoffslider.setValue((int)(this.TP * 200.0));
        this.dampslider.setValue((int)(100.0 * this.damp));
        this.damplab.setText("damping=" + this.df1.format(this.damp));
        this.c0slider.setValue((int)(this.c0s * 100.0));
        this.c0lab.setText("velocity=Courant=" + this.df1.format(Math.sqrt(this.c0s)));
        this.refrslider.setValue((int)(100.0 * this.refr));
        this.refrlabel.setText("index of refr=" + this.df1.format(this.refr0));
        this.jSlider1.setValue(1);
        this.reset_all();
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.dampslider = new JSlider();
        this.damplab = new JLabel();
        this.cutoffslider = new JSlider();
        this.cutofflabel = new JLabel();
        this.clearbutton = new JButton();
        this.jComboBox1 = new JComboBox();
        this.c0slider = new JSlider();
        this.c0lab = new JLabel();
        this.refrslider = new JSlider();
        this.refrlabel = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jSlider1 = new JSlider();
        this.jLabel2 = new JLabel();
        this.jLabel1 = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setDoubleBuffered(false);
        this.jPanel1.setMaximumSize(new Dimension(500, 550));
        this.jPanel1.setMinimumSize(new Dimension(500, 550));
        this.jPanel1.setPreferredSize(new Dimension(500, 550));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 498, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 548, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(180, 550));
        this.jPanel2.setMinimumSize(new Dimension(180, 550));
        this.jPanel2.setPreferredSize(new Dimension(180, 550));
        this.dampslider.setMaximum(310);
        this.dampslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.dampsliderMouseDragged(evt);
            }
        });
        this.damplab.setText("jLabel1");
        this.cutoffslider.setMajorTickSpacing(20);
        this.cutoffslider.setMaximum(200);
        this.cutoffslider.setMinimum(5);
        this.cutoffslider.setToolTipText("pulse period");
        this.cutoffslider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.cutoffsliderMouseReleased(evt);
            }
        });
        this.cutoffslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.cutoffsliderMouseDragged(evt);
            }
        });
        this.cutofflabel.setText("jLabel1");
        this.clearbutton.setText("clear");
        this.clearbutton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.clearbuttonActionPerformed(evt);
            }
        });
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"continuous sine", "triangle pulse", "square puls", "Gaussian pulse", "pulse train"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.c0slider.setMinimum(2);
        this.c0slider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.c0sliderMouseDragged(evt);
            }
        });
        this.c0lab.setText("jLabel1");
        this.refrslider.setMajorTickSpacing(20);
        this.refrslider.setMaximum(200);
        this.refrslider.setMinimum(2);
        this.refrslider.setToolTipText("");
        this.refrslider.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent evt) {
                NewJApplet.this.refrsliderMouseReleased(evt);
            }
        });
        this.refrslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.refrsliderMouseDragged(evt);
            }
        });
        this.refrlabel.setText("jLabel1");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"fixed end", "open end"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox2ActionPerformed(evt);
            }
        });
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setMaximum(20);
        this.jSlider1.setMinimum(1);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel2.setText("animation speeed");
        this.jLabel1.setText("jLabel1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(56, 56, 56).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.damplab).addComponent(this.cutofflabel).addComponent(this.refrlabel).addComponent(this.jLabel2).addComponent(this.jLabel1))).addGroup(jPanel2Layout.createSequentialGroup().addGap(42, 42, 42).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSlider1, -2, 0, Short.MAX_VALUE).addComponent(this.refrslider, -2, 0, Short.MAX_VALUE).addComponent(this.cutoffslider, -2, 0, Short.MAX_VALUE).addComponent(this.c0slider, -2, 117, -2).addComponent(this.dampslider, -2, 0, Short.MAX_VALUE)))).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.c0lab, -1, -1, Short.MAX_VALUE)).addGroup(jPanel2Layout.createSequentialGroup().addGap(42, 42, 42).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jComboBox1, GroupLayout.Alignment.LEADING, 0, 135, Short.MAX_VALUE).addComponent(this.clearbutton, -1, 135, Short.MAX_VALUE).addComponent(this.jComboBox2, GroupLayout.Alignment.LEADING, 0, 135, Short.MAX_VALUE)))).addGap(33, 33, 33)));
        jPanel2Layout.linkSize(0, this.c0slider, this.cutoffslider, this.dampslider, this.jSlider1, this.refrslider);
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.damplab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dampslider, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.c0lab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.c0slider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.cutofflabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cutoffslider, -2, -1, -2).addGap(18, 18, 18).addComponent(this.refrlabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.refrslider, -2, -1, -2).addGap(31, 31, 31).addComponent(this.jComboBox1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jComboBox2, -2, -1, -2).addGap(33, 33, 33).addComponent(this.clearbutton).addGap(40, 40, 40).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addGap(26, 26, 26).addComponent(this.jLabel1).addContainerGap(18, Short.MAX_VALUE)));
        jPanel2Layout.linkSize(1, this.c0slider, this.cutoffslider, this.dampslider, this.jSlider1, this.refrslider);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(44, 44, 44).addComponent(this.jPanel2, -2, 212, -2).addGap(340, 340, 340)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel2, -2, -1, -2).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(226, 226, 226)))));
    }

    private void dampsliderMouseDragged(MouseEvent evt) {
        this.damp = (double)this.dampslider.getValue() * 0.01;
        this.damplab.setText("damping=" + this.df1.format(this.damp));
    }

    private void clearbuttonActionPerformed(ActionEvent evt) {
        this.stop();
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
        }
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
        this.refr = this.refr0 * this.refr0;
        this.start();
    }

    private void cutoffsliderMouseDragged(MouseEvent evt) {
        this.cutofflabel.setText("pulse duration=" + this.df1.format(this.TP));
        double TP1 = (double)this.cutoffslider.getValue() * 0.005;
        this.cutofflabel.setText("pulse width=" + this.df1.format(TP1));
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.stop();
        this.pulsetype = this.jComboBox1.getSelectedIndex();
        this.reset_all();
        this.start();
    }

    private void c0sliderMouseDragged(MouseEvent evt) {
        this.c00s = (double)this.c0slider.getValue() * 0.01;
        this.c0lab.setText("velocity=Courant=" + this.df1.format(Math.sqrt(this.c0s)));
    }

    private void cutoffsliderMouseReleased(MouseEvent evt) {
        this.TP0 = (double)this.cutoffslider.getValue() * 0.01;
        if (this.pulsetype == 0) {
            this.phase += this.omega * this.time_now;
            this.time_now = 0.0;
        }
    }

    private void refrsliderMouseReleased(MouseEvent evt) {
    }

    private void refrsliderMouseDragged(MouseEvent evt) {
        this.refr0 = (double)this.refrslider.getValue() * 0.01;
        this.refrlabel.setText("index of refr=" + this.df1.format(this.refr0));
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.boundtype = this.jComboBox2.getSelectedIndex();
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.anispeed = this.jSlider1.getValue();
    }

    void reset_all() {
        for (int i = 0; i < this.NDIM; ++i) {
            this.ampl[i] = 0.0;
            this.velo[i] = 0.0;
            this.oldsd[i] = 0.0;
        }
        this.sp2 = this.space_grid * this.space_grid;
        this.time_now = 0.0;
        this.phase = 0.0;
        this.TP = this.TP0;
    }

    double signal_sin(double t) {
        return 0.5 * (1.0 - Math.cos(this.omega * t + this.phase));
    }

    double signal_tr(double t) {
        if (t > this.TP) {
            return 0.0;
        }
        if (t < 0.5 * this.TP) {
            return t * 2.0 / this.TP;
        }
        return 2.0 - t * 2.0 / this.TP;
    }

    double signal_sq(double t) {
        if (t > this.TP) {
            return 0.0;
        }
        return 1.0;
    }

    double signal_g(double t) {
        double aa = t / this.TP - 3.0;
        return Math.exp(-aa * aa);
    }

    double signal_train(double t) {
        if (t > 10.0 * this.TP) {
            return 0.0;
        }
        if (Math.sin(t * 6.28 / this.TP) > 0.0) {
            return 1.0;
        }
        return -1.0;
    }

    void waves() {
        this.c0s = this.c00s;
        if (this.pulsetype == 0) {
            this.omega0 = Math.PI / this.TP0;
            this.omega += (this.omega0 - this.omega) * 0.01;
            this.ampl[0] = this.signal_sin(this.time_now);
        }
        if (this.pulsetype == 1) {
            this.ampl[0] = this.signal_tr(this.time_now);
        }
        if (this.pulsetype == 2) {
            this.ampl[0] = this.signal_sq(this.time_now);
        }
        if (this.pulsetype == 3) {
            this.ampl[0] = this.signal_g(this.time_now);
        }
        if (this.pulsetype == 4) {
            this.ampl[0] = this.signal_train(this.time_now);
        }
        this.time_now += this.time_grid;
        this.i = 1;
        while (this.i < this.NDIM - 1) {
            this.dxx = (this.ampl[this.i + 1] + this.ampl[this.i - 1] - 2.0 * this.ampl[this.i]) / this.sp2;
            this.dv = this.i < this.NDIM / 2 ? this.c0s * this.dxx - this.damp * this.velo[this.i] : this.refr * this.c0s * this.dxx - this.damp * this.velo[this.i];
            this.velo[this.i] = this.velo[this.i] + this.dv * this.time_grid;
            ++this.i;
        }
        if (this.boundtype == 0) {
            this.velo[this.NDIM - 1] = 0.0;
        } else {
            this.dxx = 2.0 * (this.ampl[this.NDIM - 2] - this.ampl[this.NDIM - 1]) / this.sp2;
            this.dv = this.refr * this.c0s * this.dxx - this.damp * this.velo[this.NDIM - 1];
            this.velo[this.NDIM - 1] = this.velo[this.NDIM - 1] + this.dv * this.time_grid;
        }
        this.i = 1;
        while (this.i < this.NDIM) {
            this.ampl[this.i] = this.ampl[this.i] + this.velo[this.i] * this.time_grid;
            ++this.i;
        }
    }

    void draw() {
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        this.jLabel1.setText("time=" + this.df1.format(this.time_now));
        this.gb.setColor(Color.white);
        this.gb.clearRect(0, 0, 550, 600);
        this.gb.setColor(Color.black);
        this.gb.drawLine(250, 0, 250, 600);
        this.gb.setColor(Color.red);
        this.i = 0;
        while (this.i < this.NDIM - 1) {
            this.gb.drawLine(this.i, 300 - (int)(100.0 * this.ampl[this.i]), this.i + 1, 300 - (int)(100.0 * this.ampl[this.i + 1]));
            ++this.i;
        }
        g2.drawImage((Image)this.image, 0, 0, null);
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

