/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    double[] RealC;
    double[] ImagC;
    double[] RealC2;
    double[] ImagC2;
    double[] RealC3;
    double[] ImagC3;
    double[] RealC4;
    double[] ImagC4;
    double[] RealF1;
    double[] ImagF1;
    double[] RealF2;
    double[] ImagF2;
    double[] RealF3;
    double[] ImagF3;
    double[] RealF4;
    double[] ImagF4;
    int nstates = 2;
    double V = 1.0;
    double DeltaE = 2.0;
    double tstep = 0.001;
    double freq = 0.0;
    DecimalFormat df;
    private JLabel DEL;
    private JSlider DES;
    private JLabel VL;
    private JSlider VS;
    private JLabel freqL;
    private JSlider freqS;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.RealC = new double[this.nstates];
        this.ImagC = new double[this.nstates];
        this.RealC2 = new double[this.nstates];
        this.ImagC2 = new double[this.nstates];
        this.RealC3 = new double[this.nstates];
        this.ImagC3 = new double[this.nstates];
        this.RealC4 = new double[this.nstates];
        this.ImagC4 = new double[this.nstates];
        this.RealF1 = new double[this.nstates];
        this.ImagF1 = new double[this.nstates];
        this.RealF2 = new double[this.nstates];
        this.ImagF2 = new double[this.nstates];
        this.RealF3 = new double[this.nstates];
        this.ImagF3 = new double[this.nstates];
        this.RealF4 = new double[this.nstates];
        this.ImagF4 = new double[this.nstates];
        this.df = new DecimalFormat("##0.0");
        this.VS.setValue((int)(this.V * 20.0));
        this.DES.setValue((int)(this.DeltaE * 20.0));
        this.freqS.setValue((int)(this.freq * 20.0));
        this.VL.setText("V=" + this.df.format(this.V));
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.freqL.setText("frequency=" + this.df.format(this.freq));
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.VS = new JSlider();
        this.DES = new JSlider();
        this.freqL = new JLabel();
        this.DEL = new JLabel();
        this.freqS = new JSlider();
        this.VL = new JLabel();
        this.jLabel1 = new JLabel();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 420, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 365, Short.MAX_VALUE));
        this.VS.setToolTipText("magnitude of the perturbation");
        this.VS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.VSMouseDragged(evt);
            }
        });
        this.DES.setToolTipText("energy gap of the two states");
        this.DES.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.DESMouseDragged(evt);
            }
        });
        this.freqL.setText("freq  ");
        this.DEL.setText("DeltaE ");
        this.freqS.setToolTipText("frequency of the perturbation");
        this.freqS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.freqSMouseDragged(evt);
            }
        });
        this.VL.setText("V          ");
        this.jLabel1.setText("blue:occupation of initial state   red: occupation of final state");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.freqS, -2, 133, -2).addComponent(this.VS, -2, 133, -2).addComponent(this.DES, -2, 133, -2))).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.VL)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.freqL)).addGroup(layout.createSequentialGroup().addGap(40, 40, 40).addComponent(this.DEL))).addContainerGap(34, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.freqL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.freqS, -2, -1, -2).addGap(30, 30, 30).addComponent(this.VL).addGap(18, 18, 18).addComponent(this.VS, -2, -1, -2).addGap(46, 46, 46).addComponent(this.DEL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DES, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jLabel1).addContainerGap(80, Short.MAX_VALUE)));
    }

    private void VSMouseDragged(MouseEvent evt) {
        this.V = (double)this.VS.getValue() * 0.05;
        this.VL.setText("V=" + this.df.format(this.V));
        this.jPanel1.repaint();
    }

    private void DESMouseDragged(MouseEvent evt) {
        this.DeltaE = (double)this.DES.getValue() * 0.05;
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.jPanel1.repaint();
    }

    private void freqSMouseDragged(MouseEvent evt) {
        this.freq = (double)this.freqS.getValue() * 0.05;
        this.freqL.setText("frequency=" + this.df.format(this.freq));
        this.jPanel1.repaint();
    }

    void grad(double[] RC, double[] IC, double[] RF, double[] IF, double t) {
        double Vt = this.V * Math.cos(this.freq * t);
        RF[0] = Vt * IC[1];
        IF[0] = -Vt * RC[1];
        RF[1] = Vt * IC[0] + this.DeltaE * IC[1];
        IF[1] = -Vt * RC[0] - this.DeltaE * RC[1];
    }

    void advance(double[] RC, double[] IC, double[] RF, double[] IF, double[] RC1, double[] IC1, double step) {
        for (int i = 0; i < this.nstates; ++i) {
            RC1[i] = RC[i] + RF[i] * step;
            IC1[i] = IC[i] + IF[i] * step;
        }
    }

    void rk4(double t) {
        this.grad(this.RealC, this.ImagC, this.RealF1, this.ImagF1, t);
        this.advance(this.RealC, this.ImagC, this.RealF1, this.ImagF1, this.RealC2, this.ImagC2, this.tstep * 0.5);
        this.grad(this.RealC2, this.ImagC2, this.RealF2, this.ImagF2, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF2, this.ImagF2, this.RealC3, this.ImagC3, this.tstep * 0.5);
        this.grad(this.RealC3, this.ImagC3, this.RealF3, this.ImagF3, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF3, this.ImagF3, this.RealC4, this.ImagC4, this.tstep);
        this.grad(this.RealC4, this.ImagC4, this.RealF4, this.ImagF4, t + this.tstep);
        for (int i = 0; i < this.nstates; ++i) {
            this.RealC[i] = this.RealC[i] + this.tstep * (this.RealF1[i] + 2.0 * this.RealF2[i] + 2.0 * this.RealF3[i] + this.RealF4[i]) / 6.0;
            this.ImagC[i] = this.ImagC[i] + this.tstep * (this.ImagF1[i] + 2.0 * this.ImagF2[i] + 2.0 * this.ImagF3[i] + this.ImagF4[i]) / 6.0;
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        int i1;

        void iterate() {
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            NewJApplet.this.RealC[0] = 1.0;
            NewJApplet.this.ImagC[0] = 0.0;
            NewJApplet.this.RealC[1] = 0.0;
            NewJApplet.this.ImagC[1] = 0.0;
            this.iy0 = 150;
            this.ix0 = 0;
            double t = 0.0;
            this.i = 0;
            while (this.i < 400) {
                this.i1 = 0;
                while (this.i1 < 50) {
                    NewJApplet.this.rk4(t += NewJApplet.this.tstep);
                    ++this.i1;
                }
                g.setColor(Color.black);
                g.drawRect(0, 50, 400, 250);
                this.iy1 = (int)((NewJApplet.this.RealC[0] * NewJApplet.this.RealC[0] + NewJApplet.this.ImagC[0] * NewJApplet.this.ImagC[0]) * 250.0);
                this.ix1 = (int)((NewJApplet.this.RealC[1] * NewJApplet.this.RealC[1] + NewJApplet.this.ImagC[1] * NewJApplet.this.ImagC[1]) * 250.0);
                g.setColor(Color.blue);
                g.drawLine(this.i, 300 - this.iy0, this.i + 1, 300 - this.iy1);
                this.iy0 = this.iy1;
                g.setColor(Color.red);
                g.drawLine(this.i, 300 - this.ix0, this.i + 1, 300 - this.ix1);
                this.ix0 = this.ix1;
                g.setColor(Color.black);
                g.drawString("time", 200, 320);
                ++this.i;
            }
        }
    }
}

