/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DecimalFormat;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    int nmax = 100;
    int ndim = 5;
    int[] iindex;
    double[][] a;
    double[][] L;
    double[][] a0;
    double[][] R;
    double[] x;
    double[] b;
    double[] y;
    double[] b0;
    double[] bk;
    double[] qb;
    double[] deltar;
    double[] uvec;
    double[] aicol;
    double p;
    double z;
    int i;
    int j;
    int k;
    DecimalFormat df;
    DecimalFormat df2;
    int matrix = 1;
    double rx = 0.0;
    boolean reort = false;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton5;
    private JScrollPane jScrollPane1;
    private JSlider jSlider1;
    private JTextArea jTextArea1;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.a = new double[this.nmax][this.nmax];
        this.a0 = new double[this.nmax][this.nmax];
        this.R = new double[this.nmax][this.nmax];
        this.L = new double[this.nmax][this.nmax];
        this.x = new double[this.nmax];
        this.b = new double[this.nmax];
        this.b0 = new double[this.nmax];
        this.y = new double[this.nmax];
        this.bk = new double[this.nmax];
        this.qb = new double[this.nmax];
        this.deltar = new double[this.nmax];
        this.uvec = new double[this.nmax];
        this.aicol = new double[this.nmax];
        this.iindex = new int[this.nmax];
        this.df = new DecimalFormat("##0.000000");
        this.df2 = new DecimalFormat("##0.000000000000000");
        this.jSlider1.setValue(this.ndim);
        this.jLabel3.setText("dimension " + this.ndim);
        this.matrix = 1;
        this.setmat();
        this.copymat();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new myPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jSlider1 = new JSlider();
        this.jButton3 = new JButton();
        this.jRadioButton5 = new JRadioButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jLabel3 = new JLabel();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton1.setText("Gauss");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Gauss  pivot");
        this.jButton2.setMaximumSize(new Dimension(40, 25));
        this.jButton2.setMinimumSize(new Dimension(40, 25));
        this.jButton2.setPreferredSize(new Dimension(40, 25));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setText("Hilbert");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("random");
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setSelected(true);
        this.jRadioButton2.setText("well conditioned");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.jSlider1.setMajorTickSpacing(1);
        this.jSlider1.setMaximum(60);
        this.jSlider1.setMinimum(2);
        this.jSlider1.setOrientation(1);
        this.jSlider1.setPaintTicks(true);
        this.jSlider1.setSnapToTicks(true);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jButton3.setText("QR w GS");
        this.jButton3.setMaximumSize(new Dimension(40, 25));
        this.jButton3.setMinimumSize(new Dimension(40, 25));
        this.jButton3.setPreferredSize(new Dimension(40, 25));
        this.jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton3ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton5);
        this.jRadioButton5.setText("ill conditioned");
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton5ActionPerformed(evt);
            }
        });
        this.jButton4.setText("QR w HH");
        this.jButton4.setMaximumSize(new Dimension(40, 25));
        this.jButton4.setMinimumSize(new Dimension(40, 25));
        this.jButton4.setPreferredSize(new Dimension(40, 25));
        this.jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton4ActionPerformed(evt);
            }
        });
        this.jButton5.setText("QR w GSr");
        this.jButton5.setMaximumSize(new Dimension(40, 25));
        this.jButton5.setMinimumSize(new Dimension(40, 25));
        this.jButton5.setPreferredSize(new Dimension(40, 25));
        this.jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton5ActionPerformed(evt);
            }
        });
        this.jButton6.setText("new");
        this.jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton6ActionPerformed(evt);
            }
        });
        this.jLabel3.setText("jLabel3");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(41, 41, 41).addComponent(this.jScrollPane1, -2, 549, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButton2, -1, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton6)).addComponent(this.jRadioButton1).addComponent(this.jRadioButton5).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton2, -2, 120, -2).addComponent(this.jButton4, -2, 120, -2).addComponent(this.jButton5, -2, 120, -2).addComponent(this.jButton3, -2, 120, -2).addComponent(this.jButton1, -2, 120, -2)).addGap(41, 41, 41).addComponent(this.jSlider1, -2, -1, -2))).addGap(0, 0, Short.MAX_VALUE))).addGap(60, 60, 60)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 83, Short.MAX_VALUE).addComponent(this.jLabel3, -2, 131, -2).addGap(1125, 1125, 1125)))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -2, 524, -2).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButton1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton3).addComponent(this.jButton6)).addGap(41, 41, 41).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addComponent(this.jButton5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1)).addComponent(this.jSlider1, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jLabel3))).addGap(554, 554, 554)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addContainerGap(14, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(63, 63, 63).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(201, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.Gauss();
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.Gausspiv();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton1.isSelected()) {
            this.matrix = 0;
        }
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton2.isSelected()) {
            this.matrix = 1;
            this.setmat();
            this.copymat();
        }
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton3.isSelected()) {
            this.matrix = 2;
            this.setmat();
            this.copymat();
        }
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        this.ndim = this.jSlider1.getValue();
        this.jLabel3.setText("dimension " + this.ndim);
        this.setmat();
        this.copymat();
    }

    private void jButton3ActionPerformed(ActionEvent evt) {
        this.reort = false;
        this.doQR();
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        if (this.jRadioButton5.isSelected()) {
            this.matrix = 3;
            this.setmat();
            this.copymat();
        }
    }

    private void jButton4ActionPerformed(ActionEvent evt) {
        this.doQRHH();
    }

    private void jButton5ActionPerformed(ActionEvent evt) {
        this.reort = true;
        this.doQR();
    }

    private void jButton6ActionPerformed(ActionEvent evt) {
        if (this.matrix == 2) {
            this.setmat();
            this.copymat();
        }
    }

    public void setL() {
        int j;
        int i;
        for (i = 0; i < this.ndim; ++i) {
            for (j = 0; j < this.ndim; ++j) {
                this.L[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (i = 0; i < this.ndim; ++i) {
            for (j = 0; j < this.ndim; ++j) {
                this.a[i][j] = this.a0[i][j];
            }
        }
        for (i = 0; i < this.ndim; ++i) {
            this.b[i] = this.b0[i];
        }
    }

    public void setmat() {
        int j;
        int i;
        for (i = 0; i < this.ndim; ++i) {
            for (j = 0; j < this.ndim; ++j) {
                this.a[i][j] = 0.0;
            }
        }
        if (this.matrix == 0) {
            for (i = 0; i < this.ndim; ++i) {
                for (j = 0; j < this.ndim; ++j) {
                    this.a[i][j] = 1.0 / (double)(i + j + 1);
                }
            }
        }
        if (this.matrix == 2) {
            for (i = 0; i < this.ndim; ++i) {
                for (j = 0; j < this.ndim; ++j) {
                    this.a[i][j] = 2.0 * (Math.random() - 0.5);
                }
            }
        }
        if (this.matrix == 1) {
            for (i = 0; i < this.ndim; ++i) {
                for (j = 0; j < this.ndim; ++j) {
                    this.a[i][j] = i == j ? (double)this.ndim : 1.0;
                }
            }
        }
        if (this.matrix == 3) {
            for (i = 0; i < this.ndim; ++i) {
                for (j = 0; j < this.ndim; ++j) {
                    this.a[i][j] = 0.0;
                }
            }
            for (i = 0; i < this.ndim; ++i) {
                this.a[i][i] = 1.0;
                this.a[i][this.ndim - 1] = 1.0;
                for (j = i + 1; j < this.ndim; ++j) {
                    this.a[j][i] = -1.0;
                }
            }
        }
        for (i = 0; i < this.ndim; ++i) {
            double s = 0.0;
            for (j = 0; j < this.ndim; ++j) {
                s += this.a[i][j] * (double)j;
            }
            this.b[i] = s;
        }
    }

    public void copymat() {
        int i;
        for (i = 0; i < this.ndim; ++i) {
            for (int j = 0; j < this.ndim; ++j) {
                this.a0[i][j] = this.a[i][j];
            }
        }
        for (i = 0; i < this.ndim; ++i) {
            this.b0[i] = this.b[i];
        }
    }

    public void swap(int i1, int i2) {
        double a1;
        int i;
        for (i = 0; i < this.ndim; ++i) {
            a1 = this.a[i1][i];
            this.a[i1][i] = this.a[i2][i];
            this.a[i2][i] = a1;
            a1 = this.L[i1][i];
            this.L[i1][i] = this.L[i2][i];
            this.L[i2][i] = a1;
        }
        a1 = this.b[i1];
        this.b[i1] = this.b[i2];
        this.b[i2] = a1;
        i = this.iindex[i1];
        this.iindex[i1] = this.iindex[i2];
        this.iindex[i2] = i;
    }

    public void printmatQR(int np) {
        int j;
        int i;
        int npp = np;
        if (npp > this.ndim) {
            npp = this.ndim;
        }
        this.jTextArea1.append(" \n AMAT \n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.a[i][j]) + "  ");
            }
            this.jTextArea1.append("\n");
        }
        this.jTextArea1.append(" \n QMAT \n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.L[i][j]) + "  ");
            }
            this.jTextArea1.append("\n");
        }
        this.jTextArea1.append(" \n RMAT \n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.R[i][j]) + "  ");
            }
            this.jTextArea1.append("\n");
        }
        this.jTextArea1.append(" \n Testing orthogonality \n");
        double smax = 0.0;
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                double s = 0.0;
                for (int k = 0; k < this.ndim; ++k) {
                    s += this.L[k][i] * this.L[k][j];
                }
                if (i == j) {
                    s -= 1.0;
                }
                if (!((s = Math.abs(s)) > smax)) continue;
                smax = s;
            }
        }
        this.jTextArea1.append("maximum deviation : " + smax + "\n" + "\n");
    }

    public void printmat(int np) {
        int j;
        int i;
        int npp = np;
        if (npp > this.ndim) {
            npp = this.ndim;
        }
        this.jTextArea1.append(" \n LMAT \n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.L[i][j]) + "  ");
            }
            this.jTextArea1.append("\n");
        }
        this.jTextArea1.append(" \n AMAT  | b\n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.a[i][j]) + "  ");
            }
            this.jTextArea1.append(" | " + this.df.format(this.b[i]));
            this.jTextArea1.append("\n");
        }
    }

    void printmatpiv(int np) {
        int j;
        int i;
        int npp = np;
        if (npp > this.ndim) {
            npp = this.ndim;
        }
        this.jTextArea1.append(" \n LMAT \n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.L[i][this.iindex[j]]) + "  ");
            }
            this.jTextArea1.append("\n");
        }
        this.jTextArea1.append(" \n AMAT  | b\n");
        for (i = 0; i < npp; ++i) {
            for (j = 0; j < npp; ++j) {
                this.jTextArea1.append(this.df.format(this.a[i][j]) + "  ");
            }
            this.jTextArea1.append(" | " + this.df.format(this.b[i]));
            this.jTextArea1.append("\n");
        }
    }

    void LUpiv(boolean verbose) {
        int k;
        for (k = 0; k < this.ndim; ++k) {
            this.iindex[k] = k;
        }
        for (k = 0; k < this.ndim - 1; ++k) {
            double amax = Math.abs(this.a[k][k]);
            int lmax = k;
            for (int l = k + 1; l < this.ndim; ++l) {
                if (!(Math.abs(this.a[l][k]) > amax)) continue;
                amax = Math.abs(this.a[l][k]);
                lmax = l;
            }
            if (verbose) {
                this.jTextArea1.append(" step " + k + "  pivot a[" + lmax + "," + k + "] \n");
            }
            if (lmax != k) {
                if (verbose) {
                    this.jTextArea1.append(" exchange" + lmax + "  " + k + " \n");
                }
                this.swap(lmax, k);
            }
            if (this.a[k][k] == 0.0) {
                this.jTextArea1.append(" matrix singular or pivoting needed! \n");
                throw new RuntimeException();
            }
            for (int i = k + 1; i < this.ndim; ++i) {
                double lik = this.a[i][k] / this.a[k][k];
                this.b[i] = this.b[i] - lik * this.b[k];
                for (int j = k; j < this.ndim; ++j) {
                    this.a[i][j] = this.a[i][j] - lik * this.a[k][j];
                    this.L[i][j] = this.L[i][j] - lik * this.L[k][j];
                }
            }
        }
    }

    void solvpiv(boolean verbose) {
        this.x[this.ndim - 1] = this.b[this.ndim - 1] / this.a[this.ndim - 1][this.ndim - 1];
        for (int i = this.ndim - 2; i >= 0; --i) {
            this.x[i] = this.b[i];
            for (int j = i + 1; j < this.ndim; ++j) {
                this.x[i] = this.x[i] - this.x[j] * this.a[i][j];
            }
            this.x[i] = this.x[i] / this.a[i][i];
        }
    }

    public void LU(boolean verbose) {
        for (int k = 0; k < this.ndim - 1; ++k) {
            for (int i = k + 1; i < this.ndim; ++i) {
                if (this.a[k][k] == 0.0) {
                    this.jTextArea1.append(" matrix singular or pivoting needed! \n");
                    throw new RuntimeException();
                }
                this.L[i][k] = this.a[i][k] / this.a[k][k];
                for (int j = k; j < this.ndim; ++j) {
                    this.a[i][j] = this.a[i][j] - this.L[i][k] * this.a[k][j];
                }
            }
        }
    }

    public void solv(boolean verbose) {
        int j;
        int i;
        this.y[0] = this.b[0];
        for (i = 1; i < this.ndim; ++i) {
            this.y[i] = this.b[i];
            for (j = 0; j <= i - 1; ++j) {
                this.y[i] = this.y[i] - this.L[i][j] * this.y[j];
            }
        }
        this.x[this.ndim - 1] = this.y[this.ndim - 1] / this.a[this.ndim - 1][this.ndim - 1];
        for (i = this.ndim - 2; i >= 0; --i) {
            this.x[i] = this.y[i];
            for (j = i + 1; j < this.ndim; ++j) {
                this.x[i] = this.x[i] - this.x[j] * this.a[i][j];
            }
            this.x[i] = this.x[i] / this.a[i][i];
        }
    }

    public void printx() {
        this.jTextArea1.append("\n");
        this.jTextArea1.append(" solution x \n");
        this.jTextArea1.append(" i          x   \n");
        for (int i = 0; i < this.ndim; ++i) {
            this.jTextArea1.append("" + i + "  " + this.df2.format(this.x[i]) + "\n");
        }
    }

    public void printmaxdev() {
        double dev = 0.0;
        for (int i = 0; i < this.ndim; ++i) {
            if (!(Math.abs(this.x[i] - (double)i) > dev)) continue;
            dev = Math.abs(this.x[i] - (double)i);
        }
        this.jTextArea1.append("max deviation of x  " + dev + "\n");
    }

    public void check() {
        this.jTextArea1.append("\n");
        this.jTextArea1.append(" i      Ax            Ax-b  \n");
        for (int i = 0; i < this.ndim; ++i) {
            double s = 0.0;
            for (int j = 0; j < this.ndim; ++j) {
                s += this.a0[i][j] * this.x[j];
            }
            this.jTextArea1.append("" + i + "  " + this.df.format(s) + "  " + this.df2.format(this.b0[i] - s) + "\n");
        }
    }

    public void Gauss() {
        this.jTextArea1.selectAll();
        this.jTextArea1.replaceSelection(" Gauss elimination \n");
        this.setL();
        this.jTextArea1.append(" \n  initial values \n");
        this.printmat(this.ndim);
        this.LU(true);
        this.jTextArea1.append("  \n  after LU decomposition \n");
        this.printmat(this.ndim);
        this.solv(true);
        this.printx();
        this.check();
        this.printmaxdev();
    }

    public void Gausspiv() {
        this.jTextArea1.selectAll();
        this.jTextArea1.replaceSelection(" Gauss elimination with partial pivoting\n");
        this.setL();
        this.jTextArea1.append(" \n  initial values \n");
        this.printmat(this.ndim);
        this.LUpiv(true);
        this.jTextArea1.append("  \n  after LU decomposition \n");
        this.printmatpiv(this.ndim);
        this.solvpiv(true);
        this.printx();
        this.check();
        this.printmaxdev();
    }

    public void doQR() {
        this.jTextArea1.selectAll();
        this.jTextArea1.replaceSelection(" QR decomposition with Gram-Schmid orthogonalization \n");
        this.setL();
        this.QR(true);
        this.printmatQR(this.ndim);
        this.solvQR(true);
        this.printx();
        this.check();
        this.printmaxdev();
    }

    public void doQRHH() {
        this.jTextArea1.selectAll();
        this.jTextArea1.replaceSelection(" QR decomposition with Householder reflections \n");
        this.setL();
        this.QRHH();
        this.printmatQR(this.ndim);
        this.solvQR(true);
        this.printx();
        this.check();
        this.printmaxdev();
    }

    public void QRHH() {
        int i;
        for (i = 0; i < this.ndim; ++i) {
            for (int j = 0; j < this.ndim; ++j) {
                this.R[i][j] = this.a[i][j];
                this.L[i][j] = i == j ? 1.0 : 0.0;
            }
        }
        for (int irow = 0; irow < this.ndim; ++irow) {
            double z;
            int icol;
            double s = 0.0;
            for (i = irow; i < this.ndim; ++i) {
                s += this.R[i][irow] * this.R[i][irow];
            }
            s = Math.sqrt(s);
            double kk = this.R[irow][irow] > 0.0 ? -s : s;
            for (i = irow; i < this.ndim; ++i) {
                this.uvec[i] = this.R[i][irow];
            }
            this.uvec[irow] = this.uvec[irow] - kk;
            s = 0.0;
            for (i = irow; i < this.ndim; ++i) {
                s += this.uvec[i] * this.uvec[i];
            }
            s = Math.sqrt(s);
            for (i = irow; i < this.ndim; ++i) {
                this.uvec[i] = this.uvec[i] / s;
            }
            for (icol = irow; icol < this.ndim; ++icol) {
                for (i = irow; i < this.ndim; ++i) {
                    this.aicol[i] = this.R[i][icol];
                }
                s = 0.0;
                for (i = irow; i < this.ndim; ++i) {
                    s += this.aicol[i] * this.uvec[i];
                }
                for (i = irow; i < this.ndim; ++i) {
                    this.R[i][icol] = z = this.aicol[i] - 2.0 * s * this.uvec[i];
                }
            }
            for (icol = 0; icol < this.ndim; ++icol) {
                for (i = irow; i < this.ndim; ++i) {
                    this.aicol[i] = this.L[icol][i];
                }
                s = 0.0;
                for (i = irow; i < this.ndim; ++i) {
                    s += this.aicol[i] * this.uvec[i];
                }
                for (i = irow; i < this.ndim; ++i) {
                    this.L[icol][i] = z = this.aicol[i] - 2.0 * s * this.uvec[i];
                }
            }
        }
    }

    public void QR(boolean verbose) {
        int i;
        double s = 0.0;
        for (i = 0; i < this.ndim; ++i) {
            s += this.a[i][0] * this.a[i][0];
        }
        this.R[0][0] = s = Math.sqrt(s);
        for (i = 0; i < this.ndim; ++i) {
            this.L[i][0] = this.a[i][0] / s;
        }
        for (int k = 1; k < this.ndim; ++k) {
            int j;
            for (i = 0; i < this.ndim; ++i) {
                this.bk[i] = this.a[i][k];
            }
            for (i = 0; i < k; ++i) {
                s = 0.0;
                for (j = 0; j < this.ndim; ++j) {
                    s += this.a[j][k] * this.L[j][i];
                }
                this.R[i][k] = s;
                for (j = 0; j < this.ndim; ++j) {
                    this.bk[j] = this.bk[j] - s * this.L[j][i];
                }
            }
            if (this.reort) {
                for (i = 0; i < k; ++i) {
                    s = 0.0;
                    for (j = 0; j < this.ndim; ++j) {
                        s += this.bk[j] * this.L[j][i];
                    }
                    this.R[i][k] = this.R[i][k] + s;
                    for (j = 0; j < this.ndim; ++j) {
                        this.bk[j] = this.bk[j] - s * this.L[j][i];
                    }
                }
            }
            s = 0.0;
            for (i = 0; i < this.ndim; ++i) {
                s += this.bk[i] * this.bk[i];
            }
            this.R[k][k] = s = Math.sqrt(s);
            for (i = 0; i < this.ndim; ++i) {
                this.L[i][k] = this.bk[i] / s;
            }
        }
    }

    void solvQR(boolean verbose) {
        int j;
        double s;
        int i;
        for (i = 0; i < this.ndim; ++i) {
            s = 0.0;
            for (j = 0; j < this.ndim; ++j) {
                s += this.L[j][i] * this.b[j];
            }
            this.qb[i] = s;
        }
        if (verbose) {
            this.jTextArea1.append(" transformed rhs vector \n");
            for (i = 0; i < this.ndim; ++i) {
                this.jTextArea1.append("" + this.df.format(this.qb[i]));
            }
            this.jTextArea1.append("\n");
        }
        this.x[this.ndim - 1] = this.qb[this.ndim - 1] / this.R[this.ndim - 1][this.ndim - 1];
        for (i = this.ndim - 2; i >= 0; --i) {
            s = this.qb[i];
            for (j = i + 1; j < this.ndim; ++j) {
                s -= this.x[j] * this.R[i][j];
            }
            this.x[i] = s /= this.R[i][i];
        }
    }

    public class myPanel
    extends JPanel {
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
        }
    }
}

