/*
 * Decompiled with CFR 0.152.
 */
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    double xmin = -2.0;
    double xmax = 5.0;
    double ymin = -1.0;
    double ymax = 1.0;
    double pxmin;
    double pxmax;
    double pymin;
    double pymax;
    int nmaxpoints = 20;
    int ndraw = 400;
    int draw_off = 10;
    int npoints = 0;
    int[] ixp;
    int[] iyp;
    double[] xval;
    double[] yval;
    double[] xdat;
    double[] ydat;
    double[] a;
    double[] t;
    double newvalue;
    double[][] coeff;
    double[] weight;
    int method = 2;
    private ButtonGroup buttonGroup1;
    private JButton jButton1;
    private JPanel jPanel1;
    private JRadioButton jRadioButton1;
    private JRadioButton jRadioButton2;
    private JRadioButton jRadioButton3;
    private JRadioButton jRadioButton4;
    private JRadioButton jRadioButton5;
    private JTextField xf0;
    private JTextField xf1;
    private JTextField xf10;
    private JTextField xf2;
    private JTextField xf3;
    private JTextField xf4;
    private JTextField xf5;
    private JTextField xf6;
    private JTextField xf7;
    private JTextField xf8;
    private JTextField xf9;
    private JTextField yf0;
    private JTextField yf1;
    private JTextField yf10;
    private JTextField yf2;
    private JTextField yf3;
    private JTextField yf4;
    private JTextField yf5;
    private JTextField yf6;
    private JTextField yf7;
    private JTextField yf8;
    private JTextField yf9;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.xval = new double[this.ndraw];
        this.yval = new double[this.ndraw];
        this.ixp = new int[this.ndraw];
        this.iyp = new int[this.ndraw];
        this.xdat = new double[this.nmaxpoints];
        this.ydat = new double[this.nmaxpoints];
        this.a = new double[this.nmaxpoints];
        this.t = new double[this.nmaxpoints];
        this.coeff = new double[this.nmaxpoints][4];
        this.weight = new double[this.nmaxpoints];
        for (int i = 0; i < this.ndraw; ++i) {
            this.xval[i] = this.xmin + (this.xmax - this.xmin) * (double)i / (double)this.ndraw;
            this.yval[i] = Math.sin(this.xval[i]);
            this.npoints = 4;
            this.xdat[0] = -1.5;
            this.ydat[0] = -3.375;
            this.xdat[1] = -1.0;
            this.ydat[1] = -1.0;
            this.xdat[2] = -0.5;
            this.ydat[2] = -0.125;
            this.xdat[3] = 0.0;
            this.ydat[3] = 0.0;
            this.minmax();
            this.xf0.setText("" + this.xdat[0]);
            this.yf0.setText("" + this.ydat[0]);
            this.xf1.setText("" + this.xdat[1]);
            this.yf1.setText("" + this.ydat[1]);
            this.xf2.setText("" + this.xdat[2]);
            this.yf2.setText("" + this.ydat[2]);
            this.xf3.setText("" + this.xdat[3]);
            this.yf3.setText("" + this.ydat[3]);
            this.xf4.setText("");
            this.yf4.setText("");
            this.xf5.setText("");
            this.yf5.setText("");
            this.xf6.setText("");
            this.yf6.setText("");
            this.xf7.setText("");
            this.yf7.setText("");
            this.xf8.setText("");
            this.yf8.setText("");
            this.xf9.setText("");
            this.yf9.setText("");
            this.xf10.setText("");
            this.yf10.setText("");
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new myPanel();
        this.jRadioButton1 = new JRadioButton();
        this.jRadioButton2 = new JRadioButton();
        this.jRadioButton3 = new JRadioButton();
        this.xf0 = new JTextField();
        this.yf0 = new JTextField();
        this.yf1 = new JTextField();
        this.xf1 = new JTextField();
        this.xf2 = new JTextField();
        this.yf2 = new JTextField();
        this.xf3 = new JTextField();
        this.yf3 = new JTextField();
        this.xf4 = new JTextField();
        this.yf4 = new JTextField();
        this.xf5 = new JTextField();
        this.yf5 = new JTextField();
        this.yf6 = new JTextField();
        this.xf6 = new JTextField();
        this.xf7 = new JTextField();
        this.yf7 = new JTextField();
        this.yf8 = new JTextField();
        this.xf8 = new JTextField();
        this.xf9 = new JTextField();
        this.yf9 = new JTextField();
        this.jButton1 = new JButton();
        this.xf10 = new JTextField();
        this.yf10 = new JTextField();
        this.jRadioButton4 = new JRadioButton();
        this.jRadioButton5 = new JRadioButton();
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 507, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 434, Short.MAX_VALUE));
        this.buttonGroup1.add(this.jRadioButton1);
        this.jRadioButton1.setSelected(true);
        this.jRadioButton1.setText("polynomial");
        this.jRadioButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton2);
        this.jRadioButton2.setText("linear spline");
        this.jRadioButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton2ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton3);
        this.jRadioButton3.setText("cubic spline");
        this.jRadioButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton3ActionPerformed(evt);
            }
        });
        this.xf0.setText("jTextField1");
        this.yf0.setText("jTextField2");
        this.yf1.setText("jTextField2");
        this.xf1.setText("jTextField1");
        this.xf2.setText("jTextField1");
        this.yf2.setText("jTextField2");
        this.xf3.setText("jTextField1");
        this.yf3.setText("jTextField2");
        this.xf4.setText("jTextField1");
        this.yf4.setText("jTextField2");
        this.xf5.setText("jTextField1");
        this.yf5.setText("jTextField2");
        this.yf6.setText("jTextField2");
        this.xf6.setText("jTextField1");
        this.xf7.setText("jTextField1");
        this.yf7.setText("jTextField2");
        this.yf8.setText("jTextField2");
        this.xf8.setText("jTextField1");
        this.xf9.setText("jTextField1");
        this.yf9.setText("jTextField2");
        this.jButton1.setText("refresh");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.xf10.setText("jTextField1");
        this.yf10.setText("jTextField2");
        this.buttonGroup1.add(this.jRadioButton4);
        this.jRadioButton4.setText("rational FH");
        this.jRadioButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton4ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButton5);
        this.jRadioButton5.setText("rational B");
        this.jRadioButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jRadioButton5ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.xf0).addComponent(this.xf1, -2, -1, -2).addComponent(this.xf2, -2, -1, -2).addComponent(this.xf3, -2, -1, -2).addComponent(this.xf4, -2, -1, -2).addComponent(this.xf5, -2, -1, -2).addComponent(this.xf6, -2, -1, -2).addComponent(this.xf7, -2, -1, -2).addComponent(this.xf8, -2, -1, -2).addComponent(this.xf9, -2, -1, -2).addComponent(this.xf10, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.yf0, GroupLayout.Alignment.TRAILING, -2, -1, -2).addComponent(this.yf1, -2, -1, -2).addComponent(this.yf2, -2, -1, -2).addComponent(this.yf3, -2, -1, -2).addComponent(this.yf4, -2, -1, -2).addComponent(this.yf5, -2, -1, -2).addComponent(this.yf6, -2, -1, -2).addComponent(this.yf7, -2, -1, -2).addComponent(this.yf8, -2, -1, -2).addComponent(this.yf9, -2, -1, -2).addComponent(this.yf10, -2, -1, -2)).addContainerGap(107, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.jButton1).addContainerGap()))).addGroup(layout.createSequentialGroup().addComponent(this.jRadioButton1).addGap(18, 18, 18).addComponent(this.jRadioButton2).addGap(18, 18, 18).addComponent(this.jRadioButton3).addGap(18, 18, 18).addComponent(this.jRadioButton4).addGap(18, 18, 18).addComponent(this.jRadioButton5).addGap(0, 0, Short.MAX_VALUE)))));
        layout.linkSize(0, this.xf0, this.xf1, this.xf10, this.xf2, this.xf3, this.xf4, this.xf5, this.xf6, this.xf7, this.xf8, this.xf9, this.yf0, this.yf1, this.yf10, this.yf2, this.yf3, this.yf4, this.yf5, this.yf6, this.yf7, this.yf8, this.yf9);
        layout.linkSize(0, this.jRadioButton1, this.jRadioButton2, this.jRadioButton3);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(30, 30, 30).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(layout.createSequentialGroup().addComponent(this.yf0, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.yf8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(25, 25, 25).addComponent(this.yf10, -2, -1, -2)).addComponent(this.yf9, -2, -1, -2))).addGroup(layout.createSequentialGroup().addComponent(this.xf0, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf3, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf4, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf5, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf6, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf7, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf8, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf9, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.xf10, -2, -1, -2))).addGap(18, 18, 18).addComponent(this.jButton1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1).addComponent(this.jRadioButton2).addComponent(this.jRadioButton3).addComponent(this.jRadioButton4).addComponent(this.jRadioButton5)).addContainerGap(121, Short.MAX_VALUE)));
        layout.linkSize(1, this.xf0, this.xf1, this.xf10, this.xf2, this.xf3, this.xf4, this.xf5, this.xf6, this.xf7, this.xf8, this.xf9, this.yf0, this.yf1, this.yf10, this.yf2, this.yf3, this.yf4, this.yf5, this.yf6, this.yf7, this.yf8, this.yf9);
        layout.linkSize(1, this.jRadioButton1, this.jRadioButton2, this.jRadioButton3);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.getvalues();
        this.minmax();
        this.minmaxp();
        this.jPanel1.repaint();
    }

    private void jRadioButton1ActionPerformed(ActionEvent evt) {
        this.jRadioButton1.setSelected(true);
        this.method = 0;
        this.jPanel1.repaint();
    }

    private void jRadioButton2ActionPerformed(ActionEvent evt) {
        this.jRadioButton2.setSelected(true);
        this.method = 1;
        this.jPanel1.repaint();
    }

    private void jRadioButton3ActionPerformed(ActionEvent evt) {
        this.jRadioButton3.setSelected(true);
        this.method = 2;
        this.jPanel1.repaint();
    }

    private void jRadioButton4ActionPerformed(ActionEvent evt) {
        this.jRadioButton4.setSelected(true);
        this.method = 3;
        this.jPanel1.repaint();
    }

    private void jRadioButton5ActionPerformed(ActionEvent evt) {
        this.jRadioButton5.setSelected(true);
        this.method = 4;
        this.jPanel1.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int check(JTextField xf) {
        double d = 0.0;
        int valid = 1;
        try {
            String s = xf.getText();
            d = Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            xf.setText("");
            valid = 0;
        }
        finally {
            if (valid > 0) {
                this.newvalue = d;
            }
        }
        return valid;
    }

    public void getvalues() {
        this.npoints = 0;
        this.checkpair(this.xf0, this.yf0);
        this.checkpair(this.xf1, this.yf1);
        this.checkpair(this.xf2, this.yf2);
        this.checkpair(this.xf3, this.yf3);
        this.checkpair(this.xf4, this.yf4);
        this.checkpair(this.xf5, this.yf5);
        this.checkpair(this.xf6, this.yf6);
        this.checkpair(this.xf7, this.yf7);
        this.checkpair(this.xf8, this.yf8);
        this.checkpair(this.xf9, this.yf9);
        this.checkpair(this.xf10, this.yf10);
    }

    public void checkpair(JTextField xf, JTextField yf) {
        int validy;
        int validx = this.check(xf);
        if (validx > 0) {
            this.xdat[this.npoints] = this.newvalue;
        }
        if ((validy = this.check(yf)) > 0) {
            this.ydat[this.npoints] = this.newvalue;
        }
        if (validx > 0 && validy > 0) {
            ++this.npoints;
        }
    }

    public void minmax() {
        int i;
        double a = 1000.0;
        for (i = 0; i < this.npoints; ++i) {
            if (!(this.xdat[i] < a)) continue;
            a = this.xdat[i];
        }
        this.xmin = a;
        a = 1000.0;
        for (i = 0; i < this.npoints; ++i) {
            if (!(this.ydat[i] < a)) continue;
            a = this.ydat[i];
        }
        this.ymin = a;
        a = -1000.0;
        for (i = 0; i < this.npoints; ++i) {
            if (!(this.xdat[i] > a)) continue;
            a = this.xdat[i];
        }
        this.xmax = a;
        a = -1000.0;
        for (i = 0; i < this.npoints; ++i) {
            if (!(this.ydat[i] > a)) continue;
            a = this.ydat[i];
        }
        this.ymax = a;
        this.pxmin = this.xmin;
        this.pxmax = this.xmax;
        this.pymin = this.ymin;
        this.pymax = this.ymax;
    }

    public void minmaxp() {
        int i;
        double a = this.pymin;
        for (i = 0; i < this.ndraw; ++i) {
            if (!(this.yval[i] < a)) continue;
            a = this.yval[i];
        }
        this.pymin = a;
        a = this.pymax;
        for (i = 0; i < this.ndraw; ++i) {
            if (!(this.yval[i] > a)) continue;
            a = this.yval[i];
        }
        this.pymax = a;
    }

    public double getz(int ix) {
        return this.pxmin + (double)ix * (this.pxmax - this.pxmin) / (double)this.ndraw;
    }

    public int ytrans(double y) {
        return this.ndraw - (int)((double)this.ndraw * (y - this.pymin) / (this.pymax - this.pymin));
    }

    public int xtrans(double x) {
        return (int)((double)this.ndraw * (x - this.pxmin) / (this.pxmax - this.pxmin));
    }

    public void divdif() {
        for (int i = 0; i < this.npoints; ++i) {
            this.t[i] = this.ydat[i];
            for (int k = i - 1; k >= 0; --k) {
                this.t[k] = (this.t[k + 1] - this.t[k]) / (this.xdat[i] - this.xdat[k]);
            }
            this.a[i] = this.t[0];
        }
    }

    public double poly(double z) {
        double p = this.a[this.npoints - 1];
        for (int i = this.npoints - 2; i >= 0; --i) {
            p = p * (z - this.xdat[i]) + this.a[i];
        }
        return p;
    }

    public void interpol() {
        this.divdif();
        for (int i = 0; i < this.ndraw; ++i) {
            double z = this.xmin + (double)i * (this.xmax - this.xmin) / (double)this.ndraw;
            double y = this.poly(z);
            this.xval[i] = z;
            this.yval[i] = y;
        }
    }

    public void intersplinel() {
        this.divdif();
        for (int i = 0; i < this.ndraw; ++i) {
            double z = this.xmin + (double)i * (this.xmax - this.xmin) / (double)this.ndraw;
            double y = this.evalsplinel(z);
            this.xval[i] = z;
            this.yval[i] = y;
        }
    }

    public void interspline() {
        this.divdif();
        for (int i = 0; i < this.ndraw; ++i) {
            double z = this.getz(i);
            double y = this.evalspline(z);
            this.xval[i] = z;
            this.yval[i] = y;
        }
    }

    void spline() {
        int i;
        double[] h = new double[this.nmaxpoints];
        double[] lam = new double[this.nmaxpoints];
        double[] mu = new double[this.nmaxpoints];
        double[] d = new double[this.nmaxpoints];
        double[] p = new double[this.nmaxpoints];
        double[] q = new double[this.nmaxpoints];
        double[] u = new double[this.nmaxpoints];
        double[] m = new double[this.nmaxpoints];
        for (i = 1; i < this.npoints; ++i) {
            h[i] = this.xdat[i] - this.xdat[i - 1];
        }
        for (i = 1; i < this.npoints - 1; ++i) {
            lam[i] = h[i + 1] / (h[i] + h[i + 1]);
            mu[i] = 1.0 - lam[i];
        }
        for (i = 1; i < this.npoints - 1; ++i) {
            d[i] = (this.ydat[i + 1] - this.ydat[i]) / h[i + 1] - (this.ydat[i] - this.ydat[i - 1]) / h[i];
            d[i] = d[i] * 6.0 / (h[i] + h[i + 1]);
        }
        d[0] = 0.0;
        lam[0] = 0.0;
        mu[0] = 1.0;
        q[0] = -lam[0] * 0.5;
        u[0] = d[0] * 0.5;
        for (i = 1; i < this.npoints; ++i) {
            p[i] = mu[i] * q[i - 1] + 2.0;
            q[i] = -(lam[i] / p[i]);
            u[i] = (d[i] - mu[i] * u[i - 1]) / p[i];
        }
        m[this.npoints - 1] = u[this.npoints - 1];
        for (i = this.npoints - 2; i >= 0; --i) {
            m[i] = q[i] * m[i + 1] + u[i];
        }
        for (i = 0; i < this.npoints - 1; ++i) {
            this.coeff[i][0] = this.ydat[i];
            this.coeff[i][2] = m[i] * 0.5;
            this.coeff[i][1] = (this.ydat[i + 1] - this.ydat[i]) / h[i + 1] - h[i + 1] * (2.0 * m[i] + m[i + 1]) / 6.0;
            this.coeff[i][3] = (m[i + 1] - m[i]) / (6.0 * h[i + 1]);
        }
    }

    double evalsplinel(double z) {
        double sp = 0.0;
        for (int i = 0; i < this.npoints - 1; ++i) {
            if (!(z >= this.xdat[i]) || !(z < this.xdat[i + 1])) continue;
            double hij = this.xdat[i + 1] - this.xdat[i];
            double hyij = this.ydat[i + 1] - this.ydat[i];
            double dz = z - this.xdat[i];
            sp = this.ydat[i] + hyij * dz / hij;
        }
        return sp;
    }

    double evalspline(double z) {
        double sp = 0.0;
        for (int i = 0; i < this.npoints - 1; ++i) {
            if (!(z >= this.xdat[i]) || !(z < this.xdat[i + 1])) continue;
            double hij = this.xdat[i + 1] - this.xdat[i];
            double dz = z - this.xdat[i];
            sp = this.coeff[i][3] * dz;
            sp = (sp + this.coeff[i][2]) * dz;
            sp = (sp + this.coeff[i][1]) * dz;
            sp += this.coeff[i][0];
        }
        return sp;
    }

    void evalweights() {
        int i;
        for (i = 0; i < this.npoints; ++i) {
            this.weight[i] = 0.0;
        }
        double wsig = -1.0;
        this.weight[0] = wsig / (this.xdat[1] - this.xdat[0]);
        for (i = 1; i < this.npoints - 1; ++i) {
            wsig = -wsig;
            this.weight[i] = wsig * (1.0 / (this.xdat[i] - this.xdat[i - 1]) + 1.0 / (this.xdat[i + 1] - this.xdat[i]));
        }
        wsig = -wsig;
        this.weight[this.npoints - 1] = wsig / (this.xdat[this.npoints - 1] - this.xdat[this.npoints - 2]);
    }

    void Berrweights() {
        double wsig = 1.0;
        for (int i = 0; i < this.npoints; ++i) {
            this.weight[i] = wsig;
            wsig = -wsig;
        }
    }

    double ratint(double x) {
        int i;
        double eps = 1.0E-12;
        double r = 0.0;
        boolean close = false;
        for (i = 0; i < this.npoints; ++i) {
            if (!(Math.abs(x - this.xdat[i]) < eps)) continue;
            close = true;
            r = this.ydat[i];
        }
        if (!close) {
            double rnum = 0.0;
            double rden = 0.0;
            for (i = 0; i < this.npoints; ++i) {
                double pr = this.weight[i] / (x - this.xdat[i]);
                rnum += this.ydat[i] * pr;
                rden += pr;
            }
            r = rnum / rden;
        }
        return r;
    }

    public void interrat(int wkind) {
        if (wkind == 0) {
            this.evalweights();
        } else {
            this.Berrweights();
        }
        for (int i = 0; i < this.ndraw; ++i) {
            double z = this.xmin + (double)i * (this.xmax - this.xmin) / (double)this.ndraw;
            double y = this.ratint(z);
            this.xval[i] = z;
            this.yval[i] = y;
        }
    }

    public class myPanel
    extends JPanel {
        int i;
        int ix;
        int iy;
        int ix0;
        int iy0;

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (NewJApplet.this.method == 0) {
                NewJApplet.this.interpol();
            }
            if (NewJApplet.this.method == 1) {
                NewJApplet.this.spline();
                NewJApplet.this.intersplinel();
            }
            if (NewJApplet.this.method == 2) {
                NewJApplet.this.spline();
                NewJApplet.this.interspline();
            }
            if (NewJApplet.this.method == 3) {
                NewJApplet.this.interrat(0);
            }
            if (NewJApplet.this.method == 4) {
                NewJApplet.this.interrat(1);
            }
            this.i = 0;
            while (this.i < NewJApplet.this.npoints) {
                this.ix = NewJApplet.this.xtrans(NewJApplet.this.xdat[this.i]);
                this.iy = NewJApplet.this.ytrans(NewJApplet.this.ydat[this.i]);
                g.fillOval(this.ix - 7 + NewJApplet.this.draw_off, this.iy - 7 + NewJApplet.this.draw_off, 15, 15);
                ++this.i;
            }
            this.i = 0;
            while (this.i < NewJApplet.this.ndraw) {
                NewJApplet.this.ixp[this.i] = this.i + NewJApplet.this.draw_off;
                NewJApplet.this.iyp[this.i] = NewJApplet.this.ytrans(NewJApplet.this.yval[this.i]) + NewJApplet.this.draw_off;
                ++this.i;
            }
            this.ix0 = NewJApplet.this.xtrans(0.0) + NewJApplet.this.draw_off;
            this.iy0 = NewJApplet.this.ytrans(0.0) + NewJApplet.this.draw_off;
            g.drawPolyline(NewJApplet.this.ixp, NewJApplet.this.iyp, NewJApplet.this.ndraw);
            g.drawLine(this.ix0, 0, this.ix0, NewJApplet.this.ndraw);
            g.drawLine(0, this.iy0, NewJApplet.this.ndraw, this.iy0);
            this.i = -10;
            while (this.i <= 10) {
                if ((double)this.i >= NewJApplet.this.xmin && (double)this.i <= NewJApplet.this.xmax) {
                    this.ix0 = NewJApplet.this.xtrans(this.i) + NewJApplet.this.draw_off;
                    this.iy0 = NewJApplet.this.ytrans(0.0) + NewJApplet.this.draw_off;
                    g.drawLine(this.ix0, this.iy0 - 10, this.ix0, this.iy0 + 10);
                    g.drawString("" + this.i, this.ix0 - 5, this.iy0 + 20);
                }
                ++this.i;
            }
            this.i = -10;
            while (this.i <= 10) {
                if ((double)this.i >= NewJApplet.this.pymin && (double)this.i <= NewJApplet.this.pymax) {
                    this.ix0 = NewJApplet.this.xtrans(0.0) + NewJApplet.this.draw_off;
                    this.iy0 = NewJApplet.this.ytrans(this.i) + NewJApplet.this.draw_off;
                    g.drawLine(this.ix0 - 10, this.iy0, this.ix0 + 10, this.iy0);
                    g.drawString("" + this.i, this.ix0 - 30, this.iy0 + 5);
                }
                ++this.i;
            }
        }
    }
}

