/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements ActionListener {
    int nmax = 5000;
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Graphics2D gb;
    Graphics2D gb2;
    BufferedImage image;
    BufferedImage image2;
    double r2;
    double r;
    double x;
    double y;
    double vx;
    double vy;
    double dx;
    double dy;
    double dvx;
    double dvy;
    double ekin;
    double epot;
    double angm;
    double time_now;
    double fx;
    double fy;
    double xest;
    double yest;
    double vxest;
    double vyest;
    double xh;
    double yh;
    double vxh;
    double vyh;
    double axh;
    double ayh;
    double ax;
    double ay;
    double vx0;
    double vy0;
    double dvx1;
    double dvy1;
    int i;
    int j;
    int k;
    int l;
    int m;
    int n;
    int outer_loop;
    int count;
    double TSTEP = 0.01;
    int innersteps = 10;
    double[] etot;
    double[] times;
    double[] k1;
    double[] k2;
    double[] k3;
    double[] k4;
    double[] delta;
    double emin;
    double emax;
    double tmax;
    double esum;
    double denom;
    int selector = 0;
    int esel = 0;
    boolean exactstart = false;
    private JButton jButton1;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBox1;
    private JComboBox jComboBox2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JSlider jSlider1;
    private JTextField jTextField1;
    private JTextField jTextField2;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.count = 0;
        this.reset();
        this.init_variables();
        this.timer = new Timer(10, this);
        this.timer.setInitialDelay(10);
        this.timer.start();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.count > this.nmax) {
            return;
        }
        this.iterate();
        this.timer.setInitialDelay(10);
        this.timer.setDelay(10);
        this.timer.restart();
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new myPanel2();
        this.jPanel3 = new JPanel();
        this.jComboBox1 = new JComboBox();
        this.jButton1 = new JButton();
        this.jTextField1 = new JTextField();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jSlider1 = new JSlider();
        this.jLabel3 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jComboBox2 = new JComboBox();
        this.jTextField2 = new JTextField();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(300, 300));
        this.jPanel1.setMinimumSize(new Dimension(300, 300));
        this.jPanel1.setPreferredSize(new Dimension(300, 300));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 298, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 298, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(300, 200));
        this.jPanel2.setMinimumSize(new Dimension(300, 200));
        this.jPanel2.setPreferredSize(new Dimension(300, 200));
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 198, Short.MAX_VALUE));
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel3.setMaximumSize(new Dimension(150, 550));
        this.jPanel3.setMinimumSize(new Dimension(150, 550));
        this.jPanel3.setPreferredSize(new Dimension(150, 550));
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"Euler", "RK2", "RK4", "Verlet", "LeapFrog"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jButton1.setText("reset");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jButton1ActionPerformed(evt);
            }
        });
        this.jTextField1.setText("jTextField1");
        this.jTextField1.setMinimumSize(new Dimension(90, 18));
        this.jTextField1.setPreferredSize(new Dimension(90, 18));
        this.jTextField1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jTextField1ActionPerformed(evt);
            }
        });
        this.jLabel1.setText("timestep");
        this.jLabel2.setText("animation speed");
        this.jSlider1.setMinimum(1);
        this.jSlider1.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.jSlider1MouseDragged(evt);
            }
        });
        this.jLabel3.setText("jLabel3");
        this.jCheckBox1.setText("exact start value");
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jCheckBox1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("jLabel4");
        this.jLabel5.setText("jLabel5");
        this.jLabel6.setText("jLabel6");
        this.jComboBox2.setModel(new DefaultComboBoxModel<String>(new String[]{"etot", "ekin", "epot"}));
        this.jComboBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                NewJApplet.this.jComboBox2ActionPerformed(evt);
            }
        });
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(28, 28, 28).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox2, -2, 93, -2).addComponent(this.jSlider1, -2, 136, -2))).addGroup(jPanel3Layout.createSequentialGroup().addGap(53, 53, 53).addComponent(this.jLabel1)).addGroup(jPanel3Layout.createSequentialGroup().addGap(27, 27, 27).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jComboBox1, -2, -1, -2).addComponent(this.jTextField1, -2, -1, -2))).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jCheckBox1)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel4)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel5)).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel6)).addGroup(jPanel3Layout.createSequentialGroup().addGap(39, 39, 39).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jButton1)))).addContainerGap(57, Short.MAX_VALUE)));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addComponent(this.jComboBox1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jCheckBox1).addGap(37, 37, 37).addComponent(this.jLabel1).addGap(18, 18, 18).addComponent(this.jTextField1, -2, -1, -2).addGap(30, 30, 30).addComponent(this.jButton1).addGap(52, 52, 52).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSlider1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 77, Short.MAX_VALUE).addComponent(this.jLabel6).addGap(18, 18, 18).addComponent(this.jLabel5).addGap(18, 18, 18).addComponent(this.jLabel3).addGap(18, 18, 18).addComponent(this.jLabel4).addContainerGap()));
        this.jTextField2.setText("jTextField2");
        this.jTextField2.setPreferredSize(new Dimension(300, 22));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jTextField2, -2, 300, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel3, -2, 223, -2).addContainerGap(314, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(24, 24, 24).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel3, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(2, 2, 2).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField2, -1, -1, Short.MAX_VALUE))).addContainerGap(21, Short.MAX_VALUE)));
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.count = 0;
        this.TSTEP = Double.parseDouble(this.jTextField1.getText());
        this.reset();
        this.init_variables();
        this.timer.restart();
    }

    private void jTextField1ActionPerformed(ActionEvent evt) {
        this.TSTEP = Double.parseDouble(this.jTextField1.getText());
    }

    private void jSlider1MouseDragged(MouseEvent evt) {
        int i1 = this.jSlider1.getValue();
        this.innersteps = i1 * i1;
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        this.selector = this.jComboBox1.getSelectedIndex();
        this.count = 0;
        this.reset();
        this.init_variables();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.exactstart = this.jCheckBox1.isSelected();
    }

    private void jComboBox2ActionPerformed(ActionEvent evt) {
        this.esel = this.jComboBox2.getSelectedIndex();
        this.count = 0;
        this.reset();
        this.init_variables();
    }

    void init_variables() {
        this.image = new BufferedImage(300, 300, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 300, 300);
        this.image2 = new BufferedImage(300, 200, 1);
        this.gb2 = this.image2.createGraphics();
        this.gb2.setBackground(Color.white);
        this.gb2.clearRect(0, 0, 300, 200);
        this.df = new DecimalFormat("##.00");
        this.df1 = new DecimalFormat("0.0000000E00");
        this.jTextField1.setText("" + this.TSTEP);
        this.jSlider1.setValue((int)Math.sqrt(this.innersteps));
        this.etot = new double[this.nmax];
        this.times = new double[this.nmax];
        this.k1 = new double[4];
        this.k2 = new double[4];
        this.k3 = new double[4];
        this.k4 = new double[4];
        this.delta = new double[4];
    }

    void reset() {
        this.x = 1.0;
        this.y = 0.0;
        this.vx = 0.0;
        this.vy = 1.0;
        this.time_now = 0.0;
        this.emin = 10.0;
        this.emax = -10.0;
        this.tmax = this.TSTEP;
    }

    void iterate() {
        double yp;
        double xp;
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics ga = this.jPanel2.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        Graphics2D g2a = (Graphics2D)ga;
        if (this.selector == 0) {
            this.Euler();
        }
        if (this.selector == 1) {
            this.RK2();
        }
        if (this.selector == 2) {
            this.RK4();
        }
        if (this.selector == 3) {
            this.Verlet();
        }
        if (this.selector == 4) {
            this.LeapFrog();
        }
        if (this.count < this.nmax) {
            this.esum = this.ekin + this.epot;
            if (this.esel == 1) {
                this.etot[this.count] = this.ekin;
            }
            if (this.esel == 2) {
                this.etot[this.count] = this.epot;
            }
            if (this.esel == 0) {
                this.etot[this.count] = this.esum;
            }
            this.times[this.count] = this.time_now;
            if (this.etot[this.count] > this.emax) {
                this.emax = this.etot[this.count];
            }
            if (this.etot[this.count] < this.emin) {
                this.emin = this.etot[this.count];
            }
            this.tmax = this.time_now;
            ++this.count;
        }
        this.gb.clearRect(0, 0, 300, 300);
        this.gb.setColor(Color.black);
        this.gb2.clearRect(0, 0, 300, 200);
        this.gb2.setColor(Color.black);
        for (i = 0; i < 359; ++i) {
            double p = Math.PI * (double)i / 180.0;
            xp = Math.cos(p);
            yp = Math.sin(p);
            double p1 = Math.PI * (double)(i + 1) / 180.0;
            double xp1 = Math.cos(p1);
            double yp1 = Math.sin(p1);
            this.gb.drawLine(150 + (int)(xp * 100.0), 150 + (int)(yp * 100.0), 150 + (int)(xp1 * 100.0), 150 + (int)(yp1 * 100.0));
        }
        this.gb.setColor(Color.red);
        xp = Math.cos(this.time_now);
        yp = Math.sin(this.time_now);
        this.gb.drawOval(147 + (int)(xp * 100.0), 147 + (int)(yp * 100.0), 6, 6);
        this.gb.setColor(Color.blue);
        this.gb.drawOval(147 + (int)(this.x * 100.0), 147 + (int)(this.y * 100.0), 6, 6);
        g2.drawImage((Image)this.image, 0, 0, null);
        this.denom = this.emax - this.emin;
        if (this.denom < 1.0E-14) {
            this.denom = 1.0E-14;
        }
        for (i = 0; i < this.count - 1; ++i) {
            int ix1 = (int)(300.0 * this.times[i] / this.tmax);
            int ix2 = (int)(300.0 * this.times[i + 1] / this.tmax);
            int iy1 = (int)(200.0 * (this.emax - this.etot[i]) / this.denom);
            int iy2 = (int)(200.0 * (this.emax - this.etot[i + 1]) / this.denom);
            this.gb2.drawLine(ix1, iy1, ix2, iy2);
        }
        this.jTextField2.setText("range=" + this.df1.format(this.emax - this.emin) + "\n aver=" + this.df1.format((this.emin + this.emax) * 0.5));
        this.jLabel4.setText("Energy=" + this.df1.format(this.esum));
        this.jLabel5.setText("kinetic=" + this.df1.format(this.ekin));
        this.jLabel6.setText("potential=" + this.df1.format(this.epot));
        this.gb2.drawImage((Image)this.image2, 0, 0, null);
        this.jPanel2.repaint();
        this.jLabel3.setText("time=" + this.df.format(this.time_now));
    }

    void Euler() {
        this.i = 0;
        while (this.i < this.innersteps) {
            this.time_now += this.TSTEP;
            this.r2 = this.x * this.x + this.y * this.y;
            this.r = Math.sqrt(this.r2);
            this.dx = this.vx * this.TSTEP;
            this.dy = this.vy * this.TSTEP;
            this.dvx = -this.TSTEP * this.x / (this.r * this.r2);
            this.dvy = -this.TSTEP * this.y / (this.r * this.r2);
            this.x += this.dx;
            this.y += this.dy;
            this.vx += this.dvx;
            this.vy += this.dvy;
            ++this.i;
        }
        this.ekin = 0.5 * (this.vx * this.vx + this.vy * this.vy);
        this.epot = -1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.angm = this.x * this.vy - this.y * this.vx;
    }

    void RK2() {
        this.i = 0;
        while (this.i < this.innersteps) {
            this.time_now += this.TSTEP;
            this.xh = this.x + 0.5 * this.TSTEP * this.vx;
            this.yh = this.y + 0.5 * this.TSTEP * this.vy;
            this.r2 = this.x * this.x + this.y * this.y;
            this.r = Math.sqrt(this.r2);
            this.vxh = this.vx - 0.5 * this.TSTEP * this.x / (this.r * this.r2);
            this.vyh = this.vy - 0.5 * this.TSTEP * this.y / (this.r * this.r2);
            this.dx = this.TSTEP * this.vxh;
            this.dy = this.TSTEP * this.vyh;
            this.r2 = this.xh * this.xh + this.yh * this.yh;
            this.r = Math.sqrt(this.r2);
            this.axh = -this.xh / (this.r * this.r2);
            this.ayh = -this.yh / (this.r * this.r2);
            this.dvx = this.TSTEP * this.axh;
            this.dvy = this.TSTEP * this.ayh;
            this.x += this.dx;
            this.y += this.dy;
            this.vx += this.dvx;
            this.vy += this.dvy;
            ++this.i;
        }
        this.ekin = 0.5 * (this.vx * this.vx + this.vy * this.vy);
        this.epot = -1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.angm = this.x * this.vy - this.y * this.vx;
    }

    void forces(double x, double y) {
        double r2 = x * x + y * y;
        double r = Math.sqrt(r2);
        this.fx = -x / (r * r2);
        this.fy = -y / (r * r2);
    }

    void RK4() {
        this.i = 0;
        while (this.i < this.innersteps) {
            this.time_now += this.TSTEP;
            this.forces(this.x, this.y);
            this.k1[0] = this.TSTEP * this.vx;
            this.k1[1] = this.TSTEP * this.vy;
            this.k1[2] = this.TSTEP * this.fx;
            this.k1[3] = this.TSTEP * this.fy;
            this.xh = this.x + 0.5 * this.k1[0];
            this.yh = this.y + 0.5 * this.k1[1];
            this.vxh = this.vx + 0.5 * this.k1[2];
            this.vyh = this.vy + 0.5 * this.k1[3];
            this.forces(this.xh, this.yh);
            this.k2[0] = this.TSTEP * this.vxh;
            this.k2[1] = this.TSTEP * this.vyh;
            this.k2[2] = this.TSTEP * this.fx;
            this.k2[3] = this.TSTEP * this.fy;
            this.xh = this.x + 0.5 * this.k2[0];
            this.yh = this.y + 0.5 * this.k2[1];
            this.vxh = this.vx + 0.5 * this.k2[2];
            this.vyh = this.vy + 0.5 * this.k2[3];
            this.forces(this.xh, this.yh);
            this.k3[0] = this.TSTEP * this.vxh;
            this.k3[1] = this.TSTEP * this.vyh;
            this.k3[2] = this.TSTEP * this.fx;
            this.k3[3] = this.TSTEP * this.fy;
            this.xest = this.x + this.k3[0];
            this.yest = this.y + this.k3[1];
            this.vxest = this.vx + this.k3[2];
            this.vyest = this.vy + this.k3[3];
            this.forces(this.xest, this.yest);
            this.k4[0] = this.TSTEP * this.vxest;
            this.k4[1] = this.TSTEP * this.vyest;
            this.k4[2] = this.TSTEP * this.fx;
            this.k4[3] = this.TSTEP * this.fy;
            this.j = 0;
            while (this.j < 4) {
                this.delta[this.j] = (this.k1[this.j] + 2.0 * this.k2[this.j] + 2.0 * this.k3[this.j] + this.k4[this.j]) / 6.0;
                ++this.j;
            }
            this.x += this.delta[0];
            this.y += this.delta[1];
            this.vx += this.delta[2];
            this.vy += this.delta[3];
            ++this.i;
        }
        this.ekin = 0.5 * (this.vx * this.vx + this.vy * this.vy);
        this.epot = -1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.angm = this.x * this.vy - this.y * this.vx;
    }

    void Verlet() {
        if (this.time_now == 0.0) {
            if (this.exactstart) {
                this.xh = Math.cos(-this.TSTEP);
                this.yh = Math.sin(-this.TSTEP);
            } else {
                this.r2 = this.x * this.x + this.y * this.y;
                this.r = Math.sqrt(this.r2);
                this.ax = -this.x / (this.r * this.r2);
                this.ay = -this.y / (this.r * this.r2);
                this.xh = this.x - this.TSTEP * this.vx + 0.5 * this.TSTEP * this.TSTEP * this.ax;
                this.yh = this.y - this.TSTEP * this.vy + 0.5 * this.TSTEP * this.TSTEP * this.ay;
            }
        }
        this.i = 0;
        while (this.i < this.innersteps) {
            this.time_now += this.TSTEP;
            this.r2 = this.x * this.x + this.y * this.y;
            this.r = Math.sqrt(this.r2);
            this.dvx = -this.TSTEP * this.x / (this.r * this.r2);
            this.dvy = -this.TSTEP * this.y / (this.r * this.r2);
            this.dx = this.x - this.xh + this.dvx * this.TSTEP;
            this.dy = this.y - this.yh + this.dvy * this.TSTEP;
            this.vx = 0.5 * this.dvx + (this.x - this.xh) / this.TSTEP;
            this.vy = 0.5 * this.dvy + (this.y - this.yh) / this.TSTEP;
            this.xh = this.x;
            this.yh = this.y;
            this.x += this.dx;
            this.y += this.dy;
            ++this.i;
        }
        this.ekin = 0.5 * (this.vx * this.vx + this.vy * this.vy);
        this.epot = -1.0 / Math.sqrt(this.xh * this.xh + this.yh * this.yh);
        this.angm = this.xh * this.vy - this.yh * this.vx;
    }

    void LeapFrog() {
        if (this.time_now == 0.0) {
            if (this.exactstart) {
                this.vx = -Math.sin(-0.5 * this.TSTEP);
                this.vy = Math.cos(-0.5 * this.TSTEP);
            } else {
                this.r2 = this.x * this.x + this.y * this.y;
                this.r = Math.sqrt(this.r2);
                this.dvx = 0.5 * this.TSTEP * this.x / (this.r * this.r2);
                this.dvy = 0.5 * this.TSTEP * this.y / (this.r * this.r2);
                this.vx += this.dvx;
                this.vy += this.dvy;
            }
        }
        this.i = 0;
        while (this.i < this.innersteps) {
            this.time_now += this.TSTEP;
            this.r2 = this.x * this.x + this.y * this.y;
            this.r = Math.sqrt(this.r2);
            this.dvx = -this.TSTEP * this.x / (this.r * this.r2);
            this.dvy = -this.TSTEP * this.y / (this.r * this.r2);
            this.vx += this.dvx;
            this.vy += this.dvy;
            this.dx = this.vx * this.TSTEP;
            this.dy = this.vy * this.TSTEP;
            this.x += this.dx;
            this.y += this.dy;
            ++this.i;
        }
        this.dvx1 = -this.TSTEP * this.x / (this.r * this.r2);
        this.dvy1 = -this.TSTEP * this.y / (this.r * this.r2);
        this.vx0 = this.vx + 0.5 * this.dvx1;
        this.vy0 = this.vy + 0.5 * this.dvy1;
        this.ekin = 0.5 * (this.vx0 * this.vx0 + this.vy0 * this.vy0);
        this.epot = -1.0 / Math.sqrt(this.x * this.x + this.y * this.y);
        this.esum = this.epot + this.ekin;
        this.angm = this.x * this.vy0 - this.y * this.vx0;
    }

    public class myPanel2
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics ga) {
            Graphics2D g2a = (Graphics2D)ga;
            int size = 200;
            super.paintComponent(ga);
            g2a.drawImage((Image)NewJApplet.this.image2, 0, 0, null);
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

