/*
 * Decompiled with CFR 0.152.
 */
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Line2D;
import java.text.DecimalFormat;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;

public class NewJApplet
extends JApplet {
    double[] RealC;
    double[] ImagC;
    double[] RealC2;
    double[] ImagC2;
    double[] RealC3;
    double[] ImagC3;
    double[] RealC4;
    double[] ImagC4;
    double[] RealF1;
    double[] ImagF1;
    double[] RealF2;
    double[] ImagF2;
    double[] RealF3;
    double[] ImagF3;
    double[] RealF4;
    double[] ImagF4;
    int nstates = 50;
    double V = 0.01;
    double DeltaE = 2.0;
    double tstep = 0.002;
    double E0 = 0.0;
    double EN;
    int stepin = 20;
    int scale = 200;
    DecimalFormat df;
    DecimalFormat df2;
    static float[] dash1 = new float[]{5.0f};
    static BasicStroke dashed = new BasicStroke(1.0f, 0, 0, 10.0f, dash1, 0.0f);
    private JLabel DEL;
    private JSlider DES;
    private JLabel E0L;
    private JSlider E0S;
    private JLabel VL;
    private JSlider VS;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JLabel scalel;
    private JSlider scales;
    private JLabel timl;
    private JSlider tims;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.RealC = new double[this.nstates];
        this.ImagC = new double[this.nstates];
        this.RealC2 = new double[this.nstates];
        this.ImagC2 = new double[this.nstates];
        this.RealC3 = new double[this.nstates];
        this.ImagC3 = new double[this.nstates];
        this.RealC4 = new double[this.nstates];
        this.ImagC4 = new double[this.nstates];
        this.RealF1 = new double[this.nstates];
        this.ImagF1 = new double[this.nstates];
        this.RealF2 = new double[this.nstates];
        this.ImagF2 = new double[this.nstates];
        this.RealF3 = new double[this.nstates];
        this.ImagF3 = new double[this.nstates];
        this.RealF4 = new double[this.nstates];
        this.ImagF4 = new double[this.nstates];
        this.df = new DecimalFormat("##0.0000");
        this.df2 = new DecimalFormat("0.0");
        this.VS.setValue((int)(this.V * 2000.0));
        this.DES.setValue((int)(this.DeltaE * 20.0));
        this.E0S.setValue((int)(this.E0 * 40.0));
        this.scales.setValue(this.scale);
        this.tims.setValue(this.stepin);
        this.VL.setText("V=" + this.df.format(this.V));
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.E0L.setText("E0=" + this.df.format(this.E0));
        this.timl.setText("steps=" + this.stepin);
        this.scalel.setText("scale=" + this.scale);
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jLabel1 = new JLabel();
        this.VS = new JSlider();
        this.DES = new JSlider();
        this.E0L = new JLabel();
        this.timl = new JLabel();
        this.E0S = new JSlider();
        this.VL = new JLabel();
        this.tims = new JSlider();
        this.DEL = new JLabel();
        this.scales = new JSlider();
        this.scalel = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel1.setText("occupation of initial state");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, 296, -2).addContainerGap(150, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1, -2, 15, -2).addGap(0, 349, Short.MAX_VALUE)));
        this.VS.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.VSMouseDragged(evt);
            }
        });
        this.DES.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.DESMouseDragged(evt);
            }
        });
        this.E0L.setText("E0");
        this.timl.setText("timescale");
        this.E0S.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.E0SMouseDragged(evt);
            }
        });
        this.VL.setText("V          ");
        this.tims.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.timsMouseDragged(evt);
            }
        });
        this.DEL.setText("DeltaE ");
        this.scales.setMaximum(200);
        this.scales.setMinimum(20);
        this.scales.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.scalesMouseDragged(evt);
            }
        });
        this.scalel.setText("scale");
        this.jLabel2.setText("time");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(404, 404, 404).addComponent(this.jLabel2)).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.E0S, -2, 133, -2).addComponent(this.VS, -2, 133, -2).addComponent(this.DES, -2, 133, -2).addComponent(this.tims, -2, 133, -2).addComponent(this.scales, -2, 133, -2).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.VL)).addGroup(layout.createSequentialGroup().addGap(51, 51, 51).addComponent(this.E0L)).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.DEL)).addGroup(layout.createSequentialGroup().addGap(37, 37, 37).addComponent(this.timl)).addGroup(layout.createSequentialGroup().addGap(38, 38, 38).addComponent(this.scalel))).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(60, 60, 60).addComponent(this.E0L).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.E0S, -2, -1, -2).addGap(30, 30, 30).addComponent(this.VL).addGap(18, 18, 18).addComponent(this.VS, -2, -1, -2).addGap(48, 48, 48).addComponent(this.DEL).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.DES, -2, -1, -2).addGap(27, 27, 27).addComponent(this.timl).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tims, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.scalel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.scales, -2, -1, -2)).addGroup(layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jPanel1, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addContainerGap(84, Short.MAX_VALUE)));
    }

    private void VSMouseDragged(MouseEvent evt) {
        this.V = (double)this.VS.getValue() * 5.0E-4;
        this.VL.setText("V=" + this.df.format(this.V));
        this.jPanel1.repaint();
    }

    private void DESMouseDragged(MouseEvent evt) {
        this.DeltaE = (double)this.DES.getValue() * 0.05;
        this.DEL.setText("Energy gap=" + this.df.format(this.DeltaE));
        this.jPanel1.repaint();
    }

    private void E0SMouseDragged(MouseEvent evt) {
        this.E0 = (double)this.E0S.getValue() * 0.025;
        this.E0L.setText("E0=" + this.df.format(this.E0));
        this.jPanel1.repaint();
    }

    private void timsMouseDragged(MouseEvent evt) {
        this.stepin = this.tims.getValue();
        this.timl.setText("steps=" + this.stepin);
        this.jPanel1.repaint();
    }

    private void scalesMouseDragged(MouseEvent evt) {
        this.scale = this.scales.getValue();
        this.scalel.setText("scale=" + this.scale);
        this.jPanel1.repaint();
    }

    void grad(double[] RC, double[] IC, double[] RF, double[] IF, double t) {
        int i;
        RF[0] = this.E0 * IC[0];
        IF[0] = -this.E0 * RC[0];
        for (i = 1; i < this.nstates; ++i) {
            RF[0] = RF[0] + this.V * IC[i];
            IF[0] = IF[0] - this.V * RC[i];
        }
        for (i = 1; i < this.nstates; ++i) {
            this.EN = (double)(i - this.nstates / 2) * this.DeltaE / (double)this.nstates;
            RF[i] = this.V * IC[0] + this.EN * IC[i];
            IF[i] = -this.V * RC[0] - this.EN * RC[i];
        }
    }

    void advance(double[] RC, double[] IC, double[] RF, double[] IF, double[] RC1, double[] IC1, double step) {
        for (int i = 0; i < this.nstates; ++i) {
            RC1[i] = RC[i] + RF[i] * step;
            IC1[i] = IC[i] + IF[i] * step;
        }
    }

    void rk4(double t) {
        this.grad(this.RealC, this.ImagC, this.RealF1, this.ImagF1, t);
        this.advance(this.RealC, this.ImagC, this.RealF1, this.ImagF1, this.RealC2, this.ImagC2, this.tstep * 0.5);
        this.grad(this.RealC2, this.ImagC2, this.RealF2, this.ImagF2, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF2, this.ImagF2, this.RealC3, this.ImagC3, this.tstep * 0.5);
        this.grad(this.RealC3, this.ImagC3, this.RealF3, this.ImagF3, t + this.tstep * 0.5);
        this.advance(this.RealC, this.ImagC, this.RealF3, this.ImagF3, this.RealC4, this.ImagC4, this.tstep);
        this.grad(this.RealC4, this.ImagC4, this.RealF4, this.ImagF4, t + this.tstep);
        for (int i = 0; i < this.nstates; ++i) {
            this.RealC[i] = this.RealC[i] + this.tstep * (this.RealF1[i] + 2.0 * this.RealF2[i] + 2.0 * this.RealF3[i] + this.RealF4[i]) / 6.0;
            this.ImagC[i] = this.ImagC[i] + this.tstep * (this.ImagF1[i] + 2.0 * this.ImagF2[i] + 2.0 * this.ImagF3[i] + this.ImagF4[i]) / 6.0;
        }
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int i;
        int ix0;
        int ix1;
        int i1;

        void iterate() {
        }

        public void paintComponent(Graphics g) {
            int iy2;
            int itick;
            Graphics2D g2 = (Graphics2D)g;
            super.paintComponent(g);
            NewJApplet.this.RealC[0] = 1.0;
            NewJApplet.this.ImagC[0] = 0.0;
            this.i = 1;
            while (this.i < NewJApplet.this.nstates) {
                NewJApplet.this.RealC[this.i] = 0.0;
                NewJApplet.this.ImagC[this.i] = 0.0;
                ++this.i;
            }
            this.iy0 = 0;
            this.ix0 = 0;
            double t = 0.0;
            g.setColor(Color.black);
            g.drawRect(0, 50, 400, 300);
            g.setColor(Color.gray);
            g2.setStroke(dashed);
            for (itick = 1; itick < 10; ++itick) {
                iy2 = 50 - (int)(Math.log((double)itick * 0.1) * (double)NewJApplet.this.scale);
                if (iy2 >= 350) continue;
                g2.draw(new Line2D.Double(0.0, iy2, 400.0, iy2));
            }
            for (itick = 1; itick < 10; ++itick) {
                iy2 = 50 - (int)(Math.log((double)itick * 0.01) * (double)NewJApplet.this.scale);
                if (iy2 >= 350) continue;
                g2.draw(new Line2D.Double(0.0, iy2, 400.0, iy2));
            }
            for (itick = 1; itick < 10; ++itick) {
                iy2 = 50 - (int)(Math.log((double)itick * 0.001) * (double)NewJApplet.this.scale);
                if (iy2 >= 350) continue;
                g2.draw(new Line2D.Double(0.0, iy2, 400.0, iy2));
            }
            for (itick = 1; itick < 10; ++itick) {
                iy2 = 50 - (int)(Math.log((double)itick * 1.0E-4) * (double)NewJApplet.this.scale);
                if (iy2 >= 350) continue;
                g2.draw(new Line2D.Double(0.0, iy2, 400.0, iy2));
            }
            for (itick = 1; itick < 10; ++itick) {
                iy2 = 50 - (int)(Math.log((double)itick * 1.0E-5) * (double)NewJApplet.this.scale);
                if (iy2 >= 350) continue;
                g2.draw(new Line2D.Double(0.0, iy2, 400.0, iy2));
            }
            for (itick = 0; itick < 10; ++itick) {
                iy2 = itick * 50;
                if (iy2 >= 400) continue;
                g2.draw(new Line2D.Double(iy2, 50.0, iy2, 350.0));
            }
            g2.setColor(Color.black);
            g2.drawString("1.0", 400, 50);
            iy2 = 50 - (int)(Math.log(0.1) * (double)NewJApplet.this.scale);
            if (iy2 < 350) {
                g2.drawString("0.1", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.01) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.01", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.001) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.001", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(1.0E-4) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.0001", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(1.0E-5) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.00001", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.2) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.2", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.02) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.02", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.002) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.002", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(2.0E-4) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.0002", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(2.0E-5) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.00002", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.5) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.5", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.05) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.05", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(0.005) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.005", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(5.0E-4) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.0005", 400, iy2);
            }
            if ((iy2 = 50 - (int)(Math.log(5.0E-5) * (double)NewJApplet.this.scale)) < 350) {
                g2.drawString("0.00005", 400, iy2);
            }
            this.i = 0;
            while (this.i < 400) {
                this.i1 = 0;
                while (this.i1 < NewJApplet.this.stepin) {
                    NewJApplet.this.rk4(t += NewJApplet.this.tstep);
                    ++this.i1;
                }
                if (this.i % 100 == 0) {
                    g2.drawString(NewJApplet.this.df2.format(t), this.i, 360);
                }
                this.iy1 = (int)(Math.log(NewJApplet.this.RealC[0] * NewJApplet.this.RealC[0] + NewJApplet.this.ImagC[0] * NewJApplet.this.ImagC[0]) * (double)NewJApplet.this.scale);
                g.setColor(Color.blue);
                g.drawLine(this.i, 50 - this.iy0, this.i + 1, 50 - this.iy1);
                this.iy0 = this.iy1;
                g.setColor(Color.black);
                ++this.i;
            }
        }
    }
}

