/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JApplet;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.LayoutStyle;
import javax.swing.Timer;

public class NewJApplet
extends JApplet
implements Runnable {
    DecimalFormat df;
    DecimalFormat df1;
    Timer timer;
    Thread calculatorThread;
    int N = 20;
    int MAXITER = 200;
    double J = 1.0;
    int NSQ = 40000;
    int[] Lattice;
    double kT;
    double magav;
    double B;
    int Npoints;
    int magsum;
    int done;
    int number_samples;
    char[] message;
    char cc;
    int i;
    int j;
    int iter;
    int Spin;
    double DE;
    double r;
    double JJ;
    double[] Analytical;
    int count = 0;
    int loops = 20000;
    int ixo = 0;
    int iyo = 0;
    Graphics2D gb;
    BufferedImage image;
    private JLabel Blab;
    private JSlider Bslider;
    private JLabel Jlab;
    private JSlider Jslider;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel kTlab;
    private JSlider kTslider;

    public void init() {
        try {
            EventQueue.invokeAndWait(new Runnable(){

                public void run() {
                    NewJApplet.this.initComponents();
                }
            });
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.df = new DecimalFormat("00.000E0");
        this.df1 = new DecimalFormat("0.000");
        this.Lattice = new int[this.N];
        this.Analytical = new double[200];
        this.image = new BufferedImage(400, 400, 1);
        this.gb = this.image.createGraphics();
        this.gb.setBackground(Color.white);
        this.gb.clearRect(0, 0, 400, 400);
        this.reset_all();
        this.calc_exact();
    }

    public void run() {
        while (Thread.currentThread() == this.calculatorThread) {
            this.Metropolis();
        }
    }

    public void start() {
        if (this.calculatorThread == null) {
            this.calculatorThread = new Thread(this);
            this.calculatorThread.start();
        }
    }

    public void stop() {
        this.calculatorThread = null;
    }

    public void reset_all() {
        this.i = 0;
        this.j = 0;
        this.count = 0;
        this.kT = 2.0;
        this.B = 1.0;
        this.kTlab.setText("kT=" + this.df1.format(this.kT));
        this.kTslider.setValue((int)(Math.sqrt(this.kT) * 100.0));
        this.Blab.setText("B=" + this.df1.format(this.B));
        this.JJ = (Math.sqrt(this.B) + 2.0) * 50.0;
        if (this.B < 0.0) {
            this.JJ = -this.JJ;
        }
        this.Bslider.setValue((int)this.JJ);
        this.Jlab.setText("J=" + this.df1.format(this.J));
        this.JJ = (Math.sqrt(this.J) + 2.0) * 50.0;
        if (this.J < 0.0) {
            this.JJ = -this.JJ;
        }
        this.Jslider.setValue((int)this.JJ);
        this.RandomSpin();
        this.ClearAverage();
    }

    public void calc_exact() {
        this.i = 0;
        while (this.i < 200) {
            double x = (double)this.i * 0.05 - 5.0;
            if (x > 1000.0 * this.kT) {
                this.Analytical[this.i] = 1.0 / Math.sqrt(1.0 + 4.0 * Math.exp(-(4.0 * this.J + 2.0 * x) / this.kT));
            } else if (x < -1000.0 * this.kT) {
                this.Analytical[this.i] = -1.0 / Math.sqrt(1.0 + 4.0 * Math.exp(-(4.0 * this.J - 2.0 * x) / this.kT));
            } else {
                double s = Math.sinh(x / this.kT);
                this.Analytical[this.i] = s / Math.sqrt(s * s + Math.exp(-4.0 * this.J / this.kT));
            }
            ++this.i;
        }
    }

    private void initComponents() {
        this.jPanel1 = new myPanel();
        this.jPanel2 = new JPanel();
        this.kTslider = new JSlider();
        this.kTlab = new JLabel();
        this.Bslider = new JSlider();
        this.Blab = new JLabel();
        this.Jslider = new JSlider();
        this.Jlab = new JLabel();
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel1.setMaximumSize(new Dimension(350, 550));
        this.jPanel1.setMinimumSize(new Dimension(350, 550));
        this.jPanel1.setPreferredSize(new Dimension(350, 550));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 415, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 0, Short.MAX_VALUE));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanel2.setMaximumSize(new Dimension(120, 550));
        this.jPanel2.setMinimumSize(new Dimension(120, 550));
        this.jPanel2.setPreferredSize(new Dimension(120, 550));
        this.kTslider.setMaximum(310);
        this.kTslider.setMinimum(50);
        this.kTslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.kTsliderMouseDragged(evt);
            }
        });
        this.kTlab.setText("jLabel1");
        this.Bslider.setMaximum(200);
        this.Bslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.BsliderMouseDragged(evt);
            }
        });
        this.Blab.setText("jLabel1");
        this.Jslider.setMaximum(200);
        this.Jslider.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent evt) {
                NewJApplet.this.JsliderMouseDragged(evt);
            }
        });
        this.Jlab.setText("jLabel1");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap(29, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.kTlab).addGap(66, 66, 66)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.Blab).addGap(64, 64, 64)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.kTslider, -2, 125, -2).addComponent(this.Bslider, -2, 125, -2).addComponent(this.Jslider, -2, 125, -2)).addGap(25, 25, 25)).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.Jlab).addGap(65, 65, 65)))));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addGap(29, 29, 29).addComponent(this.kTlab).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.kTslider, -2, -1, -2).addGap(42, 42, 42).addComponent(this.Blab).addGap(18, 18, 18).addComponent(this.Bslider, -2, -1, -2).addGap(36, 36, 36).addComponent(this.Jlab).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.Jslider, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, 417, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, 181, -2).addContainerGap(492, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jPanel1, -2, 0, Short.MAX_VALUE).addComponent(this.jPanel2, -2, 400, -2)).addContainerGap(375, Short.MAX_VALUE)));
    }

    private void kTsliderMouseDragged(MouseEvent evt) {
        this.kT = (double)this.kTslider.getValue() * 0.01;
        this.kT *= this.kT;
        this.kTlab.setText("kT=" + this.df1.format(this.kT));
        this.calc_exact();
    }

    private void BsliderMouseDragged(MouseEvent evt) {
        this.B = (double)this.Bslider.getValue() * 0.02 - 2.0;
        this.B = this.B > 0.0 ? (this.B *= this.B) : -this.B * this.B;
        this.Blab.setText("B=" + this.df1.format(this.B));
        this.calc_exact();
    }

    private void JsliderMouseDragged(MouseEvent evt) {
        this.J = (double)this.Jslider.getValue() * 0.02 - 2.0;
        this.J = this.J > 0.0 ? (this.J *= this.J) : -this.J * this.J;
        this.Jlab.setText("J=" + this.df1.format(this.J));
        this.calc_exact();
    }

    void AllUp() {
        for (int i = 0; i < this.N; ++i) {
            this.Lattice[i] = 1;
        }
    }

    void RandomSpin() {
        for (int i = 0; i < this.N; ++i) {
            double r = Math.random();
            this.Lattice[i] = r < 0.5 ? -1 : 1;
        }
    }

    double Energy(int i, int Spin) {
        int left = i == 0 ? this.N - 1 : i - 1;
        int right = i == this.N - 1 ? 0 : i + 1;
        return -2.0 * this.J * (double)Spin * (double)(this.Lattice[left] + this.Lattice[right]) + 2.0 * this.B * (double)Spin;
    }

    void Metropolis() {
        int i;
        Graphics g = this.jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D)g;
        for (i = 0; i < this.N; ++i) {
            this.Spin = this.Lattice[i] < 1 ? 1 : -1;
            this.DE = this.Energy(i, this.Spin);
            if (this.DE < 0.0) {
                this.Lattice[i] = this.Spin;
                continue;
            }
            this.r = Math.random();
            if (!(Math.exp(-this.DE / this.kT) > this.r)) continue;
            this.Lattice[i] = this.Spin;
        }
        ++this.number_samples;
        this.magsum = 0;
        for (i = 0; i < this.N; ++i) {
            this.magsum += this.Lattice[i];
        }
        this.magav += (double)this.magsum;
        if (this.number_samples > 500) {
            this.gb.clearRect(0, 300, 400, 50);
            int ixs = 0;
            for (i = 0; i < this.N; ++i) {
                if (this.Lattice[i] < 0) {
                    this.gb.setColor(Color.green);
                    this.gb.fillOval(ixs, 320, 15, 10);
                    ixs += 15;
                    continue;
                }
                this.gb.setColor(Color.red);
                this.gb.fillOval(ixs, 320, 5, 15);
                ixs += 5;
            }
            this.gb.clearRect(0, 40, 400, 250);
            this.gb.setColor(Color.red);
            int ix = (int)((this.B + 5.0) * 40.0 + 2.0);
            int iy = 145 - (int)(-100.0 * this.magav / (double)(this.N * this.number_samples));
            this.gb.drawOval(ix - 5, iy - 5, 10, 10);
            this.ClearAverage();
            for (ix = 1; ix < 200; ++ix) {
                this.gb.drawLine(2 * (ix - 1), 145 - (int)(100.0 * this.Analytical[ix - 1]), 2 * ix, 145 - (int)(100.0 * this.Analytical[ix]));
            }
            this.gb.setColor(Color.black);
            this.gb.drawLine(0, 145, 400, 145);
            this.gb.drawString("force (B)", 320, 195);
            this.gb.drawLine(0, 0, 0, 300);
            this.gb.drawString("average chain length", 5, 25);
            for (i = -4; i < 5; ++i) {
                ix = (i + 5) * 40 + 2;
                this.gb.drawLine(ix, 150, ix, 140);
                this.gb.drawString("" + i, ix - 5, 170);
            }
            for (i = -5; i < 6; ++i) {
                iy = 145 + i * 20;
                this.gb.drawLine(0, iy, 5, iy);
            }
            g2.drawImage((Image)this.image, 0, 0, null);
        }
    }

    void ClearAverage() {
        this.magav = 0.0;
        this.number_samples = 0;
    }

    public class myPanel
    extends JPanel {
        int iy0;
        int iy1;
        int ix0;
        int ix1;
        double tscale;

        public void paint(Graphics g) {
            Graphics2D g2 = (Graphics2D)g;
            int size = 200;
            super.paintComponent(g);
            g2.drawImage((Image)NewJApplet.this.image, 0, 0, null);
        }
    }
}

