/*
 * NewJApplet.java
 *
 * Created on October 2, 2008, 2:11 PM
 */
package gpoly;

import javax.swing.SwingUtilities;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.BorderFactory;
import java.awt.Color;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet implements ActionListener {

    Timer timer;
    public int number_segments,  numb_loops,  n_aver,  iav,  ndata;
    public int window_w = 10;
    public double emin,  elast,  etot,  xharm,  kT,  kappa,  length,  ekin,  epot,  tstep,  damp;
    public double xcoor,  ycoor,  xtry,  ytry,  forcx,  forcy,  vx,  vy,  dx,  dv,  vtry;
    public double[] datax,  datay;
    public double eq_distance;
    double stdv;
    double ekinav, epotav, lengav, extensav, extensavn, extenq;
    int[] ixp, iyp;
    DecimalFormat df, df2;

    public void actionPerformed(ActionEvent e) {
        aver();
        jPanel2.repaint();
        jPanel1.repaint();
        timer.restart();

    }

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                    setup();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        DecimalFormatSymbols unusualSymbols =
                new DecimalFormatSymbols();

        unusualSymbols.setDecimalSeparator('.');

        df = new DecimalFormat("##0.00000000", unusualSymbols);
        df2 = new DecimalFormat("##0.00", unusualSymbols);
        timer = new Timer(10, this);
        timer.setInitialDelay(10);
        timer.start();
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jLabel1 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jSlider2 = new javax.swing.JSlider();
        jSlider3 = new javax.swing.JSlider();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jSlider4 = new javax.swing.JSlider();
        jLabel7 = new javax.swing.JLabel();
        jLabel8 = new javax.swing.JLabel();
        jLabel9 = new javax.swing.JLabel();
        jPanel2 = new myPanel2();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setMaximumSize(new java.awt.Dimension(400, 350));
        jPanel1.setMinimumSize(new java.awt.Dimension(400, 350));
        jPanel1.setOpaque(false);
        jPanel1.setPreferredSize(new java.awt.Dimension(400, 350));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 398, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 348, Short.MAX_VALUE)
        );

        jLabel1.setText("Epot");

        jLabel3.setText("elongation");

        jSlider1.setPaintTicks(true);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jSlider2.setMinimum(-100);
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jSlider3.setMaximum(500);
        jSlider3.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider3MouseDragged(evt);
            }
        });

        jLabel4.setText("friction");

        jLabel5.setText("force");

        jLabel6.setText("spring");

        jSlider4.setMaximum(1000);
        jSlider4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider4MouseDragged(evt);
            }
        });

        jLabel7.setText("temperature");

        jLabel8.setText("Ekin");

        jLabel9.setText("Etot");

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setMaximumSize(new java.awt.Dimension(400, 200));
        jPanel2.setMinimumSize(new java.awt.Dimension(400, 200));
        jPanel2.setPreferredSize(new java.awt.Dimension(400, 200));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 398, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 198, Short.MAX_VALUE)
        );

        jButton1.setText("excite");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("reset");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jLabel5, javax.swing.GroupLayout.PREFERRED_SIZE, 183, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addGap(432, 432, 432)
                .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap())
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(432, 432, 432)
                        .addComponent(jSlider1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(432, 432, 432)
                        .addComponent(jSlider3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(432, 432, 432)
                        .addComponent(jSlider4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel1, javax.swing.GroupLayout.PREFERRED_SIZE, 213, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel8, javax.swing.GroupLayout.PREFERRED_SIZE, 202, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 204, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel3)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton1)
                                .addGap(18, 18, 18)
                                .addComponent(jButton2)))))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jSlider1, jSlider2, jSlider3, jSlider4});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabel1, jLabel3, jLabel8, jLabel9});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabel4, jLabel5, jLabel6, jLabel7});

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jButton1, jButton2});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(43, 43, 43)
                        .addComponent(jLabel1)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jLabel8)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel9)
                        .addGap(108, 108, 108)
                        .addComponent(jLabel3)
                        .addGap(71, 71, 71)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jButton1)
                            .addComponent(jButton2))
                        .addGap(39, 39, 39)
                        .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 16, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(2, 2, 2)
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jLabel5)
                        .addGap(1, 1, 1)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel6)
                        .addGap(1, 1, 1)
                        .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel7)
                        .addGap(1, 1, 1)
                        .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addGap(20, 20, 20)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );

        layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jSlider1, jSlider2, jSlider3, jSlider4});

    }// </editor-fold>//GEN-END:initComponents

private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
    damp = jSlider1.getValue() * 0.1;// TODO add your handling code here:
}//GEN-LAST:event_jSlider1MouseDragged

private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
    kappa = jSlider2.getValue() * 0.25;
    drawpot();
    jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_jSlider2MouseDragged

private void jSlider3MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseDragged
    xharm = jSlider3.getValue();
    drawpot();
    jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_jSlider3MouseDragged

private void jSlider4MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseDragged
    kT = jSlider4.getValue() * 0.01;// TODO add your handling code here:
}//GEN-LAST:event_jSlider4MouseDragged

private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
    xcoor=1;
    // TODO add your handling code here:
}//GEN-LAST:event_jButton1ActionPerformed

private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
    ndata = 0;// TODO add your handling code here:
}//GEN-LAST:event_jButton2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider jSlider3;
    private javax.swing.JSlider jSlider4;
    // End of variables declaration//GEN-END:variables

    public void setup() {
        int i;

        number_segments = 20;
        eq_distance = 1.0;
        kT = 0.0;
        tstep = 0.005;
        damp = 0.1;

        emin = 1000.0;
        elast = 1000.0;
        etot = 1000.0;
        xharm = 10.0;
        kT = 10.0;
        kappa = 0.0;
        numb_loops = 10;
        n_aver = 250;
        iav = 0;
        ekinav = 0;
        epotav = 0;
        lengav = 0;
        extensav = 0;
        extensavn = 0;
        extenq = 0;


        datax = new double[100];
        datay = new double[100];
        ndata = 0;

        ixp=new int[400];
        iyp=new int[400];

        xcoor = 1;
        ycoor = 0;
        vx = 0;
        vy = 0;



        jSlider1.setValue((int) (10.0 * damp));
        jSlider2.setValue((int) (kappa * 10.0));
        jSlider3.setValue((int) xharm);
        jSlider4.setValue((int) (100 * kT));

        drawpot();
    }

    public double randgauss() {
        double x, r, phi, rho;

        r = Math.random();
        phi = 2.0 * Math.PI * r;

        r = Math.random();
        rho = Math.sqrt(-Math.log(1 - r));

        x = rho * Math.cos(phi) * Math.sqrt(2.0);



        return x;
    }

    public void rk2() {

        forcx = kappa + kT * (Math.random() - 0.5);

        xtry = xcoor + vx * tstep * 0.5;
        vtry = vx * (1 - damp * tstep * 0.5) - xharm * xcoor * tstep * 0.5 + forcx * tstep * 0.5;

        dx = vtry * tstep;
        dv = -damp * vtry * tstep - xharm * xtry * tstep + forcx * tstep;

        xcoor += dx;
        vx += dv;

        ekin = 0.5 * vx * vx;
        epot = 0.5 * xharm * xcoor * xcoor -  kappa * xcoor;



    }

    class myPanel2 extends javax.swing.JPanel {

        public void paintComponent(Graphics g) {
            int ix, iy, ida, iy1;
            g.clearRect(1, 1, 400, 200);
            g.drawLine(0, 100, 400, 100);
            g.drawLine(200, 0, 200, 200);
            g.drawString("x",380,90);
            g.drawString("v",210,10);
            g.drawString("phase space",10,10);

            ix = (int) (xcoor * 100) + 200;
            iy = (int) (vx * 100 + 100);
            g.fillOval(ix-4, iy-4, 8, 8);
        //super.paintComponent(g);




        }
    }

    public void drawpot() {
        int i, ix, iy;
        double xx, vv;
        for (i = 0; i < 400; i++) {

            xx = (i - 200) * 0.01;

            vv = xx * xx * xharm * 0.5 - kappa * xx;
            iy = 200 - (int) (vv * 1);
            ixp[i] = i;
            iyp[i] = iy;

        }

    }

    public void aver() {
        int iverl;
        xtry = 0.0;
        ytry = 0.0;


        if (iav == 0) {
            ekinav = 0;
            epotav = 0;
            lengav = 0;
            extensav = 0;
            extenq = 0;
        }

        for (iverl = 0; iverl < numb_loops; iverl++) {
            rk2();
        }




        ekinav += ekin;
        epotav += epot;
        lengav += length;
        extensav += xcoor;
        extenq += (xcoor * xcoor);

        iav++;
        if (iav >= n_aver) {
            iav = 0;
            extensavn = extensav / n_aver;
            extenq = extenq / n_aver;
            stdv = Math.sqrt(extenq - extensavn * extensavn);

            lengav = lengav / n_aver;
            jLabel1.setText("Epot:" + df.format((epotav / n_aver)));
            jLabel8.setText("Ekin:" + df.format((ekinav / n_aver)));
            jLabel9.setText("Etot:" + df.format((ekinav + epotav) / n_aver));
            
            jLabel3.setText("elongation:" + df2.format(extensavn) + " +- " + df2.format(stdv));
        }







        jLabel5.setText("force:" + df2.format(kappa * 0.1));
        jLabel4.setText("friction:" + df2.format(damp));
        jLabel6.setText("spring:" + df2.format(xharm));




        jLabel7.setText("temperature:" + df2.format(kT));




    }

    class myPanel extends javax.swing.JPanel {

        int ix, iy, ix1, iy1, i2, i;
        double sx, sy, rx, ry, r2, r2s, r, edel, bofa, rn, vv, xx;

        public void paintComponent(Graphics g) {
            int iverl, ix, iy;
            Graphics g2;
            super.paintComponent(g);

            g2 = jPanel2.getGraphics();

            {
                //jLabel7.setText("" + (kT * 1));


                //jPanel2.repaint();
                
                
                g.drawString("potential energy V(x)",10,10);




                g.drawPolyline(ixp, iyp, 400);
                ix = (int) (xcoor * 100) + 200;



            vv = xcoor * xcoor * xharm * 0.5 - kappa * xcoor;
            iy = 200 - (int) (vv * 1);

            g.fillOval(ix-4,iy-4,8,8);

            }
        }
    }
}
