/*
 * NewJApplet.java
 *
 * Created on April 6, 2008, 11:11 AM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet
        implements ActionListener {

    DecimalFormat df, df1;
    Timer timer;
    int natoms = 10;
    int natoms1 = 5;
    int nmols = 2;
    int count;
    double[][] rcg, vcg, rbod, omega, omega_ad, ombod, angmom, inertia, force, torque, rlab, quat;
    double[] dr, fij;
    double tstep = 0.0005;
    double tsf;
    int[] nat;
    double[][][] amat;
    double[] mass;
    double[][] values;
    double drtx, drty, drtz; // total angular momentum
    BufferedImage image, imagea;
    Graphics2D gb, gba;
    double zz, totaltime;
    double yoffset = 0.0;
    double inimom1 = 0.0;
    double inimom2 = 0.0;
    double inimom1a=0;
    double inimom2a=0;
    double inivel = 0.0;
    double erot1, erot2, ekin1, ekin2, etot1, etot2, vdwen;
    boolean simulating = false;
    boolean attractive = true;
    double etot;
    double escale = 100;
    int timescale = 20;
    int innerloops = 20;
    double energyscale = 100;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        init_variables();
        reset();
    }

    public void actionPerformed(ActionEvent e) {
        int i, j;



        if (simulating) {

            if (count == 0) {

                innerloops = timescale;
                advance();
                calc_en();
                etot = ekin1 + ekin2 + erot1 + erot2 + vdwen;
               

            }
            count++;

        }
         escale = energyscale / etot;
        if (count < 1000) {
            for (j = 0; j < innerloops; j++) {
                advance();
            }
            jLabel3.setText("time=" + df.format(totaltime));
        }
        
        draw();

        jPanel1.repaint();
        timer.restart();

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jLabel3 = new javax.swing.JLabel();
        jPanel2 = new javax.swing.JPanel();
        jLabel4 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jSlider2 = new javax.swing.JSlider();
        jSlider3 = new javax.swing.JSlider();
        jLabel5 = new javax.swing.JLabel();
        jSlider4 = new javax.swing.JSlider();
        jLabel8 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jSlider7 = new javax.swing.JSlider();
        jSlider8 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jLabel10 = new javax.swing.JLabel();
        jLabel11 = new javax.swing.JLabel();
        jLabel12 = new javax.swing.JLabel();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jSlider1 = new javax.swing.JSlider();
        jPanel3 = new myPanel2();
        jSlider5 = new javax.swing.JSlider();
        jLabel9 = new javax.swing.JLabel();
        jSlider6 = new javax.swing.JSlider();
        jLabel1 = new javax.swing.JLabel();

        jPanel1.setMaximumSize(new java.awt.Dimension(500, 250));
        jPanel1.setMinimumSize(new java.awt.Dimension(500, 250));
        jPanel1.setPreferredSize(new java.awt.Dimension(500, 250));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 500, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 250, Short.MAX_VALUE)
        );

        jLabel3.setText("jLabel1");

        jLabel4.setFont(new java.awt.Font("Courier", 1, 12)); // NOI18N
        jLabel4.setText("jLabel1");

        jLabel6.setFont(new java.awt.Font("Courier", 1, 12)); // NOI18N
        jLabel6.setText("jLabel6");

        jSlider2.setMajorTickSpacing(20);
        jSlider2.setMinimum(-100);
        jSlider2.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider2.setPaintTicks(true);
        jSlider2.setSnapToTicks(true);
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jSlider3.setMajorTickSpacing(20);
        jSlider3.setMinimum(-100);
        jSlider3.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider3.setPaintTicks(true);
        jSlider3.setSnapToTicks(true);
        jSlider3.setValue(0);
        jSlider3.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider3MouseDragged(evt);
            }
        });

        jLabel5.setText("angular momenta");

        jSlider4.setMajorTickSpacing(20);
        jSlider4.setMaximum(200);
        jSlider4.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider4.setPaintTicks(true);
        jSlider4.setSnapToTicks(true);
        jSlider4.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider4MouseDragged(evt);
            }
        });

        jLabel8.setText("velocity");

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("attractive forces on");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jSlider7.setMajorTickSpacing(20);
        jSlider7.setMinimum(-100);
        jSlider7.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider7.setPaintTicks(true);
        jSlider7.setSnapToTicks(true);
        jSlider7.setValue(0);
        jSlider7.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider7MouseDragged(evt);
            }
        });

        jSlider8.setMajorTickSpacing(20);
        jSlider8.setMinimum(-100);
        jSlider8.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider8.setPaintTicks(true);
        jSlider8.setSnapToTicks(true);
        jSlider8.setValue(0);
        jSlider8.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider8MouseDragged(evt);
            }
        });

        jLabel2.setText("Lz1");

        jLabel7.setText("Ly1");

        jLabel10.setText("Lz2");

        jLabel11.setText("Ly2");

        jLabel12.setText("vx1");

        jButton1.setText("start");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("prepare");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jLabel4, javax.swing.GroupLayout.PREFERRED_SIZE, 323, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel6)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(7, 7, 7)
                        .addComponent(jCheckBox1))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED))
                                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                                        .addComponent(jLabel2)
                                        .addGap(24, 24, 24)))
                                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addGroup(jPanel2Layout.createSequentialGroup()
                                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addGap(12, 12, 12)
                                                .addComponent(jLabel7))
                                            .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, 48, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addGap(12, 12, 12)
                                                .addComponent(jLabel10))
                                            .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jSlider8, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addGap(12, 12, 12)
                                                .addComponent(jLabel11)))
                                        .addGap(17, 17, 17)
                                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGroup(jPanel2Layout.createSequentialGroup()
                                                .addGap(12, 12, 12)
                                                .addComponent(jLabel12))))
                                    .addGroup(jPanel2Layout.createSequentialGroup()
                                        .addComponent(jButton1)
                                        .addGap(18, 18, 18)
                                        .addComponent(jButton2))))
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(jLabel5)
                                .addGap(54, 54, 54)
                                .addComponent(jLabel8)
                                .addGap(12, 12, 12)))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jSlider2, jSlider3, jSlider4, jSlider7, jSlider8});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(56, 56, 56)
                .addComponent(jLabel4)
                .addGap(26, 26, 26)
                .addComponent(jLabel6)
                .addGap(78, 78, 78)
                .addComponent(jCheckBox1)
                .addGap(46, 46, 46)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jSlider3, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider4, javax.swing.GroupLayout.PREFERRED_SIZE, 180, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider7, javax.swing.GroupLayout.PREFERRED_SIZE, 172, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider8, javax.swing.GroupLayout.PREFERRED_SIZE, 172, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel2)
                        .addComponent(jLabel10))
                    .addComponent(jLabel11)
                    .addComponent(jLabel12)
                    .addComponent(jLabel7))
                .addGap(60, 60, 60)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(jButton2))
                .addGap(55, 55, 55))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {jSlider2, jSlider3, jSlider7, jSlider8});

        jSlider1.setMinimum(-100);
        jSlider1.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider1.setValue(0);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jPanel3.setMaximumSize(new java.awt.Dimension(500, 250));
        jPanel3.setMinimumSize(new java.awt.Dimension(500, 250));
        jPanel3.setPreferredSize(new java.awt.Dimension(500, 250));

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 500, Short.MAX_VALUE)
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 250, Short.MAX_VALUE)
        );

        jSlider5.setMajorTickSpacing(10);
        jSlider5.setMinimum(5);
        jSlider5.setPaintTicks(true);
        jSlider5.setSnapToTicks(true);
        jSlider5.setValue(20);
        jSlider5.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider5MouseDragged(evt);
            }
        });

        jLabel9.setText("timescale");

        jSlider6.setMaximum(200);
        jSlider6.setOrientation(javax.swing.JSlider.VERTICAL);
        jSlider6.setValue(100);
        jSlider6.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider6MouseDragged(evt);
            }
        });

        jLabel1.setText("energy   red=translation   blue=rotation   green=potential   black=total");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jLabel1, javax.swing.GroupLayout.Alignment.TRAILING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(26, 26, 26)
                        .addComponent(jLabel9)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, 146, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(0, 0, Short.MAX_VALUE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 311, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(411, 411, 411))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(jLabel1))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(20, 20, 20)
                                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(61, 61, 61)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(jSlider6, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider5, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel9)
                            .addComponent(jLabel3))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 51, Short.MAX_VALUE)))
                .addGap(253, 253, 253))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        int i, j;

        {
            simulating = true;

            reset();
            timer.restart();


            draw();

        }
    // jPanel1.repaint();
    // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged


        yoffset = jSlider1.getValue() * 0.1;
        {
            if (!simulating) {
                rcg[1][0] = yoffset;
                labcoords();
                draw();
            }
        }
    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged

        inimom1 = jSlider2.getValue() * 0.2;
        if (!simulating) {

            angmom[2][0] = inimom1;
        }

// TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jSlider3MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider3MouseDragged
        inimom2 = jSlider3.getValue() * 0.2;
        if (!simulating) {

            angmom[2][1] = inimom2;
        }
    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider3MouseDragged

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
        timer.stop();
        simulating = false;
        reset();
        vcg[0][0] = 0;
        timer.restart();// TODO add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jSlider4MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider4MouseDragged
        inivel = jSlider4.getValue() * 0.1; // TODO add your handling code here:
    }//GEN-LAST:event_jSlider4MouseDragged

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        attractive = jCheckBox1.isSelected();        // TODO add your handling code here:
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jSlider5MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider5MouseDragged
        timescale = jSlider5.getValue(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider5MouseDragged

    private void jSlider6MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider6MouseDragged
        energyscale = jSlider6.getValue();
        escale = energyscale / etot;
        draw();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider6MouseDragged

    private void jSlider7MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider7MouseDragged
      inimom1a=jSlider7.getValue()*0.2;
      angmom[0][0]=inimom1a;// TODO add your handling code here:
    }//GEN-LAST:event_jSlider7MouseDragged

    private void jSlider8MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider8MouseDragged
       inimom2a=jSlider8.getValue()*0.2;
       angmom[0][1]=inimom2a;// TODO add your handling code here:
    }//GEN-LAST:event_jSlider8MouseDragged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel10;
    private javax.swing.JLabel jLabel11;
    private javax.swing.JLabel jLabel12;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider jSlider3;
    private javax.swing.JSlider jSlider4;
    private javax.swing.JSlider jSlider5;
    private javax.swing.JSlider jSlider6;
    private javax.swing.JSlider jSlider7;
    private javax.swing.JSlider jSlider8;
    // End of variables declaration//GEN-END:variables
    void init_variables() {
        rcg = new double[3][nmols];
        vcg = new double[3][nmols];
        ombod = new double[3][nmols];
        omega = new double[3][nmols];
        omega_ad = new double[3][nmols];

        angmom = new double[3][nmols];
        inertia = new double[3][nmols];
        rlab = new double[3][natoms];
        rbod = new double[3][natoms];
        force = new double[3][nmols];
        torque = new double[3][nmols];

        quat = new double[4][nmols];
        amat = new double[3][3][nmols];

        dr = new double[3];
        fij = new double[3];
        nat = new int[natoms];


        mass = new double[nmols];
        image =
                new BufferedImage(500, 250, BufferedImage.TYPE_INT_RGB);

        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 500, 250);

        imagea =
                new BufferedImage(500, 250, BufferedImage.TYPE_INT_RGB);

        gba = (Graphics2D) imagea.createGraphics();
        gba.setBackground(Color.white);
        gba.clearRect(0, 0, 500, 250);




        timer = new Timer(1, this);
        df = new DecimalFormat("+0.000000;-0.000000");
        df1 = new DecimalFormat("+0.00000000;-0.00000000");

        values = new double[5][500];
    }

    void reset() {
        int i;
        double qnorm1, qnorm2;

        tsf = tstep * 1.E-14 / 1.66E-27;
        if (simulating) {
            inivel = jSlider4.getValue() * 0.1;
        }
        inimom1 = jSlider2.getValue() * 0.2;
        inimom2 = jSlider3.getValue() * 0.2;
        nat[0] = 6;
        nat[1] = 1;
        nat[2] = 1;
        nat[3] = 1;
        nat[4] = 1;

        nat[5] = 6;
        nat[6] = 1;
        nat[7] = 1;
        nat[8] = 1;
        nat[9] = 1;


        rcg[0][0] = -5.0;
        rcg[1][0] = yoffset;
        rcg[2][0] = 0.0;
        rcg[0][1] = 7.0;
        rcg[1][1] = 0.0;
        rcg[2][1] = 0.0;

        vcg[0][0] = inivel;
        vcg[1][0] = 0.0;
        vcg[2][0] = 0.0;
        vcg[0][1] = 0.0;
        vcg[1][1] = 0.0;
        vcg[2][1] = 0.0;

        inertia[0][0] = 3.15;
        inertia[1][0] = 3.15;
        inertia[2][0] = 3.15;
        inertia[0][1] = 3.15;
        inertia[1][1] = 3.15;
        inertia[2][1] = 3.15;

        rbod[0][0] = 0.0;
        rbod[1][0] = 0.0;
        rbod[2][0] = 0.0;
        rbod[0][1] = -0.848;
        rbod[1][1] = 0.396;
        rbod[2][1] = -0.544;
        rbod[0][2] = -0.217;
        rbod[1][2] = 0.009;
        rbod[2][2] = 1.060;
        rbod[0][3] = 0.872;
        rbod[1][3] = 0.611;
        rbod[2][3] = -0.195;
        rbod[0][4] = 0.192;
        rbod[1][4] = -1.016;
        rbod[2][4] = -0.320;

        rbod[0][5] = 0.0;
        rbod[1][5] = 0.0;
        rbod[2][5] = 0.0;
        rbod[0][6] = 0.848;
        rbod[1][6] = 0.396;
        rbod[2][6] = -0.544;
        rbod[0][7] = 0.217;
        rbod[1][7] = 0.009;
        rbod[2][7] = 1.060;
        rbod[0][8] = -0.872;
        rbod[1][8] = 0.611;
        rbod[2][8] = -0.195;
        rbod[0][9] = -0.192;
        rbod[1][9] = -1.016;
        rbod[2][9] = -0.320;

        quat[0][0] = 0.0243;
        quat[1][0] = -0.3578;
        quat[2][0] = 0.6899;
        quat[3][0] = 0.6182;

        quat[0][1] = 0.0243;
        quat[1][1] = -0.3578;
        quat[2][1] = -0.6899;
        quat[3][1] = -0.6182;

        mass[0] = 16.0;
        mass[1] = 16.0;

        angmom[0][0] = inimom1a;
        angmom[1][0] = 0;
        angmom[2][0] = inimom1;
        angmom[0][1] = inimom2a;
        angmom[1][1] = 0;
        angmom[2][1] = inimom2;




        qnorm1 = 0;
        qnorm2 = 0;
        for (i = 0; i < 4; i++) {
            qnorm1 += (quat[i][0] * quat[i][0]);
            qnorm2 += (quat[i][1] * quat[i][1]);

        }
        for (i = 0; i < 4; i++) {
            quat[i][0] = quat[i][0] / Math.sqrt(qnorm1);
            quat[i][1] = quat[i][1] / Math.sqrt(qnorm2);
        }
        newmatrix(0);
        newmatrix(1);
        labcoords();
        calc_forces();

        count = 0;

        prepare();
        draw();

        totaltime = 0;

        timer.setInitialDelay(10);
        timer.start();

    }

    double vdwedat(int atype) {
        double ve;
        if (atype == 1) {
            ve = 8.6 * 1.38E-23;
        } else {
            ve = 51.2 * 1.38E-23;
        }
        return ve;

    }

    double vdwsdat(int atype) {
        double vs;
        if (atype == 1) {
            vs = 2.81;
        } else {
            vs = 3.35;
        }
        return vs;

    }

    void calc_forces() {
        int i, j, k;
        double d2, vdwe, vdws, d6, d8, d14, fac, f6, f12;


        for (k = 0; k < 3; k++) {
            force[k][0] = 0;
            force[k][1] = 0;
            torque[k][0] = 0;
            torque[k][1] = 0;

        }
        for (i = 0; i < natoms1; i++) {
            for (j = natoms1; j < natoms; j++) {

                for (k = 0; k < 3; k++) {

                    dr[k] = rlab[k][i] - rlab[k][j];
                    fij[k] = 0;
                }
                d2 = dr[0] * dr[0] + dr[1] * dr[1] + dr[2] * dr[2];

                vdwe = Math.sqrt(vdwedat(nat[i]) * vdwedat(nat[j]));
                vdws = 0.5 * (vdwsdat(nat[i]) + vdwsdat(nat[j]));

                d6 = d2 * d2 * d2;
                d8 = d6 * d2;
                d14 = d6 * d6 * d2;

                f12 = 1.E10 * 48.0 * vdwe * Math.pow(vdws, 12) / d14;
                fac = f12;
                if (attractive) {
                    f6 = -24.0E10 * vdwe * Math.pow(vdws, 6) / d8;
                    fac = fac + f6;
                }
                for (k = 0; k < 3; k++) {
                    force[k][0] += fac * dr[k];
                    force[k][1] -= fac * dr[k];
                    fij[k] = fac * dr[k];
                }

                for (k = 0; k < 3; k++) {
                    dr[k] = rlab[k][i] - rcg[k][0];
                }

                torque[0][0] += (dr[1] * fij[2] - dr[2] * fij[1]);
                torque[1][0] += (dr[2] * fij[0] - dr[0] * fij[2]);
                torque[2][0] += (dr[0] * fij[1] - dr[1] * fij[0]);

                for (k = 0; k < 3; k++) {
                    dr[k] = rlab[k][j] - rcg[k][1];



                }

                torque[0][1] -= (dr[1] * fij[2] - dr[2] * fij[1]);
                torque[1][1] -= (dr[2] * fij[0] - dr[0] * fij[2]);
                torque[2][1] -= (dr[0] * fij[1] - dr[1] * fij[0]);
            }
        }
    }

    void newmatrix(int im) {
        amat[0][0][im] = quat[0][im] * quat[0][im] + quat[1][im] * quat[1][im] - quat[2][im] * quat[2][im] - quat[3][im] * quat[3][im];
        amat[1][1][im] = quat[0][im] * quat[0][im] - quat[1][im] * quat[1][im] + quat[2][im] * quat[2][im] - quat[3][im] * quat[3][im];
        amat[2][2][im] = quat[0][im] * quat[0][im] - quat[1][im] * quat[1][im] - quat[2][im] * quat[2][im] + quat[3][im] * quat[3][im];
        amat[0][1][im] = 2. * (quat[1][im] * quat[2][im] + quat[0][im] * quat[3][im]);
        amat[1][0][im] = 2. * (quat[1][im] * quat[2][im] - quat[0][im] * quat[3][im]);


        amat[0][2][im] = 2. * (quat[1][im] * quat[3][im] - quat[0][im] * quat[2][im]);
        amat[2][0][im] = 2. * (quat[1][im] * quat[3][im] + quat[0][im] * quat[2][im]);

        amat[1][2][im] = 2. * (quat[2][im] * quat[3][im] + quat[0][im] * quat[1][im]);
        amat[2][1][im] = 2. * (quat[2][im] * quat[3][im] - quat[0][im] * quat[1][im]);
    }

    void labcoords() {
        double s;
        int i, j, ia;

        for (ia = 0; ia < natoms1; ia++) {
            for (i = 0; i < 3; i++) {
                s = 0;
                for (j = 0; j < 3; j++) {
                    s = s + amat[i][j][0] * rbod[j][ia];
                }
                rlab[i][ia] = rcg[i][0] + s;

            }
        }
        for (ia = natoms1; ia < natoms; ia++) {
            for (i = 0; i < 3; i++) {
                s = 0;
                for (j = 0; j < 3; j++) {
                    s = s + amat[i][j][1] * rbod[j][ia];
                }
                rlab[i][ia] = rcg[i][1] + s;

            }
        }


    }

    void draw() {
        int im, ia, ix, iy, iy1;
        int base = 150;
        double vs, vs1;
        int count1;
        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g;
        Graphics ga = jPanel3.getGraphics();
        Graphics2D g2a = (Graphics2D) ga;
        gb.setColor(Color.white);
        gb.clearRect(0, 0, 500, 250);
        gb.setColor(Color.black);


        for (ia = 0; ia < natoms; ia++) {
            ix = (int) (rlab[0][ia] * 10.0 + 100.0);
            iy = (int) (100.0 - rlab[1][ia] * 10.0);

            if ((ia == 4) || (ia == 9)) {
                gb.setColor(Color.red);
            } else {
                gb.setColor(Color.blue);
            }
            gb.drawOval(ix, iy, 10, 10);

        }

        gba.setColor(Color.white);
        gba.clearRect(0, 0, 500, 250);
        gba.setColor(Color.red);

        count1=Math.min(count,500);
        
        for (ix = 0; ix < count1 - 1; ix++) {
            iy = base - (int) (values[0][ix] * escale);
            iy1 = base - (int) (values[0][ix + 1] * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }
        for (ix = 0; ix < count1 - 1; ix++) {
            iy = base - (int) (values[1][ix] * escale);
            iy1 = base - (int) (values[1][ix + 1] * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }
        gba.setColor(Color.blue);

        for (ix = 0; ix < count1 - 1; ix++) {
            iy = base - (int) (values[2][ix] * escale);
            iy1 = base - (int) (values[2][ix + 1] * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }
        for (ix = 0; ix < count1 - 1; ix++) {
            iy = base - (int) (values[3][ix] * escale);
            iy1 = base - (int) (values[3][ix + 1] * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }
        gba.setColor(Color.green);

        for (ix = 0; ix < count1 - 1; ix++) {
            iy = base - (int) (values[4][ix] * escale);
            iy1 = base - (int) (values[4][ix + 1] * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }
        gba.setColor(Color.black);

        for (ix = 0; ix < count1 - 1; ix++) {
            vs = values[0][ix] + values[1][ix] + values[2][ix] + values[3][ix]+values[4][ix];
            vs1 = values[0][ix + 1] + values[1][ix + 1] + values[2][ix + 1] + values[3][ix + 1]+values[4][ix+1];
            iy = base - (int) (vs * escale);
            iy1 = base - (int) (vs1 * escale);
            gba.drawLine(ix, iy, ix + 1, iy1);
        }



        g2.drawImage(image, 0, 0, null);
        g2a.drawImage(imagea, 0, 0, null);


    }

    void rotate(int im) {
        double ombod2, fdiag, fndia, dq0, dq1, dq2, dq3;

        ombod2 = omega[0][im] * omega[0][im] + omega[1][im] * omega[1][im] + omega[2][im] * omega[2][im];
        ombod2 = ombod2 * tstep * tstep / 16.0;
        fdiag = (1. - ombod2) / (1. + ombod2);
        fndia = .5 * tstep / (1. + ombod2);


        dq0 = omega[0][im] * quat[1][im] + omega[1][im] * quat[2][im] + omega[2][im] * quat[3][im];
        dq0 = dq0 * fndia + quat[0][im] * fdiag;

        dq1 = -omega[0][im] * quat[0][im] + omega[2][im] * quat[2][im] - omega[1][im] * quat[3][im];
        dq1 = dq1 * fndia + quat[1][im] * fdiag;

        dq2 = -omega[1][im] * quat[0][im] - omega[2][im] * quat[1][im] + omega[0][im] * quat[3][im];
        dq2 = dq2 * fndia + quat[2][im] * fdiag;

        dq3 = -omega[2][im] * quat[0][im] + omega[1][im] * quat[1][im] - omega[0][im] * quat[2][im];
        dq3 = dq3 * fndia + quat[3][im] * fdiag;

        quat[0][im] = dq0;
        quat[1][im] = dq1;
        quat[2][im] = dq2;
        quat[3][im] = dq3;

    }

    void calc_angmom() {
        int im, ic;
        double s, xaob, yaob, zaob;
        //calculate angular velocity at t=0 and t=1/2
        for (im = 0; im < nmols; im++) {
            for (ic = 0; ic < 3; ic++) {
                ombod[ic][im] = (amat[0][ic][im] * angmom[0][im] + amat[1][ic][im] * angmom[1][im] + amat[2][ic][im] * angmom[2][im]) / inertia[ic][im];
            }
        }

        for (im = 0; im < nmols; im++) {
            xaob = angmom[0][im] * (amat[0][1][im] * ombod[2][im] - amat[0][2][im] * ombod[1][im]);
            xaob = xaob + angmom[1][im] * (amat[1][1][im] * ombod[2][im] - amat[1][2][im] * ombod[1][im]);
            xaob = xaob + angmom[2][im] * (amat[2][1][im] * ombod[2][im] - amat[2][2][im] * ombod[1][im]);
            xaob = xaob + amat[0][0][im] * torque[0][im] + amat[1][0][im] * torque[1][im] + amat[2][0][im] * torque[2][im];
            xaob = xaob / inertia[0][im];

            yaob = angmom[0][im] * (amat[0][0][im] * ombod[2][im] - amat[0][2][im] * ombod[0][im]);
            yaob = yaob + angmom[1][im] * (amat[1][0][im] * ombod[2][im] - amat[1][2][im] * ombod[0][im]);
            yaob = yaob + angmom[2][im] * (amat[2][0][im] * ombod[2][im] - amat[2][2][im] * ombod[0][im]);
            yaob = yaob + amat[0][1][im] * torque[0][im] + amat[1][1][im] * torque[1][im] + amat[2][1][im] * torque[2][im];
            yaob = -yaob / inertia[1][im];

            zaob = angmom[0][im] * (amat[0][0][im] * ombod[1][im] - amat[0][1][im] * ombod[0][im]);
            zaob = zaob + angmom[1][im] * (amat[1][0][im] * ombod[1][im] - amat[1][1][im] * ombod[0][im]);
            zaob = zaob + angmom[2][im] * (amat[2][0][im] * ombod[1][im] - amat[2][1][im] * ombod[0][im]);
            zaob = zaob + amat[0][2][im] * torque[0][im] + amat[1][2][im] * torque[1][im] + amat[2][2][im] * torque[2][im];
            zaob = zaob / inertia[2][im];

            omega[0][im] = ombod[0][im] + 0.5 * tstep * xaob;
            omega[1][im] = ombod[1][im] + 0.5 * tstep * yaob;
            omega[2][im] = ombod[2][im] + 0.5 * tstep * zaob;

        }

    }

    void prepare() {
        int im, ic;

        calc_forces();


        // calculate velocities at t=1/2
        for (im = 0; im < nmols; im++) {
            for (ic = 0; ic < 3; ic++) {
                vcg[ic][im] += force[ic][im] * 0.5 * tsf / mass[im];
            }
        }

        calc_angmom();

    }

    void calc_en() {
        int i, j, k;
        double d2, vdwe, vdws, d6, d8, d12, f12, f6, fac;


        ekin1 = vcg[0][0] * vcg[0][0] + vcg[1][0] * vcg[1][0] + vcg[2][0] * vcg[2][0];
        ekin1 = ekin1 * 0.5 * mass[0];

        ekin2 = vcg[0][1] * vcg[0][1] + vcg[1][1] * vcg[1][1] + vcg[2][1] * vcg[2][1];
        ekin2 = ekin2 * 0.5 * mass[1];

        erot1 = 0;
        erot2 = 0;
        for (i = 0; i < 3; i++) {
            erot1 = erot1 + ombod[i][0] * ombod[i][0] * inertia[i][0] * 0.5;
            erot2 = erot2 + ombod[i][1] * ombod[i][1] * inertia[i][1] * 0.5;
        }

        vdwen = 0.0;
        for (i = 0; i < natoms1; i++) {
            for (j = natoms1; j < natoms; j++) {

                for (k = 0; k < 3; k++) {

                    dr[k] = rlab[k][i] - rlab[k][j];
                    fij[k] = 0;
                }
                d2 = dr[0] * dr[0] + dr[1] * dr[1] + dr[2] * dr[2];

                vdwe = Math.sqrt(vdwedat(nat[i]) * vdwedat(nat[j]));
                vdws = 0.5 * (vdwsdat(nat[i]) + vdwsdat(nat[j]));

                d6 = d2 * d2 * d2;
                d12 = d6 * d6;


                f12 = 4.0 * vdwe * Math.pow(vdws, 12) / d12;
                fac = f12;
                if (attractive) {
                    f6 = -4.0 * vdwe * Math.pow(vdws, 6) / d6;
                    fac = fac + f6;
                }
                vdwen = vdwen + fac;

            }
        }

        vdwen = vdwen / 1.66E-23;

    }

    void advance() {
        int im, ic;
        double dribx, driby, dribz;


        totaltime += tstep;

        drtx = 0;
        drty = 0;
        drtz = 0;


        for (im = 0; im < nmols; im++) {
            //advance coordinates
            for (ic = 0; ic < 3; ic++) {
                rcg[ic][im] += (vcg[ic][im] * tstep);
            }


            rotate(im);
            newmatrix(im);

        }
        labcoords();

        //calculate new forces at t=1
        calc_forces();
        //further advance velocities
        for (im = 0; im < nmols; im++) {
            for (ic = 0; ic < 3; ic++) {
                vcg[ic][im] += force[ic][im] * 0.5 * tsf / mass[im];
            }
        }

        calc_en();
        jLabel6.setText("Energy=" + df1.format(erot1 + erot2 + ekin1 + ekin2 + vdwen));


        //advance angular momenta
        for (im = 0; im < nmols; im++) {
            for (ic = 0; ic < 3; ic++) {
                angmom[ic][im] = angmom[ic][im] + (torque[ic][im] * tsf);
            }

            // calculate total angular momentum
            drtx = drtx + mass[im] * (rcg[1][im] * vcg[2][im] - rcg[2][im] * vcg[1][im]);
            drty = drty + mass[im] * (rcg[2][im] * vcg[0][im] - rcg[0][im] * vcg[2][im]);
            drtz = drtz + mass[im] * (rcg[0][im] * vcg[1][im] - rcg[1][im] * vcg[0][im]);

            zz = rcg[1][im] * vcg[0][im];

        }

        // now calculate  the angular velocities at time t and (t+dt)
        calc_angmom();

        // calculate velocities at t=1/2
        for (im = 0; im < nmols; im++) {
            for (ic = 0; ic < 3; ic++) {
                vcg[ic][im] += force[ic][im] * 0.5 * tsf / mass[im];
            }

        }


        jLabel4.setText("ang mom " + df.format(angmom[0][0] + angmom[0][1] + drtx) + " " + df.format(angmom[1][0] + angmom[1][1] + drty) + " " + df.format(angmom[2][0] + angmom[2][1] + drtz));


        if (count < 500) {

            values[0][count] = ekin1;
            values[1][count] = ekin2;
            values[2][count] = erot1;
            values[3][count] = erot2;
            values[4][count] = vdwen;

        }
    }

    public class myPanel extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(g);


            g2.drawImage(image, 0, 0, null);



        }
    }

    public class myPanel2 extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, i, j;

            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            super.paintComponent(g);
            g2.drawImage(imagea, 0, 0, null);

        }
    }
    }
