package numericalprec;

import javax.swing.SwingUtilities;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.BorderFactory;
import java.awt.Color;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;import java.text.*;
/*
 * NewJApplet.java
 *
 * Created on Sep 24, 2009, 5:09:25 PM
 */

// package numericalprec;
/**
 *
 * @author root
 */
public class NewJApplet extends javax.swing.JApplet {

    int iyex[], iyap[], ival[];
    int ntaylor = 10;
    int showerr=0;
    DecimalFormat df;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        iyex = new int[300];
        iyap = new int[300];
        ival = new int[300];
        DecimalFormatSymbols unusualSymbols =
                new DecimalFormatSymbols();

        unusualSymbols.setDecimalSeparator('.');

        df = new DecimalFormat("0.###E0", unusualSymbols);
        jSlider1.setValue(10);
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        jPanel1 = new myPanel();
        jSlider1 = new javax.swing.JSlider();
        jRadioButton1 = new javax.swing.JRadioButton();
        jRadioButton2 = new javax.swing.JRadioButton();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 382, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 256, Short.MAX_VALUE)
        );

        jSlider1.setMajorTickSpacing(2);
        jSlider1.setMaximum(24);
        jSlider1.setPaintLabels(true);
        jSlider1.setPaintTicks(true);
        jSlider1.setSnapToTicks(true);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        buttonGroup1.add(jRadioButton1);
        jRadioButton1.setSelected(true);
        jRadioButton1.setText("value");
        jRadioButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton1ActionPerformed(evt);
            }
        });

        buttonGroup1.add(jRadioButton2);
        jRadioButton2.setText("error");
        jRadioButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jRadioButton2ActionPerformed(evt);
            }
        });

        jLabel2.setText("order N");

        jLabel1.setText("jLabel1");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 334, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(layout.createSequentialGroup()
                                        .addContainerGap()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jRadioButton2)
                                                .addGap(18, 18, 18)
                                                .addComponent(jRadioButton1)))))
                                .addGap(4, 4, 4))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(131, 131, 131)
                                .addComponent(jLabel2)))
                        .addGap(0, 0, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, 742, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(8, 8, 8)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(24, 24, 24)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(36, 36, 36)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jRadioButton2)
                    .addComponent(jRadioButton1))
                .addContainerGap(118, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        ntaylor = jSlider1.getValue();
        
        jPanel1.repaint();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jRadioButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton1ActionPerformed
        if(jRadioButton1.isSelected()) showerr=0;
        jPanel1.repaint();
        
    }//GEN-LAST:event_jRadioButton1ActionPerformed

    private void jRadioButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jRadioButton2ActionPerformed
      if(jRadioButton2.isSelected()) showerr=1;
      jPanel1.repaint();
      
    }//GEN-LAST:event_jRadioButton2ActionPerformed

    double my_cos(double x, int nterms) {
        double cos = 1.0;
        double fact = 1.0;
        double sign = -1.0;
        double powx = 1.0;
        double i;
        double s;

       

        s = 1;
       

        x *= x;
        for (i = 2; i <= nterms; i += 2) {
            fact *= i * (i - 1);
            powx *= x;
            cos += sign * powx / fact;
            sign *= -1.0;
        }
        cos = cos * s;
        return cos;
    }
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JRadioButton jRadioButton1;
    private javax.swing.JRadioButton jRadioButton2;
    private javax.swing.JSlider jSlider1;
    // End of variables declaration//GEN-END:variables
    class myPanel extends javax.swing.JPanel {

        public void paintComponent(Graphics g) {
            int ix, iy, ix1, iy1, i2, i;
            double x, y, ya,maxerr,newerr;
            super.paintComponent(g);


            g.setColor(Color.black);
            g.drawLine(0, 100, 350, 100);
            for (i = 0; i < 7; i++) {
                ix = (int) (i * 150 / Math.PI) + 10;
                g.drawLine(ix, 95, ix, 105);
                g.drawString("" + i, ix - 2, 120);
            }

            maxerr=0.0;

            if(showerr==0)



            {

            for (i = 0; i < 300; i++) {
                x = (i-150) * 2 * Math.PI / 300;
                y = Math.cos(x);
                ya = my_cos(x, ntaylor);

                newerr=Math.abs(y-ya);
                if(newerr>maxerr) maxerr=newerr;


                iyex[i] = (int) (-y * 100 + 100);
                iyap[i] = (int) (-ya * 100 + 100);
                ival[i] = i + 10;


            }
            g.setColor(Color.blue);
            g.drawPolyline(ival, iyex, 300);
            g.drawString("blue=cos(x)",20,250);
            
            g.setColor(Color.red);
            g.drawPolyline(ival, iyap, 300);
            g.drawString("red=Taylor",100,250);
            
            
            
            jLabel1.setText(" max err   "+df.format(maxerr));

            }
            else
            {

            for (i = 0; i < 300; i++) {
                x = (i-150) * 2 * Math.PI / 300;
                y = Math.cos(x);
                ya = my_cos(x, ntaylor)-y;
                newerr=Math.abs(ya);
                if(newerr>maxerr) maxerr=newerr;

               


            }

            for (i = 0; i < 300; i++) {
                x = (i-150) * 2 * Math.PI / 300;
                y = Math.cos(x);
                ya = my_cos(x, ntaylor)-y;
                ya=ya/maxerr;

                iyap[i] = (int) (-ya * 100 + 100);
                ival[i] = i + 10;


            }



            g.setColor(Color.black); 
            g.drawPolyline(ival, iyap, 300);
            jLabel1.setText(" max err   "+df.format(maxerr));
            g.drawString("difference",20,250);


            }


        }
    }
}
