/*
 * NewJApplet.java
 *
 * Created on April 3, 2008, 6:28 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet
        implements ActionListener {

    int nmax = 5000;
    DecimalFormat df, df1;
    Timer timer;
    Graphics2D gb, gb2;
    BufferedImage image;
    BufferedImage image2;
    double r2, r, x, y, vx, vy, dx, dy, dvx, dvy, ekin, epot, angm, time_now;
    double fx, fy, xest, yest, vxest, vyest;
    double xh, yh, vxh, vyh, axh, ayh, ax, ay, vx0, vy0, dvx1, dvy1;
    int i, j, k, l, m, n, outer_loop, count;
    double TSTEP = 0.01;
    int innersteps = 10;
    double[] etot;
    double[] times;
    double[] k1, k2, k3, k4, delta;
    double emin, emax, tmax, esum, denom;
    int selector = 0;
    int esel = 0;
    boolean exactstart = false;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }

        count = 0;
        reset();
        init_variables();

        timer = new Timer(10, this);
        timer.setInitialDelay(10);
        timer.start();

    }

    public void actionPerformed(ActionEvent e) {

        if ((count > nmax)) {
            return;
        }

        iterate();
        //draw();
        timer.setInitialDelay(10);
        timer.setDelay(10);
        timer.restart();

    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jPanel2 = new myPanel2();
        jPanel3 = new javax.swing.JPanel();
        jComboBox1 = new javax.swing.JComboBox();
        jButton1 = new javax.swing.JButton();
        jTextField1 = new javax.swing.JTextField();
        jLabel1 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jSlider1 = new javax.swing.JSlider();
        jLabel3 = new javax.swing.JLabel();
        jCheckBox1 = new javax.swing.JCheckBox();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();
        jLabel6 = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox();
        jTextField2 = new javax.swing.JTextField();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setMaximumSize(new java.awt.Dimension(300, 300));
        jPanel1.setMinimumSize(new java.awt.Dimension(300, 300));
        jPanel1.setPreferredSize(new java.awt.Dimension(300, 300));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 298, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 298, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setMaximumSize(new java.awt.Dimension(300, 200));
        jPanel2.setMinimumSize(new java.awt.Dimension(300, 200));
        jPanel2.setPreferredSize(new java.awt.Dimension(300, 200));

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 0, Short.MAX_VALUE)
        );
        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 198, Short.MAX_VALUE)
        );

        jPanel3.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel3.setMaximumSize(new java.awt.Dimension(150, 550));
        jPanel3.setMinimumSize(new java.awt.Dimension(150, 550));
        jPanel3.setPreferredSize(new java.awt.Dimension(150, 550));

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "Euler", "RK2", "RK4", "Verlet", "LeapFrog" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        jButton1.setText("reset");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jTextField1.setText("jTextField1");
        jTextField1.setMinimumSize(new java.awt.Dimension(90, 18));
        jTextField1.setPreferredSize(new java.awt.Dimension(90, 18));
        jTextField1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jTextField1ActionPerformed(evt);
            }
        });

        jLabel1.setText("timestep");

        jLabel2.setText("animation speed");

        jSlider1.setMinimum(1);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jLabel3.setText("jLabel3");

        jCheckBox1.setText("exact start value");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });

        jLabel4.setText("jLabel4");

        jLabel5.setText("jLabel5");

        jLabel6.setText("jLabel6");

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "etot", "ekin", "epot" }));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel3Layout = new javax.swing.GroupLayout(jPanel3);
        jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(28, 28, 28)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, 93, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 136, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(53, 53, 53)
                        .addComponent(jLabel1))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(27, 27, 27)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jCheckBox1))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel4))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel3))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel5))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel6))
                    .addGroup(jPanel3Layout.createSequentialGroup()
                        .addGap(39, 39, 39)
                        .addGroup(jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel2)
                            .addComponent(jButton1))))
                .addContainerGap(57, Short.MAX_VALUE))
        );
        jPanel3Layout.setVerticalGroup(
            jPanel3Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel3Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jCheckBox1)
                .addGap(37, 37, 37)
                .addComponent(jLabel1)
                .addGap(18, 18, 18)
                .addComponent(jTextField1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(30, 30, 30)
                .addComponent(jButton1)
                .addGap(52, 52, 52)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 77, Short.MAX_VALUE)
                .addComponent(jLabel6)
                .addGap(18, 18, 18)
                .addComponent(jLabel5)
                .addGap(18, 18, 18)
                .addComponent(jLabel3)
                .addGap(18, 18, 18)
                .addComponent(jLabel4)
                .addContainerGap())
        );

        jTextField2.setText("jTextField2");
        jTextField2.setPreferredSize(new java.awt.Dimension(300, 22));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jTextField2, javax.swing.GroupLayout.PREFERRED_SIZE, 300, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, 223, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(314, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGap(24, 24, 24)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(2, 2, 2)
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jTextField2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap(21, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
        count = 0;
         TSTEP = Double.parseDouble(jTextField1.getText());
        reset();
        init_variables();
        timer.restart();
    // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jTextField1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jTextField1ActionPerformed
        TSTEP = Double.parseDouble(jTextField1.getText());
        
    // TODO add your handling code here:
    }//GEN-LAST:event_jTextField1ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        int i1;
        i1 = jSlider1.getValue();
        innersteps = i1 * i1;// TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        selector = (int) jComboBox1.getSelectedIndex();
        count = 0;
        reset();
        init_variables();// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        exactstart = jCheckBox1.isSelected();
    // TODO add your handling code here:
    }//GEN-LAST:event_jCheckBox1ActionPerformed

    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
        esel = (int) jComboBox2.getSelectedIndex();
        count = 0;
        reset();
        init_variables(); // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanel3;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JTextField jTextField1;
    private javax.swing.JTextField jTextField2;
    // End of variables declaration//GEN-END:variables
    void init_variables() {
        image =
                new BufferedImage(300, 300, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 300, 300);

        image2 =
                new BufferedImage(300, 200, BufferedImage.TYPE_INT_RGB);
        gb2 = (Graphics2D) image2.createGraphics();
        gb2.setBackground(Color.white);
        gb2.clearRect(0, 0, 300, 200);


        df = new DecimalFormat("##.00");
        df1 = new DecimalFormat("0.0000000E00");

        jTextField1.setText("" + TSTEP);
        jSlider1.setValue((int) Math.sqrt(innersteps));

        etot = new double[nmax];
        times = new double[nmax];
        k1 = new double[4];
        k2 = new double[4];
        k3 = new double[4];
        k4 = new double[4];
        delta = new double[4];


    }

    void reset() {
        x = 1.0;
        y = 0.0;

        vx = 0.0;
        vy = 1.0;

        time_now = 0.0;

        emin = 10.0;
        emax = -10.0;
        tmax = TSTEP;

    }

    void iterate() {
        int i, ix1, ix2, iy1, iy2;
        double xp, yp, p, p1, xp1, yp1;

        Graphics g = jPanel1.getGraphics();
        Graphics ga = jPanel2.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        Graphics2D g2a = (Graphics2D) ga;

        if (selector == 0) {
            Euler();
        }
        if (selector == 1) {
            RK2();
        }
        if (selector == 2) {
            RK4();
        }
        if (selector == 3) {
            Verlet();
        }
        if (selector == 4) {
            LeapFrog();
        }


        if (count < nmax) {
            esum = ekin + epot ;
            if (esel == 1) {
                etot[count] = ekin;
            }
            if (esel == 2) {
                etot[count] = epot;
            }
            if (esel == 0) {
                etot[count] = esum;
            }
            times[count] = time_now;


            if (etot[count] > emax) {
                emax = etot[count];
            }
            if (etot[count] < emin) {
                emin = etot[count];
            }

            tmax = time_now;
            count++;


        }
        gb.clearRect(0, 0, 300, 300);
        gb.setColor(Color.black);

        gb2.clearRect(0, 0, 300, 200);
        gb2.setColor(Color.black);


        for (i = 0; i < 359; i++) {
            p = Math.PI * i / 180.0;
            xp = Math.cos(p);
            yp = Math.sin(p);
            p1 = Math.PI * (i + 1) / 180.0;
            xp1 = Math.cos(p1);
            yp1 = Math.sin(p1);
            gb.drawLine(150 + (int) (xp * 100), 150 + (int) (yp * 100),
                    150 + (int) (xp1 * 100), 150 + (int) (yp1 * 100));

        }
        gb.setColor(Color.red);
        xp = Math.cos(time_now);
        yp = Math.sin(time_now);
        gb.drawOval(147 + (int) (xp * 100), 147 + (int) (yp * 100), 6, 6);
        gb.setColor(Color.blue);
        gb.drawOval(147 + (int) (x * 100), 147 + (int) (y * 100), 6, 6);
        g2.drawImage(image, 0, 0, null);

        denom = emax - emin;
        if (denom < 1.0E-14) {
            denom = 1.0E-14;
        }

        for (i = 0; i < count - 1; i++) {
            ix1 = (int) (300 * times[i] / tmax);
            ix2 = (int) (300 * times[i + 1] / tmax);
            iy1 = (int) (200 * (emax - etot[i]) / denom);
            iy2 = (int) (200 * (emax - etot[i + 1]) / denom);
            gb2.drawLine(ix1, iy1, ix2, iy2);
        }
        //gb2.setColor(Color.red);
        //gb2.drawLine(0, (int) (200 * emax / denom), 300, (int) (200 * emax / denom));
        jTextField2.setText("range=" + df1.format(emax - emin) + "\n aver=" + df1.format((emin + emax) * 0.5));
        jLabel4.setText("Energy=" + df1.format(esum));
        jLabel5.setText("kinetic=" + df1.format(ekin));
        jLabel6.setText("potential=" + df1.format(epot));
        gb2.drawImage(image2, 0, 0, null);

        jPanel2.repaint();
        jLabel3.setText("time=" + df.format(time_now));

    }

    void Euler() {





        for (i = 0; i < innersteps; i++) {

            time_now += TSTEP;

            r2 = (x * x + y * y);
            r = Math.sqrt(r2);

            dx = vx * TSTEP;
            dy = vy * TSTEP;

            dvx = -TSTEP * x / (r * r2);
            dvy = -TSTEP * y / (r * r2);


            /* simple Euler Method */

            x = x + dx;
            y = y + dy;
            vx = vx + dvx;
            vy = vy + dvy;
        }


        ekin = 0.5 * (vx * vx + vy * vy);
        epot = -1.0 / Math.sqrt(x * x + y * y);
        angm = x * vy - y * vx;


    }

    void RK2() {




        for (i = 0; i < innersteps; i++) {
            time_now += TSTEP;

            /* Runge Kutta 2nd order Method */


            /* estimate midstep coordinates and velocities*/
            /* (predictor step) */


            xh = x + 0.5 * TSTEP * vx;
            yh = y + 0.5 * TSTEP * vy;

            r2 = (x * x + y * y);
            r = Math.sqrt(r2);
            vxh = vx - 0.5 * TSTEP * x / (r * r2);
            vyh = vy - 0.5 * TSTEP * y / (r * r2);

            /* corrector step: advance coordinates and velocities */

            dx = TSTEP * vxh;
            dy = TSTEP * vyh;

            r2 = (xh * xh + yh * yh);
            r = Math.sqrt(r2);
            axh = -xh / (r * r2);
            ayh = -yh / (r * r2);

            dvx = TSTEP * axh;
            dvy = TSTEP * ayh;

            x = x + dx;
            y = y + dy;
            vx = vx + dvx;
            vy = vy + dvy;


        }




        ekin = 0.5 * (vx * vx + vy * vy);
        epot = -1.0 / Math.sqrt(x * x + y * y);
        angm = x * vy - y * vx;






    }

    void forces(double x, double y) {
        double r, r2;


        r2 = (x * x + y * y);
        r = Math.sqrt(r2);
        fx = -x / (r * r2);
        fy = -y / (r * r2);
    }

    void RK4() {

        for (i = 0; i < innersteps; i++) {

            time_now = time_now + TSTEP;

            /* Runge Kutta 4th  order Method */



            forces(x, y);

            k1[0] = TSTEP * vx;
            k1[1] = TSTEP * vy;
            k1[2] = TSTEP * fx;
            k1[3] = TSTEP * fy;

            /* estimate midstep coordinates */

            xh = x + 0.5 * k1[0];
            yh = y + 0.5 * k1[1];
            vxh = vx + 0.5 * k1[2];
            vyh = vy + 0.5 * k1[3];

            forces(xh, yh);

            k2[0] = TSTEP * vxh;
            k2[1] = TSTEP * vyh;
            k2[2] = TSTEP * fx;
            k2[3] = TSTEP * fy;


            /* improve midstep */

            xh = x + 0.5 * k2[0];
            yh = y + 0.5 * k2[1];
            vxh = vx + 0.5 * k2[2];
            vyh = vy + 0.5 * k2[3];

            forces(xh, yh);

            k3[0] = TSTEP * vxh;
            k3[1] = TSTEP * vyh;
            k3[2] = TSTEP * fx;
            k3[3] = TSTEP * fy;


            /* estimate final coordinates */

            xest = x + k3[0];
            yest = y + k3[1];
            vxest = vx + k3[2];
            vyest = vy + k3[3];

            forces(xest, yest);

            k4[0] = TSTEP * vxest;
            k4[1] = TSTEP * vyest;
            k4[2] = TSTEP * fx;
            k4[3] = TSTEP * fy;



            /* simpsons rule for integration */

            for (j = 0; j < 4; j++) {
                delta[j] = (k1[j] + 2.0 * k2[j] + 2.0 * k3[j] + k4[j]) / 6.0;
            }



            x = x + delta[0];
            y = y + delta[1];
            vx = vx + delta[2];
            vy = vy + delta[3];


        }
        ekin = 0.5 * (vx * vx + vy * vy);
        epot = -1.0 / Math.sqrt(x * x + y * y);
        angm = x * vy - y * vx;



    }

    void Verlet() {

        /* estimate x at - dt */

        if (time_now == 0.0) {

            if (exactstart) {



                xh = Math.cos(-TSTEP);
                yh = Math.sin(-TSTEP);
            } else {

                r2 = (x * x + y * y);
                r = Math.sqrt(r2);


                ax = -x / (r * r2);
                ay = -y / (r * r2);

                xh = x - TSTEP * vx + .5 * TSTEP * TSTEP * ax;
                yh = y - TSTEP * vy + .5 * TSTEP * TSTEP * ay;
            }

        }

        for (i = 0; i < innersteps; i++) {

            /* Verlet Method */


            time_now += TSTEP;

            r2 = (x * x + y * y);
            r = Math.sqrt(r2);


            dvx = -TSTEP * x / (r * r2);
            dvy = -TSTEP * y / (r * r2);



            dx = x - xh + dvx * TSTEP;
            dy = y - yh + dvy * TSTEP;


            vx = 0.5 * dvx + (x - xh) / TSTEP;
            vy = 0.5 * dvy + (y - yh) / TSTEP;
            xh = x;
            yh = y;

            x = x + dx;
            y = y + dy;
        }





        ekin = 0.5 * (vx * vx + vy * vy);
        epot = -1.0 / Math.sqrt(xh * xh + yh * yh);
        angm = xh * vy - yh * vx;



    }

    void LeapFrog() {
        double ek, ep;
        if (time_now == 0.0) {

            if (exactstart) {

                vx = -Math.sin(-0.5 * TSTEP);
                vy = Math.cos(-0.5 * TSTEP);


            } else {
                /* estimate v at -1/2 dt */
                r2 = (x * x + y * y);
                r = Math.sqrt(r2);

                dvx = 0.5 * TSTEP * x / (r * r2);
                dvy = 0.5 * TSTEP * y / (r * r2);
                vx = vx + dvx;
                vy = vy + dvy;
            }

        }


        for (i = 0; i < innersteps; i++) {

            /* Leap Frog Method */
            /* velocities are now at (n+1/2) dt */

            time_now += TSTEP;

            r2 = (x * x + y * y);
            r = Math.sqrt(r2);


            dvx = -TSTEP * x / (r * r2);
            dvy = -TSTEP * y / (r * r2);
            vx = vx + dvx;
            vy = vy + dvy;



            dx = vx * TSTEP;
            dy = vy * TSTEP;
            x = x + dx;
            y = y + dy;
        }

        dvx1 = -TSTEP * x / (r * r2);
        dvy1 = -TSTEP * y / (r * r2);


        //vx0 = vx + 0.375 * dvx1+0.125*dvx;
        //vy0 = vy + 0.375 * dvy1+0.125*dvy;

        vx0 = vx + 0.5 * dvx1;
        vy0 = vy + 0.5 * dvy1;

        ekin = 0.5 * (vx0 * vx0 + vy0 * vy0);
        epot = -1.0 / Math.sqrt(x * x + y * y);

        esum = epot + ekin;

        angm = x * vy0 - y * vx0;




    }

    public class myPanel extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(g);

            g2.drawImage(image, 0, 0, null);




        }
    }

    public class myPanel2 extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics ga) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2a = (Graphics2D) ga;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(ga);

            g2a.drawImage(image2, 0, 0, null);



        }
    }
}
