/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;


/**
 *
 * @author  root
 */
public class NewJApplet extends javax.swing.JApplet {
    
    double [] RealC,ImagC,RealC2,ImagC2,RealC3,ImagC3,RealC4,ImagC4;
    double [] RealF1,ImagF1,RealF2,ImagF2,RealF3,ImagF3,RealF4,ImagF4;
    int nstates=3;
    double V12=1.0;
    double V23=0.0;
    double V13=0.0;
    double E1=0.0;
    double E2=0.0;
    double E3=0.0;
    double tstep=0.001;
    double freq=0.0;
    
    boolean locked=false;
    
    DecimalFormat df;
    
    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {
                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        
        RealC = new double[nstates];
        ImagC = new double[nstates];
        RealC2 = new double[nstates];
        ImagC2 = new double[nstates];
        RealC3 = new double[nstates];
        ImagC3 = new double[nstates];        
        RealC4 = new double[nstates];
        ImagC4 = new double[nstates];
        RealF1 = new double[nstates];
        ImagF1 = new double[nstates];        
        RealF2 = new double[nstates];
        ImagF2 = new double[nstates];
        RealF3 = new double[nstates];
        ImagF3 = new double[nstates];        
        RealF4 = new double[nstates];
        ImagF4 = new double[nstates];
        
        df= new DecimalFormat("##0.0");
        
        V12Slider.setValue((int)(V12*20.0));
        V23Slider.setValue((int)(V23*20.0));
        V13Slider.setValue((int)(V13*20.0));
        
        E1Slider.setValue((int)(E1*20.0));
        E2Slider.setValue((int)(E2*20.0));
        E3Slider.setValue((int)(E3*20.0));
         
        V12Label.setText("V12="+df.format(V12));
        V23Label.setText("V23="+df.format(V23));
        V13Label.setText("V13="+df.format(V13));
        
        E1Label.setText("E1="+df.format(E1));
        E2Label.setText("E2="+df.format(E2));
        E3Label.setText("E3="+df.format(E3));
        
        lockButton.setSelected(false);
        
    }
    
    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        V23Slider = new javax.swing.JSlider();
        E1Slider = new javax.swing.JSlider();
        V12Label = new javax.swing.JLabel();
        E1Label = new javax.swing.JLabel();
        V12Slider = new javax.swing.JSlider();
        V23Label = new javax.swing.JLabel();
        V13Slider = new javax.swing.JSlider();
        V13Label = new javax.swing.JLabel();
        E2Slider = new javax.swing.JSlider();
        E3Slider = new javax.swing.JSlider();
        E2Label = new javax.swing.JLabel();
        E3Label = new javax.swing.JLabel();
        lockButton = new javax.swing.JToggleButton();
        jLabel1 = new javax.swing.JLabel();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 420, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 365, Short.MAX_VALUE)
        );

        V23Slider.setToolTipText("coupling V23");
        V23Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                V23SliderMouseDragged(evt);
            }
        });

        E1Slider.setToolTipText("initial state energy");
        E1Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                E1SliderMouseDragged(evt);
            }
        });

        V12Label.setText("V12");

        E1Label.setText("E1");

        V12Slider.setToolTipText("coupling V12 ");
        V12Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                V12SliderMouseDragged(evt);
            }
        });

        V23Label.setText("V23");

        V13Slider.setToolTipText("direct coupling V13");
        V13Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                V13SliderMouseDragged(evt);
            }
        });

        V13Label.setText("V13");

        E2Slider.setToolTipText("virtual state energy");
        E2Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                E2SliderMouseDragged(evt);
            }
        });

        E3Slider.setToolTipText("final state energy");
        E3Slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                E3SliderMouseDragged(evt);
            }
        });

        E2Label.setText("E2");

        E3Label.setText("E3");

        lockButton.setText("lock V12 V23");
        lockButton.setToolTipText("keep V12=V23");
        lockButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                lockButtonActionPerformed(evt);
            }
        });

        jLabel1.setText("occupation  of  initial state (blue)   intermediate state (green)   final state (red)");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                    .addComponent(V23Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(V13Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(E1Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(E2Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(E3Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addComponent(V12Slider, javax.swing.GroupLayout.PREFERRED_SIZE, 133, javax.swing.GroupLayout.PREFERRED_SIZE)
                                    .addGroup(layout.createSequentialGroup()
                                        .addGap(12, 12, 12)
                                        .addComponent(E3Label))
                                    .addComponent(lockButton, javax.swing.GroupLayout.PREFERRED_SIZE, 152, javax.swing.GroupLayout.PREFERRED_SIZE)))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(V13Label))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(12, 12, 12)
                                .addComponent(V23Label))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(E1Label))
                            .addGroup(layout.createSequentialGroup()
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                                .addComponent(E2Label))
                            .addGroup(layout.createSequentialGroup()
                                .addGap(12, 12, 12)
                                .addComponent(V12Label)))
                        .addContainerGap(41, Short.MAX_VALUE))))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(30, 30, 30)
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(lockButton, javax.swing.GroupLayout.PREFERRED_SIZE, 24, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(15, 15, 15)
                        .addComponent(V12Label)
                        .addGap(16, 16, 16)
                        .addComponent(V12Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(V23Label)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(V23Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(V13Label)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(V13Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(53, 53, 53)
                        .addComponent(E1Label)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(E1Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(E2Label)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(E2Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(E3Label)
                        .addGap(12, 12, 12)
                        .addComponent(E3Slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel1)
                .addContainerGap(93, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void V23SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_V23SliderMouseDragged
        // TODO add your handling code here:
        V23=V23Slider.getValue()*0.05;
        V23Label.setText("V23="+df.format(V23));   
        if(locked){V12=V23; V12Label.setText("V12="+df.format(V23));
        V12Slider.setValue(V23Slider.getValue());}
        jPanel1.repaint();
}//GEN-LAST:event_V23SliderMouseDragged

    private void E1SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_E1SliderMouseDragged

         E1=E1Slider.getValue()*0.05;
         E1Label.setText("E1="+df.format(E1));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_E1SliderMouseDragged

    private void V12SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_V12SliderMouseDragged
         V12=V12Slider.getValue()*0.05;
         V12Label.setText("V12="+df.format(V12));
         if(locked){V23=V12; V23Label.setText("V23="+df.format(V12)); 
         V23Slider.setValue(V12Slider.getValue());}
         jPanel1.repaint();
        // TODO add your handling code here:
}//GEN-LAST:event_V12SliderMouseDragged

    private void V13SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_V13SliderMouseDragged
         V13=V13Slider.getValue()*0.05;
         V13Label.setText("V13="+df.format(V13));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_V13SliderMouseDragged

    private void E2SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_E2SliderMouseDragged
         E2=E2Slider.getValue()*0.05;
         E2Label.setText("E2="+df.format(E2));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_E2SliderMouseDragged

    private void E3SliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_E3SliderMouseDragged
         E3=E3Slider.getValue()*0.05;
         E1Label.setText("E3="+df.format(E3));
         jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_E3SliderMouseDragged

    private void lockButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_lockButtonActionPerformed
     locked=lockButton.isSelected();
     V23Slider.setValue(V12Slider.getValue());
     V23Label.setText("V23="+df.format(V12));
       
     
        // TODO add your handling code here:
    }//GEN-LAST:event_lockButtonActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel E1Label;
    private javax.swing.JSlider E1Slider;
    private javax.swing.JLabel E2Label;
    private javax.swing.JSlider E2Slider;
    private javax.swing.JLabel E3Label;
    private javax.swing.JSlider E3Slider;
    private javax.swing.JLabel V12Label;
    private javax.swing.JSlider V12Slider;
    private javax.swing.JLabel V13Label;
    private javax.swing.JSlider V13Slider;
    private javax.swing.JLabel V23Label;
    private javax.swing.JSlider V23Slider;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JToggleButton lockButton;
    // End of variables declaration//GEN-END:variables
    
    void grad(double[]RC,double[]IC,double[]RF,double[]IF,double t)
    {   double Vt;
        
        
    
        RF[0]=E1*IC[0]+V12*IC[1]+V13*IC[2];
        IF[0]=-E1*RC[0]-V12*RC[1]-V13*RC[2];

        RF[1]=E2*IC[1]+V12*IC[0]+V23*IC[2];
        IF[1]=-E2*RC[1]-V12*RC[0]-V23*RC[2];
    
        RF[2]=E3*IC[2]+V13*IC[0]+V23*IC[1];
        IF[2]=-E3*RC[2]-V13*RC[0]-V23*RC[1];
    }
    
    void advance(double[]RC,double[]IC,double[]RF,double[]IF,
                 double[]RC1,double[]IC1,double step)
    { int i;
    
      for(i=0;i<nstates;i++)
      {
      RC1[i]=RC[i]+RF[i]*step;
      IC1[i]=IC[i]+IF[i]*step;
      
      }
    
    }
    
    
    void rk4(double t)
    { int i;
    grad(RealC,ImagC,RealF1,ImagF1,t);
    advance(RealC,ImagC,RealF1,ImagF1,RealC2,ImagC2,tstep*0.5);
    grad(RealC2,ImagC2,RealF2,ImagF2,t+tstep*0.5);
    advance(RealC,ImagC,RealF2,ImagF2,RealC3,ImagC3,tstep*0.5);
    grad(RealC3,ImagC3,RealF3,ImagF3,t+tstep*0.5);
    advance(RealC,ImagC,RealF3,ImagF3,RealC4,ImagC4,tstep);
    grad(RealC4,ImagC4,RealF4,ImagF4,t+tstep);
    
    for(i=0;i<nstates;i++)
    {
    
    RealC[i]=RealC[i]+tstep*(RealF1[i]+2.0*RealF2[i]+2.0*RealF3[i]+RealF4[i])/6.0;
    ImagC[i]=ImagC[i]+tstep*(ImagF1[i]+2.0*ImagF2[i]+2.0*ImagF3[i]+ImagF4[i])/6.0;
    
    }
    
    }
    
    public class myPanel extends javax.swing.JPanel{
       
    int iy0,iy1,i,ix0,ix1,i1,iz0,iz1;
    void iterate()
    {
      
    }
 
    public void paintComponent(Graphics g)
{   double t;     
    
     super.paintComponent(g);  
     
     RealC[0]=1.0; ImagC[0]=0.0;

     for(i=1;i<nstates;i++){RealC[i]=0.0; ImagC[i]=0.0;}
     
     iy0=150;
     ix0=0;
     iz0=0;
     
     t=0.0;
     
     for (i=0;i<400;i++)
     {
     for(i1=0;i1<50;i1++)
     {t+=tstep;
     rk4(t);
     }
     g.setColor(Color.black);
     g.drawRect(0,50,400,250);
     
     iy1=(int) ( (RealC[0]*RealC[0]+ImagC[0]*ImagC[0])*250.0);
     ix1=(int) ( (RealC[1]*RealC[1]+ImagC[1]*ImagC[1])*250.0);
     iz1=(int) ( (RealC[2]*RealC[2]+ImagC[2]*ImagC[2])*250.0);
     
     g.setColor(Color.blue);
     g.drawLine(i, 300-iy0, i+1, 300-iy1);
     iy0=iy1;

     g.setColor(Color.red);
     g.drawLine(i, 300-ix0, i+1, 300-ix1);
     ix0=ix1;
     
     g.setColor(Color.green);
     g.drawLine(i, 300-iz0, i+1, 300-iz1);
     iz0=iz1;
     
     g.setColor(Color.black);
     g.drawString("time",200,320);
     
     
     
     }
     
}
     }
}
     
     
     
