/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.text.*;
import javax.swing.text.DefaultCaret;
import javax.swing.ScrollPaneConstants;
import java.awt.image.BufferedImage;

/*
 * NewJApplet.java
 *
 * Created on 14.03.2010, 17:36:50
 */

/**
 *
 * @author poj
 */
public class NewJApplet extends javax.swing.JApplet implements Runnable {

     volatile Thread calculatorThread;
    int funcsel = 0;
    int methsel=0;
    double x1;
    double x2;
    double eps = 1E-20;
    int nmax = 500;
    int nsteps = 0;
    int nplot = 250;
    int[] ixp, iyp;
    double[] xap, yap;
    //Timer timer; 
    Graphics2D gb;
    BufferedImage image;
    DecimalFormat df, df2, df3;
    

    /**
     * Initializes the applet NewJApplet
     */
    public void init() {

        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }
        stop();

        ixp = new int[nplot];
        iyp = new int[nplot];
        xap = new double[nmax];
        yap = new double[nmax];

        //timer = new Timer(100, this);
        df = new DecimalFormat("##0.00");
        df2 = new DecimalFormat("0.00E00");
        df3 = new DecimalFormat("#0.0000000000");
     
     
        x1 = jSlider1.getValue() * 0.04 - 2.0;
        x2 = jSlider2.getValue() * 0.04 - 2.0;

       //   x1 = 0.05;
       // x2 = 1.7;

       // x1 = -4;
       // x2 = 1.33333;
     
        jList1.setSelectedIndex(0);
        DefaultCaret caret = (DefaultCaret)jTextArea1.getCaret();
        caret.setUpdatePolicy(DefaultCaret.ALWAYS_UPDATE);
        jScrollPane2.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        
        image =
                new BufferedImage(510, 410, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 510, 410);
        
       

    }
     public void run() {
        int i;
        double x1_l,x2_l,eps_l;
        

        if (Thread.currentThread() == calculatorThread) {
        x1_l=x1;
        x2_l=x2;
        eps_l=eps;
        nsteps=0;
            draw_new();
            switch (methsel)
                    {
            
                case 0: bisection(x1_l,x2_l,eps_l); break;
                case 1: Dekker(x1_l,x2_l,eps_l); break;
                case 2: Brent(x1_l,x2_l,eps_l); break;
                case 3: Chandrupatla(x1_l,x2_l,eps_l); break;
                case 4: regulaf(x1_l,x2_l,eps_l); break;
                case 5: newton(x1_l,eps_l); break;
                default:break;
            
            
            
            }

            //waves();

        }
    }

    public void start() {
        if (calculatorThread == null) {
            calculatorThread = new Thread(this);
            calculatorThread.start();
        }
    }

    public void stop() {

        Thread tmpBlinker = calculatorThread;;
        calculatorThread = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        try {

            Thread.currentThread().sleep(100);
        } catch (InterruptedException ie) {
//If this thread was intrrupted by nother thread 
        }
    }

    public void actionPerformed(ActionEvent e) {


        //jPanel1.repaint();
        //timer.restart();




    }

    /**
     * This method is called from within the init() method to initialize the
     * form. WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jScrollPane1 = new javax.swing.JScrollPane();
        jList1 = new javax.swing.JList();
        jScrollPane2 = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jSlider1 = new javax.swing.JSlider();
        jSlider2 = new javax.swing.JSlider();
        jButton4 = new javax.swing.JButton();
        jButton5 = new javax.swing.JButton();
        jButton6 = new javax.swing.JButton();

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 510, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 404, Short.MAX_VALUE)
        );

        jList1.setModel(new javax.swing.AbstractListModel() {
            String[] strings = { "x-2", "x^2-2", "x^3-2", "x^4-2", "5*sin(5x)", "cos^2(2x)-x^2", "5*(sqrt(|x+2|)-1)", "exp(-x)*ln(x)", "(x-1)^3", "x^25" };
            public int getSize() { return strings.length; }
            public Object getElementAt(int i) { return strings[i]; }
        });
        jList1.setSelectionMode(javax.swing.ListSelectionModel.SINGLE_SELECTION);
        jList1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                jList1MouseClicked(evt);
            }
        });
        jScrollPane1.setViewportView(jList1);

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPane2.setViewportView(jTextArea1);

        jButton1.setText("bisection");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("reg f");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jButton3.setText("Newton");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jSlider1.setMaximum(110);
        jSlider1.setValue(0);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jSlider2.setMaximum(110);
        jSlider2.setValue(110);
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jButton4.setText("Dekker's");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        jButton5.setText("Brent");
        jButton5.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton5ActionPerformed(evt);
            }
        });

        jButton6.setText("Chandrupatla");
        jButton6.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton6ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 87, Short.MAX_VALUE)
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(30, 30, 30))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 7, Short.MAX_VALUE)))
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 149, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jButton1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton3, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton4, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton5, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jButton6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                    .addComponent(jScrollPane2, javax.swing.GroupLayout.PREFERRED_SIZE, 438, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(178, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jButton1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton4)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton5)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton6)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton2)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(jButton3))
                            .addComponent(jScrollPane1, javax.swing.GroupLayout.PREFERRED_SIZE, 184, javax.swing.GroupLayout.PREFERRED_SIZE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 301, Short.MAX_VALUE)))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void jList1MouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jList1MouseClicked
        funcsel = jList1.getMinSelectionIndex();
        //jTextArea1.append("funcsel" + funcsel + "\n");
        nsteps = 0;
        draw_new();
        
        jPanel1.repaint();
        // TODO add your handling code here:
    }//GEN-LAST:event_jList1MouseClicked

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        
        methsel=0; start();
        //bisection(x1, x2, eps);
        //jPanel1.repaint();
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed

        methsel=4;
        start();
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        x1 = jSlider1.getValue() * 0.04 - 2.0;
        draw_new();
        jPanel1.repaint();
        // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
        x2 = jSlider2.getValue() * 0.04 - 2.0;
        draw_new();
        jPanel1.repaint();
        // TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        methsel=5;
        start(); // TODO add your handling code here:
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
        methsel=1;
        start();  // TODO add your handling code here:
    }//GEN-LAST:event_jButton4ActionPerformed

    private void jButton5ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton5ActionPerformed
       methsel=2;
       start();;  // TODO add your handling code here:
    }//GEN-LAST:event_jButton5ActionPerformed

    private void jButton6ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton6ActionPerformed
       methsel=3;
      start();  // TODO add your handling code here:
    }//GEN-LAST:event_jButton6ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JButton jButton5;
    private javax.swing.JButton jButton6;
    private javax.swing.JList jList1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

   public double fun7 (double x){
   double rv;
   if(Math.abs(x)<3.8E-4) rv=0; else rv=x*Math.exp(-1/(x*x));
   return rv;
   
   }
   
   
   
   
    public double func(double x) {
        double rv;

        switch (funcsel) {
            case 0:
                rv=x-2.0;
                break;
            case 1:
                rv = x * x - 2.0;
                break;
            case 2:
                rv = x * x * x - 2.0;
                break;
            case 3:
                rv = x * x * x * x - 2.0;
                break;
            case 4:
                rv = 5 * Math.sin(5 * x);
                break;
            case 5:
                rv = Math.cos(2 * x) * Math.cos(2 * x) - x * x;
                break;
            case 6:
                rv = 5 * (Math.sqrt(Math.abs(x + 2)) - 1);
                break;
            case 7:
                rv = Math.exp(-x) * Math.log(x);
                break;
            case 8:
                rv = (x - 1) * (x - 1) * (x - 1);
                break;
            case 9:
                rv=Math.pow(x, 25);
                break;
        
            default:
                rv = 0;

        }
        //jTextArea1.append("value "+rv+"\n");
        return rv;
    }

    public double dfunc(double x) {
        double rv;

        switch (funcsel) {
            case 0:
                rv=1;
                break;
            case 1:
                rv = 2 * x;
                break;
            case 2:
                rv = 3 * x * x;
                break;
            case 3:
                rv = 4 * x * x * x;
                break;
            case 4:
                rv = 25 * Math.cos(5 * x);
                break;
            case 5:
                rv = -4 * Math.cos(2 * x) * Math.sin(2 * x) - 2 * x;
                break;
            case 6:
                rv = 2.5*Math.signum(x+2)/Math.sqrt(Math.abs(x+2));
                break;
            case 7:
                rv = Math.exp(-x)/x-Math.exp(-x) * Math.log(x);
                break;
            case 8:
                rv = 3* (x - 1) * (x - 1);
                break;
            case 9:
                rv=25*Math.pow(x,24);
                break;
            default:
                rv = 0;

        }
        //jTextArea1.append("value "+rv+"\n");
        return rv;
    }

    void newton(double x0, double eps) {


        double x1, f1, df1, y,xm1;
        int keep_iterating = 1;
        int found_it = 0;
        int ah, aw;
        

        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with Newton-Raphson method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());


        
        


        xap[0] = x0;
        yap[0] = func(x0);
        nsteps = 1;

        x1 = x0;
        xm1=x1+1.0;




        while ((keep_iterating == 1) && (found_it == 0)) {
            f1 = func(x1);
            df1 = dfunc(x1);

            if (Math.abs(x1-xm1) < 5E-16) {
                keep_iterating = 0;
                found_it = 1;
                jTextArea1.append(" no more change \n ");
            } else {

                if (Math.abs(df1) ==0) {
                    jTextArea1.append(" derivative too small \n");
                    keep_iterating = 0;
                } else {
                    xm1=x1;
                    x1 = x1 - f1 / df1;


                    f1 = func(x1);
                    jTextArea1.append("" + nsteps + "  " + x1 + "  " + f1 + "\n");

                    xap[nsteps] = x1;
                    yap[nsteps] = f1;
                    
                    

                    nsteps += 1;

                    if (nsteps > 200) {
                        jTextArea1.append(" too many iterations \n");
                        keep_iterating = 0;
                    }

                }
            }
            draw_points();
            
        }
        if (found_it == 1) {
            y = func(x1);
            jTextArea1.append(" solution after " + nsteps + " steps  is " + df3.format(x1) + "  f=" + df2.format(y) + "\n");
        }
        stop();

    }

    void regulaf(double x1, double x2, double eps) {

        
        double x, f1, f2, y, xold;
        int keep_iterating = 1;
        int found_it = 0;
        int ah, aw;

        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with regula falsi method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());

        x = x1;

        nsteps = 2;

        f1 = func(x1);
        f2 = func(x2);

        xap[0] = x1;
        yap[0] = f1;
        xap[1] = x2;
        yap[1] = f2;

        if ((f1 * f2) >= 0) {
            jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + " \n");
            nsteps=0;
        } else {


            while ((keep_iterating == 1) && (found_it == 0)) {


                xold = x;

                x = x2 * f1 - x1 * f2;
                x = x / (f1 - f2);


                if (x == xold) {
                    jTextArea1.append(" no more change" + x + "  f=" + func(x) + "\n");
                    break;
                }

                y = func(x);


                xap[nsteps] = x;
                yap[nsteps] = y;
                   nsteps += 1;

                jTextArea1.append(""+(nsteps-2)+" " + x + "  " + y + "\n");

             
                draw_points();

             

                if (nsteps > 200) {
                    jTextArea1.append(" too many iterations \n");
                    keep_iterating = 0;
                }


                if (y == 0.0) {
                    keep_iterating = 0;
                    found_it = 1;
                    jTextArea1.append(" function value is small enough\n ");
                } else {
                    if ((f1 * y) < 0.0) {
                        x2 = x;
                        f2 = y;
                    } else if ((f2 * y) < 0.0) {
                        x1 = x;
                        f1 = y;
                    } else {
                        jTextArea1.append(" ... cannot find a solution \n");
                        keep_iterating = 0;
                    }
                }


                if ((x2 - x1) < eps) {
                    jTextArea1.append(" intervall is small enough \n");
                    found_it = 1;
                    x = (x2 - x1) * 0.5;
                }
                
            }

            if (found_it == 1) {
                y = func(x);
                jTextArea1.append(" solution after " + (nsteps-2) + "  steps  is  " + x + "  f=" + df2.format(y) + " \n");
            }

        }
        stop();
    }

    void bisection(double x1, double x2, double eps) {

       

        
        double x, f1, f2, y,tol;
        int keep_iterating = 1;
        int found_it = 0;
        
        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with bisection method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());
               

      

        nsteps = 2;

        f1 = func(x1);
        f2 = func(x2);
        xap[0] = x1;
        yap[0] = f1;
        xap[1] = x2;
        yap[1] = f2;

        if ((f1 * f2) >= 0) {
            jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            nsteps=0;
        } else {
            x = (x1 + x2) / 2.0;

            while ((keep_iterating == 1) && (found_it == 0)) {

                x = (x1 + x2) / 2.0;
                y = func(x);

                xap[nsteps] = x;
                yap[nsteps] = y;
                  nsteps += 1;

                jTextArea1.append(""+(nsteps-2)+"  " + x + "  " + y + "\n");
               
                draw_points();
              


                if (y == 0.0) {
                    keep_iterating = 0;
                    found_it = 1;
                    jTextArea1.append(" function value is small enough\n ");
                } else {
                    if (!(Math.signum(f1) ==Math.signum(y)) ) {
                        x2 = x;
                        f2 = y;
                    } else if (!((Math.signum(f2)==Math.signum(y)))) {
                        x1 = x;
                        f1 = y;
                    } else {
                        jTextArea1.append(" ... cannot find a solution \n");
                        jTextArea1.append(" "+y+"  "+f1+" " +f2+"\n");
                        keep_iterating = 0;
                    }
                }

                tol=eps+Math.abs(x1+x2)*5E-16;

                if ((x2 - x1) < tol) {
                    jTextArea1.append(" intervall is small enough \n");
                    found_it = 1;
                    x = (x2 + x1) * 0.5;
                }

             
                

              
                
                 

            }

            if (found_it == 1) {
                y = func(x);
                jTextArea1.append(" solution after " + (nsteps-2) + " steps is " + x + "  f=" + df2.format(y) + " \n");
            }

        }  stop();
    }

    void Dekker(double x1, double x2, double eps) {

        

        
        
        double xm1,tol,x, xi, xk, yk, yi, f1, f2, y, xm, xs, a, b, b1, dm, ds, da, db, c, bn, an, fa, fb, t;
        int keep_iterating = 1;
        int found_it = 0;
        int found_x = 0;
        int ah, aw;
        int i;
        int nochange=0;
        
        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with Dekker's combined method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());

        

        nsteps = 2;

        f1 = func(x1);
        f2 = func(x2);

        if ((f1 * f2) >= 0) {
            jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            nsteps=0;
        } else {

            if (Math.abs(f1) < Math.abs(f2)) {
                b = x1;
                a = x2;
                c = x2;
                t = f1;
                f1 = f2;
                f2 = t;

            } else {
                a = x1;
                b = x2;
                c = x1;
            }

            xap[0] = a;
            yap[0] = f1;
            xap[1] = b;
            yap[1] = f2;
            
            xm1=b+1;











            while ((keep_iterating == 1) && (found_it == 0)) {

                tol=eps+Math.abs(b)*1E-15;
                
                f1 = func(a);
                f2 = func(b);



                xm = (c + b) / 2.0;
                xs = b - f2 * (b - a) / (f2 - f1);


                if (Math.abs(b - xs) < tol) {

                    if (c > b) {
                        xi = b + tol;
                    } else {
                        xi = b - tol;
                    }

                } else {

                    if (((b < xs) && (xs < xm)) || ((b > xs) && (xs > xm))) {

                        xi = xs;
                        //jTextArea1.append("interpolating \n");

                    } else {
                        xi = xm;
                        //jTextArea1.append("midpoint \n");
                    }
                }
                //jTextArea1.append("xm,xs  " + xm + "  " + xs + "\n");

                yi = func(xi);

                if (yi == 0) {
                    jTextArea1.append("function value is zero after " + (nsteps-1) + "steps \n");
                    y = yi;
                    b = xi;
                   
                    xap[nsteps] = xi;
                    yap[nsteps] = yi;
                    nsteps++;
                     jTextArea1.append(""+(nsteps-2)+"  "+b+" \n");
                    draw_points();
                    break;

                }


                i = nsteps;
                found_x = 0;
                do {
                    i = i - 1;
                    xk = xap[i];
                    yk = yap[i];

                    if ((yk * yi) < 0) {
                        found_x = 1;
                    }
                } while ((i >= 0) && (found_x == 0));


                //xap[nsteps] = xi;
                //yap[nsteps] = yi;
              
                xm1=b;
             

                if (Math.abs(yi) < Math.abs(yk)) {
                    a = b;
                    b = xi;
                    c = xk;
                    xap[nsteps] = xi;
                    yap[nsteps] = yi;
                } else {
                    a = xi;
                    b = xk;
                    c = xi;
                    xap[nsteps] = xk;
                    yap[nsteps] = yk;
                    //jTextArea1.append("exchange a b \n");
                }
                
                draw_points();

                jTextArea1.append("" + (nsteps-1) + "  " + xap[nsteps] + "  " + yap[nsteps]  + " \n");

                if (Math.abs(xm1 - b) < tol * 0.5) {

                    nochange++;

                    if (nochange == 1) {
                        //jTextArea1.append(" failed  \n");

                    } else {
                        //jTextArea1.append(" failed " + nochange + " times\n");
                        //jTextArea1.append(" interval width is" + Math.abs(c - b) + "\n");

                    }
                    if (nochange > 2) {
                        jTextArea1.append(" interval width is" + Math.abs(c - b) + "\n");
                        jTextArea1.append("no more iterations justified \n");
                        break;
                    }


                } else {
                    nochange = 0;
                }



                nsteps += 1;
                if(nsteps>=nmax-1) break;

               

                if (Math.abs(b - c) < tol) { 
                    jTextArea1.append(" interval width is" + Math.abs(c - b) + "\n");
                    jTextArea1.append(" intervall is small enough \n");
                    found_it = 1;
                    break;

                }

                

            }

            if (found_it == 1) {
                y = func(b);
                jTextArea1.append(" solution after " + (nsteps-2) + " steps is " + b + "  f=" + df2.format(y) + " \n");
            }

        }
        stop();
    }

    void Chandrupatla(double x1, double x2, double eps) {

        
        double x, xi, xk, yk, yi, f1, f2, y, xm, xs, a, b, b1, dm, ds, da, db, c, bn, an, fa, fb, t,ft;
        double dab, dac, dbc, fc, d, ee, tol, p, q, r, s,fm,tl,th,phi,fl,fh,alpha,A,B,C,D;

        int keep_iterating = 1;
        int found_it = 0;
        int found_x = 0;
        int ah, aw;
        int i;
        int mflag;

        boolean cond1, cond2, cond3, cond4, cond5;
        
        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with Chandrupatla's combined method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());

        

        nsteps = 2;

        f1 = func(x1);
        f2 = func(x2);
        
        b=x1;
        c=x2;
        a=c;
        
        fb=f1;
        fc=f2;
        fa=fc;
        

        if ((f1 * f2) >= 0) {
            jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            nsteps=0;
        } else {
            
            
            t=0.5;

          
            xap[0] = c;
            yap[0] = fc;
            xap[1] = b;
            yap[1] = fb;

            while ((keep_iterating == 1) && (found_it == 0)) {

                xs = a + t * (b - a);
                ft = func(xs);
                
                if(ft==0.0){ found_it=1; b=xs;
                
                xap[nsteps] = b;
                yap[nsteps] = ft;



                nsteps += 1;
                jTextArea1.append("" + (nsteps-3) + " " + b +"  "+Math.abs(c-b)+ "\n");
                draw_points();
                    break;}
                
                
                //jTextArea1.append(""+t+" "+xs+"  "+ft+"\n");

                if (Math.signum(ft) == Math.signum(fa)) {

                    c = a;
                    fc = fa;

                    a = xs;
                    fa = ft;


                } else {

                    c = b;
                    b = a;
                    a = xs;

                    fc = fb;
                    fb = fa;
                    fa = ft;


                }

                xm = a;
                fm = fa;

                if (Math.abs(fb) < Math.abs(fa)) {
                    xm = b;
                    fm = fb;

                }
                
                
                //jTextArea1.append("new points "+b+" " +a +"  "+c+"\n");
                //jTextArea1.append("new values "+fb+" " +fa +"  "+fc+"\n");
                tol = 2E-16 * Math.abs(b) + eps;
                tl = tol / Math.abs(b - c);


                if ((tl > 0.5) || (fm == 0)) { 
                    //jTextArea1.append(" converged\n");
                    found_it=1;
                    
                     
                xap[nsteps] = xm;
                yap[nsteps] = fm;



                nsteps += 1;
                jTextArea1.append(" " + (nsteps-3) + " " + b +"  "+Math.abs(c-b)+ "\n");
                draw_points();

                    break;
                }

                xi = (a - b) / (c - b);
                phi = (fa - fb) / (fc - fb);
                fl = 1 - Math.sqrt(1 - xi);
                fh = Math.sqrt(xi);

                if ((fl < phi) && (phi < fh)) {
                    alpha = (c - a) / (b - a);

                    A = fa / (fb - fa);
                    B = fc / (fb - fc);
                    C = fa / (fc - fa);
                    D = fb / (fc - fb);
                    t = A * B + C * D * alpha;



                } else {
                    t = 0.5;
                }
                
             

                if (t < tl) {
                    t = tl;
                }
                if (t > (1 - tl)) {
                    t = 1 - tl;
                }




              
              







                xap[nsteps] = b;
                yap[nsteps] = fb;



                nsteps += 1;



  jTextArea1.append(" " + (nsteps-3) + " " + b +"  "+Math.abs(c-b)+ "\n");
               

               draw_points();

            }
            

            if (found_it == 1) {
                y = func(b);
                jTextArea1.append(" solution after " + (nsteps-3) + " steps is " + b + "  f=" + df2.format(y) + " \n");
            }

        }
        stop();
    }

    void Brent(double x1, double x2, double eps) {

        
        double x, xi, xk, yk, yi, f1, f2, y, xm, xs, a, b, b1, dm, ds, da, db, c, bn, an, fa, fb, t;
        double dab, dac, dbc, fc, d, ee, tol, p, q, r, s;

        int keep_iterating = 1;
        int found_it = 0;

        int ah, aw;
        int i;

        Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
        jTextArea1.setCaretPosition(0);
        jTextArea1.setText("");
        jTextArea1.append("root finding with Dekker-Brent method\n");
        jScrollPane2.getVerticalScrollBar().setValue(jScrollPane1.getVerticalScrollBar().getMinimum());


        

        nsteps = 2;


        a = x1;
        b = x2;
        c = a;

        fa = func(a);
        fb = func(b);
        fc = fa;

        d = b - a;
        ee = d;

        if ((fa * fb) >= 0) {
            jTextArea1.append(" bad initial interval " + x1 + "  " + x2 + "\n");
            nsteps=0;
        } else {




            xap[0] = b;
            yap[0] = fb;

            xap[1] = a;
            yap[1] = fa;
            p = q = 0;


            while ((keep_iterating == 1) && (found_it == 0)) {
                if (Math.abs(fc) < Math.abs(fb)) {
                    a = b;
                    b = c;
                    c = a;
                    fa = fb;
                    fb = fc;
                    fc = fa;
                }

                tol = 5E-16 * Math.abs(b) + eps;
                xm = (c - b) * 0.5;





                if ((Math.abs(xm) > tol) && !(fb == 0.0)) {
                    //jTextArea1.append("e ="+ee+"\n");

                    if ((Math.abs(ee) < tol) || (Math.abs(fa) <= Math.abs(fb))) {
                        d = xm;
                        ee = xm; 
                        //jTextArea1.append(" bisect " + d + " \n");
                    } else {
                        s = fb / fa;
                        if (a == c) {
                            p = 2 * xm * s;
                            q = 1 - s;
                            //jTextArea1.append(" linear interpolation \n");
                        } else {
                            q = fa / fc;
                            r = fb / fc;
                            p = s * (2 * xm * q * (q - r) - (b - a) * (r - 1));
                            q = (q - 1) * (r - 1) * (s - 1);
                            //jTextArea1.append(" quadr interpolation \n");
                        }
                        if (p > 0) {
                            q = -q;
                        } else {
                            p = -p;
                        }
                    
                    s = ee;
                    ee = d;
                    if ((2 * p < 3 * xm * q - Math.abs(tol * q)) && (p < Math.abs(s * q * 0.5))) {
                        d = p / q;
                        //jTextArea1.append(" accept " + d + "  "+s+"  \n");
                    } else {
                        d = xm;
                        ee = xm;
                        //jTextArea1.append(" bisect* " + d + " \n");
                    }
                    }
                } else {
                    found_it = 1;
                    break;
                }

                a = b;
                fa = fb;

                if (Math.abs(d) > tol) {
                    b = b + d;
                } else {
                    if (xm > 0) {
                        b = b + tol;
                    } else {
                        b = b - tol;
                    }

                }






                fb = func(b);
                jTextArea1.append(" " + (nsteps-1) + " " + b +"  "+fb+ "\n");

                if (((fb > 0) && (fc > 0)) || (fb < 0 && fc < 0)) {
                    c = a;
                    fc = fa;
                    d = b - a;
                    ee = d;

                }





                xap[nsteps] = b;
                yap[nsteps] = fb;
                
                
                

               

                nsteps += 1;
                draw_points();



                if (Math.abs(b - c) < eps) {
                    jTextArea1.append(" intervall width < "+eps+"\n");
                    found_it = 1;

                }

               

            }

            if (found_it == 1) {
                jTextArea1.append(" intervall width < "+eps+"\n");
                y = func(b);
                jTextArea1.append(" solution after " + (nsteps-2) + " steps is " + b + "  f=" + df2.format(y) + " \n");
            }

        }
        stop();
    }
    public void draw_points()
    { int i, j, ix, iy;
        double x;
     Graphics g = jPanel1.getGraphics();
        Graphics2D g2 = (Graphics2D) g; 
       gb.setColor(Color.RED);

            for (i = 0; i < nsteps-1 ; i++) {
                ix = 2 * (int) (50.0 * xap[i] + 100.0);
                iy = 200 - (int) (yap[i] * 20);

                gb.fillOval(ix - 4, iy - 4, 8, 8);


            }
            if (nsteps > 0) {
                gb.setColor(Color.GREEN);
                ix = 2 * (int) (50.0 * xap[nsteps-1 ] + 100.0);
                iy = 200 - (int) (yap[nsteps-1 ] * 20);

                gb.fillOval(ix - 4, iy - 4, 8, 8);
            }
            g2.drawImage(image, 0, 0, null);
    
    }
    public void draw_new ()
    { 
        int i, j, ix, iy;
        double x; 
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 510, 410);
        
        
        
        for (i = 0; i < 250; i++) {
            x = -2 + i * 0.02;
            ixp[i] = i * 2;
            iyp[i] = 200 - (int) (func(x) * 20);
        }
        gb.setColor(Color.black);
        gb.drawPolyline(ixp, iyp, nplot);



        iy = 200;
        gb.setColor(Color.GRAY);
        gb.drawLine(0, iy, 500, iy);

        ix = 2 * (int) (50.0 * x1 + 100.0);
        gb.drawLine(ix, 0, ix, 350);

        gb.drawString("" + df.format(x1), ix, 390);

        ix = 2 * (int) (50.0 * x2 + 100.0);
        gb.drawLine(ix, 0, ix, 350);

        gb.drawString("" + df.format(x2), ix, 390);
        
        draw_points();
        
    }

    public class myPanel extends javax.swing.JPanel {


        public void paintComponent(Graphics g) {
            Graphics2D g2 = (Graphics2D) g;

            super.paintComponent(g);

             g2.drawImage(image, 0, 0, null);



        }
    }
}
