/*
 * waveapplet.java
 *
 * Created on 21. März 2008, 12:55
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.image.BufferedImage;

/**
 *
 * @author  poj
 */
public class waveapplet extends javax.swing.JApplet
        implements ActionListener {

    DecimalFormat df, df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int NDIM = 500;
    int NHALF=250;
    int NITER = 10000;
    double DELTAT = 0.001;
    double DELTAX = 0.1;
    double[] V, RPSI, IPSI, DRPSI, DIPSI,RPSIO,IPSIO;
    int i, j, k, loop, il;
    double x, d2r, d2i, dx2,dx2h;
    double[][] a, b, r, u, gam;
    double[] nom, bet;
    double denom;
    int innerloops = 1;
    int selector = 0;
    int method=0;
    double V0;
    double VM = 100.0;
    double Ekin, Epot, Norm,totaltime;
    int icent = 50;
    double inwidth=50;
    
    double [] ra11,ia11,ra22,ia22,ra12,ia12,rb11,ib11,rb22,ib22,rb12,ib12;
    
    double r11,i11,r22,i22,r12,i12;
    
    public void actionPerformed(ActionEvent e) {
        int iw,ip;
        double amp;

        
        if(totaltime<5000.0){
        
        loop++;
        //jLabel1.setText("" + loop);
        
        
        
        
        if(method==0) waves();
        if(method==1) waves2();
         if(method==2) waves25p();
         if(method==3) waves27p();
      if(method==4) waves3();
      
        jLabel9.setText("time: "+df1.format(totaltime));
           /* if ((loop == 1) || (loop == 100) || (loop==200) ||(loop==300) ||(loop==400)  ) {

                jTextArea1.append(" time="+totaltime+"\n");
                for (ip = 0; ip < NDIM; ip++) {
                   amp=(RPSI[ip] * RPSI[ip] + IPSI[ip] * IPSI[ip]);
                   if(amp>1.0E-3)
                    jTextArea1.append(" " + ip + "  " + amp + "\n");
                }
                jTextArea1.append(" \n");
            }*/
        //jTextArea1.append(" "+totaltime+"  "+Norm+" "+(Ekin+Epot)+"\n");
        timer.setInitialDelay(10);
        timer.setDelay(10);
        timer.restart();
        }

    }

    /** Initializes the applet waveapplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    initComponents();
                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }



        //velSlider.setValue((int) (vel * 100));
        //velLabel.setText("velocity=" + df1.format((vel)));
        init_variables();
        speedSlider.setValue(1);
        reset_all();
        timer = new Timer(10, this);
        timer.setInitialDelay(10);
        timer.start();


    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        velLabel = new javax.swing.JLabel();
        velSlider = new javax.swing.JSlider();
        jComboBox1 = new javax.swing.JComboBox();
        speedSlider = new javax.swing.JSlider();
        jButton1 = new javax.swing.JButton();
        jSlider1 = new javax.swing.JSlider();
        jLabel6 = new javax.swing.JLabel();
        jLabel7 = new javax.swing.JLabel();
        jSlider2 = new javax.swing.JSlider();
        jLabel8 = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox();
        jLabel9 = new javax.swing.JLabel();
        jLabel2 = new javax.swing.JLabel();
        jLabel3 = new javax.swing.JLabel();
        jLabel4 = new javax.swing.JLabel();
        jLabel5 = new javax.swing.JLabel();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setMaximumSize(new java.awt.Dimension(400, 400));
        jPanel1.setMinimumSize(new java.awt.Dimension(400, 400));
        jPanel1.setPreferredSize(new java.awt.Dimension(400, 400));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 542, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 400, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setMaximumSize(new java.awt.Dimension(200, 600));
        jPanel2.setMinimumSize(new java.awt.Dimension(200, 600));
        jPanel2.setPreferredSize(new java.awt.Dimension(200, 600));

        jLabel1.setText("animation speed");

        velLabel.setText("jLabel2");

        velSlider.setMajorTickSpacing(1);
        velSlider.setMaximum(5);
        velSlider.setMinimum(1);
        velSlider.setPaintLabels(true);
        velSlider.setPaintTicks(true);
        velSlider.setSnapToTicks(true);
        velSlider.setValue(3);
        velSlider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                velSliderMouseDragged(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "quadratic", "quartic", "box" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        speedSlider.setMajorTickSpacing(1);
        speedSlider.setMaximum(50);
        speedSlider.setMinimum(1);
        speedSlider.setPaintTicks(true);
        speedSlider.setSnapToTicks(true);
        speedSlider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                speedSliderMouseDragged(evt);
            }
        });

        jButton1.setText("Restart");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jSlider1.setMaximum(470);
        jSlider1.setMinimum(30);
        jSlider1.setMinorTickSpacing(50);
        jSlider1.setPaintTicks(true);
        jSlider1.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider1MouseReleased(evt);
            }
        });
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jLabel6.setText("potential ");

        jLabel7.setText("initial position");

        jSlider2.setMaximum(50);
        jSlider2.setMinimum(10);
        jSlider2.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                jSlider2MouseReleased(evt);
            }
        });
        jSlider2.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider2MouseDragged(evt);
            }
        });

        jLabel8.setText("initial width");

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "CN", "SOD3", "SOD5", "SOD7", "SPO" }));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox2ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(55, 55, 55)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel7)
                            .addComponent(jLabel1)))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, 144, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 154, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(64, 64, 64)
                        .addComponent(jLabel8))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(speedSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 144, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(jLabel6)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(velSlider, javax.swing.GroupLayout.PREFERRED_SIZE, 138, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(65, 65, 65)
                        .addComponent(velLabel))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(51, 51, 51)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jButton1)
                            .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, 95, javax.swing.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap(54, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jSlider1, jSlider2, speedSlider, velSlider});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(velLabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(velSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(22, 22, 22)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(18, 18, 18)
                .addComponent(jLabel7)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jLabel8)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSlider2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(29, 29, 29)
                .addComponent(jLabel1)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(speedSlider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jButton1)
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        jLabel9.setText("jLabel9");

        jLabel2.setText("jLabel2");

        jLabel3.setText("jLabel3");
        jLabel3.setMaximumSize(new java.awt.Dimension(250, 15));
        jLabel3.setMinimumSize(new java.awt.Dimension(250, 15));
        jLabel3.setPreferredSize(new java.awt.Dimension(250, 15));

        jLabel4.setText("jLabel4");

        jLabel5.setText("jLabel5");

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 544, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addGroup(layout.createSequentialGroup()
                        .addGap(12, 12, 12)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jLabel9, javax.swing.GroupLayout.PREFERRED_SIZE, 230, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                                .addGap(18, 18, 18)
                                .addComponent(jLabel2))
                            .addGroup(layout.createSequentialGroup()
                                .addComponent(jLabel4)
                                .addGap(18, 18, 18)
                                .addComponent(jLabel5)))))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 232, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(176, Short.MAX_VALUE))
        );

        layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {jLabel2, jLabel3, jLabel4, jLabel5, jLabel9});

        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.PREFERRED_SIZE, 402, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addComponent(jLabel9)
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel2))
                        .addGap(18, 18, 18)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                            .addComponent(jLabel4)
                            .addComponent(jLabel5)))
                    .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))
                .addGap(111, 111, 111))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void velSliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_velSliderMouseDragged
        DELTAT = Math.pow(10, -velSlider.getValue());
        velLabel.setText("timestep=" + df.format(DELTAT));
        reset_all();
    
    }//GEN-LAST:event_velSliderMouseDragged

    private void speedSliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_speedSliderMouseDragged

        innerloops = speedSlider.getValue();// TODO add your handling code here:
    }//GEN-LAST:event_speedSliderMouseDragged

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed

        selector = jComboBox1.getSelectedIndex();
        reset_all();// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed

        reset_all();// TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        timer.stop();
        icent = jSlider1.getValue();
        reset_all();
        draw();

    // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    private void jSlider1MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseReleased
        timer.restart();        // TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseReleased

    private void jSlider2MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseDragged
        timer.stop();
        inwidth=jSlider2.getValue();
        reset_all();
        draw();
        // TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseDragged

    private void jSlider2MouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider2MouseReleased
      timer.restart(); // TODO add your handling code here:
    }//GEN-LAST:event_jSlider2MouseReleased

    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed

        method = jComboBox2.getSelectedIndex();
        reset_all();// TODO add your handling code here:// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox2ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButton1;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JLabel jLabel9;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JSlider jSlider2;
    private javax.swing.JSlider speedSlider;
    private javax.swing.JLabel velLabel;
    private javax.swing.JSlider velSlider;
    // End of variables declaration//GEN-END:variables
    void init_variables() {
        df = new DecimalFormat("0.000E0");
        df1 = new DecimalFormat("0.000000000000");



        image =
                new BufferedImage(550, 650, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 550, 650);

        V = new double[NDIM];

        RPSI = new double[NDIM];
        IPSI = new double[NDIM];
        RPSIO = new double[NDIM];
        IPSIO = new double[NDIM];
        DRPSI = new double[NDIM];
        DIPSI = new double[NDIM];

        a = new double[NDIM][2];
        b = new double[NDIM][2];
        r = new double[NDIM][2];
        u = new double[NDIM][2];
        gam = new double[NDIM][2];

        nom = new double[2];
        bet = new double[2];
        
        
        ra11=new double[NHALF];
        ia11=new double[NHALF];        
        ra22=new double[NHALF];
        ia22=new double[NHALF];
        ra12=new double[NHALF];
        ia12=new double[NHALF];
        
        rb11=new double[NHALF];
        ib11=new double[NHALF];        
        rb22=new double[NHALF];
        ib22=new double[NHALF];
        rb12=new double[NHALF];
        ib12=new double[NHALF];
        

        velSlider.setValue(3);
        velLabel.setText("timestep=" + df.format(DELTAT));
    }

    double potential4(int i) {
        double x;

        x = ((double) (i - NDIM / 2) / (double) NDIM);
        return 1000 * x * x * x * x - x * x * 100;

    }

    double potential2(int i) {
        double x;

        x = ((double) (i - NDIM / 2) / (double) NDIM);
        return 100 * x * x;

    }

    void reset_all() {
        int i;
        double kfac,pref,arg;
        
        kfac=30*2*Math.PI/NDIM;
        //kfac=0.0;


        dx2 = DELTAX * DELTAX;
        dx2h=dx2*2.0;

        if (selector == 0) {
            V0 = potential2(icent);

            for (i = 0; i < NDIM; i++) {

                V[i] = potential2(i) - V0;

                RPSI[i] = 0.0;
                IPSI[i] = 0.0;

            }
        }
        if (selector == 1) {
            V0 = potential4(icent);

            for (i = 0; i < NDIM; i++) {

                V[i] = potential4(i) - V0;

                RPSI[i] = 0.0;
                IPSI[i] = 0.0;

            }
        }
        if (selector == 2) {
            for (i = 0; i < NDIM; i++) {
                V[i] = 0;
            }
              for (i = 0; i < NDIM; i++) {
            x = (double) i - (double) (icent);
            arg=x/inwidth;
            pref= Math.exp(-(arg * arg));
            RPSI[i]=pref*Math.cos(x*kfac);
            IPSI[i]=pref*Math.sin(x*kfac);
        }
            
        }
           if (selector == 3) {
            for (i = 0; i < NDIM; i++) {
                V[i] = 0;
            }
            
        }

        if(selector<2){
        for (i = 0; i < NDIM; i++) {
            x = (double) i - (double) (icent);
            x=x/inwidth;
            pref= Math.exp(-(x * x));
            RPSI[i]=pref;
            IPSI[i]=0;
        }
        }
        normalize();

        loop = 0;
           
        switch(method)
                {
        
            case 0: ;
            case 1: initwaves2();
            case 2: initwaves25p();
            case 3: initwaves27p();
            case 4: ;
             
            default: ;    
        
        }
        
     
        
        totaltime=0;
        
        //jTextArea1.setText(null);
       




    }

    void tridag() {
        int j;



        bet[0] = b[0][0];
        bet[1] = b[0][1];

        denom = bet[0] * bet[0] + bet[1] * bet[1];

        u[0][0] = (r[0][0] * bet[0] + r[0][1] * bet[1]) / denom;
        u[0][1] = (r[0][1] * bet[0] - r[0][0] * bet[1]) / denom;


        for (j = 1; j < NDIM; j++) {


            gam[j][0] = (a[j - 1][0] * bet[0] + a[j - 1][1] * bet[1]) / denom;
            gam[j][1] = (a[j - 1][1] * bet[0] - a[j - 1][0] * bet[1]) / denom;

            bet[0] = b[j][0] - a[j][0] * gam[j][0] + a[j][1] * gam[j][1];
            bet[1] = b[j][1] - a[j][0] * gam[j][1] - a[j][1] * gam[j][0];

            denom = bet[0] * bet[0] + bet[1] * bet[1];
 
            nom[0] = r[j][0] - a[j][0] * u[j - 1][0] + a[j][1] * u[j - 1][1];
            nom[1] = r[j][1] - a[j][0] * u[j - 1][1] - a[j][1] * u[j - 1][0];

            u[j][0] = (nom[0] * bet[0] + nom[1] * bet[1]) / denom;
            u[j][1] = (nom[1] * bet[0] - nom[0] * bet[1]) / denom;





        }

        for (j = (NDIM - 2); j >= 0; j--) {
            u[j][0] -= (gam[j + 1][0] * u[j + 1][0] - gam[j + 1][1] * u[j + 1][1]);
            u[j][1] -= (gam[j + 1][0] * u[j + 1][1] + gam[j + 1][1] * u[j + 1][0]);
        }
    }

    void normalize() {
        /* normalize */

        x = 0.0;
        for (i = 0; i < NDIM; i++) {
            x = x + RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
        }

        x = Math.sqrt(x);

        for (i = 0; i < NDIM; i++) {
            RPSI[i] = RPSI[i] / x;
            IPSI[i] = IPSI[i] / x;
        }
    }
    void ex2(double a11, double a22, double a12 ) {
        double rx1, ix1, rx2, ix2, q, t, c2, cs, s2, ev1, ev2;

        q = 0.5 * (a22 - a11) / a12;
        t = 1. / (Math.abs(q) + Math.sqrt(1. + q * q));
        if (q < 0.0) {
            t = -t;
        }

        c2 = 1. / (1. + t * t);
        cs = t * c2;
        s2 = t * cs;

        ev1 = a11 - a12 * t;
        ev2 = a22 + a12 * t;

        rx1 = Math.cos(ev1);
        ix1 = -Math.sin(ev1);

        rx2 = Math.cos(ev2);
        ix2 = -Math.sin(ev2);


        r11 = c2 * rx1 + s2 * rx2;
        i11 = c2 * ix1 + s2 * ix2;
        r22 = c2 * rx2 + s2 * rx1;
        i22 = c2 * ix2 + s2 * ix1;
        r12 = cs * (rx2 - rx1);
        i12 = cs * (ix2 - ix1);

    }

    ;
        void waves3() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        int y1, y2, y3, i, j,index;
        double amp, su,a11,a22,a12,r1,r2,i1,i2;
        
        r11=i11=r12=i12=r22=i22=0;

        for (il = 0; il < innerloops; il++) {
             totaltime+=DELTAT;

            {

                a11=0.5*DELTAT*(V[0]+1.0/dx2);
                a22=0.25*DELTAT*(V[1]+1.0/dx2);
                a12=-0.25*DELTAT/dx2h;
                
                ex2(a11,a22,a12);
                
                ra11[0]=r11;
                ia11[0]=i11;
                ra22[0]=r22;
                ia22[0]=i22;
                ra12[0]=r12;
                ia12[0]=i12;
              
                for (i = 1; i < NHALF - 1; i++) {
                    index = i * 2;

                    a11 = 0.25 * DELTAT * (V[index] + 1.0 / dx2);
                    a22 = 0.25 * DELTAT * (V[index + 1] + 1.0 / dx2);
                    a12 = -0.5 * DELTAT / dx2h;

                    ex2(a11, a22, a12);

                    ra11[i] = r11;
                    ia11[i] = i11;
                    ra22[i] = r22;
                    ia22[i] = i22;
                    ra12[i] = r12;
                    ia12[i] = i12;


                }
                index=2*(NHALF-1);
                a11=0.25*DELTAT*(V[index]+1.0/dx2);
                a22=0.5*DELTAT*(V[index+1]+1.0/dx2);
                a12=-0.25*DELTAT/dx2h;
                
                ex2(a11,a22,a12);
                
                ra11[NHALF-1]=r11;
                ia11[NHALF-1]=i11;
                ra22[NHALF-1]=r22;
                ia22[NHALF-1]=i22;
                ra12[NHALF-1]=r12;
                ia12[NHALF-1]=i12;
                
                
                 for (i = 0; i < NHALF - 1; i++) {
                    index = i * 2+1;

                    a11 = 0.5 * DELTAT * (V[index] + 1.0 / dx2);
                    a22 = 0.5 * DELTAT * (V[index + 1] + 1.0 / dx2);
                    a12 = - DELTAT / dx2h;

                    ex2(a11, a22, a12);

                    rb11[i] = r11;
                    ib11[i] = i11;
                    rb22[i] = r22;
                    ib22[i] = i22;
                    rb12[i] = r12;
                    ib12[i] = i12;


                }
                
                
                
                for (i = 0; i < NHALF; i++) {
                    
                    index=i*2;
                    r1=ra11[i]*RPSI[index]-ia11[i]*IPSI[index]+ra12[i]*RPSI[index+1]-ia12[i]*IPSI[index+1];
                    i1=ra11[i]*IPSI[index]+ia11[i]*RPSI[index]+ra12[i]*IPSI[index+1]+ia12[i]*RPSI[index+1];
                    r2=ra12[i]*RPSI[index]-ia12[i]*IPSI[index]+ra22[i]*RPSI[index+1]-ia22[i]*IPSI[index+1];
                    i2=ra12[i]*IPSI[index]+ia12[i]*RPSI[index]+ra22[i]*IPSI[index+1]+ia22[i]*RPSI[index+1];
                    RPSI[index]=r1;
                    IPSI[index]=i1;
                    RPSI[index+1]=r2;
                    IPSI[index+1]=i2;
                    
                }
                 for (i = 0; i < NHALF-1; i++) {
                    
                    index=i*2+1;
                    r1=rb11[i]*RPSI[index]-ib11[i]*IPSI[index]+rb12[i]*RPSI[index+1]-ib12[i]*IPSI[index+1];
                    i1=rb11[i]*IPSI[index]+ib11[i]*RPSI[index]+rb12[i]*IPSI[index+1]+ib12[i]*RPSI[index+1];
                    r2=rb12[i]*RPSI[index]-ib12[i]*IPSI[index]+rb22[i]*RPSI[index+1]-ib22[i]*IPSI[index+1];
                    i2=rb12[i]*IPSI[index]+ib12[i]*RPSI[index]+rb22[i]*IPSI[index+1]+ib22[i]*RPSI[index+1];
                    RPSI[index]=r1;
                    IPSI[index]=i1;
                    RPSI[index+1]=r2;
                    IPSI[index+1]=i2;
                    
                }
                
                  for (i = 0; i < NHALF; i++) {
                    
                    index=i*2;
                    r1=ra11[i]*RPSI[index]-ia11[i]*IPSI[index]+ra12[i]*RPSI[index+1]-ia12[i]*IPSI[index+1];
                    i1=ra11[i]*IPSI[index]+ia11[i]*RPSI[index]+ra12[i]*IPSI[index+1]+ia12[i]*RPSI[index+1];
                    r2=ra12[i]*RPSI[index]-ia12[i]*IPSI[index]+ra22[i]*RPSI[index+1]-ia22[i]*IPSI[index+1];
                    i2=ra12[i]*IPSI[index]+ia12[i]*RPSI[index]+ra22[i]*IPSI[index+1]+ia22[i]*RPSI[index+1];
                    RPSI[index]=r1;
                    IPSI[index]=i1;
                    RPSI[index+1]=r2;
                    IPSI[index+1]=i2;
                    
                }
                
                



            /*     normalize(); */

            }



        }


        Ekin = 0;
        Epot = 0;
        Norm = 0;
        for (i = 0; i < NDIM; i++) {
            amp = RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
            Norm = Norm + amp;
            Epot = Epot + amp * V[i];

        }
        
        su = 0;
        for (i = 1; i < NDIM - 1; i++) {
            su = su + RPSI[i] * RPSI[i + 1] + IPSI[i] * IPSI[i + 1];
            su = su + RPSI[i] * RPSI[i - 1] + IPSI[i] * IPSI[i - 1];
        }
        
         su = su + RPSI[0] * RPSI[1] + IPSI[0] * IPSI[1];
         su = su + RPSI[NDIM-1] * RPSI[NDIM-2] + IPSI[NDIM-1] * IPSI[NDIM-2];
        
        Ekin = Ekin + su - 2 * Norm;
        Ekin = -Ekin / dx2h;
        
       

        jLabel2.setText("Norm=" + df1.format(Norm));
        jLabel3.setText("Epot=" + df1.format(Epot));
        jLabel4.setText("Ekin=" + df1.format(Ekin));
        jLabel5.setText("Etot=" + df1.format(Epot + Ekin));

        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




    }
     
    
    void waves() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        int y1, y2, y3, i, j;
        double amp, su;

        for (il = 0; il < innerloops; il++) {

            {
                totaltime+=DELTAT;


                for (i = 0; i < NDIM; i++) {
                    a[i][0] = 0.0;
                    a[i][1] = -0.25*DELTAT / dx2;
                    b[i][0] = 1.0;
                    b[i][1] = 0.5*DELTAT * (V[i] + 1.0 / dx2);
                    r[i][0] = RPSI[i];
                    r[i][1] = IPSI[i];
                }


                tridag();

                for (i = 0; i < NDIM; i++) {
                    RPSI[i] = 2 * u[i][0] - RPSI[i];
                    IPSI[i] = 2 * u[i][1] - IPSI[i];
                }


            /*     normalize(); */

            }



        }


        Ekin = 0;
        Epot = 0;
        Norm = 0;
        for (i = 0; i < NDIM; i++) {
            amp = RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
            Norm = Norm + amp;
            Epot = Epot + amp * V[i];

        }
        su = 0;
        for (i = 1; i < NDIM - 1; i++) {
            su = su + RPSI[i] * RPSI[i + 1] + IPSI[i] * IPSI[i + 1];
            su = su + RPSI[i] * RPSI[i - 1] + IPSI[i] * IPSI[i - 1];
        }
        
         su = su + RPSI[0] * RPSI[1] + IPSI[0] * IPSI[1];
         su = su + RPSI[NDIM-1] * RPSI[NDIM-2] + IPSI[NDIM-1] * IPSI[NDIM-2];
        
        Ekin = Ekin + su - 2 * Norm;
        Ekin = -Ekin / dx2h;

        jLabel2.setText("Norm=" + df1.format(Norm));
        jLabel3.setText("Epot=" + df1.format(Epot));
        jLabel4.setText("Ekin=" + df1.format(Ekin));
        jLabel5.setText("Etot=" + df1.format(Epot + Ekin));

        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




    }
  
     void initwaves2()
             {int y1, y2, y3, i, j;
        double amp, su,rdel,imdel;


                for (i = 1; i < NDIM-1; i++) {
                    
                    
                    rdel=(V[i]+1.0/dx2)*IPSI[i]-IPSI[i-1]/dx2h-IPSI[i+1]/dx2h;                    
                    rdel=-rdel*DELTAT;
                    
                    DRPSI[i]=rdel;
                    
                    imdel=(V[i]+1.0/dx2)*RPSI[i]-RPSI[i-1]/dx2h-RPSI[i+1]/dx2h; 
                    imdel=imdel*DELTAT;
                    
                    DIPSI[i]=imdel;
                }
                    rdel=(V[0]+1.0/dx2)*IPSI[0]-IPSI[1]/dx2h;                    
                    rdel=-rdel*DELTAT;
                    
                    DRPSI[0]=rdel;
                    
                    imdel=(V[0]+1.0/dx2)*RPSI[0]-RPSI[1]/dx2h; 
                    imdel=imdel*DELTAT;
                    
                    DIPSI[0]=imdel;
                    
                    rdel=(V[NDIM-1]+1.0/dx2)*IPSI[NDIM-1]-IPSI[NDIM-2]/dx2h;                    
                    rdel=-rdel*DELTAT;
                    
                    DRPSI[NDIM-1]=rdel;
                    
                    imdel=(V[NDIM-1]+1.0/dx2)*RPSI[NDIM-1]-RPSI[NDIM-2]/dx2h; 
                    imdel=imdel*DELTAT;
                    
                    DIPSI[NDIM-1]=imdel;

                

                for (i = 0; i < NDIM; i++) {
                    RPSIO[i] = RPSI[i]+DRPSI[i];
                    IPSIO[i] = IPSI[i]+DIPSI[i];
                    
                   
                }


            /*     normalize(); */

            }
      void initwaves25p()
             {int y1, y2, y3, i, j;
        double amp, su,rdel,imdel;
          
        double c0=1.25;
        double c1=-16./24.;
        double c2=1./24.; 
/*        
         double c0=1.0;
        double c1=-0.5;
        double c2=0.0;
        * 
        * 
        */
                     for (i = 0; i < NDIM; i++) {
                    
                    
                    rdel=(V[i]+c0/dx2)*IPSI[i];
                    if(i>0) rdel=rdel+c1*IPSI[i-1]/dx2;
                    if(i>1) rdel=rdel+c2*IPSI[i-2]/dx2;
                    if(i<NDIM-1)rdel=rdel+c1*IPSI[i+1]/dx2;
                    if(i<NDIM-2)rdel=rdel+c2*IPSI[i+2]/dx2;
                                  
                    rdel=-rdel*DELTAT;
                    
                    DRPSI[i]=rdel;
                    
                    imdel=(V[i]+c0/dx2)*RPSI[i];
                    if(i>0) imdel=imdel+c1*RPSI[i-1]/dx2;
                    if(i>1) imdel=imdel+c2*RPSI[i-2]/dx2;
                    if(i<NDIM-1)imdel=imdel+c1*RPSI[i+1]/dx2;
                    if(i<NDIM-2)imdel=imdel+c2*RPSI[i+2]/dx2;
                                  
                    imdel=imdel*DELTAT;
                    
                    DIPSI[i]=imdel;
                }
                   

             

                

                for (i = 0; i < NDIM; i++) {
                    RPSIO[i] = RPSI[i]+DRPSI[i];
                    IPSIO[i] = IPSI[i]+DIPSI[i];
                    
                   
                }


            /*     normalize(); */

            }
    
    void initwaves27p()
             {int y1, y2, y3, i, j;
        double amp, su,rdel,imdel;
       
        
        double c0=49./36.;
        double c1=-3./4.;
        double c2=3./40.;
        double c3=-1./180.;
/*        
         double c0=1.0;
        double c1=-0.5;
        double c2=0.0;
        * 
        * 
        */
                     for (i = 0; i < NDIM; i++) {
                    
                    
                    rdel=(V[i]+c0/dx2)*IPSI[i];
                    if(i>0) rdel=rdel+c1*IPSI[i-1]/dx2;
                    if(i>1) rdel=rdel+c2*IPSI[i-2]/dx2;
                    if(i>2) rdel=rdel+c3*IPSI[i-3]/dx2;
                    if(i<NDIM-1)rdel=rdel+c1*IPSI[i+1]/dx2;
                    if(i<NDIM-2)rdel=rdel+c2*IPSI[i+2]/dx2;
                    if(i<NDIM-3)rdel=rdel+c3*IPSI[i+3]/dx2;
                                  
                    rdel=-rdel*DELTAT;
                    
                    DRPSI[i]=rdel;
                    
                    imdel=(V[i]+c0/dx2)*RPSI[i];
                    if(i>0) imdel=imdel+c1*RPSI[i-1]/dx2;
                    if(i>1) imdel=imdel+c2*RPSI[i-2]/dx2;
                    if(i>2) imdel=imdel+c3*RPSI[i-3]/dx2;
                    if(i<NDIM-1)imdel=imdel+c1*RPSI[i+1]/dx2;
                    if(i<NDIM-2)imdel=imdel+c2*RPSI[i+2]/dx2;
                    if(i<NDIM-3)imdel=imdel+c3*RPSI[i+3]/dx2;
                                  
                    imdel=imdel*DELTAT;
                    
                    DIPSI[i]=imdel;
                }
                   

             

                

                for (i = 0; i < NDIM; i++) {
                    RPSIO[i] = RPSI[i]+DRPSI[i];
                    IPSIO[i] = IPSI[i]+DIPSI[i];
                    
                   
                }


            /*     normalize(); */

            }

        void waves2() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        int y1, y2, y3, i, j;
        double amp, su,rdel,imdel,amp1,norm1;

        for (il = 0; il < innerloops; il++) {

            {

                totaltime+=DELTAT;
                for (i = 1; i < NDIM-1; i++) {
                    
                    
                    rdel=(V[i]+1.0/dx2)*IPSI[i]-IPSI[i-1]/dx2h-IPSI[i+1]/dx2h;                    
                    rdel=2.0*rdel*DELTAT;
                    
                    DRPSI[i]=rdel;
                    
                    imdel=(V[i]+1.0/dx2)*RPSI[i]-RPSI[i-1]/dx2h-RPSI[i+1]/dx2h; 
                    imdel=-2.0*imdel*DELTAT;
                    
                    DIPSI[i]=imdel;
                }
                    rdel=(V[0]+1.0/dx2)*IPSI[0]-IPSI[1]/dx2h;                    
                    rdel=2.0*rdel*DELTAT;
                    
                    DRPSI[0]=rdel;
                    
                    imdel=(V[0]+1.0/dx2)*RPSI[0]-RPSI[1]/dx2h; 
                    imdel=-2.0*imdel*DELTAT;
                    
                    DIPSI[0]=imdel;
                    
                    rdel=(V[NDIM-1]+1.0/dx2)*IPSI[NDIM-1]-IPSI[NDIM-2]/dx2h;                    
                    rdel=2.0*rdel*DELTAT;
                    
                    DRPSI[NDIM-1]=rdel;
                    
                    imdel=(V[NDIM-1]+1.0/dx2)*RPSI[NDIM-1]-RPSI[NDIM-2]/dx2h; 
                    imdel=-2.0*imdel*DELTAT;
                    
                    DIPSI[NDIM-1]=imdel;

                

                for (i = 0; i < NDIM; i++) {
                    
                    rdel=RPSI[i];
                    imdel=IPSI[i];
                    
                    RPSI[i] = RPSIO[i]+DRPSI[i];
                    IPSI[i] = IPSIO[i]+DIPSI[i];
                    
                    RPSIO[i]=rdel;
                    IPSIO[i]=imdel;
                }


            /*     normalize(); */

            }



        }


        Ekin = 0;
        Epot = 0;
        Norm = 0;
        for (i = 0; i < NDIM; i++) {
            amp = RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
            //amp1=RPSIO[i]*RPSI[i]+IPSIO[i]*IPSI[i];
            Norm = Norm + amp;
            Epot = Epot + amp * V[i];

        }
        su = 0;
        for (i = 1; i < NDIM - 1; i++) {
            su = su + RPSI[i] * RPSI[i + 1] + IPSI[i] * IPSI[i + 1];
            su = su + RPSI[i] * RPSI[i - 1] + IPSI[i] * IPSI[i - 1];
        }
            su = su + RPSI[0] * RPSI[1] + IPSI[0] * IPSI[ 1];
            su = su + RPSI[NDIM-1] * RPSI[NDIM-2] + IPSI[NDIM-1] * IPSI[NDIM-2];
        Ekin = Ekin +  su - 2 * Norm;
        Ekin = -Ekin / dx2h;

        jLabel2.setText("Norm=" + df1.format(Norm));
        jLabel3.setText("Epot=" + df1.format(Epot));
        jLabel4.setText("Ekin=" + df1.format(Ekin));
        jLabel5.setText("Etot=" + df1.format(Epot + Ekin));

        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




    }
                void waves25p() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        int y1, y2, y3, i, j;
        double amp, su,rdel,imdel,amp1,norm1;
        
        
        double c0=1.25;
        double c1=-16./24.;
        double c2=1./24.;
        /*
        double c0=1.0;
        double c1=-0.5;
        double c2=0.0;
        */

        for (il = 0; il < innerloops; il++) {

            {

                totaltime+=DELTAT;
                for (i = 0; i < NDIM; i++) {
                    
                    
                    rdel = (V[i] + c0 / dx2) * IPSI[i];
                    if (i > 0) {
                        rdel = rdel + c1 * IPSI[i - 1] / dx2;
                    }
                    if (i > 1) {
                        rdel = rdel + c2 * IPSI[i - 2] / dx2;
                    }
                    if (i < NDIM - 1) {
                        rdel = rdel + c1 * IPSI[i + 1] / dx2;
                    }
                    if (i < NDIM - 2) {
                        rdel = rdel + c2 * IPSI[i + 2] / dx2;
                    }

                    rdel = 2.0 * rdel * DELTAT;

                    DRPSI[i] = rdel;

                    imdel = (V[i] + c0 / dx2) * RPSI[i];
                    if (i > 0) {
                        imdel = imdel + c1 * RPSI[i - 1] / dx2;
                    }
                    if (i > 1) {
                        imdel = imdel + c2 * RPSI[i - 2] / dx2;
                    }
                    if (i < NDIM - 1) {
                        imdel = imdel + c1 * RPSI[i + 1] / dx2;
                    }
                    if (i < NDIM - 2) {
                        imdel = imdel + c2 * RPSI[i + 2] / dx2;
                    }

                    imdel = -2.0 * imdel * DELTAT;

                    DIPSI[i] = imdel;
                }
                   
                

                for (i = 0; i < NDIM; i++) {
                    
                    rdel=RPSI[i];
                    imdel=IPSI[i];
                    
                    RPSI[i] = RPSIO[i]+DRPSI[i];
                    IPSI[i] = IPSIO[i]+DIPSI[i];
                    
                    RPSIO[i]=rdel;
                    IPSIO[i]=imdel;
                }


            /*     normalize(); */

            }



        }


        Ekin = 0;
        Epot = 0;
        Norm = 0;
        for (i = 0; i < NDIM; i++) {
            amp = RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
            //amp1=RPSIO[i]*RPSI[i]+IPSIO[i]*IPSI[i];
            Norm = Norm + amp;
            Epot = Epot + amp * V[i];

        }
        su = 0;
        for (i = 0; i < NDIM ; i++) {
            su = su + c0*(RPSI[i] * RPSI[i ] + IPSI[i] * IPSI[i ]);
            if(i>0)su = su + c1*(RPSI[i] * RPSI[i-1 ] + IPSI[i] * IPSI[i-1 ]);
            if(i<NDIM-1)su = su + c1*(RPSI[i] * RPSI[i+1 ] + IPSI[i] * IPSI[i+1 ]);
            if(i>1)su = su + c2*(RPSI[i] * RPSI[i-2 ] + IPSI[i] * IPSI[i-2 ]);
            if(i<NDIM-2)su = su + c2*(RPSI[i] * RPSI[i+2 ] + IPSI[i] * IPSI[i+2 ]);
        }
           
        
        Ekin = su / dx2;

        jLabel2.setText("Norm=" + df1.format(Norm));
        jLabel3.setText("Epot=" + df1.format(Epot));
        jLabel4.setText("Ekin=" + df1.format(Ekin));
        jLabel5.setText("Etot=" + df1.format(Epot + Ekin));

        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




    }
                 void waves27p() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;
        int y1, y2, y3, i, j;
        double amp, su,rdel,imdel,amp1,norm1;
        
        
        double c0=49./36.;
        double c1=-3./4.;
        double c2=3./40.;
        double c3=-1./180.;
        /*
        double c0=1.0;
        double c1=-0.5;
        double c2=0.0;
        */

        for (il = 0; il < innerloops; il++) {

            {

                totaltime+=DELTAT;
                for (i = 0; i < NDIM; i++) {
                    
                    
                    rdel = (V[i] + c0 / dx2) * IPSI[i];
                    if (i > 0) {
                        rdel = rdel + c1 * IPSI[i - 1] / dx2;
                    }
                    if (i > 1) {
                        rdel = rdel + c2 * IPSI[i - 2] / dx2;
                    }
                    if (i > 2) {
                        rdel = rdel + c3 * IPSI[i - 3] / dx2;
                    }
                    if (i < NDIM - 1) {
                        rdel = rdel + c1 * IPSI[i + 1] / dx2;
                    }
                    if (i < NDIM - 2) {
                        rdel = rdel + c2 * IPSI[i + 2] / dx2;
                    }
                    if (i < NDIM - 3) {
                        rdel = rdel + c3 * IPSI[i + 3] / dx2;
                    }
                    rdel = 2.0 * rdel * DELTAT;

                    DRPSI[i] = rdel;

                    imdel = (V[i] + c0 / dx2) * RPSI[i];
                    if (i > 0) {
                        imdel = imdel + c1 * RPSI[i - 1] / dx2;
                    }
                    if (i > 1) {
                        imdel = imdel + c2 * RPSI[i - 2] / dx2;
                    }
                     if (i > 2) {
                        imdel = imdel + c3 * RPSI[i - 3] / dx2;
                    }
                    if (i < NDIM - 1) {
                        imdel = imdel + c1 * RPSI[i + 1] / dx2;
                    }
                    if (i < NDIM - 2) {
                        imdel = imdel + c2 * RPSI[i + 2] / dx2;
                    }
                     if (i < NDIM - 3) {
                        imdel = imdel + c3 * RPSI[i + 3] / dx2;
                    }

                    imdel = -2.0 * imdel * DELTAT;

                    DIPSI[i] = imdel;
                }
                   
                

                for (i = 0; i < NDIM; i++) {
                    
                    rdel=RPSI[i];
                    imdel=IPSI[i];
                    
                    RPSI[i] = RPSIO[i]+DRPSI[i];
                    IPSI[i] = IPSIO[i]+DIPSI[i];
                    
                    RPSIO[i]=rdel;
                    IPSIO[i]=imdel;
                }


            /*     normalize(); */

            }



        }


        Ekin = 0;
        Epot = 0;
        Norm = 0;
        for (i = 0; i < NDIM; i++) {
            amp = RPSI[i] * RPSI[i] + IPSI[i] * IPSI[i];
            //amp1=RPSIO[i]*RPSI[i]+IPSIO[i]*IPSI[i];
            Norm = Norm + amp;
            Epot = Epot + amp * V[i];

        }
        
        su=0;
        
        for (i = 0; i < NDIM ; i++) {
            su = su + c0*(RPSI[i] * RPSI[i ] + IPSI[i] * IPSI[i ]);
            if(i>0)su = su + c1*(RPSI[i] * RPSI[i-1 ] + IPSI[i] * IPSI[i-1 ]);
            if(i<NDIM-1)su = su + c1*(RPSI[i] * RPSI[i+1 ] + IPSI[i] * IPSI[i+1 ]);
            if(i>1)su = su + c2*(RPSI[i] * RPSI[i-2 ] + IPSI[i] * IPSI[i-2 ]);
            if(i<NDIM-2)su = su + c2*(RPSI[i] * RPSI[i+2 ] + IPSI[i] * IPSI[i+2 ]);
            if(i>2)su = su + c3*(RPSI[i] * RPSI[i-3 ] + IPSI[i] * IPSI[i-3 ]);
            if(i<NDIM-3)su = su + c3*(RPSI[i] * RPSI[i+3 ] + IPSI[i] * IPSI[i+3 ]);
        }
           
        
        Ekin = su / dx2;
        
       

        jLabel2.setText("Norm=" + df1.format(Norm));
        jLabel3.setText("Epot=" + df1.format(Epot));
        jLabel4.setText("Ekin=" + df1.format(Ekin));
        jLabel5.setText("Etot=" + df1.format(Epot + Ekin));

        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




    }


    void draw() {
        int y1, y2, y3, i, j;
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;

        //jLabel1.setText("time=" + df1.format(time_now));



        gb.clearRect(0, 0, 550, 600);

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) (V[i] * 10);
            y2 = 200 - (int) (V[i + 1] * 10);
            gb.drawLine(i, y1, i + 1, y2);
        }


        gb.setColor(Color.red);

        /*
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,RPSI[i],i+1,RPSI[i+1],1);
        for(i=0;i<NDIM;i++) WDrawLine(myworld,i,IPSI[i],i+1,IPSI[i+1],2);
         */

        for (i = 0; i < NDIM - 1; i++) {
            y1 = 200 - (int) ((IPSI[i] * IPSI[i] + RPSI[i] * RPSI[i]) * 1500.0);
            y2 = 200 - (int) ((IPSI[i + 1] * IPSI[i + 1] + RPSI[i + 1] * RPSI[i + 1]) * 1500.0);
            gb.drawLine(i, y1, i + 1, y2);
        }



        g2.drawImage(image, 0, 0, null);




        g2.drawImage(image, 0, 0, null);

    }

    public class myPanel extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(g);


            g2.drawImage(image, 0, 0, null);



        }
    }
}





