/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends JApplet
        implements ActionListener {

    DecimalFormat df, df1;
    Timer timer;
    Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int i, j, k, l, loop;
    double dxxt, tt, sp2, time_now, dxx, dv, da;
    double[] ampl;
    double[] velo;
    double[] oldsd;
    int NDIM = 500;
    int NITER = 10000;
    double space_grid = 0.001;  /* m */

    double time_grid = 0.001;  /* s */

    double c0s = 0.05;    /* m2/s2 */

    double c00s = 0.05;
    double dc = -0.005;
    double omega = 20.0;  /* 1/s */

    double omega0 = 20.0;
    double damp = 2.0;   /* 1/s */

    double TP = 0.1;
    double TP0 = 0.1;
    double cutoff = 0.4;
    double phase = 0.0;
    double refr = 1.0;
    double refr0 = 1.0;
    boolean nonlinear = false;
    int pulsetype = 0;
    int boundtype = 0;
    int anispeed=1;

    public void actionPerformed(ActionEvent e) {
        int iw;
        for(iw=0;iw<anispeed;iw++)waves();
        
        draw();
        timer.setInitialDelay(1);
        timer.setDelay(1);
        timer.restart();

    }

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    int i;
                    initComponents();

                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }




        df = new DecimalFormat("00.000E0");
        df1 = new DecimalFormat("0.000");

        ampl = new double[NDIM];
        velo = new double[NDIM];
        oldsd = new double[NDIM];

        image =
                new BufferedImage(550, 650, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 550, 650);


        cutofflabel.setText("pulse width=" + df1.format(TP));
        cutoffslider.setValue((int) (TP * 200));
        dampslider.setValue((int) (100 * damp));
        damplab.setText("damping=" + df1.format(damp));
        c0slider.setValue((int) (c0s * 100));
        c0lab.setText("velocity=Courant=" + df1.format(Math.sqrt(c0s)));
        refrslider.setValue((int) (100 * refr));
        refrlabel.setText("index of refr=" + df1.format(refr0));
        jSlider1.setValue(1);
        reset_all();
        timer = new Timer(10, this);
        timer.setInitialDelay(10);
        timer.start();


    //jPanel1.repaint();
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jPanel2 = new javax.swing.JPanel();
        dampslider = new javax.swing.JSlider();
        damplab = new javax.swing.JLabel();
        cutoffslider = new javax.swing.JSlider();
        cutofflabel = new javax.swing.JLabel();
        clearbutton = new javax.swing.JButton();
        jComboBox1 = new javax.swing.JComboBox();
        c0slider = new javax.swing.JSlider();
        c0lab = new javax.swing.JLabel();
        refrslider = new javax.swing.JSlider();
        refrlabel = new javax.swing.JLabel();
        jComboBox2 = new javax.swing.JComboBox();
        jSlider1 = new javax.swing.JSlider();
        jLabel2 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setDoubleBuffered(false);
        jPanel1.setMaximumSize(new java.awt.Dimension(500, 550));
        jPanel1.setMinimumSize(new java.awt.Dimension(500, 550));
        jPanel1.setPreferredSize(new java.awt.Dimension(500, 550));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 498, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 548, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setMaximumSize(new java.awt.Dimension(180, 550));
        jPanel2.setMinimumSize(new java.awt.Dimension(180, 550));
        jPanel2.setPreferredSize(new java.awt.Dimension(180, 550));

        dampslider.setMaximum(310);
        dampslider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                dampsliderMouseDragged(evt);
            }
        });

        damplab.setText("jLabel1");

        cutoffslider.setMajorTickSpacing(20);
        cutoffslider.setMaximum(200);
        cutoffslider.setMinimum(5);
        cutoffslider.setToolTipText("pulse period");
        cutoffslider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                cutoffsliderMouseReleased(evt);
            }
        });
        cutoffslider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                cutoffsliderMouseDragged(evt);
            }
        });

        cutofflabel.setText("jLabel1");

        clearbutton.setText("clear");
        clearbutton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearbuttonActionPerformed(evt);
            }
        });

        jComboBox1.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "continuous sine", "triangle pulse", "square puls", "Gaussian pulse", "pulse train" }));
        jComboBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox1ActionPerformed(evt);
            }
        });

        c0slider.setMinimum(2);
        c0slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                c0sliderMouseDragged(evt);
            }
        });

        c0lab.setText("jLabel1");

        refrslider.setMajorTickSpacing(20);
        refrslider.setMaximum(200);
        refrslider.setMinimum(2);
        refrslider.setToolTipText("");
        refrslider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                refrsliderMouseReleased(evt);
            }
        });
        refrslider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                refrsliderMouseDragged(evt);
            }
        });

        refrlabel.setText("jLabel1");

        jComboBox2.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "fixed end", "open end" }));
        jComboBox2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox2ActionPerformed(evt);
            }
        });

        jSlider1.setMajorTickSpacing(1);
        jSlider1.setMaximum(20);
        jSlider1.setMinimum(1);
        jSlider1.setPaintTicks(true);
        jSlider1.setSnapToTicks(true);
        jSlider1.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                jSlider1MouseDragged(evt);
            }
        });

        jLabel2.setText("animation speeed");

        jLabel1.setText("jLabel1");

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(56, 56, 56)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(damplab)
                            .addComponent(cutofflabel)
                            .addComponent(refrlabel)
                            .addComponent(jLabel2)
                            .addComponent(jLabel1)))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(42, 42, 42)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                            .addComponent(refrslider, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                            .addComponent(cutoffslider, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE)
                            .addComponent(c0slider, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(dampslider, javax.swing.GroupLayout.PREFERRED_SIZE, 0, Short.MAX_VALUE))))
                .addContainerGap(javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addComponent(c0lab, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(42, 42, 42)
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(jComboBox1, javax.swing.GroupLayout.Alignment.LEADING, 0, 135, Short.MAX_VALUE)
                            .addComponent(clearbutton, javax.swing.GroupLayout.DEFAULT_SIZE, 135, Short.MAX_VALUE)
                            .addComponent(jComboBox2, javax.swing.GroupLayout.Alignment.LEADING, 0, 135, Short.MAX_VALUE))))
                .addGap(33, 33, 33))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {c0slider, cutoffslider, dampslider, jSlider1, refrslider});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(damplab)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(dampslider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(c0lab)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(c0slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(cutofflabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cutoffslider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(refrlabel)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(refrslider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(31, 31, 31)
                .addComponent(jComboBox1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(jComboBox2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(33, 33, 33)
                .addComponent(clearbutton)
                .addGap(40, 40, 40)
                .addComponent(jLabel2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jSlider1, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(26, 26, 26)
                .addComponent(jLabel1)
                .addContainerGap(18, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.VERTICAL, new java.awt.Component[] {c0slider, cutoffslider, dampslider, jSlider1, refrslider});

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .addGap(44, 44, 44)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 212, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(340, 340, 340))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addContainerGap())
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addGap(226, 226, 226))))
        );
    }// </editor-fold>//GEN-END:initComponents
    private void dampsliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_dampsliderMouseDragged
        damp = dampslider.getValue() * 0.01;
        damplab.setText("damping=" + df1.format(damp));

    //ClearAverage();
    //jPanel1.repaint();// TODO add your handling code here:
}//GEN-LAST:event_dampsliderMouseDragged

    private void clearbuttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearbuttonActionPerformed
        int i;
        stop();
        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0;
            velo[i] = 0;
        }
        time_now = 0;
        phase = 0;
        TP = TP0;
        refr = refr0*refr0;
        start();

}//GEN-LAST:event_clearbuttonActionPerformed

    private void cutoffsliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutoffsliderMouseDragged

        cutofflabel.setText("pulse duration=" + df1.format(TP));//GEN-LAST:event_cutoffsliderMouseDragged
        double TP1;
        //stop();
        TP1 = cutoffslider.getValue() * 0.005;

        cutofflabel.setText("pulse width=" + df1.format(TP1));

    //reset_all();
    //start();
    }

    private void jComboBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox1ActionPerformed
        stop();
        pulsetype = jComboBox1.getSelectedIndex();
        reset_all();
        start();// TODO add your handling code here:
    }//GEN-LAST:event_jComboBox1ActionPerformed

    private void c0sliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_c0sliderMouseDragged

        c00s = c0slider.getValue() * 0.01;

        c0lab.setText("velocity=Courant=" + df1.format(Math.sqrt(c0s)));
    // TODO add your handling code here:
    }//GEN-LAST:event_c0sliderMouseDragged

    private void cutoffsliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutoffsliderMouseReleased
        // TODO add your handling code here:
        TP0 = cutoffslider.getValue() * 0.01;
        if (pulsetype == 0) {
            phase = phase + omega * time_now;

            time_now = 0.0;
        }
    }//GEN-LAST:event_cutoffsliderMouseReleased

    private void refrsliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_refrsliderMouseReleased
    // TODO add your handling code here:
}//GEN-LAST:event_refrsliderMouseReleased

    private void refrsliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_refrsliderMouseDragged
        refr0 = refrslider.getValue() * 0.01;
        refrlabel.setText("index of refr=" + df1.format(refr0));// TODO add your handling code here:
}//GEN-LAST:event_refrsliderMouseDragged

    private void jComboBox2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox2ActionPerformed
        boundtype = jComboBox2.getSelectedIndex();
    // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox2ActionPerformed

    private void jSlider1MouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_jSlider1MouseDragged
        anispeed=jSlider1.getValue();// TODO add your handling code here:
    }//GEN-LAST:event_jSlider1MouseDragged

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel c0lab;
    private javax.swing.JSlider c0slider;
    private javax.swing.JButton clearbutton;
    private javax.swing.JLabel cutofflabel;
    private javax.swing.JSlider cutoffslider;
    private javax.swing.JLabel damplab;
    private javax.swing.JSlider dampslider;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JComboBox jComboBox2;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JSlider jSlider1;
    private javax.swing.JLabel refrlabel;
    private javax.swing.JSlider refrslider;
    // End of variables declaration//GEN-END:variables
    void reset_all() {
        int i;

        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0.0;
            velo[i] = 0.0;
            oldsd[i] = 0.0;
        }

        sp2 = space_grid * space_grid;

        time_now = 0;
        phase = 0;
        TP = TP0;
    }

    /* monochromatic signal : */
    double signal_sin(double t) {
        //return 0.5*(1.0-Math.cos(omega * t));
        return 0.5 * (1 - Math.cos(omega * t + phase));
    }


    /* triangular pulse : */
    double signal_tr(double t) {
        if (t > TP) {
            return 0.0;
        } else {
            if (t < 0.5 * TP) {
                return (t * 2.0 / TP);
            } else {
                return (2.0 - t * 2.0 / TP);
            }
        }
    }

    /* square  pulse : */
    double signal_sq(double t) {
        if (t > TP) {
            return 0.0;
        } else {
            return 1.0;
        }
    }

    /* gaussian pulse : */
    double signal_g(double t) {
        double aa;
        aa = t / TP - 3.0;
        return Math.exp(-aa * aa);
    }


    /* pulse train : */
    double signal_train(double t) {
        if (t > 10.0 * TP) {
            return 0.0;
        } else {
            if (Math.sin(t * 6.28 / TP) > 0) {
                return 1.0;
            } else {
                return -1.0;
            }
        }
    }

    void waves() {




        c0s = c00s;


        if (pulsetype == 0) {

            omega0 = Math.PI / TP0;
            omega += (omega0 - omega) * 0.01;
            ampl[0] = signal_sin(time_now);
        }


        if (pulsetype == 1) {

            ampl[0] = signal_tr(time_now);
        }
        if (pulsetype == 2) {
            ampl[0] = signal_sq(time_now);
        }
        if (pulsetype == 3) {
            ampl[0] = signal_g(time_now);
        }
        if (pulsetype == 4) {
            ampl[0] = signal_train(time_now);
        }




        //


        time_now = time_now + time_grid;



        for (i = 1; i < NDIM - 1; i++) {
            dxx = (ampl[i + 1] + ampl[i - 1] - 2.0 * ampl[i]) / sp2;

            if (i < NDIM / 2) {
                dv = c0s * dxx - damp * velo[i];
            } else {
                dv = refr * c0s * dxx - damp * velo[i];
            }
            velo[i] = velo[i] + dv * time_grid;



        }


        if (boundtype == 0) {
            velo[NDIM - 1] = 0.0;
        } else {
            dxx = 2*(ampl[NDIM - 2] - ampl[NDIM - 1]) / sp2;

            dv = refr * c0s * dxx - damp * velo[NDIM - 1];
            velo[NDIM - 1] = velo[NDIM - 1] + dv * time_grid;

        }


        for (i = 1; i < NDIM; i++) {
            ampl[i] = ampl[i] + velo[i] * time_grid;
        }



    }

    void draw() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;

        jLabel1.setText("time=" + df1.format(time_now));

        gb.setColor(Color.white);
        gb.clearRect(0, 0, 550, 600);
        gb.setColor(Color.black);
        gb.drawLine(250, 0, 250, 600);
        gb.setColor(Color.red);
        for (i = 0; i < NDIM - 1; i++) {
            gb.drawLine(i, 300 - (int) (100 * ampl[i]), i + 1, 300 - (int) (100 * ampl[i + 1]));
        }





        g2.drawImage(image, 0, 0, null);

    }

    public class myPanel extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(g);


            g2.drawImage(image, 0, 0, null);



        }
    }
}



