/*
 * NewJApplet.java
 *
 * Created on February 13, 2008, 6:36 PM
 */

import java.awt.*;
import java.awt.event.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;
import java.awt.Graphics2D;
import java.awt.geom.*;
import java.text.*;
import java.io.*;
import java.util.*;
import javax.swing.*;
import java.awt.image.BufferedImage;

/**
 *
 * @author  root
 */
public class NewJApplet extends JApplet
        implements Runnable {

    DecimalFormat df, df1;
    Timer timer;
    volatile Thread calculatorThread;
    Graphics2D gb;
    BufferedImage image;
    int i, j, k, l, loop;
    double dxxt, tt, sp2, time_now, dxx, dv, da;
    double[] ampl;
    double[] velo;
    double[] oldsd;
    double[] deltav;
    double[] deltaa;
    double [] ampl1;
    double[]velo1;
    int NDIM = 500;
    int NITER = 10000;
    double space_grid = 0.001;  /* m */

    double time_grid = 0.001;  /* s */

    double c0s = 0.05; /* m2/s2 */
    double c0=0.25;
    double c00s = 0.05;
    double dc = -0.005;
    double omega = 20.0;  /* 1/s */

    double omega0 = 20.0;
    double damp = 2.0;   /* 1/s */

    double TP = 0.1;
    double TP0 = 0.1;
    double cutoff = 0.4;
    double phase = 0.0;
    double refr = 1.0;
    double refr0 = 1.0;
    boolean nonlinear = false;
    int pulsetype = 0;
    int boundtype = 0;
    int method=0;
    boolean periodic=true;

    /** Initializes the applet NewJApplet */
    public void init() {
        try {
            java.awt.EventQueue.invokeAndWait(new Runnable() {

                public void run() {
                    int i;
                    initComponents();

                }
            });
        } catch (Exception ex) {
            ex.printStackTrace();
        }




        df = new DecimalFormat("00.000E0");
        df1 = new DecimalFormat("0.000");

        ampl = new double[NDIM];
        velo = new double[NDIM+1];
        ampl1 = new double[NDIM];
        velo1 = new double[NDIM+1];
        oldsd = new double[NDIM];
        deltav=new double[NDIM+1];
        deltaa=new double[NDIM];

        image =
                new BufferedImage(550, 650, BufferedImage.TYPE_INT_RGB);
        gb = (Graphics2D) image.createGraphics();
        gb.setBackground(Color.white);
        gb.clearRect(0, 0, 550, 650);


        cutofflabel.setText("pulse width=" + df1.format(TP));
        cutoffslider.setValue((int) (TP * 200));
        
        c0slider.setValue((int) (c0s * 100));
        c0lab.setText("velocity=Courant=" + df1.format(Math.sqrt(c0s)));
        
        stop();
        reset_all();
        initval();
        start();


    //jPanel1.repaint();
    }

    public void run() {
        int i;

        while (Thread.currentThread() == calculatorThread) {

            waves();

        }
    }

    public void start() {
        if (calculatorThread == null) {
            calculatorThread = new Thread(this);
            calculatorThread.start();
        }
    }

    public void stop() {

        Thread tmpBlinker = calculatorThread;;
        calculatorThread = null;
        if (tmpBlinker != null) {
            tmpBlinker.interrupt();
        }
        try {

            Thread.currentThread().sleep(100);
        } catch (InterruptedException ie) {
//If this thread was intrrupted by nother thread 
        }
    }

    /** This method is called from within the init() method to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new myPanel();
        jPanel2 = new javax.swing.JPanel();
        cutoffslider = new javax.swing.JSlider();
        cutofflabel = new javax.swing.JLabel();
        clearbutton = new javax.swing.JButton();
        jLabel1 = new javax.swing.JLabel();
        c0slider = new javax.swing.JSlider();
        c0lab = new javax.swing.JLabel();
        jComboBox3 = new javax.swing.JComboBox();
        jButton1 = new javax.swing.JButton();
        jButton2 = new javax.swing.JButton();
        jButton3 = new javax.swing.JButton();
        jButton4 = new javax.swing.JButton();

        jPanel1.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel1.setDoubleBuffered(false);
        jPanel1.setMaximumSize(new java.awt.Dimension(500, 550));
        jPanel1.setMinimumSize(new java.awt.Dimension(500, 550));
        jPanel1.setPreferredSize(new java.awt.Dimension(500, 550));

        javax.swing.GroupLayout jPanel1Layout = new javax.swing.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 523, Short.MAX_VALUE)
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGap(0, 548, Short.MAX_VALUE)
        );

        jPanel2.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(0, 0, 0)));
        jPanel2.setMaximumSize(new java.awt.Dimension(120, 550));
        jPanel2.setMinimumSize(new java.awt.Dimension(120, 550));
        jPanel2.setPreferredSize(new java.awt.Dimension(120, 550));

        cutoffslider.setMajorTickSpacing(20);
        cutoffslider.setMaximum(200);
        cutoffslider.setMinimum(5);
        cutoffslider.setToolTipText("pulse period");
        cutoffslider.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseReleased(java.awt.event.MouseEvent evt) {
                cutoffsliderMouseReleased(evt);
            }
        });
        cutoffslider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                cutoffsliderMouseDragged(evt);
            }
        });

        cutofflabel.setText("jLabel1");

        clearbutton.setText("start");
        clearbutton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                clearbuttonActionPerformed(evt);
            }
        });

        jLabel1.setText("jLabel1");

        c0slider.setMinimum(2);
        c0slider.addMouseMotionListener(new java.awt.event.MouseMotionAdapter() {
            public void mouseDragged(java.awt.event.MouseEvent evt) {
                c0sliderMouseDragged(evt);
            }
        });

        c0lab.setText("jLabel1");

        jComboBox3.setModel(new javax.swing.DefaultComboBoxModel(new String[] { "leap frog", "LW", "ICN" }));
        jComboBox3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBox3ActionPerformed(evt);
            }
        });

        jButton1.setText("stop");
        jButton1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton1ActionPerformed(evt);
            }
        });

        jButton2.setText("Gaussian");
        jButton2.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton2ActionPerformed(evt);
            }
        });

        jButton3.setText("Triangular");
        jButton3.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton3ActionPerformed(evt);
            }
        });

        jButton4.setText("Rectangular");
        jButton4.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButton4ActionPerformed(evt);
            }
        });

        javax.swing.GroupLayout jPanel2Layout = new javax.swing.GroupLayout(jPanel2);
        jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(cutofflabel, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(c0lab, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addGap(45, 45, 45)
                        .addComponent(jLabel1))
                    .addGroup(jPanel2Layout.createSequentialGroup()
                        .addContainerGap()
                        .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.TRAILING, false)
                                .addComponent(jComboBox3, javax.swing.GroupLayout.Alignment.LEADING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jButton2, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jButton3, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                .addComponent(jButton4, javax.swing.GroupLayout.Alignment.LEADING, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                            .addGroup(jPanel2Layout.createSequentialGroup()
                                .addComponent(jButton1)
                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                                .addComponent(clearbutton))))
                    .addComponent(c0slider, javax.swing.GroupLayout.PREFERRED_SIZE, 117, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(cutoffslider, javax.swing.GroupLayout.PREFERRED_SIZE, 125, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addGap(0, 75, Short.MAX_VALUE))
        );

        jPanel2Layout.linkSize(javax.swing.SwingConstants.HORIZONTAL, new java.awt.Component[] {c0slider, cutoffslider});

        jPanel2Layout.setVerticalGroup(
            jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(jPanel2Layout.createSequentialGroup()
                .addGap(21, 21, 21)
                .addComponent(c0lab, javax.swing.GroupLayout.PREFERRED_SIZE, 23, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(c0slider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(18, 18, 18)
                .addComponent(cutofflabel, javax.swing.GroupLayout.PREFERRED_SIZE, 21, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(cutoffslider, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(55, 55, 55)
                .addComponent(jComboBox3, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(36, 36, 36)
                .addGroup(jPanel2Layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jButton1)
                    .addComponent(clearbutton))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButton2)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButton3)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addComponent(jButton4)
                .addGap(39, 39, 39)
                .addComponent(jLabel1)
                .addContainerGap(116, Short.MAX_VALUE))
        );

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, 525, Short.MAX_VALUE)
                .addGap(44, 44, 44)
                .addComponent(jPanel2, javax.swing.GroupLayout.PREFERRED_SIZE, 220, javax.swing.GroupLayout.PREFERRED_SIZE)
                .addGap(307, 307, 307))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(jPanel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(jPanel2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap(226, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents

    private void clearbuttonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_clearbuttonActionPerformed
        int i;
       
        drawwaves();
        start();
        

}//GEN-LAST:event_clearbuttonActionPerformed

    private void cutoffsliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutoffsliderMouseDragged

        cutofflabel.setText("pulse duration=" + df1.format(TP));//GEN-LAST:event_cutoffsliderMouseDragged
        double TP1;
        stop();
        TP0 = cutoffslider.getValue() * 0.01;
        TP=TP0;

        cutofflabel.setText("pulse width=" + df1.format(TP0));
        initval();
        drawwaves();
        jPanel1.repaint();

    //reset_all();
    //start();
    }

    private void c0sliderMouseDragged(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_c0sliderMouseDragged

        c00s = c0slider.getValue() * 0.01;

        c0lab.setText("velocity=Courant=" + df1.format(Math.sqrt(c00s)));
    // TODO add your handling code here:
    }//GEN-LAST:event_c0sliderMouseDragged

    private void cutoffsliderMouseReleased(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_cutoffsliderMouseReleased
        // TODO add your handling code here:
        TP0 = cutoffslider.getValue() * 0.01;
       initval();
        drawwaves();
    }//GEN-LAST:event_cutoffsliderMouseReleased

    private void jComboBox3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBox3ActionPerformed
        stop(); 
        method = jComboBox3.getSelectedIndex();
        //initval();
        //drawwaves();
        start();
        // TODO add your handling code here:
    }//GEN-LAST:event_jComboBox3ActionPerformed

    private void jButton2ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton2ActionPerformed
         int i;
        stop();
        
        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0;
            velo[i] = 0;
            deltaa[i]=0;
            deltav[i]=0;
        }
        time_now = 0;
        phase = 0;
        TP = TP0;
        refr = refr0;
        pulsetype=0;
        initval();  drawwaves();   // TODO add your handling code here:
    }//GEN-LAST:event_jButton2ActionPerformed

    private void jButton1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton1ActionPerformed
      stop();  // TODO add your handling code here:
    }//GEN-LAST:event_jButton1ActionPerformed

    private void jButton3ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton3ActionPerformed
        int i;
        stop();
        
        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0;
            velo[i] = 0;
            deltaa[i]=0;
            deltav[i]=0;
        }
        time_now = 0;
        phase = 0;
        TP = TP0;
        refr = refr0;
        pulsetype=1;
        initval(); drawwaves();
        
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton3ActionPerformed

    private void jButton4ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButton4ActionPerformed
       int i;
        stop();
        
        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0;
            velo[i] = 0;
            deltaa[i]=0;
            deltav[i]=0;
        }
        time_now = 0;
        phase = 0;
        TP = TP0;
        refr = refr0;
        pulsetype=2;
        initval();  drawwaves();
     
        // TODO add your handling code here:
    }//GEN-LAST:event_jButton4ActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel c0lab;
    private javax.swing.JSlider c0slider;
    private javax.swing.JButton clearbutton;
    private javax.swing.JLabel cutofflabel;
    private javax.swing.JSlider cutoffslider;
    private javax.swing.JButton jButton1;
    private javax.swing.JButton jButton2;
    private javax.swing.JButton jButton3;
    private javax.swing.JButton jButton4;
    private javax.swing.JComboBox jComboBox3;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    // End of variables declaration//GEN-END:variables
    void reset_all() {
        int i;

        for (i = 0; i < NDIM; i++) {
            ampl[i] = 0.0;
            velo[i] = 0.0;
            oldsd[i] = 0.0;
        }

        sp2 = space_grid * space_grid;

        time_now = 0;
        phase = 0;
        TP = TP0;
    }

   


    /* triangular pulse : */
    double signal_tr(double t) {
        double t2;
        t2=2*t;
        if ( (t2 > 0.5+TP/4) || (t2<0.5-TP/4)) {
            return 0.0;
        } else {
            if (t2 < 0.5) {
                return (1+4*(t2-0.5) / TP);
            } else {
                return (1+4*(0.5-t2) / TP);
            }
        }
    }

    /* square  pulse : */
    double signal_sq(double t) {
        double t2;
        t2=2*t;
        if ( (t2 > 0.5+TP/4) || (t2<0.5-TP/4)) {
            return 0.0;
        } else {
            return 1.0;
        }
    }

    /* gaussian pulse : */
    double signal_g(double t) {
        double t2;
        t2=2*t;
        double aa;
        aa = 5*(t2-0.5) / TP ;
        return Math.exp(-aa * aa);
    }


   
    void initval(){
        double time0,time_ad;
        int ip;
        
        
        time_now=0;
        for(i=0;i<NDIM;i++){
            
            time_now=i*time_grid;
            ip=i;
            
            if (method==0)
            {
            time_ad=time_now+time_grid;
            ip=ip;
            if(ip==NDIM) ip=0;
            }
            else
            
                time_ad=time_now;
            
            
           

        if (pulsetype == 1) {

            ampl[i] = signal_tr(time_now);
             velo[ip]=-signal_tr(time_ad);
        }
        if (pulsetype == 2) {
            ampl[i] = signal_sq(time_now);
              velo[ip]=-signal_sq(time_ad);
        }
        if (pulsetype == 0) {
            ampl[i] = signal_g(time_now);
              velo[ip]=-signal_g(time_ad); 
        }
        
        }
        time_now=0;
    }
    void drawwaves(){
        
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;

        gb.setColor(Color.white);
        gb.clearRect(0, 0, 550, 600);
        gb.setColor(Color.black);
        
        gb.setColor(Color.red);
        for (i = 0; i < NDIM - 1; i++) {
            gb.drawLine(i, 300 - (int) (100 * ampl[i]), i + 1, 300 - (int) (100 * ampl[i + 1]));
        }

        gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            gb.drawLine(i, 300 - (int) (100 * velo[i]), i + 1, 300 - (int) (100 * velo[i + 1]));
        }



        g2.drawImage(image, 0, 0, null);

        
    }
    
    

    void waves() {
        Graphics g = jPanel1.getGraphics();

        Graphics2D g2 = (Graphics2D) g;



        c0s = c00s;
        c0=Math.sqrt(c0s);
        
        
        
       

        //

         
     
        
        time_now = time_now + time_grid;

        jLabel1.setText("time=" + df1.format(time_now));

        if(method==0 &&periodic==false){
        
        
        for (i = 0; i < NDIM - 1; i++) {
         
            
            dv=c0*(ampl[i+1]-ampl[i])/space_grid;
            
            velo[i] = velo[i] + dv * time_grid;



        }
        

            dv=-ampl[NDIM-1]/space_grid;
            velo[NDIM - 1] = velo[NDIM-1]+dv*time_grid;
 
        for (i = 1; i < NDIM; i++) {
            dv=c0*(velo[i]-velo[i-1])/space_grid;
            ampl[i] = ampl[i] + dv * time_grid;
        }


        }
        
        if(method==0 &&periodic==true){
        
        
        for (i = 0; i < NDIM - 1; i++) {
         
            
            dv=c0*(ampl[i+1]-ampl[i])/space_grid;
            
            velo[i] = velo[i] + dv * time_grid;



        }
            dv=c0*(ampl[0]-ampl[NDIM-1])/space_grid;
            
            velo[NDIM-1] = velo[NDIM-1] + dv * time_grid;
        

 
        for (i = 1; i < NDIM; i++) {
            dv=c0*(velo[i]-velo[i-1])/space_grid;
            ampl[i] = ampl[i] + dv * time_grid;
        }

            dv=c0*(velo[0]-velo[NDIM-1])/space_grid;
            ampl[0] = ampl[0] + dv * time_grid;
        }
        
        
        if(method==1 && periodic==false){
            
            dv=c0*(ampl[1]-ampl[0])/space_grid+c0s*0.5*(2*velo[1]-2*velo[0])*time_grid/sp2;
            deltav[0]=dv;
            
             dv=c0*0.5*(-ampl[NDIM-1])/space_grid+c0s*0.5*(velo[NDIM-1]-2*velo[NDIM])*time_grid/sp2;
             deltav[NDIM]=dv;
            
               for(i=1; i<NDIM-1;i++){
                   
            dv=c0*0.5*(velo[i+1]-velo[i-1])/space_grid+c0s*0.5*(ampl[i+1]+ampl[i-1]-2*ampl[i])*time_grid/sp2;
            deltaa[i]=dv;
            
            dv=c0*0.5*(ampl[i+1]-ampl[i-1])/space_grid+c0s*0.5*(velo[i+1]+velo[i-1]-2*velo[i])*time_grid/sp2;
            deltav[i]=dv;

            
               }
            
             dv=c0*0.5*(velo[NDIM-1]-velo[NDIM-2])/space_grid+c0s*0.5*(ampl[NDIM-2]-2*ampl[NDIM-1])*time_grid/sp2;
             deltaa[NDIM-1]=dv;
            
            
         
                 dv=c0*0.5*(-ampl[NDIM-2])/space_grid+c0s*0.5*(velo[NDIM-1]+velo[NDIM-2]-2*velo[NDIM-1])*time_grid/sp2;
             deltav[NDIM-1]=dv;
             



                
                
                velo[0]=velo[0]+deltav[0]*time_grid;
                velo[NDIM]=velo[NDIM]+deltav[NDIM]*time_grid;
                
            
            
            for(i=1;i<NDIM;i++){
                        ampl[i]=ampl[i]+deltaa[i]*time_grid;
                        velo[i]=velo[i]+deltav[i]*time_grid;
            
            }}
         if(method==1 && periodic==true){
            
            dv=c0*0.5*(ampl[1]-ampl[NDIM-1])/space_grid+c0s*0.5*(velo[NDIM-1]+velo[1]-2*velo[0])*time_grid/sp2;
            deltav[0]=dv;
            dv=c0*0.5*(velo[1]-velo[NDIM-1])/space_grid+c0s*0.5*(ampl[1]+ampl[NDIM-1]-2*ampl[0])*time_grid/sp2;
            deltaa[0]=dv;
           
            
               for(i=1; i<NDIM-1;i++){
                   
            dv=c0*0.5*(velo[i+1]-velo[i-1])/space_grid+c0s*0.5*(ampl[i+1]+ampl[i-1]-2*ampl[i])*time_grid/sp2;
            deltaa[i]=dv;
            
            dv=c0*0.5*(ampl[i+1]-ampl[i-1])/space_grid+c0s*0.5*(velo[i+1]+velo[i-1]-2*velo[i])*time_grid/sp2;
            deltav[i]=dv;

            
               }
            
             dv=c0*0.5*(velo[0]-velo[NDIM-2])/space_grid+c0s*0.5*(ampl[0]+ampl[NDIM-2]-2*ampl[NDIM-1])*time_grid/sp2;
             deltaa[NDIM-1]=dv;
            
            
         
             dv=c0*0.5*(ampl[0]-ampl[NDIM-2])/space_grid+c0s*0.5*(velo[0]+velo[NDIM-2]-2*velo[NDIM-1])*time_grid/sp2;
             deltav[NDIM-1]=dv;
             



            
            
            
            for(i=0;i<NDIM;i++){
                        ampl[i]=ampl[i]+deltaa[i]*time_grid;
                        velo[i]=velo[i]+deltav[i]*time_grid;
            
            }}
        
         if(method==2 &&periodic==true){
        
        
        
             // calculate first estimate f(n+1/2)             
             
        for (i = 1; i < NDIM - 1; i++) {         

            dv=c0*(ampl[i+1]-ampl[i-1])/space_grid;
            velo1[i] = velo[i] + 0.25*dv * time_grid;
            dv=c0*(velo[i+1]-velo[i-1])/space_grid;
            ampl1[i] = ampl[i] + 0.25*dv * time_grid;

        }
            dv=c0*(ampl[1]-ampl[NDIM-1])/space_grid;            
            velo1[0] = velo[0] + 0.25*dv * time_grid;    
            dv=c0*(velo[1]-velo[NDIM-1])/space_grid;
            ampl1[0] = ampl[0] + 0.25*dv * time_grid;
 
            
            dv=c0*(ampl[0]-ampl[NDIM-2])/space_grid;            
            velo1[NDIM-1] = velo[NDIM-1] + 0.25*dv * time_grid;                   
            dv=c0*(velo[0]-velo[NDIM-2])/space_grid;
            ampl1[NDIM-1] = ampl[NDIM-1] + 0.25*dv * time_grid;
            
            
            
 
            
            
           // now calculate first estimate f(n+1)
         
            for (i = 1; i < NDIM - 1; i++) {         

            dv=c0*(ampl1[i+1]-ampl1[i-1])/space_grid;
            deltav[i] = velo[i] + 0.5*dv * time_grid;
            dv=c0*(velo1[i+1]-velo1[i-1])/space_grid;
            deltaa[i] = ampl[i] + 0.5*dv * time_grid;

        }
            dv=c0*(ampl1[0]-ampl1[NDIM-2])/space_grid;            
            deltav[NDIM-1] = velo[NDIM-1] + 0.5*dv * time_grid;    
            dv=c0*(velo1[0]-velo1[NDIM-2])/space_grid;
            deltaa[NDIM-1] = ampl[NDIM-1] + 0.5*dv * time_grid;
            
            
            dv=c0*(ampl1[1]-ampl1[NDIM-1])/space_grid;            
            deltav[0] = velo[0] + 0.5*dv * time_grid;             
            dv=c0*(velo1[1]-velo1[NDIM-1])/space_grid;
            deltaa[0] = ampl[0] + 0.5*dv * time_grid;
           
 
         
             // calculate second estimate f(n+1/2)             
             
        for (i = 0; i < NDIM ; i++) {         

           
            velo1[i] = 0.5*(velo[i]+deltav[i]);
            ampl1[i] = 0.5*(ampl[i]+deltaa[i]);

        }
                     
        
        
           // finally calculate second estimate f(n+1)
         
            for (i = 1; i < NDIM - 1; i++) {         

            dv=c0*(ampl1[i+1]-ampl1[i-1])/space_grid;
            velo[i] = velo[i] + 0.5*dv * time_grid;
            dv=c0*(velo1[i+1]-velo1[i-1])/space_grid;
            ampl[i] = ampl[i] + 0.5*dv * time_grid;

        }
            dv=c0*(ampl1[0]-ampl1[NDIM-2])/space_grid;            
            velo[NDIM-1] = velo[NDIM-1] + 0.5*dv * time_grid;    
            dv=c0*(velo1[0]-velo1[NDIM-2])/space_grid;
            ampl[NDIM-1] = ampl[NDIM-1] + 0.5*dv * time_grid;
            
            
            dv=c0*(ampl1[1]-ampl1[NDIM-1])/space_grid;            
            velo[0] = velo[0] + 0.5*dv * time_grid;
            dv=c0*(velo1[1]-velo1[NDIM-1])/space_grid;
            ampl[0] = ampl[0] + 0.5*dv * time_grid;
          
         
}
         //for(i=0;i<NDIM;i++){
         //jTextArea1.append(i+" "+ampl[i]+" "+velo[i]+"\n");
         //}
         
         //stop();
         
        gb.setColor(Color.white);
        gb.clearRect(0, 0, 550, 600);
        gb.setColor(Color.black);
        
        gb.setColor(Color.red);
        for (i = 0; i < NDIM - 1; i++) {
            gb.drawLine(i, 300 - (int) (100 * ampl[i]), i + 1, 300 - (int) (100 * ampl[i + 1]));
        }

            gb.setColor(Color.blue);
        for (i = 0; i < NDIM - 1; i++) {
            gb.drawLine(i, 300 - (int) (100 * velo[i]), i + 1, 300 - (int) (100 * velo[i + 1]));
        }



        g2.drawImage(image, 0, 0, null);

    }

    public class myPanel extends javax.swing.JPanel {

        int iy0, iy1, ix0, ix1;
        double tscale;

        public void paint(Graphics g) {
            int ix, iy, ir, ix5, ix10, ix15, ix20, ix25, k, i, j;
            double xp, yp;
            Graphics2D g2 = (Graphics2D) g;
            int size = 200;

            //if(count==0) {super.paintComponent(g);

            //}

            super.paintComponent(g);


            g2.drawImage(image, 0, 0, null);



        }
    }
}



