(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     29571,        968]*)
(*NotebookOutlinePosition[     30253,        991]*)
(*  CellTagsIndexPosition[     30209,        987]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["\<\
Calculation of the Ricci Tensor of the Reissner Nordstrom metric using 
the package metrigrav\
\>", "Title"],

Cell[TextData[{
  "\nThis Notebook contains an example of the use of the packgage ",
  StyleBox["metrigrav. \n",
    FontWeight->"Bold"],
  StyleBox["We calculate the Ricci tensor of the Reissner Nordstrom metric.",
    FontVariations->{"CompatibilityType"->0}]
}], "Text",
  FontSize->16],

Cell[TextData[{
  "\nFirst we initialize the programme by typing the command ",
  StyleBox["mainmetric",
    FontWeight->"Bold"]
}], "Caption",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(mainmetric\)\)\)], "Input",
  CellLabel->"In[31]:="],

Cell[BoxData[
    \("OK I calculate your space, Give me the data"\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \("Give me the dimension of your space"\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    InterpretationBox[\("Your space has dimension n = "\[InvisibleSpace]4\),
      SequenceForm[ "Your space has dimension n = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    InterpretationBox[\("Now I stop and you give me two vectors of dimension \
"\[InvisibleSpace]4\),
      SequenceForm[ 
      "Now I stop and you give me two vectors of dimension ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \("vector coordi = vector of coordinates"\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \("vector diffe = vector of differentials"\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \("Next you give me the metric as ds2 = "\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \("Then to resume calculation you print metricresume"\)], "Print",
  CellLabel->"From In[31]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[31]="]
}, Open  ]],

Cell["\<\
Then we insert the required input data
\
\>", "Caption",
  FontSize->16],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(coordi = {t, 
          r, \[Theta], \[CurlyPhi]};\)\)\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(diffe = {dt, dr, d\[Theta], 
          d\[CurlyPhi]};\)\)\)], "Input",
  CellLabel->"In[33]:="],

Cell[BoxData[
    \(\(ds2 = \(-\((1 - A\/r + Q\/r\^2)\)\)*
            dt\^2 + \((1 - A\/r + Q\/r\^2)\)\^\(-1\)*dr\^2 + 
          r\^2*Sin[\[Theta]]\^2*d\[CurlyPhi]\^2 + 
          r\^2*d\[Theta]\^2;\)\)], "Input",
  CellLabel->"In[34]:="],

Cell[TextData[{
  "\nand we continue the calculation typing ",
  StyleBox["metricresume",
    FontWeight->"Bold"]
}], "Caption",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(metricresume\)], "Input",
  CellLabel->"In[35]:="],

Cell[BoxData[
    \("I resume the calculation"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("First I extract the metric coefficients from your data"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Then I calculate the inverse metric"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Done !"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("and I calculate also the metric determinant"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Done"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("I perform the calculation of the Christoffel symbols"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("-----------------"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("I finished"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("the Levi Civita connection  is given by:"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]1\[InvisibleSpace]\
1\[InvisibleSpace]"] = "\[InvisibleSpace]\(dr\ \((\(-2\)\ Q + A\ r)\)\)\/\(2\ \
r\ \((Q + r\ \((\(-A\) + r)\))\)\)\),
      SequenceForm[ "\[CapitalGamma][", 1, 1, "] = ", 
        Times[ 
          Rational[ 1, 2], dr, 
          Power[ r, -1], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]1\[InvisibleSpace]\
2\[InvisibleSpace]"] = "\[InvisibleSpace]\(dt\ \((\(-2\)\ Q + A\ r)\)\)\/\(2\ \
r\ \((Q + r\ \((\(-A\) + r)\))\)\)\),
      SequenceForm[ "\[CapitalGamma][", 1, 2, "] = ", 
        Times[ 
          Rational[ 1, 2], dt, 
          Power[ r, -1], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]1\[InvisibleSpace]\
3\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[CapitalGamma][", 1, 3, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]1\[InvisibleSpace]\
4\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[CapitalGamma][", 1, 4, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]2\[InvisibleSpace]\
1\[InvisibleSpace]"] = "\[InvisibleSpace]\(dt\ \((\(-2\)\ Q + A\ r)\)\ \((Q + \
r\ \((\(-A\) + r)\))\)\)\/\(2\ r\^5\)\),
      SequenceForm[ "\[CapitalGamma][", 2, 1, "] = ", 
        Times[ 
          Rational[ 1, 2], dt, 
          Power[ r, -5], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Plus[ Q, 
            Times[ r, 
              Plus[ 
                Times[ -1, A], r]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]2\[InvisibleSpace]\
2\[InvisibleSpace]"] = "\[InvisibleSpace]\(dr\ \((2\ Q - A\ r)\)\)\/\(2\ Q\ r \
- 2\ A\ r\^2 + 2\ r\^3\)\),
      SequenceForm[ "\[CapitalGamma][", 2, 2, "] = ", 
        Times[ dr, 
          Plus[ 
            Times[ 2, Q], 
            Times[ -1, A, r]], 
          Power[ 
            Plus[ 
              Times[ 2, Q, r], 
              Times[ -2, A, 
                Power[ r, 2]], 
              Times[ 2, 
                Power[ r, 3]]], -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]2\[InvisibleSpace]\
3\[InvisibleSpace]"] = "\[InvisibleSpace]\(d\[Theta]\ \((A - \(Q + r\^2\)\/r)\
\)\)\),
      SequenceForm[ "\[CapitalGamma][", 2, 3, "] = ", 
        Times[ d\[Theta], 
          Plus[ A, 
            Times[ -1, 
              Power[ r, -1], 
              Plus[ Q, 
                Power[ r, 2]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]2\[InvisibleSpace]\
4\[InvisibleSpace]"] = "\[InvisibleSpace]\(-\(\(d\[CurlyPhi]\ \((Q + 
                    r\ \((\(-A\) + r)\))\)\ Sin[\[Theta]]\^2\)\/r\)\)\),
      SequenceForm[ "\[CapitalGamma][", 2, 4, "] = ", 
        Times[ -1, d\[CurlyPhi], 
          Power[ r, -1], 
          Plus[ Q, 
            Times[ r, 
              Plus[ 
                Times[ -1, A], r]]], 
          Power[ 
            Sin[ \[Theta]], 2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]3\[InvisibleSpace]\
1\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[CapitalGamma][", 3, 1, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]3\[InvisibleSpace]\
2\[InvisibleSpace]"] = "\[InvisibleSpace]d\[Theta]\/r\),
      SequenceForm[ "\[CapitalGamma][", 3, 2, "] = ", 
        Times[ d\[Theta], 
          Power[ r, -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]3\[InvisibleSpace]\
3\[InvisibleSpace]"] = "\[InvisibleSpace]dr\/r\),
      SequenceForm[ "\[CapitalGamma][", 3, 3, "] = ", 
        Times[ dr, 
          Power[ r, -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]3\[InvisibleSpace]\
4\[InvisibleSpace]"] = "\[InvisibleSpace]\(\(-d\[CurlyPhi]\)\ Cos[\[Theta]]\ \
Sin[\[Theta]]\)\),
      SequenceForm[ "\[CapitalGamma][", 3, 4, "] = ", 
        Times[ -1, d\[CurlyPhi], 
          Cos[ \[Theta]], 
          Sin[ \[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]4\[InvisibleSpace]\
1\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[CapitalGamma][", 4, 1, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]4\[InvisibleSpace]\
2\[InvisibleSpace]"] = "\[InvisibleSpace]d\[CurlyPhi]\/r\),
      SequenceForm[ "\[CapitalGamma][", 4, 2, "] = ", 
        Times[ d\[CurlyPhi], 
          Power[ r, -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]4\[InvisibleSpace]\
3\[InvisibleSpace]"] = "\[InvisibleSpace]\(d\[CurlyPhi]\ Cot[\[Theta]]\)\),
      SequenceForm[ "\[CapitalGamma][", 4, 3, "] = ", 
        Times[ d\[CurlyPhi], 
          Cot[ \[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("\[CapitalGamma]["\[InvisibleSpace]4\[InvisibleSpace]\
4\[InvisibleSpace]"] = "\[InvisibleSpace]\(dr\/r + 
          d\[Theta]\ Cot[\[Theta]]\)\),
      SequenceForm[ "\[CapitalGamma][", 4, 4, "] = ", 
        Plus[ 
          Times[ dr, 
            Power[ r, -1]], 
          Times[ d\[Theta], 
            Cot[ \[Theta]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Task finished"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("The result is encoded in a tensor Gam[a,b,c]"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("-----------------"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \(" Now I calculate the Riemann tensor"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("I tell you my steps :"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]1\),
      SequenceForm[ " a = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]2\),
      SequenceForm[ " a = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]3\),
      SequenceForm[ " a = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]4\),
      SequenceForm[ " a = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Finished"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("-------------------------"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Now I evaluate the curvature 2-form of your space"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("I find the following answer"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]1\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "R[", 1, 1, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((\(-3\)\ Q + A\ r)\)\ dt ** \
dr\)\/\(r\^2\ \((Q + r\ \((\(-A\) + r)\))\)\)\),
      SequenceForm[ "R[", 1, 2, "] = ", 
        Times[ 
          Power[ r, -2], 
          Plus[ 
            Times[ -3, Q], 
            Times[ A, r]], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1], 
          NonCommutativeMultiply[ dt, dr]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((2\ Q - A\ r)\)\ dt ** \
d\[Theta]\)\/\(2\ r\^2\)\),
      SequenceForm[ "R[", 1, 3, "] = ", 
        Times[ 
          Rational[ 1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ 2, Q], 
            Times[ -1, A, r]], 
          NonCommutativeMultiply[ dt, d\[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(-\(\(\((\(-2\)\ Q + A\ r)\)\ dt ** 
                  d\[CurlyPhi]\ Sin[\[Theta]]\^2\)\/\(2\ r\^2\)\)\)\),
      SequenceForm[ "R[", 1, 4, "] = ", 
        Times[ 
          Rational[ -1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          NonCommutativeMultiply[ dt, d\[CurlyPhi]], 
          Power[ 
            Sin[ \[Theta]], 2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]1\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((\(-3\)\ Q\^2 + Q\ \((4\ A - 3\ \
r)\)\ r + A\ r\^2\ \((\(-A\) + r)\))\)\ dt ** dr\)\/r\^6\),
      SequenceForm[ "R[", 2, 1, "] = ", 
        Times[ 
          Power[ r, -6], 
          Plus[ 
            Times[ -3, 
              Power[ Q, 2]], 
            Times[ Q, 
              Plus[ 
                Times[ 4, A], 
                Times[ -3, r]], r], 
            Times[ A, 
              Power[ r, 2], 
              Plus[ 
                Times[ -1, A], r]]], 
          NonCommutativeMultiply[ dt, dr]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "R[", 2, 2, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((2\ Q - A\ r)\)\ dr ** \
d\[Theta]\)\/\(2\ r\^2\)\),
      SequenceForm[ "R[", 2, 3, "] = ", 
        Times[ 
          Rational[ 1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ 2, Q], 
            Times[ -1, A, r]], 
          NonCommutativeMultiply[ dr, d\[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(-\(\(\((\(-2\)\ Q + A\ r)\)\ dr ** 
                  d\[CurlyPhi]\ Sin[\[Theta]]\^2\)\/\(2\ r\^2\)\)\)\),
      SequenceForm[ "R[", 2, 4, "] = ", 
        Times[ 
          Rational[ -1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          NonCommutativeMultiply[ dr, d\[CurlyPhi]], 
          Power[ 
            Sin[ \[Theta]], 2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]1\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(-\(\(\((\(-2\)\ Q + A\ r)\)\ \((Q + 
                    r\ \((\(-A\) + r)\))\)\ dt ** 
                  d\[Theta]\)\/\(2\ r\^6\)\)\)\),
      SequenceForm[ "R[", 3, 1, "] = ", 
        Times[ 
          Rational[ -1, 2], 
          Power[ r, -6], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Plus[ Q, 
            Times[ r, 
              Plus[ 
                Times[ -1, A], r]]], 
          NonCommutativeMultiply[ dt, d\[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((\(-2\)\ Q + A\ r)\)\ dr ** d\
\[Theta]\)\/\(2\ r\^2\ \((Q + r\ \((\(-A\) + r)\))\)\)\),
      SequenceForm[ "R[", 3, 2, "] = ", 
        Times[ 
          Rational[ 1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1], 
          NonCommutativeMultiply[ dr, d\[Theta]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "R[", 3, 3, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((\(-Q\) + A\ r)\)\ d\[Theta] ** d\
\[CurlyPhi]\ Sin[\[Theta]]\^2\)\/r\^2\),
      SequenceForm[ "R[", 3, 4, "] = ", 
        Times[ 
          Power[ r, -2], 
          Plus[ 
            Times[ -1, Q], 
            Times[ A, r]], 
          NonCommutativeMultiply[ d\[Theta], d\[CurlyPhi]], 
          Power[ 
            Sin[ \[Theta]], 2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]4\[InvisibleSpace]1\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(-\(\(\((\(-2\)\ Q + A\ r)\)\ \((Q + 
                    r\ \((\(-A\) + r)\))\)\ dt ** 
                  d\[CurlyPhi]\)\/\(2\ r\^6\)\)\)\),
      SequenceForm[ "R[", 4, 1, "] = ", 
        Times[ 
          Rational[ -1, 2], 
          Power[ r, -6], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Plus[ Q, 
            Times[ r, 
              Plus[ 
                Times[ -1, A], r]]], 
          NonCommutativeMultiply[ dt, d\[CurlyPhi]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]4\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((\(-2\)\ Q + A\ r)\)\ dr ** d\
\[CurlyPhi]\)\/\(2\ r\^2\ \((Q + r\ \((\(-A\) + r)\))\)\)\),
      SequenceForm[ "R[", 4, 2, "] = ", 
        Times[ 
          Rational[ 1, 2], 
          Power[ r, -2], 
          Plus[ 
            Times[ -2, Q], 
            Times[ A, r]], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1], 
          NonCommutativeMultiply[ dr, d\[CurlyPhi]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]4\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(\((Q - A\ r)\)\ d\[Theta] ** d\
\[CurlyPhi]\)\/r\^2\),
      SequenceForm[ "R[", 4, 3, "] = ", 
        Times[ 
          Power[ r, -2], 
          Plus[ Q, 
            Times[ -1, A, r]], 
          NonCommutativeMultiply[ d\[Theta], d\[CurlyPhi]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]4\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "R[", 4, 4, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("The result is encoded in a tensor RR[i,j]"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("Its components are encoded in a tensor Rie[i,j,a,b]"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \(" Now I calculate the Ricci tensor"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("Ricci["\[InvisibleSpace]1\[InvisibleSpace]1\
\[InvisibleSpace]"]= "\[InvisibleSpace]\(Q\ \((Q + r\ \((\(-A\) + r)\))\)\)\/\
\(2\ r\^6\)\),
      SequenceForm[ "Ricci[", 1, 1, "]= ", 
        Times[ 
          Rational[ 1, 2], Q, 
          Power[ r, -6], 
          Plus[ Q, 
            Times[ r, 
              Plus[ 
                Times[ -1, A], r]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("Ricci["\[InvisibleSpace]2\[InvisibleSpace]2\
\[InvisibleSpace]"]= "\[InvisibleSpace]\(-\(Q\/\(2\ r\^2\ \((Q + 
                    r\ \((\(-A\) + r)\))\)\)\)\)\),
      SequenceForm[ "Ricci[", 2, 2, "]= ", 
        Times[ 
          Rational[ -1, 2], Q, 
          Power[ r, -2], 
          Power[ 
            Plus[ Q, 
              Times[ r, 
                Plus[ 
                  Times[ -1, A], r]]], -1]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("Ricci["\[InvisibleSpace]3\[InvisibleSpace]3\
\[InvisibleSpace]"]= "\[InvisibleSpace]Q\/\(2\ r\^2\)\),
      SequenceForm[ "Ricci[", 3, 3, "]= ", 
        Times[ 
          Rational[ 1, 2], Q, 
          Power[ r, -2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    InterpretationBox[\("Ricci["\[InvisibleSpace]4\[InvisibleSpace]4\
\[InvisibleSpace]"]= "\[InvisibleSpace]\(Q\ Sin[\[Theta]]\^2\)\/\(2\ r\^2\)\),
      
      SequenceForm[ "Ricci[", 4, 4, "]= ", 
        Times[ 
          Rational[ 1, 2], Q, 
          Power[ r, -2], 
          Power[ 
            Sin[ \[Theta]], 2]]],
      Editable->False]], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \(" The tensor ricten[a,b]] giving the Ricci tensor "\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \(" is ready for storing on hard disk"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[35]="]
}, Open  ]],

Cell["\<\

We can summarize our results by recalling the form of the metric \
\>", "Caption",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(MatrixForm[gg]\)], "Input",
  CellLabel->"In[36]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(-1\) - Q\/r\^2 + A\/r\), "0", "0", "0"},
            {"0", \(1\/\(1 + Q\/r\^2 - A\/r\)\), "0", "0"},
            {"0", "0", \(r\^2\), "0"},
            {"0", "0", "0", \(r\^2\ Sin[\[Theta]]\^2\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[36]//MatrixForm="]
}, Open  ]],

Cell["\<\

and of the calculated Ricci Tensor\
\>", "Caption",
  FontSize->16],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(MatrixForm[ricten]\)\)\)], "Input",
  CellLabel->"In[37]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(Q\ \((Q + r\ \((\(-A\) + r)\))\)\)\/\(2\ r\^6\)\), "0", "0", 
              "0"},
            {"0", \(-\(Q\/\(2\ r\^2\ \((Q + r\ \((\(-A\) + r)\))\)\)\)\), "0",
               "0"},
            {"0", "0", \(Q\/\(2\ r\^2\)\), "0"},
            {"0", "0", "0", \(\(Q\ Sin[\[Theta]]\^2\)\/\(2\ r\^2\)\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[37]//MatrixForm="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowSize->{705, 655},
WindowMargins->{{-4, Automatic}, {Automatic, 0}},
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 118, 3, 195, "Title"],
Cell[1897, 58, 289, 7, 87, "Text"],
Cell[2189, 67, 159, 5, 44, "Caption"],

Cell[CellGroupData[{
Cell[2373, 76, 99, 2, 49, "Input"],
Cell[2475, 80, 108, 2, 23, "Print"],
Cell[2586, 84, 100, 2, 23, "Print"],
Cell[2689, 88, 211, 4, 23, "Print"],
Cell[2903, 94, 266, 6, 23, "Print"],
Cell[3172, 102, 102, 2, 23, "Print"],
Cell[3277, 106, 103, 2, 23, "Print"],
Cell[3383, 110, 102, 2, 23, "Print"],
Cell[3488, 114, 114, 2, 23, "Print"],
Cell[3605, 118, 65, 2, 27, "Output"]
}, Open  ]],
Cell[3685, 123, 82, 4, 43, "Caption"],
Cell[3770, 129, 139, 3, 49, "Input"],
Cell[3912, 134, 142, 3, 49, "Input"],
Cell[4057, 139, 240, 5, 42, "Input"],
Cell[4300, 146, 144, 5, 44, "Caption"],

Cell[CellGroupData[{
Cell[4469, 155, 70, 2, 29, "Input"],
Cell[4542, 159, 89, 2, 23, "Print"],
Cell[4634, 163, 119, 2, 23, "Print"],
Cell[4756, 167, 100, 2, 23, "Print"],
Cell[4859, 171, 71, 2, 23, "Print"],
Cell[4933, 175, 108, 2, 23, "Print"],
Cell[5044, 179, 69, 2, 23, "Print"],
Cell[5116, 183, 117, 2, 23, "Print"],
Cell[5236, 187, 82, 2, 23, "Print"],
Cell[5321, 191, 75, 2, 23, "Print"],
Cell[5399, 195, 105, 2, 23, "Print"],
Cell[5507, 199, 610, 17, 38, "Print"],
Cell[6120, 218, 610, 17, 38, "Print"],
Cell[6733, 237, 260, 5, 23, "Print"],
Cell[6996, 244, 260, 5, 23, "Print"],
Cell[7259, 251, 582, 16, 37, "Print"],
Cell[7844, 269, 609, 17, 38, "Print"],
Cell[8456, 288, 458, 12, 39, "Print"],
Cell[8917, 302, 568, 14, 39, "Print"],
Cell[9488, 318, 260, 5, 23, "Print"],
Cell[9751, 325, 322, 7, 36, "Print"],
Cell[10076, 334, 308, 7, 36, "Print"],
Cell[10387, 343, 398, 9, 23, "Print"],
Cell[10788, 354, 260, 5, 23, "Print"],
Cell[11051, 361, 328, 7, 36, "Print"],
Cell[11382, 370, 345, 7, 23, "Print"],
Cell[11730, 379, 429, 11, 36, "Print"],
Cell[12162, 392, 78, 2, 23, "Print"],
Cell[12243, 396, 109, 2, 23, "Print"],
Cell[12355, 400, 82, 2, 23, "Print"],
Cell[12440, 404, 100, 2, 23, "Print"],
Cell[12543, 408, 86, 2, 23, "Print"],
Cell[12632, 412, 163, 4, 23, "Print"],
Cell[12798, 418, 163, 4, 23, "Print"],
Cell[12964, 424, 163, 4, 23, "Print"],
Cell[13130, 430, 163, 4, 23, "Print"],
Cell[13296, 436, 163, 4, 23, "Print"],
Cell[13462, 442, 163, 4, 23, "Print"],
Cell[13628, 448, 163, 4, 23, "Print"],
Cell[13794, 454, 163, 4, 23, "Print"],
Cell[13960, 460, 163, 4, 23, "Print"],
Cell[14126, 466, 163, 4, 23, "Print"],
Cell[14292, 472, 163, 4, 23, "Print"],
Cell[14458, 478, 163, 4, 23, "Print"],
Cell[14624, 484, 163, 4, 23, "Print"],
Cell[14790, 490, 163, 4, 23, "Print"],
Cell[14956, 496, 163, 4, 23, "Print"],
Cell[15122, 502, 163, 4, 23, "Print"],
Cell[15288, 508, 163, 4, 23, "Print"],
Cell[15454, 514, 163, 4, 23, "Print"],
Cell[15620, 520, 163, 4, 23, "Print"],
Cell[15786, 526, 163, 4, 23, "Print"],
Cell[15952, 532, 73, 2, 23, "Print"],
Cell[16028, 536, 90, 2, 23, "Print"],
Cell[16121, 540, 114, 2, 23, "Print"],
Cell[16238, 544, 92, 2, 23, "Print"],
Cell[16333, 548, 232, 5, 23, "Print"],
Cell[16568, 555, 600, 17, 38, "Print"],
Cell[17171, 574, 479, 13, 37, "Print"],
Cell[17653, 589, 583, 15, 40, "Print"],
Cell[18239, 606, 703, 20, 39, "Print"],
Cell[18945, 628, 232, 5, 23, "Print"],
Cell[19180, 635, 479, 13, 37, "Print"],
Cell[19662, 650, 583, 15, 40, "Print"],
Cell[20248, 667, 662, 18, 37, "Print"],
Cell[20913, 687, 645, 18, 38, "Print"],
Cell[21561, 707, 232, 5, 23, "Print"],
Cell[21796, 714, 532, 14, 39, "Print"],
Cell[22331, 730, 668, 18, 37, "Print"],
Cell[23002, 750, 651, 18, 38, "Print"],
Cell[23656, 770, 437, 11, 36, "Print"],
Cell[24096, 783, 232, 5, 23, "Print"],
Cell[24331, 790, 106, 2, 23, "Print"],
Cell[24440, 794, 116, 2, 23, "Print"],
Cell[24559, 798, 92, 2, 23, "Print"],
Cell[24654, 802, 98, 2, 23, "Print"],
Cell[24755, 806, 246, 5, 23, "Print"],
Cell[25004, 813, 461, 13, 37, "Print"],
Cell[25468, 828, 246, 5, 23, "Print"],
Cell[25717, 835, 517, 14, 38, "Print"],
Cell[26237, 851, 246, 5, 23, "Print"],
Cell[26486, 858, 322, 8, 37, "Print"],
Cell[26811, 868, 246, 5, 23, "Print"],
Cell[27060, 875, 402, 11, 40, "Print"],
Cell[27465, 888, 96, 2, 23, "Print"],
Cell[27564, 892, 114, 2, 23, "Print"],
Cell[27681, 896, 99, 2, 23, "Print"],
Cell[27783, 900, 93, 2, 23, "Print"],
Cell[27879, 904, 65, 2, 27, "Output"]
}, Open  ]],
Cell[27959, 909, 109, 4, 43, "Caption"],

Cell[CellGroupData[{
Cell[28093, 917, 72, 2, 29, "Input"],
Cell[28168, 921, 521, 13, 119, "Output"]
}, Open  ]],
Cell[28704, 937, 78, 4, 43, "Caption"],

Cell[CellGroupData[{
Cell[28807, 945, 107, 2, 49, "Input"],
Cell[28917, 949, 626, 15, 131, "Output"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

