(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     12359,        289]*)
(*NotebookOutlinePosition[     13036,        312]*)
(*  CellTagsIndexPosition[     12992,        308]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[" MATHEMATICA PACKAGE METRIGAV", "Title"],

Cell["\<\

Einstein Equations in metric formalism\
\>", "Subtitle"],

Cell[CellGroupData[{

Cell["Metric Gravity", "Section"],

Cell["\<\
In this Notebook we provide a package to calculate Einstein equations for any \
given metric in arbitrary dimensions and using the metric formalism.\
\>", "Text",
  FontSize->18],

Cell[CellGroupData[{

Cell["routines: metrigrav", "Subsection",
  FontSize->16],

Cell[TextData[{
  "This routine is devised to calculate the Levi Civita connection, the \
Riemann curvature and the Einstein Tensor for general manifolds In the metric \
formalism. The inputs are\n1) the dimension n\n2) the set of coordinates a n \
vector = ",
  StyleBox["coordi",
    FontWeight->"Bold"],
  "\n3) the set of differentials, an n vector  = ",
  StyleBox["diffe",
    FontWeight->"Bold"],
  "\n4) the metric given as a quadratic differential ds2=",
  Cell[BoxData[
      \(TraditionalForm\`g\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`dx\^i\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`dx\^j\)]],
  StyleBox["\n",
    FontWeight->"Bold"],
  StyleBox["TO START this programme you type ",
    FontSize->14,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["mainmetric ",
    FontSize->14,
    FontWeight->"Bold",
    FontVariations->{"Underline"->True,
    "CompatibilityType"->0}],
  StyleBox["and then you follow instructions",
    FontSize->14,
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["mainmetric", "Subsubsection",
  FontSize->14],

Cell[BoxData[{
    \(\(mainmetric := {\[IndentingNewLine]Print["\<OK I calculate your space, \
Give me the data\>"]; \[IndentingNewLine]Print["\<Give me the dimension of \
your space\>"]; \[IndentingNewLine]mdim = 
            Input["\<dimension = ?\>"]; \[IndentingNewLine]Print["\<Your \
space has dimension n = \>", 
            mdim]; \[IndentingNewLine]Print["\<Now I stop and you give me two \
vectors of dimension \>", 
            mdim]; \[IndentingNewLine]Print["\<vector coordi = vector of \
coordinates\>"]; \[IndentingNewLine]Print["\<vector diffe = vector of \
differentials\>"]; \[IndentingNewLine]Print["\<Next you give me the metric as \
ds2 = \>"]; \[IndentingNewLine]Print["\<Then to resume calculation you print \
metricresume\>"];\[IndentingNewLine]};\)\), "\[IndentingNewLine]", 
    \(\(firstres := {Print["\<I resume the calculation\>"]; \
\[IndentingNewLine]Print["\<First I extract the metric coefficients from your \
data\>"]; \[IndentingNewLine]gg = 
            Table[0, {i, 1, mdim}, {j, 1, 
                mdim}]; \[IndentingNewLine]Do[{Do[{gg\_\(\(\
\[LeftDoubleBracket]\)\(i, j\)\(\[RightDoubleBracket]\)\) = \(1\/2\) \
\((Coefficient[ds2, 
                          diffe\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\)*
                            diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)])\); \
\[IndentingNewLine]gg\_\(\(\[LeftDoubleBracket]\)\(j, i\)\(\
\[RightDoubleBracket]\)\) = \(1\/2\) \((Coefficient[ds2, 
                          diffe\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\)*
                            diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)])\);\[IndentingNewLine]}, {j, i + 1, 
                  mdim}]; \
\[IndentingNewLine]gg\_\(\(\[LeftDoubleBracket]\)\(i, i\)\(\
\[RightDoubleBracket]\)\) = 
                Coefficient[ds2, 
                  diffe\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\)\^2];}, {i, 1, 
              mdim}]; \[IndentingNewLine]Print["\<Then I calculate the \
inverse metric\>"]; \[IndentingNewLine]ggm = 
            Simplify[
              Inverse[gg]]; \[IndentingNewLine]Print["\<Done !\>"]; \
\[IndentingNewLine]Print["\<and I calculate also the metric determinant\>"]; \
\[IndentingNewLine]detto = 
            Simplify[
              Det[gg]]; \[IndentingNewLine]Print["\<Done\>"];};\)\
\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(\)}], "Input",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell["metricresume", "Subsubsection",
  FontSize->14],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(metricresume := \
{\[IndentingNewLine]firstres; \[IndentingNewLine]metrigrav;}\)\)\)], "Input",
  FontSize->14]
}, Closed]],

Cell[CellGroupData[{

Cell["routine metrigrav", "Subsubsection",
  FontSize->14],

Cell[BoxData[
    \(metrigrav := {\[IndentingNewLine]holviel = 
          diffe; \[IndentingNewLine]Print["\<I perform the calculation of the \
Christoffel symbols\>"]; \[IndentingNewLine]Gam = 
          Table[0, {i, 1, mdim}, {j, 1, mdim}, {k, 1, 
              mdim}]; \[IndentingNewLine]Do[\[IndentingNewLine]\ \ Do[\
\[IndentingNewLine]\ \ \ \ \ \ Do[{\(Gam\_\(\(\[LeftDoubleBracket]\)\(a, b, c\
\)\(\[RightDoubleBracket]\)\) = 
                    Simplify[\(1\/2\) \(\[Sum]\+\(m = 1\)\%mdim\((ggm\_\(\(\
\[LeftDoubleBracket]\)\(a, m\)\(\[RightDoubleBracket]\)\)\[IndentingNewLine]*\
\((\[PartialD]\_\(coordi\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\)\)\ 
                                    gg\_\(\(\[LeftDoubleBracket]\)\(m, c\)\(\
\[RightDoubleBracket]\)\)\[IndentingNewLine] + \[PartialD]\_\(coordi\_\(\(\
\[LeftDoubleBracket]\)\(c\)\(\[RightDoubleBracket]\)\)\)\ 
                                    gg\_\(\(\[LeftDoubleBracket]\)\(m, b\)\(\
\[RightDoubleBracket]\)\)\[IndentingNewLine] - \[PartialD]\_\(coordi\_\(\(\
\[LeftDoubleBracket]\)\(m\)\(\[RightDoubleBracket]\)\)\)\ 
                                    gg\_\(\(\[LeftDoubleBracket]\)\(b, c\)\(\
\[RightDoubleBracket]\)\))\))\)\), Trig \[Rule] True];\)}, {c, 1, 
                mdim}], \[IndentingNewLine]{b, 1, 
              mdim}], \[IndentingNewLine]{a, 1, 
            mdim}]; \[IndentingNewLine]Conne = 
          Table[\[Sum]\+\(b = 1\)\%mdim \
holviel\_\(\(\[LeftDoubleBracket]\)\(b\)\(\[RightDoubleBracket]\)\)*\ 
                Gam\_\(\(\[LeftDoubleBracket]\)\(a, b, c\)\(\
\[RightDoubleBracket]\)\), {a, 1, mdim}, {c, 1, 
              mdim}]; \[IndentingNewLine]Print["\<-----------------\>"]; \
\[IndentingNewLine]Print["\<I finished\>"]; \[IndentingNewLine]Print["\<the \
Levi Civita connection  is given by:\>"]; \[IndentingNewLine]Do[
          Do[\[IndentingNewLine]Print["\<\[CapitalGamma][\>", i, 
              j, "\<] = \>", 
              Conne\_\(\(\[LeftDoubleBracket]\)\(i, \
j\)\(\[RightDoubleBracket]\)\)], {j, 1, mdim}], {i, 1, 
            mdim}]; \[IndentingNewLine]Print["\<Task finished\>"]; \
\[IndentingNewLine]Print["\<The result is encoded in a tensor Gam[a,b,c]\>"]; \
\[IndentingNewLine]Print["\<-----------------\>"]; \[IndentingNewLine]Print["\
\< Now I calculate the Riemann tensor\>"]; \[IndentingNewLine]Rie = 
          Table[0, {a, 1, mdim}, {b, 1, mdim}, {f, 1, mdim}, {g, 1, 
              mdim}]; \[IndentingNewLine]Print["\<I tell you my steps :\>"]; \
\[IndentingNewLine]Do[{Print["\< a = \>", a]; 
            Do[{Print["\< b = \>", b]; 
                Do[Do[{\[IndentingNewLine]urdo = \
\((\[PartialD]\_\(coordi[\([f]\)]\)\ 
                              Gam\_\(\(\[LeftDoubleBracket]\)\(a, g, b\)\(\
\[RightDoubleBracket]\)\) - \[IndentingNewLine]\[PartialD]\_\(coordi[\([g]\)]\
\)\ Gam\_\(\(\[LeftDoubleBracket]\)\(a, f, b\)\(\[RightDoubleBracket]\)\))\); \
\[IndentingNewLine]urdo = 
                        Simplify[urdo, 
                          Trig \[Rule] True]; \[IndentingNewLine]weggio = 
                        Simplify[\[Sum]\+\(z = 1\)\%mdim Gam\_\(\(\
\[LeftDoubleBracket]\)\(a, f, z\)\(\[RightDoubleBracket]\)\)*
                                Gam\_\(\(\[LeftDoubleBracket]\)\(z, g, b\)\(\
\[RightDoubleBracket]\)\) - \[IndentingNewLine]\[Sum]\+\(z = 1\)\%mdim \
Gam\_\(\(\[LeftDoubleBracket]\)\(a, g, z\)\(\[RightDoubleBracket]\)\)*
                                Gam\_\(\(\[LeftDoubleBracket]\)\(z, f, b\)\(\
\[RightDoubleBracket]\)\), 
                          Trig \[Rule] True]; \[IndentingNewLine]Rie[\([a, b, 
                            f, g]\)] = 
                        Simplify[\(1\/2\) \((urdo + 
                                weggio)\)\[IndentingNewLine], 
                          Trig \[Rule] True];}, {f, 1, mdim}], {g, 1, 
                    mdim}];}, {b, 1, mdim}];}, {a, 1, 
            mdim}]; \[IndentingNewLine]Print["\<Finished\>"]; \
\[IndentingNewLine]Print["\<-------------------------\>"]; \
\[IndentingNewLine]Print["\<Now I evaluate the curvature 2-form of your space\
\>"]; \[IndentingNewLine]RR = 
          Table[0, {i, 1, mdim}, {j, 1, mdim}]; \[IndentingNewLine]Do[
          Do[\ {RR[\([i, j]\)] = 
                2*\(\[Sum]\+\(a = 1\)\%mdim\(\[Sum]\+\(b = a + 1\)\%mdim \
Rie\_\(\(\[LeftDoubleBracket]\)\(i, j, a, \
b\)\(\[RightDoubleBracket]\)\)*\((holviel\_\(\(\[LeftDoubleBracket]\)\(a\)\(\
\[RightDoubleBracket]\)\) ** 
                            holviel\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\))\)\)\)}, {i, 1, mdim}], {j, 1, 
            mdim}]; \[IndentingNewLine]Print["\<I find the following \
answer\>"]; \[IndentingNewLine]Do[
          Do[Print["\<R[\>", i, j, "\<] = \>", RR[\([i, j]\)]], {j, 1, 
              mdim}], {i, 1, 
            mdim}]; \[IndentingNewLine]Print["\<The result is encoded in a \
tensor RR[i,j]\>"]; \[IndentingNewLine]Print["\<Its components are encoded in \
a tensor Rie[i,j,a,b]\>"]; \
\[IndentingNewLine]Print["\<---------------------------\>"]; \n\t\tPrint["\< \
Now I calculate the Ricci tensor\>"]; \t\n\t
        ricten = Table[0, {a, 1, mdim}, {b, 1, mdim}\ ]; \n
        Do[ricten[\([b, e]\)] = 
            Simplify[
              Sum[Rie[\([xx, b, xx, e]\)], {xx, 
                  mdim}]]; \[IndentingNewLine]ulla = 0; \n
          If[ricten[\([b, e]\)] =!= 
              0, {\n\t\t\t\t\tPrint[b, "\< \>", 
                e, "\< \>", "\<  non zero\>"]; \
\[IndentingNewLine]Print["\<Ricci[\>", b, e, "\<]= \>", 
                ricten[\([b, e]\)]]; \n\t\t\t\t\tulla = 
                ulla + 1;\[IndentingNewLine]}], \n{b, mdim}, {e, 
            mdim}]; \n\t\t\t\tPrint["\<I have finished the calculation\>"]; \
\[IndentingNewLine]If[
          ulla \[Equal] 
            0, {\(Print["\<The Ricci tensor is zero\>"];\)}, {\n\t\t\tPrint["\
\< The tensor ricten[a,b]] giving the Ricci tensor \>"]; \n\t\t\tPrint["\< is \
ready for storing on hard disk\>"];}]; \n\t\t\t\
Print["\<----------------------------\>"];\[IndentingNewLine]\
\[IndentingNewLine]}\)], "Input",
  FontSize->14]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowSize->{1252, 653},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Report.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 46, 0, 81, "Title"],
Cell[1825, 55, 67, 3, 66, "Subtitle"],

Cell[CellGroupData[{
Cell[1917, 62, 33, 0, 67, "Section"],
Cell[1953, 64, 188, 4, 34, "Text"],

Cell[CellGroupData[{
Cell[2166, 72, 57, 1, 43, "Subsection"],
Cell[2226, 75, 1126, 33, 261, "MathCaption"],

Cell[CellGroupData[{
Cell[3377, 112, 51, 1, 33, "Subsubsection"],
Cell[3431, 115, 2463, 46, 1372, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[5931, 166, 53, 1, 27, "Subsubsection"],
Cell[5987, 169, 158, 3, 90, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[6182, 177, 58, 1, 27, "Subsubsection"],
Cell[6243, 180, 6064, 103, 2005, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

