(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    118222,       2663]*)
(*NotebookOutlinePosition[    118901,       2686]*)
(*  CellTagsIndexPosition[    118857,       2682]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Manifold Geometry, Curvatures and Killing Vectors", "Title"],

Cell["\<\
This notebook contains various packages for the calculation of the spin \
connection and the curvatures of various manifolds, both homogeneous \
(=cosets) and also non homogeneous. It si divided in various sections\
\>", "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["Coset Manifolds (Euclidean signature)", "Section"],

Cell[CellGroupData[{

Cell["Instructions for the Use", "Subsection",
  FontSize->18],

Cell[TextData[{
  "This notebook has the following purpose, that of calculating the Riemann \
tensor and the connection of the several coset manifolds. In particular:\n1) \
The manifold:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(SU(3)\)\/\(\(SU(2)\)\ x\ \(U(1)\)\)\),
          FontSize->18], TraditionalForm]]],
  "=",
  Cell[BoxData[
      \(TraditionalForm\`CP\_2\)]],
  "\n2) The spheres:\n\t\t\t\t",
  Cell[BoxData[
      FormBox[
        StyleBox[\(\(SO(m + 1)\)\/\(SO(m)\)\),
          FontSize->18], TraditionalForm]]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`S\_m\)]],
  "\t\n3)The manifold \n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\(SU(3)\)\/\(U(1)\)\)],
    FontSize->18],
  StyleBox["=",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`N\^010\)],
    FontSize->18],
  "\t\t\t\t\t\t\n\t\t\t\t\nThe calculation is done using the RUNCOSET package \
constructed by Prof. Leonardo Castellani. The input are the structure \
constants of the corresponding group that are calculated by suitable routines \
inserted in this package.\nFirst read the two sections of PROGRAMME\n and \
then start by the command \n",
  StyleBox["start ",
    FontWeight->"Bold"],
  StyleBox["\nIf you want to calculate the structure constants for CP2, \
spheres or N010 you just type:\n",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["cp2stru, spheres or  n010stru",
    FontWeight->"Bold",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\nand then initialize RUNCOSET programme by the command\n",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["initial\n",
    FontWeight->"Bold",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["then supply the file cc=fff\nand you can calculate with the \
commands of RUNCOSET\nthat are described in the section below",
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24]
}, Open  ]],

Cell[CellGroupData[{

Cell["Decription of the main commands of RUNCOSET", "Subsection"],

Cell[TextData[{
  "The available commands one can use at this point are the following ones\n\t\
1. \n             ",
  StyleBox["doriemann2",
    FontWeight->"Bold"],
  "\n             This command generates as an output a tensor  ",
  StyleBox["Rie[[a,b,c,d]] = ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((R\^ab)\)\_cd\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`\((R\^ab)\)\_cd\)]],
  " is the Riemann tensor in the conventions of the old Kaluza Klein \
literature, namely Universal mass relations Ann. of Phys. 162, (1985) 372 by \
D'Auria and Fr\[EAcute].\n             2. \n            ",
  StyleBox["doconnection ",
    FontWeight->"Bold"],
  "\n            This command generates as an output a tensor ",
  StyleBox["connten[[a,b]] = ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`B\^ab\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`B\^ab\)]],
  " is the spin connection 1-form  in the conventions of the old Kaluza Klein \
literature, namely Universal mass relations Ann. of Phys. 162, (1985) 372 by \
D'Auria and Fr\[EAcute].\n            3.\n             ",
  StyleBox["doconcomp",
    FontWeight->"Bold"],
  " \n             This command generates as an output a tensor ",
  StyleBox["contor[[c,a,b]] = ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`\((B\^ab)\)\_c\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`\((B\^ab)\)\_c\)]],
  " is the torsion part of the spin connection 1-form  in the conventions of \
the old Kaluza Klein literature, namely Universal mass relations Ann. of \
Phys. 162, (1985) 372 by D'Auria and Fr\[EAcute].\n             4\n           \
  ",
  StyleBox["doricci ",
    FontWeight->"Bold"],
  "\nThis command generates as an output a tensor ",
  StyleBox["ricten[[a,b]] =  ",
    FontWeight->"Bold"],
  Cell[BoxData[
      \(TraditionalForm\`R\_cb\^ca\)]],
  " where ",
  Cell[BoxData[
      \(TraditionalForm\`R\_cb\^ca\)]],
  " is the Ricci tensor in the conventions of the old Kaluza Klein \
literature, namely Universal mass relations Ann. of Phys. 162, (1985) 372 by \
D'Auria and Fr\[EAcute].\n",
  StyleBox[" \t5\n             docurvaform\n",
    FontWeight->"Bold"],
  StyleBox["This command generates the curvature 2--form once the Riemann \
tensor has been generated",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["             ",
    FontWeight->"Bold"],
  "\nIndex ordering\nThe index ordering is as follows:\nA=(a,i);   \
a=1,.....,dimG/H ; i=dimG/H+1,........,dimG\nThe index a enumerates the coset \
directions, while the index i enumerates the H subalgebra directions"
}], "MathCaption",
  FontSize->24],

Cell["", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Initializing", "Subsection"],

Cell[CellGroupData[{

Cell["Setting the working Directory", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(start := {\[IndentingNewLine]settando \
:= \[IndentingNewLine]{direc = 
                InputString["\<give the address of your working 
directory\>"]; \[IndentingNewLine]SetDirectory[
                direc]; \[IndentingNewLine]Directory[];\[IndentingNewLine]}; \
\[IndentingNewLine]settando; \[IndentingNewLine]Directory[];};\)\(\ \)\)\)], \
"Input",
  CellLabel->"In[1]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Structure constants for CP2", "Subsection"],

Cell[TextData[{
  "This programme calculates the generators and the structure constants of \
SU(3) in such a way that the firrst 4 generators are those of the coset:\n",
  Cell[BoxData[
      \(TraditionalForm\`\(SU(3)\)\/\(\(SU(2)\)\ x\ \(U(1)\)\)\)]]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["Construction of the structure constants of SU(3)", "Subsubsection"],

Cell["\<\
The important thing is that the structure constants, in Leonardo's programme \
must be organized in such a way that the first 4 indices are those of the \
coset and the last 4 are those of the subgroup SU(2) x U(1). Hence we just \
permute the names of the indices in the programme that was used for the \
construction of SU(3) structure constants in N010 calculations of 1999.\
\>", "Text"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(lammat := {\[IndentingNewLine]\[Lambda]\_1 \
= {{0, 1, 0}, {1, 0, 0}, {0, 0, 
                0}}; \[IndentingNewLine]\[Lambda]\_2 = {{0, \
\(-\[ImaginaryI]\), 0}, {\[ImaginaryI], 0, 0}, {0, 0, 
                0}}; \[IndentingNewLine]\[Lambda]\_3 = {{1, 0, 
                0}, {0, \(-1\), 0}, {0, 0, 
                0}}; \[IndentingNewLine]\[Lambda]\_4 = {{0, 0, 1}, {0, 0, 
                0}, {1, 0, 0}}; \[IndentingNewLine]\[Lambda]\_5 = {{0, 
                0, \(-\[ImaginaryI]\)}, {0, 0, 0}, {\[ImaginaryI], 0, 
                0}}; \[IndentingNewLine]\[Lambda]\_6 = {{0, 0, 0}, {0, 0, 
                1}, {0, 1, 0}}; \[IndentingNewLine]\[Lambda]\_7 = {{0, 0, 
                0}, {0, 0, \(-\[ImaginaryI]\)}, {0, \[ImaginaryI], 
                0}}; \[IndentingNewLine]\[Lambda]\_8 = \(1\/\@3\) {{1, 0, 
                  0}, {0, 1, 0}, {0, 0, \(-2\)}}; \[IndentingNewLine]lam = 
            Table[\[Lambda]\_i, {i, 1, 
                8}];\[IndentingNewLine]};\)\[IndentingNewLine]
    \(cp2stru := {\[IndentingNewLine]lammat; \[IndentingNewLine]tt = 
            Table[0\ , {i, 1, 8}, {j, 1, 3}, {k, 1, 
                3}]; \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(1\)\(\
\[RightDoubleBracket]\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(4\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(2\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(6\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(3\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(5\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(4\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(7\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(5\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(8\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(8\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(1\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(7\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(2\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]tt\_\(\(\[LeftDoubleBracket]\)\(6\)\(\[RightDoubleBracket]\
\)\) = \(\[ImaginaryI]\/2\) 
              lam\_\(\(\[LeftDoubleBracket]\)\(3\)\(\[RightDoubleBracket]\)\);\
 \[IndentingNewLine]ordvec = {4, 6, 5, 7, 8, 1, 2, 
              3}; \[IndentingNewLine]fff = 
            Table[0, {i, 1, 8}, {j, 1, 8}, {k, 1, 8}]; \[IndentingNewLine]Do[
            Do[Do[\ {xx = 
                    tt\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\
\)\) . tt\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\) - 
                      tt\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\); \ \[IndentingNewLine]fff\_\(\(\[LeftDoubleBracket]\
\)\(k, i, j\)\(\[RightDoubleBracket]\)\) = \(-2\) \(\[Sum]\+\(p = 1\)\%3 xx\_\
\(\(\[LeftDoubleBracket]\)\(p, p\)\(\[RightDoubleBracket]\)\)\);}, {k, 1, 
                  8}], {i, 1, 8}], {j, 1, 8}];};\)\[IndentingNewLine]
    \(\(runna := {start; \
\[IndentingNewLine]struconst;\[IndentingNewLine]}\)\(\[IndentingNewLine]\)
    \)\)\(\t\t\)\)\)], "Input",
  CellLabel->"In[2]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spheres", "Subsection"],

Cell[TextData[{
  "This programme calculates the generators and the structure constants of \
the group SO(n+1) and orders them in such a way that the first n generators \
are those of the coset:\n                  \t\t\t\t  ",
  Cell[BoxData[
      \(TraditionalForm\`\(SO(n + 1)\)\/\(SO(n)\)\)]]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\
Programme to compute structure constants of SO(n) groups for sphere cosets\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(spheres := {\[IndentingNewLine]mmm = 
            Input["\<Which sphere m= ?\>"]; \[IndentingNewLine]nn = 
            mmm + 1; \[IndentingNewLine]dimen = 
            nn*\(nn - 1\)\/2; \[IndentingNewLine]gg = 
            Table[0, {i, 1, dimen}, {k, 1, nn}, {j, 1, 
                nn}]; \[IndentingNewLine]xx = 
            1; \[IndentingNewLine]Do[{gg[\([xx, nn, j]\)] = 
                1; \[IndentingNewLine]gg[\([xx, j, 
                    nn]\)] = \(-1\); \[IndentingNewLine]xx = xx + 1;}, {j, 1, 
              nn - 1}]; \[IndentingNewLine]Do[
            Do[\[IndentingNewLine]{gg[\([xx, i, j]\)] = 
                  1; \[IndentingNewLine]gg[\([xx, j, 
                      i]\)] = \(-1\); \[IndentingNewLine]xx = xx + 1;}, {j, 
                i + 1, nn - 1}], {i, 1, 
              nn - 1}]; \[IndentingNewLine]\[IndentingNewLine]hh = 
            Table[0, {i, 1, dimen}, {j, 1, dimen}]; \[IndentingNewLine]Do[
            Do[{temp = 
                  gg\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\
\) . gg\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\)\); \ 
                hh\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\[RightDoubleBracket]\
\)\) = \[Sum]\+\(r = 1\)\%nn temp\_\(\(\[LeftDoubleBracket]\)\(r, r\)\(\
\[RightDoubleBracket]\)\)}, {i, 1, dimen}], {j, 1, 
              dimen}]; \[IndentingNewLine]fff = 
            Table[0, {i, 1, dimen}, {j, 1, dimen}, {k, 1, 
                dimen}]; \[IndentingNewLine]Do[
            Do[Do[\ {yyy = 
                    gg\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\
\)\) . gg\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\)\) . 
                        gg\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\) - 
                      gg\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\) . 
                        gg\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\) . 
                        gg\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\); \ \[IndentingNewLine]fff\_\(\(\[LeftDoubleBracket]\
\)\(k, i, j\)\(\[RightDoubleBracket]\)\) = \(-\(1\/2\)\) \(\[Sum]\+\(p = \
1\)\%nn yyy\_\(\(\[LeftDoubleBracket]\)\(p, \
p\)\(\[RightDoubleBracket]\)\)\);}, {k, 1, dimen}], {j, 1, dimen}], {i, 1, 
              dimen}];\t\[IndentingNewLine]};\)\)], "Input",
  CellLabel->"In[5]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["N010 coset", "Subsection"],

Cell[TextData[{
  "This programme generates the structure constants of SU(3) but in such an \
order that the first 7 generators are those of the coset\n\t\t\t\t",
  Cell[BoxData[
      \(TraditionalForm\`\(\(\t\)\(\(SU(3)\)\/\(U(1)\)\)\)\)]],
  "\nU(1) being generated by the 8th Gell  Mann matrix"
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["routine", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(n010stru := {\[IndentingNewLine]lammat; \
\[IndentingNewLine]tt = 
            Table[0\ , {i, 1, 8}, {j, 1, 3}, {k, 1, 
                3}]; \[IndentingNewLine]Do[
            tt\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\) = \
\(\[ImaginaryI]\/2\) 
                lam\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\
\), {i, 1, 8}]; \[IndentingNewLine]fff = 
            Table[0, {i, 1, 8}, {j, 1, 8}, {k, 1, 8}]; \[IndentingNewLine]Do[
            Do[Do[\ {xx = 
                    tt\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\
\)\) . tt\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\) - 
                      tt\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\) . 
                        tt\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\); \ \[IndentingNewLine]fff\_\(\(\[LeftDoubleBracket]\
\)\(k, i, j\)\(\[RightDoubleBracket]\)\) = \(-2\) \(\[Sum]\+\(p = 1\)\%3 xx\_\
\(\(\[LeftDoubleBracket]\)\(p, p\)\(\[RightDoubleBracket]\)\)\);}, {k, 1, 
                  8}], {i, 1, 8}], {j, 1, 8}];};\)\)\)], "Input",
  CellLabel->"In[6]:="]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["RUNCOSET  PACKAGE (Euclidean signature)", "Section"],

Cell["\<\
This is a new package based on the package \"Cosets\" that was written by \
Leonardo Castellani and which computes the Riemann tensor, Weyl tensor and \
the spin connection for  G/H manifolds . The package  has been modified and \
adapted to the  way  we want to perform our calculations.\
\>", "MathCaption"],

Cell[CellGroupData[{

Cell["ROUTINES OF THE PACKAGE  RUNCOSET", "Subsection"],

Cell[CellGroupData[{

Cell["Initial inputs", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(\(initial := {\nPrint["\<=======================================\>"]; \n
          Print["\< Welcome to RUNCOSET, a new package  built by Petrus\>"]; \
\nPrint["\<on Leonardus technology\>"]; \n
          Print["\< It computes various geometric quantities of G/H  \
cosets\>"]; \n
          Print["\< Please insert the dimensions of the group G and\>"]; \n
          Print["\< of the coset G/H\>"]; \t\t\n
          dg\  = \ Input["\< dimension of G = ?\>"]; \n
          dco\  = \ 
            Input["\< dimension of G/H = ?\>"]; \n\n (*\ \ \ \ computes\ the\ \
delta\ function\ \ *) \n\n\ delta = Table[0, {i1, dg}, {i2, dg}]; \n\ 
          Do[delta[\([a, a]\)] = 1, {a, dg}]; \n\n\  (*\ 
            definition\ of\ antisymmetrized\ deltas\ \ \ *) \n\n
          deltaa[m1_, m2_] := \((\n
              If[Sort[m1] =!= Sort[m2], 0, 
                1/\(Length[m1]!\)*Signature[m1]*
                  Signature[m2]])\); \n\n (*\ \ \ \ default\ rescalings\  = 
              1\ \ \ \ \ *) \n\nDo[r[a] = 1, {a, dco}]; \n
          Print["\<-----------------------------------------------\>"]; \n
          Print["\< Now you need to provide the structure constants of the 
				group\>"]; \nPrint["\< and the rescalings\>"]; \n
          Print["\< The structure constants must be given as a tensor \
cc[[A,B,C]]; \>"]; \n
          Print["\< The rescalings must be given as r[1]=?, r[2]=?...\>"]; \n
          Print["\<-----------------------------------------------\>"];\t\t\t\
\t\t\t\t\t\t\t\t\t\n\t\t};\)\), "\n", 
    \(\(docf := {cf = Table[0, {i1, dco}, {i2, dco}, {i3, dco}]; \n
          Do[cf[\([b, c, a]\)] = 
              Simplify[\n
                r[b]*r[c]/r[a]*cc[\([b, c, a]\)] - 
                  r[a]*r[c]/r[b]*
                    cc[\([a, c, b]\)]\n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \  - 
                  r[a]*r[b]/r[c]*cc[\([a, b, c]\)]], \n{a, dco}, {b, 
              dco}, {c, dco}];};\)\n\), "\n", 
    \(\)}], "Input",
  CellLabel->"In[7]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(deltaa\\)\\\" is similar to existing symbol \
\\\"\\!\\(delta\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[7]:="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Command: doriemann2", "Subsubsection"],

Cell[BoxData[
    \(\(\(\n\)\(doriemann2 := {\n\t\t\
Print["\<-------------------------------------\>"]; \n\t\t\ Print["\< Now I \
calculate the Riemann tensor Rie(a,b,c,d)\>"]; \n\t\tdocf; \n\t\tRie = 
            Table[0, {a, 1, dco}, {b, 1, dco}, {c, 1, dco}, {d, 1, dco}]; \n\ 
          Do[\ riemann[a, b, d, e] = 
              Simplify[\n\ \ \ 1/4*r[d]*r[e]*
                    Sum[1/r[c]*cf[\([b, c, a]\)]*cc[\([d, e, c]\)], {c, 
                        dco}] + \n\ \ \ 1/2*r[d]*r[e]*
                    Sum[cc[\([b, i, a]\)]*cc[\([d, e, i]\)], {i, dco + 1, 
                        dg}] + \n\ \ \ 1/8*
                    Sum[cf[\([c, d, a]\)]*cf[\([b, e, c]\)], {c, 
                        dco}] - \n\ \ \ 1/8*
                    Sum[cf[\([c, e, a]\)]*cf[\([b, d, c]\)], {c, dco}]]; \n\ 
            If[riemann[a, b, d, e] =!= 
                0, {Print[a, "\< \>", b, "\< \>", d, "\<  \>", \ 
                  e, "\<  non zero\>"]; \n\t\t\t\t\txyz = 
                  riemann[a, b, d, 
                    e]; \n\t\t\t\t\tRie[\([a, b, d, e]\)]\  = \ xyz; 
                Rie[\([a, b, e, d]\)]\  = \ \(-xyz\);}], {a, dco}, {b, 
              dco}, {d, dco}, {e, 
              dco}]; \n\t\t\tPrint["\<I have finished the calculation\>"]; \n\
\t\t\tPrint["\< The tensor Rie(a,b,c,d) is ready for storing on hard \
disk\>"]; \n\t\t\tPrint["\<Store it in your preferred directory with the name \
you choose\>"]; \n\t\t\tPrint["\<----------------------------\>"]; \
\[IndentingNewLine]Print["\<------------------------------------\>"]; \
\[IndentingNewLine]\(Print["\<Now I evaluate the curvature 2-form of your \
space\>"];\)\[IndentingNewLine]\(vielbein = Table[e\_i, {i, 1, dco}]\); \n
          RR = Table[0, {i, 1, dco}, {j, 1, dco}]; \n
          Do[Do[\ {RR[\([i, j]\)] = 
                  2*\(\[Sum]\+\(a = 1\)\%dco\(\[Sum]\+\(b = a + 1\)\%dco \
Rie\_\(\(\[LeftDoubleBracket]\)\(i, j, a, \
b\)\(\[RightDoubleBracket]\)\)*\((vielbein\_\(\(\[LeftDoubleBracket]\)\(a\)\(\
\[RightDoubleBracket]\)\) ** 
                              vielbein\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\))\)\)\)}, {i, 1, dco}], {j, 1, 
              dco}]; \[IndentingNewLine]Print["\<I find the following \
answer\>"]; \[IndentingNewLine]Do[
            Do[Print["\<R[\>", i, j, "\<] = \>", RR[\([i, j]\)]], {j, i + 1, 
                dco}], {i, 1, 
              dco}]; \[IndentingNewLine]Print["\<The result is encoded in a \
tensor RR[i,j]\>"]; \[IndentingNewLine]Print["\<Its components are encoded in \
a tensor Rie[i,j,a,b]\>"];\t\t\n\t\t\t};\)\(\t\)\)\)], "Input",
  CellLabel->"In[9]:="],

Cell[BoxData[""], "Input",
  CellLabel->"In[10]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Command: doconnection", "Subsubsection"],

Cell[BoxData[
    \(\(\(\n\)\(doconnection := {\n\t\tconnten = 
            Table[0, {a, 1, dco}, {b, 1, dco}]; \n\ \ Do[
            conn[a, b] = 
              Simplify[\n\ \ \ \ 1/
                      2*\((r[b]/r[a]*
                          Sum[r[c]*cc[\([b, c, a]\)]*viel[c], {c, 
                              dco}] - \n\ \ \ \ \ \ \ \ \ r[a]/r[b]*
                          Sum[r[c]*cc[\([a, c, b]\)]*viel[c], {c, 
                              dco}] - \n\ \ \ \ \ \ \ \ \ r[a]*r[b]*
                          Sum[1/r[c]*cc[\([a, b, c]\)]*viel[c], {c, 
                              dco}])\) + \n\ \ \ \ \ \ \ \ \ Sum[
                    cc[\([b, i, a]\)]*om[i], {i, dco + 1, 
                      dg}]]; \n\ \ \ \ \ \ \ \ \ If[
              conn[a, b] =!= 
                0, {Print[a, "\< \>", 
                  b, "\< \>", "\<  non zero\>"]; \n\t\t\t\t\txy = 
                  conn[a, b]; \n\t\t\t\t\tconnten\[LeftDoubleBracket]a, 
                    b\[RightDoubleBracket] = 
                  xy; \n\t\t\t\t\tconnten\[LeftDoubleBracket]a, 
                    b\[RightDoubleBracket] = \(-xy\);}], \n\ \ \ \ \ \ \ \ \ \
{a, dco}, {b, 
              dco}]; \n\t\t\tPrint["\<I have finished the calculation\>"]; \n\
\t\t\tPrint["\< The tensor connten[[a,b]] giving the formal expression \>"]; \
\n\t\t\tPrint["\< of the spin connection B[a,b] as a 1-form\>"]; \n\t\t\t\
Print["\< is ready for storing on hard disk\>"]; \n\t\t\tPrint["\<Store it in \
your preferred directory with the name you choose\>"]; \n\t\t\t\
Print["\<----------------------------\>"];\n\t\t\t};\)\)\)], "Input",
  CellLabel->"In[11]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Command: doconcomp", "Subsubsection"],

Cell[BoxData[
    \(\(doconncomp := {\n\t\t\
Print["\<-------------------------------------\>"]; \n\t\tPrint["\< Now I \
calculate the torsion part of the spin connection\>"]; \t\n\t\tcontor = 
            Table[0, {c, 1, dco}, {a, 1, dco}, {b, 1, dco}]; \n\ \ Do[
            conncomp[c, a, b] = 
              Simplify[\n\ \ \ \ 1/
                    2*\((r[b]/r[a]*r[c]*
                        cc[\([b, c, a]\)] - \n\ \ \ \ \ \ \ \ \ r[a]/r[b]*
                        r[c]*cc[\([a, c, b]\)] - \n\ \ \ \ \ \ \ \ \ r[a]*
                        r[b]/r[c]*cc[\([a, b, c]\)])\)]; \n\ \ \ \ If[
              conncomp[c, a, b] =!= 
                0, {Print[c, "\< \>", a, "\< \>", 
                  b, \ "\<  non zero\>"]; \n\t\t\t\t\txxx = 
                  conncomp[c, a, b]; \n\t\t\t\t\tcontor\[LeftDoubleBracket]c, 
                    a, b\[RightDoubleBracket] = \(-xxx\); \n\t\t\t\t\tcontor\
\[LeftDoubleBracket]c, b, a\[RightDoubleBracket] = \ 
                  xxx;}], \n\ \ \ \ \ \ \ \ \ {c, dco}, {a, dco}, {b, 
              dco}]; \n\t\t\tPrint["\<I have finished the calculation\>"]; \n\
\t\t\tPrint["\< The tensor contor[a,b]] giving the torsion part B[c,a,b] \
\>"]; \n\t\t\tPrint["\< of the spin connection B[a,b]\>"]; \n\t\t\tPrint["\< \
is ready for storing on hard disk\>"]; \n\t\t\tPrint["\<Store it in your \
preferred directory with the name you choose\>"]; \n\t\t\t\
Print["\<----------------------------\>"];};\)\)], "Input",
  CellLabel->"In[12]:="]
}, Closed]],

Cell[CellGroupData[{

Cell["Command: doricci", "Subsubsection"],

Cell[BoxData[
    \(\(\(doricci := {\n\t\t\
Print["\<-------------------------------------\>"]; \n\t\tPrint["\< Now I \
calculate the Ricci tensor\>"]; \t\n\t
          ricten = Table[0, {a, 1, dco}, {b, 1, dco}\ ]; \n
          Do[ricci[b, e] = Simplify[Sum[riemann[a, b, a, e], {a, dco}]]; \n
            If[ricci[b, e] =!= 
                0, {\n\t\t\t\t\tPrint[b, "\< \>", 
                  e, "\< \>", "\<  non zero\>"]; \n\t\t\t\t\txz = 
                  ricci[b, e]; \n\t\t\t\t\tricten\[LeftDoubleBracket]b, 
                    e\[RightDoubleBracket] = 
                  xz; \n\t\t\t\t\tricten\[LeftDoubleBracket]e, 
                    b\[RightDoubleBracket] = xz;}], \n{b, dco}, {e, 
              dco}]; \n\t\t\t\tPrint["\<I have finished the calculation\>"]; \
\n\t\t\tPrint["\< The tensor ricten[a,b]] giving the Ricci tensor \>"]; \n\t\t\
\tPrint["\< is ready for storing on hard disk\>"]; \n\t\t\tPrint["\<Store it \
in your preferred directory with the name you choose\>"]; \n\t\t\t\
Print["\<----------------------------\>"];}\ ;\)\(\n\)
    \)\)], "Input",
  CellLabel->"In[13]:="],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(Print["\<I have read everything\>"];\)\
\[IndentingNewLine]
    \(Print[Sin[\[Pi]\/4]];\)\)\)\)], "Input",
  CellLabel->"In[14]:="],

Cell[BoxData[
    \("I have read everything"\)], "Print",
  CellLabel->"From In[14]:="],

Cell[BoxData[
    \(1\/\@2\)], "Print",
  CellLabel->"From In[14]:="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Command docurvaform", "Subsubsection"],

Cell[BoxData[{
    \(\(docurvaform := {Print["\<------------------------------------\>"]; \
\[IndentingNewLine]Print["\<I evaluate the curvature 2-form of your  \
coset\>"]; \[IndentingNewLine]vielbein = Table[V\_i, {i, 1, dco}]; \n
          RR = Table[0, {i, 1, dco}, {j, 1, dco}]; \n
          Do[Do[\ {RR[\([i, 
                      j]\)] = \[Sum]\+\(a = 1\)\%dco\(\[Sum]\+\(b = 1\)\%dco \
Rie\_\(\(\[LeftDoubleBracket]\)\(i, j, a, \
b\)\(\[RightDoubleBracket]\)\)*\((vielbein\_\(\(\[LeftDoubleBracket]\)\(a\)\(\
\[RightDoubleBracket]\)\) ** 
                            vielbein\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\))\)\)}, {i, 1, dco}], {j, 1, 
              dco}]; \[IndentingNewLine]Print["\<I find the following \
answer\>"]; \[IndentingNewLine]Do[
            Do[Print["\<R[\>", i, j, "\<] = \>", RR[\([i, j]\)]], {j, i + 1, 
                dco}], {i, 1, 
              dco}]; \[IndentingNewLine]Print["\<Now choose a value for the \
rescaling parameters\>"]; \[IndentingNewLine]Print["\<writing rullina = \
{....}\>"]; \[IndentingNewLine]Print["\<Then type redisplay\>"];};\)\), "\
\[IndentingNewLine]", 
    \(redisplay := {\[IndentingNewLine]RRR = 
          Simplify[
            ReplaceAll[RR, 
              rullina]]; \[IndentingNewLine]Print["\<Now the curvature 2-form \
is:\>"]; \[IndentingNewLine]Do[
          Do[Print["\<R[\>", i, j, "\<] = \>", RRR[\([i, j]\)]], {j, i + 1, 
              dco}], {i, 1, 
            dco}]; \[IndentingNewLine]Print["\<and the Ricci tensor is:\>"]\
\[IndentingNewLine]Print["\<Ricci = \>", 
            MatrixForm[
              Simplify[
                ReplaceAll[ricten, 
                  rullina]]]]; \[IndentingNewLine]Print["\<In case you want \
to see the order of generators type generorder\>"]; \
\[IndentingNewLine]Print["\<Warning: This applies only to the CP2 \
case\>"];}\), "\[IndentingNewLine]", 
    \(\(\(generorder := {\[IndentingNewLine]\(Do[
              Print["\<gen # \>", i, "\< = lambda[\>", 
                ordvec[\([i]\)], "\<]\>"], {i, 1, 
                8}];\)};\)\(\[IndentingNewLine]\)
    \)\)}], "Input",
  CellLabel->"In[16]:="]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["\<\
Geometry of Quasi Homogeneous manifolds (euclidean, or lorentzian) and of \
General Manifolds (general signature)\
\>", "Section"],

Cell[TextData[{
  "This routine is devised to calculate the geometry in the following very \
common situation where the vielbein of a space in dimension \nn=1+r\nis given \
in the following form:\n",
  Cell[BoxData[
      \(TraditionalForm\`e\^1\)]],
  "=d\[Mu]\n",
  Cell[BoxData[
      \(TraditionalForm\`e\^i\)]],
  "=",
  Cell[BoxData[
      FormBox[
        SuperscriptBox[
          RowBox[{
            FormBox[\(f\_i\),
              "TraditionalForm"], "(", "\[Mu]", ")"}], "i"], 
        TraditionalForm]]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  "\nwhere ",
  Cell[BoxData[
      \(TraditionalForm\`f\_i\)]],
  "(\[Mu]) are functions of the coordinate \[Mu] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  " are vielbeins of an r-dimensional space for which the contorsion is \
already known:\nd",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  "= - ",
  Cell[BoxData[
      \(TraditionalForm\`t\_\(\(\ \ \)\(jk\)\)\%i\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^j\)]],
  " \[And] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^k\)]],
  "\nWe name such manifolds quasi homogeneous"
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["Main", "Subsection"],

Cell[TextData[{
  "You start this programme by typing ",
  StyleBox["mainspin",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["routine", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(mainspin := \
{\[IndentingNewLine]\(contors;\)}\)\)\)], "Input",
  CellLabel->"In[19]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(contors\\)\\\" is similar to existing symbol \
\\\"\\!\\(contor\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[19]:="]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Spin connection and curvature routines", "Subsection"],

Cell[TextData[{
  "This routine is devised to calculate the intrinsic components of the spin \
connection once the contorsion tensor as already been calculated \nd",
  Cell[BoxData[
      \(TraditionalForm\`e\^i\)]],
  "= ",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(\(\ \ \ \ \)\(jk\)\)\%i\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`e\^\(\(i\)\(\ \)\)\)]],
  "\[And] ",
  Cell[BoxData[
      \(TraditionalForm\`e\^k\)]],
  "\nThere are two versions of the programme one for quasi homogeneous \
manifolds called ",
  StyleBox["spinpack",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  " and one for general manifolds called ",
  StyleBox["spinpackgen\n",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox["in the second case you will prompted to supply also the signature \
of space-time a n vector of plus or minus  1.s = ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["signat",
    FontWeight->"Bold",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["\n",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(spinpack := {\[IndentingNewLine]Print["\<I \
start\>"]; \[IndentingNewLine]mdim = r + 1; \n
          Print["\<now give me the contorsion tensor\>"]; \n
          Print["\<by writing cont= ?\>"]; \[IndentingNewLine]Print["\< then \
resume the calculation by typing
spinresume\>"];};\)\[IndentingNewLine]
    \(\(spinresume := {\[IndentingNewLine]vielbein = 
            Table[e\_i, {i, 1, 
                mdim}]; \[IndentingNewLine]Print["\<I resume the calculation \
of the spin connection\>"]; \[IndentingNewLine]ometen = 
            Table[0, {i, 1, mdim}, {j, 1, mdim}, {k, 1, 
                mdim}]; \[IndentingNewLine]Do[
            Do[Do[\[IndentingNewLine]ometen\_\(\(\[LeftDoubleBracket]\)\(i, \
\[ScriptL], m\)\(\[RightDoubleBracket]\)\) = 
                  cont\_\(\(\[LeftDoubleBracket]\)\(i, \[ScriptL], m\)\(\
\[RightDoubleBracket]\)\)\n + 
                    cont\_\(\(\[LeftDoubleBracket]\)\(\[ScriptL], m, i\)\(\
\[RightDoubleBracket]\)\) - 
                    cont\_\(\(\[LeftDoubleBracket]\)\(m, i, \[ScriptL]\)\(\
\[RightDoubleBracket]\)\), {i, 1, mdim}], {\[ScriptL], 1, mdim}], {m, 1, 
              mdim}]; \[IndentingNewLine]omega = 
            Table[0, {i, 1, mdim}, {\[ScriptL], 1, 
                mdim}]; \[IndentingNewLine]Do[
            Do[omega\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\) = \[Sum]\+\(m = 1\)\%mdim ometen\_\(\(\
\[LeftDoubleBracket]\)\(i, j, m\)\(\[RightDoubleBracket]\)\)*
                    vielbein\_\(\(\[LeftDoubleBracket]\)\(m\)\(\
\[RightDoubleBracket]\)\), {i, 1, mdim}], {j, 1, 
              mdim}]; \[IndentingNewLine]Print["\<-----------------\>"]; \
\[IndentingNewLine]Print["\<the result is\>"]; \[IndentingNewLine]Do[
            Do[\[IndentingNewLine]Print["\<\[Omega][\>", i, j, "\<] = \>", 
                omega\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\)], {j, i + 1, mdim}], {i, 1, 
              mdim}]; \[IndentingNewLine]Print["\<Task finished\>"]; \
\[IndentingNewLine]Print["\<The result is encoded in a tensor omega[i,j]\>"]; \
\[IndentingNewLine]Print["\<Its components are encoded in a tensor \
ometen[i,j,m]\>"]; \[IndentingNewLine]Print["\<If you want the curvature, \
type curvapack for quasi homogeneous manifolds\>"];\[IndentingNewLine]};\)\(\
\[IndentingNewLine]\)
    \)\[IndentingNewLine]
    \(spinpackgen := {\[IndentingNewLine]Print["\<I start\>"]; \
\[IndentingNewLine]mdim = dimse; \n
          Print["\<now give me the contorsion tensor\>"]; \n
          Print["\<by writing cont= ?\>"]; \[IndentingNewLine]Print["\<and \
give me the signature a vector of +/- 1\>"]; \[IndentingNewLine]Print["\<by \
writing signat = ? \>"]; \[IndentingNewLine]Print["\<then resume the \
calculation by typing
spinresumegen\>"];};\)\[IndentingNewLine]
    \(spinresumegen := {\[IndentingNewLine]vielbein = 
            Table[e\_i, {i, 1, 
                mdim}]; \[IndentingNewLine]Print["\<I resume the calculation \
of the spin connection\>"]; \[IndentingNewLine]ometen1 = 
            Table[0, {i, 1, mdim}, {j, 1, mdim}, {k, 1, 
                mdim}]; \[IndentingNewLine]ometen = 
            Table[0, {i, 1, mdim}, {j, 1, mdim}, {k, 1, 
                mdim}]; \[IndentingNewLine]cont1 = 
            Table[0, {i, 1, mdim}, {j, 1, mdim}, {k, 1, 
                mdim}]; \[IndentingNewLine]Do[
            cont1[\([i]\)] = signat[\([i]\)]*cont[\([i]\)], {i, 1, 
              mdim}]; \[IndentingNewLine]Do[
            Do[Do[\[IndentingNewLine]ometen1\_\(\(\[LeftDoubleBracket]\)\(i, \
\[ScriptL], m\)\(\[RightDoubleBracket]\)\) = 
                  cont1\_\(\(\[LeftDoubleBracket]\)\(i, \[ScriptL], m\)\(\
\[RightDoubleBracket]\)\) + 
                    cont1\_\(\(\[LeftDoubleBracket]\)\(\[ScriptL], m, i\)\(\
\[RightDoubleBracket]\)\) - 
                    cont1\_\(\(\[LeftDoubleBracket]\)\(m, i, \[ScriptL]\)\(\
\[RightDoubleBracket]\)\), {i, 1, mdim}], {\[ScriptL], 1, mdim}], {m, 1, 
              mdim}]; \[IndentingNewLine]Do[
            Do[ometen\_\(\(\[LeftDoubleBracket]\)\(i, \[ScriptL]\)\(\
\[RightDoubleBracket]\)\) = 
                ometen1\_\(\(\[LeftDoubleBracket]\)\(i, \[ScriptL]\)\(\
\[RightDoubleBracket]\)\)*signat[\([i]\)]*
                  signat[\([\[ScriptL]]\)], {\[ScriptL], 1, mdim}], {i, 1, 
              mdim}]; \[IndentingNewLine]omega = 
            Table[0, {i, 1, mdim}, {\[ScriptL], 1, 
                mdim}]; \[IndentingNewLine]Do[
            Do[
              omega\_\(\(\[LeftDoubleBracket]\)\(i, \
j\)\(\[RightDoubleBracket]\)\) = \[Sum]\+\(m = 1\)\%mdim ometen\_\(\(\
\[LeftDoubleBracket]\)\(i, j, m\)\(\[RightDoubleBracket]\)\)*
                    vielbein\_\(\(\[LeftDoubleBracket]\)\(m\)\(\
\[RightDoubleBracket]\)\), {i, 1, mdim}], {j, 1, 
              mdim}]; \[IndentingNewLine]Print["\<-----------------\>"]; \
\[IndentingNewLine]Print["\<the result is\>"]; \[IndentingNewLine]Do[
            Do[\[IndentingNewLine]Print["\<\[Omega][\>", i, j, "\<] = \>", 
                omega\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\)], {j, i + 1, mdim}], {i, 1, 
              mdim}]; \[IndentingNewLine]Print["\<Task finished\>"]; \
\[IndentingNewLine]Print["\<The result is encoded in a tensor omega[i,j]\>"]; \
\[IndentingNewLine]Print["\<Its components are encoded in a tensor \
ometen[i,j,m]\>"]; \[IndentingNewLine]Print["\<If you want the curvature, \
type curvapack for quasi homogeneous manifolds\>"]; \
\[IndentingNewLine]Print["\<Otherwise, type curvapackgen for general \
manifolds\>"];\[IndentingNewLine]};\)\[IndentingNewLine]\[IndentingNewLine]
    \)\)\)], "Input",
  CellLabel->"In[20]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(cont\\)\\\" is similar to existing symbol \\\
\"\\!\\(conn\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[20]:="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["routine curvapack", "Subsection"],

Cell[TextData[{
  "This routine is devised to calculate the  curvature of a manifold when the \
intrinsic components of the spin connection depend only on one coordinate \
\[Mu] and the first vielbein is\n",
  Cell[BoxData[
      \(TraditionalForm\`e\_1\)]],
  "= A(\[Mu])*d\[Mu]"
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["routine", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(curvapack := {\[IndentingNewLine]Print["\<-----------------\>"]; \
\[IndentingNewLine]Print["\< I calculate the Riemann tensor\>"]; \
\[IndentingNewLine]deltaf = IdentityMatrix[mdim]; \[IndentingNewLine]Rie = 
          Table[0, {a, 1, mdim}, {b, 1, mdim}, {f, 1, mdim}, {g, 1, 
              mdim}]; \[IndentingNewLine]Do[
          Do[Do[Do[\[IndentingNewLine]Rie[\([a, b, f, 
                      g]\)] = \[IndentingNewLine]Simplify[\[Sum]\+\(c = \
1\)\%mdim\((\(1\/2\) \((ometen\_\(\(\[LeftDoubleBracket]\)\(a, c, f\)\(\
\[RightDoubleBracket]\)\)*
                                    signat\_\(\(\[LeftDoubleBracket]\)\(c\)\(\
\[RightDoubleBracket]\)\)*
                                    ometen\_\(\(\[LeftDoubleBracket]\)\(c, b, \
g\)\(\[RightDoubleBracket]\)\) - \[IndentingNewLine]ometen\_\(\(\
\[LeftDoubleBracket]\)\(a, c, g\)\(\[RightDoubleBracket]\)\)*
                                    signat\_\(\(\[LeftDoubleBracket]\)\(c\)\(\
\[RightDoubleBracket]\)\)*
                                    ometen\_\(\(\[LeftDoubleBracket]\)\(c, b, \
f\)\(\[RightDoubleBracket]\)\))\) + \[IndentingNewLine]\(1\/2\) \((ometen\_\(\
\(\[LeftDoubleBracket]\)\(a, b, c\)\(\[RightDoubleBracket]\)\)*
                                    cont\_\(\(\[LeftDoubleBracket]\)\(c, f, g\
\)\(\[RightDoubleBracket]\)\) - 
                                  ometen\_\(\(\[LeftDoubleBracket]\)\(a, b, c\
\)\(\[RightDoubleBracket]\)\)*
                                    cont\_\(\(\[LeftDoubleBracket]\)\(c, g, f\
\)\(\[RightDoubleBracket]\)\))\))\) + \
\[IndentingNewLine]1\/\(2*Afac\)*\((deltaf\_\(\(\[LeftDoubleBracket]\)\(1, \
f\)\(\[RightDoubleBracket]\)\)*\[PartialD]\_\[Mu]\ 
                                ometen\_\(\(\[LeftDoubleBracket]\)\(a, b, g\)\
\(\[RightDoubleBracket]\)\)*\((1 - 
                                  deltaf\_\(\(\[LeftDoubleBracket]\)\(1, \
g\)\(\[RightDoubleBracket]\)\))\) - \[IndentingNewLine]deltaf\_\(\(\
\[LeftDoubleBracket]\)\(1, g\)\(\[RightDoubleBracket]\)\)*\[PartialD]\_\[Mu]\ 
                                ometen\_\(\(\[LeftDoubleBracket]\)\(a, b, f\)\
\(\[RightDoubleBracket]\)\)*\((1 - 
                                  deltaf\_\(\(\[LeftDoubleBracket]\)\(1, \
f\)\(\[RightDoubleBracket]\)\))\))\), Trig \[Rule] True], {a, 1, mdim}], {b, 
                1, mdim}], {f, 1, mdim}], {g, 1, 
            mdim}]; \[IndentingNewLine]Print["\<------------------------------\
------\>"]; \[IndentingNewLine]Print["\<Now I evaluate the curvature 2-form \
of your space\>"]; \[IndentingNewLine]vielbein = Table[e\_i, {i, 1, mdim}]; \n
        RR = Table[0, {i, 1, mdim}, {j, 1, mdim}]; \n
        Do[Do[\ {RR[\([i, 
                    j]\)] = \[Sum]\+\(a = 1\)\%mdim\(\[Sum]\+\(b = 1\)\%mdim \
Rie\_\(\(\[LeftDoubleBracket]\)\(i, j, a, \
b\)\(\[RightDoubleBracket]\)\)*\((vielbein\_\(\(\[LeftDoubleBracket]\)\(a\)\(\
\[RightDoubleBracket]\)\) ** 
                          vielbein\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\))\)\)}, {i, 1, mdim}], {j, 1, 
            mdim}]; \[IndentingNewLine]Print["\<I find the following \
answer\>"]; \[IndentingNewLine]Do[
          Do[Print["\<R[\>", i, j, "\<] = \>", RR[\([i, j]\)]], {j, i + 1, 
              mdim}], {i, 1, 
            mdim}]; \[IndentingNewLine]Print["\<The result is encoded in a \
tensor RR[i,j]\>"]; \[IndentingNewLine]Print["\<Its components are encoded in \
a tensor Rie[i,j,a,b]\>"];}\)\(\[IndentingNewLine]\)
    \)\)], "Input",
  CellLabel->"In[24]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(deltaf\\)\\\" is similar to existing symbols \
\\!\\({delta, deltaa}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[24]:="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Routine curvapackgen", "Subsection"],

Cell[TextData[{
  "This routine is devised to calculate the curvature two form and the \
Riemann tensor in a general situation for an arbitrary dimensional manifold \
and with the vielbein depending on all the coordinates. You can start this \
programme only after having computed the spin connection via the package ",
  StyleBox["spinpack",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  "\n"
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(curvapackgen := \
{\[IndentingNewLine]Print["\<-----------------\>"]; \
\[IndentingNewLine]Print["\< I calculate the Riemann tensor\>"]; \
\[IndentingNewLine]\[IndentingNewLine]Rie = 
          Table[0, {a, 1, mdim}, {b, 1, mdim}, {f, 1, mdim}, {g, 1, 
              mdim}]; \[IndentingNewLine]Print["\<I tell you my steps :\>"]; \
\[IndentingNewLine]Do[{Print["\< a = \>", a]; 
            Do[{Print["\< b = \>", b]; 
                Do[Do[{\[IndentingNewLine]urdo = 
                        1\/2*\((\[Sum]\+\(z = 1\)\%mdim\( 
                                      InvEmatri\_\(\(\[LeftDoubleBracket]\)\(\
z, f\)\(\[RightDoubleBracket]\)\)\) \[PartialD]\_\(coordi[\([z]\)]\)\ 
                                    ometen\_\(\(\[LeftDoubleBracket]\)\(a, b, \
g\)\(\[RightDoubleBracket]\)\) - \[IndentingNewLine]\[Sum]\+\(z = 1\)\%mdim\( 
                                      InvEmatri\_\(\(\[LeftDoubleBracket]\)\(\
z, g\)\(\[RightDoubleBracket]\)\)\) \[PartialD]\_\(coordi[\([z]\)]\)\ 
                                    ometen\_\(\(\[LeftDoubleBracket]\)\(a, b, \
f\)\(\[RightDoubleBracket]\)\))\); \[IndentingNewLine]urdo = 
                        Simplify[urdo, 
                          Trig \[Rule] True]; \[IndentingNewLine]puf = 
                        Simplify[\[Sum]\+\(x = 1\)\%mdim ometen\_\(\(\
\[LeftDoubleBracket]\)\(a, b, x\)\(\[RightDoubleBracket]\)\)*
                              contens\_\(\(\[LeftDoubleBracket]\)\(x, f, \
g\)\(\[RightDoubleBracket]\)\), 
                          Trig \[Rule] True]; \[IndentingNewLine]weggio = 
                        Simplify[\[Sum]\+\(z = 1\)\%mdim ometen\_\(\(\
\[LeftDoubleBracket]\)\(a, z, f\)\(\[RightDoubleBracket]\)\)*
                                ometen\_\(\(\[LeftDoubleBracket]\)\(z, b, g\)\
\(\[RightDoubleBracket]\)\)*
                                signat\_\(\(\[LeftDoubleBracket]\)\(z\)\(\
\[RightDoubleBracket]\)\) - \[Sum]\+\(z = 1\)\%mdim ometen\_\(\(\
\[LeftDoubleBracket]\)\(a, z, g\)\(\[RightDoubleBracket]\)\)*
                                ometen\_\(\(\[LeftDoubleBracket]\)\(z, b, f\)\
\(\[RightDoubleBracket]\)\)*
                                signat\_\(\(\[LeftDoubleBracket]\)\(z\)\(\
\[RightDoubleBracket]\)\) - \[IndentingNewLine]\[Sum]\+\(z = 1\)\%mdim ometen\
\_\(\(\[LeftDoubleBracket]\)\(b, z, f\)\(\[RightDoubleBracket]\)\)*
                                ometen\_\(\(\[LeftDoubleBracket]\)\(z, a, g\)\
\(\[RightDoubleBracket]\)\)*
                                signat\_\(\(\[LeftDoubleBracket]\)\(z\)\(\
\[RightDoubleBracket]\)\) + \[IndentingNewLine]\[Sum]\+\(z = 1\)\%mdim ometen\
\_\(\(\[LeftDoubleBracket]\)\(b, z, g\)\(\[RightDoubleBracket]\)\)*
                                ometen\_\(\(\[LeftDoubleBracket]\)\(z, a, f\)\
\(\[RightDoubleBracket]\)\)*
                                signat\_\(\(\[LeftDoubleBracket]\)\(z\)\(\
\[RightDoubleBracket]\)\), 
                          Trig \[Rule] True]; \[IndentingNewLine]Rie[\([a, b, 
                            f, g]\)] = 
                        Simplify[
                          urdo + puf + \(1\/4\) weggio\[IndentingNewLine], 
                          Trig \[Rule] True];}, {f, 1, dimse}], {g, 1, 
                    dimse}];}, {b, 1, dimse}];}, {a, 1, 
            dimse}]; \[IndentingNewLine]Print["\<Finished\>"]; \
\[IndentingNewLine]Print["\<------------------------------------\>"]; \
\[IndentingNewLine]Print["\<Now I evaluate the curvature 2-form of your space\
\>"]; \[IndentingNewLine]vielbein = Table[e\_i, {i, 1, mdim}]; \n
        RR = Table[0, {i, 1, mdim}, {j, 1, mdim}]; \n
        Do[Do[\ {RR[\([i, j]\)] = 
                Simplify[
                  2*\(\[Sum]\+\(a = 1\)\%mdim\(\[Sum]\+\(b = a + 1\)\%mdim \
Rie\_\(\(\[LeftDoubleBracket]\)\(i, j, a, \
b\)\(\[RightDoubleBracket]\)\)*\((vielbein\_\(\(\[LeftDoubleBracket]\)\(a\)\(\
\[RightDoubleBracket]\)\) ** 
                              vielbein\_\(\(\[LeftDoubleBracket]\)\(b\)\(\
\[RightDoubleBracket]\)\))\)\)\)]}, {i, 1, mdim}], {j, 1, 
            mdim}]; \[IndentingNewLine]Print["\<I find the following \
answer\>"]; \[IndentingNewLine]Do[
          Do[Print["\<R[\>", i, j, "\<] = \>", RR[\([i, j]\)]], {j, i + 1, 
              mdim}], {i, 1, 
            mdim}]; \[IndentingNewLine]Print["\<The result is encoded in a \
tensor RR[i,j]\>"]; \[IndentingNewLine]Print["\<Its components are encoded in \
a tensor Rie[i,j,a,b]\>"]; \
\[IndentingNewLine]Print["\<-------------------------------------\>"]; \n\t\t\
Print["\< Now I calculate the Ricci tensor\>"]; \t\n\t
        ricten = Table[0, {a, 1, mdim}, {b, 1, mdim}\ ]; \n
        Do[ricci[b, e] = Simplify[Sum[Rie[\([a, b, a, e]\)], {a, mdim}]]; \n
          If[ricci[b, e] =!= 
              0, {\n\t\t\t\t\tPrint[b, "\< \>", 
                e, "\< \>", "\<  non zero\>"]; \n\t\t\t\t\txz = 
                ricci[b, e]; \n\t\t\t\t\tricten\[LeftDoubleBracket]b, 
                  e\[RightDoubleBracket] = 
                xz; \n\t\t\t\t\tricten\[LeftDoubleBracket]e, 
                  b\[RightDoubleBracket] = xz;}], \n{b, mdim}, {e, 
            mdim}]; \n\t\t\t\tPrint["\<I have finished the calculation\>"]; \n\
\t\t\tPrint["\< The tensor ricten[a,b]] giving the Ricci tensor \>"]; \n\t\t\t\
Print["\< is ready for storing on hard disk\>"]; \n\t\t\tPrint["\<Ricci[a,] = \
\>", \ MatrixForm[
            ricten]]; \n\t\t\tPrint["\<----------------------------\>"];}\)\)\
\)], "Input",
  CellLabel->"In[25]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Contorsion routine for mixed vielbeins", "Subsection"],

Cell[TextData[{
  "This routine is devised to calculate the contorsion tensor in the \
following very common situation where the vielbein of a space in dimension \n\
n=1+r\nis given in the following form:\n",
  Cell[BoxData[
      \(TraditionalForm\`e\^1\)]],
  "=A(\[Mu])d\[Mu]\n",
  Cell[BoxData[
      \(TraditionalForm\`e\^i\)]],
  "=",
  Cell[BoxData[
      \(TraditionalForm\`f\_i\)]],
  "(\[Mu]) ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  "\nwhere ",
  Cell[BoxData[
      \(TraditionalForm\`f\_i\)]],
  "(\[Mu]) are functions of the coordinate \[Mu] and ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  " are vielbeins of an r-dimensional space for which the contorsion is \
already known:\nd",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^i\)]],
  "= - ",
  Cell[BoxData[
      \(TraditionalForm\`t\_\(\(\ \ \)\(jk\)\)\%i\)]],
  " ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^j\)]],
  " \[And] ",
  Cell[BoxData[
      \(TraditionalForm\`\[Sigma]\^k\)]],
  "\nSo that we find:\n",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(\(\ \ \ \)\(AB\)\)\%1\)]],
  "=0\n",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(\(\ \ \ \)\(1  i\)\)\%i\)]],
  "=",
  Cell[BoxData[
      \(TraditionalForm\`1\/2\)]],
  Cell[BoxData[
      \(TraditionalForm\`1\/\(A(\[Mu])\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\[PartialD]\_\[Mu]\ \(\(Log\)\([\)\(f\_i\)\)\)]],
  "(\[Mu])] \n",
  Cell[BoxData[
      \(TraditionalForm\`c\_\(\(\ \ \ \ \)\(jk\)\)\%i\)]],
  "= - ",
  Cell[BoxData[
      \(TraditionalForm\`\(\(f\_i\)(\[Mu])\)\/\(\(\(f\_j\)(\[Mu])\) \
\(\(f\_k\)(\[Mu])\)\)\)]],
  Cell[BoxData[
      \(TraditionalForm\`\(\(\ \)\(t\_\(\(\ \ \ \)\(jk\)\)\%i\)\)\)]],
  "\nTO START THE ROUTINE TYPE        ",
  StyleBox["contors",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine \
\>", "Subsubsection"],

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{
        RowBox[{
          RowBox[{"contors", ":=", 
            RowBox[{"{", "\[IndentingNewLine]", 
              
              RowBox[{\(Print["\<Give me the dimension of the codimension one \
subspace\>"]\), ";", "\[IndentingNewLine]", \(r = Input["\<r= ?\>"]\), ";", 
                "\[IndentingNewLine]", \(nnn = r + 1\), ";", 
                "\[IndentingNewLine]", \(Print["\<Now give me the \>", 
                  r, "\< x \>", 
                  r, \*"\"\< dimensional matrix \!\(f\_i\^j\)(\[Mu]) \
functions\>\""]\), ";", 
                "\[IndentingNewLine]", \(Print["\<Give it to me as \
scal=...\>"]\), ";", "\[IndentingNewLine]", 
                RowBox[{
                "Print", "[", 
                  "\"\<and give me the precontorsion tensor\n \
\!\(TraditionalForm\`t\_jk\%i\) as precon=...\>\"", "]"}], ";", 
                "\[IndentingNewLine]", \(Print["\<Give me the scale factor of \
the first vielbein\>"]\), ";", 
                "\[IndentingNewLine]", \(Print["\<Give it to me as Afac = A(\
\[Mu])\>"]\), ";", 
                "\[IndentingNewLine]", \(Print["\<Then resume the calculation \
typing:
contoresume\>"]\), ";"}], "}"}]}], ";"}], 
        "\[IndentingNewLine]", \(contoresume := {\[IndentingNewLine]scalmeno \
= Inverse[
                scal]; \[IndentingNewLine]Print["\<I resume the calculation \
of the contorsion\>"]; \[IndentingNewLine]contens = 
              Table[0, {i, 1, nnn}, {j, 1, nnn}, {k, 1, 
                  nnn}]; \[IndentingNewLine]Do[
              Do[{contens\_\(\(\[LeftDoubleBracket]\)\(k + 1, 1, j + 1\)\(\
\[RightDoubleBracket]\)\) = 
                    1\/Afac*\(1\/2\) 
                      Simplify[\[Sum]\+\(p = 1\)\%r\[PartialD]\_\[Mu]\ 
                              scal\_\(\(\[LeftDoubleBracket]\)\(k, p\)\(\
\[RightDoubleBracket]\)\)*
                            scalmeno\_\(\(\[LeftDoubleBracket]\)\(p, j\)\(\
\[RightDoubleBracket]\)\), 
                        Trig \[Rule] 
                          True]; \[IndentingNewLine]contens\_\(\(\
\[LeftDoubleBracket]\)\(k + 1, j + 1, 1\)\(\[RightDoubleBracket]\)\) = \(-\(1\
\/Afac\)\) \(1\/2\) Simplify[\[Sum]\+\(p = 1\)\%r\[PartialD]\_\[Mu]\ 
                              scal\_\(\(\[LeftDoubleBracket]\)\(k, p\)\(\
\[RightDoubleBracket]\)\)*
                            scalmeno\_\(\(\[LeftDoubleBracket]\)\(p, j\)\(\
\[RightDoubleBracket]\)\), Trig \[Rule] True]}, {k, 1, r}], {j, 1, 
                r}]; \[IndentingNewLine]Do[
              Do[Do[\[IndentingNewLine]contens\_\(\(\[LeftDoubleBracket]\)\(i \
+ 1, j + 1, k + 1\)\(\[RightDoubleBracket]\)\) = \ \(-\ 
                      Simplify[\[Sum]\+\(ip = 1\)\%r\(\[Sum]\+\(jp = 1\)\%r\(\
\[Sum]\+\(kp = 1\)\%3 scal\_\(\(\[LeftDoubleBracket]\)\(i, ip\)\(\
\[RightDoubleBracket]\)\)*
                                scalmeno\_\(\(\[LeftDoubleBracket]\)\(j, jp\)\
\(\[RightDoubleBracket]\)\)*
                                scalmeno\_\(\(\[LeftDoubleBracket]\)\(k, kp\)\
\(\[RightDoubleBracket]\)\)*
                                precon\_\(\(\[LeftDoubleBracket]\)\(ip, jp, \
kp\)\(\[RightDoubleBracket]\)\)\)\), Trig \[Rule] True]\), {i, 1, r}], {j, 1, 
                  r}], {k, 1, 
                r}]; \[IndentingNewLine]Print["\<I have finished!\>"]; \
\[IndentingNewLine]dimse = 
              r + 1; \[IndentingNewLine]Print["\<The contorsion is encoded in \
tensor named contens\>"]; \[IndentingNewLine]Print["\<Now you can begin the \
calculation of the spin connection by typing
spinpackgen\>"];}\)}], "\[IndentingNewLine]", 
      "\[IndentingNewLine]"}]], "Input",
  CellLabel->"In[26]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["calculation of the contorsion for general manifolds", "Subsection"],

Cell[TextData[{
  "This routine is devised to calculate the contorsion for general manifolds. \
The inputs are\n1) the dimension n\n2) the set of coordinates a n vector = ",
  StyleBox["coordi",
    FontWeight->"Bold"],
  "\n3) the set of differenetials, a nnn vector  = ",
  StyleBox["diffe",
    FontWeight->"Bold"],
  "\n4) the set of vielbein 1-forms a nnn vector = ",
  StyleBox["fform\n",
    FontWeight->"Bold"],
  StyleBox["TO START this programme you type ",
    FontSize->14,
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["contorgen",
    FontSize->14,
    FontWeight->"Bold",
    FontVariations->{"Underline"->True,
    "CompatibilityType"->0}],
  StyleBox[" and then you follow instructions",
    FontSize->14,
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(contorgen := \
{\[IndentingNewLine]Print["\<Give me the dimension of your space\>"]; \
\[IndentingNewLine]dimse = 
            Input["\<dimension = ?\>"]; \[IndentingNewLine]numco = 
            dimse; \[IndentingNewLine]Print["\<Your space has dimension n = \
\>", dimse]; \[IndentingNewLine]Print["\<Now I stop and you give me three \
vectors of dimension \>", 
            dimse]; \[IndentingNewLine]Print["\<vector fform = vector of \
1-form vielbeins\>"]; \[IndentingNewLine]Print["\<vector coordi = vector of \
coordinates\>"]; \[IndentingNewLine]Print["\<vector diffe = vector of \
differentials\>"]; \[IndentingNewLine]Print["\<Then resume the calculation \
typing: contorgenresume\>"]; \[IndentingNewLine]Print["\<If you already have \
the contorsion type\>"]; \[IndentingNewLine]Print["\<spinpackgen\>"];};\)\
\[IndentingNewLine]
    contorgenresume := {\[IndentingNewLine]Print["\<I calculate the exterior \
differentials of the vielbeins\>"]; \[IndentingNewLine]coeffi = 
          Table[0, {i, 1, dimse}, {j, 1, numco}]; \[IndentingNewLine]Do[
          Do[{udif = 
                diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\
\)\); \[IndentingNewLine]coeffi\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\) = 
                Coefficient[
                  fform\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\), udif];}, {j, 1, numco}], {i, 1, 
            dimse}]; \[IndentingNewLine]domeg = 
          Table[0, {i, 1, dimse}, {j, 1, dimse}, {k, 1, 
              dimse}]; \[IndentingNewLine]Do[
          Do[Do[\[IndentingNewLine]{var1 = 
                  coordi\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\); \[IndentingNewLine]var2 = 
                  coordi\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\); \[IndentingNewLine]temp1 = 
                  Simplify[\[PartialD]\_var1\ 
                      coeffi\_\(\(\[LeftDoubleBracket]\)\(i, k\)\(\
\[RightDoubleBracket]\)\), Trig \[Rule] True]; \[IndentingNewLine]temp2\  = 
                  Simplify[\[PartialD]\_var2\ 
                      coeffi\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\), 
                    Trig \[Rule] 
                      True]; \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ domeg\_\(\(\
\[LeftDoubleBracket]\)\(i, j, k\)\(\[RightDoubleBracket]\)\) = \(1\/2\) \
\((temp1 - temp2)\);}, {j, 1, numco}], {k, 1, numco}], {i, 1, 
            dimse}]; \[IndentingNewLine]Print["\<--------------------\>"]; \
\[IndentingNewLine]Print["\<I finished!\>"]; \[IndentingNewLine]Print["\<Next \
I calculate the inveverse vielbein\>"]; \[IndentingNewLine]Ematri = 
          Table[0, {i, 1, dimse}, {j, 1, dimse}]; \[IndentingNewLine]Do[
          Do[Ematri\_\(\(\[LeftDoubleBracket]\)\(i, \
j\)\(\[RightDoubleBracket]\)\) = 
              Coefficient[
                fform\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\
\)\), diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\)\)], {j, 
              1, dimse}], {i, 1, dimse}]; \[IndentingNewLine]InvEmatri = 
          Simplify[Inverse[Ematri], 
            Trig \[Rule] 
              True]; \[IndentingNewLine]Print["\<Done!\>"]; \
\[IndentingNewLine]Print["\<I resume the calculation of the contorsion\>"]; \
\[IndentingNewLine]contens = 
          Table[0, {i, 1, dimse}, {j, 1, dimse}, {k, 1, 
              dimse}]; \[IndentingNewLine]Print["\< I calculate the \
contorsion c[i,j,k] for \>"]; \[IndentingNewLine]\ 
        Do[\ {Print["\<i = \>", 
              i]; \[IndentingNewLine]contens\_\(\(\[LeftDoubleBracket]\)\(i\)\
\(\[RightDoubleBracket]\)\) = 
              Simplify[
                Transpose[InvEmatri] . 
                  domeg\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\) . InvEmatri, Trig \[Rule] True];}, {i, 1, 
            dimse}]; \[IndentingNewLine]Print["\<I have finished!\>"]; \
\[IndentingNewLine]vielbein = Table[e\_i, {i, 1, dimse}]; \n
        RR = Table[
            0, {i, 1, dimse}, {j, 1, dimse}]; \[IndentingNewLine]domegavec = 
          Table[0, {i, 1, dimse}]; \[IndentingNewLine]Do[\ 
          domegavec\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\
\) = 2*\(\[Sum]\+\(j = 1\)\%numco\(\[Sum]\+\(k = j + 1\)\%numco contens\_\(\(\
\[LeftDoubleBracket]\)\(i, j, k\)\(\[RightDoubleBracket]\)\)*
                    vielbein\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\) ** 
                      vielbein\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\)\)\), {i, 1, dimse}]; \[IndentingNewLine]dE = 
          domegavec; \[IndentingNewLine]Print["\<The result, encoded in a \
vector dE[i] is the following:\>"]; \[IndentingNewLine]Do[
          Print["\<dE[\>", i, "\<] = \>", \ domegavec[\([i]\)]], {i, 1, 
            dimse}]; \
\[IndentingNewLine]Print["\<-----------------------------\>"]; \
\[IndentingNewLine]Print["\<The contorsion is encoded in tensor named contens\
\>"]; \[IndentingNewLine]Print["\<-------------------------------\>"]; \
\[IndentingNewLine]Print["\<Now you can begin the calculation of the spin \
connection by typing
spinpackgen\>"];}\)\)\)], "Input",
  CellLabel->"In[28]:="]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculation for Cartan Maurer equations and vielbein differentials (Euclidean \
signature)\
\>", "Section"],

Cell[TextData[{
  "This package is devised to calculate the exterior differential of a set of \
1-forms, for instance vielbeins or Cartan Maurer 1-forms\nThis part is \
initialized by typing ",
  StyleBox["extdiff\n",
    FontWeight->"Bold"],
  StyleBox["then yo follow the computer instructions",
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(extdiff := {\[IndentingNewLine]Print["\<I \
calculate the exterior differential of the set of 1-forms you give me\>"]; \
\[IndentingNewLine]Print["\<and I also calculate the exterior products of the \
same forms\>"]; \[IndentingNewLine]Print["\<Give me the dimension of your set\
\>"]; \[IndentingNewLine]dimse = 
            Input["\<number of 1 forms\>"]; \[IndentingNewLine]Print["\<Now \
give me the number of coordinates they depend on\>"]; \
\[IndentingNewLine]numco = 
            Input["\<Number of coordinates\>"]; \
\[IndentingNewLine]Print["\<Now I stop and you give me three vectors\>"]; \
\[IndentingNewLine]Print["\<vector fform = vector of 1-forms\>"]; \
\[IndentingNewLine]Print["\<vector coordi = vector of coordinates\>"]; \
\[IndentingNewLine]Print["\<vector diffe = vector of differentials\>"]; \
\[IndentingNewLine]Print["\<-------------------\>"]; \
\[IndentingNewLine]Print["\<After that input, to resume the calculation, type \
resumdiff\>"];\[IndentingNewLine]};\)\[IndentingNewLine]
    \(\(resumdiff := {\[IndentingNewLine]Print["\<I resume the calculation of \
the exterior differentials\>"]; \[IndentingNewLine]coeffi = 
          Table[0, {i, 1, dimse}, {j, 1, numco}]; \[IndentingNewLine]Do[
          Do[{udif = 
                diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\[RightDoubleBracket]\
\)\); \[IndentingNewLine]coeffi\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\) = 
                Coefficient[
                  fform\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\), udif];}, {j, 1, numco}], {i, 1, 
            dimse}]; \[IndentingNewLine]domeg = 
          Table[0, {i, 1, dimse}, {j, 1, numco}, {k, 1, 
              numco}]; \[IndentingNewLine]Do[
          Do[Do[\[IndentingNewLine]{var1 = 
                  coordi\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\); \[IndentingNewLine]var2 = 
                  coordi\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\); \[IndentingNewLine]temp1 = 
                  Simplify[\[PartialD]\_var1\ 
                      coeffi\_\(\(\[LeftDoubleBracket]\)\(i, k\)\(\
\[RightDoubleBracket]\)\), Trig \[Rule] True]; \[IndentingNewLine]temp2\  = 
                  Simplify[\[PartialD]\_var2\ 
                      coeffi\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\), 
                    Trig \[Rule] 
                      True]; \n\ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ domeg\_\(\(\
\[LeftDoubleBracket]\)\(i, j, k\)\(\[RightDoubleBracket]\)\) = \(1\/2\) \
\((temp1 - temp2)\);}, {j, 1, numco}], {k, 1, numco}], {i, 1, 
            dimse}]; \[IndentingNewLine]domegavec = 
          Table[0, {i, 1, dimse}]; \[IndentingNewLine]Do[\ 
          domegavec\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\
\) = 2*\(\[Sum]\+\(j = 1\)\%numco\(\[Sum]\+\(k = j + 1\)\%numco domeg\_\(\(\
\[LeftDoubleBracket]\)\(i, j, k\)\(\[RightDoubleBracket]\)\)*
                    diffe\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\) ** 
                      diffe\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\)\)\), {i, 1, dimse}]; \[IndentingNewLine]dE = 
          domegavec; \[IndentingNewLine]Print["\<--------------------\>"]; \
\[IndentingNewLine]Print["\<I finished!\>"]; \[IndentingNewLine]Print["\<The \
result, encoded in a vector dE[i] is the following:\>"]; \
\[IndentingNewLine]Do[
          Print["\<dE[\>", i, "\<] = \>", \ domegavec[\([i]\)]], {i, 1, 
            dimse}]; \
\[IndentingNewLine]Print["\<-----------------------------\>"]; \
\[IndentingNewLine]Print["\<Next I calculate the exterior products\>"]; \
\[IndentingNewLine]producto = 
          Table[0, {i, 1, dimse}, {j, 1, 
              dimse}]; \[IndentingNewLine]coefprodi = 
          Table[0, {i, 1, dimse}, {j, 1, dimse}, {k, 1, numco}, {p, 1, 
              numco}]; \[IndentingNewLine]Do[
          Do[Do[Do[\[IndentingNewLine]coefprodi\_\(\(\[LeftDoubleBracket]\)\(\
i, j, k, p\)\(\[RightDoubleBracket]\)\) = \(1\/2\) 
                    Simplify[\((coeffi\_\(\(\[LeftDoubleBracket]\)\(i, k\)\(\
\[RightDoubleBracket]\)\)*\[IndentingNewLine]coeffi\_\(\(\[LeftDoubleBracket]\
\)\(j, p\)\(\[RightDoubleBracket]\)\) - 
                          coeffi\_\(\(\[LeftDoubleBracket]\)\(i, p\)\(\
\[RightDoubleBracket]\)\)*\[IndentingNewLine]coeffi\_\(\(\[LeftDoubleBracket]\
\)\(j, k\)\(\[RightDoubleBracket]\)\))\), 
                      Trig \[Rule] True], \[IndentingNewLine]{k, 1, 
                  numco}], {p, 1, numco}], {j, 1, dimse}], {i, 1, 
            dimse}]; \[IndentingNewLine]Do[
          Do[\[IndentingNewLine]producto\_\(\(\[LeftDoubleBracket]\)\(i, \
j\)\(\[RightDoubleBracket]\)\) = 
              2*\(\[Sum]\+\(p = 1\)\%numco\(\[Sum]\+\(k = p + 1\)\%numco \
coefprodi\_\(\(\[LeftDoubleBracket]\)\(i, j, p, \
k\)\(\[RightDoubleBracket]\)\)*
                      diffe\_\(\(\[LeftDoubleBracket]\)\(p\)\(\
\[RightDoubleBracket]\)\) ** 
                        diffe\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\)\)\), {j, 1, dimse}], {i, 1, 
            dimse}]; \[IndentingNewLine]EWE = 
          producto; \[IndentingNewLine]Print["\<---------------------\>"]; \
\[IndentingNewLine]Print["\<The result, encoded in a tensor EWE[i,j] is;\>"]; \
\[IndentingNewLine]Do[
          Do[Print["\<E[\>", i, "\<]\[And]E[\>", j, "\<] = \>", \ 
              producto[\([i, j]\)]], {j, i + 1, dimse}], {i, 1, 
            dimse}];\[IndentingNewLine]}\)\(\[IndentingNewLine]\)\(\
\[IndentingNewLine]\)
    \)\)\)\)], "Input",
  CellLabel->"In[30]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["SO(3), SO(4) t' Hooft matrices and Euler angles", "Section"],

Cell[TextData[{
  "This programme is devised to calculate the differential 1 forms on the 3 \
sphere in terms of the Euler angles, introducing the self dual and antiself \
dual generators of the SO(4) group, namely the 't Hooft matrices. This \
calculation relies on the routine ",
  StyleBox["spheres",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  " belonging to another section of this notebook.\nYOU START THIS PROGRAMME \
by TYPING ",
  StyleBox["eulerus.",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox[" When you will prompted for the sphere dimension you have to type \
3.\nThe output 1-forms are encoded in two 3-vectors named ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["sigmap",
    FontWeight->"Bold",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox[" and ",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["sigmam, ",
    FontWeight->"Bold",
    FontVariations->{"CompatibilityType"->0}],
  StyleBox["respectively",
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine eulerus\
\>", "Subsubsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(eulerus \
:= \[IndentingNewLine]{Print["\<------------------------------------\>"]; \
\[IndentingNewLine]Print["\<This programme calculates the left-invariant one \
forms of SO(3) in terms of the euler 
angles\>"]; \[IndentingNewLine]spheres; \[IndentingNewLine]vec = {1, 0, 0, 
            0}; \[IndentingNewLine]L1 = 
          MatrixExp[\[Psi]*gg[\([1]\)]]; \[IndentingNewLine]L2 = 
          MatrixExp[\(-\[Theta]\)*gg[\([2]\)]]; \[IndentingNewLine]L3 = 
          MatrixExp[\(-\[CurlyPhi]\)*gg[\([3]\)]]; \[IndentingNewLine]MM = 
          L3 . L2 . 
            L1; \[IndentingNewLine]Print["\< A unit four-vector of SO(4) is \
parametrized as follows\>"]; \[IndentingNewLine]Print[
          MatrixForm[
            L3 . L2 . L1 . 
              vec]]; \[IndentingNewLine]Print["\<This defines the Euler \
angles\>"]; \[IndentingNewLine]dM = 
          Simplify[\[PartialD]\_\[Psi]\ MM\ *
                d\[Psi] + \[PartialD]\_\[Theta]\ MM*
                d\[Theta] + \[PartialD]\_\[CurlyPhi]\ MM*
                d\[CurlyPhi]]; \[IndentingNewLine]dM = 
          Simplify[\[PartialD]\_\[Psi]\ MM\ *
                d\[Psi] + \[PartialD]\_\[Theta]\ MM*
                d\[Theta] + \[PartialD]\_\[CurlyPhi]\ MM*
                d\[CurlyPhi]]; \[IndentingNewLine]thoft; \[IndentingNewLine]\
\[CapitalOmega] = 
          Simplify[Transpose[MM] . dM, 
            Trig \[Rule] True]; \[IndentingNewLine]xx1 = 
          Jp1 . \[CapitalOmega]; \[IndentingNewLine]\(xx2 = 
              Jp2 . \[CapitalOmega];\)\[IndentingNewLine]\(xx3 = 
              Jp3 . \[CapitalOmega];\)\[IndentingNewLine]\(sig1 = 
              Simplify[\(1\/2\) \(\[Sum]\+\(s = 1\)\%4 xx1\_\(\(\
\[LeftDoubleBracket]\)\(s, s\)\(\[RightDoubleBracket]\)\)\)];\)\
\[IndentingNewLine]\(sig2 = \ 
              Simplify[
                1\/2\ \(\[Sum]\+\(s = 1\)\%4 \
xx2\_\(\(\[LeftDoubleBracket]\)\(s, s\)\(\[RightDoubleBracket]\)\)\)];\)\
\[IndentingNewLine]\(sig3 = 
            Simplify[
              1\/2\ \(\[Sum]\+\(s = 1\)\%4 \
xx3\_\(\(\[LeftDoubleBracket]\)\(s, s\)\(\[RightDoubleBracket]\)\)\)]\); \
\[IndentingNewLine]tx1 = Jm1 . \[CapitalOmega]; \[IndentingNewLine]tx2 = 
          Jm2 . \[CapitalOmega]; \[IndentingNewLine]tx3 = 
          Jm3 . \[CapitalOmega]; \[IndentingNewLine]tig1 = 
          
          Simplify[\(1\/2\) \(\[Sum]\+\(s = 1\)\%4 tx1\_\(\(\
\[LeftDoubleBracket]\)\(s, s\)\(\[RightDoubleBracket]\)\)\)]; \
\[IndentingNewLine]tig2 = \ 
          Simplify[
            1\/2\ \(\[Sum]\+\(s = 1\)\%4 tx2\_\(\(\[LeftDoubleBracket]\)\(s, \
s\)\(\[RightDoubleBracket]\)\)\)]; \[IndentingNewLine]tig3 = 
          Simplify[
            1\/2\ \(\[Sum]\+\(s = 1\)\%4 tx3\_\(\(\[LeftDoubleBracket]\)\(s, \
s\)\(\[RightDoubleBracket]\)\)\)]; \[IndentingNewLine]sigmap = {sig1, sig2, 
            sig3}; \[IndentingNewLine]sigmam = {tig1, tig2, 
            tig3}; \[IndentingNewLine]Print["\<The two sets of differential 1 \
forms satisfying the SO(3) Maurer Cartan equations are\>"]; \
\[IndentingNewLine]Print["\<-------\>", "\<Self dual\>", "\<---------\>"]; \
\[IndentingNewLine]Do[
          Print["\<\[Sigma][\>", i, "\<] = \>", sigmap[\([i]\)]], {i, 1, 
            3}]; \[IndentingNewLine]Print["\<-------\>", "\<Anti Self \
dual\>", "\<---------\>"]; \[IndentingNewLine]Do[
          Print["\<sigma[\>", i, "\<] = \>", sigmam[\([i]\)]], {i, 1, 
            3}];\[IndentingNewLine]}\)], "Input",
  CellLabel->"In[32]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[Theta]\\)\\\" is similar to existing \
symbol \\\"\\!\\(d\[Psi]\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[CurlyPhi]\\)\\\" is similar to existing \
symbols \\!\\({d\[Theta], d\[Psi]}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\
\\\", ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(tig1\\)\\\" is similar to existing symbol \\\
\"\\!\\(sig1\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(tig2\\)\\\" is similar to existing symbol \\\
\"\\!\\(sig2\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[32]:="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["routine thoft", "Subsection"],

Cell[TextData[{
  "Running ",
  StyleBox["thoft ",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox[" one generates the 't hooft matrices. The self dual ones are \
named Jp1,Jp2, Jp3, the antiselfdual ones are named Jm1, Jm2, Jm3. ",
    FontVariations->{"CompatibilityType"->0}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(thoft := {\n\t
        Jp1 = {{0, \(-1\), 0, 0}, {1, 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, 1, 
              0}}; \n\tJp2 = {{0, 0, \ 1, 0}, {0, 0, 0, \(-1\)}, {\(-1\), 0, 
              0, 0}, {0, 1, 0, 0}}; \n\t\tJp3 = {{0, 0, 0, \(-1\)}, {0, 
              0, \(-1\), 0}, {0, 1, 0, 0}, {1, 0, 0, 0}}; \n\t\tJm1 = {{0, 1, 
              0, 0}, {\(-1\), 0, 0, 0}, {0, 0, 0, \(-1\)}, {0, 0, 1, 
              0}}; \n\t\tJm2 = {{0, 0, \(-1\), 0}, {0, 0, 0, \(-1\)}, {1, 0, 
              0, 0}, {0, 1, 0, 0}}; \n\t\tJm3\  = {{0, 0, 0, 1}, {0, 
              0, \(-1\), 0}, {0, 1, 0, 0}, {\(-1\), 0, 0, 
              0}}; \n\t\tJJp = {Jp1, Jp2, Jp3}; \n\t\tJJm = {Jm1, Jm2, 
            Jm3};}\)\)\)], "Input",
  CellLabel->"In[33]:="]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["AdS space in four dimensions (Minkowski signature)", "Section"],

Cell[TextData[{
  "The routines of this section are deviced to calculate the algebra of \
SO(2,3) the solvable parametrization of anti de Sitter space in four \
dimensions, constructs its Killing vectors and make various other checks. If \
you want to run the entire package and see what it does you can just type: ",
  StyleBox["mainads4",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0],
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\
routine
\
\>", "Subsubsection",
  FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(mainads4 := \
{\[IndentingNewLine]Print["\<Give me the address of your working \
directory\>"]; \[IndentingNewLine]birec = 
          InputString["\<Directory ?\>"]; \[IndentingNewLine]SetDirectory[
          birec]; \[IndentingNewLine]Directory[]; \[IndentingNewLine]algso23; 
        cosetto; verkilling; 
        trigochange\[IndentingNewLine]Print["\<Now I save the results\>"]; \
\[IndentingNewLine]n3gij >> adsmetric.ma; \[IndentingNewLine]tdiffer >> 
          adsdiffer.ma; \[IndentingNewLine]newkilvec3 >> 
          adskil.ma; \[IndentingNewLine]tasder >> 
          adsderiv.ma; \[IndentingNewLine]Print["\<Done! The AdS metric is \
saved in adsmetric.ma\>"]; \[IndentingNewLine]Print["\<The AdS differentials \
are saved in adsdiffer.ma\>"]; \[IndentingNewLine]Print["\<The AdS Killing \
vectors are saved in adskil.ma\>"]; \[IndentingNewLine]Print["\<The AdS \
derivatives are saved in adsderiv.ma\>"];\[IndentingNewLine]}\)\)\)], "Input",\

  CellLabel->"In[34]:=",
  FontSize->18],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(birec\\)\\\" is similar to existing symbol \
\\\"\\!\\(direc\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[34]:="]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Lie algebra of SO(2,3) and Killing metric", "Subsection",
  FontSize->18],

Cell[TextData[{
  "In this section one defines the 10 generators of the SO(2,3) Lie algebra\n\
K0,K1,K2,K3,N1,N2,N3,J1,J2,J3\nwhere J are the SO(3) rotations, N the three \
Lorentz boosts and K0,K1,K2,K3 the 4 translations generators.\nThe routine is \
activated by typing: ",
  StyleBox["algso23",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection",
  FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(algso23 := {\[IndentingNewLine]Print["\<Now \
I define the SO(2,3) generators\>"]; \[IndentingNewLine]zeroma = {{0, 0, 0, 
              0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 
              0, 0, 0, 0}}; 
        N1 = {{0, 0, 1, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 0}, {0, 0, 0, 0, 
              0}, {0, 0, 0, 0, 0}}; 
        N2 = {{0, 0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {1, 0, 0, 0, 
              0}, {0, 0, 0, 0, 0}}; 
        N3 = {{0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 
              0}, {1, 0, 0, 0, 0}}; 
        J1 = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 
              0, \(-1\), 0, 0}, {0, 0, 0, 0, 0}}; 
        J2 = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 
              0}, {0, 0, \(-1\), 0, 0}}; 
        J3 = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 
              1}, {0, 0, 0, \(-1\), 0}}; 
        K0 = {{0, 1, 0, 0, 0}, {\(-1\), 0, 0, 0, 0}, {0, 0, 0, 0, 0}, {0, 0, 
              0, 0, 0}, {0, 0, 0, 0, 0}}; 
        K1 = {{0, 0, 0, 0, 0}, {0, 0, 1, 0, 0}, {0, 1, 0, 0, 0}, {0, 0, 0, 0, 
              0}, {0, 0, 0, 0, 0}}; 
        K2 = {{0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 0, 0, 0, 0}, {0, 1, 0, 0, 
              0}, {0, 0, 0, 0, 0}}; 
        K3 = {{0, 0, 0, 0, 0}, {0, 0, 0, 0, 1}, {0, 0, 0, 0, 0}, {0, 0, 0, 0, 
              0}, {0, 1, 0, 0, 0}}; 
        general = {K0, K1, K2, K3, N1, N2, N3, J1, J2, J3}; 
        Print["\<-------------------------------------------\>"]; 
        Print["\<I finished, the generators\>"]; 
        Print["\<K0,K1,K2,K3,N1,N2,N3,J1,J2,J3\>"]; 
        Print["\<are encoded in a 10 vectorsof 5 times 5 matrices\>"]; \
\[IndentingNewLine]Print["\<named general\>"]; \
\[IndentingNewLine]Print["\<Now I calculate the Killing metric\>"]; \
\[IndentingNewLine]killing = Table[0, {i, 1, 10}, {j, 1, 10}]; 
        Do[Do[{XXX = 
                general\[LeftDoubleBracket]i\[RightDoubleBracket] . 
                  general\[LeftDoubleBracket]j\[RightDoubleBracket]; 
              killing\[LeftDoubleBracket]i, 
                  j\[RightDoubleBracket] = \[Sum]\+\(k = 1\)\%5 
                    XXX\[LeftDoubleBracket]k, k\[RightDoubleBracket];}, {i, 
              1, 10}], {j, 1, 10}]; \[IndentingNewLine]MM[1, 2] = K0; 
        MM[2, 1] = \(-K0\); MM[1, 3] = K1; MM[3, 1] = \(-K1\); MM[1, 4] = K2; 
        MM[4, 1] = \(-K2\); MM[1, 5] = K3; MM[5, 1] = \(-K3\); MM[2, 3] = N1; 
        MM[3, 2] = \(-N1\); MM[2, 4] = N2; MM[4, 2] = \(-N2\); MM[2, 5] = N3; 
        MM[5, 2] = \(-N3\); MM[3, 4] = J1; MM[4, 3] = \(-J1\); MM[3, 5] = J2; 
        MM[5, 3] = \(-J2\); MM[4, 5] = J3; MM[5, 4] = \(-J3\); 
        MM[1, 1] = zeroma; MM[2, 2] = zeroma; MM[3, 3] = zeroma; 
        MM[4, 4] = zeroma; 
        MM[5, 5] = 
          zeroma; \[IndentingNewLine]metric = {{1, 0, 0, 0, 0}, {0, 1, 0, 0, 
              0}, {0, 0, \(-1\), 0, 0}, {0, 0, 0, \(-1\), 0}, {0, 0, 0, 
              0, \(-1\)}}; 
        Print["\<===========================================\>"]; 
        Print["\<Ora verifico l'algebra di SO(2,3) nella forma\>"]; 
        Print["\<standard\>"]; error = 0; OKs = 0; 
        Do[Do[Do[
              Do[{XXX = MM[A, B] . MM[C, D] - MM[C, D] . MM[A, B]; 
                  YYY = metric\[LeftDoubleBracket]A, 
                          C\[RightDoubleBracket]\ MM[B, D] - 
                      metric\[LeftDoubleBracket]B, C\[RightDoubleBracket]\ MM[
                          A, D] - 
                      metric\[LeftDoubleBracket]A, D\[RightDoubleBracket]\ MM[
                          B, C] + 
                      metric\[LeftDoubleBracket]B, D\[RightDoubleBracket]\ MM[
                          A, C]; 
                  If[XXX === YYY, 
                    OKs = OKs + 1, {Print["\<errore\>", "\< A=\>", 
                        A, "\< B=\>", B, "\< C=\>", C, "\< D=\>", D]; 
                      error = error + 1;}];}, {A, 1, 5}], {B, 1, 5}], {C, 1, 
              5}], {D, 1, 5}]; 
        Print["\<Ho verificato ed il numero di errori e' \>", error]; 
        Print["\<Il numero di prove verificate e' \>", OKs];}\)\)\)], "Input",\

  CellLabel->"In[35]:=",
  FontSize->18],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(general\\)\\\" is similar to existing symbol \
\\\"\\!\\(General\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(XXX\\)\\\" is similar to existing symbol \
\\\"\\!\\(xxx\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(YYY\\)\\\" is similar to existing symbol \
\\\"\\!\\(yyy\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[35]:="],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[35]:="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Solvable subalgebra generating the coset and construction of the  vielbein\
\>", "Subsection",
  FontSize->18],

Cell[TextData[{
  "This routine constructs the coset representative in solvable \
parametrization, the vierbein and the structure constants of the full Lie \
algebra.\nThe routine  is activated by typing: ",
  StyleBox["cosetto.\n",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox["To run this routine you need first to run algso23",
    FontSlant->"Italic",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->18],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection",
  FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{
        RowBox[{"cosetto", ":=", 
          RowBox[{"{", 
            
            RowBox[{\(Print["\<=========================================\>"]\)\
, ";", \(Print["\<I read Mario's solvable matrices\>"]\), 
              ";", \(Print["\<-----------------------------------------\>"]\),
               ";", \(matrina = {{{0, 0, 0, 0, 0}, {0, 0, 0, 1, 0}, {0, 0, 0, 
                      0, 0}, {0, 1, 0, 0, 0}, {0, 0, 0, 0, 0}}, {{0, 0, 0, 0, 
                      0}, {0, 0, 0, 0, 2^\((\(-1\)/2)\)}, {0, 0, 0, 0, 
                      0}, {0, 0, 0, 0, 2^\((\(-1\)/2)\)}, {0, 
                      2^\((\(-1\)/2)\), 0, \(-2^\((\(-1\)/2)\)\), 
                      0}}, {{0, \(-1\)/2, 0, 1/2, 0}, {1/2, 0, \(-1\)/2, 0, 
                      0}, {0, \(-1\)/2, 0, 1/2, 0}, {1/2, 0, \(-1\)/2, 0, 
                      0}, {0, 0, 0, 0, 0}}, {{0, \(-1\)/2, 0, 1/2, 0}, {1/2, 
                      0, 1/2, 0, 0}, {0, 1/2, 0, \(-1\)/2, 0}, {1/2, 0, 1/2, 
                      0, 0}, {0, 0, 0, 0, 0}}}\), ";", 
              "\[IndentingNewLine]", \(nomi = {h2, e2, e12, em12}\), ";", 
              "\[IndentingNewLine]", \(Print["\<And now I create the \
coset\>"]\), 
              ";", \(carta = 
                matrina\[LeftDoubleBracket]1\[RightDoubleBracket]\), 
              ";", \(abel = \
{matrina\[LeftDoubleBracket]2\[RightDoubleBracket], 
                  matrina\[LeftDoubleBracket]3\[RightDoubleBracket], 
                  matrina\[LeftDoubleBracket]4\[RightDoubleBracket]}\), 
              ";", \(metric = {{1, 0, 0, 0, 0}, {0, 1, 0, 0, 0}, {0, 
                    0, \(-1\), 0, 0}, {0, 0, 0, \(-1\), 0}, {0, 0, 0, 
                    0, \(-1\)}}\), 
              ";", \(flatt[x1_, x2_, x3_] := 
                x1\ abel\[LeftDoubleBracket]1\[RightDoubleBracket] + 
                  x2\ abel\[LeftDoubleBracket]2\[RightDoubleBracket] + 
                  x3\ abel\[LeftDoubleBracket]3\[RightDoubleBracket]\), 
              ";", \(unoma = IdentityMatrix[5]\), ";", 
              "\[IndentingNewLine]", \(SS[rho_] := 
                unoma + \((1\/2\ \((rho + 1\/rho)\) - 1)\)\ carta . carta + 
                  1\/2\ \((rho - 1\/rho)\)\ carta\), 
              ";", \(psiche[p_, q_, r_] := 
                flatt[\@2\ p, \(2\ \((q - r)\)\)\/2, \(2\ \((q + r)\)\)\/2]\),
               ";", \(tau[x_, t_, w_] := 
                Simplify[
                  unoma + psiche[x, t, w] + 
                    1\/2\ Simplify[psiche[x, t, w] . psiche[x, t, w]]]\), 
              ";", \(coset[rho_, x_, t_, w_] := 
                Simplify[tau[x, t, w] . SS[rho]]\), 
              ";", \(Print["\<I have calculated the coset representative.\>"]\
\), ";", \(Print["\<For SO(2,3)/(SO(1,3)) it is a \>"]\), 
              ";", \(Print["\< 5 x 5 matrix tau[x,t,w] which is function of \
the \>"]\), ";", \(Print["\< 3 world-volume 3 coordinate of the 2-brane\>"]\),
               ";", \(Print["\<multiplied on the right by another    matrix \
SS[rho]\>"]\), ";", 
              "\[IndentingNewLine]", \
\(Print["\<-------------------------------\>"]\), 
              ";", \(Print["\<Now left invariant 1--forms and vierbein\>"]\), 
              ";", 
              RowBox[{"preomeg", "=", 
                RowBox[{
                  RowBox[{"dx", " ", 
                    RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                      RowBox[{
                        SuperscriptBox["tau", 
                          TagBox[\((1, 0, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, t, w\), 
                        "]"}]}]}], "+", 
                  RowBox[{"dt", " ", 
                    RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                      RowBox[{
                        SuperscriptBox["tau", 
                          TagBox[\((0, 1, 0)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, t, w\), 
                        "]"}]}]}], "+", 
                  RowBox[{"dw", " ", 
                    RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                      RowBox[{
                        SuperscriptBox["tau", 
                          TagBox[\((0, 0, 1)\),
                            Derivative],
                          MultilineFunction->None], "[", \(x, t, w\), 
                        "]"}]}]}]}]}], ";", \(preomeg = Simplify[preomeg]\), 
              ";", 
              RowBox[{"Omega", "=", 
                RowBox[{\(SS[1\/rho] . preomeg . SS[rho]\), "+", 
                  RowBox[{"drho", " ", 
                    RowBox[{\(SS[1\/rho]\), ".", 
                      RowBox[{
                        SuperscriptBox["SS", "\[Prime]",
                          MultilineFunction->None], "[", "rho", "]"}]}]}]}]}],
               ";", \(Omega = Simplify[Omega]\), 
              ";", \(Print["\<------------------------------------------\>"]\)\
, ";", \(Print["\<I have calculated\>"]\), 
              ";", \(Print["\<Omega= L^-1 dL = \>"]\), ";", 
              "\[IndentingNewLine]", \(Print["\<Now I calculate the AdS_4 \
vierbein\>"]\), ";", \(vierbein = Table[o, {i, 1, 4}]\), 
              ";", \(Do[{XXX = 
                    Omega . 
                      general\[LeftDoubleBracket]i\[RightDoubleBracket]; 
                  vierbein\[LeftDoubleBracket]i\[RightDoubleBracket] = 
                    Simplify[\[Sum]\+\(k = 1\)\%5 XXX\[LeftDoubleBracket]k, k\
\[RightDoubleBracket]]\/killing\[LeftDoubleBracket]i, \
i\[RightDoubleBracket];}, {i, 1, 4}]\), ";", 
              "\[IndentingNewLine]", \(Print["\<Done\>"]\), ";", 
              "\[IndentingNewLine]", \(Do[
                Print["\<E[\>", i, "\<] = \>", vierbein[\([i]\)]], {i, 1, 
                  4}]\), ";", 
              "\[IndentingNewLine]", \(Print[\*"\"\<Redefining rho -> \!\(1\/\
\[Rho]\)\>\""]\), ";", 
              "\[IndentingNewLine]", \(Print["\<la metrica e' pertanto\>"]\), 
              ";", "\[IndentingNewLine]", \(dsads4 = 
                ReplaceAll[\ \ \(-\ 
                      vierbein\_\(\(\[LeftDoubleBracket]\)\(1\)\(\
\[RightDoubleBracket]\)\)\^2\)\ \ \  + \ \ \ \[Sum]\+\(i = 2\)\%4 \
vierbein\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\)\^2, {rho \
\[Rule] \ 1\/\[Rho], drho \[Rule] \(-\(d\[Rho]\/\[Rho]\^2\)\)}]\), ";", 
              "\[IndentingNewLine]", \(Print["\<ds^2 = \>", dsads4]\), ";", 
              "\[IndentingNewLine]", \
\(Print["\<-------------------------------------\>"]\), 
              ";", \(Print["\<Ora calcolo le costanti di struttura\>"]\), 
              ";", \(strucost = 
                Table[0, {i, 1, 10}, {j, 1, 10}, {k, 1, 10}]\), 
              ";", \(Do[
                Do[Do[{XXX = 
                        general\[LeftDoubleBracket]i\[RightDoubleBracket] . 
                            general\[LeftDoubleBracket]j\[RightDoubleBracket] \
- general\[LeftDoubleBracket]j\[RightDoubleBracket] . 
                            general\[LeftDoubleBracket]
                              i\[RightDoubleBracket]; 
                      YYY = XXX . 
                          general\[LeftDoubleBracket]k\[RightDoubleBracket]; 
                      strucost\[LeftDoubleBracket]i, j, 
                          k\[RightDoubleBracket] = 
                        Simplify[\[Sum]\+\(p = 1\)\%5 \
YYY\[LeftDoubleBracket]p, \
p\[RightDoubleBracket]]\/killing\[LeftDoubleBracket]k, \
k\[RightDoubleBracket];}, {i, 1, 10}], {j, 1, 10}], {k, 1, 10}]\), ";", 
              "\[IndentingNewLine]", \(Print["\<Done!\>"]\), 
              ";", \(Print["\<the result is in  strucost\>"]\), 
              ";", \(Print["\<which is a tensor C[i,j,k] 10 x 10 x 10\>"]\), 
              ";"}], "}"}]}], "\[IndentingNewLine]", ";"}]}]], "Input",
  CellLabel->"In[36]:=",
  FontSize->18],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(em12\\)\\\" is similar to existing symbol \\\
\"\\!\\(e12\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[36]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(abel\\)\\\" is similar to existing symbol \\\
\"\\!\\(Label\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[36]:="],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(Omega\\)\\\" is similar to existing symbol \
\\\"\\!\\(omega\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[36]:="],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell1\\\"\\) will be suppressed during this \
calculation. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[36]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[Rho]\\)\\\" is similar to existing \
symbols \\!\\({d\[Theta], d\[CurlyPhi], d\[Psi]}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[36]:="]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{

Cell["Killing vectors", "Subsection",
  FontSize->18],

Cell[TextData[{
  "This programme verifies the Killing vectors in the solvable \
parametrization and then exhibits them explicitly.\nThe routine is \
initialized by typing: ",
  StyleBox["verkilling\n",
    FontWeight->"Bold",
    FontVariations->{"Underline"->True}],
  StyleBox["To run this routine you need to run first also23 and cosetto",
    FontSlant->"Italic",
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["routine", "Subsubsection",
  FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{
      RowBox[{"verkilling", ":=", 
        RowBox[{"{", 
          
          RowBox[{\(Print["\<=================================================\
=\>"]\), ";", \(Print["\<Ora verifico che la soluzione trovata\>"]\), 
            ";", \(Print["\<soddisfi l'equazione dei Killing vectors\>"]\), 
            ";", \(Print["\<--------------------------------------------------\
\>"]\), ";", \(Print["\<Leggo i risultati per i Killing vectors\>"]\), 
            ";", \(Print["\<e per i compensatori\>"]\), ";", 
            "\[IndentingNewLine]", \(kilvec = {{\(-\((rho*t)\)\), \(-\((t*
                        x)\)\), \(-\((1 + rho^2 + t^2 + w^2 + x^2)\)\)/
                    2, \(-\((t*w)\)\)}, {\(-\((rho*w)\)\), \(-\((w*
                        x)\)\), \(-\((t*w)\)\), \((1 + rho^2 - t^2 - w^2 + 
                        x^2)\)/2}, {rho, x, t, 
                  w}, {\(-\((rho*x)\)\), \((1 + rho^2 - t^2 + w^2 - x^2)\)/
                    2, \(-\((t*x)\)\), \(-\((w*x)\)\)}, {0, 
                  0, \(-w\), \(-t\)}, {\(-\((rho*t)\)\), \(-\((t*
                        x)\)\), \((1 - rho^2 - t^2 - w^2 - x^2)\)/
                    2, \(-\((t*w)\)\)}, {0, \(-t\), \(-x\), 
                  0}, {\(-\((rho*w)\)\), \(-\((w*x)\)\), \(-\((t*
                        w)\)\), \((\(-1\) + rho^2 - t^2 - w^2 + x^2)\)/
                    2}, {0, \(-w\), 0, 
                  x}, {rho*x, \((1 - rho^2 + t^2 - w^2 + x^2)\)/2, t*x, 
                  w*x}}\), ";", 
            "\[IndentingNewLine]", \(compen = {{w, rho, x, 0, 0, 0}, {t, 0, 
                  0, rho, x, 0}, {0, 0, 0, 0, 0, 0}, {0, 0, t, 
                  0, \(-w\), \(-rho\)}, {1, 0, 0, 0, 0, 0}, {w, rho, x, 0, 0, 
                  0}, {0, 0, 1, 0, 0, 0}, {t, 0, 0, rho, x, 0}, {0, 0, 0, 0, 
                  1, 0}, {0, 0, \(-t\), 0, w, rho}}\), ";", 
            "\[IndentingNewLine]", \(Print["\<Fatto..!\>"]\), 
            ";", \(HHH = metric . Transpose[coset[rho, x, t, w]] . metric\), 
            ";", \(KKK = coset[rho, x, t, w]\), 
            ";", \(subgrou = {N1, N2, N3, J1, J2, J3}\), 
            ";", \(Print["\<Inizio  il calcolo\>"]\), 
            ";", \(primus = Table[0, {i, 1, 10}, {j, 1, 5}, {k, 1, 5}]\), 
            ";", \(secundus = Table[0, {i, 1, 10}, {j, 1, 5}, {k, 1, 5}]\), 
            ";", \(tertius = Table[0, {i, 1, 10}, {j, 1, 5}, {k, 1, 5}]\), 
            ";", \(verifkil = Table[0, {i, 1, 10}, {j, 1, 5}, {k, 1, 5}]\), 
            ";", 
            RowBox[{"Do", "[", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{"prepri", "=", 
                      RowBox[{
                        
                        RowBox[{\(kilvec\[LeftDoubleBracket]k, 
                            2\[RightDoubleBracket]\), " ", 
                          RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                            RowBox[{
                              SuperscriptBox["tau", 
                                TagBox[\((1, 0, 0)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, t, w\), 
                              "]"}]}]}], "+", 
                        
                        RowBox[{\(kilvec\[LeftDoubleBracket]k, 
                            3\[RightDoubleBracket]\), " ", 
                          RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                            RowBox[{
                              SuperscriptBox["tau", 
                                TagBox[\((0, 1, 0)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, t, w\), 
                              "]"}]}]}], "+", 
                        
                        RowBox[{\(kilvec\[LeftDoubleBracket]k, 
                            4\[RightDoubleBracket]\), " ", 
                          RowBox[{\(tau[\(-x\), \(-t\), \(-w\)]\), ".", 
                            RowBox[{
                              SuperscriptBox["tau", 
                                TagBox[\((0, 0, 1)\),
                                  Derivative],
                                MultilineFunction->None], "[", \(x, t, w\), 
                              "]"}]}]}]}]}], 
                    ";", \(prepri = Simplify[prepri]\), ";", 
                    RowBox[{"pri", "=", 
                      RowBox[{\(SS[1\/rho] . prepri . SS[rho]\), "+", 
                        
                        RowBox[{\(kilvec\[LeftDoubleBracket]k, 
                            1\[RightDoubleBracket]\), " ", 
                          RowBox[{\(SS[1\/rho]\), ".", 
                            RowBox[{
                              SuperscriptBox["SS", "\[Prime]",
                                MultilineFunction->None], "[", "rho", 
                              "]"}]}]}]}]}], 
                    ";", \(primus\[LeftDoubleBracket]k\[RightDoubleBracket] = 
                      Simplify[pri]\), 
                    ";", \(secundus\[LeftDoubleBracket]
                        k\[RightDoubleBracket] = \[Sum]\+\(i = 1\)\%6 
                            compen\[LeftDoubleBracket]k, 
                            i\[RightDoubleBracket]\ subgrou\
\[LeftDoubleBracket]i\[RightDoubleBracket]\), 
                    ";", \(tertius\[LeftDoubleBracket]k\[RightDoubleBracket] \
= HHH . general\[LeftDoubleBracket]k\[RightDoubleBracket] . KKK\), 
                    ";", \(verifkil\[LeftDoubleBracket]k\[RightDoubleBracket] \
= Simplify[tertius\[LeftDoubleBracket]k\[RightDoubleBracket] - 
                          primus\[LeftDoubleBracket]k\[RightDoubleBracket] - 
                          secundus\[LeftDoubleBracket]k\[RightDoubleBracket]]\
\), ";"}], "}"}], ",", \({k, 1, 10}\)}], "]"}], 
            ";", \(Print["\<----------------------------------------\>"]\), 
            ";", \(Print["\< Ho terminato\>"]\), 
            ";", \(Print["\<Ho Salvato il risultato in verifkil\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Ora controlla tu che tutto sia \
zero\>"]\), ";", "\[IndentingNewLine]", \(Print[verifkil]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Now let me exhibit the result \
explicitly\>"]\), ";", 
            "\[IndentingNewLine]", \(kilad2 = 
              Simplify[ReplaceAll[kilvec, {rho \[Rule] 1\/\[Rho]}]]\), ";", 
            "\[IndentingNewLine]", \(Do[
              kilad2\_\(\(\[LeftDoubleBracket]\)\(j, 1\)\(\
\[RightDoubleBracket]\)\) = \(-kilad2\_\(\(\[LeftDoubleBracket]\)\(j, 1\)\(\
\[RightDoubleBracket]\)\)\)*\[Rho]\^2, {j, 1, 10}]\), ";", 
            "\[IndentingNewLine]", \(kilads = Simplify[kilad2]\), ";", 
            "\[IndentingNewLine]", \(adscord = {\[Rho], x, t, w}\), ";", 
            "\[IndentingNewLine]", \(adsdiff = {d\[Rho], dx, dt, dw}\), ";", 
            "\[IndentingNewLine]", \(adsder = {d\/d\[Rho], d\/dx, d\/dt, 
                d\/dw}\), ";", 
            "\[IndentingNewLine]", \(Do[
              Print["\<k[\>", 
                i, "\<] = \>", \[Sum]\+\(i = 1\)\%4 kilads[\([j, i]\)] ** 
                    adsder[\([i]\)]], {j, 1, 10}]\), ";", 
            "\[IndentingNewLine]", \
\(Print["\<------------------------------\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Proof that Killings are \
Killings for the standard metric\>"]\), ";", 
            "\[IndentingNewLine]", \(g4sol = 
              Table[Coefficient[dsads4, 
                  adsdiff[\([i]\)]*adsdiff[\([j]\)]], {i, 1, 4}, {j, 1, 4}]\),
             ";", "      ", "\[IndentingNewLine]", \(ggmunu = g4sol\), ";", 
            "\[IndentingNewLine]", \(xmu = adscord\), ";", 
            "\[IndentingNewLine]", \(dxmu\  = adsdiff\), ";", 
            "\[IndentingNewLine]", \(derdxmu = adsder\), ";", 
            "\[IndentingNewLine]", \(killus = kilads\), ";", 
            "\[IndentingNewLine]", \(dim = 4\), ";", 
            "\[IndentingNewLine]", \(kilnu = 10\), ";", "  ", 
            "\[IndentingNewLine]", "testkillus", ";"}], "\[IndentingNewLine]",
           "        ", "}"}]}], ";"}]], "Input",
  CellLabel->"In[37]:=",
  FontSize->18],

Cell[BoxData[
    RowBox[{\(General::"spell1"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(dxmu\\)\\\" is similar to existing symbol \\\
\"\\!\\(xmu\\)\\\". \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\
\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell1\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[37]:="]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Trigonometric coordinates", "Subsection",
  FontSize->18],

Cell[TextData[{
  "In this section we turn to trigonometric coordinates in which the metric \
of AdS space has the following form:\n",
  Cell[BoxData[
      \(TraditionalForm\`ds\^2\)],
    FontSize->18],
  StyleBox["= - ",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`d\[Tau]\^2\)],
    FontSize->18],
  StyleBox[" +",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`Cos[\[Tau]]\^2\)],
    FontSize->18],
  StyleBox["[",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`d\[Lambda]\^2\)],
    FontSize->18],
  StyleBox["+",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`Sinh[\[Lambda]]\^2\)],
    FontSize->18],
  StyleBox["(",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`d\[Alpha]\^2\)],
    FontSize->18],
  StyleBox["+",
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`Sin[\[Alpha]]\^2\)],
    FontSize->18],
  Cell[BoxData[
      \(TraditionalForm\`d\[Beta]\^2\)],
    FontSize->18],
  StyleBox[")]",
    FontSize->18]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection",
  FontSize->18],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{"trigochange", ":=", 
        RowBox[{"{", "\[IndentingNewLine]", 
          
          RowBox[{\(Print["\<======================================\>"]\), 
            ";", "\[IndentingNewLine]", \(Print["\<Now I perform a change of \
coordinates\>"]\), ";", 
            "\[IndentingNewLine]", \(tcoord = {\[Tau], \[Lambda], \[Alpha], \
\[Beta]}\), ";", "\[IndentingNewLine]", \(Print["\<to the new set\>"]\), ";", 
            "\[IndentingNewLine]", \(Print[tcoord]\), ";", 
            "\[IndentingNewLine]", \(tdiffer = {d\[Tau], d\[Lambda], 
                d\[Alpha], d\[Beta]}\), ";", 
            "\[IndentingNewLine]", \(tasder = {d\/d\[Tau], d\/d\[Lambda], 
                d\/d\[Alpha], d\/d\[Beta]}\), ";", 
            "\[IndentingNewLine]", \(ffx[\[Tau]_, \[Lambda]_, \[Alpha]_, \
\[Beta]_] = {Cos[\[Tau]]*\((Cosh[\[Lambda]] + 
                      Sinh[\[Lambda]]*
                        Sin[\[Alpha]])\), \
\[IndentingNewLine]\(Sinh[\[Lambda]]*Cos[\[Alpha]]\)\/\(Cosh[\[Lambda]] + \
Sinh[\[Lambda]]*Sin[\[Alpha]]\)*Sin[\[Beta]], 
                Tan[\[Tau]]*1\/\(Cosh[\[Lambda]] + Sinh[\[Lambda]]*Sin[\
\[Alpha]]\), \(Sinh[\[Lambda]]*Cos[\[Alpha]]\)\/\(Cosh[\[Lambda]] + Sinh[\
\[Lambda]]*Sin[\[Alpha]]\)*Cos[\[Beta]]}\), ";", 
            "\[IndentingNewLine]", \(Print["\<the transformation is\>"]\), 
            ";", "\[IndentingNewLine]", \(Do[
              Print[adscord\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\), "\< = \>", \(ffx[\[Tau], \[Lambda], \[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\)], {i, 
                1, 4}]\), ";", 
            "\[IndentingNewLine]", \
\(Print["\<------------------------------\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<I calculate the Jacobian\>"]\), 
            ";", "\[IndentingNewLine]", \(JJ = 
              Table[Simplify[\[PartialD]\_\(tcoord\_\(\(\[LeftDoubleBracket]\)\
\(j\)\(\[RightDoubleBracket]\)\)\)\ \(ffx[\[Tau], \[Lambda], \[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\), 
                  Trig \[Rule] \ True], {i, 1, 4}, {j, 1, 4}]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Done !\>"]\), ";", 
            
            "\[IndentingNewLine]", \(Print["\< I calculate the inverse \
Jacobian\>"]\), ";", "\[IndentingNewLine]", \(JJm = Inverse[JJ]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Done !\>"]\), ";", 
            "\[IndentingNewLine]", \(xx1 = \(ffx[\[Tau], \[Lambda], \[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(1\)\(\[RightDoubleBracket]\)\)\), ";",
             "\[IndentingNewLine]", \(xx2 = \(ffx[\[Tau], \[Lambda], \
\[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(2\)\(\[RightDoubleBracket]\)\)\), ";",
             "\[IndentingNewLine]", \(xx3 = \(ffx[\[Tau], \[Lambda], \
\[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(3\)\(\[RightDoubleBracket]\)\)\), ";",
             "\[IndentingNewLine]", \(xx4 = \(ffx[\[Tau], \[Lambda], \
\[Alpha], \
\[Beta]]\)\_\(\(\[LeftDoubleBracket]\)\(4\)\(\[RightDoubleBracket]\)\)\), ";",
             "\[IndentingNewLine]", \(Rul1 = {\[Rho] \[Rule] xx1, 
                x \[Rule] \ xx2, \ \[IndentingNewLine]t \[Rule] \ xx3\ , \ 
                w \[Rule] xx4\ }\), ";", 
            "\[IndentingNewLine]", \
\(Print["\<----------------------------\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<First I make the transformation \
on the metric\>"]\), ";", 
            "\[IndentingNewLine]", \(gij = 
              Table[Coefficient[dsads4, 
                  adsdiff\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\)*
                    adsdiff\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)], {i, 1, 4}, {j, 1, 4}]\), ";", 
            "\[IndentingNewLine]", \(n1gij = ReplaceAll[gij, Rul1]\), ";", 
            "\[IndentingNewLine]", \(n2gij = Transpose[JJ] . n1gij . JJ\), 
            ";", "\[IndentingNewLine]", \(n3gij = 
              Simplify[n2gij, Trig \[Rule] \ True]\), ";", 
            "\[IndentingNewLine]", \(nds2ads = \[Sum]\+\(i = 1\)\%4\(\[Sum]\+\
\(j = 1\)\%4 n3gij\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\[RightDoubleBracket]\
\)\)*tdiffer\_\(\(\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\)*
                    tdiffer\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)\)\), ";", 
            "\[IndentingNewLine]", \(Print["\<In the new coordinates the \
metric is:\>"]\), ";", 
            "\[IndentingNewLine]", \(Print["\<ds^2 = \>", nds2ads]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Do you want to continue ?\>"]\),
             ";", "\n", \(flag = InputString["\<Y or N\>"]\), ";", 
            "\n", \(If[flag === "\<Y\>", Goto[continuo], Goto[Stoppo]]\), ";",
             "\n", \(Label[continuo]\), ";", 
            "\[IndentingNewLine]", \(Print["\<Now I make the transformation \
on the vectors\>"]\), ";", 
            "\[IndentingNewLine]", \(newkilvec1 = ReplaceAll[kilads, Rul1]\), 
            ";", "\[IndentingNewLine]", \(newkilvec2 = 
              newkilvec1 . Transpose[JJm]\), ";", 
            "\[IndentingNewLine]", \(newkilvec3 = 
              Table[0, {i, 1, 10}, {j, 1, 4}]\), ";", 
            "\[IndentingNewLine]", \(Do[{Print["\< i = \>", i]; 
                Do[{Print["\< j = \>", 
                      j]; \[IndentingNewLine]newkilvec3\_\(\(\
\[LeftDoubleBracket]\)\(i, j\)\(\[RightDoubleBracket]\)\) = 
                      Simplify[
                        newkilvec2\_\(\(\[LeftDoubleBracket]\)\(i, j\)\(\
\[RightDoubleBracket]\)\), Trig \[Rule] True];}, {j, 1, 4}];}, {i, 1, 10}]\), 
            ";", "\[IndentingNewLine]", \(Print["\<then the Killing vectors \
in the new basis are\>"]\), ";", 
            "\n", \(Do[{Print[j]; \[IndentingNewLine]Print["\<k[\>", 
                  i, "\<] = \>", \[Sum]\+\(i = 1\)\%4 newkilvec3[\([j, i]\)] ** 
                      tasder[\([i]\)]];}, {j, 1, 10}]\), ";", 
            "\[IndentingNewLine]", \(metricozza = nds2ads\), 
            StyleBox[";",
              FontSize->18], 
            "\[IndentingNewLine]", \(ggmunu = 
              Table[Coefficient[metricozza, 
                  tdiffer\_\(\(\[LeftDoubleBracket]\)\(i\)\(\
\[RightDoubleBracket]\)\)*
                    tdiffer\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)], {i, 1, 4}, {j, 1, 4}]\), ";", 
            StyleBox["\n",
              FontSlant->"Italic"], 
            RowBox[{
              StyleBox["xmu",
                FontWeight->"Bold"], "=", "tcoord"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["dxmu",
                FontWeight->"Bold"], " ", "=", "tdiffer"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["derdxmu",
                FontWeight->"Bold"], "=", "tasder"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["killus",
                FontWeight->"Bold"], "=", "newkilvec3"}], ";", 
            "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["dim",
                FontWeight->"Bold"], "=", "4"}], ";", "\[IndentingNewLine]", 
            RowBox[{
              StyleBox["kilnu",
                FontWeight->"Bold"], "=", "10"}], ";", "\[IndentingNewLine]", 
            "testkillus", ";", "\n", \(Label[Stoppo]\), ";", 
            "\n", \(Print["\<Fine\>"]\), ";"}], "\[IndentingNewLine]", "}"}], 
        "\[IndentingNewLine]"}]}]], "Input",
  CellLabel->"In[38]:=",
  FontSize->18],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[Tau]\\)\\\" is similar to existing \
symbols \\!\\({d\[Theta], d\[Rho], d\[CurlyPhi], d\[Psi]}\\). \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[38]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[Lambda]\\)\\\" is similar to existing \
symbols \\!\\({d\[Theta], d\[Rho], d\[Tau], d\[CurlyPhi], d\[Psi]}\\). \\!\\(\
\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\\\", \
ButtonFrame->None, ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[38]:="],

Cell[BoxData[
    RowBox[{\(General::"spell"\), \(\(:\)\(\ \)\), "\<\"Possible spelling \
error: new symbol name \\\"\\!\\(d\[Alpha]\\)\\\" is similar to existing \
symbols \\!\\({d\[Theta], d\[Lambda], d\[Rho], d\[Tau], d\[CurlyPhi], \
d\[Psi]}\\). \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"General::spell\\\"]\\)\"\>"}]], "Message",
  CellLabel->"From In[38]:="],

Cell[BoxData[
    RowBox[{\(General::"stop"\), \(\(:\)\(\ \)\), "\<\"Further output of \
\\!\\(General :: \\\"spell\\\"\\) will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::stop\\\"]\\)\"\>"}]], \
"Message",
  CellLabel->"From In[38]:="]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Test of Killing vectors", "Section"],

Cell[TextData[{
  "This routine is devised to test wheter a set of vector fields are Killing \
vectors for a given metric. \nThe inputs to be given before running the \
routine are:\n",
  StyleBox["ggmunu",
    FontWeight->"Bold"],
  "=",
  StyleBox["metric as n x n matrix;\n",
    FontSlant->"Italic"],
  StyleBox["xmu",
    FontWeight->"Bold"],
  "= set of coordinates as a n-vector;\n",
  StyleBox["dxmu",
    FontWeight->"Bold"],
  " =set of coordinate differentials as an n-vector;\n",
  StyleBox["derdxmu",
    FontWeight->"Bold"],
  "=set of  coordinate derivatives as an n-vector;\n",
  StyleBox["killus",
    FontWeight->"Bold"],
  "=set of Killing vectors to be tested\n",
  StyleBox["dim",
    FontWeight->"Bold"],
  "=dimension of manifold\n",
  StyleBox["kilnu",
    FontWeight->"Bold"],
  "=number of Killing vectors;  \nthe routine is than ",
  StyleBox["activated by typing ",
    FontColor->RGBColor[1, 0, 0]],
  StyleBox["testkillus",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0],
    FontVariations->{"Underline"->True}]
}], "MathCaption",
  FontSize->24],

Cell[CellGroupData[{

Cell["\<\

routine\
\>", "Subsubsection"],

Cell[BoxData[
    \(\(\(testkillus := {\[IndentingNewLine]Print["\<I start the Killing \
vector test for the metric and the vectors you gave me\>"]; \
\[IndentingNewLine]Do[\[IndentingNewLine]{Print["\< I check the vector \>", 
              A]; \[IndentingNewLine]testone = \[Sum]\+\(i = 1\)\%dim\(\[Sum]\
\+\(j = 1\)\%dim\(\[Sum]\+\(k = 1\)\%dim\[PartialD]\_\(xmu\_\(\(\
\[LeftDoubleBracket]\)\(i\)\(\[RightDoubleBracket]\)\)\)\ 
                          ggmunu\_\(\(\[LeftDoubleBracket]\)\(j, k\)\(\
\[RightDoubleBracket]\)\)*
                        killus\_\(\(\[LeftDoubleBracket]\)\(A, i\)\(\
\[RightDoubleBracket]\)\)*
                        dxmu\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)*
                        dxmu\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\)\)\) + 
                2*\(\[Sum]\+\(p = 1\)\%dim\(\[Sum]\+\(j = \
1\)\%dim\(\[Sum]\+\(k = 1\)\%dim ggmunu\_\(\(\[LeftDoubleBracket]\)\(p, k\)\(\
\[RightDoubleBracket]\)\)*\[PartialD]\_\(xmu\_\(\(\[LeftDoubleBracket]\)\(j\)\
\(\[RightDoubleBracket]\)\)\)\ 
                            killus\_\(\(\[LeftDoubleBracket]\)\(A, p\)\(\
\[RightDoubleBracket]\)\)*
                          dxmu\_\(\(\[LeftDoubleBracket]\)\(j\)\(\
\[RightDoubleBracket]\)\)*
                          dxmu\_\(\(\[LeftDoubleBracket]\)\(k\)\(\
\[RightDoubleBracket]\)\)\)\)\); \[IndentingNewLine]testino = 
              Simplify[testone]; \[IndentingNewLine]Print["\<testino = \>", 
              testino]; \[IndentingNewLine]If[testino === 0, 
              Print["\< Vector \>", \ A, \ "\< OK KILLING!\>"], 
              Print["\<Vector \>", \ A, \ "\< = NO  KILLING !\>"]];}, {A, 1, 
            kilnu}];}\)\(\[IndentingNewLine]\)
    \)\)], "Input",
  CellLabel->"In[39]:="]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[StyleBox["End of Packages",
  FontSlant->"Italic"]], "Subtitle"],

Cell[BoxData[""], "Input",
  CellLabel->"In[40]:="]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowSize->{1432, 779},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
StyleDefinitions -> "Textbook.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 66, 0, 69, "Title"],
Cell[1845, 55, 261, 5, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[2131, 64, 56, 0, 85, "Section"],

Cell[CellGroupData[{
Cell[2212, 68, 62, 1, 47, "Subsection"],
Cell[2277, 71, 1922, 50, 776, "MathCaption"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4236, 126, 65, 0, 44, "Subsection"],
Cell[4304, 128, 2683, 67, 889, "MathCaption"],
Cell[6990, 197, 16, 0, 25, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7043, 202, 34, 0, 44, "Subsection"],

Cell[CellGroupData[{
Cell[7102, 206, 54, 0, 37, "Subsubsection"],
Cell[7159, 208, 422, 8, 210, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[7630, 222, 49, 0, 44, "Subsection"],
Cell[7682, 224, 287, 6, 115, "MathCaption"],

Cell[CellGroupData[{
Cell[7994, 234, 73, 0, 37, "Subsubsection"],
Cell[8070, 236, 401, 6, 88, "Text"],
Cell[8474, 244, 3848, 63, 949, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[12371, 313, 29, 0, 44, "Subsection"],
Cell[12403, 315, 331, 7, 114, "MathCaption"],

Cell[CellGroupData[{
Cell[12759, 326, 107, 2, 37, "Subsubsection"],
Cell[12869, 330, 2361, 41, 612, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[15279, 377, 32, 0, 44, "Subsection"],
Cell[15314, 379, 333, 7, 122, "MathCaption"],

Cell[CellGroupData[{
Cell[15672, 390, 32, 0, 37, "Subsubsection"],
Cell[15707, 392, 1350, 24, 277, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[17118, 423, 58, 0, 85, "Section"],
Cell[17179, 425, 319, 5, 60, "MathCaption"],

Cell[CellGroupData[{
Cell[17523, 434, 55, 0, 44, "Subsection"],

Cell[CellGroupData[{
Cell[17603, 438, 39, 0, 37, "Subsubsection"],

Cell[CellGroupData[{
Cell[17667, 442, 1988, 36, 1066, "Input"],
Cell[19658, 480, 388, 6, 70, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[20095, 492, 44, 0, 31, "Subsubsection"],
Cell[20142, 494, 2614, 43, 1119, "Input"],
Cell[22759, 539, 51, 1, 31, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[22847, 545, 46, 0, 31, "Subsubsection"],
Cell[22896, 547, 1627, 28, 606, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[24560, 580, 43, 0, 31, "Subsubsection"],
Cell[24606, 582, 1479, 24, 606, "Input"]
}, Closed]],

Cell[CellGroupData[{
Cell[26122, 611, 41, 0, 31, "Subsubsection"],
Cell[26166, 613, 1102, 19, 491, "Input"],

Cell[CellGroupData[{
Cell[27293, 636, 180, 4, 89, "Input"],
Cell[27476, 642, 87, 2, 70, "Print"],
Cell[27566, 646, 69, 2, 70, "Print"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[27684, 654, 44, 0, 31, "Subsubsection"],
Cell[27731, 656, 2147, 41, 748, "Input"]
}, Closed]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[29939, 704, 140, 3, 53, "Section"],
Cell[30082, 709, 1213, 41, 332, "MathCaption"],

Cell[CellGroupData[{
Cell[31320, 754, 26, 0, 44, "Subsection"],
Cell[31349, 756, 179, 6, 43, "MathCaption"],

Cell[CellGroupData[{
Cell[31553, 766, 32, 0, 37, "Subsubsection"],

Cell[CellGroupData[{
Cell[31610, 770, 136, 3, 70, "Input"],
Cell[31749, 775, 391, 6, 28, "Message"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[32201, 788, 60, 0, 44, "Subsection"],
Cell[32264, 790, 1143, 33, 251, "MathCaption"],

Cell[CellGroupData[{
Cell[33432, 827, 41, 3, 54, "Subsubsection"],

Cell[CellGroupData[{
Cell[33498, 834, 5654, 97, 1798, "Input"],
Cell[39155, 933, 386, 6, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[39602, 946, 39, 0, 44, "Subsection"],
Cell[39644, 948, 315, 8, 108, "MathCaption"],

Cell[CellGroupData[{
Cell[39984, 960, 32, 0, 37, "Subsubsection"],

Cell[CellGroupData[{
Cell[40041, 964, 3489, 57, 906, "Input"],
Cell[43533, 1023, 390, 6, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[43984, 1036, 42, 0, 44, "Subsection"],
Cell[44029, 1038, 450, 10, 138, "MathCaption"],

Cell[CellGroupData[{
Cell[44504, 1052, 41, 3, 54, "Subsubsection"],
Cell[44548, 1057, 5472, 90, 1045, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[50069, 1153, 60, 0, 44, "Subsection"],
Cell[50132, 1155, 1872, 61, 520, "MathCaption"],

Cell[CellGroupData[{
Cell[52029, 1220, 42, 3, 54, "Subsubsection"],
Cell[52074, 1225, 3661, 69, 1115, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[55784, 1300, 73, 0, 44, "Subsection"],
Cell[55860, 1302, 815, 23, 217, "MathCaption"],

Cell[CellGroupData[{
Cell[56700, 1329, 41, 3, 54, "Subsubsection"],
Cell[56744, 1334, 5209, 90, 1460, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[62014, 1431, 117, 3, 85, "Section"],
Cell[62134, 1436, 378, 9, 117, "MathCaption"],

Cell[CellGroupData[{
Cell[62537, 1449, 41, 3, 54, "Subsubsection"],
Cell[62581, 1454, 5591, 96, 1566, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[68221, 1556, 66, 0, 85, "Section"],
Cell[68290, 1558, 1099, 27, 175, "MathCaption"],

Cell[CellGroupData[{
Cell[69414, 1589, 49, 3, 54, "Subsubsection"],

Cell[CellGroupData[{
Cell[69488, 1596, 3447, 64, 1144, "Input"],
Cell[72938, 1662, 394, 6, 70, "Message"],
Cell[73335, 1670, 401, 6, 70, "Message"],
Cell[73739, 1678, 386, 6, 70, "Message"],
Cell[74128, 1686, 386, 6, 70, "Message"],
Cell[74517, 1694, 363, 6, 70, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[74929, 1706, 35, 0, 38, "Subsection"],
Cell[74967, 1708, 342, 9, 72, "MathCaption"],

Cell[CellGroupData[{
Cell[75334, 1721, 41, 3, 54, "Subsubsection"],
Cell[75378, 1726, 779, 12, 210, "Input"]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[76218, 1745, 69, 0, 85, "Section"],
Cell[76290, 1747, 474, 10, 101, "MathCaption"],

Cell[CellGroupData[{
Cell[76789, 1761, 57, 4, 66, "Subsubsection"],

Cell[CellGroupData[{
Cell[76871, 1769, 1042, 18, 399, "Input"],
Cell[77916, 1789, 388, 6, 70, "Message"]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{
Cell[78353, 1801, 79, 1, 41, "Subsection"],
Cell[78435, 1804, 398, 9, 154, "MathCaption"],

Cell[CellGroupData[{
Cell[78858, 1817, 57, 4, 66, "Subsubsection"],

Cell[CellGroupData[{
Cell[78940, 1825, 4242, 73, 1386, "Input"],
Cell[83185, 1900, 392, 6, 70, "Message"],
Cell[83580, 1908, 384, 6, 70, "Message"],
Cell[83967, 1916, 384, 6, 70, "Message"],
Cell[84354, 1924, 363, 6, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[84778, 1937, 120, 3, 47, "Subsection"],
Cell[84901, 1942, 463, 11, 114, "MathCaption"],

Cell[CellGroupData[{
Cell[85389, 1957, 57, 4, 54, "Subsubsection"],

Cell[CellGroupData[{
Cell[85471, 1965, 7880, 143, 1818, "Input"],
Cell[93354, 2110, 385, 6, 70, "Message"],
Cell[93742, 2118, 387, 6, 70, "Message"],
Cell[94132, 2126, 388, 6, 70, "Message"],
Cell[94523, 2134, 363, 6, 70, "Message"],
Cell[94889, 2142, 412, 7, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Closed]],

Cell[CellGroupData[{
Cell[95362, 2156, 53, 1, 41, "Subsection"],
Cell[95418, 2159, 444, 11, 117, "MathCaption"],

Cell[CellGroupData[{
Cell[95887, 2174, 48, 1, 43, "Subsubsection"],

Cell[CellGroupData[{
Cell[95960, 2179, 8114, 141, 1825, "Input"],
Cell[104077, 2322, 385, 6, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[104523, 2335, 63, 1, 47, "Subsection"],
Cell[104589, 2338, 1037, 42, 73, "MathCaption"],

Cell[CellGroupData[{
Cell[105651, 2384, 57, 4, 66, "Subsubsection"],

Cell[CellGroupData[{
Cell[105733, 2392, 7570, 139, 1758, "Input"],
Cell[113306, 2533, 421, 7, 70, "Message"],
Cell[113730, 2542, 431, 6, 70, "Message"],
Cell[114164, 2550, 444, 7, 70, "Message"],
Cell[114611, 2559, 362, 6, 70, "Message"]
}, Open  ]]
}, Closed]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{
Cell[115046, 2573, 42, 0, 85, "Section"],
Cell[115091, 2575, 1087, 34, 376, "MathCaption"],

Cell[CellGroupData[{
Cell[116203, 2613, 41, 3, 54, "Subsubsection"],
Cell[116247, 2618, 1766, 31, 420, "Input"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{
Cell[118062, 2655, 78, 1, 34, "Subtitle"],
Cell[118143, 2658, 51, 1, 30, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

