(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     82916,       2493]*)
(*NotebookOutlinePosition[     83614,       2517]*)
(*  CellTagsIndexPosition[     83570,       2513]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Examples of the use of the package NOVAMANIFOLDA", "Title"],

Cell["\<\

In this Notebook we display some examples of the use of the package \
NOVAMANIFOLDA. Obviously you have to evaluate first the NoteBook \
Novamanifolda.
\
\>", "Text",
  FontSize->16],

Cell[CellGroupData[{

Cell["Use of the routine RUNCOSET for coset manifolds", "Subtitle"],

Cell[CellGroupData[{

Cell[TextData[{
  "The 4-dimensional coset ",
  Cell[BoxData[
      \(TraditionalForm\`CP\^2\)]]
}], "Section"],

Cell["We initialize the programme", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(start\)\)\)], "Input",
  CellLabel->"In[42]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[42]="]
}, Open  ]],

Cell["We calculate the structure constant of the SU(3) Lie algebra", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(cp2stru\)\)\)], "Input",
  CellLabel->"In[43]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[43]="]
}, Open  ]],

Cell[TextData[{
  "\nThe result of this calculation is a tensor named ",
  StyleBox["fff ",
    FontWeight->"Bold"],
  " and stored in the computer memory (if you wanted another group, you had \
to calculate the structure constants of its Lie algebra and store them in a \
tri-tensor named also ",
  StyleBox["fff.  ",
    FontWeight->"Bold"],
  StyleBox["It is important that in ordering the generators the first dim G/H \
should correspond to the coset generators, while the late dim H should \
correspond to the stability subgroup H generators",
    FontVariations->{"CompatibilityType"->0}],
  ")"
}], "Text"],

Cell["Next we initial the RUNCOSET programme", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(initial\)\)\)], "Input",
  CellLabel->"In[44]:="],

Cell[BoxData[
    \("======================================="\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" Welcome to RUNCOSET, a new package  built by Petrus"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \("on Leonardus technology"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" It computes various geometric quantities of G/H  cosets"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" Please insert the dimensions of the group G and"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" of the coset G/H"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \("-----------------------------------------------"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" Now you need to provide the structure constants of the     group"\)], \
"Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" and the rescalings"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" The structure constants must be given as a tensor cc[[A,B,C]]; "\)], \
"Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \(" The rescalings must be given as r[1]=?, r[2]=?..."\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \("-----------------------------------------------"\)], "Print",
  CellLabel->"From In[44]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[44]="]
}, Open  ]],

Cell["We supply the calculated SU(3) structure constants", "Text"],

Cell[BoxData[
    \(\(cc = fff;\)\)], "Input",
  CellLabel->"In[46]:="],

Cell["we calculate the spin connection one-form for this coset.", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(doconnection\)\)\)], "Input",
  CellLabel->"In[47]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \(" The tensor connten[[a,b]] giving the formal expression "\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \(" of the spin connection B[a,b] as a 1-form"\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \(" is ready for storing on hard disk"\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \("Store it in your preferred directory with the name you choose"\)], \
"Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[47]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[47]="]
}, Open  ]],

Cell["\<\
We display the result of this calculation. In the formula below om[i], \
(i=1,...,8) denote the Maurer Cartan one-forms of the SU(3) group ordered and \
normalized according to the conventions used for the structure constants.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(MatrixForm[connten]\)\)\)], "Input",
  CellLabel->"In[49]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {
              "0", \(om[7]\/2\), \(1\/2\ \((\@3\ om[5] + om[6])\)\), \(om[
                    8]\/2\)},
            {\(-\(om[7]\/2\)\), 
              "0", \(om[8]\/2\), \(1\/2\ \((\@3\ om[5] - om[6])\)\)},
            {\(1\/2\ \((\(-\@3\)\ om[5] - om[6])\)\), \(-\(om[8]\/2\)\), 
              "0", \(om[7]\/2\)},
            {\(-\(om[8]\/2\)\), \(1\/2\ \((\(-\@3\)\ om[5] + 
                    om[6])\)\), \(-\(om[7]\/2\)\), "0"}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[49]//MatrixForm="]
}, Open  ]],

Cell["\<\
Let us now insert the rescaling factors r[i]. These are as many as there are \
irreducible representations of H in the complementary subspace in the \
decomposition G=H\[CirclePlus]K. For CP2 the 4 coset generators span just one \
irredicble representation of the su(2)\[Times]u(1) Lie algebra, hence there \
is only one scaling factor.\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(r[1] = \[Lambda]; \ r[2] = \[Lambda]; \ 
    r[3] = \[Lambda]; \ r[4] = \[Lambda]\)\)\)], "Input",
  CellLabel->"In[55]:="],

Cell[BoxData[
    \(\[Lambda]\)], "Output",
  CellLabel->"Out[55]="]
}, Open  ]],

Cell["Next we compute the torsion of the coset", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(doconncomp\)\)\)], "Input",
  CellLabel->"In[56]:="],

Cell[BoxData[
    \("-------------------------------------"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \(" Now I calculate the torsion part of the spin connection"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \(" The tensor contor[a,b]] giving the torsion part B[c,a,b] "\)], "Print",\

  CellLabel->"From In[56]:="],

Cell[BoxData[
    \(" of the spin connection B[a,b]"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \(" is ready for storing on hard disk"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \("Store it in your preferred directory with the name you choose"\)], \
"Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[56]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[56]="]
}, Open  ]],

Cell["\<\
The CP2 coset is symmetric and torsionless and this is indeed verified by the \
computer\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(contor\)\)\)], "Input",
  CellLabel->"In[57]:="],

Cell[BoxData[
    \({{{0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 
          0, 0, 0}, {0, 0, 0, 0}, {0, 0, 0, 0}}, {{0, 0, 0, 0}, {0, 0, 0, 
          0}, {0, 0, 0, 0}, {0, 0, 0, 0}}}\)], "Output",
  CellLabel->"Out[57]="]
}, Open  ]],

Cell["Then we calculate the Riemann tensor", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(doriemann2\)\)\)], "Input",
  CellLabel->"In[58]:="],

Cell[BoxData[
    \("-------------------------------------"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \(" Now I calculate the Riemann tensor Rie(a,b,c,d)"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 2, " ", 1, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 2, " ", 2, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 2, " ", 3, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 2, " ", 4, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 3, " ", 1, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 3, " ", 2, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 3, " ", 3, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 3, " ", 4, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 4, " ", 1, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 4, " ", 2, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 4, " ", 3, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 4, " ", 4, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 1, " ", 1, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 1, " ", 2, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 1, " ", 3, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 1, " ", 4, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 3, " ", 1, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 3, " ", 2, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 3, " ", 3, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 3, " ", 4, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 4, " ", 1, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 4, " ", 2, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 4, " ", 3, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 4, " ", 4, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 1, " ", 1, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 1, " ", 2, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 1, " ", 3, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 1, " ", 4, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 2, " ", 1, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 2, " ", 2, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 2, " ", 3, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 2, " ", 4, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 4, " ", 1, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 4, " ", 2, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 4, " ", 3, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 4, " ", 4, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 1, " ", 1, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 1, " ", 2, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 1, " ", 3, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 1, " ", 4, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 2, " ", 1, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 2, " ", 2, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 2, " ", 3, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 2, " ", 4, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]1\[InvisibleSpace]"  "\[InvisibleSpace]2\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 3, " ", 1, "  ", 2, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]2\[InvisibleSpace]"  "\[InvisibleSpace]1\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 3, " ", 2, "  ", 1, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]3\[InvisibleSpace]"  "\[InvisibleSpace]4\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 3, " ", 3, "  ", 4, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]4\[InvisibleSpace]"  "\[InvisibleSpace]3\
\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 3, " ", 4, "  ", 3, "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \(" The tensor Rie(a,b,c,d) is ready for storing on hard disk"\)], "Print",\

  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("Store it in your preferred directory with the name you choose"\)], \
"Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("------------------------------------"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("Now I evaluate the curvature 2-form of your space"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("I find the following answer"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/8\ \[Lambda]\^2\ e\_1 ** 
                  e\_2 + 1\/8\ \[Lambda]\^2\ e\_3 ** e\_4)\)\)\),
      SequenceForm[ "R[", 1, 2, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 2]]], 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 3], 
                Subscript[ e, 4]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/2\ \[Lambda]\^2\ e\_1 ** 
                  e\_3 + 1\/4\ \[Lambda]\^2\ e\_2 ** e\_4)\)\)\),
      SequenceForm[ "R[", 1, 3, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 2], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 3]]], 
            Times[ 
              Rational[ 1, 4], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 2], 
                Subscript[ e, 4]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/8\ \[Lambda]\^2\ e\_1 ** 
                  e\_4 + 1\/8\ \[Lambda]\^2\ e\_2 ** e\_3)\)\)\),
      SequenceForm[ "R[", 1, 4, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 4]]], 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 2], 
                Subscript[ e, 3]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/8\ \[Lambda]\^2\ e\_1 ** 
                  e\_4 + 1\/8\ \[Lambda]\^2\ e\_2 ** e\_3)\)\)\),
      SequenceForm[ "R[", 2, 3, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 4]]], 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 2], 
                Subscript[ e, 3]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/4\ \[Lambda]\^2\ e\_1 ** 
                  e\_3 + 1\/2\ \[Lambda]\^2\ e\_2 ** e\_4)\)\)\),
      SequenceForm[ "R[", 2, 4, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 4], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 3]]], 
            Times[ 
              Rational[ 1, 2], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 2], 
                Subscript[ e, 4]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(2\ \((1\/8\ \[Lambda]\^2\ e\_1 ** 
                  e\_2 + 1\/8\ \[Lambda]\^2\ e\_3 ** e\_4)\)\)\),
      SequenceForm[ "R[", 3, 4, "] = ", 
        Times[ 2, 
          Plus[ 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 1], 
                Subscript[ e, 2]]], 
            Times[ 
              Rational[ 1, 8], 
              Power[ \[Lambda], 2], 
              NonCommutativeMultiply[ 
                Subscript[ e, 3], 
                Subscript[ e, 4]]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("The result is encoded in a tensor RR[i,j]"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \("Its components are encoded in a tensor Rie[i,j,a,b]"\)], "Print",
  CellLabel->"From In[58]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[58]="]
}, Open  ]],

Cell["and we calculate the explicit form of the curvature two-form", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(docurvaform\)\)\)], "Input",
  CellLabel->"In[59]:="],

Cell[BoxData[
    \("------------------------------------"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \("I evaluate the curvature 2-form of your  coset"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \("I find the following answer"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]2\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/8\ \[Lambda]\^2\ V\_1 ** V\_2 - 
          1\/8\ \[Lambda]\^2\ V\_2 ** V\_1 + 
          1\/8\ \[Lambda]\^2\ V\_3 ** V\_4 - 
          1\/8\ \[Lambda]\^2\ V\_4 ** V\_3\)\),
      SequenceForm[ "R[", 1, 2, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 2]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 1]]], 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 3]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/2\ \[Lambda]\^2\ V\_1 ** V\_3 + 
          1\/4\ \[Lambda]\^2\ V\_2 ** V\_4 - 
          1\/2\ \[Lambda]\^2\ V\_3 ** V\_1 - 
          1\/4\ \[Lambda]\^2\ V\_4 ** V\_2\)\),
      SequenceForm[ "R[", 1, 3, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 2], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 3]]], 
          Times[ 
            Rational[ 1, 4], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 1]]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 2]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]1\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/8\ \[Lambda]\^2\ V\_1 ** V\_4 + 
          1\/8\ \[Lambda]\^2\ V\_2 ** V\_3 - 
          1\/8\ \[Lambda]\^2\ V\_3 ** V\_2 - 
          1\/8\ \[Lambda]\^2\ V\_4 ** V\_1\)\),
      SequenceForm[ "R[", 1, 4, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 3]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 2]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 1]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/8\ \[Lambda]\^2\ V\_1 ** V\_4 + 
          1\/8\ \[Lambda]\^2\ V\_2 ** V\_3 - 
          1\/8\ \[Lambda]\^2\ V\_3 ** V\_2 - 
          1\/8\ \[Lambda]\^2\ V\_4 ** V\_1\)\),
      SequenceForm[ "R[", 2, 3, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 3]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 2]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 1]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]2\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/4\ \[Lambda]\^2\ V\_1 ** V\_3 + 
          1\/2\ \[Lambda]\^2\ V\_2 ** V\_4 - 
          1\/4\ \[Lambda]\^2\ V\_3 ** V\_1 - 
          1\/2\ \[Lambda]\^2\ V\_4 ** V\_2\)\),
      SequenceForm[ "R[", 2, 4, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 4], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 3]]], 
          Times[ 
            Rational[ 1, 2], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ -1, 4], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 1]]], 
          Times[ 
            Rational[ -1, 2], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 2]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    InterpretationBox[\("R["\[InvisibleSpace]3\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]\(1\/8\ \[Lambda]\^2\ V\_1 ** V\_2 - 
          1\/8\ \[Lambda]\^2\ V\_2 ** V\_1 + 
          1\/8\ \[Lambda]\^2\ V\_3 ** V\_4 - 
          1\/8\ \[Lambda]\^2\ V\_4 ** V\_3\)\),
      SequenceForm[ "R[", 3, 4, "] = ", 
        Plus[ 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 1], 
              Subscript[ V, 2]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 2], 
              Subscript[ V, 1]]], 
          Times[ 
            Rational[ 1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 3], 
              Subscript[ V, 4]]], 
          Times[ 
            Rational[ -1, 8], 
            Power[ \[Lambda], 2], 
            NonCommutativeMultiply[ 
              Subscript[ V, 4], 
              Subscript[ V, 3]]]]],
      Editable->False]], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \("Now choose a value for the rescaling parameters"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \("writing rullina = {....}"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \("Then type redisplay"\)], "Print",
  CellLabel->"From In[59]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[59]="]
}, Open  ]],

Cell["Finally we calculate the Ricci tensor", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(doricci\)\)\)], "Input",
  CellLabel->"In[60]:="],

Cell[BoxData[
    \("-------------------------------------"\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \(" Now I calculate the Ricci tensor"\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \(" The tensor ricten[a,b]] giving the Ricci tensor "\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \(" is ready for storing on hard disk"\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \("Store it in your preferred directory with the name you choose"\)], \
"Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[60]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[60]="]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(MatrixForm[ricten]\)\)\)], "Input",
  CellLabel->"In[61]:="],

Cell[BoxData[
    TagBox[
      RowBox[{"(", "\[NoBreak]", GridBox[{
            {\(\(3\ \[Lambda]\^2\)\/4\), "0", "0", "0"},
            {"0", \(\(3\ \[Lambda]\^2\)\/4\), "0", "0"},
            {"0", "0", \(\(3\ \[Lambda]\^2\)\/4\), "0"},
            {"0", "0", "0", \(\(3\ \[Lambda]\^2\)\/4\)}
            },
          RowSpacings->1,
          ColumnSpacings->1,
          ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
      Function[ BoxForm`e$, 
        MatrixForm[ BoxForm`e$]]]], "Output",
  CellLabel->"Out[61]//MatrixForm="]
}, Open  ]],

Cell["\<\

The above expression of the Ricci tensor is provided in the flat indices. \
Indeed the Ricci tensor is the trace of the Riemann tensor calculated in the \
flat basis as componets of the curvature two-form along the vielbein basis.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Calculation of the (Pseudo) Riemannian Geometry of a Kasner metric in \
vielbein formalism\
\>", "Section"],

Cell["\<\
As an example of calculation of the pseudo-riemannian geometry in vielbein \
formalism we consider in this section the case of a Kasner cosmological \
metric\
\>", "Text"],

Cell["We initialize this general package by typing contorgen", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(contorgen\)\)\)], "Input",
  CellLabel->"In[62]:="],

Cell[BoxData[
    \("Give me the dimension of your space"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    InterpretationBox[\("Your space has dimension n = "\[InvisibleSpace]4\),
      SequenceForm[ "Your space has dimension n = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    InterpretationBox[\("Now I stop and you give me three vectors of \
dimension "\[InvisibleSpace]4\),
      SequenceForm[ 
      "Now I stop and you give me three vectors of dimension ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("vector fform = vector of 1-form vielbeins"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("vector coordi = vector of coordinates"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("vector diffe = vector of differentials"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("Then resume the calculation typing: contorgenresume"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("If you already have the contorsion type"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \("spinpackgen"\)], "Print",
  CellLabel->"From In[62]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[62]="]
}, Open  ]],

Cell["\<\
Next we supply the information required by the computer, namely, vielbein, \
coordinates and corodinate differentials\
\>", "Text"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(fform = {dt, s\_1[t] dx\_1, s\_2[t] dx\_2, 
          s\_3[t] dx\_3};\)\[IndentingNewLine]
    \(coordi = {t, x\_1, x\_2, x\_3};\)\[IndentingNewLine]
    \(diffe = {dt, dx\_1, dx\_2, dx\_3};\)\)\)\)], "Input",
  CellLabel->"In[81]:="],

Cell["\<\
We proceed the calculation evalutaing the external differential of the \
vielbein\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(contorgenresume\)\)\)], "Input",
  CellLabel->"In[84]:="],

Cell[BoxData[
    \("I calculate the exterior differentials of the vielbeins"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("--------------------"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("I finished!"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("Next I calculate the inveverse vielbein"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("Done!"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("I resume the calculation of the contorsion"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \(" I calculate the contorsion c[i,j,k] for "\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]1\),
      SequenceForm[ "i = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]2\),
      SequenceForm[ "i = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]3\),
      SequenceForm[ "i = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[\("i = "\[InvisibleSpace]4\),
      SequenceForm[ "i = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("I have finished!"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("The result, encoded in a vector dE[i] is the following:"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[\("dE["\[InvisibleSpace]1\[InvisibleSpace]"] = "\
\[InvisibleSpace]0\),
      SequenceForm[ "dE[", 1, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"dE[\"\>", "\[InvisibleSpace]", "2", 
        "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_2\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_1\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_1[t]\)]}],
      SequenceForm[ "dE[", 2, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 2]], 
          Power[ 
            Subscript[ s, 1][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 1]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"dE[\"\>", "\[InvisibleSpace]", "3", 
        "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_3\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_2\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_2[t]\)]}],
      SequenceForm[ "dE[", 3, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 3]], 
          Power[ 
            Subscript[ s, 2][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 2]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"dE[\"\>", "\[InvisibleSpace]", "4", 
        "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_4\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_3\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_3[t]\)]}],
      SequenceForm[ "dE[", 4, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 4]], 
          Power[ 
            Subscript[ s, 3][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 3]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("-----------------------------"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("The contorsion is encoded in tensor named contens"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("-------------------------------"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \("Now you can begin the calculation of the spin connection by typing \
spinpackgen"\)], "Print",
  CellLabel->"From In[84]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[84]="]
}, Open  ]],

Cell["We initialize the calculation of the spin connection", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(spinpackgen\)\)\)], "Input",
  CellLabel->"In[85]:="],

Cell[BoxData[
    \("I start"\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \("now give me the contorsion tensor"\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \("by writing cont= ?"\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \("and give me the signature a vector of +/- 1"\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \("by writing signat = ? "\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \("then resume the calculation by typing spinresumegen"\)], "Print",
  CellLabel->"From In[85]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[85]="]
}, Open  ]],

Cell["\<\
Requested by the computer we indicate the file containing the contorsion and \
we specify the signature\
\>", "Text"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(cont = contens;\)\[IndentingNewLine]
    \(signat = {\(-1\), 1, 1, 1};\)\)\)\)], "Input",
  CellLabel->"In[86]:="],

Cell["We conclude the calculation of the spin connection", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(spinresumegen\)\)\)], "Input",
  CellLabel->"In[88]:="],

Cell[BoxData[
    \("I resume the calculation of the spin connection"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("-----------------"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("the result is"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"\[Omega][\"\>", "\[InvisibleSpace]", "1", 
        "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\"] = \"\>", 
        "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_2\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_1\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_1[t]\)]}],
      SequenceForm[ "\[Omega][", 1, 2, "] = ", 
        Times[ 
          Subscript[ e, 2], 
          Power[ 
            Subscript[ s, 1][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 1]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"\[Omega][\"\>", "\[InvisibleSpace]", "1", 
        "\[InvisibleSpace]", "3", "\[InvisibleSpace]", "\<\"] = \"\>", 
        "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_3\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_2\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_2[t]\)]}],
      SequenceForm[ "\[Omega][", 1, 3, "] = ", 
        Times[ 
          Subscript[ e, 3], 
          Power[ 
            Subscript[ s, 2][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 2]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"\[Omega][\"\>", "\[InvisibleSpace]", "1", 
        "\[InvisibleSpace]", "4", "\[InvisibleSpace]", "\<\"] = \"\>", 
        "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_4\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_3\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_3[t]\)]}],
      SequenceForm[ "\[Omega][", 1, 4, "] = ", 
        Times[ 
          Subscript[ e, 4], 
          Power[ 
            Subscript[ s, 3][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 3]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[\("\[Omega]["\[InvisibleSpace]2\[InvisibleSpace]3\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[Omega][", 2, 3, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[\("\[Omega]["\[InvisibleSpace]2\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[Omega][", 2, 4, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    InterpretationBox[\("\[Omega]["\[InvisibleSpace]3\[InvisibleSpace]4\
\[InvisibleSpace]"] = "\[InvisibleSpace]0\),
      SequenceForm[ "\[Omega][", 3, 4, "] = ", 0],
      Editable->False]], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("Task finished"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("The result is encoded in a tensor omega[i,j]"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("Its components are encoded in a tensor ometen[i,j,m]"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("If you want the curvature, type curvapack for quasi homogeneous \
manifolds"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \("Otherwise, type curvapackgen for general manifolds"\)], "Print",
  CellLabel->"From In[88]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[88]="]
}, Open  ]],

Cell["\<\
Next we calculate the curvature two form and the Ricci tensor\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(curvapackgen\)\(\[IndentingNewLine]\)
    \)\)\)], "Input",
  CellLabel->"In[89]:="],

Cell[BoxData[
    \("-----------------"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \(" I calculate the Riemann tensor"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("I tell you my steps :"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]1\),
      SequenceForm[ " a = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]2\),
      SequenceForm[ " a = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]3\),
      SequenceForm[ " a = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" a = "\[InvisibleSpace]4\),
      SequenceForm[ " a = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]1\),
      SequenceForm[ " b = ", 1],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]2\),
      SequenceForm[ " b = ", 2],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]3\),
      SequenceForm[ " b = ", 3],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(" b = "\[InvisibleSpace]4\),
      SequenceForm[ " b = ", 4],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("Finished"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("------------------------------------"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("Now I evaluate the curvature 2-form of your space"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("I find the following answer"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        "2", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_2\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_1\), "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_1[t]\)]}],
      SequenceForm[ "R[", 1, 2, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 2]], 
          Power[ 
            Subscript[ s, 1][ t], -1], 
          Derivative[ 2][ 
            Subscript[ s, 1]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        "3", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_3\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_2\), "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_2[t]\)]}],
      SequenceForm[ "R[", 1, 3, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 3]], 
          Power[ 
            Subscript[ s, 2][ t], -1], 
          Derivative[ 2][ 
            Subscript[ s, 2]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "1", "\[InvisibleSpace]", 
        "4", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_1 ** e\_4\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_3\), "\[Prime]\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_3[t]\)]}],
      SequenceForm[ "R[", 1, 4, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 1], 
            Subscript[ e, 4]], 
          Power[ 
            Subscript[ s, 3][ t], -1], 
          Derivative[ 2][ 
            Subscript[ s, 3]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        "3", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_2 ** e\_3\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_1\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
            RowBox[{
              SuperscriptBox[\(s\_2\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_1[t]\ s\_2[
              t]\)]}],
      SequenceForm[ "R[", 2, 3, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 2], 
            Subscript[ e, 3]], 
          Power[ 
            Subscript[ s, 1][ t], -1], 
          Power[ 
            Subscript[ s, 2][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 1]][ t], 
          Derivative[ 1][ 
            Subscript[ s, 2]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "2", "\[InvisibleSpace]", 
        "4", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_2 ** e\_4\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_1\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
            RowBox[{
              SuperscriptBox[\(s\_3\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_1[t]\ s\_3[
              t]\)]}],
      SequenceForm[ "R[", 2, 4, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 2], 
            Subscript[ e, 4]], 
          Power[ 
            Subscript[ s, 1][ t], -1], 
          Power[ 
            Subscript[ s, 3][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 1]][ t], 
          Derivative[ 1][ 
            Subscript[ s, 3]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"R[\"\>", "\[InvisibleSpace]", "3", "\[InvisibleSpace]", 
        "4", "\[InvisibleSpace]", "\<\"] = \"\>", "\[InvisibleSpace]", 
        FractionBox[
          RowBox[{\(e\_3 ** e\_4\), " ", 
            RowBox[{
              SuperscriptBox[\(s\_2\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}], " ", 
            RowBox[{
              SuperscriptBox[\(s\_3\), "\[Prime]",
                MultilineFunction->None], "[", "t", "]"}]}], \(s\_2[t]\ s\_3[
              t]\)]}],
      SequenceForm[ "R[", 3, 4, "] = ", 
        Times[ 
          NonCommutativeMultiply[ 
            Subscript[ e, 3], 
            Subscript[ e, 4]], 
          Power[ 
            Subscript[ s, 2][ t], -1], 
          Power[ 
            Subscript[ s, 3][ t], -1], 
          Derivative[ 1][ 
            Subscript[ s, 2]][ t], 
          Derivative[ 1][ 
            Subscript[ s, 3]][ t]]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("The result is encoded in a tensor RR[i,j]"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("Its components are encoded in a tensor Rie[i,j,a,b]"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("-------------------------------------"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \(" Now I calculate the Ricci tensor"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(1\[InvisibleSpace]" "\[InvisibleSpace]1\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 1, " ", 1, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(2\[InvisibleSpace]" "\[InvisibleSpace]2\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 2, " ", 2, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(3\[InvisibleSpace]" "\[InvisibleSpace]3\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 3, " ", 3, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[\(4\[InvisibleSpace]" "\[InvisibleSpace]4\
\[InvisibleSpace]" "\[InvisibleSpace]"  non zero"\),
      SequenceForm[ 4, " ", 4, " ", "  non zero"],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("I have finished the calculation"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \(" The tensor ricten[a,b]] giving the Ricci tensor "\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \(" is ready for storing on hard disk"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    InterpretationBox[
      RowBox[{"\<\"Ricci[a,] = \"\>", "\[InvisibleSpace]", 
        TagBox[
          RowBox[{"(", "\[NoBreak]", GridBox[{
                {
                  RowBox[{\(1\/2\), " ", 
                    RowBox[{"(", 
                      RowBox[{
                        FractionBox[
                          RowBox[{
                            SuperscriptBox[\(s\_1\), "\[Prime]\[Prime]",
                              MultilineFunction->None], "[", "t", 
                            "]"}], \(s\_1[t]\)], "+", 
                        FractionBox[
                          RowBox[{
                            SuperscriptBox[\(s\_2\), "\[Prime]\[Prime]",
                              MultilineFunction->None], "[", "t", 
                            "]"}], \(s\_2[t]\)], "+", 
                        FractionBox[
                          RowBox[{
                            SuperscriptBox[\(s\_3\), "\[Prime]\[Prime]",
                              MultilineFunction->None], "[", "t", 
                            "]"}], \(s\_3[t]\)]}], ")"}]}], "0", "0", "0"},
                {"0", 
                  FractionBox[
                    RowBox[{
                      RowBox[{\(s\_2[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_1\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_3\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_3[t]\), " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                SuperscriptBox[\(s\_1\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}], 
                              " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_2\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}]}],
                             "+", 
                            RowBox[{\(s\_2[t]\), " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_1\), "\[Prime]\[Prime]",
                                  MultilineFunction->None], "[", "t", 
                                "]"}]}]}], ")"}]}]}], \(2\ s\_1[t]\ s\_2[
                        t]\ s\_3[t]\)], "0", "0"},
                {"0", "0", 
                  FractionBox[
                    RowBox[{
                      RowBox[{\(s\_1[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_2\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_3\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_3[t]\), " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                SuperscriptBox[\(s\_1\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}], 
                              " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_2\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}]}],
                             "+", 
                            RowBox[{\(s\_1[t]\), " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_2\), "\[Prime]\[Prime]",
                                  MultilineFunction->None], "[", "t", 
                                "]"}]}]}], ")"}]}]}], \(2\ s\_1[t]\ s\_2[
                        t]\ s\_3[t]\)], "0"},
                {"0", "0", "0", 
                  FractionBox[
                    RowBox[{
                      RowBox[{\(s\_1[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_2\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_3\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_2[t]\), " ", 
                        RowBox[{"(", 
                          RowBox[{
                            RowBox[{
                              RowBox[{
                                SuperscriptBox[\(s\_1\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}], 
                              " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_3\), "\[Prime]",
                                  MultilineFunction->None], "[", "t", "]"}]}],
                             "+", 
                            RowBox[{\(s\_1[t]\), " ", 
                              RowBox[{
                                SuperscriptBox[\(s\_3\), "\[Prime]\[Prime]",
                                  MultilineFunction->None], "[", "t", 
                                "]"}]}]}], ")"}]}]}], \(2\ s\_1[t]\ s\_2[
                        t]\ s\_3[t]\)]}
                },
              RowSpacings->1,
              ColumnSpacings->1,
              ColumnAlignments->{Left}], "\[NoBreak]", ")"}],
          Function[ BoxForm`e$, 
            MatrixForm[ BoxForm`e$]]]}],
      SequenceForm[ "Ricci[a,] = ", 
        MatrixForm[ {{
          Times[ 
            Rational[ 1, 2], 
            Plus[ 
              Times[ 
                Power[ 
                  Subscript[ s, 1][ t], -1], 
                Derivative[ 2][ 
                  Subscript[ s, 1]][ t]], 
              Times[ 
                Power[ 
                  Subscript[ s, 2][ t], -1], 
                Derivative[ 2][ 
                  Subscript[ s, 2]][ t]], 
              Times[ 
                Power[ 
                  Subscript[ s, 3][ t], -1], 
                Derivative[ 2][ 
                  Subscript[ s, 3]][ t]]]], 0, 0, 0}, {0, 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ s, 1][ t], -1], 
            Power[ 
              Subscript[ s, 2][ t], -1], 
            Power[ 
              Subscript[ s, 3][ t], -1], 
            Plus[ 
              Times[ 
                Subscript[ s, 2][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 1]][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 3]][ t]], 
              Times[ 
                Subscript[ s, 3][ t], 
                Plus[ 
                  Times[ 
                    Derivative[ 1][ 
                      Subscript[ s, 1]][ t], 
                    Derivative[ 1][ 
                      Subscript[ s, 2]][ t]], 
                  Times[ 
                    Subscript[ s, 2][ t], 
                    Derivative[ 2][ 
                      Subscript[ s, 1]][ t]]]]]], 0, 0}, {0, 0, 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ s, 1][ t], -1], 
            Power[ 
              Subscript[ s, 2][ t], -1], 
            Power[ 
              Subscript[ s, 3][ t], -1], 
            Plus[ 
              Times[ 
                Subscript[ s, 1][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 2]][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 3]][ t]], 
              Times[ 
                Subscript[ s, 3][ t], 
                Plus[ 
                  Times[ 
                    Derivative[ 1][ 
                      Subscript[ s, 1]][ t], 
                    Derivative[ 1][ 
                      Subscript[ s, 2]][ t]], 
                  Times[ 
                    Subscript[ s, 1][ t], 
                    Derivative[ 2][ 
                      Subscript[ s, 2]][ t]]]]]], 0}, {0, 0, 0, 
          Times[ 
            Rational[ 1, 2], 
            Power[ 
              Subscript[ s, 1][ t], -1], 
            Power[ 
              Subscript[ s, 2][ t], -1], 
            Power[ 
              Subscript[ s, 3][ t], -1], 
            Plus[ 
              Times[ 
                Subscript[ s, 1][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 2]][ t], 
                Derivative[ 1][ 
                  Subscript[ s, 3]][ t]], 
              Times[ 
                Subscript[ s, 2][ t], 
                Plus[ 
                  Times[ 
                    Derivative[ 1][ 
                      Subscript[ s, 1]][ t], 
                    Derivative[ 1][ 
                      Subscript[ s, 3]][ t]], 
                  Times[ 
                    Subscript[ s, 1][ t], 
                    Derivative[ 2][ 
                      Subscript[ s, 3]][ t]]]]]]}}]],
      Editable->False]], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \("----------------------------"\)], "Print",
  CellLabel->"From In[89]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[89]="]
}, Open  ]],

Cell["\<\

We display the Ricci tensor once more\
\>", "Text"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(ricten\)\)\)], "Input",
  CellLabel->"In[91]:="],

Cell[BoxData[
    RowBox[{"{", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{\(1\/2\), " ", 
              RowBox[{"(", 
                RowBox[{
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[\(s\_1\), "\[Prime]\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], \(s\_1[
                      t]\)], "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[\(s\_2\), "\[Prime]\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], \(s\_2[
                      t]\)], "+", 
                  FractionBox[
                    RowBox[{
                      SuperscriptBox[\(s\_3\), "\[Prime]\[Prime]",
                        MultilineFunction->None], "[", "t", "]"}], \(s\_3[
                      t]\)]}], ")"}]}], ",", "0", ",", "0", ",", "0"}], "}"}],
         ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", 
            FractionBox[
              RowBox[{
                RowBox[{\(s\_2[t]\), " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_1\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_3\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{\(s\_3[t]\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          SuperscriptBox[\(s\_1\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_2\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_2[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_1\), "\[Prime]\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}]}], 
                    ")"}]}]}], \(2\ s\_1[t]\ s\_2[t]\ s\_3[t]\)], ",", "0", 
            ",", "0"}], "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", 
            FractionBox[
              RowBox[{
                RowBox[{\(s\_1[t]\), " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_2\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_3\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{\(s\_3[t]\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          SuperscriptBox[\(s\_1\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_2\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_1[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_2\), "\[Prime]\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}]}], 
                    ")"}]}]}], \(2\ s\_1[t]\ s\_2[t]\ s\_3[t]\)], ",", "0"}], 
          "}"}], ",", 
        RowBox[{"{", 
          RowBox[{"0", ",", "0", ",", "0", ",", 
            FractionBox[
              RowBox[{
                RowBox[{\(s\_1[t]\), " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_2\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}], " ", 
                  RowBox[{
                    SuperscriptBox[\(s\_3\), "\[Prime]",
                      MultilineFunction->None], "[", "t", "]"}]}], "+", 
                RowBox[{\(s\_2[t]\), " ", 
                  RowBox[{"(", 
                    RowBox[{
                      RowBox[{
                        RowBox[{
                          SuperscriptBox[\(s\_1\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}], " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_3\), "\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}], "+", 
                      
                      RowBox[{\(s\_1[t]\), " ", 
                        RowBox[{
                          SuperscriptBox[\(s\_3\), "\[Prime]\[Prime]",
                            MultilineFunction->None], "[", "t", "]"}]}]}], 
                    ")"}]}]}], \(2\ s\_1[t]\ s\_2[t]\ s\_3[t]\)]}], "}"}]}], 
      "}"}]], "Output",
  CellLabel->"Out[91]="]
}, Open  ]],

Cell["\<\
The above result presents the Ricci tensor for a Kasner like metric with \
three indipendent scale factors for each of the three euclidian axes.
\
\>", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowSize->{1121, 781},
WindowMargins->{{0, Automatic}, {0, Automatic}},
Magnification->1.5,
StyleDefinitions -> "Classic.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 65, 0, 217, "Title"],
Cell[1844, 55, 193, 7, 158, "Text"],

Cell[CellGroupData[{
Cell[2062, 66, 67, 0, 92, "Subtitle"],

Cell[CellGroupData[{
Cell[2154, 70, 111, 4, 88, "Section"],
Cell[2268, 76, 43, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[2336, 80, 94, 2, 80, "Input"],
Cell[2433, 84, 65, 2, 47, "Output"]
}, Open  ]],
Cell[2513, 89, 76, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[2614, 93, 96, 2, 80, "Input"],
Cell[2713, 97, 65, 2, 47, "Output"]
}, Open  ]],
Cell[2793, 102, 613, 14, 148, "Text"],
Cell[3409, 118, 54, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[3488, 122, 96, 2, 80, "Input"],
Cell[3587, 126, 104, 2, 47, "Print"],
Cell[3694, 130, 117, 2, 47, "Print"],
Cell[3814, 134, 88, 2, 47, "Print"],
Cell[3905, 138, 121, 2, 47, "Print"],
Cell[4029, 142, 113, 2, 47, "Print"],
Cell[4145, 146, 82, 2, 47, "Print"],
Cell[4230, 150, 112, 2, 47, "Print"],
Cell[4345, 154, 132, 3, 47, "Print"],
Cell[4480, 159, 84, 2, 47, "Print"],
Cell[4567, 163, 131, 3, 47, "Print"],
Cell[4701, 168, 115, 2, 47, "Print"],
Cell[4819, 172, 112, 2, 47, "Print"],
Cell[4934, 176, 65, 2, 47, "Output"]
}, Open  ]],
Cell[5014, 181, 66, 0, 44, "Text"],
Cell[5083, 183, 71, 2, 54, "Input"],
Cell[5157, 187, 73, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[5255, 191, 101, 2, 80, "Input"],
Cell[5359, 195, 246, 5, 47, "Print"],
Cell[5608, 202, 246, 5, 47, "Print"],
Cell[5857, 209, 246, 5, 47, "Print"],
Cell[6106, 216, 246, 5, 47, "Print"],
Cell[6355, 223, 246, 5, 47, "Print"],
Cell[6604, 230, 246, 5, 47, "Print"],
Cell[6853, 237, 246, 5, 47, "Print"],
Cell[7102, 244, 246, 5, 47, "Print"],
Cell[7351, 251, 246, 5, 47, "Print"],
Cell[7600, 258, 246, 5, 47, "Print"],
Cell[7849, 265, 246, 5, 47, "Print"],
Cell[8098, 272, 246, 5, 47, "Print"],
Cell[8347, 279, 96, 2, 47, "Print"],
Cell[8446, 283, 121, 2, 47, "Print"],
Cell[8570, 287, 107, 2, 47, "Print"],
Cell[8680, 291, 99, 2, 47, "Print"],
Cell[8782, 295, 128, 3, 47, "Print"],
Cell[8913, 300, 93, 2, 47, "Print"],
Cell[9009, 304, 65, 2, 47, "Output"]
}, Open  ]],
Cell[9089, 309, 250, 4, 70, "Text"],

Cell[CellGroupData[{
Cell[9364, 317, 108, 2, 80, "Input"],
Cell[9475, 321, 756, 18, 188, "Output"]
}, Open  ]],
Cell[10246, 342, 360, 6, 96, "Text"],

Cell[CellGroupData[{
Cell[10631, 352, 170, 3, 80, "Input"],
Cell[10804, 357, 68, 2, 47, "Output"]
}, Open  ]],
Cell[10887, 362, 56, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[10968, 366, 99, 2, 80, "Input"],
Cell[11070, 370, 102, 2, 47, "Print"],
Cell[11175, 374, 121, 2, 47, "Print"],
Cell[11299, 378, 96, 2, 47, "Print"],
Cell[11398, 382, 125, 3, 47, "Print"],
Cell[11526, 387, 95, 2, 47, "Print"],
Cell[11624, 391, 99, 2, 47, "Print"],
Cell[11726, 395, 128, 3, 47, "Print"],
Cell[11857, 400, 93, 2, 47, "Print"],
Cell[11953, 404, 65, 2, 47, "Output"]
}, Open  ]],
Cell[12033, 409, 112, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[12170, 416, 95, 2, 80, "Input"],
Cell[12268, 420, 324, 5, 122, "Output"]
}, Open  ]],
Cell[12607, 428, 52, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[12684, 432, 99, 2, 80, "Input"],
Cell[12786, 436, 102, 2, 47, "Print"],
Cell[12891, 440, 113, 2, 47, "Print"],
Cell[13007, 444, 317, 6, 47, "Print"],
Cell[13327, 452, 317, 6, 47, "Print"],
Cell[13647, 460, 317, 6, 47, "Print"],
Cell[13967, 468, 317, 6, 47, "Print"],
Cell[14287, 476, 317, 6, 47, "Print"],
Cell[14607, 484, 317, 6, 47, "Print"],
Cell[14927, 492, 317, 6, 47, "Print"],
Cell[15247, 500, 317, 6, 47, "Print"],
Cell[15567, 508, 317, 6, 47, "Print"],
Cell[15887, 516, 317, 6, 47, "Print"],
Cell[16207, 524, 317, 6, 47, "Print"],
Cell[16527, 532, 317, 6, 47, "Print"],
Cell[16847, 540, 317, 6, 47, "Print"],
Cell[17167, 548, 317, 6, 47, "Print"],
Cell[17487, 556, 317, 6, 47, "Print"],
Cell[17807, 564, 317, 6, 47, "Print"],
Cell[18127, 572, 317, 6, 47, "Print"],
Cell[18447, 580, 317, 6, 47, "Print"],
Cell[18767, 588, 317, 6, 47, "Print"],
Cell[19087, 596, 317, 6, 47, "Print"],
Cell[19407, 604, 317, 6, 47, "Print"],
Cell[19727, 612, 317, 6, 47, "Print"],
Cell[20047, 620, 317, 6, 47, "Print"],
Cell[20367, 628, 317, 6, 47, "Print"],
Cell[20687, 636, 317, 6, 47, "Print"],
Cell[21007, 644, 317, 6, 47, "Print"],
Cell[21327, 652, 317, 6, 47, "Print"],
Cell[21647, 660, 317, 6, 47, "Print"],
Cell[21967, 668, 317, 6, 47, "Print"],
Cell[22287, 676, 317, 6, 47, "Print"],
Cell[22607, 684, 317, 6, 47, "Print"],
Cell[22927, 692, 317, 6, 47, "Print"],
Cell[23247, 700, 317, 6, 47, "Print"],
Cell[23567, 708, 317, 6, 47, "Print"],
Cell[23887, 716, 317, 6, 47, "Print"],
Cell[24207, 724, 317, 6, 47, "Print"],
Cell[24527, 732, 317, 6, 47, "Print"],
Cell[24847, 740, 317, 6, 47, "Print"],
Cell[25167, 748, 317, 6, 47, "Print"],
Cell[25487, 756, 317, 6, 47, "Print"],
Cell[25807, 764, 317, 6, 47, "Print"],
Cell[26127, 772, 317, 6, 47, "Print"],
Cell[26447, 780, 317, 6, 47, "Print"],
Cell[26767, 788, 317, 6, 47, "Print"],
Cell[27087, 796, 317, 6, 47, "Print"],
Cell[27407, 804, 317, 6, 47, "Print"],
Cell[27727, 812, 317, 6, 47, "Print"],
Cell[28047, 820, 317, 6, 47, "Print"],
Cell[28367, 828, 96, 2, 47, "Print"],
Cell[28466, 832, 125, 3, 47, "Print"],
Cell[28594, 837, 128, 3, 47, "Print"],
Cell[28725, 842, 93, 2, 47, "Print"],
Cell[28821, 846, 101, 2, 47, "Print"],
Cell[28925, 850, 114, 2, 47, "Print"],
Cell[29042, 854, 92, 2, 47, "Print"],
Cell[29137, 858, 765, 20, 63, "Print"],
Cell[29905, 880, 765, 20, 63, "Print"],
Cell[30673, 902, 765, 20, 63, "Print"],
Cell[31441, 924, 765, 20, 63, "Print"],
Cell[32209, 946, 765, 20, 63, "Print"],
Cell[32977, 968, 765, 20, 63, "Print"],
Cell[33745, 990, 106, 2, 47, "Print"],
Cell[33854, 994, 116, 2, 47, "Print"],
Cell[33973, 998, 65, 2, 47, "Output"]
}, Open  ]],
Cell[34053, 1003, 76, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[34154, 1007, 100, 2, 80, "Input"],
Cell[34257, 1011, 101, 2, 47, "Print"],
Cell[34361, 1015, 111, 2, 47, "Print"],
Cell[34475, 1019, 92, 2, 47, "Print"],
Cell[34570, 1023, 1172, 33, 63, "Print"],
Cell[35745, 1058, 1172, 33, 63, "Print"],
Cell[36920, 1093, 1172, 33, 63, "Print"],
Cell[38095, 1128, 1172, 33, 63, "Print"],
Cell[39270, 1163, 1172, 33, 63, "Print"],
Cell[40445, 1198, 1172, 33, 63, "Print"],
Cell[41620, 1233, 112, 2, 47, "Print"],
Cell[41735, 1237, 89, 2, 47, "Print"],
Cell[41827, 1241, 84, 2, 47, "Print"],
Cell[41914, 1245, 65, 2, 47, "Output"]
}, Open  ]],
Cell[41994, 1250, 53, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[42072, 1254, 96, 2, 80, "Input"],
Cell[42171, 1258, 102, 2, 47, "Print"],
Cell[42276, 1262, 98, 2, 47, "Print"],
Cell[42377, 1266, 246, 5, 47, "Print"],
Cell[42626, 1273, 246, 5, 47, "Print"],
Cell[42875, 1280, 246, 5, 47, "Print"],
Cell[43124, 1287, 246, 5, 47, "Print"],
Cell[43373, 1294, 96, 2, 47, "Print"],
Cell[43472, 1298, 114, 2, 47, "Print"],
Cell[43589, 1302, 99, 2, 47, "Print"],
Cell[43691, 1306, 128, 3, 47, "Print"],
Cell[43822, 1311, 93, 2, 47, "Print"],
Cell[43918, 1315, 65, 2, 47, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44020, 1322, 107, 2, 80, "Input"],
Cell[44130, 1326, 535, 13, 196, "Output"]
}, Open  ]],
Cell[44680, 1342, 255, 5, 96, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[44972, 1352, 117, 3, 88, "Section"],
Cell[45092, 1357, 181, 4, 70, "Text"],
Cell[45276, 1363, 70, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[45371, 1367, 98, 2, 80, "Input"],
Cell[45472, 1371, 100, 2, 47, "Print"],
Cell[45575, 1375, 211, 4, 47, "Print"],
Cell[45789, 1381, 270, 6, 47, "Print"],
Cell[46062, 1389, 106, 2, 47, "Print"],
Cell[46171, 1393, 102, 2, 47, "Print"],
Cell[46276, 1397, 103, 2, 47, "Print"],
Cell[46382, 1401, 116, 2, 47, "Print"],
Cell[46501, 1405, 104, 2, 47, "Print"],
Cell[46608, 1409, 76, 2, 47, "Print"],
Cell[46687, 1413, 65, 2, 47, "Output"]
}, Open  ]],
Cell[46767, 1418, 141, 3, 44, "Text"],
Cell[46911, 1423, 283, 5, 132, "Input"],
Cell[47197, 1430, 105, 3, 44, "Text"],

Cell[CellGroupData[{
Cell[47327, 1437, 104, 2, 80, "Input"],
Cell[47434, 1441, 120, 2, 47, "Print"],
Cell[47557, 1445, 85, 2, 47, "Print"],
Cell[47645, 1449, 76, 2, 47, "Print"],
Cell[47724, 1453, 104, 2, 47, "Print"],
Cell[47831, 1457, 70, 2, 47, "Print"],
Cell[47904, 1461, 107, 2, 47, "Print"],
Cell[48014, 1465, 106, 2, 47, "Print"],
Cell[48123, 1469, 161, 4, 47, "Print"],
Cell[48287, 1475, 161, 4, 47, "Print"],
Cell[48451, 1481, 161, 4, 47, "Print"],
Cell[48615, 1487, 161, 4, 47, "Print"],
Cell[48779, 1493, 81, 2, 47, "Print"],
Cell[48863, 1497, 120, 2, 47, "Print"],
Cell[48986, 1501, 213, 5, 47, "Print"],
Cell[49202, 1508, 710, 19, 67, "Print"],
Cell[49915, 1529, 710, 19, 67, "Print"],
Cell[50628, 1550, 710, 19, 67, "Print"],
Cell[51341, 1571, 94, 2, 47, "Print"],
Cell[51438, 1575, 114, 2, 47, "Print"],
Cell[51555, 1579, 96, 2, 47, "Print"],
Cell[51654, 1583, 145, 3, 47, "Print"],
Cell[51802, 1588, 65, 2, 47, "Output"]
}, Open  ]],
Cell[51882, 1593, 68, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[51975, 1597, 100, 2, 80, "Input"],
Cell[52078, 1601, 72, 2, 47, "Print"],
Cell[52153, 1605, 98, 2, 47, "Print"],
Cell[52254, 1609, 83, 2, 47, "Print"],
Cell[52340, 1613, 108, 2, 47, "Print"],
Cell[52451, 1617, 87, 2, 47, "Print"],
Cell[52541, 1621, 116, 2, 47, "Print"],
Cell[52660, 1625, 65, 2, 47, "Output"]
}, Open  ]],
Cell[52740, 1630, 127, 3, 44, "Text"],
Cell[52870, 1635, 163, 3, 106, "Input"],
Cell[53036, 1640, 66, 0, 44, "Text"],

Cell[CellGroupData[{
Cell[53127, 1644, 102, 2, 80, "Input"],
Cell[53232, 1648, 112, 2, 47, "Print"],
Cell[53347, 1652, 82, 2, 47, "Print"],
Cell[53432, 1656, 78, 2, 47, "Print"],
Cell[53513, 1660, 683, 18, 67, "Print"],
Cell[54199, 1680, 683, 18, 67, "Print"],
Cell[54885, 1700, 683, 18, 67, "Print"],
Cell[55571, 1720, 246, 5, 47, "Print"],
Cell[55820, 1727, 246, 5, 47, "Print"],
Cell[56069, 1734, 246, 5, 47, "Print"],
Cell[56318, 1741, 78, 2, 47, "Print"],
Cell[56399, 1745, 109, 2, 47, "Print"],
Cell[56511, 1749, 117, 2, 47, "Print"],
Cell[56631, 1753, 140, 3, 47, "Print"],
Cell[56774, 1758, 115, 2, 47, "Print"],
Cell[56892, 1762, 65, 2, 47, "Output"]
}, Open  ]],
Cell[56972, 1767, 85, 2, 44, "Text"],

Cell[CellGroupData[{
Cell[57082, 1773, 133, 3, 106, "Input"],
Cell[57218, 1778, 82, 2, 47, "Print"],
Cell[57303, 1782, 96, 2, 47, "Print"],
Cell[57402, 1786, 86, 2, 47, "Print"],
Cell[57491, 1790, 163, 4, 47, "Print"],
Cell[57657, 1796, 163, 4, 47, "Print"],
Cell[57823, 1802, 163, 4, 47, "Print"],
Cell[57989, 1808, 163, 4, 47, "Print"],
Cell[58155, 1814, 163, 4, 47, "Print"],
Cell[58321, 1820, 163, 4, 47, "Print"],
Cell[58487, 1826, 163, 4, 47, "Print"],
Cell[58653, 1832, 163, 4, 47, "Print"],
Cell[58819, 1838, 163, 4, 47, "Print"],
Cell[58985, 1844, 163, 4, 47, "Print"],
Cell[59151, 1850, 163, 4, 47, "Print"],
Cell[59317, 1856, 163, 4, 47, "Print"],
Cell[59483, 1862, 163, 4, 47, "Print"],
Cell[59649, 1868, 163, 4, 47, "Print"],
Cell[59815, 1874, 163, 4, 47, "Print"],
Cell[59981, 1880, 163, 4, 47, "Print"],
Cell[60147, 1886, 163, 4, 47, "Print"],
Cell[60313, 1892, 163, 4, 47, "Print"],
Cell[60479, 1898, 163, 4, 47, "Print"],
Cell[60645, 1904, 163, 4, 47, "Print"],
Cell[60811, 1910, 73, 2, 47, "Print"],
Cell[60887, 1914, 101, 2, 47, "Print"],
Cell[60991, 1918, 114, 2, 47, "Print"],
Cell[61108, 1922, 92, 2, 47, "Print"],
Cell[61203, 1926, 745, 19, 67, "Print"],
Cell[61951, 1947, 745, 19, 67, "Print"],
Cell[62699, 1968, 745, 19, 67, "Print"],
Cell[63447, 1989, 1019, 27, 67, "Print"],
Cell[64469, 2018, 1019, 27, 67, "Print"],
Cell[65491, 2047, 1019, 27, 67, "Print"],
Cell[66513, 2076, 106, 2, 47, "Print"],
Cell[66622, 2080, 116, 2, 47, "Print"],
Cell[66741, 2084, 102, 2, 47, "Print"],
Cell[66846, 2088, 98, 2, 47, "Print"],
Cell[66947, 2092, 246, 5, 47, "Print"],
Cell[67196, 2099, 246, 5, 47, "Print"],
Cell[67445, 2106, 246, 5, 47, "Print"],
Cell[67694, 2113, 246, 5, 47, "Print"],
Cell[67943, 2120, 96, 2, 47, "Print"],
Cell[68042, 2124, 114, 2, 47, "Print"],
Cell[68159, 2128, 99, 2, 47, "Print"],
Cell[68261, 2132, 9181, 219, 188, "Print"],
Cell[77445, 2353, 93, 2, 47, "Print"],
Cell[77541, 2357, 65, 2, 47, "Output"]
}, Open  ]],
Cell[77621, 2362, 62, 3, 70, "Text"],

Cell[CellGroupData[{
Cell[77708, 2369, 95, 2, 80, "Input"],
Cell[77806, 2373, 4886, 108, 214, "Output"]
}, Open  ]],
Cell[82707, 2484, 169, 4, 96, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

