(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.2'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    291854,       6025]*)
(*NotebookOutlinePosition[    292556,       6049]*)
(*  CellTagsIndexPosition[    292512,       6045]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell["Test of the MATHEMATICA package periastro", "Title"],

Cell[TextData[{
  "\nThis Notebook contains some examples of the use of the package ",
  StyleBox["periastro ",
    FontWeight->"Bold"],
  StyleBox["to calculate and display orbits in the Schwarzschild metric",
    FontVariations->{"CompatibilityType"->0}]
}], "Text"],

Cell[CellGroupData[{

Cell["\<\

This section contains some examples of orbits calculated with periastro\
\>", "Section"],

Cell[CellGroupData[{

Cell["\<\
With a = 60 m and \[Epsilon] = 0.6
\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(periastro\)\)\)], "Input",
  CellLabel->"In[12]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("We make a comparison between orbits in Newton's Theory"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("and in Schwarzschild geometry"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("Input of geometrical parameters"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("PLOT of the ORBIT with the following parameters:"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    InterpretationBox[\("Semilatus rectum =  "\[InvisibleSpace]60\
\[InvisibleSpace]"m"\),
      SequenceForm[ "Semilatus rectum =  ", 60, "m"],
      Editable->False]], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    InterpretationBox[\("eccentricity =  "\[InvisibleSpace]0.6`\),
      SequenceForm[ "eccentricity =  ", .59999999999999998],
      Editable->False]], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("Keplerian orbit with these parameters"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.785714 0.00793651 0.309017 0.00613134 [
[1.025 .30902 0 -6.28125 ]
[1.025 .30902 10 6.28125 ]
[.78571 .64303 -5 0 ]
[.78571 .64303 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.78571 0 m
.78571 .61803 L
s
gsave
.78571 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.006 w
.97619 .30902 m
.97619 .31016 L
.97618 .3112 L
.97616 .3124 L
.97613 .31353 L
.97607 .31554 L
.97598 .31773 L
.97585 .32014 L
.97568 .3227 L
.97527 .32728 L
.97473 .33202 L
.97412 .33646 L
.9723 .34658 L
.96984 .35692 L
.96705 .36641 L
.95878 .38787 L
.94921 .40667 L
.93601 .42734 L
.91908 .44876 L
.90044 .46828 L
.85129 .50771 L
.82046 .52671 L
.7812 .54653 L
.73706 .56426 L
.71182 .5726 L
.68256 .58084 L
.6528 .58776 L
.62375 .59321 L
.6091 .59549 L
.59266 .5977 L
.57786 .59936 L
.56147 .60086 L
.55232 .60154 L
.54381 .60207 L
.53504 .60252 L
.52678 .60286 L
.52197 .60301 L
.51757 .60312 L
.51266 .60322 L
.50994 .60326 L
.50737 .60329 L
.50486 .60331 L
.50219 .60332 L
.49737 .60332 L
.49217 .60328 L
.48919 .60325 L
.4864 .6032 L
.48119 .60309 L
.47549 .60293 L
.46501 .60253 L
Mistroke
.45469 .60199 L
.44504 .60135 L
.42284 .59943 L
.39877 .59659 L
.35359 .58907 L
.3278 .58341 L
.304 .57724 L
.25758 .56233 L
.21519 .54488 L
.13909 .50101 L
.10405 .47252 L
.07226 .43836 L
.04863 .40279 L
.03855 .38168 L
.03463 .3714 L
.03149 .36166 L
.02902 .35242 L
.02717 .3439 L
.02558 .33439 L
.02495 .32939 L
.02444 .32411 L
.0241 .3193 L
.02397 .3166 L
.02388 .31415 L
.02381 .30938 L
.02386 .30489 L
.02393 .30234 L
.02405 .29964 L
.02436 .29481 L
.02459 .29212 L
.02485 .28961 L
.02554 .28392 L
.02721 .27392 L
.02924 .26471 L
.03554 .2441 L
.04301 .22629 L
.05283 .20785 L
.07407 .17741 L
.10314 .14636 L
.13838 .11753 L
.17434 .0943 L
.21944 .07122 L
.26334 .05363 L
.30398 .0408 L
.34748 .03022 L
.37208 .02553 L
.39507 .02195 L
.41527 .01941 L
.43717 .01729 L
.44727 .01652 L
Mistroke
.45802 .01586 L
.46807 .01538 L
.47716 .01505 L
.48242 .01491 L
.48727 .01482 L
.49006 .01478 L
.49257 .01475 L
.49546 .01473 L
.49818 .01472 L
.5031 .01472 L
.5076 .01475 L
.5125 .01481 L
.51496 .01486 L
.51765 .01492 L
.52684 .01518 L
.53511 .01551 L
.54453 .016 L
.55333 .01656 L
.5849 .01943 L
.60053 .02135 L
.61724 .02377 L
.64941 .02958 L
.7017 .04242 L
.74952 .05835 L
.79368 .07735 L
.8291 .09631 L
.86181 .11768 L
.90842 .15769 L
.92598 .17748 L
.94133 .19849 L
.95301 .21831 L
.96276 .23962 L
.96637 .24955 L
.96955 .26003 L
.97178 .26906 L
.97366 .27873 L
.97432 .28294 L
.97485 .28692 L
.97528 .2908 L
.9756 .29439 L
.97584 .29779 L
.97594 .29952 L
.97603 .30139 L
.97607 .30247 L
.97611 .30346 L
.97613 .30438 L
.97615 .3054 L
.97617 .30631 L
.97618 .30716 L
.97619 .30806 L
Mistroke
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 177.875},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003oo`3oooli
0?ooo`030000003oool0oooo07D0oooo003o0?ooocT0oooo00<000000?ooo`3oool0M@3oool00?l0
oooo>@3oool00`000000oooo0?ooo`1e0?ooo`00o`3oooli0?ooo`030000003oool0oooo07D0oooo
003o0?ooocT0oooo00<000000?ooo`3oool0M@3oool00;h0oooo5`00001S0?ooo`030000003oool0
oooo07D0oooo002Z0?oood400000C@3oool00`000000oooo0?ooo`1e0?ooo`00XP3ooolL000001L0
oooo700000170?ooo`030000003oool0oooo07D0oooo002J0?oooa000000@@3oool=00000400oooo
00<000000?ooo`3oool0M@3oool009D0oooo3@00001?0?ooo`d00000>P3oool00`000000oooo0?oo
o`1e0?ooo`00T03oool:000005h0oooo3000000d0?ooo`030000003oool0oooo07D0oooo002<0?oo
o`T00000J@3oool:00000300oooo00<000000?ooo`3oool0M@3oool008P0oooo2000001d0?ooo`P0
0000;03oool00`000000oooo0?ooo`1e0?ooo`00Q03oool8000007`0oooo2000000X0?ooo`030000
003oool0oooo07D0oooo001o0?ooo`T00000Q03oool8000002@0oooo00<000000?ooo`3oool0M@3o
ool007`0oooo2000002<0?ooo`P00000803oool00`000000oooo0?ooo`1e0?ooo`00N@3oool70000
09@0oooo2000000L0?ooo`030000003oool0oooo07D0oooo001f0?ooo`L00000V`3oool7000001T0
oooo00<000000?ooo`3oool0M@3oool007<0oooo1`00002R0?ooo`H000005P3oool00`000000oooo
0?ooo`1e0?ooo`00L03oool700000:P0oooo1P00000C0?ooo`030000003oool0oooo07D0oooo001^
0?ooo`H00000[P3oool600000100oooo00<000000?ooo`3oool0M@3oool006/0oooo1P00002d0?oo
o`H000003@3oool00`000000oooo0?ooo`1e0?ooo`00J@3oool600000;T0oooo1P00000:0?ooo`03
0000003oool0oooo07D0oooo001V0?ooo`H00000_`3oool6000000L0oooo00<000000?ooo`3oool0
M@3oool006@0oooo1P0000330?ooo`H000001@3oool00`000000oooo0?ooo`1e0?ooo`00H@3oool6
00000<T0oooo1@0000030?ooo`030000003oool0oooo07D0oooo001O0?ooo`H00000c@3oool50000
00030?ooo`000000oooo07H0oooo001M0?ooo`D00000dP3oool6000007H0oooo001K0?ooo`D00000
eP3oool6000007@0oooo001I0?ooo`D00000fP3oool600000780oooo001G0?ooo`D00000g03oool0
0`000000oooo0?ooo`0400000740oooo001F0?ooo`@00000gP3oool00`000000oooo0?ooo`020?oo
o`@00000K`3oool005@0oooo1000003P0?ooo`030000003oool0oooo00<0oooo1@00001]0?ooo`00
DP3oool500000>40oooo00<000000?ooo`3oool01@3oool5000006/0oooo001@0?ooo`D00000h`3o
ool00`000000oooo0?ooo`070?ooo`@00000JP3oool004h0oooo1@00003U0?ooo`030000003oool0
oooo00T0oooo1000001X0?ooo`00C03oool500000>L0oooo00<000000?ooo`3oool02P3oool50000
06H0oooo001;0?ooo`@00000j@3oool00`000000oooo0?ooo`0<0?ooo`D00000I03oool004T0oooo
1000003[0?ooo`030000003oool0oooo00h0oooo1000001S0?ooo`00B03oool400000>`0oooo00<0
00000?ooo`3oool0403oool400000640oooo00160?ooo`@00000kP3oool00`000000oooo0?ooo`0A
0?ooo`@00000H03oool004D0oooo1000003_0?ooo`030000003oool0oooo01<0oooo1000001N0?oo
o`00@`3oool400000?40oooo00<000000?ooo`3oool0503oool5000005`0oooo00120?ooo`@00000
lP3oool00`000000oooo0?ooo`0F0?ooo`@00000F`3oool00400oooo1000003d0?ooo`030000003o
ool0oooo01P0oooo1000001I0?ooo`00?`3oool400000?D0oooo00<000000?ooo`3oool06@3oool4
000005P0oooo000m0?ooo`@00000m`3oool00`000000oooo0?ooo`0K0?ooo`<00000E`3oool003`0
oooo1000003h0?ooo`030000003oool0oooo01`0oooo1000001E0?ooo`00>`3oool300000?X0oooo
00<000000?ooo`3oool07@3oool4000005@0oooo000j0?ooo`<00000n`3oool00`000000oooo0?oo
o`0O0?ooo`<00000D`3oool003P0oooo1000003l0?ooo`030000003oool0oooo0200oooo0`00001B
0?ooo`00=`3oool400000?d0oooo00<000000?ooo`3oool08@3oool300000540oooo000f0?ooo`<0
0000o`3oool00`000000oooo0?ooo`0R0?ooo`@00000C`3oool003D0oooo0`00003o0?ooo`40oooo
00<000000?ooo`3oool08`3oool4000004h0oooo000c0?ooo`@00000o`3oool20?ooo`030000003o
ool0oooo02D0oooo0`00001=0?ooo`00<P3oool400000?l0oooo0`3oool00`000000oooo0?ooo`0V
0?ooo`<00000C03oool00340oooo0`00003o0?ooo`D0oooo00<000000?ooo`3oool09`3oool30000
04/0oooo000`0?ooo`<00000o`3oool60?ooo`030000003oool0oooo02P0oooo100000190?ooo`00
;`3oool300000?l0oooo1`3oool00`000000oooo0?ooo`0Y0?ooo`@00000B03oool002h0oooo0`00
003o0?ooo`P0oooo00<000000?ooo`3oool0:`3oool3000004L0oooo000]0?ooo`<00000o`3oool9
0?ooo`030000003oool0oooo02`0oooo0P0000170?ooo`00;03oool300000?l0oooo2P3oool00`00
0000oooo0?ooo`0]0?ooo`800000AP3oool002`0oooo0P00003o0?ooo`/0oooo00<000000?ooo`3o
ool0;P3oool2000004D0oooo000[0?ooo`800000o`3oool<0?ooo`030000003oool0oooo02l0oooo
0P0000140?ooo`00:P3oool300000?l0oooo303oool00`000000oooo0?ooo`0`0?ooo`030000003o
ool0oooo0480oooo000Y0?ooo`<00000o`3oool=0?ooo`030000003oool0oooo0300oooo0P000013
0?ooo`00:03oool300000?l0oooo3P3oool00`000000oooo0?ooo`0a0?ooo`800000@P3oool002L0
oooo0`00003o0?ooo`l0oooo00<000000?ooo`3oool0<P3oool200000440oooo000W0?ooo`800000
o`3oool@0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0?`3oool002H0oooo0P00
003o0?oooa40oooo00<000000?ooo`3oool0<`3oool200000400oooo000U0?ooo`800000o`3ooolB
0?ooo`030000003oool0oooo03@0oooo0P00000o0?ooo`009@3oool00`000000oooo0?ooo`3o0?oo
oa40oooo00<000000?ooo`3oool0=@3oool2000003h0oooo000T0?ooo`800000o`3ooolC0?ooo`03
0000003oool0oooo03H0oooo00<000000?ooo`3oool0?03oool002<0oooo0P00003o0?oooa@0oooo
00<000000?ooo`3oool0=P3oool2000003d0oooo000S0?ooo`030000003oool0oooo0?l0oooo4`3o
ool00`000000oooo0?ooo`0g0?ooo`800000?03oool00280oooo0P00003o0?oooaD0oooo00<00000
0?ooo`3oool0>03oool2000003/0oooo000Q0?ooo`800000o`3ooolF0?ooo`030000003oool0oooo
03T0oooo00<000000?ooo`3oool0>@3oool00240oooo00<000000?ooo`3oool0o`3ooolE0?ooo`03
0000003oool0oooo03T0oooo0P00000j0?ooo`00803oool200000?l0oooo5`3oool00`000000oooo
0?ooo`0j0?ooo`800000>@3oool001l0oooo0P00003o0?oooaP0oooo00<000000?ooo`3oool0>`3o
ool00`000000oooo0?ooo`0g0?ooo`007`3oool00`000000oooo0?ooo`3o0?oooaL0oooo00<00000
0?ooo`3oool0>`3oool2000003P0oooo000N0?ooo`800000o`3ooolI0?ooo`030000003oool0oooo
03`0oooo00<000000?ooo`3oool0=P3oool001h0oooo00<000000?ooo`3oool0o`3ooolH0?ooo`03
0000003oool0oooo03`0oooo0P00000g0?ooo`007@3oool200000?l0oooo6P3oool00`000000oooo
0?ooo`0m0?ooo`800000=P3oool001`0oooo0P00003o0?oooa/0oooo00<000000?ooo`3oool0?P3o
ool00`000000oooo0?ooo`0d0?ooo`00703oool00`000000oooo0?ooo`3o0?oooaX0oooo00<00000
0?ooo`3oool0?P3oool2000003D0oooo000K0?ooo`800000o`3ooolL0?ooo`030000003oool0oooo
03h0oooo0P00000e0?ooo`006`3oool00`000000oooo0?ooo`3o0?oooa/0oooo00<000000?ooo`3o
ool0?P3oool3000003@0oooo000J0?ooo`800000o`3ooolM0?ooo`030000003oool0oooo03l0oooo
0P00000d0?ooo`006P3oool00`000000oooo0?ooo`3o0?oooa`0oooo00<000000?ooo`3oool0?`3o
ool3000003<0oooo000I0?ooo`800000o`3ooolN0?ooo`030000003oool0oooo0400oooo0P00000c
0?ooo`006@3oool00`000000oooo0?ooo`3o0?oooad0oooo00<000000?ooo`3oool0@03oool20000
03<0oooo000H0?ooo`800000o`3ooolO0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3o
ool0<@3oool001P0oooo00<000000?ooo`3oool0o`3ooolN0?ooo`030000003oool0oooo0440oooo
0P00000b0?ooo`005`3oool200000?l0oooo803oool00`000000oooo0?ooo`120?ooo`030000003o
ool0oooo0300oooo000G0?ooo`800000o`3ooolP0?ooo`030000003oool0oooo0480oooo0P00000a
0?ooo`005`3oool200000?l0oooo803oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo
02l0oooo000F0?ooo`<00000o`3ooolP0?ooo`030000003oool0oooo04<0oooo0P00000`0?ooo`00
5P3oool200000?l0oooo8@3oool00`000000oooo0?ooo`130?ooo`800000<03oool001H0oooo0P00
003o0?ooob40oooo00<000000?ooo`3oool0@`3oool200000300oooo000F0?ooo`800000o`3ooolQ
0?ooo`030000003oool0oooo04<0oooo0`00000_0?ooo`005@3oool300000?l0oooo8@3oool00`00
0000oooo0?ooo`140?ooo`800000;`3oool001D0oooo0P00003o0?ooob80oooo00<000000?ooo`3o
ool0A03oool2000002l0oooo000E0?ooo`800000o`3ooolR0?ooo`030000003oool0oooo04@0oooo
0`00000^0?ooo`005@3oool200000?l0oooo8P3oool00`000000oooo0?ooo`150?ooo`800000;P3o
ool001@0oooo0`00003o0?ooob80oooo00<000000?ooo`3oool0A@3oool2000002h0oooo000D0?oo
o`800000o`3ooolS0?ooo`030000003oool0oooo04D0oooo0P00000^0?ooo`00503oool200000?l0
oooo8`3oool00`000000oooo0?ooo`150?ooo`800000;P3oool001@0oooo0P00003o0?ooob<0oooo
00<000000?ooo`3oool0A@3oool2000002h0oooo000C0?ooo`<00000o`3ooolS0?ooo`030000003o
ool0oooo04D0oooo0P00000^0?ooo`004`3oool200000?l0oooo903oool00`000000oooo0?ooo`15
0?ooo`800000;P3oool001<0oooo0P00003o0?ooob@0oooo00<000000?ooo`3oool0A@3oool20000
02h0oooo000C0?ooo`800000o`3ooolT0?ooo`030000003oool0oooo04D0oooo0P00000^0?ooo`00
4`3oool200000?l0oooo903oool00`000000oooo0?ooo`150?ooo`800000;P3oool001<0oooo0P00
003o0?ooob@0oooo00<000000?ooo`3oool0A@3oool2000002h0oooo000C0?ooo`800000o`3ooolT
0?ooo`030000003oool0oooo04D0oooo0`00000]0?ooo`004`3oool200000?l0oooo903oool00`00
0000oooo0?ooo`150?ooo`<00000503oool01P3OW4P0000000000000M;l0oooo0;md0080000000<0
B9cO0?ooo`3oool03P3oool001<0oooo0P00003o0?ooob@0oooo00<000000?ooo`3oool0AP3oool2
000001D0oooo00L0okmd0000001d_ol0oooo0?noM0000000M;oo0140oooo000;0?ooool00000PP00
000=0?ooo`050?oo_`1d04P0B7A804P0M02oool04P3oool001<0oooo0P00003o0?ooob@0oooo00<0
00000?ooo`3oool0A@3oool3000001L0oooo00<0W4P004Q8B000B9`04`3oool001<0oooo0P00003o
0?ooob@0oooo00<000000?ooo`3oool0AP3oool2000001D0oooo00L0oono07@00018W=l0oooo0=nL
B00007@0_ooo0140oooo000C0?ooo`800000o`3ooolT0?ooo`030000003oool0oooo04H0oooo0P00
000D0?ooo`090?oOW01800000000001d_`3oool0_g@00000000004P0W=oo0100oooo000C0?ooo`80
0000o`3ooolT0?ooo`030000003oool0oooo04H0oooo0P00000]0?ooo`004`3oool200000?l0oooo
903oool00`000000oooo0?ooo`150?ooo`<00000;@3oool001<0oooo0P00003o0?ooob@0oooo00<0
00000?ooo`3oool0A@3oool2000002h0oooo000C0?ooo`800000o`3ooolT0?ooo`030000003oool0
oooo04D0oooo0P00000^0?ooo`004`3oool200000?l0oooo903oool00`000000oooo0?ooo`150?oo
o`800000;P3oool001<0oooo0P00003o0?ooob@0oooo00<000000?ooo`3oool0A@3oool2000002h0
oooo000C0?ooo`<00000o`3ooolS0?ooo`030000003oool0oooo04D0oooo0P00000^0?ooo`00503o
ool200000?l0oooo8`3oool00`000000oooo0?ooo`150?ooo`800000;P3oool001@0oooo0P00003o
0?ooob<0oooo00<000000?ooo`3oool0A@3oool2000002h0oooo000D0?ooo`800000o`3ooolS0?oo
o`030000003oool0oooo04D0oooo0P00000^0?ooo`00503oool300000?l0oooo8P3oool00`000000
oooo0?ooo`150?ooo`800000;P3oool001D0oooo0P00003o0?ooob80oooo00<000000?ooo`3oool0
A03oool3000002h0oooo000E0?ooo`800000o`3ooolR0?ooo`030000003oool0oooo04@0oooo0P00
000_0?ooo`005@3oool300000?l0oooo8@3oool00`000000oooo0?ooo`140?ooo`800000;`3oool0
01H0oooo0P00003o0?ooob40oooo00<000000?ooo`3oool0A03oool2000002l0oooo000F0?ooo`80
0000o`3ooolQ0?ooo`030000003oool0oooo04<0oooo0`00000_0?ooo`005P3oool200000?l0oooo
8@3oool00`000000oooo0?ooo`130?ooo`800000<03oool001H0oooo0`00003o0?ooob00oooo00<0
00000?ooo`3oool0@`3oool200000300oooo000G0?ooo`800000o`3ooolP0?ooo`030000003oool0
oooo0480oooo0`00000`0?ooo`005`3oool200000?l0oooo803oool00`000000oooo0?ooo`120?oo
o`800000<@3oool001L0oooo0`00003o0?oooal0oooo00<000000?ooo`3oool0@P3oool200000340
oooo000H0?ooo`800000o`3ooolO0?ooo`030000003oool0oooo0440oooo0`00000a0?ooo`00603o
ool200000?l0oooo7`3oool00`000000oooo0?ooo`110?ooo`800000<P3oool001P0oooo0P00003o
0?oooal0oooo00<000000?ooo`3oool0@@3oool200000380oooo000I0?ooo`030000003oool0oooo
0?l0oooo7@3oool00`000000oooo0?ooo`100?ooo`<00000<P3oool001T0oooo0P00003o0?oooah0
oooo00<000000?ooo`3oool0@03oool2000003<0oooo000J0?ooo`030000003oool0oooo0?l0oooo
703oool00`000000oooo0?ooo`100?ooo`800000<`3oool001X0oooo0P00003o0?oooad0oooo00<0
00000?ooo`3oool0@03oool00`000000oooo0?ooo`0b0?ooo`006`3oool00`000000oooo0?ooo`3o
0?oooa/0oooo00<000000?ooo`3oool0?`3oool2000003@0oooo000K0?ooo`800000o`3ooolL0?oo
o`030000003oool0oooo03l0oooo00<000000?ooo`3oool0<`3oool001`0oooo00<000000?ooo`3o
ool0o`3ooolJ0?ooo`030000003oool0oooo03h0oooo0P00000e0?ooo`00703oool200000?l0oooo
6`3oool00`000000oooo0?ooo`0m0?ooo`800000=P3oool001d0oooo00<000000?ooo`3oool0o`3o
oolI0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0=@3oool001d0oooo0P00003o
0?oooaX0oooo00<000000?ooo`3oool0?03oool2000003L0oooo000N0?ooo`800000o`3ooolI0?oo
o`030000003oool0oooo03`0oooo00<000000?ooo`3oool0=P3oool001l0oooo00<000000?ooo`3o
ool0o`3ooolG0?ooo`030000003oool0oooo03/0oooo0P00000h0?ooo`007`3oool200000?l0oooo
603oool00`000000oooo0?ooo`0j0?ooo`800000>@3oool00200oooo0P00003o0?oooaL0oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0h0?ooo`008@3oool00`000000oooo0?ooo`3o
0?oooaD0oooo00<000000?ooo`3oool0>@3oool2000003X0oooo000Q0?ooo`800000o`3ooolF0?oo
o`030000003oool0oooo03T0oooo00<000000?ooo`3oool0>@3oool00280oooo00<000000?ooo`3o
ool0o`3ooolD0?ooo`030000003oool0oooo03P0oooo0P00000k0?ooo`008P3oool200000?l0oooo
5@3oool00`000000oooo0?ooo`0g0?ooo`800000?03oool002<0oooo0P00003o0?oooa@0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0k0?ooo`00903oool00`000000oooo0?ooo`3o
0?oooa80oooo00<000000?ooo`3oool0=P3oool2000003d0oooo000T0?ooo`800000o`3ooolC0?oo
o`030000003oool0oooo03D0oooo0P00000n0?ooo`009@3oool200000?l0oooo4P3oool00`000000
oooo0?ooo`0d0?ooo`800000?`3oool002H0oooo0P00003o0?oooa40oooo00<000000?ooo`3oool0
=03oool00`000000oooo0?ooo`0n0?ooo`009P3oool300000?l0oooo403oool00`000000oooo0?oo
o`0c0?ooo`800000@03oool002L0oooo0`00003o0?ooo`l0oooo00<000000?ooo`3oool0<P3oool2
00000440oooo000X0?ooo`<00000o`3oool>0?ooo`030000003oool0oooo0340oooo0P0000120?oo
o`00:@3oool300000?l0oooo3@3oool00`000000oooo0?ooo`0`0?ooo`800000@`3oool002X0oooo
0`00003o0?ooo``0oooo00<000000?ooo`3oool0;`3oool3000004<0oooo000[0?ooo`<00000o`3o
ool;0?ooo`030000003oool0oooo02h0oooo0`0000140?ooo`00;03oool300000?l0oooo2P3oool0
0`000000oooo0?ooo`0]0?ooo`<00000A@3oool002d0oooo0`00003o0?ooo`T0oooo00<000000?oo
o`3oool0;03oool3000004H0oooo000^0?ooo`<00000o`3oool80?ooo`030000003oool0oooo02/0
oooo0`0000170?ooo`00;`3oool300000?l0oooo1`3oool00`000000oooo0?ooo`0Z0?ooo`<00000
B03oool00300oooo0`00003o0?ooo`H0oooo00<000000?ooo`3oool0:@3oool3000004T0oooo000a
0?ooo`<00000o`3oool50?ooo`030000003oool0oooo02P0oooo0`00001:0?ooo`00<P3oool30000
0?l0oooo103oool00`000000oooo0?ooo`0W0?ooo`<00000B`3oool003<0oooo0`00003o0?ooo`<0
oooo00<000000?ooo`3oool09@3oool4000004`0oooo000d0?ooo`@00000o`3oool10?ooo`030000
003oool0oooo02@0oooo1000001=0?ooo`00=@3oool400000?l0oooo00<000000?ooo`3oool08`3o
ool3000004l0oooo000g0?ooo`<00000oP3oool00`000000oooo0?ooo`0R0?ooo`<00000D03oool0
03P0oooo0`00003m0?ooo`030000003oool0oooo0240oooo0`00001A0?ooo`00>@3oool300000?`0
oooo00<000000?ooo`3oool07`3oool400000580oooo000j0?ooo`<00000n`3oool00`000000oooo
0?ooo`0N0?ooo`@00000D`3oool003/0oooo1000003i0?ooo`030000003oool0oooo01d0oooo0`00
001E0?ooo`00?03oool400000?P0oooo00<000000?ooo`3oool0703oool3000005H0oooo000n0?oo
o`<00000m`3oool00`000000oooo0?ooo`0K0?ooo`<00000E`3oool003l0oooo1000003e0?ooo`03
0000003oool0oooo01T0oooo1000001H0?ooo`00@03oool400000?@0oooo00<000000?ooo`3oool0
603oool4000005T0oooo00120?ooo`@00000lP3oool00`000000oooo0?ooo`0G0?ooo`<00000F`3o
ool004<0oooo1@00003`0?ooo`030000003oool0oooo01D0oooo1000001L0?ooo`00A@3oool50000
0>h0oooo00<000000?ooo`3oool0503oool4000005d0oooo00170?ooo`@00000k@3oool00`000000
oooo0?ooo`0B0?ooo`@00000G`3oool004T0oooo1000003[0?ooo`030000003oool0oooo0100oooo
1@00001P0?ooo`00BP3oool500000>T0oooo00<000000?ooo`3oool03P3oool500000680oooo001<
0?ooo`@00000j03oool00`000000oooo0?ooo`0=0?ooo`@00000I03oool004h0oooo1000003V0?oo
o`030000003oool0oooo00/0oooo1000001V0?ooo`00C`3oool500000>@0oooo00<000000?ooo`3o
ool02@3oool5000006L0oooo001A0?ooo`@00000h`3oool00`000000oooo0?ooo`070?ooo`D00000
J@3oool005<0oooo1000003Q0?ooo`030000003oool0oooo00D0oooo1@00001[0?ooo`00E03oool5
00000=l0oooo00<000000?ooo`3oool00`3oool5000006d0oooo001F0?ooo`D00000g@3oool00`00
0000oooo0?ooo`020?ooo`@00000K`3oool005P0oooo1000003L0?ooo`030000003oool0oooo00@0
0000L@3oool005X0oooo1000003J0?ooo`H00000LP3oool005/0oooo1@00003G0?ooo`D00000M03o
ool005d0oooo1P00003A0?ooo`H00000MP3oool005l0oooo1P00003<0?ooo`P00000M`3oool00680
oooo1P0000360?ooo`L000000`3oool00`000000oooo0?ooo`1e0?ooo`00I03oool600000<80oooo
1P0000060?ooo`030000003oool0oooo07D0oooo001W0?ooo`H00000_03oool6000000T0oooo00<0
00000?ooo`3oool0M@3oool006T0oooo1P00002g0?ooo`L000002`3oool00`000000oooo0?ooo`1e
0?ooo`00K03oool600000;40oooo1`00000>0?ooo`030000003oool0oooo07D0oooo001^0?ooo`L0
0000[03oool600000140oooo00<000000?ooo`3oool0M@3oool00780oooo1`00002U0?ooo`H00000
503oool00`000000oooo0?ooo`1e0?ooo`00M@3oool700000:00oooo1P00000F0?ooo`030000003o
ool0oooo07D0oooo001i0?ooo`H00000VP3oool6000001T0oooo00<000000?ooo`3oool0M@3oool0
07`0oooo1`00002B0?ooo`L00000703oool00`000000oooo0?ooo`1e0?ooo`00O`3oool7000008/0
oooo2000000O0?ooo`030000003oool0oooo07D0oooo00230?ooo`H00000PP3oool:000002<0oooo
00<000000?ooo`3oool0M@3oool008H0oooo2000001g0?ooo``000009`3oool00`000000oooo0?oo
o`1e0?ooo`00R@3oool900000700oooo2@00000]0?ooo`030000003oool0oooo07D0oooo002>0?oo
o`X00000IP3oool7000003<0oooo00<000000?ooo`3oool0M@3oool00980oooo3000001L0?ooo`P0
0000=P3oool00`000000oooo0?ooo`1e0?ooo`00V03oool<000004X0oooo4000000j0?ooo`030000
003oool0oooo07D0oooo002N0?ooo`l00000?03ooolA000003h0oooo00<000000?ooo`3oool0M@3o
ool00:@0oooo4P00000Y0?ooo`l00000BP3oool00`000000oooo0?ooo`1e0?ooo`00[@3oooll0000
04l0oooo00<000000?ooo`3oool0M@3oool00;H0oooo:P00001H0?ooo`030000003oool0oooo07D0
oooo003o0?ooocT0oooo00<000000?ooo`3oool0M@3oool00?l0oooo>@3oool00`000000oooo0?oo
o`1e0?ooo`00o`3oooli0?ooo`030000003oool0oooo07D0oooo003o0?ooocT0oooo00<000000?oo
o`3oool0M@3oool00?l0oooo>@3oool00`000000oooo0?ooo`1e0?ooo`00o`3ooona0?ooo`00o`3o
oona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3o
oona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3o
oona0?ooo`00o`3ooole0?ooo`030?oo_`1d000000000080000000<007Bo0?ooo`3oool0M03oool0
0?l0oooo>03oool00`3o_g@007Bo0?ooo`1f0?ooo`00o`3oooli0?ooo`0309a8B02Lgol0oooo07D0
oooo003o0?ooocP0oooo00<0oono07@00000M;l0MP3oool00?l0oooo>03oool0103OW4P007Bo0;md
001d_ome0?ooo`00o`3ooolh0?ooo`0409a8B02Lgol0omnL04Q8W7D0oooo003o0?ooocL0oooo00H0
okmd001d_`3oool0oooo0;md001d_omd0?ooo`00o`3ooolg0?ooo`0609a8B02Lgol0oooo0?ooo`3o
gi`0B4RLM03oool00?l0oooo=P3oool0202oM00000000000M02oool0oono07@00000000007BoL`3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {265.813, 0}} -> {-102.663, -50.4001, \
0.492102, 0.636985}}],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("The Schwarzschild orbit with the same parameters"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    InterpretationBox[\("After "\[InvisibleSpace]1\[InvisibleSpace]" \
revolutions"\),
      SequenceForm[ "After ", 1, " revolutions"],
      Editable->False]], "Print",
  CellLabel->"From In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.567361 0.0115423 0.699371 0.0108131 [
[1.025 .69937 0 -6.28125 ]
[1.025 .69937 10 6.28125 ]
[.56736 1.025 -5 0 ]
[.56736 1.025 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .69937 m
1 .69937 L
s
gsave
1.025 .69937 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.56736 0 m
.56736 1 L
s
gsave
.56736 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.006 w
.56736 .95889 m
.56951 .95888 L
.57146 .95886 L
.57372 .95883 L
.57585 .95879 L
.57965 .95869 L
.58376 .95854 L
.5883 .95833 L
.5931 .95805 L
.60171 .95739 L
.61059 .95651 L
.6189 .9555 L
.63778 .95255 L
.65694 .94858 L
.67438 .9441 L
.71317 .93098 L
.74622 .9161 L
.78132 .89606 L
.81607 .87115 L
.84606 .84466 L
.90085 .77903 L
.92396 .74056 L
.94525 .69417 L
.96119 .64503 L
.96729 .61855 L
.97008 .60311 L
.97228 .58815 L
.97388 .57425 L
.97456 .56681 L
.97516 .55883 L
.97556 .55207 L
.97573 .54846 L
.97589 .54455 L
.976 .54096 L
.97608 .53765 L
.97614 .53448 L
.97618 .53113 L
.97619 .52716 L
.97617 .52354 L
.97615 .52152 L
.97612 .51934 L
.97604 .51535 L
.97592 .51161 L
.97578 .50762 L
.97542 .50045 L
.97487 .49203 L
.97422 .4841 L
.97221 .46585 L
.96986 .44977 L
.96663 .43203 L
Mistroke
.95888 .39927 L
.94888 .36694 L
.93732 .33674 L
.90165 .26724 L
.85783 .20629 L
.80052 .14779 L
.76631 .12047 L
.72537 .09344 L
.68632 .07253 L
.64194 .05376 L
.61642 .04517 L
.59265 .03853 L
.5697 .03332 L
.54499 .029 L
.53415 .02751 L
.52243 .02619 L
.5157 .02556 L
.50952 .02507 L
.50323 .02465 L
.49737 .02434 L
.49238 .02413 L
.48705 .02396 L
.48113 .02385 L
.47575 .02381 L
.47012 .02383 L
.46403 .02394 L
.45828 .02411 L
.45298 .02432 L
.44718 .02463 L
.44096 .02504 L
.42975 .026 L
.41645 .02748 L
.40435 .02918 L
.37826 .03396 L
.35385 .03987 L
.30972 .05434 L
.26495 .0745 L
.22894 .09538 L
.19194 .12202 L
.12809 .18483 L
.0987 .2246 L
.07608 .26312 L
.05797 .30224 L
.04471 .3394 L
.03402 .38054 L
.02975 .40358 L
.02827 .41352 L
.02689 .42445 L
.0259 .43396 L
.02506 .44416 L
Mistroke
.02468 .44977 L
.0244 .45488 L
.02417 .46007 L
.02401 .46488 L
.0239 .46926 L
.02383 .47392 L
.02381 .47908 L
.02384 .48374 L
.0239 .48814 L
.02402 .49289 L
.02417 .49736 L
.02434 .50146 L
.0249 .51123 L
.02559 .52028 L
.02777 .5406 L
.03065 .56005 L
.03454 .58045 L
.0437 .61683 L
.05631 .6544 L
.08514 .71706 L
.1193 .77129 L
.16006 .82089 L
.24024 .89044 L
.28301 .91711 L
.32938 .93969 L
.3737 .95586 L
.39577 .96209 L
.41965 .96753 L
.44168 .97137 L
.46143 .97386 L
.47227 .97484 L
.47794 .97525 L
.48392 .97561 L
.48912 .97584 L
.49188 .97595 L
.49482 .97603 L
.49753 .9761 L
.49999 .97614 L
.50246 .97617 L
.50479 .97619 L
.5069 .97619 L
.50916 .97618 L
.5113 .97616 L
.51326 .97614 L
.51503 .9761 L
.51697 .97606 L
.52087 .97595 L
.52511 .97578 L
.52963 .97556 L
.53773 .97504 L
Mistroke
.54579 .97437 L
.55335 .9736 L
.56736 .9718 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00
iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool0
0`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000
oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?oo
o`370?ooo`00/`3ooolL0?l001L0oooo00<000000?ooo`3oool0a`3oool00:T0oooo;`3o000>0?oo
o`030000003oool0oooo0<L0oooo002O0?oooaD0o`006P3ooolD0?l000@0oooo00<000000?ooo`3o
ool0a`3oool009X0oooo3`3o000_0?ooo`l0o`00b@3oool009L0oooo203o00130?ooo`X0o`00a03o
ool009@0oooo1P3o001<0?ooo`030000003o0000o`0000L0o`00`03oool00900oooo1`3o001?0?oo
o`030000003oool0oooo00<0oooo203o002l0?ooo`00S@3oool70?l00580oooo00<000000?ooo`3o
ool01`3oool70?l00;T0oooo00290?ooo`L0o`00EP3oool00`000000oooo0?ooo`0:0?ooo`L0o`00
]P3oool008H0oooo1`3o001I0?ooo`030000003oool0oooo00d0oooo1`3o002c0?ooo`00PP3oool7
0?l005d0oooo00<000000?ooo`3oool0403oool80?l00:l0oooo001n0?ooo`P0o`00H03oool00`00
0000oooo0?ooo`0D0?ooo`L0o`00[03oool007`0oooo1P3o001T0?ooo`030000003oool0oooo01P0
oooo1P3o002Y0?ooo`00N@3oool60?l006L0oooo00<000000?ooo`3oool06`3oool50?l00:L0oooo
001g0?ooo`H0o`00J@3oool00`000000oooo0?ooo`0M0?ooo`D0o`00Y@3oool007D0oooo1@3o001/
0?ooo`030000003oool0oooo01l0oooo1@3o002S0?ooo`00L`3oool50?l006h0oooo00<000000?oo
o`3oool08@3oool60?l00:00oooo001`0?ooo`H0o`00L03oool00`000000oooo0?ooo`0S0?ooo`H0
o`00WP3oool006h0oooo1P3o001b0?ooo`030000003oool0oooo02H0oooo1@3o002L0?ooo`00K03o
ool50?l007D0oooo00<000000?ooo`3oool0:03oool50?l009X0oooo001Z0?ooo`D0o`00M`3oool0
0`000000oooo0?ooo`0Z0?ooo`D0o`00V03oool006T0oooo103o001i0?ooo`030000003oool0oooo
02`0oooo1@3o002F0?ooo`00I`3oool40?l007/0oooo00<000000?ooo`3oool0;P3oool50?l009@0
oooo001U0?ooo`D0o`00O03oool00`000000oooo0?ooo`0`0?ooo`D0o`00TP3oool006@0oooo103o
001n0?ooo`030000003oool0oooo0380oooo1@3o002@0?ooo`00HP3oool40?l00800oooo00<00000
0?ooo`3oool0=03oool50?l008h0oooo001P0?ooo`D0o`00P@3oool00`000000oooo0?ooo`0f0?oo
o`D0o`00S03oool005l0oooo103o00230?ooo`030000003oool0oooo03P0oooo1@3o002:0?ooo`00
G@3oool40?l008D0oooo00<000000?ooo`3oool0>P3oool50?l008P0oooo001L0?ooo`@0o`00QP3o
ool00`000000oooo0?ooo`0l0?ooo`@0o`00Q`3oool005X0oooo103o00280?ooo`030000003oool0
oooo03h0oooo103o00250?ooo`00F@3oool40?l008T0oooo00<000000?ooo`3oool0?`3oool40?l0
08@0oooo001H0?ooo`<0o`00R`3oool00`000000oooo0?ooo`110?ooo`@0o`00PP3oool005L0oooo
0`3o002<0?ooo`030000003oool0oooo0480oooo103o00210?ooo`00E@3oool40?l008d0oooo00<0
00000?ooo`3oool0A03oool40?l007l0oooo001D0?ooo`@0o`00SP3oool00`000000oooo0?ooo`15
0?ooo`@0o`00OP3oool005<0oooo0`3o002@0?ooo`030000003oool0oooo04L0oooo103o001l0?oo
o`00DP3oool30?l00940oooo00<000000?ooo`3oool0B03oool40?l007/0oooo001@0?ooo`@0o`00
TP3oool00`000000oooo0?ooo`1:0?ooo`@0o`00N@3oool004l0oooo103o002C0?ooo`030000003o
ool0oooo04/0oooo103o001h0?ooo`00CP3oool30?l009D0oooo00<000000?ooo`3oool0C@3oool3
0?l007L0oooo001=0?ooo`<0o`00UP3oool00`000000oooo0?ooo`1>0?ooo`@0o`00M@3oool004`0
oooo0`3o002G0?ooo`030000003oool0oooo04l0oooo103o001d0?ooo`00B`3oool30?l009P0oooo
00<000000?ooo`3oool0D@3oool30?l007<0oooo001:0?ooo`<0o`00V@3oool00`000000oooo0?oo
o`1B0?ooo`<0o`00LP3oool004T0oooo0`3o002J0?ooo`030000003oool0oooo05<0oooo0`3o001a
0?ooo`00B03oool30?l009/0oooo00<000000?ooo`3oool0E03oool30?l00700oooo00170?ooo`<0
o`00W03oool00`000000oooo0?ooo`1E0?ooo`@0o`00KP3oool004H0oooo0`3o002M0?ooo`030000
003oool0oooo05H0oooo103o001]0?ooo`00A@3oool30?l009h0oooo00<000000?ooo`3oool0F03o
ool30?l006`0oooo00140?ooo`<0o`00W`3oool00`000000oooo0?ooo`1I0?ooo`<0o`00J`3oool0
04<0oooo0`3o002P0?ooo`030000003oool0oooo05X0oooo0`3o001Z0?ooo`00@@3oool40?l00:40
oooo00<000000?ooo`3oool0F`3oool30?l006T0oooo00100?ooo`@0o`00XP3oool00`000000oooo
0?ooo`1L0?ooo`<0o`00J03oool003l0oooo0`3o002T0?ooo`030000003oool0oooo05d0oooo0`3o
001W0?ooo`00?P3oool30?l00:D0oooo00<000000?ooo`3oool0GP3oool30?l006H0oooo000m0?oo
o`<0o`00YP3oool00`000000oooo0?ooo`1O0?ooo`<0o`00I@3oool003`0oooo0`3o002W0?ooo`03
0000003oool0oooo0600oooo0`3o001T0?ooo`00>`3oool30?l00:P0oooo00<000000?ooo`3oool0
H@3oool30?l006<0oooo000j0?ooo`<0o`00Z@3oool00`000000oooo0?ooo`1R0?ooo`<0o`00HP3o
ool003T0oooo0`3o002Z0?ooo`030000003oool0oooo06<0oooo0`3o001Q0?ooo`00>03oool30?l0
0:/0oooo00<000000?ooo`3oool0I03oool30?l00600oooo000g0?ooo`<0o`00[03oool00`000000
oooo0?ooo`1U0?ooo`<0o`00G`3oool003H0oooo0`3o002]0?ooo`030000003oool0oooo06H0oooo
0`3o001N0?ooo`00=@3oool30?l00:h0oooo00<000000?ooo`3oool0I`3oool30?l005d0oooo000e
0?ooo`80o`00[`3oool00`000000oooo0?ooo`1X0?ooo`<0o`00G03oool003@0oooo0P3o002`0?oo
o`030000003oool0oooo06T0oooo0`3o001K0?ooo`00<`3oool20?l00;40oooo00<000000?ooo`3o
ool0JP3oool30?l005X0oooo000b0?ooo`80o`00/P3oool00`000000oooo0?ooo`1[0?ooo`<0o`00
F@3oool00380oooo00<0o`000?ooo`3oool0/@3oool00`000000oooo0?ooo`1/0?ooo`<0o`00F03o
ool00340oooo0P3o002c0?ooo`030000003oool0oooo06d0oooo0`3o001G0?ooo`00<03oool20?l0
0;@0oooo00<000000?ooo`3oool0KP3oool30?l005H0oooo000_0?ooo`80o`00]@3oool00`000000
oooo0?ooo`1_0?ooo`<0o`00E@3oool002l0oooo00<0o`000?ooo`3oool0]03oool00`000000oooo
0?ooo`1`0?ooo`80o`00E@3oool002h0oooo0P3o002f0?ooo`030000003oool0oooo0740oooo0P3o
001D0?ooo`00;@3oool20?l00;L0oooo00<000000?ooo`3oool0LP3oool20?l005<0oooo000/0?oo
o`80o`00^03oool00`000000oooo0?ooo`1c0?ooo`80o`00DP3oool002`0oooo00<0o`000?ooo`3o
ool0]`3oool00`000000oooo0?ooo`1d0?ooo`030?l0003oool0oooo0500oooo000[0?ooo`80o`00
^@3oool00`000000oooo0?ooo`1d0?ooo`80o`00D@3oool002X0oooo0P3o002j0?ooo`030000003o
ool0oooo07D0oooo0P3o001@0?ooo`00:@3oool20?l00;/0oooo00<000000?ooo`3oool0MP3oool0
0`3o0000oooo0?ooo`1>0?ooo`00:@3oool00`3o0000oooo0?ooo`2j0?ooo`030000003oool0oooo
07H0oooo0P3o001?0?ooo`00:03oool20?l00;`0oooo00<000000?ooo`3oool0M`3oool20?l004h0
oooo000W0?ooo`80o`00_@3oool00`000000oooo0?ooo`1h0?ooo`80o`00C@3oool002L0oooo00<0
o`000?ooo`3oool0_03oool00`000000oooo0?ooo`1i0?ooo`030?l0003oool0oooo04/0oooo000V
0?ooo`80o`00_P3oool00`000000oooo0?ooo`1i0?ooo`80o`00C03oool002H0oooo00<0o`000?oo
o`3oool0_@3oool00`000000oooo0?ooo`1j0?ooo`80o`00B`3oool002D0oooo0P3o002o0?ooo`03
0000003oool0oooo07/0oooo00<0o`000?ooo`3oool0B@3oool002@0oooo0P3o00300?ooo`030000
003oool0oooo07/0oooo0P3o001:0?ooo`00903oool00`3o0000oooo0?ooo`2o0?ooo`030000003o
ool0oooo07`0oooo0P3o00190?ooo`008`3oool20?l00<40oooo00<000000?ooo`3oool0O@3oool2
0?l004P0oooo000S0?ooo`030?l0003oool0oooo0<00oooo00<000000?ooo`3oool0OP3oool00`3o
0000oooo0?ooo`160?ooo`008P3oool20?l00<80oooo00<000000?ooo`3oool0OP3oool20?l004L0
oooo000Q0?ooo`80o`00``3oool00`000000oooo0?ooo`1o0?ooo`80o`00AP3oool00240oooo00<0
o`000?ooo`3oool0`P3oool00`000000oooo0?ooo`200?ooo`030?l0003oool0oooo04@0oooo000P
0?ooo`80o`00a03oool00`000000oooo0?ooo`200?ooo`80o`00A@3oool00200oooo00<0o`000?oo
o`3oool0``3oool00`000000oooo0?ooo`210?ooo`80o`00A03oool001l0oooo0P3o00350?ooo`03
0000003oool0oooo0880oooo0P3o00130?ooo`007`3oool00`3o0000oooo0?ooo`340?ooo`030000
003oool0oooo08<0oooo00<0o`000?ooo`3oool0@@3oool001h0oooo0P3o00360?ooo`030000003o
ool0oooo08<0oooo0P3o00120?ooo`007P3oool00`3o0000oooo0?ooo`350?ooo`030000003oool0
oooo08@0oooo00<0o`000?ooo`3oool0@03oool001h0oooo00<0o`000?ooo`3oool0a@3oool00`00
0000oooo0?ooo`240?ooo`80o`00@@3oool001d0oooo0P3o00370?ooo`030000003oool0oooo08D0
oooo00<0o`000?ooo`3oool0?`3oool001d0oooo00<0o`000?ooo`3oool0aP3oool00`000000oooo
0?ooo`250?ooo`80o`00@03oool001`0oooo0P3o00380?ooo`030000003oool0oooo08H0oooo00<0
o`000?ooo`3oool0?P3oool001`0oooo00<0o`000?ooo`3oool0a`3oool00`000000oooo0?ooo`26
0?ooo`80o`00?`3oool001/0oooo0P3o00390?ooo`030000003oool0oooo08L0oooo00<0o`000?oo
o`3oool0?@3oool001/0oooo00<0o`000?ooo`3oool0b03oool00`000000oooo0?ooo`270?ooo`80
o`00?P3oool001/0oooo00<0o`000?ooo`3oool0b03oool00`000000oooo0?ooo`280?ooo`030?l0
003oool0oooo03`0oooo000J0?ooo`80o`00bP3oool00`000000oooo0?ooo`280?ooo`80o`00?@3o
ool001X0oooo00<0o`000?ooo`3oool0b@3oool00`000000oooo0?ooo`290?ooo`030?l0003oool0
oooo03/0oooo000I0?ooo`80o`00b`3oool00`000000oooo0?ooo`290?ooo`80o`00?03oool001P0
oooo0P3o003<0?ooo`030000003oool0oooo08X0oooo00<0o`000?ooo`3oool0>P3oool001P0oooo
0P3o003<0?ooo`030000003oool0oooo08X0oooo0P3o000k0?ooo`005`3oool30?l00<`0oooo00<0
00000?ooo`3oool0R`3oool00`3o0000oooo0?ooo`0i0?ooo`005`3oool20?l00<d0oooo00<00000
0?ooo`3oool0R`3oool20?l003X0oooo000G0?ooo`80o`00c@3oool00`000000oooo0?ooo`2<0?oo
o`030?l0003oool0oooo03P0oooo000F0?ooo`<0o`00c@3oool00`000000oooo0?ooo`2<0?ooo`80
o`00>@3oool001H0oooo0P3o003>0?ooo`030000003oool0oooo08d0oooo00<0o`000?ooo`3oool0
=`3oool001D0oooo0`3o003>0?ooo`030000003oool0oooo08d0oooo0P3o000h0?ooo`005@3oool2
0?l00<l0oooo00<000000?ooo`3oool0SP3oool00`3o0000oooo0?ooo`0f0?ooo`005@3oool20?l0
0<l0oooo00<000000?ooo`3oool0SP3oool20?l003L0oooo000D0?ooo`<0o`00c`3oool00`000000
oooo0?ooo`2?0?ooo`030?l0003oool0oooo03D0oooo000D0?ooo`80o`00d03oool00`000000oooo
0?ooo`2?0?ooo`80o`00=P3oool001<0oooo0`3o003@0?ooo`030000003oool0oooo0900oooo00<0
o`000?ooo`3oool0=03oool001<0oooo0P3o003A0?ooo`030000003oool0oooo0900oooo0P3o000e
0?ooo`004`3oool20?l00=40oooo00<000000?ooo`3oool0T@3oool00`3o0000oooo0?ooo`0c0?oo
o`004P3oool30?l00=40oooo00<000000?ooo`3oool0T@3oool20?l003@0oooo000B0?ooo`80o`00
dP3oool00`000000oooo0?ooo`2A0?ooo`80o`00=03oool00180oooo0P3o003B0?ooo`030000003o
ool0oooo0980oooo0P3o000c0?ooo`004P3oool20?l00=80oooo00<000000?ooo`3oool0TP3oool2
0?l003<0oooo000A0?ooo`<0o`00dP3oool00`000000oooo0?ooo`2B0?ooo`<0o`00<P3oool00140
oooo0P3o003C0?ooo`030000003oool0oooo09<0oooo0P3o000b0?ooo`004@3oool20?l00=<0oooo
00<000000?ooo`3oool0T`3oool30?l00340oooo000A0?ooo`80o`00d`3oool00`000000oooo0?oo
o`2D0?ooo`80o`00<@3oool00100oooo0`3o003C0?ooo`030000003oool0oooo09@0oooo0P3o000a
0?ooo`00403oool20?l00=@0oooo00<000000?ooo`3oool0U03oool30?l00300oooo000@0?ooo`80
o`00e03oool00`000000oooo0?ooo`2E0?ooo`80o`00<03oool00100oooo0P3o003D0?ooo`030000
003oool0oooo09D0oooo0`3o000_0?ooo`00403oool20?l00=@0oooo00<000000?ooo`3oool0UP3o
ool20?l002l0oooo000?0?ooo`<0o`00e03oool00`000000oooo0?ooo`2F0?ooo`80o`00;`3oool0
00l0oooo0P3o003E0?ooo`030000003oool0oooo09H0oooo0`3o000^0?ooo`003`3oool20?l00=D0
oooo00<000000?ooo`3oool0U`3oool20?l002h0oooo000?0?ooo`80o`00e@3oool00`000000oooo
0?ooo`2G0?ooo`80o`00;P3oool000h0oooo0`3o003E0?ooo`030000003oool0oooo09L0oooo0P3o
000^0?ooo`003P3oool20?l00=H0oooo00<000000?ooo`3oool0U`3oool30?l002d0oooo000>0?oo
o`80o`00eP3oool00`000000oooo0?ooo`2H0?ooo`80o`00;@3oool000h0oooo0P3o003F0?ooo`03
0000003oool0oooo09P0oooo0P3o000]0?ooo`003@3oool30?l00=H0oooo00<000000?ooo`3oool0
V03oool30?l002`0oooo000=0?ooo`80o`00e`3oool00`000000oooo0?ooo`2I0?ooo`80o`00;03o
ool000d0oooo0P3o003G0?ooo`030000003oool0oooo09T0oooo0P3o000/0?ooo`003@3oool20?l0
0=L0oooo00<000000?ooo`3oool0V@3oool30?l002/0oooo000=0?ooo`80o`00e`3oool00`000000
oooo0?ooo`2J0?ooo`80o`00:`3oool000`0oooo0`3o003G0?ooo`030000003oool0oooo09X0oooo
0P3o000[0?ooo`00303oool20?l00=P0oooo00<000000?ooo`3oool0VP3oool20?l002/0oooo000<
0?ooo`80o`00f03oool00`000000oooo0?ooo`2J0?ooo`<0o`00:P3oool000`0oooo0P3o003H0?oo
o`030000003oool0oooo09/0oooo0P3o000Z0?ooo`00303oool20?l00=P0oooo00<000000?ooo`3o
ool0V`3oool20?l002X0oooo000<0?ooo`80o`00f03oool00`000000oooo0?ooo`2K0?ooo`80o`00
:P3oool000`0oooo0P3o003H0?ooo`030000003oool0oooo09/0oooo0P3o000Z0?ooo`00303oool2
0?l00=P0oooo00<000000?ooo`3oool0V`3oool30?l002T0oooo000;0?ooo`<0o`00f03oool00`00
0000oooo0?ooo`2L0?ooo`80o`00:@3oool000/0oooo0P3o003I0?ooo`030000003oool0oooo09`0
oooo0P3o000Y0?ooo`002`3oool20?l00=T0oooo00<000000?ooo`3oool0W03oool20?l002T0oooo
000;0?ooo`80o`00f@3oool00`000000oooo0?ooo`2L0?ooo`<0o`00:03oool000/0oooo0P3o003I
0?ooo`030000003oool0oooo09d0oooo0P3o000X0?ooo`002`3oool20?l00=T0oooo00<000000?oo
o`3oool0W@3oool20?l002P0oooo000;0?ooo`80o`00f@3oool00`000000oooo0?ooo`2M0?ooo`80
o`00:03oool000/0oooo0P3o003I0?ooo`030000003oool0oooo09d0oooo0P3o000X0?ooo`002`3o
ool20?l00=T0oooo00<000000?ooo`3oool0W@3oool20?l002P0oooo000;0?ooo`80o`00f@3oool0
0`000000oooo0?ooo`2M0?ooo`80o`00:03oool000/0oooo00<0o`000?ooo`3oool0f03oool00`00
0000oooo0?ooo`2M0?ooo`80o`00:03oool000X0oooo0P3o003J0?ooo`030000003oool0oooo09h0
oooo0P3o000W0?ooo`002P3oool20?l00=X0oooo00<000000?ooo`3oool0WP3oool20?l002L0oooo
000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2N0?ooo`80o`009`3oool000X0oooo0P3o003J
0?ooo`030000003oool0oooo09h0oooo0P3o000W0?ooo`002P3oool20?l00=X0oooo00<000000?oo
o`3oool0WP3oool20?l002L0oooo000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2N0?ooo`80
o`009`3oool000X0oooo0P3o003J0?ooo`030000003oool0oooo09h0oooo0P3o000W0?ooo`002P3o
ool20?l00=X0oooo00<000000?ooo`3oool0W`3oool20?l002H0oooo000:0?ooo`80o`00fP3oool0
0`000000oooo0?ooo`2O0?ooo`80o`009P3oool000X0oooo0P3o003J0?ooo`030000003oool0oooo
09l0oooo0P3o000V0?ooo`002P3oool20?l00=X0oooo00<000000?ooo`3oool0W`3oool20?l002H0
oooo000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2O0?ooo`80o`009P3oool000X0oooo0P3o
003J0?ooo`030000003oool0oooo09l0oooo0P3o000V0?ooo`002P3oool20?l00=X0oooo00<00000
0?ooo`3oool0W`3oool20?l002H0oooo000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2O0?oo
o`80o`009P3oool000X0oooo0P3o003J0?ooo`030000003oool0oooo09l0oooo0P3o000V0?ooo`00
2P3oool20?l00=X0oooo00<000000?ooo`3oool0W`3oool30?l002D0oooo000:0?ooo`80o`00fP3o
ool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000X0oooo0P3o003J0?ooo`030000003oool0
oooo0:00oooo0P3o000U0?ooo`002P3oool20?l00=X0oooo00<000000?ooo`3oool0X03oool20?l0
02D0oooo000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000X0oooo
0P3o003J0?ooo`030000003oool0oooo0:00oooo0P3o000U0?ooo`002P3oool20?l00=X0oooo00<0
00000?ooo`3oool0X03oool20?l002D0oooo000:0?ooo`80o`00fP3oool00`000000oooo0?ooo`2P
0?ooo`80o`009@3oool000X0oooo0`3o003I0?ooo`030000003oool0oooo0:00oooo0P3o000U0?oo
o`002`3oool20?l00=T0oooo00<000000?ooo`3oool0X03oool20?l002D0oooo000;0?ooo`80o`00
f@3oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000/0oooo0P3o003I0?ooo`030000003o
ool0oooo0:00oooo0P3o000U0?ooo`002`3oool20?l00=T0oooo00<000000?ooo`3oool0X03oool2
0?l002D0oooo000<0?ooo`80o`00f03oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000`0
oooo0P3o003H0?ooo`030000003oool0oooo0:00oooo0P3o000U0?ooo`00303oool20?l00=P0oooo
00<000000?ooo`3oool0X03oool20?l002D0oooo000<0?ooo`80o`00f03oool00`000000oooo0?oo
o`2P0?ooo`80o`009@3oool000`0oooo0P3o003H0?ooo`030000003oool0oooo0:00oooo0P3o000U
0?ooo`00303oool20?l00=P0oooo00<000000?ooo`3oool0X03oool20?l002D0oooo000<0?ooo`80
o`00f03oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000`0oooo0P3o003H0?ooo`030000
003oool0oooo0:00oooo0P3o000U0?ooo`003@3oool20?l00=L0oooo00<000000?ooo`3oool0X03o
ool20?l002D0oooo000=0?ooo`80o`00e`3oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool0
00d0oooo0P3o003G0?ooo`030000003oool0oooo0:00oooo0P3o000U0?ooo`003@3oool20?l00=L0
oooo00<000000?ooo`3oool0X03oool20?l002D0oooo000=0?ooo`80o`00e`3oool00`000000oooo
0?ooo`2P0?ooo`80o`009@3oool000d0oooo0P3o003G0?ooo`030000003oool0oooo0:00oooo0P3o
000U0?ooo`003@3oool20?l00=L0oooo00<000000?ooo`3oool0X03oool20?l002D0oooo000=0?oo
o`80o`00e`3oool00`000000oooo0?ooo`2P0?ooo`80o`009@3oool000h0oooo0P3o003F0?ooo`03
0000003oool0oooo0:00oooo0P3o000U0?ooo`003P3oool20?l00=H0oooo00<000000?ooo`3oool0
W`3oool30?l002D0oooo000>0?ooo`80o`00eP3oool00`000000oooo0?ooo`2O0?ooo`80o`009P3o
ool000h0oooo0P3o003F0?ooo`030000003oool0oooo09l0oooo0P3o000V0?ooo`003P3oool20?l0
0=H0oooo00<000000?ooo`3oool0W`3oool20?l002H0oooo000>0?ooo`80o`00eP3oool00`000000
oooo0?ooo`2O0?ooo`80o`009P3oool000h0oooo0P3o003F0?ooo`030000003oool0oooo09l0oooo
0P3o000V0?ooo`003P3oool30?l00=D0oooo00<000000?ooo`3oool0W`3oool20?l002H0oooo000?
0?ooo`80o`00e@3oool00`000000oooo0?ooo`2O0?ooo`80o`009P3oool000l0oooo0P3o003E0?oo
o`030000003oool0oooo09l0oooo0P3o000V0?ooo`003`3oool20?l00=D0oooo00<000000?ooo`3o
ool0WP3oool20?l002L0oooo000?0?ooo`<0o`00e03oool00`000000oooo0?ooo`2N0?ooo`80o`00
9`3oool00100oooo0P3o003D0?ooo`030000003oool0oooo09h0oooo0P3o000W0?ooo`00403oool2
0?l00=@0oooo00<000000?ooo`3oool0WP3oool20?l002L0oooo000@0?ooo`80o`00e03oool00`00
0000oooo0?ooo`2N0?ooo`80o`009`3oool00100oooo0`3o003C0?ooo`030000003oool0oooo09h0
oooo0P3o000W0?ooo`004@3oool20?l00=<0oooo00<000000?ooo`3oool0W@3oool20?l002P0oooo
000A0?ooo`80o`00d`3oool00`000000oooo0?ooo`2M0?ooo`80o`00:03oool00140oooo0`3o003B
0?ooo`030000003oool0oooo09d0oooo0P3o000X0?ooo`004P3oool20?l00=80oooo00<000000?oo
o`3oool0W@3oool20?l002P0oooo000B0?ooo`80o`00dP3oool00`000000oooo0?ooo`2M0?ooo`80
o`00:03oool00180oooo0P3o003B0?ooo`030000003oool0oooo09d0oooo0P3o000X0?ooo`004P3o
ool30?l00=40oooo00<000000?ooo`3oool0W03oool20?l002T0oooo000C0?ooo`80o`00d@3oool0
0`000000oooo0?ooo`2L0?ooo`80o`00:@3oool001<0oooo0P3o003A0?ooo`030000003oool0oooo
09`0oooo0P3o000Y0?ooo`004`3oool30?l00=00oooo00<000000?ooo`3oool0W03oool20?l002T0
oooo000D0?ooo`80o`00d03oool00`000000oooo0?ooo`2L0?ooo`80o`00:@3oool001@0oooo0P3o
003@0?ooo`030000003oool0oooo09`0oooo0P3o000Y0?ooo`00503oool30?l00<l0oooo00<00000
0?ooo`3oool0V`3oool20?l002X0oooo000E0?ooo`80o`00c`3oool00`000000oooo0?ooo`2K0?oo
o`80o`00:P3oool001D0oooo0P3o003?0?ooo`030000003oool0oooo09/0oooo0P3o000Z0?ooo`00
5@3oool30?l00<h0oooo00<000000?ooo`3oool0V`3oool20?l002X0oooo000F0?ooo`80o`00cP3o
ool00`000000oooo0?ooo`2K0?ooo`80o`00:P3oool001H0oooo0P3o003>0?ooo`030000003oool0
oooo09X0oooo0P3o000[0?ooo`005P3oool30?l00<d0oooo00<000000?ooo`3oool0VP3oool20?l0
02/0oooo000G0?ooo`80o`00c@3oool00`000000oooo0?ooo`2J0?ooo`80o`00:`3oool001L0oooo
0P3o003=0?ooo`030000003oool0oooo09T0oooo0`3o000[0?ooo`00603oool00`3o0000oooo0?oo
o`3;0?ooo`030000003oool0oooo09T0oooo0P3o000/0?ooo`00603oool20?l00<`0oooo00<00000
0?ooo`3oool0V@3oool20?l002`0oooo000I0?ooo`030?l0003oool0oooo0<X0oooo00<000000?oo
o`3oool0V@3oool20?l002`0oooo000I0?ooo`80o`00b`3oool00`000000oooo0?ooo`2H0?ooo`<0
o`00;03oool001X0oooo00<0o`000?ooo`3oool0b@3oool00`000000oooo0?ooo`2H0?ooo`80o`00
;@3oool001X0oooo0P3o003:0?ooo`030000003oool0oooo09P0oooo0P3o000]0?ooo`006`3oool0
0`3o0000oooo0?ooo`380?ooo`030000003oool0oooo09L0oooo0`3o000]0?ooo`006`3oool20?l0
0<T0oooo00<000000?ooo`3oool0U`3oool20?l002h0oooo000L0?ooo`030?l0003oool0oooo0<L0
oooo00<000000?ooo`3oool0U`3oool20?l002h0oooo000L0?ooo`80o`00b03oool00`000000oooo
0?ooo`2F0?ooo`<0o`00;P3oool001d0oooo00<0o`000?ooo`3oool0aP3oool00`000000oooo0?oo
o`2F0?ooo`80o`00;`3oool001d0oooo0P3o00370?ooo`030000003oool0oooo09H0oooo0P3o000_
0?ooo`007P3oool00`3o0000oooo0?ooo`350?ooo`030000003oool0oooo09H0oooo0P3o000_0?oo
o`007P3oool00`3o0000oooo0?ooo`350?ooo`030000003oool0oooo09D0oooo0`3o000_0?ooo`00
7P3oool20?l00<H0oooo00<000000?ooo`3oool0U@3oool20?l00300oooo000O0?ooo`030?l0003o
ool0oooo0<@0oooo00<000000?ooo`3oool0U@3oool20?l00240oooo00H0gia800000000000007Bo
0?ooo`2oM0020000000304RLg`3oool0oooo00@0oooo000O0?ooo`80o`00a@3oool00`000000oooo
0?ooo`2E0?ooo`030?l0003oool0oooo0240oooo00L0okmd0000001d_ol0oooo0?noM0000000M;oo
00L0oooo000P0?ooo`030?l0003oool0oooo0<<0oooo00<000000?ooo`3oool0U03oool20?l002@0
oooo00D0oono07@0B018M4P0B01d0;ooo`080?ooo`0000<0oooo0000000000007@0000020?l00?l0
0000G00000000`3o000000000000000E000000l0oooo00<0W4P004Q8B000B9`02@3oool00240oooo
00<0o`000?ooo`3oool0`P3oool00`000000oooo0?ooo`2C0?ooo`80o`00903oool01`3ookl0M000
04RLg`3oool0gia80000M02oool01`3oool00240oooo0P3o00330?ooo`030000003oool0oooo09<0
oooo00<0o`000?ooo`3oool08P3oool02@3ogi`0B00000000000M;l0oooo0;md00000000001809cO
o`060?ooo`008P3oool00`3o0000oooo0?ooo`310?ooo`030000003oool0oooo0980oooo0P3o000c
0?ooo`008P3oool20?l00<80oooo00<000000?ooo`3oool0TP3oool00`3o0000oooo0?ooo`0b0?oo
o`008`3oool00`3o0000oooo0?ooo`300?ooo`030000003oool0oooo0940oooo0P3o000d0?ooo`00
8`3oool20?l00<40oooo00<000000?ooo`3oool0T@3oool00`3o0000oooo0?ooo`0c0?ooo`00903o
ool00`3o0000oooo0?ooo`2o0?ooo`030000003oool0oooo0900oooo0P3o000e0?ooo`00903oool2
0?l00<00oooo00<000000?ooo`3oool0T03oool00`3o0000oooo0?ooo`0d0?ooo`009@3oool00`3o
0000oooo0?ooo`2n0?ooo`030000003oool0oooo08l0oooo0P3o000f0?ooo`009@3oool20?l00;l0
oooo00<000000?ooo`3oool0S`3oool00`3o0000oooo0?ooo`0e0?ooo`009P3oool20?l00;h0oooo
00<000000?ooo`3oool0SP3oool20?l003L0oooo000W0?ooo`030?l0003oool0oooo0;`0oooo00<0
00000?ooo`3oool0SP3oool00`3o0000oooo0?ooo`0f0?ooo`009`3oool20?l00;d0oooo00<00000
0?ooo`3oool0S@3oool20?l003P0oooo000X0?ooo`030?l0003oool0oooo0;/0oooo00<000000?oo
o`3oool0S@3oool00`3o0000oooo0?ooo`0g0?ooo`00:03oool20?l00;`0oooo00<000000?ooo`3o
ool0S03oool20?l003T0oooo000Y0?ooo`80o`00^`3oool00`000000oooo0?ooo`2<0?ooo`030?l0
003oool0oooo03P0oooo000Z0?ooo`030?l0003oool0oooo0;T0oooo00<000000?ooo`3oool0R`3o
ool20?l003X0oooo000Z0?ooo`80o`00^P3oool00`000000oooo0?ooo`2;0?ooo`030?l0003oool0
oooo03T0oooo000[0?ooo`030?l0003oool0oooo0;P0oooo00<000000?ooo`3oool0RP3oool20?l0
03/0oooo000[0?ooo`80o`00^@3oool00`000000oooo0?ooo`290?ooo`80o`00?03oool002`0oooo
0P3o002h0?ooo`030000003oool0oooo08T0oooo00<0o`000?ooo`3oool0>`3oool002d0oooo00<0
o`000?ooo`3oool0]P3oool00`000000oooo0?ooo`280?ooo`80o`00?@3oool002d0oooo0P3o002g
0?ooo`030000003oool0oooo08P0oooo00<0o`000?ooo`3oool0?03oool002h0oooo00<0o`000?oo
o`3oool0]@3oool00`000000oooo0?ooo`270?ooo`80o`00?P3oool002h0oooo0P3o002f0?ooo`03
0000003oool0oooo08L0oooo00<0o`000?ooo`3oool0?@3oool002l0oooo0P3o002e0?ooo`030000
003oool0oooo08H0oooo0P3o000o0?ooo`00<03oool00`3o0000oooo0?ooo`2c0?ooo`030000003o
ool0oooo08H0oooo00<0o`000?ooo`3oool0?P3oool00300oooo0P3o002d0?ooo`030000003oool0
oooo08D0oooo0P3o00100?ooo`00<@3oool20?l00;<0oooo00<000000?ooo`3oool0Q03oool20?l0
0440oooo000a0?ooo`<0o`00/P3oool00`000000oooo0?ooo`240?ooo`030?l0003oool0oooo0400
oooo000b0?ooo`<0o`00/@3oool00`000000oooo0?ooo`230?ooo`80o`00@P3oool003<0oooo0P3o
002a0?ooo`030000003oool0oooo0880oooo0P3o00130?ooo`00=03oool20?l00;00oooo00<00000
0?ooo`3oool0P@3oool30?l004<0oooo000d0?ooo`<0o`00[`3oool00`000000oooo0?ooo`200?oo
o`<0o`00A03oool003D0oooo0`3o002^0?ooo`030000003oool0oooo0800oooo0P3o00150?ooo`00
=P3oool30?l00:d0oooo00<000000?ooo`3oool0O`3oool20?l004H0oooo000g0?ooo`<0o`00[03o
ool00`000000oooo0?ooo`1n0?ooo`<0o`00AP3oool003P0oooo0P3o002/0?ooo`030000003oool0
oooo07d0oooo0`3o00170?ooo`00>@3oool20?l00:/0oooo00<000000?ooo`3oool0O03oool30?l0
04P0oooo000i0?ooo`<0o`00ZP3oool00`000000oooo0?ooo`1k0?ooo`<0o`00B@3oool003X0oooo
0`3o002Y0?ooo`030000003oool0oooo07/0oooo0P3o001:0?ooo`00>`3oool30?l00:P0oooo00<0
00000?ooo`3oool0NP3oool20?l004/0oooo000l0?ooo`<0o`00Y`3oool00`000000oooo0?ooo`1i
0?ooo`<0o`00B`3oool003d0oooo0`3o002V0?ooo`030000003oool0oooo07P0oooo0`3o001<0?oo
o`00?P3oool20?l00:H0oooo00<000000?ooo`3oool0M`3oool30?l004d0oooo000o0?ooo`80o`00
Y@3oool00`000000oooo0?ooo`1f0?ooo`<0o`00CP3oool003l0oooo0`3o002T0?ooo`030000003o
ool0oooo07D0oooo0`3o001?0?ooo`00@03oool30?l00:<0oooo00<000000?ooo`3oool0M@3oool2
0?l00500oooo00110?ooo`<0o`00XP3oool00`000000oooo0?ooo`1d0?ooo`80o`00D@3oool00480
oooo0`3o002Q0?ooo`030000003oool0oooo07<0oooo0`3o001A0?ooo`00@`3oool30?l00:00oooo
00<000000?ooo`3oool0LP3oool30?l00580oooo00140?ooo`@0o`00WP3oool00`000000oooo0?oo
o`1a0?ooo`<0o`00D`3oool004D0oooo103o002M0?ooo`030000003oool0oooo0700oooo0`3o001D
0?ooo`00A`3oool30?l009`0oooo00<000000?ooo`3oool0L03oool20?l005D0oooo00180?ooo`<0
o`00V`3oool00`000000oooo0?ooo`1_0?ooo`80o`00EP3oool004T0oooo0`3o002J0?ooo`030000
003oool0oooo06h0oooo0`3o001F0?ooo`00BP3oool30?l009T0oooo00<000000?ooo`3oool0K@3o
ool30?l005L0oooo001;0?ooo`<0o`00V03oool00`000000oooo0?ooo`1/0?ooo`<0o`00F03oool0
04`0oooo103o002F0?ooo`030000003oool0oooo06/0oooo0`3o001I0?ooo`00C@3oool40?l009D0
oooo00<000000?ooo`3oool0JP3oool30?l005X0oooo001?0?ooo`<0o`00U03oool00`000000oooo
0?ooo`1Y0?ooo`<0o`00F`3oool00500oooo0`3o002C0?ooo`030000003oool0oooo06P0oooo0`3o
001L0?ooo`00D@3oool30?l00980oooo00<000000?ooo`3oool0IP3oool40?l005d0oooo001B0?oo
o`<0o`00T@3oool00`000000oooo0?ooo`1U0?ooo`@0o`00GP3oool005<0oooo0`3o002@0?ooo`03
0000003oool0oooo06@0oooo0`3o001P0?ooo`00E03oool40?l008h0oooo00<000000?ooo`3oool0
H`3oool30?l00640oooo001E0?ooo`@0o`00S@3oool00`000000oooo0?ooo`1R0?ooo`<0o`00HP3o
ool005L0oooo0`3o002<0?ooo`030000003oool0oooo0640oooo0`3o001S0?ooo`00F03oool30?l0
08/0oooo00<000000?ooo`3oool0H03oool30?l006@0oooo001I0?ooo`<0o`00RP3oool00`000000
oooo0?ooo`1N0?ooo`@0o`00I@3oool005X0oooo0`3o00290?ooo`030000003oool0oooo05d0oooo
103o001V0?ooo`00F`3oool30?l008P0oooo00<000000?ooo`3oool0F`3oool40?l006P0oooo001L
0?ooo`@0o`00QP3oool00`000000oooo0?ooo`1J0?ooo`@0o`00J@3oool005d0oooo103o00250?oo
o`030000003oool0oooo05T0oooo0`3o001[0?ooo`00G`3oool30?l008@0oooo00<000000?ooo`3o
ool0E`3oool40?l006`0oooo001P0?ooo`<0o`00P`3oool00`000000oooo0?ooo`1F0?ooo`@0o`00
K@3oool00640oooo103o00210?ooo`030000003oool0oooo05@0oooo103o001_0?ooo`00HP3oool4
0?l00800oooo00<000000?ooo`3oool0D`3oool40?l00700oooo001T0?ooo`@0o`00OP3oool00`00
0000oooo0?ooo`1A0?ooo`@0o`00LP3oool006D0oooo1@3o001l0?ooo`030000003oool0oooo04l0
oooo1@3o001c0?ooo`00I`3oool40?l007/0oooo00<000000?ooo`3oool0C@3oool50?l007D0oooo
001Y0?ooo`@0o`00N@3oool00`000000oooo0?ooo`1;0?ooo`D0o`00M`3oool006X0oooo1@3o001g
0?ooo`030000003oool0oooo04X0oooo103o001i0?ooo`00K03oool50?l007D0oooo00<000000?oo
o`3oool0B03oool40?l007/0oooo001^0?ooo`@0o`00M03oool00`000000oooo0?ooo`160?ooo`D0
o`00O03oool00700oooo103o001b0?ooo`030000003oool0oooo04@0oooo1@3o001n0?ooo`00L@3o
ool50?l00700oooo00<000000?ooo`3oool0@P3oool50?l00800oooo001c0?ooo`D0o`00KP3oool0
0`000000oooo0?ooo`100?ooo`D0o`00PP3oool007D0oooo1@3o001/0?ooo`030000003oool0oooo
03d0oooo1P3o00240?ooo`00M`3oool50?l006X0oooo00<000000?ooo`3oool0>`3oool60?l008H0
oooo001i0?ooo`H0o`00I`3oool00`000000oooo0?ooo`0i0?ooo`D0o`00R@3oool007/0oooo1P3o
001U0?ooo`030000003oool0oooo03L0oooo1@3o002;0?ooo`00OP3oool50?l006<0oooo00<00000
0?ooo`3oool0=03oool60?l008d0oooo00200?ooo`D0o`00H@3oool00`000000oooo0?ooo`0a0?oo
o`L0o`00S`3oool00880oooo1@3o001O0?ooo`030000003oool0oooo02h0oooo1`3o002B0?ooo`00
Q03oool60?l005`0oooo00<000000?ooo`3oool0:`3oool70?l009D0oooo00260?ooo`H0o`00FP3o
ool00`000000oooo0?ooo`0X0?ooo`L0o`00V03oool008T0oooo1P3o001G0?ooo`030000003oool0
oooo02D0oooo1`3o002K0?ooo`00R`3oool60?l005D0oooo00<000000?ooo`3oool08@3oool70?l0
09l0oooo002>0?ooo`H0o`00DP3oool00`000000oooo0?ooo`0M0?ooo`P0o`00XP3oool00900oooo
1P3o001@0?ooo`030000003oool0oooo01T0oooo203o002V0?ooo`00T`3oool60?l004d0oooo00<0
00000?ooo`3oool04@3oool<0?l00:X0oooo002E0?ooo`P0o`00B@3oool00`000000oooo0?ooo`07
0?oooa80o`00[P3oool009P0oooo2@3o00140?oooaD0o`00]P3oool009d0oooo203o00100?ooo``0
o`00_`3oool00:40oooo1`3o000n0?ooo`030000003oool0oooo0<L0oooo002T0?ooo`L0o`00>`3o
ool00`000000oooo0?ooo`370?ooo`00Y`3oool<0?l003<0oooo00<0o`000?ooo`3oool0a`3oool0
0:X0oooo4@3o000U0?ooo`L0o`00b@3oool00;<0oooo403o000G0?ooo``0o`0000<000000?ooo`3o
ool0a`3oool00;/0oooo9@3o00060?ooo`030000003oool0oooo0<L0oooo00320?oooaT0o`002`3o
ool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`00
0000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo
0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`37
0?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00iP3oool00`000000oooo0?ooo`370?ooo`00
iP3oool00`000000oooo0?ooo`370?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?oo
o`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00h@3oool00`3o
okl0M0000000000200000003001d_`3oool0oooo0<L0oooo003T0?ooo`030?noM000M;l0oooo0<T0
oooo003U0?ooo`0309a8B02Lgol0oooo0<P0oooo003T0?ooo`030?oo_`1d000007Bo0<T0oooo003T
0?ooo`040=nLB000M;l0_g@007BoolP0oooo003T0?ooo`0409a8B02Lgol0omnL04Q8W<P0oooo003S
0?ooo`060?noM000M;l0oooo0?ooo`2oM000M;ooa`3oool00><0oooo00H0W4Q809cOo`3oool0oooo
0?oOW018B9c70?ooo`00hP3oool0202oM00000000000M02oool0oono07@00000000007BoaP3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00001\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-49.5695, -64.6786, 0.323195, \
0.344991}}],

Cell[BoxData[
    \("After more revolutions, Yes or No?"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    InterpretationBox[\("After "\[InvisibleSpace]3\[InvisibleSpace]" \
revolutions"\),
      SequenceForm[ "After ", 3, " revolutions"],
      Editable->False]], "Print",
  CellLabel->"From In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.635989 0.00960489 0.600729 0.00923528 [
[1.025 .60073 0 -6.28125 ]
[1.025 .60073 10 6.28125 ]
[.63599 1.025 -5 0 ]
[.63599 1.025 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .60073 m
1 .60073 L
s
gsave
1.025 .60073 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.63599 0 m
.63599 1 L
s
gsave
.63599 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.006 w
.63599 .82238 m
.64135 .82233 L
.64623 .82221 L
.65186 .82198 L
.65718 .82167 L
.66664 .8209 L
.67689 .81975 L
.68815 .81809 L
.70005 .8159 L
.72129 .8108 L
.74301 .80398 L
.76311 .79612 L
.80767 .77279 L
.85072 .74087 L
.88707 .70404 L
.90549 .68044 L
.92394 .65191 L
.93937 .62246 L
.95194 .59228 L
.96193 .56106 L
.96653 .54251 L
.97005 .52483 L
.97245 .50947 L
.97443 .49214 L
.97516 .48323 L
.97573 .47355 L
.97607 .4643 L
.97619 .45575 L
.97611 .44561 L
.97598 .44044 L
.97575 .4347 L
.97515 .42446 L
.97436 .41476 L
.97312 .40325 L
.9717 .39259 L
.9674 .36822 L
.96274 .34806 L
.95639 .32575 L
.93932 .28036 L
.91591 .23461 L
.88775 .19243 L
.8573 .15626 L
.81875 .11991 L
.77043 .08503 L
.74144 .06861 L
.71285 .05524 L
.68535 .04478 L
.65942 .03695 L
.62988 .03029 L
.61334 .02758 L
Mistroke
.6051 .02651 L
.59751 .02567 L
.58252 .02446 L
.57461 .02406 L
.56626 .02381 L
.55218 .02381 L
.53674 .0244 L
.52298 .02547 L
.5083 .02717 L
.49451 .0293 L
.48204 .03168 L
.45251 .03914 L
.42131 .04993 L
.39292 .06262 L
.36782 .07639 L
.32639 .10533 L
.28618 .14302 L
.25105 .18754 L
.22486 .23276 L
.20484 .28141 L
.19656 .30946 L
.19076 .33561 L
.18835 .34987 L
.18655 .36327 L
.18531 .37525 L
.18437 .38815 L
.18404 .39483 L
.1838 .40214 L
.18368 .40974 L
.1837 .41681 L
.18402 .42935 L
.18436 .43634 L
.18476 .44268 L
.18573 .45404 L
.18708 .46599 L
.19028 .48705 L
.19478 .50911 L
.20094 .5327 L
.21469 .57263 L
.23036 .60742 L
.27301 .67563 L
.29727 .70474 L
.32526 .73276 L
.37715 .77308 L
.42656 .80082 L
.45447 .81269 L
.48451 .82272 L
.49815 .82638 L
.5125 .82964 L
.52481 .83197 L
Mistroke
.53792 .83397 L
.55047 .83543 L
.56184 .83637 L
.56727 .83669 L
.57316 .83695 L
.57869 .83709 L
.5838 .83715 L
.59025 .83712 L
.59628 .83698 L
.60167 .83677 L
.60746 .83645 L
.61374 .83599 L
.62033 .83538 L
.632 .83398 L
.64418 .83208 L
.65553 .82988 L
.67631 .82478 L
.69794 .81789 L
.72055 .8088 L
.75871 .78848 L
.7909 .76534 L
.82238 .73544 L
.84803 .70317 L
.87134 .66318 L
.88199 .63863 L
.89003 .61485 L
.89592 .59168 L
.89851 .57827 L
.9004 .56582 L
.90175 .55395 L
.90233 .54716 L
.90274 .54084 L
.90301 .53526 L
.9032 .52907 L
.90328 .52255 L
.90324 .51641 L
.90305 .50919 L
.90288 .50508 L
.90267 .50125 L
.90218 .49419 L
.9015 .48661 L
.89972 .47196 L
.89754 .4585 L
.89427 .4425 L
.88984 .42498 L
.87929 .39268 L
.86602 .36148 L
.85057 .33218 L
.82804 .29735 L
.80335 .26609 L
Mistroke
.73949 .20546 L
.6964 .17554 L
.65048 .1507 L
.6066 .13265 L
.57984 .12407 L
.55446 .11752 L
.52694 .11212 L
.51144 .10983 L
.49651 .10814 L
.48265 .10702 L
.46968 .10635 L
.45534 .10606 L
.44728 .10609 L
.43996 .10626 L
.42664 .10687 L
.41253 .10796 L
.40046 .10927 L
.38722 .1111 L
.35778 .11674 L
.33058 .12397 L
.2826 .14195 L
.25678 .15479 L
.23413 .16819 L
.18858 .20266 L
.14701 .24655 L
.11814 .289 L
.10471 .31481 L
.09416 .33992 L
.08502 .368 L
.08106 .38356 L
.07804 .39816 L
.07579 .41178 L
.07422 .42419 L
.07299 .43801 L
.07227 .45277 L
.07213 .46045 L
.07217 .46857 L
.07268 .48309 L
.07321 .49112 L
.07386 .49862 L
.07591 .51556 L
.0783 .5302 L
.08098 .54344 L
.08861 .57264 L
.09754 .59881 L
.10706 .62171 L
.13271 .66988 L
.16092 .7102 L
.19048 .74412 L
.26372 .80579 L
Mistroke
.30709 .83194 L
.34722 .85091 L
.38359 .86429 L
.40336 .87016 L
.42184 .87479 L
.43882 .87834 L
.45699 .88139 L
.47324 .88347 L
.48802 .88483 L
.49633 .88538 L
.50517 .88579 L
.51344 .88601 L
.52093 .88607 L
.52917 .88599 L
.53379 .88587 L
.53806 .88572 L
.54661 .88528 L
.55562 .88463 L
.56442 .88381 L
.57381 .88272 L
.59047 .88024 L
.62032 .87397 L
.64757 .86607 L
.67157 .8572 L
.72093 .83243 L
.76212 .8031 L
.7989 .767 L
.82636 .72984 L
.839 .70755 L
.84885 .68618 L
.8565 .66541 L
.86221 .64542 L
.86661 .62414 L
.8683 .61266 L
.86905 .60613 L
.8696 .60016 L
.87 .59469 L
.87028 .5895 L
.87047 .584 L
.87054 .58089 L
.87057 .57801 L
.87056 .57321 L
.87045 .5679 L
.87023 .56234 L
.86994 .55711 L
.86946 .55095 L
.86889 .54507 L
.8675 .534 L
.86551 .52203 L
.86276 .50893 L
Mistroke
.85595 .48429 L
.84618 .45798 L
.82172 .41092 L
.80498 .38647 L
.7871 .36443 L
.73736 .31711 L
.68195 .27984 L
.64971 .2634 L
.6109 .24772 L
.59172 .24144 L
.56999 .23541 L
.55011 .23086 L
.52827 .22688 L
.50803 .22412 L
.49626 .22291 L
.48505 .22202 L
.47468 .22144 L
.46506 .22109 L
.45439 .22093 L
.44305 .22102 L
.4304 .22143 L
.41881 .22209 L
.41234 .22258 L
.4053 .22322 L
.39245 .22464 L
.36738 .22843 L
.34406 .23318 L
.31841 .23983 L
.29019 .24898 L
.23394 .27357 L
.184 .30397 L
.14018 .33958 L
.10508 .37692 L
.07273 .42286 L
.05755 .45112 L
.04606 .47783 L
.04066 .49303 L
.03563 .50973 L
.03199 .52435 L
.02875 .54054 L
.02646 .55574 L
.02495 .56999 L
.02403 .5851 L
.02382 .59358 L
.02381 .6013 L
.02425 .6151 L
.02537 .63006 L
.02705 .64412 L
.02913 .65704 L
.03533 .68463 L
Mistroke
.043 .70935 L
.05411 .73707 L
.06681 .76245 L
.09398 .80464 L
.12952 .84594 L
.17396 .88476 L
.22584 .91835 L
.27732 .94262 L
.29995 .95094 L
.32487 .95861 L
.34563 .96389 L
.36779 .96844 L
.37994 .97048 L
.39097 .97206 L
.40212 .97339 L
.41237 .97439 L
.42173 .9751 L
.43161 .97567 L
.44145 .97602 L
.45221 .97619 L
.46138 .97614 L
.47117 .9759 L
.48032 .9755 L
.48864 .97498 L
.49822 .97421 L
.50834 .97318 L
.52624 .97083 L
.54693 .96726 L
.56516 .96332 L
.60288 .9527 L
.63599 .94042 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00o`3oool20?ooo`030000003oool0oooo0:`0oooo003o0?ooo`80oooo00<000000?ooo`3o
ool0[03oool00?l0oooo0P3oool00`000000oooo0?ooo`2/0?ooo`00o`3oool20?ooo`030000003o
ool0oooo0:`0oooo003o0?ooo`80oooo00<000000?ooo`3oool0[03oool00?l0oooo0P3oool00`00
0000oooo0?ooo`2/0?ooo`00o`3oool20?ooo`030000003oool0oooo0:`0oooo003o0?ooo`80oooo
00<000000?ooo`3oool0[03oool00?l0oooo0P3oool00`000000oooo0?ooo`2/0?ooo`00e03ooolN
0?l000l0oooo00<000000?ooo`3oool0[03oool00<P0oooo<@3o00080?ooo`030000003oool0oooo
0:`0oooo00330?oooa40o`007P3oool=0?l00080oooo00<000000?ooo`3oool0[03oool00;l0oooo
2@3o000`0?ooo`d0o`00Z`3oool00;/0oooo203o000l0?ooo``0o`00Y@3oool00;L0oooo203o0012
0?ooo`040000003oool0oooo0?ooo`T0o`00XP3oool00;D0oooo1P3o00160?ooo`030000003oool0
oooo00L0oooo1P3o002O0?ooo`00/P3oool60?l004T0oooo00<000000?ooo`3oool02@3oool60?l0
09d0oooo002`0?ooo`H0o`00B`3oool00`000000oooo0?ooo`0<0?ooo`H0o`00VP3oool00:d0oooo
1P3o001>0?ooo`030000003oool0oooo00h0oooo1`3o002G0?ooo`00Z`3oool60?l00500oooo00<0
00000?ooo`3oool04@3oool60?l009D0oooo002Y0?ooo`D0o`00D`3oool00`000000oooo0?ooo`0D
0?ooo`H0o`00TP3oool00:H0oooo1P3o001E0?ooo`030000003oool0oooo01H0oooo1`3o002?0?oo
o`00Y03oool60?l005L0oooo00<000000?ooo`3oool06@3oool60?l008d0oooo002Q0?ooo`H0o`00
FP3oool00`000000oooo0?ooo`0L0?ooo`H0o`00RP3oool009l0oooo1P3o001L0?ooo`030000003o
ool0oooo01h0oooo1P3o00280?ooo`00W@3oool50?l005l0oooo00<000000?ooo`3oool08@3oool6
0?l008D0oooo002K0?ooo`D0o`00H@3oool00`000000oooo0?ooo`0S0?ooo`H0o`00P`3oool009T0
oooo1@3o001S0?ooo`030000003oool0oooo02H0oooo1@3o00210?ooo`00U`3oool50?l006D0oooo
00<000000?ooo`3oool0:03oool40?l00800oooo002E0?ooo`D0o`00I`3oool00`000000oooo0?oo
o`0Z0?ooo`@0o`00OP3oool009@0oooo103o001Y0?ooo`030000003oool0oooo02/0oooo103o001m
0?ooo`00TP3oool40?l006/0oooo00<000000?ooo`3oool0;@3oool40?l007/0oooo002A0?ooo`@0
o`00K03oool00`000000oooo0?ooo`0^0?ooo`@0o`00NP3oool00900oooo0`3o001^0?ooo`030000
003oool0oooo0300oooo103o001h0?ooo`00SP3oool40?l006l0oooo00<000000?ooo`3oool0<@3o
ool40?l007L0oooo002=0?ooo`@0o`00L03oool00`000000oooo0?ooo`0c0?ooo`@0o`00M@3oool0
08`0oooo0`3o001b0?ooo`030000003oool0oooo03@0oooo103o001d0?ooo`00RP3oool40?l007<0
oooo00<000000?ooo`3oool0=P3oool40?l00780oooo00290?ooo`@0o`00M03oool00`000000oooo
0?ooo`0g0?ooo`@0o`00L@3oool008P0oooo0`3o001f0?ooo`030000003oool0oooo03T0oooo103o
001_0?ooo`00QP3oool40?l007L0oooo00<000000?ooo`3oool0>P3oool40?l006h0oooo00250?oo
o`@0o`00N03oool00`000000oooo0?ooo`0l0?ooo`<0o`00K@3oool008@0oooo0`3o000P0?oooa`0
o`00?P3oool00`000000oooo0?ooo`0m0?ooo`@0o`00J`3oool008<0oooo0`3o000G0?oooc80o`00
<P3oool00`000000oooo0?ooo`0n0?ooo`@0o`00JP3oool00880oooo0`3o000B0?oooa00o`00703o
oolB0?l002`0oooo00<000000?ooo`3oool0@03oool40?l006P0oooo00200?ooo`@0o`003@3oool<
0?l00380oooo303o000V0?ooo`030000003oool0oooo0440oooo103o001W0?ooo`00O`3oool40?l0
00/0oooo2@3o000n0?ooo`/0o`008@3oool00`000000oooo0?ooo`130?ooo`@0o`00I@3oool007h0
oooo0`3o00090?ooo`L0o`00BP3oool;0?l001/0oooo00<000000?ooo`3oool0A03oool40?l006@0
oooo001m0?ooo`<0o`001P3oool80?l00580oooo2`3o000F0?ooo`030000003oool0oooo04H0oooo
0`3o001S0?ooo`00O03oool30?l000D0oooo1P3o001L0?ooo`P0o`004`3oool00`000000oooo0?oo
o`170?ooo`<0o`00HP3oool007/0oooo0`3o00030?ooo`H0o`00I03oool60?l00100oooo00<00000
0?ooo`3oool0B03oool30?l00640oooo001j0?ooo`<0o`000P3oool60?l006P0oooo1P3o000>0?oo
o`030000003oool0oooo04T0oooo0`3o001P0?ooo`00N@3oool90?l006h0oooo1P3o000;0?ooo`03
0000003oool0oooo04X0oooo0`3o001O0?ooo`00M`3oool90?l00780oooo1`3o00080?ooo`030000
003oool0oooo04/0oooo0`3o001N0?ooo`00MP3oool70?l007P0oooo1P3o00060?ooo`030000003o
ool0oooo04`0oooo0`3o001M0?ooo`00M@3oool60?l007d0oooo1P3o00030?ooo`030000003oool0
oooo04d0oooo103o001K0?ooo`00L`3oool60?l00840oooo1P3o00000`3oool000000?ooo`1?0?oo
o`@0o`00FP3oool00740oooo1@3o00270?ooo`H0o`00D@3oool30?l005T0oooo001_0?ooo`H0o`00
RP3oool60?l00500oooo0`3o001H0?ooo`00K@3oool70?l008d0oooo00<000000?l0003o0000103o
001>0?ooo`<0o`00E`3oool006/0oooo1@3o00000`3oool0o`000?l0002>0?ooo`030000003oool0
oooo00H0o`00C@3oool30?l005H0oooo001Y0?ooo`D0o`000P3oool20?l008l0oooo00<000000?oo
o`3oool00`3oool50?l004`0oooo0`3o001E0?ooo`00I`3oool50?l000@0oooo00<0o`000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`050?ooo`@0o`00C03oool30?l005@0oooo001U0?ooo`D0o`00
1@3oool20?l00900oooo00<000000?ooo`3oool01`3oool40?l004/0oooo0`3o001C0?ooo`00I03o
ool40?l000H0oooo0P3o002A0?ooo`030000003oool0oooo00P0oooo1@3o001:0?ooo`80o`00D`3o
ool00680oooo103o00070?ooo`80o`00TP3oool00`000000oooo0?ooo`0:0?ooo`D0o`00B@3oool2
0?l00580oooo001P0?ooo`D0o`00203oool00`3o0000oooo0?ooo`2A0?ooo`030000003oool0oooo
00`0oooo1@3o00170?ooo`<0o`00D@3oool005l0oooo103o00090?ooo`80o`00T`3oool00`000000
oooo0?ooo`0>0?ooo`@0o`00A`3oool30?l00500oooo001M0?ooo`@0o`002P3oool20?l009@0oooo
00<000000?ooo`3oool0403oool40?l004H0oooo0`3o001?0?ooo`00G03oool40?l000X0oooo0P3o
002E0?ooo`030000003oool0oooo0140oooo1@3o00150?ooo`80o`00C`3oool005/0oooo0`3o000;
0?ooo`80o`00UP3oool00`000000oooo0?ooo`0C0?ooo`@0o`00A@3oool20?l004h0oooo001I0?oo
o`@0o`00303oool00`3o0000oooo0?ooo`2E0?ooo`030000003oool0oooo01D0oooo103o00130?oo
o`<0o`00C@3oool005P0oooo103o000<0?ooo`80o`00U`3oool00`000000oooo0?ooo`0F0?ooo`@0
o`00@`3oool30?l004`0oooo001F0?ooo`@0o`003@3oool20?l009P0oooo00<000000?ooo`3oool0
603oool40?l00480oooo0`3o001;0?ooo`00E@3oool40?l000d0oooo0P3o002I0?ooo`030000003o
ool0oooo01T0oooo103o00120?ooo`80o`00B`3oool005@0oooo0`3o000?0?ooo`030?l0003oool0
oooo09P0oooo00<000000?ooo`3oool06`3oool40?l00440oooo0P3o001:0?ooo`00DP3oool40?l0
00l0oooo0P3o002J0?ooo`030000003oool0oooo01`0oooo103o00100?ooo`<0o`00B@3oool00540
oooo103o000@0?ooo`030?l0003oool0oooo09T0oooo00<000000?ooo`3oool07P3oool40?l003l0
oooo0P3o00190?ooo`00D03oool30?l00140oooo0P3o002K0?ooo`030000003oool0oooo01l0oooo
103o000o0?ooo`80o`00B03oool004h0oooo103o000A0?ooo`80o`00W03oool00`000000oooo0?oo
o`0Q0?ooo`@0o`00?P3oool20?l004L0oooo001=0?ooo`@0o`004P3oool00`3o0000oooo0?ooo`2K
0?ooo`030000003oool0oooo0280oooo103o000n0?ooo`030?l0003oool0oooo04D0oooo001<0?oo
o`<0o`004`3oool20?l009d0oooo00<000000?ooo`3oool0903oool40?l003`0oooo0P3o00160?oo
o`00B`3oool30?l001@0oooo00<0o`000?ooo`3oool0W03oool00`000000oooo0?ooo`0U0?ooo`@0
o`00?03oool20?l004D0oooo001:0?ooo`<0o`00503oool20?l009h0oooo00<000000?ooo`3oool0
9`3oool30?l003`0oooo0P3o00140?ooo`00B@3oool30?l001D0oooo00<0o`000?ooo`3oool0W@3o
ool00`000000oooo0?ooo`0X0?ooo`<0o`00?03oool00`3o0000oooo0?ooo`120?ooo`00B@3oool2
0?l001D0oooo0P3o002O0?ooo`030000003oool0oooo02T0oooo0`3o000k0?ooo`80o`00@`3oool0
04P0oooo0P3o000F0?ooo`030?l0003oool0oooo09h0oooo00<000000?ooo`3oool0:P3oool30?l0
03/0oooo0P3o00120?ooo`00A`3oool30?l001D0oooo0P3o002P0?ooo`030000003oool0oooo02/0
oooo0`3o000k0?ooo`030?l0003oool0oooo0400oooo00160?ooo`<0o`005@3oool20?l004h0oooo
4P3o00110?ooo`030000003oool0oooo02`0oooo0`3o000j0?ooo`80o`00@@3oool004D0oooo0`3o
000F0?ooo`030?l0003oool0oooo03h0oooo;`3o000c0?ooo`030000003oool0oooo02d0oooo0`3o
000j0?ooo`80o`00@03oool004@0oooo0`3o000F0?ooo`80o`00=P3ooolI0?l00180oooo5P3o000[
0?ooo`030000003oool0oooo02h0oooo0`3o000j0?ooo`80o`00?`3oool004<0oooo0`3o000G0?oo
o`030?l0003oool0oooo0340oooo3P3o000_0?oooa40o`008P3oool00`000000oooo0?ooo`0_0?oo
o`<0o`00>P3oool00`3o0000oooo0?ooo`0m0?ooo`00@P3oool30?l001L0oooo0P3o000^0?ooo`T0
o`00@@3oool=0?l001h0oooo00<000000?ooo`3oool0<03oool30?l003T0oooo0P3o000n0?ooo`00
@@3oool30?l001P0oooo00<0o`000?ooo`3oool0:P3oool80?l004h0oooo203o000J0?ooo`030000
003oool0oooo0340oooo103o000h0?ooo`80o`00?@3oool00440oooo0P3o000H0?ooo`80o`00:03o
ool70?l005L0oooo203o000F0?ooo`030000003oool0oooo0380oooo103o000h0?ooo`030?l0003o
ool0oooo03/0oooo00100?ooo`80o`006@3oool20?l002@0oooo203o001N0?ooo`H0o`00503oool0
0`000000oooo0?ooo`0d0?ooo`<0o`00=`3oool20?l003`0oooo000o0?ooo`<0o`00603oool20?l0
0280oooo1`3o001U0?ooo`H0o`004@3oool00`000000oooo0?ooo`0e0?ooo`<0o`00=`3oool00`3o
0000oooo0?ooo`0j0?ooo`00?P3oool30?l001T0oooo0P3o000O0?ooo`L0o`00JP3oool70?l000h0
oooo00<000000?ooo`3oool0=P3oool30?l003H0oooo0P3o000k0?ooo`00?@3oool30?l001T0oooo
0`3o000M0?ooo`H0o`00L03oool80?l000X0oooo00<000000?ooo`3oool0=`3oool30?l003H0oooo
00<0o`000?ooo`3oool0>@3oool003d0oooo0P3o000J0?ooo`80o`006`3oool60?l007L0oooo203o
00060?ooo`030000003oool0oooo03P0oooo0`3o000e0?ooo`80o`00>P3oool003`0oooo0P3o000J
0?ooo`<0o`006@3oool60?l007d0oooo1P3o00040?ooo`030000003oool0oooo03T0oooo0`3o000e
0?ooo`030?l0003oool0oooo03P0oooo000k0?ooo`80o`006`3oool20?l001L0oooo1P3o00230?oo
o`H0o`0000<0oooo0000003oool0>`3oool30?l003@0oooo0P3o000i0?ooo`00>`3oool00`3o0000
oooo0?ooo`0J0?ooo`80o`005@3oool60?l008L0oooo1`3o000l0?ooo`<0o`00=03oool00`3o0000
oooo0?ooo`0g0?ooo`00>P3oool20?l001/0oooo0`3o000C0?ooo`D0o`00S@3oool60?l003/0oooo
0`3o000c0?ooo`80o`00>03oool003T0oooo0P3o000L0?ooo`80o`004@3oool60?l00940oooo00<0
00000?l0003o0000103o000i0?ooo`<0o`00<`3oool00`3o0000oooo0?ooo`0f0?ooo`00>03oool2
0?l001`0oooo0`3o000?0?ooo`H0o`00T`3oool00`000000oooo0?ooo`060?l003P0oooo0`3o000b
0?ooo`80o`00=`3oool003P0oooo00<0o`000?ooo`3oool06`3oool20?l000h0oooo1@3o002F0?oo
o`030000003oool0oooo00<0oooo1@3o000g0?ooo`<0o`00<P3oool00`3o0000oooo0?ooo`0e0?oo
o`00=`3oool20?l001d0oooo0P3o000<0?ooo`D0o`00V03oool00`000000oooo0?ooo`050?ooo`D0
o`00=P3oool20?l00380oooo0P3o000f0?ooo`00=P3oool20?l001d0oooo0`3o00090?ooo`H0o`00
VP3oool00`000000oooo0?ooo`070?ooo`@0o`00=P3oool20?l00380oooo00<0o`000?ooo`3oool0
=03oool003H0oooo00<0o`000?ooo`3oool0703oool20?l000P0oooo1P3o002L0?ooo`030000003o
ool0oooo00T0oooo103o000e0?ooo`80o`00<@3oool20?l003D0oooo000e0?ooo`80o`007@3oool3
0?l000H0oooo1@3o002O0?ooo`030000003oool0oooo00X0oooo1@3o000d0?ooo`030?l0003oool0
oooo0300oooo00<0o`000?ooo`3oool0<`3oool003@0oooo0P3o000N0?ooo`80o`001P3oool40?l0
0:40oooo00<000000?ooo`3oool0303oool50?l00380oooo0P3o000a0?ooo`80o`00=03oool003<0
oooo0P3o000O0?ooo`80o`00103oool40?l00:<0oooo00<000000?ooo`3oool03P3oool40?l00380
oooo0P3o000a0?ooo`030?l0003oool0oooo0380oooo000c0?ooo`030?l0003oool0oooo01d0oooo
0`3o00020?ooo`D0o`00Y03oool00`000000oooo0?ooo`0@0?ooo`@0o`00<@3oool20?l00300oooo
0P3o000c0?ooo`00<P3oool20?l001l0oooo0P3o00020?ooo`@0o`00YP3oool00`000000oooo0?oo
o`0A0?ooo`@0o`00<@3oool20?l002l0oooo0P3o000c0?ooo`00<@3oool20?l00200oooo1P3o002X
0?ooo`030000003oool0oooo01<0oooo103o000`0?ooo`030?l0003oool0oooo02d0oooo0`3o000b
0?ooo`00<@3oool00`3o0000oooo0?ooo`0N0?ooo`H0o`00Z@3oool00`000000oooo0?ooo`0D0?oo
o`@0o`00;`3oool20?l002l0oooo0P3o000b0?ooo`00<03oool20?l00200oooo103o002[0?ooo`03
0000003oool0oooo01H0oooo103o000^0?ooo`80o`00;P3oool30?l00340oooo000`0?ooo`030?l0
003oool0oooo01d0oooo103o002]0?ooo`030000003oool0oooo01L0oooo103o000^0?ooo`80o`00
;P3oool20?l00340oooo000_0?ooo`80o`007@3oool50?l00:h0oooo00<000000?ooo`3oool06@3o
ool40?l002d0oooo00<0o`000?ooo`3oool0;03oool20?l00340oooo000_0?ooo`030?l0003oool0
oooo01/0oooo1P3o002^0?ooo`030000003oool0oooo01X0oooo103o000/0?ooo`80o`00;@3oool3
0?l00300oooo000^0?ooo`80o`006`3oool40?l000040?ooo`3o0000o`000?l00:h0oooo00<00000
0?ooo`3oool0703oool40?l002/0oooo0P3o000]0?ooo`80o`00<03oool002h0oooo00<0o`000?oo
o`3oool06@3oool40?l00080oooo0P3o002_0?ooo`030000003oool0oooo01d0oooo103o000[0?oo
o`030?l0003oool0oooo02/0oooo0`3o000_0?ooo`00;@3oool20?l001X0oooo0`3o00040?ooo`80
o`00[`3oool00`000000oooo0?ooo`0O0?ooo`@0o`00:@3oool20?l002d0oooo0P3o000_0?ooo`00
;@3oool00`3o0000oooo0?ooo`0G0?ooo`@0o`00103oool30?l00:l0oooo00<000000?ooo`3oool0
803oool40?l002T0oooo0P3o000/0?ooo`80o`00;`3oool002`0oooo0P3o000H0?ooo`@0o`001@3o
ool20?l00;00oooo00<000000?ooo`3oool08P3oool40?l002P0oooo00<0o`000?ooo`3oool0:P3o
ool30?l002h0oooo000/0?ooo`030?l0003oool0oooo01H0oooo0`3o00070?ooo`80o`00/03oool0
0`000000oooo0?ooo`0S0?ooo`@0o`009`3oool20?l002`0oooo0P3o000^0?ooo`00:`3oool20?l0
01L0oooo0`3o00080?ooo`80o`00/03oool00`000000oooo0?ooo`0U0?ooo`<0o`009`3oool00`3o
0000oooo0?ooo`0Z0?ooo`<0o`00;@3oool002/0oooo00<0o`000?ooo`3oool0503oool40?l000T0
oooo0P3o002`0?ooo`030000003oool0oooo02H0oooo0`3o000V0?ooo`80o`00;03oool20?l002d0
oooo000Z0?ooo`80o`005@3oool40?l000T0oooo0P3o002a0?ooo`030000003oool0oooo02L0oooo
0`3o000V0?ooo`80o`00:`3oool20?l002d0oooo000Z0?ooo`030?l0003oool0oooo01<0oooo0`3o
000;0?ooo`80o`00/@3oool00`000000oooo0?ooo`0X0?ooo`<0o`009P3oool00`3o0000oooo0?oo
o`0Y0?ooo`<0o`00;03oool002T0oooo0P3o000D0?ooo`<0o`00303oool20?l00;40oooo00<00000
0?ooo`3oool0:@3oool30?l002D0oooo0P3o000[0?ooo`80o`00;03oool002T0oooo00<0o`000?oo
o`3oool04P3oool30?l000d0oooo0P3o002a0?ooo`030000003oool0oooo02X0oooo0`3o000U0?oo
o`80o`00:P3oool20?l002`0oooo000X0?ooo`80o`004P3oool40?l000h0oooo0P3o002a0?ooo`03
0000003oool0oooo02/0oooo0`3o000U0?ooo`030?l0003oool0oooo02P0oooo0`3o000[0?ooo`00
:03oool00`3o0000oooo0?ooo`0@0?ooo`@0o`003P3oool20?l00;80oooo00<000000?ooo`3oool0
;03oool30?l002@0oooo0P3o000Z0?ooo`80o`00:`3oool002L0oooo0P3o000A0?ooo`<0o`00403o
ool20?l00;80oooo00<000000?ooo`3oool0;@3oool30?l002@0oooo00<0o`000?ooo`3oool0:03o
ool20?l002/0oooo000W0?ooo`030?l0003oool0oooo00l0oooo0`3o000A0?ooo`80o`00/P3oool0
0`000000oooo0?ooo`0^0?ooo`@0o`008P3oool20?l002T0oooo0`3o000Z0?ooo`009P3oool20?l0
0100oooo0`3o000B0?ooo`80o`00/P3oool00`000000oooo0?ooo`0_0?ooo`@0o`008P3oool20?l0
02T0oooo0P3o000Z0?ooo`009P3oool20?l000l0oooo0`3o000C0?ooo`80o`00/P3oool00`000000
oooo0?ooo`0a0?ooo`<0o`008P3oool00`3o0000oooo0?ooo`0W0?ooo`80o`00:P3oool002H0oooo
0P3o000>0?ooo`<0o`00503oool20?l00;80oooo00<000000?ooo`3oool0<P3oool30?l00240oooo
0P3o000X0?ooo`80o`00:P3oool002D0oooo0`3o000=0?ooo`<0o`00503oool20?l00;<0oooo00<0
00000?ooo`3oool0<`3oool30?l00240oooo00<0o`000?ooo`3oool09`3oool20?l002T0oooo000U
0?ooo`80o`003@3oool30?l001D0oooo0P3o002c0?ooo`030000003oool0oooo03@0oooo0`3o000P
0?ooo`80o`00:03oool20?l002T0oooo000U0?ooo`80o`00303oool30?l001H0oooo0P3o002c0?oo
o`030000003oool0oooo03D0oooo0`3o000P0?ooo`80o`009`3oool20?l002T0oooo000T0?ooo`<0
o`00303oool20?l001L0oooo0P3o002c0?ooo`030000003oool0oooo03H0oooo0`3o000P0?ooo`03
0?l0003oool0oooo02D0oooo0P3o000Y0?ooo`00903oool20?l000`0oooo0P3o000H0?ooo`80o`00
/`3oool00`000000oooo0?ooo`0g0?ooo`<0o`007`3oool20?l002H0oooo0P3o000Y0?ooo`00903o
ool20?l000/0oooo0`3o000H0?ooo`80o`00/`3oool00`000000oooo0?ooo`0h0?ooo`<0o`007`3o
ool00`3o0000oooo0?ooo`0T0?ooo`80o`00:@3oool002@0oooo0P3o000:0?ooo`<0o`00603oool2
0?l00;@0oooo00<000000?ooo`3oool0>@3oool20?l001l0oooo0P3o000U0?ooo`80o`00:@3oool0
02<0oooo0`3o00090?ooo`<0o`006@3oool20?l00;@0oooo00<000000?ooo`3oool0>P3oool20?l0
01h0oooo0P3o000U0?ooo`80o`00:@3oool002<0oooo0P3o00090?ooo`<0o`006P3oool20?l00;@0
oooo00<000000?ooo`3oool0>`3oool20?l001h0oooo0P3o000T0?ooo`<0o`00:03oool002<0oooo
0P3o00080?ooo`<0o`006`3oool20?l00;@0oooo00<000000?ooo`3oool0?03oool20?l001d0oooo
0P3o000U0?ooo`80o`00:03oool00280oooo0`3o00070?ooo`<0o`00703oool20?l00;@0oooo00<0
00000?ooo`3oool0?@3oool00`3o0000oooo0?ooo`0K0?ooo`<0o`00903oool20?l002P0oooo000R
0?ooo`80o`00203oool20?l001d0oooo0P3o002d0?ooo`030000003oool0oooo03d0oooo0P3o000M
0?ooo`80o`00903oool20?l002P0oooo000R0?ooo`80o`001`3oool20?l001h0oooo0P3o002d0?oo
o`030000003oool0oooo03h0oooo0P3o000L0?ooo`<0o`008`3oool20?l002P0oooo000R0?ooo`80
o`001P3oool20?l001l0oooo0P3o002d0?ooo`030000003oool0oooo03l0oooo0P3o000L0?ooo`80
o`008`3oool30?l002L0oooo000Q0?ooo`<0o`001P3oool00`3o0000oooo0?ooo`0N0?ooo`80o`00
]03oool00`000000oooo0?ooo`100?ooo`80o`006`3oool20?l002@0oooo0P3o000W0?ooo`008@3o
ool20?l000H0oooo0P3o000P0?ooo`80o`00]03oool00`000000oooo0?ooo`110?ooo`030?l0003o
ool0oooo01T0oooo0`3o000S0?ooo`80o`009`3oool00240oooo0P3o00050?ooo`80o`008@3oool2
0?l00;@0oooo00<000000?ooo`3oool0@@3oool20?l001/0oooo0P3o000S0?ooo`80o`009`3oool0
0240oooo0P3o00050?ooo`030?l0003oool0oooo0200oooo0P3o002d0?ooo`030000003oool0oooo
0480oooo0P3o000J0?ooo`<0o`008P3oool20?l002L0oooo000Q0?ooo`80o`00103oool20?l00280
oooo00<0o`000?ooo`3oool0/`3oool00`000000oooo0?ooo`130?ooo`030?l0003oool0oooo01T0
oooo0P3o000S0?ooo`80o`009P3oool00240oooo0P3o00030?ooo`80o`008P3oool20?l00;D0oooo
00<000000?ooo`3oool0@`3oool20?l001X0oooo0P3o000S0?ooo`80o`009P3oool00200oooo0P3o
00030?ooo`80o`008`3oool20?l00;D0oooo00<000000?ooo`3oool0A03oool20?l001T0oooo0`3o
000R0?ooo`80o`009P3oool00200oooo0P3o00030?ooo`030?l0003oool0oooo0280oooo0P3o002e
0?ooo`030000003oool0oooo04D0oooo0P3o000I0?ooo`80o`008P3oool20?l002H0oooo000P0?oo
o`80o`000P3oool20?l002@0oooo0P3o002e0?ooo`030000003oool0oooo04H0oooo00<0o`000?oo
o`3oool05`3oool20?l00280oooo0P3o000V0?ooo`00803oool20?l000030?ooo`3o0000o`0002D0
oooo0P3o002e0?ooo`030000003oool0oooo04H0oooo0P3o000H0?ooo`80o`008P3oool20?l002H0
oooo000P0?ooo`80o`0000<0oooo0?l0003oool09@3oool20?l00;D0oooo00<000000?ooo`3oool0
A`3oool20?l001L0oooo0`3o000Q0?ooo`80o`009P3oool001l0oooo0P3o00000`3oool0o`000?l0
000V0?ooo`80o`00]@3oool00`000000oooo0?ooo`180?ooo`030?l0003oool0oooo01H0oooo0P3o
000Q0?ooo`80o`009P3oool001l0oooo103o000W0?ooo`80o`00]@3oool00`000000oooo0?ooo`18
0?ooo`80o`005`3oool20?l00240oooo0`3o000U0?ooo`007`3oool30?l002P0oooo0P3o002e0?oo
o`030000003oool0oooo04T0oooo00<0o`000?ooo`3oool05@3oool30?l00240oooo0P3o000U0?oo
o`007`3oool30?l002P0oooo0P3o002e0?ooo`030000003oool0oooo04T0oooo0P3o000G0?ooo`80
o`008@3oool20?l002D0oooo000O0?ooo`80o`00:@3oool20?l00;D0oooo00<000000?ooo`3oool0
BP3oool00`3o0000oooo0?ooo`0E0?ooo`80o`008@3oool20?l002D0oooo000N0?ooo`80o`00:P3o
ool20?l00;D0oooo00<000000?ooo`3oool0BP3oool20?l001H0oooo0`3o000P0?ooo`80o`009@3o
ool001h0oooo0P3o000Z0?ooo`80o`00]@3oool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0
oooo01D0oooo0P3o000P0?ooo`80o`009@3oool001h0oooo0P3o000Z0?ooo`<0o`00]03oool00`00
0000oooo0?ooo`1;0?ooo`80o`005P3oool20?l00200oooo0P3o000U0?ooo`007@3oool30?l002/0
oooo0P3o002d0?ooo`030000003oool0oooo04`0oooo00<0o`000?ooo`3oool0503oool20?l00200
oooo0P3o000U0?ooo`007@3oool30?l002/0oooo0P3o002d0?ooo`030000003oool0oooo04`0oooo
0P3o000E0?ooo`<0o`007`3oool20?l002D0oooo000L0?ooo`@0o`00:`3oool20?l00;@0oooo00<0
00000?ooo`3oool0C@3oool20?l001D0oooo0P3o000O0?ooo`80o`009@3oool001/0oooo0P3o0000
0`3oool0o`000?l0000[0?ooo`80o`00]03oool00`000000oooo0?ooo`1>0?ooo`030?l0003oool0
oooo01<0oooo0P3o000O0?ooo`80o`009@3oool001/0oooo00<0o`000?ooo`3oool00P3o000[0?oo
o`80o`00]03oool00`000000oooo0?ooo`1>0?ooo`80o`00503oool20?l001l0oooo0P3o000U0?oo
o`006P3oool20?l00080oooo0P3o000[0?ooo`80o`00]03oool00`000000oooo0?ooo`1?0?ooo`03
0?l0003oool0oooo01<0oooo0P3o000N0?ooo`80o`009@3oool001X0oooo00@0o`000?ooo`3oool0
oooo0P3o000[0?ooo`80o`00]03oool00`000000oooo0?ooo`1?0?ooo`80o`00503oool20?l001h0
oooo0P3o000U0?ooo`006@3oool20?l000<0oooo0P3o000[0?ooo`80o`00]03oool00`000000oooo
0?ooo`1@0?ooo`030?l0003oool0oooo0180oooo0P3o000N0?ooo`80o`009@3oool001T0oooo00<0
o`000?ooo`3oool00P3oool20?l002/0oooo0P3o002d0?ooo`030000003oool0oooo0500oooo0P3o
000C0?ooo`80o`007P3oool20?l002D0oooo000H0?ooo`80o`000`3oool20?l002`0oooo0P3o002d
0?ooo`030000003oool0oooo0540oooo00<0o`000?ooo`3oool04@3oool20?l001h0oooo0P3o000U
0?ooo`00603oool00`3o0000oooo0?ooo`020?ooo`80o`00;@3oool20?l00;<0oooo00<000000?oo
o`3oool0D@3oool20?l00180oooo0P3o000N0?ooo`80o`009@3oool001L0oooo0P3o00040?ooo`80
o`00;@3oool20?l00;<0oooo00<000000?ooo`3oool0DP3oool00`3o0000oooo0?ooo`0@0?ooo`80
o`007P3oool20?l002D0oooo000G0?ooo`030?l0003oool0oooo00<0oooo0P3o000]0?ooo`80o`00
/`3oool00`000000oooo0?ooo`1B0?ooo`80o`004P3oool20?l001d0oooo0P3o000U0?ooo`005P3o
ool20?l000D0oooo0P3o000]0?ooo`80o`00/`3oool00`000000oooo0?ooo`1B0?ooo`80o`004P3o
ool20?l001d0oooo0P3o000U0?ooo`005P3oool00`3o0000oooo0?ooo`040?ooo`80o`00;@3oool2
0?l00;<0oooo00<000000?ooo`3oool0DP3oool30?l00140oooo0P3o000M0?ooo`80o`009@3oool0
01H0oooo00<0o`000?ooo`3oool0103oool20?l002h0oooo0P3o002b0?ooo`030000003oool0oooo
05<0oooo0P3o000A0?ooo`80o`007@3oool20?l002D0oooo000E0?ooo`80o`001`3oool20?l002d0
oooo0P3o002b0?ooo`030000003oool0oooo05<0oooo0`3o000@0?ooo`80o`007@3oool20?l002D0
oooo000E0?ooo`030?l0003oool0oooo00H0oooo0P3o000]0?ooo`80o`00/P3oool00`000000oooo
0?ooo`1D0?ooo`80o`004@3oool20?l001`0oooo0P3o000U0?ooo`00503oool20?l000P0oooo0P3o
000]0?ooo`80o`00/P3oool00`000000oooo0?ooo`1D0?ooo`80o`004@3oool20?l001`0oooo0P3o
000U0?ooo`00503oool00`3o0000oooo0?ooo`070?ooo`80o`00;@3oool20?l00;80oooo00<00000
0?ooo`3oool0E03oool30?l00100oooo0P3o000L0?ooo`80o`009@3oool001<0oooo0P3o00090?oo
o`80o`00;@3oool20?l00;80oooo00<000000?ooo`3oool0E@3oool20?l00100oooo0P3o000L0?oo
o`80o`009@3oool001<0oooo0P3o00090?ooo`80o`00;@3oool20?l00;80oooo00<000000?ooo`3o
ool0E@3oool20?l00100oooo0P3o000L0?ooo`80o`009@3oool00180oooo0`3o00090?ooo`80o`00
;@3oool30?l00;40oooo00<000000?ooo`3oool0EP3oool20?l000l0oooo0P3o000L0?ooo`80o`00
9@3oool00180oooo0P3o000:0?ooo`80o`00;P3oool20?l00;40oooo00<000000?ooo`3oool0EP3o
ool20?l000l0oooo0P3o000L0?ooo`80o`009@3oool00180oooo0P3o000:0?ooo`80o`00;P3oool2
0?l00;40oooo00<000000?ooo`3oool0EP3oool20?l000l0oooo0P3o000K0?ooo`<0o`009@3oool0
0140oooo0`3o000:0?ooo`80o`00;P3oool20?l00;40oooo00<000000?ooo`3oool0EP3oool20?l0
00l0oooo0P3o000K0?ooo`80o`009P3oool00140oooo0P3o000;0?ooo`80o`00;P3oool20?l00;40
oooo00<000000?ooo`3oool0EP3oool20?l000l0oooo0P3o000K0?ooo`80o`009P3oool00140oooo
0P3o000;0?ooo`80o`00;P3oool30?l00;00oooo00<000000?ooo`3oool0E`3oool20?l000h0oooo
0P3o000K0?ooo`80o`009P3oool00100oooo0`3o000<0?ooo`80o`00;P3oool20?l00;00oooo00<0
00000?ooo`3oool0E`3oool20?l000h0oooo0P3o000K0?ooo`80o`009P3oool00100oooo0P3o000=
0?ooo`80o`00;P3oool20?l00;00oooo00<000000?ooo`3oool0E`3oool20?l000h0oooo0P3o000K
0?ooo`80o`009P3oool00100oooo0P3o000=0?ooo`80o`00;P3oool20?l00;00oooo00<000000?oo
o`3oool0E`3oool20?l000h0oooo0`3o000J0?ooo`80o`009P3oool000l0oooo0`3o000=0?ooo`80
o`00;P3oool20?l00;00oooo00<000000?ooo`3oool0E`3oool30?l000h0oooo0P3o000I0?ooo`80
o`009`3oool000l0oooo0P3o000>0?ooo`80o`00;`3oool20?l00:l0oooo00<000000?ooo`3oool0
F03oool20?l000h0oooo0P3o000I0?ooo`80o`009`3oool000l0oooo0P3o000>0?ooo`80o`00;`3o
ool20?l00:l0oooo00<000000?ooo`3oool0F03oool20?l000h0oooo0P3o000I0?ooo`80o`009`3o
ool000h0oooo0`3o000>0?ooo`80o`00;`3oool20?l00:l0oooo00<000000?ooo`3oool0F03oool2
0?l000h0oooo0P3o000I0?ooo`80o`009`3oool000h0oooo0P3o000@0?ooo`80o`00;P3oool20?l0
0:l0oooo00<000000?ooo`3oool0F03oool20?l000h0oooo0P3o000I0?ooo`80o`009`3oool000h0
oooo0P3o000@0?ooo`80o`00;P3oool20?l00:l0oooo00<000000?ooo`3oool0F03oool20?l000h0
oooo0P3o000I0?ooo`80o`009`3oool000d0oooo0`3o000@0?ooo`80o`00;`3oool20?l00:h0oooo
00<000000?ooo`3oool0F@3oool20?l000d0oooo0P3o000I0?ooo`80o`009`3oool000d0oooo0P3o
000A0?ooo`80o`00;`3oool20?l00:h0oooo00<000000?ooo`3oool0F@3oool20?l000d0oooo0P3o
000H0?ooo`80o`00:03oool000d0oooo0P3o000A0?ooo`80o`00;`3oool20?l00:h0oooo00<00000
0?ooo`3oool0F@3oool20?l000d0oooo0P3o000H0?ooo`80o`00:03oool000d0oooo0P3o000A0?oo
o`80o`00;`3oool20?l00:h0oooo00<000000?ooo`3oool0F@3oool20?l000d0oooo0P3o000H0?oo
o`80o`00:03oool000d0oooo0P3o000B0?ooo`80o`00;P3oool30?l00:d0oooo00<000000?ooo`3o
ool0F@3oool20?l000d0oooo0P3o000H0?ooo`80o`00:03oool000d0oooo0P3o000B0?ooo`80o`00
;`3oool20?l00:d0oooo00<000000?ooo`3oool0FP3oool20?l000`0oooo0P3o000H0?ooo`80o`00
:03oool000d0oooo0P3o000B0?ooo`80o`00;`3oool20?l00:d0oooo00<000000?ooo`3oool0FP3o
ool20?l000`0oooo0P3o000H0?ooo`80o`00:03oool000`0oooo0P3o000C0?ooo`80o`00;`3oool3
0?l00:`0oooo00<000000?ooo`3oool0FP3oool20?l000`0oooo00<0o`000?ooo`3oool05`3oool2
0?l002P0oooo000<0?ooo`80o`004`3oool30?l002l0oooo0P3o002/0?ooo`030000003oool0oooo
05X0oooo0P3o000;0?ooo`80o`00603oool20?l002T0oooo000<0?ooo`80o`00503oool20?l002l0
oooo0`3o002[0?ooo`030000003oool0oooo05X0oooo0P3o000;0?ooo`80o`00603oool20?l002T0
oooo000<0?ooo`80o`00503oool20?l00300oooo0P3o002[0?ooo`030000003oool0oooo05X0oooo
0P3o000;0?ooo`80o`00603oool20?l002T0oooo000<0?ooo`80o`00503oool20?l00300oooo0P3o
002[0?ooo`030000003oool0oooo05X0oooo0P3o000;0?ooo`80o`005`3oool30?l002T0oooo000<
0?ooo`80o`00503oool30?l002l0oooo0`3o002Z0?ooo`030000003oool0oooo05X0oooo0P3o000;
0?ooo`80o`005`3oool20?l002X0oooo000;0?ooo`80o`005P3oool20?l00300oooo0P3o002Z0?oo
o`030000003oool0oooo05X0oooo0P3o000;0?ooo`80o`005`3oool20?l002X0oooo000;0?ooo`80
o`005P3oool20?l00300oooo0P3o002Z0?ooo`030000003oool0oooo05X0oooo0P3o000;0?ooo`80
o`005`3oool20?l002X0oooo000;0?ooo`80o`005P3oool20?l00300oooo0`3o002Y0?ooo`030000
003oool0oooo05X0oooo0P3o000;0?ooo`80o`005P3oool30?l002X0oooo000;0?ooo`80o`005P3o
ool30?l00300oooo0P3o002Y0?ooo`030000003oool0oooo05X0oooo0P3o000;0?ooo`80o`005P3o
ool20?l002/0oooo000;0?ooo`80o`005`3oool20?l00300oooo0`3o002X0?ooo`030000003oool0
oooo05X0oooo0P3o000:0?ooo`80o`005`3oool20?l002/0oooo000;0?ooo`80o`005`3oool20?l0
0340oooo0P3o002X0?ooo`030000003oool0oooo05X0oooo0P3o000:0?ooo`80o`005P3oool30?l0
02/0oooo000:0?ooo`80o`00603oool20?l00340oooo0P3o002X0?ooo`030000003oool0oooo05X0
oooo0P3o000:0?ooo`80o`005P3oool20?l002`0oooo000:0?ooo`80o`00603oool30?l00300oooo
0`3o002W0?ooo`030000003oool0oooo05X0oooo0P3o000:0?ooo`80o`005P3oool20?l002`0oooo
000:0?ooo`80o`006@3oool20?l00340oooo0P3o002W0?ooo`030000003oool0oooo05X0oooo0P3o
000:0?ooo`80o`005@3oool30?l002`0oooo000:0?ooo`80o`006@3oool20?l00340oooo0`3o002V
0?ooo`030000003oool0oooo05X0oooo0P3o000:0?ooo`80o`005@3oool20?l002d0oooo000:0?oo
o`80o`006@3oool30?l00340oooo0P3o002V0?ooo`030000003oool0oooo05X0oooo0P3o000:0?oo
o`80o`005@3oool20?l002d0oooo000:0?ooo`80o`006P3oool20?l00340oooo0P3o002V0?ooo`03
0000003oool0oooo05X0oooo0P3o000:0?ooo`80o`005@3oool20?l002d0oooo000:0?ooo`80o`00
6P3oool30?l00300oooo0`3o002U0?ooo`030000003oool0oooo05X0oooo0P3o000:0?ooo`80o`00
503oool30?l002d0oooo000:0?ooo`80o`006`3oool20?l00340oooo0P3o002U0?ooo`030000003o
ool0oooo05X0oooo0P3o000:0?ooo`80o`00503oool20?l002h0oooo000:0?ooo`80o`006`3oool2
0?l00340oooo0`3o002T0?ooo`030000003oool0oooo05X0oooo0P3o00090?ooo`80o`005@3oool2
0?l002h0oooo000:0?ooo`80o`006`3oool30?l00340oooo0P3o002T0?ooo`030000003oool0oooo
05X0oooo0P3o00090?ooo`80o`00503oool30?l001l0oooo00H0gia800000000000007Bo0?ooo`2o
M0020000000304RLg`3oool0oooo00@0oooo000:0?ooo`80o`00703oool20?l00340oooo0`3o002S
0?ooo`030000003oool0oooo05X0oooo0P3o00090?ooo`80o`00503oool20?l00240oooo00L0okmd
0000001d_ol0oooo0?noM0000000M;oo00L0oooo000:0?ooo`80o`00703oool30?l00340oooo0P3o
002S0?ooo`030000003oool0oooo05X0oooo0P3o00080?ooo`<0o`004`3oool30?l00280oooo00D0
oono07@0B018M4P0B01d0;ooo`080?ooo`0000<0oooo0000000000001`0000020?l001d000000P3o
000a00000080o`00o`00000100000080o`00200000020?l001@000000P3o000E000000l0oooo00<0
W4P004Q8B000B9`02@3oool000X0oooo0P3o000M0?ooo`80o`00<@3oool30?l00:80oooo00<00000
0?ooo`3oool0FP3oool20?l000P0oooo0P3o000D0?ooo`80o`008P3oool01`3ookl0M00004RLg`3o
ool0gia80000M02oool01`3oool000X0oooo0P3o000M0?ooo`<0o`00<@3oool20?l00:80oooo00<0
00000?ooo`3oool0FP3oool20?l000P0oooo0P3o000C0?ooo`<0o`008@3oool02@3ogi`0B0000000
0000M;l0oooo0;md00000000001809cOo`060?ooo`002P3oool20?l001h0oooo0P3o000b0?ooo`03
0?l0003oool0oooo0:00oooo00<000000?ooo`3oool0FP3oool20?l000L0oooo0`3o000C0?ooo`80
o`00<@3oool000X0oooo0P3o000N0?ooo`80o`00<P3oool20?l00:40oooo00<000000?ooo`3oool0
FP3oool20?l000L0oooo0P3o000C0?ooo`<0o`00<@3oool000X0oooo0P3o000N0?ooo`<0o`00<P3o
ool20?l00:00oooo00<000000?ooo`3oool0FP3oool20?l000L0oooo0P3o000C0?ooo`80o`00<P3o
ool000X0oooo0P3o000O0?ooo`80o`00<`3oool00`3o0000oooo0?ooo`2N0?ooo`030000003oool0
oooo05X0oooo0P3o00060?ooo`<0o`004`3oool20?l00380oooo000;0?ooo`80o`007P3oool20?l0
03<0oooo0P3o002O0?ooo`030000003oool0oooo05X0oooo0P3o00060?ooo`80o`004`3oool20?l0
03<0oooo000;0?ooo`80o`007`3oool00`3o0000oooo0?ooo`0b0?ooo`030?l0003oool0oooo09d0
oooo00<000000?ooo`3oool0FP3oool20?l000H0oooo0P3o000C0?ooo`80o`00<`3oool000/0oooo
0P3o000O0?ooo`80o`00<`3oool20?l009h0oooo00<000000?ooo`3oool0F@3oool30?l000D0oooo
0`3o000C0?ooo`030?l0003oool0oooo0380oooo000;0?ooo`80o`00803oool00`3o0000oooo0?oo
o`0b0?ooo`80o`00W@3oool00`000000oooo0?ooo`1I0?ooo`80o`001P3oool20?l001<0oooo0P3o
000d0?ooo`002`3oool20?l00200oooo0P3o000d0?ooo`030?l0003oool0oooo09/0oooo00<00000
0?ooo`3oool0F@3oool20?l000H0oooo0P3o000C0?ooo`030?l0003oool0oooo03<0oooo000;0?oo
o`80o`008@3oool00`3o0000oooo0?ooo`0b0?ooo`80o`00W03oool00`000000oooo0?ooo`1I0?oo
o`80o`001@3oool30?l00180oooo0P3o000e0?ooo`002`3oool20?l00240oooo0P3o000d0?ooo`80
o`00V`3oool00`000000oooo0?ooo`1H0?ooo`<0o`001@3oool20?l001<0oooo00<0o`000?ooo`3o
ool0=03oool000/0oooo0P3o000R0?ooo`80o`00=03oool00`3o0000oooo0?ooo`2I0?ooo`030000
003oool0oooo05P0oooo0P3o00060?ooo`80o`004P3oool20?l003H0oooo000;0?ooo`80o`008`3o
ool00`3o0000oooo0?ooo`0b0?ooo`80o`00VP3oool00`000000oooo0?ooo`1H0?ooo`80o`001@3o
ool30?l00180oooo00<0o`000?ooo`3oool0=@3oool000/0oooo0P3o000S0?ooo`80o`00=03oool0
0`3o0000oooo0?ooo`2H0?ooo`030000003oool0oooo05P0oooo0P3o00050?ooo`80o`004P3oool2
0?l003L0oooo000;0?ooo`80o`00903oool00`3o0000oooo0?ooo`0b0?ooo`80o`00V@3oool00`00
0000oooo0?ooo`1H0?ooo`80o`00103oool30?l00180oooo00<0o`000?ooo`3oool0=P3oool000/0
oooo0P3o000T0?ooo`80o`00=03oool20?l009P0oooo00<000000?ooo`3oool0E`3oool30?l000@0
oooo0P3o000B0?ooo`80o`00>03oool000`0oooo0P3o000T0?ooo`030?l0003oool0oooo03<0oooo
00<0o`000?ooo`3oool0UP3oool00`000000oooo0?ooo`1G0?ooo`80o`001@3oool20?l00180oooo
00<0o`000?ooo`3oool0=`3oool000`0oooo0P3o000T0?ooo`80o`00=03oool20?l009L0oooo00<0
00000?ooo`3oool0E`3oool20?l000@0oooo0`3o000A0?ooo`80o`00>@3oool000`0oooo0P3o000U
0?ooo`030?l0003oool0oooo03<0oooo0P3o002F0?ooo`030000003oool0oooo05L0oooo0P3o0004
0?ooo`80o`004P3oool00`3o0000oooo0?ooo`0h0?ooo`00303oool20?l002D0oooo0P3o000e0?oo
o`030?l0003oool0oooo09@0oooo00<000000?ooo`3oool0EP3oool30?l000<0oooo0`3o000A0?oo
o`80o`00>P3oool000`0oooo0`3o000U0?ooo`80o`00=03oool20?l009D0oooo00<000000?ooo`3o
ool0EP3oool20?l000@0oooo0P3o000A0?ooo`80o`00>`3oool000d0oooo0P3o000V0?ooo`030?l0
003oool0oooo03<0oooo0P3o002D0?ooo`030000003oool0oooo05H0oooo0P3o00040?ooo`80o`00
4@3oool00`3o0000oooo0?ooo`0j0?ooo`003@3oool20?l002H0oooo0P3o000e0?ooo`030?l0003o
ool0oooo0980oooo00<000000?ooo`3oool0EP3oool20?l000@0oooo00<0o`000?ooo`3oool03`3o
ool20?l003`0oooo000=0?ooo`80o`009`3oool00`3o0000oooo0?ooo`0c0?ooo`80o`00T`3oool0
0`000000oooo0?ooo`1E0?ooo`<0o`000`3oool20?l00100oooo0P3o000m0?ooo`003@3oool30?l0
02H0oooo0P3o000e0?ooo`030?l0003oool0oooo0940oooo00<000000?ooo`3oool0E@3oool20?l0
00<0oooo0P3o000A0?ooo`030?l0003oool0oooo03`0oooo000>0?ooo`80o`009`3oool00`3o0000
oooo0?ooo`0c0?ooo`80o`00TP3oool00`000000oooo0?ooo`1E0?ooo`80o`000`3oool00`3o0000
oooo0?ooo`0?0?ooo`80o`00?P3oool000h0oooo0P3o000W0?ooo`80o`00=@3oool20?l00940oooo
00<000000?ooo`3oool0E03oool20?l000<0oooo0P3o000A0?ooo`030?l0003oool0oooo03d0oooo
000>0?ooo`<0o`009`3oool20?l003D0oooo0P3o002@0?ooo`030000003oool0oooo05@0oooo0P3o
00030?ooo`030?l0003oool0oooo00l0oooo0P3o000o0?ooo`003`3oool20?l002P0oooo00<0o`00
0?ooo`3oool0<`3oool30?l008l0oooo00<000000?ooo`3oool0D`3oool30?l00080oooo0P3o000@
0?ooo`80o`00@03oool000l0oooo0P3o000X0?ooo`80o`00=@3oool20?l008l0oooo00<000000?oo
o`3oool0D`3oool20?l00080oooo0P3o000@0?ooo`80o`00@@3oool000l0oooo0P3o000Y0?ooo`80
o`00=@3oool20?l008h0oooo00<000000?ooo`3oool0D`3oool20?l00080oooo00<0o`000?ooo`3o
ool03P3oool30?l00440oooo000?0?ooo`<0o`00:@3oool00`3o0000oooo0?ooo`0c0?ooo`<0o`00
S@3oool00`000000oooo0?ooo`1C0?ooo`030?l0003oool0oooo0080o`00403oool20?l00480oooo
000@0?ooo`80o`00:@3oool20?l003D0oooo0`3o002<0?ooo`030000003oool0oooo0580oooo0P3o
00000`3oool0o`000?l0000@0?ooo`80o`00@`3oool00100oooo0P3o000Z0?ooo`80o`00=@3oool3
0?l008/0oooo00<000000?ooo`3oool0DP3oool0103o0000oooo0?ooo`3o000@0?ooo`<0o`00@`3o
ool00100oooo0`3o000Z0?ooo`80o`00=@3oool30?l008X0oooo00<000000?ooo`3oool0D@3oool2
0?l000030?ooo`3o0000o`0000l0oooo0`3o00140?ooo`004@3oool20?l002/0oooo00<0o`000?oo
o`3oool0=03oool20?l008X0oooo00<000000?ooo`3oool0D@3oool0103o0000oooo0?ooo`3o000?
0?ooo`<0o`00A@3oool00140oooo0P3o000[0?ooo`80o`00=P3oool20?l008T0oooo00<000000?oo
o`3oool0D@3oool0103o0000oooo0?l0003o000?0?ooo`80o`00AP3oool00140oooo0P3o000/0?oo
o`80o`00=@3oool30?l008P0oooo00<000000?ooo`3oool0D03oool40?l000l0oooo0P3o00170?oo
o`004@3oool30?l002`0oooo00<0o`000?ooo`3oool0=03oool30?l008L0oooo00<000000?ooo`3o
ool0D03oool00`3o0000oooo0?l0000?0?ooo`<0o`00A`3oool00180oooo0P3o000/0?ooo`80o`00
=P3oool30?l008H0oooo00<000000?ooo`3oool0C`3oool40?l000h0oooo0`3o00180?ooo`004P3o
ool20?l002d0oooo0P3o000f0?ooo`<0o`00Q@3oool00`000000oooo0?ooo`1?0?ooo`<0o`003P3o
ool30?l004T0oooo000B0?ooo`<0o`00;@3oool20?l003H0oooo0`3o00240?ooo`030000003oool0
oooo04h0oooo0`3o000>0?ooo`<0o`00BP3oool001<0oooo0P3o000]0?ooo`<0o`00=P3oool30?l0
08<0oooo00<000000?ooo`3oool0CP3oool20?l000h0oooo0`3o001;0?ooo`004`3oool20?l002h0
oooo0`3o000f0?ooo`<0o`00PP3oool00`000000oooo0?ooo`1=0?ooo`<0o`003@3oool30?l004`0
oooo000C0?ooo`<0o`00;P3oool20?l003L0oooo0`3o00210?ooo`030000003oool0oooo04`0oooo
0`3o000=0?ooo`<0o`00C@3oool001@0oooo0P3o000_0?ooo`80o`00=`3oool30?l00800oooo00<0
00000?ooo`3oool0C03oool20?l000d0oooo0`3o001>0?ooo`00503oool20?l002l0oooo0`3o000g
0?ooo`<0o`00O`3oool00`000000oooo0?ooo`1;0?ooo`80o`003@3oool30?l004l0oooo000D0?oo
o`<0o`00;`3oool30?l003L0oooo0`3o001n0?ooo`030000003oool0oooo04/0oooo00<0o`000?oo
o`3oool02`3oool30?l00500oooo000E0?ooo`80o`00<03oool30?l003L0oooo0`3o001m0?ooo`03
0000003oool0oooo04X0oooo0P3o000<0?ooo`<0o`00D@3oool001D0oooo0`3o000`0?ooo`<0o`00
=`3oool30?l007`0oooo00<000000?ooo`3oool0B@3oool20?l000`0oooo0`3o001B0?ooo`005P3o
ool20?l00340oooo0`3o000g0?ooo`<0o`00N`3oool00`000000oooo0?ooo`180?ooo`<0o`002`3o
ool30?l005<0oooo000F0?ooo`80o`00<P3oool20?l003P0oooo103o001i0?ooo`030000003oool0
oooo04L0oooo0`3o000;0?ooo`<0o`00E03oool001L0oooo00<0o`000?ooo`3oool0<@3oool20?l0
03P0oooo103o001h0?ooo`030000003oool0oooo04H0oooo0`3o000;0?ooo`<0o`00E@3oool001L0
oooo0P3o000b0?ooo`<0o`00>@3oool30?l007L0oooo00<000000?ooo`3oool0A@3oool30?l000/0
oooo0`3o001F0?ooo`00603oool00`3o0000oooo0?ooo`0a0?ooo`<0o`00>@3oool40?l007D0oooo
00<000000?ooo`3oool0A03oool40?l000T0oooo103o001G0?ooo`00603oool20?l003<0oooo0`3o
000i0?ooo`@0o`00M03oool00`000000oooo0?ooo`130?ooo`@0o`002@3oool40?l005P0oooo000I
0?ooo`030?l0003oool0oooo0380oooo0`3o000j0?ooo`<0o`00L`3oool00`000000oooo0?ooo`11
0?ooo`D0o`00203oool40?l005X0oooo000I0?ooo`80o`00=03oool30?l003X0oooo0`3o001b0?oo
o`030000003oool0oooo0400oooo1@3o00080?ooo`@0o`00F`3oool001X0oooo00<0o`000?ooo`3o
ool0<`3oool40?l003T0oooo103o001`0?ooo`030000003oool0oooo03l0oooo0`3o00000`3oool0
o`000?l000070?ooo`<0o`00G@3oool001X0oooo0P3o000e0?ooo`@0o`00>@3oool40?l006l0oooo
00<000000?ooo`3oool0?P3oool30?l000030?ooo`3o0000o`0000H0oooo103o001N0?ooo`006`3o
ool00`3o0000oooo0?ooo`0e0?ooo`<0o`00>P3oool30?l006h0oooo00<000000?ooo`3oool0?@3o
ool30?l00080oooo00<0o`000?ooo`3oool0103oool40?l005l0oooo000K0?ooo`80o`00=`3oool3
0?l003X0oooo103o001/0?ooo`030000003oool0oooo03`0oooo0`3o00020?ooo`80o`001@3oool3
0?l00640oooo000L0?ooo`030?l0003oool0oooo03H0oooo0`3o000j0?ooo`@0o`00J`3oool00`00
0000oooo0?ooo`0k0?ooo`<0o`000P3oool20?l000@0oooo103o001R0?ooo`00703oool20?l003P0
oooo0`3o000k0?ooo`<0o`00JP3oool00`000000oooo0?ooo`0j0?ooo`<0o`000P3oool20?l000@0
oooo103o001S0?ooo`007@3oool20?l003P0oooo103o000j0?ooo`@0o`00J03oool00`000000oooo
0?ooo`0i0?ooo`<0o`000P3oool20?l000<0oooo103o001U0?ooo`007P3oool00`3o0000oooo0?oo
o`0g0?ooo`@0o`00>P3oool40?l006L0oooo00<000000?ooo`3oool0=`3oool40?l00080oooo0`3o
00020?ooo`@0o`00IP3oool001h0oooo0P3o000j0?ooo`<0o`00>`3oool40?l006D0oooo00<00000
0?ooo`3oool0=P3oool40?l00080oooo0`3o00000`3oool0o`000?l000020?l006P0oooo000O0?oo
o`80o`00>P3oool30?l003/0oooo103o001T0?ooo`030000003oool0oooo03D0oooo0`3o00030?oo
o`P0o`00J@3oool00200oooo00<0o`000?ooo`3oool0>@3oool30?l003`0oooo103o001R0?ooo`03
0000003oool0oooo03@0oooo0`3o00030?ooo`L0o`00J`3oool00200oooo0P3o000k0?ooo`<0o`00
?03oool50?l00600oooo00<000000?ooo`3oool0<`3oool30?l000<0oooo1P3o001]0?ooo`008@3o
ool00`3o0000oooo0?ooo`0j0?ooo`@0o`00?03oool40?l005l0oooo00<000000?ooo`3oool0<@3o
ool40?l00080oooo1`3o001^0?ooo`008@3oool20?l003`0oooo103o000m0?ooo`@0o`00G@3oool0
0`000000oooo0?ooo`0`0?ooo`@0o`000P3oool60?l00700oooo000R0?ooo`80o`00?@3oool30?l0
03d0oooo1@3o001K0?ooo`030000003oool0oooo02l0oooo0`3o00030?ooo`D0o`00LP3oool002<0
oooo00<0o`000?ooo`3oool0?03oool30?l003h0oooo103o001J0?ooo`030000003oool0oooo02d0
oooo103o00030?ooo`@0o`00M03oool002<0oooo0P3o000n0?ooo`<0o`00?`3oool40?l005P0oooo
00<000000?ooo`3oool0:`3oool50?l00080oooo103o001f0?ooo`00903oool20?l003h0oooo0`3o
000o0?ooo`D0o`00EP3oool00`000000oooo0?ooo`0Y0?ooo`D0o`000P3oool50?l007L0oooo000U
0?ooo`030?l0003oool0oooo03d0oooo103o000o0?ooo`@0o`00E@3oool00`000000oooo0?ooo`0W
0?ooo`D0o`0000<0oooo0?l0003o00001@3o001h0?ooo`009@3oool20?l003l0oooo103o00100?oo
o`@0o`00D`3oool00`000000oooo0?ooo`0U0?ooo`D0o`0000<0oooo0?l0003o00001P3o001i0?oo
o`009P3oool20?l00400oooo0`3o00100?ooo`H0o`00D03oool00`000000oooo0?ooo`0S0?ooo`/0
o`0000@0oooo0?l0003o0000o`00NP3oool002L0oooo0P3o00100?ooo`<0o`00@@3oool60?l004h0
oooo00<000000?ooo`3oool08@3oool;0?l000030?ooo`3o0000o`000080o`00N`3oool002L0oooo
0`3o00100?ooo`@0o`00@P3oool60?l004/0oooo00<000000?ooo`3oool07`3oool:0?l000<0oooo
103o001l0?ooo`00:03oool30?l00400oooo1@3o00120?ooo`L0o`00B03oool00`000000oooo0?oo
o`0L0?ooo`X0o`00103oool40?l007h0oooo000Y0?ooo`<0o`00@@3oool40?l004@0oooo1`3o0015
0?ooo`030000003oool0oooo01T0oooo2P3o00060?ooo`@0o`00O`3oool002X0oooo0P3o00130?oo
o`@0o`00A@3oool70?l00480oooo00<000000?ooo`3oool05P3oool90?l000P0oooo103o00210?oo
o`00:`3oool20?l004<0oooo1@3o00160?ooo`L0o`00?`3oool00`000000oooo0?ooo`0>0?ooo`d0
o`002`3oool40?l00880oooo000[0?ooo`<0o`00A03oool50?l004L0oooo1`3o000l0?ooo`030000
003oool0oooo00T0oooo3P3o000>0?ooo`<0o`00Q03oool002`0oooo0`3o00150?ooo`D0o`00B03o
ool70?l003P0oooo603o000?0?ooo`@0o`00Q@3oool002d0oooo0`3o00160?ooo`@0o`00BP3oool7
0?l003D0oooo5@3o000A0?ooo`@0o`00QP3oool002h0oooo0`3o00170?ooo`@0o`00B`3oool90?l0
0340oooo00<000000?ooo`3oool01@3oool80?l001<0oooo103o00280?ooo`00;`3oool30?l004L0
oooo1@3o001<0?ooo`/0o`00;03oool00`000000oooo0?ooo`090?l001H0oooo103o00290?ooo`00
<03oool30?l004P0oooo1@3o001@0?ooo`X0o`009P3oool90?l001P0oooo103o002;0?ooo`00<@3o
ool20?l004X0oooo1@3o001B0?ooo`l0o`005@3oool<0?l001/0oooo1@3o002<0?ooo`00<P3oool2
0?l004/0oooo1@3o001F0?ooobH0o`0000<0oooo0000003oool06P3oool50?l008h0oooo000b0?oo
o`<0o`00C03oool50?l005d0oooo5P3o00080?ooo`030000003oool0oooo01L0oooo1@3o002@0?oo
o`00<`3oool30?l004d0oooo1@3o001i0?ooo`030000003oool0oooo01D0oooo1@3o002B0?ooo`00
=03oool30?l004h0oooo1@3o001g0?ooo`030000003oool0oooo01<0oooo1@3o002D0?ooo`00=@3o
ool30?l004l0oooo1@3o001e0?ooo`030000003oool0oooo0140oooo1@3o002F0?ooo`00=P3oool3
0?l00500oooo1@3o001c0?ooo`030000003oool0oooo00l0oooo1@3o002H0?ooo`00=`3oool30?l0
0540oooo1P3o001`0?ooo`030000003oool0oooo00d0oooo1@3o002J0?ooo`00>03oool40?l00540
oooo1`3o001]0?ooo`030000003oool0oooo00/0oooo1@3o002L0?ooo`00>@3oool40?l005<0oooo
1`3o001Z0?ooo`030000003oool0oooo00T0oooo1@3o002N0?ooo`00>`3oool30?l005D0oooo1`3o
001W0?ooo`030000003oool0oooo00H0oooo1P3o002P0?ooo`00?03oool30?l005L0oooo1`3o001T
0?ooo`030000003oool0oooo00@0oooo1P3o002R0?ooo`00?@3oool30?l005T0oooo1`3o001Q0?oo
o`030000003oool0oooo0080oooo1@3o002U0?ooo`00?P3oool30?l005/0oooo203o001M0?ooo`03
0000003oool0o`0000D0o`00Y`3oool003l0oooo0`3o001N0?ooo`P0o`00E`3oool70?l00:X0oooo
00100?ooo`<0o`00H@3oool70?l00500oooo203o002]0?ooo`00@@3oool40?l006<0oooo1`3o0016
0?ooo`X0o`000P3oool00`000000oooo0?ooo`2/0?ooo`00@P3oool40?l006D0oooo1`3o000m0?oo
o``0o`001P3oool00`000000oooo0?ooo`2/0?ooo`00A03oool30?l006P0oooo2P3o000_0?ooo`d0
o`00303oool00`000000oooo0?ooo`2/0?ooo`00A@3oool30?l006X0oooo3P3o000T0?ooo`/0o`00
4P3oool00`000000oooo0?ooo`2/0?ooo`00AP3oool30?l00700oooo4@3o000@0?ooo`h0o`006@3o
ool00`000000oooo0?ooo`2/0?ooo`00A`3oool40?l007D0oooo903o000M0?ooo`030000003oool0
oooo0:`0oooo00180?ooo`@0o`00O@3ooolB0?l002H0oooo00<000000?ooo`3oool0[03oool004X0
oooo103o002c0?ooo`030000003oool0oooo0:`0oooo001;0?ooo`@0o`00/P3oool00`000000oooo
0?ooo`2/0?ooo`00C@3oool40?l00;00oooo00<000000?ooo`3oool0[03oool004h0oooo103o002_
0?ooo`030000003oool0oooo0:`0oooo001@0?ooo`@0o`00[@3oool00`000000oooo0?ooo`2/0?oo
o`00D@3oool40?l00:`0oooo00<000000?ooo`3oool0[03oool005<0oooo103o002Z0?ooo`030000
003oool0oooo0:`0oooo001D0?ooo`@0o`00Z@3oool00`000000oooo0?ooo`2/0?ooo`00EP3oool4
0?l00:L0oooo00<000000?ooo`3oool0[03oool005L0oooo103o002V0?ooo`030000003oool0oooo
0:`0oooo001I0?ooo`@0o`00Y03oool00`000000oooo0?ooo`2/0?ooo`00FP3oool50?l00:80oooo
00<000000?ooo`3oool0[03oool005`0oooo1@3o002P0?ooo`030000003oool0oooo0:`0oooo001N
0?ooo`D0o`00WP3oool00`000000oooo0?ooo`2/0?ooo`00H03oool50?l009`0oooo00<000000?oo
o`3oool0[03oool00680oooo1@3o002J0?ooo`030000003oool0oooo0:`0oooo001T0?ooo`H0o`00
U`3oool00`000000oooo0?ooo`2/0?ooo`00IP3oool60?l009D0oooo00<000000?ooo`3oool0[03o
ool006T0oooo1@3o002C0?ooo`030000003oool0oooo0:`0oooo001[0?ooo`D0o`00T@3oool00`3o
0000oooo0?ooo`2/0?ooo`00K@3oool50?l008`0oooo1@3o002]0?ooo`00K`3oool60?l008L0oooo
1P3o002^0?ooo`00L@3oool70?l00840oooo1P3o00020?ooo`030000003oool0oooo0:`0oooo001d
0?ooo`L0o`00O03oool60?l000@0oooo00<000000?ooo`3oool0[03oool007L0oooo1`3o001f0?oo
o`H0o`001`3oool00`000000oooo0?ooo`2/0?ooo`00NP3oool70?l00700oooo1`3o00090?ooo`03
0000003oool0oooo0:`0oooo001n0?ooo`H0o`00J@3oool70?l000d0oooo00<000000?ooo`3oool0
[03oool00840oooo1`3o001Q0?ooo`P0o`00403oool00`000000oooo0?ooo`2/0?ooo`00Q03oool8
0?l005T0oooo203o000D0?ooo`030000003oool0oooo0:`0oooo00280?ooo`T0o`00C03oool<0?l0
01P0oooo00<000000?ooo`3oool0[03oool008`0oooo2@3o00140?ooo``0o`00703oool00`000000
oooo0?ooo`2/0?ooo`00T@3oool90?l003/0oooo203o000T0?ooo`030000003oool0oooo0:`0oooo
002E0?ooo`h0o`00:`3oool;0?l002P0oooo00<000000?ooo`3oool0[03oool009X0oooo4@3o000K
0?ooo`l0o`00;03oool00`000000oooo0?ooo`2/0?ooo`00X`3oool[0?l003<0oooo00<000000?oo
o`3oool0[03oool00:/0oooo6`3o000k0?ooo`030000003oool0oooo0:`0oooo003o0?ooo`80oooo
00<000000?ooo`3oool0[03oool00?l0oooo0P3oool00`000000oooo0?ooo`2/0?ooo`00o`3oool2
0?ooo`030000003oool0oooo0:`0oooo003o0?ooo`80oooo00<000000?ooo`3oool0[03oool00?l0
oooo0P3oool00`000000oooo0?ooo`2/0?ooo`00o`3oool20?ooo`030000003oool0oooo0:`0oooo
003o0?ooo`80oooo00<000000?ooo`3oool0[03oool00?l0oooo0P3oool00`000000oooo0?ooo`2/
0?ooo`00o`3oool20?ooo`030000003oool0oooo0:`0oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003m0?ooo`030?oo_`1d000000000080000000<007Bo0?ooo`3oool0Z`3oool00?l0oooo0@3oool0
0`3o_g@007Bo0?ooo`2]0?ooo`00o`3oool20?ooo`0309a8B02Lgol0oooo0:`0oooo003o0?ooo`40
oooo00<0oono07@00000M;l0[@3oool00?l0oooo0@3oool0103OW4P007Bo0;md001d_on/0?ooo`00
o`3oool10?ooo`0409a8B02Lgol0omnL04Q8W:`0oooo003o0?ooo`060?noM000M;l0oooo0?ooo`2o
M000M;ooZ`3oool00?l0oooo00H0W4Q809cOo`3oool0oooo0?oOW018B9b[0?ooo`00oP3oool0202o
M00000000000M02oool0oono07@00000000007BoZP3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool0
0001\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-66.7133, -65.0477, 0.388387, \
0.403931}}],

Cell[BoxData[
    \("After more revolutions, Yes or No?"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    InterpretationBox[\("After "\[InvisibleSpace]10\[InvisibleSpace]" \
revolutions"\),
      SequenceForm[ "After ", 10, " revolutions"],
      Editable->False]], "Print",
  CellLabel->"From In[12]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.499906 0.00747448 0.499213 0.00761154 [
[1.025 .49921 0 -6.28125 ]
[1.025 .49921 10 6.28125 ]
[.49991 1.025 -5 0 ]
[.49991 1.025 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .49921 m
1 .49921 L
s
gsave
1.025 .49921 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.49991 0 m
.49991 1 L
s
gsave
.49991 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.006 w
.49991 .68189 m
.51382 .68148 L
.52645 .68039 L
.541 .67827 L
.55469 .67543 L
.5788 .66832 L
.60452 .65758 L
.63206 .64198 L
.66002 .62095 L
.68254 .59918 L
.70547 .57091 L
.72663 .53649 L
.74285 .50035 L
.75022 .47847 L
.75359 .46636 L
.75676 .45301 L
.75934 .4398 L
.76127 .42747 L
.76384 .4025 L
.76465 .37658 L
.7637 .3518 L
.76058 .32369 L
.7547 .29314 L
.74724 .26605 L
.73814 .24052 L
.70916 .1828 L
.68768 .1517 L
.66432 .12437 L
.63549 .09722 L
.59942 .0709 L
.56491 .05201 L
.53019 .03822 L
.49166 .0284 L
.46941 .0252 L
.44879 .02381 L
.41221 .02507 L
.37851 .03058 L
.34257 .04138 L
.30613 .05822 L
.27081 .08134 L
.24096 .10766 L
.21746 .1344 L
.19579 .16605 L
.1767 .2032 L
.16337 .23932 L
.15766 .26034 L
.15363 .27959 L
.15035 .30176 L
.14853 .32263 L
.14792 .3425 L
Mistroke
.14843 .36331 L
.14993 .38253 L
.1521 .39954 L
.15559 .41911 L
.16038 .43954 L
.17149 .47455 L
.18315 .50239 L
.19778 .5305 L
.23173 .5795 L
.26664 .61599 L
.30078 .64285 L
.33831 .66481 L
.37288 .67921 L
.39072 .68468 L
.41014 .68919 L
.41979 .69088 L
.43008 .69229 L
.4397 .69324 L
.44843 .69379 L
.46426 .69404 L
.47869 .69342 L
.49418 .69182 L
.51029 .68911 L
.52677 .68516 L
.54184 .68047 L
.56871 .66926 L
.59217 .65606 L
.61515 .63937 L
.65117 .60273 L
.66803 .57874 L
.68149 .55405 L
.69343 .52447 L
.69871 .50676 L
.70255 .4899 L
.70528 .47344 L
.70699 .45746 L
.70786 .43938 L
.70755 .41925 L
.70584 .39869 L
.70443 .38813 L
.70244 .37642 L
.6977 .3553 L
.69181 .33526 L
.67567 .29503 L
.65522 .2581 L
.62403 .21613 L
.58644 .17851 L
.53594 .14191 L
.50676 .12614 L
.47193 .11156 L
Mistroke
.44023 .1019 L
.40437 .09482 L
.3692 .09171 L
.33633 .09222 L
.31636 .09419 L
.2951 .09772 L
.25728 .10791 L
.2347 .11663 L
.21403 .12657 L
.17757 .14954 L
.14604 .17665 L
.12072 .20554 L
.09765 .24096 L
.08807 .26 L
.0792 .28164 L
.06778 .32154 L
.06221 .35935 L
.06118 .37918 L
.06148 .40097 L
.06335 .4235 L
.06649 .44432 L
.07548 .48131 L
.08704 .51353 L
.10289 .54668 L
.12255 .57872 L
.16233 .62706 L
.20337 .66317 L
.25046 .69335 L
.27701 .7062 L
.30095 .71556 L
.32674 .72344 L
.3406 .72678 L
.3534 .72932 L
.37554 .7325 L
.39913 .73419 L
.41192 .73438 L
.4238 .73409 L
.4454 .73239 L
.45706 .73082 L
.4676 .729 L
.49053 .72365 L
.50963 .71765 L
.52665 .711 L
.556 .69628 L
.58409 .6775 L
.61041 .65434 L
.63012 .63194 L
.64775 .60612 L
.66113 .58025 L
.67053 .55561 L
Mistroke
.67496 .54011 L
.67816 .52552 L
.67948 .51781 L
.68066 .50924 L
.68158 .50021 L
.68215 .49168 L
.68244 .47588 L
.68183 .46127 L
.68113 .45316 L
.68007 .44425 L
.67731 .42795 L
.67295 .40971 L
.66756 .39248 L
.65396 .3603 L
.63384 .32611 L
.60508 .29038 L
.57338 .26099 L
.53279 .23304 L
.49207 .21287 L
.46644 .20341 L
.44087 .19617 L
.41312 .19061 L
.39852 .1886 L
.38199 .18706 L
.35181 .18623 L
.32247 .18787 L
.30536 .18995 L
.28713 .1931 L
.25421 .20133 L
.23581 .20744 L
.21876 .21415 L
.18068 .23316 L
.14879 .25416 L
.12054 .27775 L
.09699 .30227 L
.07482 .33121 L
.05456 .36584 L
.04002 .40019 L
.02929 .43908 L
.02561 .46179 L
.02381 .48326 L
.02443 .51992 L
.03035 .55941 L
.04078 .59551 L
.05439 .6274 L
.07124 .65706 L
.08909 .68195 L
.13621 .72993 L
.16595 .75185 L
.19461 .76867 L
Mistroke
.22694 .78351 L
.26144 .79523 L
.29137 .8023 L
.31888 .80646 L
.34837 .80852 L
.37889 .80808 L
.40725 .80532 L
.42278 .80283 L
.43694 .79993 L
.46416 .7926 L
.49151 .78275 L
.5357 .76078 L
.57034 .73708 L
.60236 .70819 L
.63046 .67444 L
.64209 .65684 L
.65271 .63779 L
.66107 .61979 L
.66745 .60314 L
.67238 .58737 L
.67658 .57006 L
.67818 .56169 L
.67957 .55274 L
.6807 .54332 L
.68143 .53455 L
.68184 .52635 L
.68199 .51748 L
.68147 .50147 L
.68 .48608 L
.67781 .47201 L
.67494 .4586 L
.67157 .44619 L
.66151 .41865 L
.64855 .39299 L
.63107 .36684 L
.61147 .34413 L
.58695 .32195 L
.56036 .30338 L
.53322 .28883 L
.51645 .28168 L
.49765 .27512 L
.47583 .26927 L
.46572 .26716 L
.45456 .26525 L
.43385 .26282 L
.41365 .26181 L
.40096 .26183 L
.38865 .26234 L
.36492 .26465 L
.35186 .26666 L
Mistroke
.33937 .26909 L
.31561 .27507 L
.28953 .28378 L
.26097 .29605 L
.2095 .32638 L
.16403 .36439 L
.13999 .39048 L
.11929 .41776 L
.09912 .45084 L
.08121 .48966 L
.07393 .51032 L
.06747 .53354 L
.06287 .55608 L
.06002 .57735 L
.05853 .61827 L
.05982 .63906 L
.06288 .66193 L
.07192 .69954 L
.08471 .73325 L
.10344 .76808 L
.12851 .80197 L
.15985 .83308 L
.1933 .85755 L
.22579 .87514 L
.26282 .88936 L
.29591 .89763 L
.33258 .90247 L
.37054 .90301 L
.40517 .89968 L
.43638 .89355 L
.46367 .88567 L
.49351 .87422 L
.52002 .86133 L
.57254 .8269 L
.59765 .80523 L
.6178 .7846 L
.65029 .74271 L
.67325 .70255 L
.68333 .67974 L
.69179 .65595 L
.69736 .63596 L
.70184 .61447 L
.70366 .60256 L
.7049 .59186 L
.70585 .5797 L
.7063 .56839 L
.70605 .54877 L
.70535 .53797 L
.70437 .52818 L
.70177 .51076 L
Mistroke
.69837 .49477 L
.69461 .48091 L
.68977 .4663 L
.67638 .43569 L
.66101 .40983 L
.64401 .38758 L
.62674 .36944 L
.60606 .35194 L
.58222 .33613 L
.5689 .32895 L
.55368 .32201 L
.53916 .31653 L
.5255 .31232 L
.50886 .30834 L
.49948 .30662 L
.49045 .30532 L
.47408 .3038 L
.46464 .30341 L
.4558 .30336 L
.43982 .30403 L
.42452 .30558 L
.40747 .30837 L
.38879 .31272 L
.37002 .31847 L
.35005 .32618 L
.3141 .34453 L
.27696 .37044 L
.24301 .40196 L
.21445 .43657 L
.18683 .4812 L
.17443 .5073 L
.16275 .53831 L
.15778 .55478 L
.1532 .57309 L
.14713 .60769 L
.14432 .64371 L
.14498 .67909 L
.14863 .71144 L
.15618 .74692 L
.16796 .78283 L
.18293 .81566 L
.1996 .84383 L
.22099 .87231 L
.24817 .90043 L
.28077 .92595 L
.31131 .94379 L
.34708 .95872 L
.38217 .96802 L
.41489 .97242 L
.45287 .97266 L
Mistroke
.4884 .96826 L
.52034 .96042 L
.54875 .95018 L
.57836 .93597 L
.60769 .91788 L
.66081 .87229 L
.68309 .84646 L
.70399 .8168 L
.71909 .79061 L
.73244 .7623 L
.74246 .73573 L
.74968 .71144 L
.75624 .68127 L
.75862 .6657 L
.76038 .6495 L
.76171 .62299 L
.76162 .60838 L
.76102 .59502 L
.75865 .57095 L
.75519 .54996 L
.74983 .52692 L
.74353 .50628 L
.72948 .47179 L
.71147 .43929 L
.69217 .41247 L
.67316 .3913 L
.64918 .36991 L
.62186 .35106 L
.59503 .33714 L
.56975 .32757 L
.55501 .32342 L
.54097 .3204 L
.52829 .31842 L
.51448 .31707 L
.4994 .31652 L
.49178 .31661 L
.48339 .317 L
.46858 .31842 L
.45474 .32061 L
.44094 .32363 L
.42789 .32729 L
.40367 .33627 L
.37813 .34908 L
.35115 .36692 L
.32284 .39155 L
.29902 .41859 L
.27448 .45568 L
.26457 .47486 L
.25521 .49665 L
.24819 .51669 L
Mistroke
.24175 .54004 L
.23719 .5625 L
.23418 .5845 L
.23236 .61169 L
.23252 .63756 L
.23343 .65227 L
.23512 .66857 L
.24021 .6989 L
.24752 .72785 L
.25655 .75469 L
.26921 .78421 L
.28583 .81495 L
.32177 .86449 L
.34662 .89039 L
.37257 .91241 L
.40646 .93512 L
.44136 .95263 L
.47468 .96454 L
.51237 .97292 L
.53237 .97526 L
.55454 .97619 L
.57774 .97528 L
.59935 .97267 L
.63727 .96376 L
.65791 .95644 L
.67622 .94833 L
.71149 .92786 L
.74539 .90082 L
.77333 .87112 L
.79489 .84142 L
.81556 .80385 L
.8249 .78187 L
.83202 .76134 L
.83754 .74162 L
.84161 .72317 L
.84477 .70397 L
.84701 .68305 L
.84798 .66503 L
.84803 .64574 L
.84567 .61161 L
.84062 .57981 L
.83383 .55187 L
.82451 .52342 L
.8122 .49422 L
.78222 .44232 L
.75245 .40509 L
.71749 .37214 L
.67964 .34565 L
.66137 .33562 L
.64416 .3276 L
Mistroke
.6282 .32135 L
.61105 .31582 L
.59692 .31215 L
.58156 .30907 L
.56514 .3068 L
.54806 .30554 L
.53254 .30537 L
.51831 .30606 L
.50205 .30785 L
.49303 .30931 L
.4848 .31095 L
.47002 .31465 L
.45475 .31954 L
.42953 .33021 L
.40348 .34514 L
.37808 .36447 L
.35354 .38917 L
.33339 .41605 L
.31778 .44372 L
.31101 .45887 L
.30538 .47385 L
.30097 .48802 L
.29706 .5036 L
.29375 .52122 L
.29164 .53807 L
.29045 .55683 L
.2903 .56778 L
.29053 .57821 L
.29183 .597 L
.29421 .61531 L
.29734 .6321 L
.30191 .65075 L
.3083 .67128 L
.31687 .69347 L
.33726 .73377 L
.37047 .78091 L
.39389 .8065 L
.4186 .82888 L
.47209 .86559 L
.50286 .88099 L
.52127 .88851 L
.53935 .89475 L
.57467 .90386 L
.60833 .90889 L
.64567 .91041 L
.66707 .90933 L
.68692 .90702 L
.71976 .90029 L
.75524 .88855 L
.79071 .87143 L
Mistroke
.8218 .85095 L
.84994 .82661 L
.87629 .79666 L
.89711 .76518 L
.9123 .73442 L
.92541 .69628 L
.93048 .67415 L
.93367 .65354 L
.93591 .61549 L
.93337 .57567 L
.92657 .53861 L
.91501 .50064 L
.90059 .46699 L
.88488 .43841 L
.86399 .4078 L
.83882 .37812 L
.81357 .3538 L
.78885 .33399 L
.76567 .31835 L
.7404 .30407 L
.69653 .2852 L
.67205 .27761 L
.65889 .27435 L
.64678 .27184 L
.62575 .2686 L
.60337 .26667 L
.58316 .26629 L
.56468 .2671 L
.54864 .26871 L
.53183 .27135 L
.51425 .27519 L
.49644 .28029 L
.46663 .29179 L
.43606 .30811 L
.41028 .32635 L
.38982 .34466 L
.37036 .36646 L
.35266 .39193 L
.34441 .40663 L
.33761 .42092 L
.33211 .43461 L
.32708 .44978 L
.32339 .46375 L
.32067 .47703 L
.31875 .48986 L
.31742 .5038 L
.31685 .51949 L
.31718 .53396 L
.31842 .54918 L
.32081 .56588 L
Mistroke
.32411 .58176 L
.3281 .59652 L
.33742 .62263 L
.35129 .65136 L
.37006 .68093 L
.392 .70789 L
.42161 .73631 L
.45446 .7606 L
.49668 .7838 L
.52319 .79469 L
.54908 .80296 L
.56294 .8065 L
.57808 .80969 L
.60635 .81384 L
.63827 .81579 L
.65701 .81561 L
.6749 .81451 L
.70784 .81011 L
.73842 .80314 L
.75537 .79802 L
.77382 .79134 L
.80701 .77618 L
.83884 .75724 L
.86725 .7358 L
.89126 .71334 L
.91422 .68672 L
.9359 .65448 L
.95215 .62234 L
.96523 .5856 L
.97045 .56402 L
.97383 .54355 L
.97619 .50667 L
.97408 .47176 L
.96865 .44089 L
.95909 .40832 L
.94467 .37456 L
.92522 .34119 L
.90568 .31507 L
.8815 .28907 L
.8556 .2666 L
.82618 .24607 L
.79251 .22766 L
.76052 .21432 L
.7431 .20856 L
.72428 .20343 L
.69049 .19691 L
.65836 .19378 L
.6297 .19344 L
.60383 .19511 L
.5806 .19824 L
Mistroke
.55627 .20324 L
.53156 .21022 L
.50728 .21909 L
.48578 .22877 L
.44945 .24966 L
.41517 .27594 L
.38512 .30644 L
.36435 .33386 L
.34626 .36504 L
.33215 .3989 L
.32645 .41803 L
.32428 .42711 L
.32257 .43555 L
.3202 .4509 L
.31932 .45898 L
.31867 .4676 L
.31831 .47661 L
.31826 .48509 L
.31893 .50084 L
.32035 .51471 L
.32272 .52944 L
.32576 .54316 L
.32922 .55552 L
.34034 .58488 L
.35442 .6115 L
.3725 .63735 L
.39257 .65967 L
.41831 .68197 L
.45013 .70272 L
.48136 .71761 L
.5005 .72454 L
.51909 .72986 L
.53616 .73362 L
.55573 .73667 L
.57707 .73855 L
.59779 .73898 L
.61875 .73806 L
.63922 .73585 L
.65805 .73268 L
.67896 .72785 L
.70211 .72086 L
.72704 .71131 L
.77212 .68816 L
.8203 .65328 L
.84337 .63172 L
.86712 .60502 L
.88584 .57956 L
.90369 .54985 L
.9181 .51961 L
.92876 .49048 L
Mistroke
.93846 .45189 L
.94324 .41497 L
.94346 .37367 L
.94147 .3528 L
.93761 .33001 L
.92717 .29256 L
.9105 .25422 L
.88983 .22065 L
.86712 .19282 L
.84129 .16824 L
.81084 .14593 L
.77992 .12877 L
.75057 .1166 L
.7149 .10635 L
.67587 .10019 L
.63925 .09879 L
.6063 .10101 L
.57623 .1059 L
.54927 .11265 L
.52108 .12223 L
.4927 .13465 L
.44098 .16559 L
.40147 .19839 L
.36751 .23578 L
.33863 .27857 L
.32722 .30024 L
.31709 .32345 L
.31003 .3433 L
.30399 .36467 L
.2998 .38432 L
.29712 .40222 L
.29547 .42069 L
.29496 .43988 L
.29559 .45729 L
.29708 .47323 L
.29914 .48714 L
.30208 .50175 L
.30652 .51859 L
.31153 .53371 L
.32578 .56585 L
.34317 .59411 L
.36528 .62097 L
.38876 .6426 L
.41342 .66003 L
.43743 .67299 L
.46546 .68405 L
.48186 .68874 L
.49991 .69252 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[12]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00bP3oool00`000000oooo0?ooo`3S0?ooo`00bP3oool00`000000oooo0?ooo`3S0?ooo`00
bP3oool00`000000oooo0?ooo`3S0?ooo`00bP3oool00`000000oooo0?ooo`3S0?ooo`00bP3oool0
0`000000oooo0?ooo`3S0?ooo`00bP3oool00`000000oooo0?ooo`3S0?ooo`00bP3oool00`000000
oooo0?ooo`3S0?ooo`00bP3oool00`000000oooo0?ooo`3S0?ooo`00bP3oool00`000000oooo0?oo
o`3S0?ooo`00Y`3ooolG0?l000`0oooo00<000000?ooo`3oool0h`3oool00:40oooo9P3o00030?oo
o`030000003oool0oooo0><0oooo002J0?ooo`d0o`005`3oool=0?l00>D0oooo002G0?ooo`X0o`00
9P3oool80?l00>40oooo002C0?ooo`L0o`00<03oool00`000000o`000?l000060?l00=d0oooo002?
0?ooo`P0o`00<`3oool00`000000oooo0?ooo`020?ooo`P0o`00f@3oool008/0oooo203o000g0?oo
o`030000003oool0oooo00H0oooo203o003E0?ooo`00R@3oool60?l003/0oooo00<000000?ooo`3o
ool02P3oool70?l00=80oooo00270?ooo`D0o`00?P3oool00`000000oooo0?ooo`0=0?ooo`H0o`00
d03oool008D0oooo1@3o00100?ooo`030000003oool0oooo0100oooo1P3o003=0?ooo`00P`3oool5
0?l00480oooo00<000000?ooo`3oool04P3oool70?l00<X0oooo00210?ooo`D0o`00A03oool00`00
0000oooo0?ooo`0E0?ooo`H0o`00b03oool007l0oooo1@3o00160?ooo`030000003oool0oooo01P0
oooo103o00370?ooo`00O@3oool50?l004P0oooo00<000000?ooo`3oool06P3oool40?l00<D0oooo
001k0?ooo`D0o`00BP3oool00`000000oooo0?ooo`0K0?ooo`@0o`00a03oool007X0oooo103o001<
0?ooo`030000003oool0oooo01d0oooo103o00320?ooo`00N03oool40?l004h0oooo00<000000?oo
o`3oool07P3oool50?l00<00oooo001f0?ooo`D0o`00C`3oool00`000000oooo0?ooo`0P0?ooo`@0
o`00_`3oool007D0oooo103o001A0?ooo`030000003oool0oooo0280oooo103o002m0?ooo`00L`3o
ool40?l005<0oooo00<000000?ooo`3oool08`3oool40?l00;`0oooo001a0?ooo`D0o`00E03oool0
0`000000oooo0?ooo`0U0?ooo`@0o`00^P3oool00700oooo103o001F0?ooo`030000003oool0oooo
02H0oooo103o002i0?ooo`00KP3oool40?l005P0oooo00<000000?ooo`3oool0:03oool30?l00;P0
oooo001]0?ooo`@0o`00F@3oool00`000000oooo0?ooo`0Y0?ooo`@0o`00]P3oool006`0oooo0`3o
001K0?ooo`030000003oool0oooo02X0oooo103o002e0?ooo`00J`3oool30?l005`0oooo00<00000
0?ooo`3oool0;03oool40?l00;<0oooo001Z0?ooo`<0o`00G@3oool00`000000oooo0?ooo`0]0?oo
o`@0o`00/P3oool006T0oooo0`3o000M0?oooa@0o`00;@3oool00`000000oooo0?ooo`0_0?ooo`<0
o`00/@3oool006L0oooo103o000B0?ooobL0o`009P3oool00`000000oooo0?ooo`0`0?ooo`@0o`00
[`3oool006H0oooo103o000>0?oooa40o`00503oool>0?l001l0oooo00<000000?ooo`3oool0<@3o
ool40?l00:h0oooo001U0?ooo`<0o`003@3oool80?l002L0oooo3P3o000H0?ooo`030000003oool0
oooo02P0oooo703o002O0?ooo`00I03oool30?l000X0oooo1`3o000c0?ooo`/0o`00503oool00`00
0000oooo0?ooo`0R0?ooobX0o`00U`3oool006<0oooo0`3o00070?ooo`P0o`00?@3oool70?l00140
oooo00<000000?ooo`3oool0703oool<0?l000d0oooo0`3o000<0?oooa00o`00S`3oool00680oooo
0`3o00040?ooo`P0o`00A@3oool60?l000h0oooo00<000000?ooo`3oool06@3oool90?l001@0oooo
0`3o000C0?ooo``0o`00R`3oool00640oooo0`3o00020?ooo`L0o`00C03oool70?l000X0oooo00<0
00000?ooo`3oool05@3oool70?l001/0oooo0`3o000J0?ooo`L0o`00R03oool00600oooo2P3o001B
0?ooo`H0o`00203oool00`000000oooo0?ooo`0A0?ooo`P0o`007`3oool40?l001`0oooo1`3o0024
0?ooo`00H03oool70?l005P0oooo1P3o00050?ooo`030000003oool0oooo00h0oooo1`3o000T0?oo
o`@0o`007P3oool70?l00840oooo001N0?ooo`H0o`00G@3oool60?l000<0oooo00<000000?ooo`3o
ool02`3oool70?l002T0oooo0`3o000Q0?ooo`H0o`00OP3oool005/0oooo1P3o001S0?ooo`D0o`00
00<0oooo0000003oool02P3oool60?l002d0oooo0`3o000S0?ooo`H0o`00N`3oool005T0oooo1`3o
001V0?ooo`H0o`001`3oool60?l00340oooo0`3o000T0?ooo`H0o`00N@3oool005L0oooo203o001Y
0?ooo`H0o`000`3oool60?l003@0oooo0`3o000V0?ooo`H0o`00MP3oool005H0oooo103o00020?oo
o`80o`00K03oool00`000000o`000?l000070?l003P0oooo0`3o000W0?ooo`H0o`00M03oool005@0
oooo103o00030?ooo`80o`00K@3oool00`000000oooo0?l000050?l003/0oooo0`3o000Y0?ooo`D0
o`00LP3oool005<0oooo103o00030?ooo`80o`00KP3oool90?l003/0oooo0`3o000Z0?ooo`@0o`00
L@3oool00540oooo103o00040?ooo`<0o`00K03oool50?l000<0oooo1@3o000j0?ooo`<0o`00:`3o
ool40?l006l0oooo001@0?ooo`@0o`001@3oool20?l006/0oooo1@3o00070?ooo`D0o`00>@3oool2
0?l002`0oooo1@3o001]0?ooo`00C`3oool30?l000H0oooo0P3o001Z0?ooo`D0o`0000<0oooo0000
003oool0203oool40?l003T0oooo0P3o000]0?ooo`D0o`00J`3oool004d0oooo103o00060?ooo`80
o`00JP3oool40?l000<0oooo00<000000?ooo`3oool02@3oool40?l003L0oooo0`3o000^0?ooo`@0
o`00JP3oool004`0oooo103o00060?ooo`80o`00J@3oool40?l000D0oooo00<000000?ooo`3oool0
2P3oool40?l003L0oooo0`3o000_0?ooo`@0o`00J03oool004X0oooo103o00080?ooo`030?l0003o
ool0oooo06H0oooo1@3o00060?ooo`030000003oool0oooo00`0oooo103o000f0?ooo`<0o`00;`3o
ool40?l006L0oooo00190?ooo`@0o`00203oool20?l006H0oooo1@3o00080?ooo`030000003oool0
oooo00d0oooo103o000f0?ooo`<0o`00<03oool40?l006D0oooo00180?ooo`<0o`002@3oool20?l0
06H0oooo103o000:0?ooo`030000003oool0oooo00l0oooo103o000e0?ooo`80o`00<@3oool40?l0
06@0oooo00170?ooo`<0o`002@3oool20?l006D0oooo103o000<0?ooo`030000003oool0oooo0100
oooo103o000e0?ooo`80o`00<P3oool40?l00680oooo00150?ooo`@0o`002P3oool00`3o0000oooo
0?ooo`1R0?ooo`D0o`003@3oool00`000000oooo0?ooo`0B0?ooo`@0o`00=03oool20?l00380oooo
103o001Q0?ooo`00A03oool40?l000X0oooo0P3o001R0?ooo`D0o`003`3oool00`000000oooo0?oo
o`0C0?ooo`@0o`00=03oool00`3o0000oooo0?ooo`0b0?ooo`@0o`00G`3oool004<0oooo0`3o000;
0?ooo`80o`00HP3oool40?l00140oooo00<000000?ooo`3oool05@3oool30?l003<0oooo0P3o000d
0?ooo`@0o`00GP3oool00480oooo0`3o000;0?ooo`80o`00H@3oool40?l001<0oooo00<000000?oo
o`3oool05P3oool40?l00380oooo0P3o000e0?ooo`@0o`00G03oool00440oooo0`3o000<0?ooo`03
0?l0003oool0oooo05l0oooo103o000D0?ooo`030000003oool0oooo01L0oooo103o000b0?ooo`03
0?l0003oool0oooo03@0oooo103o001K0?ooo`00@03oool30?l000`0oooo0P3o001P0?ooo`<0o`00
5P3oool00`000000oooo0?ooo`0I0?ooo`@0o`00<03oool20?l003L0oooo0`3o001J0?ooo`00?P3o
ool40?l000d0oooo00<0o`000?ooo`3oool0G@3oool40?l001L0oooo00<000000?ooo`3oool06P3o
ool40?l00300oooo0P3o000g0?ooo`<0o`00F@3oool003d0oooo103o000=0?ooo`80o`00GP3oool4
0?l001P0oooo00<000000?ooo`3oool0703oool40?l002l0oooo0P3o000g0?ooo`<0o`00F03oool0
03`0oooo0`3o000?0?ooo`030?l0003oool0oooo05`0oooo0`3o000J0?ooo`030000003oool0oooo
01d0oooo103o000_0?ooo`030?l0003oool0oooo03H0oooo0`3o001G0?ooo`00>`3oool30?l000l0
oooo0P3o001M0?ooo`<0o`006`3oool00`000000oooo0?ooo`0O0?ooo`<0o`00;P3oool20?l003P0
oooo0`3o001F0?ooo`00>P3oool30?l00100oooo00<0o`000?ooo`3oool0FP3oool40?l001`0oooo
00<000000?ooo`3oool0803oool30?l002h0oooo0P3o000h0?ooo`<0o`00E@3oool003T0oooo0`3o
000@0?ooo`80o`00F`3oool40?l001d0oooo00<000000?ooo`3oool08@3oool30?l002h0oooo00<0
o`000?ooo`3oool0=`3oool30?l005@0oooo000h0?ooo`<0o`00403oool20?l003H0oooo603o000=
0?ooo`<0o`007`3oool00`000000oooo0?ooo`0R0?ooo`<0o`00;@3oool20?l003T0oooo0`3o001C
0?ooo`00=`3oool30?l00140oooo00<0o`000?ooo`3oool0;P3oool^0?l00200oooo00<000000?oo
o`3oool08`3oool30?l002d0oooo00<0o`000?ooo`3oool0>03oool30?l00580oooo000g0?ooo`80
o`004@3oool20?l002T0oooo3P3o000H0?oooa<0o`00703oool00`000000oooo0?ooo`0T0?ooo`<0
o`00;03oool20?l003X0oooo0`3o001A0?ooo`00=P3oool20?l00180oooo00<0o`000?ooo`3oool0
903oool;0?l002P0oooo3`3o000G0?ooo`030000003oool0oooo02D0oooo7`3o000@0?ooo`030?l0
003oool0oooo03T0oooo0`3o001@0?ooo`00=@3oool30?l00140oooo0P3o000R0?ooo`P0o`00;P3o
ool30?l000P0oooo2@3o000C0?ooo`030000003oool0oooo01l0oooo:`3o000:0?ooo`80o`00>`3o
ool30?l004l0oooo000d0?ooo`<0o`004P3oool00`3o0000oooo0?ooo`0L0?ooo`T0o`00<@3oool3
0?l000h0oooo1`3o000@0?ooo`030000003oool0oooo01X0oooo403o000J0?ooo`d0o`00103oool0
0`3o0000oooo0?ooo`0j0?ooo`80o`00C`3oool003<0oooo0`3o000B0?ooo`80o`006`3oool80?l0
03@0oooo0`3o000C0?ooo`H0o`003@3oool00`000000oooo0?ooo`0D0?ooo`/0o`002@3oool30?l0
01l0oooo3P3o000k0?ooo`80o`00CP3oool00380oooo0`3o000C0?ooo`030?l0003oool0oooo01P0
oooo1P3o000g0?ooo`<0o`005`3oool60?l000X0oooo00<000000?ooo`3oool04@3oool90?l000l0
oooo0`3o000U0?ooo`/0o`00=`3oool30?l004d0oooo000b0?ooo`80o`004`3oool20?l001L0oooo
1P3o000i0?ooo`<0o`006`3oool60?l000L0oooo00<000000?ooo`3oool03P3oool60?l001H0oooo
0`3o000Y0?ooo`T0o`00=@3oool30?l004`0oooo000a0?ooo`80o`00503oool20?l001D0oooo1P3o
000j0?ooo`<0o`007P3oool60?l000D0oooo00<000000?ooo`3oool02P3oool70?l001X0oooo0`3o
000Y0?ooo`030?l0003oool0oooo0080oooo1P3o000c0?ooo`<0o`00B`3oool00300oooo0P3o000D
0?ooo`<0o`004P3oool60?l003`0oooo0`3o000R0?ooo`H0o`000P3oool00`000000oooo0?ooo`07
0?ooo`L0o`007P3oool30?l002P0oooo00<0o`000?ooo`3oool01@3oool60?l00340oooo0`3o001:
0?ooo`00<03oool00`3o0000oooo0?ooo`0C0?ooo`80o`004@3oool60?l003d0oooo0`3o000U0?oo
o`H0o`0000<000000?ooo`3oool01@3oool60?l00280oooo0`3o000W0?ooo`80o`00203oool60?l0
0300oooo0P3o001:0?ooo`00;`3oool20?l001D0oooo0P3o000?0?ooo`D0o`00@03oool20?l002T0
oooo1@3o00030?ooo`H0o`009P3oool20?l002P0oooo00<0o`000?ooo`3oool02@3oool60?l002h0
oooo0P3o00190?ooo`00;P3oool20?l001D0oooo0`3o000=0?ooo`D0o`00@@3oool20?l002`0oooo
2P3o000Y0?ooo`80o`009`3oool20?l000`0oooo1P3o000/0?ooo`<0o`00B03oool002h0oooo00<0
o`000?ooo`3oool0503oool20?l000`0oooo1@3o00120?ooo`<0o`00;@3oool60?l002d0oooo0P3o
000W0?ooo`030?l0003oool0oooo00d0oooo1P3o000Z0?ooo`80o`00B03oool002d0oooo0P3o000F
0?ooo`80o`002@3oool60?l004<0oooo0`3o000/0?ooo`/0o`00:`3oool20?l002H0oooo0P3o000@
0?ooo`H0o`00:@3oool20?l004L0oooo000]0?ooo`030?l0003oool0oooo01@0oooo0`3o00070?oo
o`H0o`00A03oool30?l002X0oooo1P3o00040?ooo`H0o`00:P3oool00`3o0000oooo0?ooo`0U0?oo
o`030?l0003oool0oooo0140oooo1P3o000W0?ooo`80o`00AP3oool002`0oooo0P3o000F0?ooo`80
o`001P3oool50?l004H0oooo0`3o000Y0?ooo`H0o`0000<0oooo0000003oool01P3oool50?l002P0
oooo0P3o000V0?ooo`80o`00503oool60?l002H0oooo00<0o`000?ooo`3oool0A03oool002/0oooo
0P3o000G0?ooo`80o`00103oool50?l004L0oooo0`3o000Y0?ooo`@0o`00103oool00`000000oooo
0?ooo`070?ooo`D0o`009`3oool20?l002H0oooo00<0o`000?ooo`3oool05@3oool50?l002@0oooo
0P3o00150?ooo`00:`3oool00`3o0000oooo0?ooo`0E0?ooo`<0o`000`3oool40?l004P0oooo0`3o
000X0?ooo`@0o`001P3oool00`000000oooo0?ooo`090?ooo`@0o`009`3oool20?l002D0oooo0P3o
000H0?ooo`D0o`008`3oool20?l004@0oooo000Z0?ooo`80o`005`3oool20?l00080oooo103o001:
0?ooo`80o`009`3oool50?l000L0oooo00<000000?ooo`3oool02`3oool40?l002H0oooo00<0o`00
0?ooo`3oool0903oool00`3o0000oooo0?ooo`0H0?ooo`D0o`008P3oool00`3o0000oooo0?ooo`12
0?ooo`00:@3oool20?l001P0oooo0P3o00000`3oool0o`000?l000020?l004X0oooo0P3o000W0?oo
o`@0o`002@3oool00`000000oooo0?ooo`0<0?ooo`@0o`009@3oool20?l002D0oooo0P3o000K0?oo
o`D0o`00803oool20?l004<0oooo000Y0?ooo`030?l0003oool0oooo01H0oooo1P3o001;0?ooo`80
o`009P3oool40?l000/0oooo00<000000?ooo`3oool03P3oool40?l002@0oooo0P3o000U0?ooo`03
0?l0003oool0oooo01/0oooo1@3o000O0?ooo`030?l0003oool0oooo0440oooo000X0?ooo`80o`00
603oool50?l004`0oooo00<0o`000?ooo`3oool08`3oool50?l000`0oooo00<000000?ooo`3oool0
3`3oool40?l002@0oooo0P3o000T0?ooo`80o`007P3oool50?l001d0oooo0P3o00120?ooo`00:03o
ool00`3o0000oooo0?ooo`0F0?ooo`@0o`00C@3oool20?l002@0oooo103o000>0?ooo`030000003o
ool0oooo0140oooo103o000S0?ooo`80o`008`3oool30?l001l0oooo103o000M0?ooo`80o`00@@3o
ool002L0oooo0P3o000G0?ooo`@0o`00CP3oool00`3o0000oooo0?ooo`0Q0?ooo`@0o`00403oool0
0`000000oooo0?ooo`0B0?ooo`@0o`008`3oool00`3o0000oooo0?ooo`0Q0?ooo`<0o`008@3oool3
0?l001d0oooo00<0o`000?ooo`3oool0?`3oool002L0oooo00<0o`000?ooo`3oool0503oool60?l0
04d0oooo0P3o000R0?ooo`@0o`004@3oool00`000000oooo0?ooo`0D0?ooo`@0o`008@3oool20?l0
02<0oooo0P3o000R0?ooo`@0o`006`3oool20?l00400oooo000V0?ooo`80o`005@3oool60?l004d0
oooo0P3o000Q0?ooo`@0o`004`3oool00`000000oooo0?ooo`0E0?ooo`@0o`008@3oool20?l00280
oooo0`3o000R0?ooo`@0o`006`3oool20?l003l0oooo000V0?ooo`030?l0003oool0oooo01<0oooo
0`3o00020?ooo`80o`00C@3oool00`3o0000oooo0?ooo`0O0?ooo`@0o`00503oool00`000000oooo
0?ooo`0G0?ooo`@0o`00803oool20?l00280oooo0P3o000T0?ooo`<0o`006`3oool00`3o0000oooo
0?ooo`0m0?ooo`009@3oool20?l001@0oooo0`3o00030?ooo`80o`00C03oool20?l001l0oooo103o
000F0?ooo`030000003oool0oooo01P0oooo103o000P0?ooo`030?l0003oool0oooo0200oooo0P3o
000U0?ooo`<0o`006P3oool20?l003h0oooo000U0?ooo`030?l0003oool0oooo0140oooo103o0003
0?ooo`<0o`00C03oool00`3o0000oooo0?ooo`0M0?ooo`@0o`005`3oool00`000000oooo0?ooo`0J
0?ooo`<0o`007`3oool20?l00240oooo0`3o000U0?ooo`@0o`00603oool20?l003h0oooo000T0?oo
o`80o`004P3oool40?l000@0oooo0P3o001<0?ooo`80o`00103ooolT0?l00180oooo00<000000?oo
o`3oool06`3oool30?l001l0oooo00<0o`000?ooo`3oool0803oool20?l002H0oooo103o000G0?oo
o`<0o`00?@3oool002@0oooo00<0o`000?ooo`3oool0403oool30?l000H0oooo0P3o001;0?oooc00
o`003@3oool00`000000oooo0?ooo`0L0?ooo`<0o`007P3oool20?l00240oooo0`3o000W0?ooo`<0
o`005`3oool20?l003d0oooo000S0?ooo`80o`004@3oool30?l000L0oooo0P3o00180?ooo`X0o`00
5`3oool40?l000T0oooo2@3o00090?ooo`030000003oool0oooo0140oooo7`3o000>0?ooo`030?l0
003oool0oooo0200oooo0P3o000X0?ooo`<0o`005P3oool30?l003`0oooo000S0?ooo`030?l0003o
ool0oooo00h0oooo103o00070?ooo`<0o`00@`3oool;0?l001T0oooo103o000@0?ooo`T0o`00103o
ool00`000000oooo0?ooo`0:0?ooobh0o`001P3oool20?l00240oooo0P3o000Y0?ooo`<0o`005P3o
ool20?l003`0oooo000S0?ooo`030?l0003oool0oooo00d0oooo103o00080?ooo`80o`00?`3oool:
0?l00080oooo00<0o`000?ooo`3oool06@3oool40?l001D0oooo2@3o00000`000000oooo0?ooo`03
0?ooo`h0o`003P3oool30?l000h0oooo3@3o00020?ooo`030?l0003oool0oooo01l0oooo0P3o000Z
0?ooo`@0o`00503oool20?l003`0oooo000R0?ooo`80o`003P3oool30?l000X0oooo0P3o000l0?oo
o`P0o`001P3oool20?l001X0oooo0`3o000L0?oooa40o`005P3oool40?l001@0oooo2`3o000N0?oo
o`<0o`00:P3oool40?l001<0oooo0`3o000k0?ooo`008P3oool00`3o0000oooo0?ooo`0<0?ooo`<0
o`002`3oool20?l003X0oooo1P3o00090?ooo`80o`006P3oool30?l00200oooo1`3o000N0?ooo`@0
o`00603oool:0?l001/0oooo0P3o000/0?ooo`<0o`004`3oool20?l003/0oooo000Q0?ooo`80o`00
3@3oool30?l000/0oooo0`3o000g0?ooo`H0o`00303oool00`3o0000oooo0?ooo`0H0?ooo`<0o`00
7`3oool;0?l001h0oooo0`3o000K0?ooo`030?l0003oool0o`0000H0o`00603oool20?l002d0oooo
0`3o000B0?ooo`<0o`00>P3oool00240oooo00<0o`000?ooo`3oool02`3oool30?l000`0oooo0P3o
000f0?ooo`H0o`003@3oool20?l001T0oooo0`3o000M0?ooo`H0o`0000<000000?ooo`3oool00P3o
ool50?l001d0oooo0`3o000J0?ooo`80o`00103oool60?l001D0oooo0`3o000]0?ooo`@0o`004@3o
ool20?l003X0oooo000P0?ooo`80o`00303oool30?l000d0oooo0P3o000d0?ooo`D0o`003`3oool2
0?l001T0oooo0`3o000L0?ooo`H0o`000P3oool00`000000oooo0?ooo`040?ooo`H0o`006`3oool3
0?l001X0oooo00<0o`000?ooo`3oool01@3oool60?l001<0oooo0P3o000^0?ooo`@0o`00403oool2
0?l003X0oooo000P0?ooo`80o`002`3oool30?l000h0oooo0P3o000a0?ooo`H0o`004@3oool00`3o
0000oooo0?ooo`0G0?ooo`<0o`006P3oool60?l000D0oooo00<000000?ooo`3oool01P3oool60?l0
01X0oooo0`3o000I0?ooo`80o`002@3oool50?l00140oooo0P3o000`0?ooo`<0o`003`3oool30?l0
03T0oooo000P0?ooo`80o`002P3oool30?l000l0oooo0P3o000_0?ooo`H0o`004P3oool20?l001T0
oooo0P3o000I0?ooo`H0o`001`3oool00`000000oooo0?ooo`090?ooo`D0o`006@3oool20?l001X0
oooo00<0o`000?ooo`3oool02@3oool50?l000l0oooo0P3o000a0?ooo`<0o`003`3oool20?l003T0
oooo000O0?ooo`<0o`002@3oool30?l00100oooo0P3o000/0?ooo`H0o`005@3oool00`3o0000oooo
0?ooo`0G0?ooo`80o`00603oool50?l000X0oooo00<000000?ooo`3oool02`3oool50?l001P0oooo
0P3o000I0?ooo`80o`00303oool50?l000d0oooo0P3o000b0?ooo`<0o`003P3oool30?l003P0oooo
000O0?ooo`80o`002@3oool30?l00140oooo0P3o000Z0?ooo`H0o`005P3oool20?l001P0oooo0`3o
000F0?ooo`D0o`00303oool00`000000oooo0?ooo`0=0?ooo`H0o`005P3oool20?l001T0oooo00<0
o`000?ooo`3oool0303oool60?l000/0oooo0P3o000b0?ooo`<0o`003P3oool20?l003P0oooo000O
0?ooo`80o`00203oool30?l00180oooo0P3o000X0?ooo`D0o`00603oool20?l001P0oooo0`3o000E
0?ooo`D0o`003P3oool00`000000oooo0?ooo`0?0?ooo`H0o`005@3oool20?l001P0oooo0P3o000?
0?ooo`H0o`002@3oool20?l003<0oooo0`3o000=0?ooo`80o`00>03oool001l0oooo0P3o00070?oo
o`<0o`004`3oool20?l002L0oooo103o000J0?ooo`030?l0003oool0oooo01H0oooo0`3o000D0?oo
o`D0o`00403oool00`000000oooo0?ooo`0B0?ooo`D0o`00503oool00`3o0000oooo0?ooo`0F0?oo
o`80o`004P3oool50?l000L0oooo0P3o000d0?ooo`<0o`00303oool20?l003P0oooo000N0?ooo`<0
o`001`3oool20?l001<0oooo0P3o000V0?ooo`@0o`006`3oool20?l001L0oooo0`3o000B0?ooo`/0
o`003@3oool00`000000oooo0?ooo`0D0?ooo`@0o`004`3oool20?l001P0oooo0P3o000C0?ooo`D0
o`001@3oool20?l003D0oooo0`3o000;0?ooo`<0o`00=`3oool001h0oooo0P3o00070?ooo`80o`00
503oool20?l002@0oooo1@3o000K0?ooo`<0o`005P3oool30?l000H0oooo9P3o00070?oooa@0o`00
4`3oool20?l001L0oooo0`3o000D0?ooo`D0o`000`3oool20?l003H0oooo0`3o000;0?ooo`80o`00
=`3oool001h0oooo0P3o00060?ooo`80o`005@3oool20?l002<0oooo103o000M0?ooo`80o`005`3o
ool20?l000@0oooo4P3o00080?ooobl0o`003`3oool00`3o0000oooo0?ooo`0E0?ooo`<0o`005P3o
ool40?l00080oooo0P3o000g0?ooo`<0o`002P3oool20?l003L0oooo000N0?ooo`80o`001P3oool0
0`3o0000oooo0?ooo`0D0?ooo`80o`008@3oool40?l001l0oooo0P3o000F0?ooo`80o`0000<0oooo
0?l0003o00001@3o00090?ooo`@0o`004P3ooolA0?l00100oooo303o00090?ooo`80o`005`3oool2
0?l001P0oooo103o00000`3oool0o`000?l0000g0?ooo`<0o`002@3oool20?l003L0oooo000M0?oo
o`<0o`001@3oool20?l001H0oooo0P3o000O0?ooo`D0o`007`3oool30?l001D0oooo203o000;0?oo
o`@0o`003@3oool:0?l00080oooo00<000000?ooo`3oool01@3oool60?l000l0oooo0`3o00000`3o
ool0o`000?l0000:0?l000@0oooo0P3o000F0?ooo`<0o`00603oool60?l003P0oooo0`3o00080?oo
o`<0o`00=P3oool001d0oooo0P3o00050?ooo`80o`005`3oool20?l001h0oooo103o000Q0?ooo`80
o`005@3oool60?l000`0oooo103o000<0?ooo`T0o`001P3oool00`000000oooo0?ooo`080?ooo`H0
o`003@3oool30?l000H0oooo2@3o00020?ooo`80o`005P3oool20?l001X0oooo103o000i0?ooo`80
o`002@3oool20?l003H0oooo000M0?ooo`80o`001@3oool00`3o0000oooo0?ooo`0F0?ooo`80o`00
703oool40?l00280oooo0`3o000B0?ooo`H0o`003P3oool40?l000X0oooo7P3o00000`3oool0o`00
0?l000050?l000/0oooo103o000:0?ooo`L0o`005P3oool30?l001/0oooo103o000h0?ooo`80o`00
203oool20?l003H0oooo000M0?ooo`80o`00103oool20?l001P0oooo0P3o000J0?ooo`D0o`008`3o
ool20?l00100oooo1`3o000?0?ooo`<0o`002@3oool/0?l000T0oooo103o000;0?ooo`H0o`005P3o
ool20?l001/0oooo1P3o000g0?ooo`80o`001`3oool30?l003D0oooo000L0?ooo`<0o`000`3oool2
0?l001P0oooo0P3o000J0?ooo`@0o`009@3oool20?l000h0oooo203o000>0?ooo`@0o`00203oool;
0?l000`0oooo00<000000?ooo`3oool02@3oool=0?l000T0oooo0`3o000=0?ooo`H0o`004`3oool3
0?l001X0oooo0P3o00000`3oool0o`000?l000020?l003L0oooo00<0o`000?ooo`3oool01P3oool2
0?l003D0oooo000L0?ooo`80o`00103oool00`3o0000oooo0?ooo`0G0?ooo`80o`00603oool40?l0
02H0oooo0`3o000;0?ooo`H0o`000`3oool00`3o0000oooo0?ooo`0<0?ooo`@0o`000`3oool90?l0
01@0oooo00<000000?ooo`3oool04@3oool90?l000H0oooo0`3o000>0?ooo`L0o`004@3oool20?l0
01X0oooo0P3o00030?ooo`@0o`00=@3oool20?l000L0oooo0P3o000e0?ooo`00703oool20?l000<0
oooo0P3o000I0?ooo`80o`005`3oool40?l002L0oooo0P3o000:0?ooo`H0o`00103oool20?l000d0
oooo0`3o00030?ooo`T0o`005P3oool00`000000oooo0?ooo`0D0?ooo`T0o`00103oool30?l000l0
oooo1`3o000?0?ooo`80o`006`3oool20?l000<0oooo1@3o000d0?ooo`030?l0003oool0oooo00D0
oooo0P3o000e0?ooo`00703oool20?l00080oooo0P3o000J0?ooo`80o`005@3oool40?l002T0oooo
0P3o00080?ooo`D0o`001P3oool20?l000d0oooo0`3o00000`3oool0o`000?l000070?l001T0oooo
00<000000?ooo`3oool05`3oool90?l00080oooo0`3o000>0?ooo`80o`000P3oool60?l000`0oooo
0`3o000J0?ooo`80o`001@3oool40?l003<0oooo0P3o00060?ooo`<0o`00=03oool001`0oooo0P3o
00020?ooo`030?l0003oool0oooo01T0oooo0P3o000D0?ooo`@0o`00:@3oool30?l000H0oooo1@3o
00070?ooo`80o`003@3oool<0?l001/0oooo00<000000?ooo`3oool06@3oool90?l000030?ooo`3o
0000o`000080o`003@3oool20?l000<0oooo1P3o000;0?ooo`80o`006P3oool20?l000L0oooo103o
000b0?ooo`80o`001P3oool20?l003@0oooo000K0?ooo`80o`000P3oool20?l001/0oooo0P3o000C
0?ooo`<0o`00:`3oool20?l000D0oooo1@3o00090?ooo`030?l0003oool0oooo00X0oooo303o000M
0?ooo`030000003oool0oooo01/0oooo3@3o000=0?ooo`030?l0003oool0oooo00@0oooo1@3o0009
0?ooo`<0o`006@3oool20?l000P0oooo103o000b0?ooo`030?l0003oool0oooo00@0oooo0P3o000d
0?ooo`006`3oool20?l000030?ooo`3o0000o`0001`0oooo0P3o000B0?ooo`<0o`00:`3oool30?l0
00<0oooo1@3o000:0?ooo`80o`002`3oool<0?l001h0oooo00<000000?ooo`3oool07@3oool<0?l0
00`0oooo0P3o00070?ooo`D0o`00203oool20?l001T0oooo0P3o000:0?ooo`<0o`00<@3oool20?l0
00D0oooo0P3o000d0?ooo`006`3oool20?l000030?ooo`3o0000oooo01`0oooo0P3o000@0?ooo`@0
o`00;03oool20?l00080oooo1@3o000<0?ooo`030?l0003oool0oooo00T0oooo1P3o00000`3oool0
o`000?l000020?l00200oooo00<000000?ooo`3oool07`3oool40?l000030?ooo`3o0000o`0000@0
o`00303oool00`3o0000oooo0?ooo`070?ooo`D0o`001P3oool20?l001X0oooo0P3o000:0?ooo`@0
o`00<03oool20?l000@0oooo0P3o000d0?ooo`006`3oool40?l001d0oooo0P3o000?0?ooo`@0o`00
;@3oool70?l000d0oooo0P3o00090?ooo`H0o`0000<0oooo0?l0003o00000P3o000R0?ooo`030000
003oool0oooo0200oooo103o00020?ooo`D0o`002`3oool20?l000X0oooo1@3o00040?ooo`80o`00
6P3oool20?l000/0oooo103o000`0?ooo`030?l0003oool0oooo0080oooo0`3o000c0?ooo`006`3o
ool30?l001h0oooo0P3o000>0?ooo`<0o`00;P3oool60?l000h0oooo0P3o00080?ooo`H0o`000P3o
ool40?l002<0oooo00<000000?ooo`3oool08P3oool40?l000030?ooo`3o0000o`0000<0o`002`3o
ool20?l000/0oooo103o00030?ooo`<0o`006@3oool20?l000d0oooo0`3o000_0?ooo`80o`00103o
ool20?l003<0oooo000J0?ooo`<0o`007`3oool20?l000d0oooo0`3o000_0?ooo`@0o`00403oool0
0`3o0000oooo0?ooo`050?ooo`H0o`000P3oool40?l002D0oooo00<000000?ooo`3oool08`3oool4
0?l00080oooo103o000;0?ooo`030?l0003oool0oooo00/0oooo103o00020?ooo`80o`006@3oool2
0?l000h0oooo0`3o000_0?ooo`80o`000`3oool20?l003<0oooo000J0?ooo`<0o`007`3oool20?l0
00/0oooo103o000^0?ooo`@0o`004@3oool20?l000H0oooo1P3o00020?ooo`@0o`009P3oool00`00
0000oooo0?ooo`0U0?ooo`@0o`000P3oool40?l000T0oooo0P3o000=0?ooo`@0o`0000<0oooo0?l0
003o00006@3oool20?l000l0oooo103o000^0?ooo`040?l0003oool0oooo0?ooo`80o`00<`3oool0
01X0oooo0P3o000P0?ooo`80o`002P3oool40?l002h0oooo1@3o000A0?ooo`030?l0003oool0oooo
00<0oooo1`3o00000`3oool0o`000?l000020?l002P0oooo00<000000?ooo`3oool09P3oool40?l0
0080oooo1@3o00080?ooo`030?l0003oool0oooo00d0oooo1@3o000I0?ooo`80o`00403oool40?l0
02d0oooo0P3o00020?ooo`80o`00<`3oool001X0oooo0P3o000P0?ooo`80o`002@3oool30?l002h0
oooo1`3o000@0?ooo`80o`00103oool40?l000040?ooo`3o0000o`000?ooo`@0o`00:@3oool00`00
0000oooo0?ooo`0X0?ooo`<0o`000P3oool50?l000L0oooo0P3o000?0?ooo`D0o`00603oool20?l0
0180oooo0`3o000]0?ooo`040?l0003oool0oooo0?ooo`80o`00<P3oool001T0oooo0`3o000P0?oo
o`80o`00203oool30?l002h0oooo103o00000`3oool0o`000?l0000@0?ooo`80o`000`3oool40?l0
0080oooo0P3o0000103oool0o`000?l0003o000[0?ooo`030000003oool0oooo02T0oooo0`3o0002
0?ooo`H0o`001P3oool20?l000l0oooo103o000H0?ooo`80o`004`3oool30?l002`0oooo0P3o0002
0?ooo`80o`00<P3oool001T0oooo0P3o000Q0?ooo`80o`001P3oool40?l002d0oooo103o00030?oo
o`80o`00403oool0103o0000oooo0?ooo`3oool40?l00080oooo1P3o000/0?ooo`030000003oool0
oooo02X0oooo2`3o00060?ooo`030?l0003oool0oooo00l0oooo103o000F0?ooo`80o`00503oool3
0?l002`0oooo0P3o00000`3oool0o`000?l0000b0?ooo`00603oool30?l00240oooo0P3o00050?oo
o`@0o`00;@3oool40?l000@0oooo0P3o000?0?ooo`80o`0000<0oooo0?l0003o00000P3o00030?oo
o`H0o`00;@3oool00`000000oooo0?ooo`0[0?ooo`L0o`0000<0oooo0?l0003o00000P3o00040?oo
o`80o`00403oool50?l001D0oooo0P3o000E0?ooo`<0o`00;03oool0103o0000oooo0?l0003o000b
0?ooo`005`3oool40?l00240oooo0P3o00040?ooo`<0o`00;@3oool40?l000D0oooo0`3o000?0?oo
o`030?l0003oool0o`0000<0o`000`3oool50?l002l0oooo00<000000?ooo`3oool0;@3oool60?l0
00030?ooo`3o0000o`000080o`00103oool00`3o0000oooo0?ooo`0>0?ooo`80o`0000@0oooo0?l0
003o0000o`00503oool20?l001H0oooo0`3o000[0?ooo`@0o`00<P3oool001L0oooo00@0o`000?oo
o`3o0000o`008P3oool20?l00080oooo0`3o000]0?ooo`@0o`001P3oool20?l000l0oooo1@3o0005
0?ooo`@0o`00<03oool00`000000oooo0?ooo`0^0?ooo`D0o`000`3oool40?l00080oooo0P3o000?
0?ooo`<0o`0000<0oooo0?l0003o00000P3o000B0?ooo`80o`005`3oool30?l002/0oooo0`3o000b
0?ooo`005P3oool20?l000030?ooo`3o0000o`000280oooo0P3o00020?ooo`80o`00;@3oool30?l0
00P0oooo0P3o000?0?ooo`@0o`001@3oool40?l00340oooo00<000000?ooo`3oool0;`3oool50?l0
00<0oooo103o00020?ooo`030?l0003oool0oooo00h0oooo0P3o00020?ooo`@0o`004@3oool20?l0
01P0oooo0`3o000Z0?ooo`<0o`00<P3oool001H0oooo0P3o00000`3oool0o`000?l0000R0?ooo`80
o`0000<0oooo0?l0003o0000;@3oool30?l000T0oooo0P3o000>0?ooo`@0o`001@3oool40?l00380
oooo00<000000?ooo`3oool0<03oool50?l000@0oooo0`3o00000`3oool0o`000?l0000?0?ooo`80
o`00103oool30?l00100oooo0P3o000I0?ooo`<0o`00:P3oool20?l00380oooo000E0?ooo`<0o`00
00<0oooo0?l0003o00008P3oool50?l002`0oooo0`3o00090?ooo`<0o`003@3oool40?l000H0oooo
0`3o000c0?ooo`030000003oool0oooo0340oooo103o00050?ooo`<0o`0000<0oooo0?l0003oool0
3P3oool20?l000D0oooo0`3o000?0?ooo`80o`006P3oool30?l002T0oooo0P3o000b0?ooo`005@3o
ool20?l00080oooo0P3o000R0?ooo`@0o`00;03oool30?l000X0oooo0P3o000=0?ooo`@0o`001P3o
ool30?l003@0oooo00<000000?ooo`3oool0<P3oool40?l000D0oooo103o000?0?ooo`80o`001P3o
ool30?l000h0oooo0P3o000K0?ooo`<0o`00:03oool30?l00340oooo000D0?ooo`<0o`000P3oool2
0?l00280oooo0`3o000/0?ooo`<0o`002`3oool20?l000`0oooo103o00060?ooo`<0o`00=@3oool0
0`000000oooo0?ooo`0c0?ooo`<0o`001P3oool40?l000l0oooo0P3o00060?ooo`<0o`003@3oool2
0?l001`0oooo0`3o000W0?ooo`@0o`00<03oool001@0oooo0P3o00030?ooo`80o`008@3oool30?l0
02`0oooo0`3o000<0?ooo`80o`002`3oool50?l000D0oooo103o000e0?ooo`030000003oool0oooo
03@0oooo0`3o00060?ooo`@0o`003P3oool20?l000L0oooo0`3o000<0?ooo`80o`007@3oool30?l0
02H0oooo103o000`0?ooo`00503oool20?l000<0oooo0P3o000Q0?ooo`@0o`00:@3oool40?l000`0
oooo0`3o00090?ooo`H0o`001P3oool30?l003H0oooo00<000000?ooo`3oool0=@3oool30?l000L0
oooo0`3o000=0?ooo`80o`00203oool30?l000/0oooo0P3o000N0?ooo`<0o`009@3oool40?l00300
oooo000C0?ooo`<0o`000`3oool20?l00200oooo0P3o00000`3oool0o`000?l0000X0?ooo`@0o`00
3@3oool20?l000T0oooo1`3o00050?ooo`<0o`00=`3oool00`000000oooo0?ooo`0f0?ooo`80o`00
203oool30?l000`0oooo0P3o00090?ooo`@0o`002@3oool20?l001l0oooo0`3o000T0?ooo`D0o`00
;`3oool001<0oooo0P3o00040?ooo`80o`007`3oool30?l000030?ooo`3o0000o`0002L0oooo0`3o
000?0?ooo`80o`00203oool30?l00080oooo0P3o00050?ooo`<0o`00>03oool00`000000oooo0?oo
o`0g0?ooo`80o`001`3oool40?l000/0oooo0P3o000:0?ooo`@0o`00203oool20?l00200oooo0`3o
000S0?ooo`80o`0000<0oooo0?l0003o0000;`3oool00180oooo0`3o00040?ooo`80o`007P3oool3
0?l00080oooo0P3o000V0?ooo`<0o`00403oool20?l000L0oooo0`3o00030?ooo`80o`00103oool3
0?l003T0oooo00<000000?ooo`3oool0>03oool20?l000L0oooo103o000:0?ooo`80o`00303oool3
0?l000L0oooo0P3o000Q0?ooo`80o`008`3oool20?l000040?ooo`3o0000o`000?l002h0oooo000B
0?ooo`80o`001@3oool20?l001d0oooo0`3o00030?ooo`80o`009@3oool30?l00140oooo0P3o0006
0?ooo`<0o`000`3oool30?l000@0oooo0P3o000j0?ooo`030000003oool0oooo03T0oooo0P3o0006
0?ooo`D0o`002@3oool20?l000d0oooo0`3o00060?ooo`80o`008P3oool20?l00280oooo0P3o0002
0?ooo`80o`00;P3oool00180oooo0P3o00050?ooo`80o`00703oool30?l000@0oooo0P3o000T0?oo
o`<0o`004P3oool20?l000H0oooo0P3o00040?ooo`80o`00103oool20?l003/0oooo00<000000?oo
o`3oool0>@3oool20?l000H0oooo0P3o0000103oool0o`000?l0003o00080?ooo`80o`003P3oool3
0?l000D0oooo0P3o000R0?ooo`<0o`008@3oool20?l00080oooo0`3o000]0?ooo`004@3oool30?l0
00D0oooo0P3o000K0?ooo`<0o`001@3oool20?l002<0oooo0`3o000C0?ooo`80o`001@3oool20?l0
00@0oooo0`3o00030?ooo`<0o`00>`3oool00`000000oooo0?ooo`0j0?ooo`80o`001@3oool20?l0
0080oooo0`3o00070?ooo`80o`003`3oool30?l000@0oooo0P3o000S0?ooo`<0o`00803oool20?l0
00<0oooo0P3o000]0?ooo`004@3oool20?l000H0oooo0P3o000J0?ooo`<0o`001`3oool20?l00240
oooo0`3o000C0?ooo`80o`001@3oool30?l000@0oooo0P3o00030?ooo`<0o`00?03oool00`000000
oooo0?ooo`0j0?ooo`<0o`00103oool30?l00080oooo0`3o00070?ooo`80o`003`3oool30?l000<0
oooo0P3o000T0?ooo`<0o`007`3oool20?l000<0oooo0P3o000]0?ooo`004@3oool20?l000L0oooo
0P3o000I0?ooo`80o`00203oool20?l00200oooo0`3o000D0?ooo`80o`00103oool30?l000D0oooo
0P3o00020?ooo`@0o`00?03oool00`000000oooo0?ooo`0k0?ooo`<0o`00103oool20?l000<0oooo
0`3o00060?ooo`80o`00403oool30?l00080oooo0P3o000U0?ooo`<0o`007P3oool20?l000<0oooo
0`3o000/0?ooo`00403oool30?l000L0oooo0P3o000H0?ooo`80o`002@3oool20?l00200oooo0P3o
000E0?ooo`80o`000`3oool30?l000H0oooo0P3o00000`3oool0o`000?l000020?l003d0oooo00<0
00000?ooo`3oool0>`3oool40?l000<0oooo0P3o00040?ooo`<0o`001@3oool20?l00140oooo0`3o
00000`3oool0o`000?l0000V0?ooo`80o`007P3oool20?l000@0oooo0P3o000/0?ooo`00403oool2
0?l000P0oooo0P3o000G0?ooo`<0o`002@3oool20?l001l0oooo0P3o000F0?ooo`80o`000P3oool3
0?l000H0oooo0`3o00000`3oool0o`000?l000020?l003d0oooo00<000000?ooo`3oool0?03oool0
0`3o0000oooo0?l000030?ooo`<0o`00103oool30?l000@0oooo0P3o000B0?ooo`80o`0000<0oooo
0?l0003o00009`3oool20?l001d0oooo0P3o00040?ooo`<0o`00:`3oool00100oooo0P3o00080?oo
o`80o`005P3oool30?l000X0oooo0P3o000N0?ooo`<0o`005P3oool20?l00080oooo0P3o00070?oo
o`80o`0000D0oooo0?l0003o0000oooo0?l0000n0?ooo`030000003oool0oooo03`0oooo103o0003
0?ooo`80o`001@3oool20?l000@0oooo0P3o000C0?ooo`@0o`00:03oool20?l001`0oooo0P3o0005
0?ooo`80o`00:`3oool000l0oooo0`3o00080?ooo`80o`005@3oool30?l000/0oooo0P3o000M0?oo
o`<0o`005`3oool20?l000030?ooo`3o0000o`0000P0oooo1`3o000n0?ooo`030000003oool0oooo
03d0oooo00<0o`000?ooo`3o00000`3oool20?l000H0oooo0P3o00030?ooo`80o`004`3oool40?l0
02T0oooo00<0o`000?ooo`3oool06P3oool20?l000D0oooo0P3o000[0?ooo`003`3oool20?l000T0
oooo0P3o000E0?ooo`80o`00303oool20?l001`0oooo0`3o000H0?ooo`D0o`00203oool40?l00003
0?ooo`3o0000oooo03h0oooo00<000000?ooo`3oool0?@3oool40?l00080oooo0P3o00070?ooo`80
o`000P3oool20?l001@0oooo0`3o000Y0?ooo`80o`006`3oool20?l000D0oooo0`3o000Z0?ooo`00
3`3oool20?l000T0oooo0P3o000D0?ooo`80o`003@3oool30?l001/0oooo0P3o000I0?ooo`@0o`00
203oool40?l000030?ooo`3o0000o`0003l0oooo00<000000?ooo`3oool0?P3oool00`3o0000oooo
0?l000020?ooo`<0o`001`3oool20?l000030?ooo`3o0000o`0001D0oooo0`3o000Y0?ooo`030?l0
003oool0oooo01T0oooo0P3o00060?ooo`80o`00:P3oool000l0oooo0P3o00090?ooo`80o`00503o
ool00`3o0000oooo0?ooo`0=0?ooo`80o`006P3oool20?l001T0oooo103o00090?ooo`<0o`000P3o
ool00`3o0000oooo0?ooo`0n0?ooo`030000003oool0oooo03h0oooo103o00020?ooo`80o`00203o
ool0103o0000oooo0?l0003o000E0?ooo`<0o`00:@3oool20?l001X0oooo0P3o00060?ooo`80o`00
:P3oool000h0oooo0`3o00090?ooo`80o`004`3oool20?l000l0oooo0P3o000I0?ooo`<0o`006@3o
ool30?l000X0oooo0`3o00000`3oool0o`000?l000100?ooo`030000003oool0oooo03h0oooo0P3o
0000103oool0o`000?l0003oool20?l000P0oooo103o000E0?ooo`@0o`00:@3oool20?l001T0oooo
0P3o00060?ooo`80o`00:P3oool000h0oooo0P3o000;0?ooo`80o`004@3oool20?l00100oooo0P3o
000H0?ooo`<0o`006P3oool20?l000X0oooo0`3o00020?ooo`80o`00@03oool00`000000oooo0?oo
o`0n0?ooo`<0o`0000<0oooo0?l0003oool00P3o00090?ooo`<0o`00503oool20?l000040?ooo`3o
0000o`000?l002T0oooo00<0o`000?ooo`3oool05`3oool20?l000H0oooo0`3o000Y0?ooo`003P3o
ool20?l000/0oooo0P3o000A0?ooo`030?l0003oool0oooo00l0oooo0`3o000G0?ooo`80o`006`3o
ool20?l000X0oooo0`3o00000`3oool0o`000?l000110?ooo`030000003oool0oooo03l0oooo0P3o
00000`3oool0o`000?l000020?l000X0oooo0P3o000D0?ooo`80o`000P3oool30?l002P0oooo0P3o
000H0?ooo`80o`001`3oool20?l002T0oooo000=0?ooo`<0o`002`3oool20?l00100oooo0P3o000B
0?ooo`80o`005P3oool20?l001/0oooo0`3o000:0?ooo`80o`000P3oool20?l00440oooo00<00000
0?ooo`3oool0?`3oool20?l00080oooo00@0o`000?ooo`3o0000o`002@3oool20?l001@0oooo0P3o
00030?ooo`<0o`00:03oool00`3o0000oooo0?ooo`0F0?ooo`80o`001`3oool20?l002T0oooo000=
0?ooo`80o`00303oool20?l00100oooo00<0o`000?ooo`3oool04@3oool20?l001D0oooo0`3o000K
0?ooo`<0o`002P3oool20?l000040?ooo`3o0000o`000?l00440oooo00<000000?ooo`3oool0?`3o
ool30?l000030?ooo`3o0000o`000080o`002@3oool30?l001<0oooo0P3o00040?ooo`80o`00:03o
ool20?l001H0oooo0P3o00080?ooo`<0o`00:03oool000d0oooo0P3o000<0?ooo`80o`003`3oool2
0?l001<0oooo0P3o000E0?ooo`80o`006`3oool40?l000T0oooo0`3o00000`3oool0o`000?l00012
0?ooo`030000003oool0oooo0400oooo0P3o00020?ooo`<0o`002@3oool40?l00180oooo0P3o0005
0?ooo`80o`00:03oool20?l001D0oooo0P3o00090?ooo`80o`00:03oool000`0oooo0`3o000<0?oo
o`80o`003`3oool00`3o0000oooo0?ooo`0B0?ooo`<0o`004`3oool20?l001/0oooo0P3o00000`3o
ool0o`000?l000090?ooo`80o`000P3oool20?l00480oooo00<000000?ooo`3oool0@03oool30?l0
00040?ooo`3o0000o`000?l000T0oooo0P3o00000`3oool0o`000?ooo`0@0?ooo`80o`001P3oool3
0?l002P0oooo00<0o`000?ooo`3oool04`3oool20?l000T0oooo0P3o000X0?ooo`00303oool20?l0
00d0oooo0P3o000>0?ooo`80o`005@3oool20?l00180oooo0P3o000L0?ooo`030?l0003oool0oooo
0080o`00203oool30?l000040?ooo`3o0000o`000?l00480oooo00<000000?ooo`3oool0@@3oool2
0?l00080oooo0P3o00090?ooo`80o`0000<0oooo0?l0003o0000403oool20?l000L0oooo0P3o000X
0?ooo`80o`00503oool20?l000T0oooo0P3o000X0?ooo`00303oool20?l000d0oooo0`3o000<0?oo
o`80o`005P3oool20?l00180oooo00<0o`000?ooo`3oool06P3oool20?l00080oooo0P3o00080?oo
o`<0o`0000<0oooo0?l0003o0000@`3oool00`000000oooo0?ooo`110?ooo`80o`000P3oool20?l0
00T0oooo0P3o00020?ooo`030?l0003oool0oooo00h0oooo0P3o00080?ooo`80o`00:03oool20?l0
01<0oooo0P3o000:0?ooo`80o`009`3oool000`0oooo0P3o000>0?ooo`80o`00303oool00`3o0000
oooo0?ooo`0E0?ooo`80o`004@3oool20?l001/0oooo0P3o00030?ooo`80o`001`3oool40?l00003
0?ooo`3o0000o`0004<0oooo00<000000?ooo`3oool0@@3oool30?l000030?ooo`3o0000o`0000T0
oooo0P3o00020?ooo`80o`003`3oool20?l000T0oooo00<0o`000?ooo`3oool09`3oool00`3o0000
oooo0?ooo`0A0?ooo`80o`002P3oool20?l002L0oooo000<0?ooo`80o`003P3oool20?l000/0oooo
0P3o000G0?ooo`<0o`00403oool00`3o0000oooo0?ooo`0J0?ooo`030?l0003oool0oooo0080oooo
0P3o00070?ooo`030?l0003oool0o`0000@0o`00@`3oool00`000000oooo0?ooo`120?ooo`80o`00
00@0oooo0?l0003o0000o`00203oool20?l000<0oooo00<0o`000?ooo`3oool03@3oool20?l000T0
oooo0P3o000X0?ooo`80o`004P3oool20?l000X0oooo0P3o000W0?ooo`00303oool20?l000h0oooo
0P3o000;0?ooo`030?l0003oool0oooo01L0oooo0P3o000?0?ooo`80o`006`3oool20?l000@0oooo
0P3o00060?ooo`@0o`0000<0oooo0?l0003o0000A03oool00`000000oooo0?ooo`120?ooo`80o`00
00@0oooo0?l0003o0000o`00203oool20?l000<0oooo0P3o000>0?ooo`80o`002P3oool20?l002P0
oooo00<0o`000?ooo`3oool03`3oool20?l000/0oooo0P3o000W0?ooo`00303oool20?l000h0oooo
0`3o00090?ooo`80o`006@3oool20?l000h0oooo0P3o000K0?ooo`80o`001@3oool20?l000H0oooo
00D0o`000?ooo`3o0000o`000?ooo`020?l004@0oooo00<000000?ooo`3oool0@P3oool70?l000L0
oooo0P3o00040?ooo`030?l0003oool0oooo00/0oooo0P3o000<0?ooo`030?l0003oool0oooo02H0
oooo0P3o000@0?ooo`80o`002`3oool20?l002L0oooo000<0?ooo`80o`003`3oool20?l000T0oooo
00<0o`000?ooo`3oool0603oool30?l000d0oooo00<0o`000?ooo`3oool06P3oool00`3o0000oooo
0?ooo`040?ooo`80o`001@3oool20?l000030?ooo`3o0000o`0000<0o`00A03oool00`000000oooo
0?ooo`130?ooo`80o`0000@0oooo0?l0003o0000o`001`3oool20?l000@0oooo0P3o000<0?ooo`80
o`00303oool20?l002P0oooo0P3o000?0?ooo`80o`002`3oool20?l002L0oooo000<0?ooo`80o`00
3`3oool20?l000P0oooo0P3o000K0?ooo`80o`00303oool20?l001/0oooo0P3o00070?ooo`80o`00
103oool00`3o0000oooo0?ooo`040?l004D0oooo00<000000?ooo`3oool0@`3oool20?l000030?oo
o`3o0000o`000080o`001P3oool20?l000D0oooo0P3o000:0?ooo`<0o`003@3oool00`3o0000oooo
0?ooo`0W0?ooo`030?l0003oool0oooo00d0oooo0P3o000<0?ooo`80o`009P3oool000/0oooo0P3o
000@0?ooo`80o`00203oool00`3o0000oooo0?ooo`0J0?ooo`80o`00303oool00`3o0000oooo0?oo
o`0J0?ooo`030?l0003oool0oooo00H0oooo0P3o00030?ooo`80o`000P3oool40?l004D0oooo00<0
00000?ooo`3oool0A03oool40?l000030?ooo`3o0000oooo00D0oooo0P3o00060?ooo`030?l0003o
ool0oooo00P0oooo0P3o000>0?ooo`80o`00:03oool20?l000d0oooo0`3o000<0?ooo`80o`009P3o
ool000/0oooo0P3o000@0?ooo`<0o`001P3oool20?l001`0oooo0P3o000;0?ooo`80o`006`3oool2
0?l000P0oooo0P3o00030?ooo`80o`000P3oool40?l004D0oooo00<000000?ooo`3oool0A03oool4
0?l000030?ooo`3o0000o`0000D0oooo0P3o00060?ooo`80o`002@3oool20?l000l0oooo00<0o`00
0?ooo`3oool09`3oool20?l000`0oooo0P3o000=0?ooo`80o`009P3oool000/0oooo0P3o000A0?oo
o`80o`001P3oool00`3o0000oooo0?ooo`0K0?ooo`<0o`002@3oool20?l001/0oooo0P3o00090?oo
o`80o`000P3oool30?l00080oooo0`3o00160?ooo`030000003oool0oooo04@0oooo103o00020?oo
o`030?l0003oool0oooo00<0oooo0P3o00070?ooo`030?l0003oool0oooo00H0oooo0`3o000?0?oo
o`80o`00:@3oool00`3o0000oooo0?ooo`0:0?ooo`80o`003@3oool20?l002H0oooo000;0?ooo`80
o`004@3oool20?l000D0oooo0P3o000N0?ooo`80o`002@3oool00`3o0000oooo0?ooo`0J0?ooo`03
0?l0003oool0oooo00P0oooo0P3o00020?ooo`80o`000`3oool30?l004H0oooo00<000000?ooo`3o
ool0A03oool40?l00080oooo0P3o00040?ooo`80o`001`3oool20?l000L0oooo0P3o000A0?ooo`80
o`00:03oool20?l000/0oooo0P3o000=0?ooo`80o`009P3oool000/0oooo0P3o000A0?ooo`<0o`00
103oool00`3o0000oooo0?ooo`0M0?ooo`80o`00203oool20?l001/0oooo0P3o000:0?ooo`80o`00
0P3oool20?l000<0oooo0`3o00160?ooo`030000003oool0oooo04@0oooo103o00020?ooo`80o`00
103oool20?l000P0oooo00<0o`000?ooo`3oool01@3oool20?l00180oooo00<0o`000?ooo`3oool0
9P3oool20?l000X0oooo0`3o000=0?ooo`80o`009P3oool000/0oooo0P3o000B0?ooo`80o`00103o
ool00`3o0000oooo0?ooo`0M0?ooo`<0o`001`3oool00`3o0000oooo0?ooo`0J0?ooo`030?l0003o
ool0oooo00T0oooo0P3o0000103oool0o`000?l0003o00030?ooo`<0o`00AP3oool00`000000oooo
0?ooo`150?ooo`<0o`000P3oool30?l00080oooo0P3o00090?ooo`80o`001P3oool20?l00180oooo
0P3o000W0?ooo`<0o`002@3oool20?l000l0oooo0P3o000U0?ooo`002`3oool20?l00180oooo0P3o
00030?ooo`80o`00803oool20?l000H0oooo0P3o000K0?ooo`80o`00303oool40?l000<0oooo0`3o
00170?ooo`030000003oool0oooo04D0oooo0`3o00030?ooo`80o`000P3oool20?l000T0oooo0P3o
00060?ooo`80o`004`3oool00`3o0000oooo0?ooo`0V0?ooo`80o`002@3oool20?l000l0oooo0P3o
000U0?ooo`002`3oool20?l00180oooo0P3o00030?ooo`030?l0003oool0oooo01l0oooo0`3o0004
0?ooo`80o`00703oool00`3o0000oooo0?ooo`0;0?ooo`@0o`000`3oool30?l004L0oooo00<00000
0?ooo`3oool0A@3oool30?l000<0oooo0P3o00020?ooo`80o`002@3oool30?l000@0oooo0P3o000D
0?ooo`80o`009`3oool20?l000T0oooo0P3o000?0?ooo`80o`009@3oool000/0oooo0P3o000B0?oo
o`<0o`0000<0oooo0?l0003o00008P3oool20?l000@0oooo00<0o`000?ooo`3oool06P3oool20?l0
00d0oooo103o00030?ooo`<0o`00A`3oool00`000000oooo0?ooo`150?ooo`<0o`000`3oool20?l0
0080oooo0P3o000:0?ooo`80o`00103oool20?l001D0oooo00<0o`000?ooo`3oool09@3oool30?l0
00L0oooo0`3o000?0?ooo`80o`009@3oool000X0oooo0P3o000D0?ooo`80o`0000<0oooo0?l0003o
ool08P3oool20?l000<0oooo0P3o000L0?ooo`030?l0003oool0oooo00`0oooo0`3o00040?ooo`<0
o`00A`3oool00`000000oooo0?ooo`150?ooo`<0o`00103oool20?l000030?ooo`3o0000o`0000X0
oooo0P3o00040?ooo`80o`005@3oool20?l002L0oooo0P3o00070?ooo`80o`00403oool20?l002D0
oooo000:0?ooo`80o`00503oool40?l002<0oooo0`3o00020?ooo`030?l0003oool0oooo01/0oooo
00<0o`000?ooo`3oool0303oool30?l000@0oooo0`3o00170?ooo`030000003oool0oooo04D0oooo
0`3o00040?ooo`80o`0000<0oooo0?l0003o00002P3oool30?l00080oooo0`3o000F0?ooo`80o`00
9P3oool30?l000H0oooo0P3o000@0?ooo`80o`009@3oool000X0oooo0P3o000D0?ooo`<0o`009@3o
ool20?l000030?ooo`3o0000o`0001`0oooo0P3o000>0?ooo`<0o`001@3oool20?l004L0oooo00<0
00000?ooo`3oool0A@3oool30?l000@0oooo103o000<0?ooo`80o`000P3oool20?l001P0oooo00<0
o`000?ooo`3oool09@3oool20?l000H0oooo0P3o000@0?ooo`80o`009@3oool000X0oooo0P3o000E
0?ooo`80o`009@3oool40?l001d0oooo00<0o`000?ooo`3oool03@3oool30?l000D0oooo0P3o0017
0?ooo`030000003oool0oooo04D0oooo0`3o00040?ooo`@0o`00303oool30?l000030?ooo`3o0000
o`0001P0oooo0P3o000V0?ooo`80o`001@3oool30?l00100oooo0P3o000F0?ooo`060=nLB0000000
0000001d_`3oool0_g@00P0000000`18W=l0oooo0?ooo`040?ooo`002P3oool20?l001D0oooo0P3o
000V0?ooo`<0o`00703oool20?l000l0oooo0`3o00050?ooo`80o`00A`3oool00`000000oooo0?oo
o`150?ooo`<0o`00103oool40?l000d0oooo1@3o000I0?ooo`030?l0003oool0oooo02@0oooo0`3o
00040?ooo`80o`004@3oool20?l001L0oooo00L0okmd0000001d_ol0oooo0?noM0000000M;oo00L0
oooo000:0?ooo`80o`00503oool30?l002H0oooo0P3o000M0?ooo`030?l0003oool0oooo00h0oooo
0`3o00050?ooo`80o`00A`3oool00`000000oooo0?ooo`150?ooo`<0o`001@3oool30?l000d0oooo
103o000J0?ooo`80o`009P3oool20?l000@0oooo0P3o000A0?ooo`80o`00603oool01@3ookl0M018
04QdB01807@0_ooo00P0oooo00000`3oool000000000000700000080o`00500000040?l002D00000
0`3o000K00000080o`00400000030?l000D000000P3o002?000000<0o`001@0000020?l000h00000
103o000J00000080o`009P0000020?l000<000000`3o000A00000080o`002P00000?0?ooo`0309a8
0018B4P004RL00T0oooo000:0?ooo`80o`00503oool40?l002D0oooo0`3o000K0?ooo`80o`00403o
ool40?l000@0oooo0P3o00170?ooo`030000003oool0oooo04D0oooo0`3o00050?ooo`80o`003`3o
ool30?l001/0oooo0P3o000U0?ooo`<0o`000P3oool20?l00180oooo0P3o000G0?ooo`070?oo_`1d
0000B9cO0?ooo`3OW4P0001d0;ooo`070?ooo`002P3oool20?l001<0oooo1@3o000T0?ooo`80o`00
00<0oooo0?l0003oool06@3oool30?l000l0oooo0P3o00000`3oool0o`000?l000030?ooo`<0o`00
A`3oool00`000000oooo0?ooo`150?ooo`<0o`001@3oool30?l000h0oooo0P3o000L0?ooo`80o`00
9P3oool20?l000040?ooo`3o0000o`000?l00180oooo0P3o000F0?ooo`090?oOW01800000000001d
_`3oool0_g@00000000004P0W=oo00H0oooo000:0?ooo`80o`004`3oool20?l000040?ooo`3o0000
o`000?l002<0oooo00<0o`000?ooo`3oool00P3o000I0?ooo`80o`00403oool20?l000030?ooo`3o
0000o`0000<0oooo0`3o00170?ooo`030000003oool0oooo04D0oooo0`3o00040?ooo`@0o`003@3o
ool40?l001/0oooo0`3o000U0?ooo`80o`0000<0oooo0?l0003o00004`3oool20?l002D0oooo000:
0?ooo`80o`004`3oool20?l00080oooo0P3o000R0?ooo`80o`000`3oool00`3o0000oooo0?ooo`0G
0?ooo`80o`00403oool20?l000030?ooo`3o0000o`0000<0oooo0`3o00170?ooo`030000003oool0
oooo04D0oooo0`3o00040?ooo`@0o`003@3oool40?l001`0oooo0P3o000U0?ooo`D0o`004`3oool2
0?l002D0oooo000:0?ooo`80o`004P3oool30?l00080oooo0P3o000R0?ooo`80o`000`3oool20?l0
01L0oooo0P3o000A0?ooo`80o`0000@0oooo0?l0003o0000o`000P3oool30?l004L0oooo00<00000
0?ooo`3oool0A@3oool30?l000@0oooo1@3o000<0?ooo`@0o`00703oool30?l002D0oooo103o000C
0?ooo`80o`009@3oool000X0oooo0P3o000B0?ooo`80o`00103oool00`3o0000oooo0?ooo`0O0?oo
o`<0o`00103oool00`3o0000oooo0?ooo`0E0?ooo`80o`004@3oool20?l00080oooo0P3o00020?oo
o`<0o`00A`3oool00`000000oooo0?ooo`150?ooo`<0o`000`3oool30?l000030?ooo`3o0000o`00
00/0oooo1P3o000L0?ooo`80o`009@3oool30?l001@0oooo0P3o000U0?ooo`002P3oool20?l00180
oooo0P3o00040?ooo`80o`00803oool20?l000D0oooo0P3o000E0?ooo`<0o`004@3oool20?l00080
oooo0P3o00020?ooo`@0o`00AP3oool00`000000oooo0?ooo`150?ooo`<0o`000`3oool20?l00080
oooo0P3o000;0?ooo`80o`000P3oool20?l001`0oooo0P3o000U0?ooo`<0o`00503oool20?l002D0
oooo000:0?ooo`80o`004P3oool20?l000D0oooo00<0o`000?ooo`3oool07@3oool30?l000H0oooo
0P3o000D0?ooo`80o`004P3oool20?l00080oooo0`3o00000`3oool0o`000?l000020?l004H0oooo
00<000000?ooo`3oool0A@3oool30?l000<0oooo0P3o00020?ooo`80o`002P3oool30?l00080oooo
0`3o000K0?ooo`<0o`009@3oool20?l001@0oooo0P3o000U0?ooo`002P3oool20?l00140oooo0`3o
00050?ooo`80o`007P3oool20?l000P0oooo00<0o`000?ooo`3oool04P3oool20?l00140oooo0P3o
00040?ooo`80o`0000<0oooo0?l0003o00000P3o00160?ooo`030000003oool0oooo04D0oooo0`3o
00030?ooo`80o`000P3oool20?l000X0oooo0P3o00040?ooo`80o`00703oool20?l002@0oooo0`3o
000D0?ooo`80o`009@3oool000/0oooo0P3o000@0?ooo`80o`001`3oool00`3o0000oooo0?ooo`0L
0?ooo`80o`00203oool20?l001<0oooo0P3o000A0?ooo`80o`00103oool20?l000030?ooo`3o0000
o`000080o`00AP3oool00`000000oooo0?ooo`150?ooo`<0o`000P3oool30?l00080oooo0P3o0009
0?ooo`<0o`00103oool20?l001`0oooo0`3o000S0?ooo`@0o`004`3oool20?l002D0oooo000;0?oo
o`80o`00403oool20?l000L0oooo0P3o000L0?ooo`<0o`002@3oool00`3o0000oooo0?ooo`0A0?oo
o`80o`004@3oool20?l000@0oooo1`3o00160?ooo`030000003oool0oooo04@0oooo103o00020?oo
o`80o`000`3oool20?l000T0oooo0P3o00050?ooo`80o`007@3oool20?l00280oooo0P3o00000`3o
ool0o`000?l0000C0?ooo`80o`009@3oool000/0oooo0P3o000@0?ooo`80o`00203oool00`3o0000
oooo0?ooo`0J0?ooo`80o`002P3oool20?l00140oooo0P3o000B0?ooo`80o`001@3oool60?l004H0
oooo00<000000?ooo`3oool0A03oool40?l000040?ooo`3o0000o`000?l000<0oooo0P3o00090?oo
o`80o`001P3oool20?l001`0oooo0P3o000R0?ooo`030?l0003oool0oooo0080o`004`3oool20?l0
02D0oooo000;0?ooo`80o`00403oool20?l000P0oooo0P3o000J0?ooo`<0o`002`3oool00`3o0000
oooo0?ooo`0?0?ooo`80o`004P3oool20?l000D0oooo103o00000`3oool0o`000?l000150?ooo`03
0000003oool0oooo04@0oooo103o00000`3oool0o`000?l000040?ooo`80o`00203oool30?l000H0
oooo0P3o000L0?ooo`<0o`00803oool20?l00080oooo0`3o000B0?ooo`80o`009@3oool000/0oooo
0P3o000?0?ooo`<0o`002@3oool20?l001T0oooo0P3o000<0?ooo`80o`00403oool20?l00180oooo
0P3o00050?ooo`@0o`0000<0oooo0?l0003o0000A@3oool00`000000oooo0?ooo`140?ooo`@0o`00
00<0oooo0?l0003o0000103oool20?l000P0oooo0P3o00070?ooo`80o`007@3oool20?l00200oooo
00<0o`000?ooo`3oool00P3oool20?l00180oooo0P3o000U0?ooo`00303oool20?l000h0oooo0P3o
000;0?ooo`030?l0003oool0oooo01L0oooo0P3o000=0?ooo`80o`003`3oool20?l00180oooo0P3o
00060?ooo`<0o`0000<0oooo0?l0003o0000A@3oool00`000000oooo0?ooo`140?ooo`<0o`0000@0
oooo0?l0003o0000o`00103oool20?l000P0oooo00<0o`000?ooo`3oool01P3oool20?l001d0oooo
0P3o000P0?ooo`030?l0003oool0oooo0080oooo0P3o000B0?ooo`80o`009@3oool000`0oooo0P3o
000>0?ooo`80o`002`3oool20?l001L0oooo0`3o000>0?ooo`030?l0003oool0oooo00d0oooo0P3o
000A0?ooo`80o`001`3oool30?l000030?ooo`3o0000o`0004D0oooo00<000000?ooo`3oool0A03o
ool30?l000030?ooo`3o0000o`0000D0oooo0P3o00070?ooo`80o`00203oool20?l001d0oooo0`3o
000N0?ooo`80o`00103oool20?l00180oooo0P3o000U0?ooo`00303oool20?l000h0oooo0P3o000<
0?ooo`030?l0003oool0oooo01D0oooo0P3o000?0?ooo`80o`003@3oool20?l00180oooo0P3o0007
0?ooo`<0o`0000<0oooo0?l0003o0000A@3oool00`000000oooo0?ooo`130?ooo`L0o`001@3oool2
0?l000H0oooo0P3o000:0?ooo`80o`007@3oool20?l001h0oooo00<0o`000?ooo`3oool0103oool2
0?l00140oooo0P3o000U0?ooo`00303oool20?l000d0oooo0`3o000<0?ooo`80o`005P3oool20?l0
0100oooo0P3o000<0?ooo`80o`004P3oool20?l000P0oooo0P3o0000103oool0o`000?l0003o0014
0?ooo`030000003oool0oooo04<0oooo1P3o00060?ooo`80o`001P3oool00`3o0000oooo0?ooo`09
0?ooo`80o`007@3oool30?l001`0oooo0P3o00060?ooo`80o`00403oool20?l002H0oooo000<0?oo
o`80o`003@3oool20?l000h0oooo00<0o`000?ooo`3oool04`3oool30?l00140oooo0P3o000;0?oo
o`80o`004P3oool20?l000P0oooo0`3o00000`3oool0o`000?l000140?ooo`030000003oool0oooo
04<0oooo1P3o00060?ooo`80o`001@3oool20?l000/0oooo0P3o000N0?ooo`80o`00703oool00`3o
0000oooo0?ooo`050?ooo`80o`00403oool20?l002H0oooo000=0?ooo`80o`00303oool20?l000h0
oooo0P3o000D0?ooo`80o`004`3oool00`3o0000oooo0?ooo`090?ooo`80o`004P3oool20?l000P0
oooo0`3o00000`3oool0o`000?l000140?ooo`030000003oool0oooo0480oooo1P3o00070?ooo`80
o`00103oool20?l000`0oooo0P3o000N0?ooo`80o`006`3oool20?l000L0oooo0P3o000@0?ooo`80
o`009P3oool000d0oooo0P3o000<0?ooo`80o`003`3oool20?l001<0oooo0P3o000C0?ooo`80o`00
2@3oool30?l00180oooo0P3o00090?ooo`80o`0000@0oooo0?l0003o0000o`00@`3oool00`000000
oooo0?ooo`120?ooo`80o`0000@0oooo0?l0003o0000o`001`3oool20?l000@0oooo00<0o`000?oo
o`3oool02`3oool20?l001h0oooo0P3o000K0?ooo`030?l0003oool0oooo00H0oooo0P3o000@0?oo
o`80o`009P3oool000d0oooo0P3o000<0?ooo`80o`00403oool00`3o0000oooo0?ooo`0A0?ooo`80
o`00503oool20?l000P0oooo0P3o000C0?ooo`80o`002@3oool30?l000030?ooo`3o0000o`0004<0
oooo00<000000?ooo`3oool0@P3oool20?l000030?ooo`3o0000o`0000P0oooo0P3o00030?ooo`80
o`003P3oool20?l001h0oooo0P3o000I0?ooo`80o`002@3oool20?l000l0oooo0P3o000V0?ooo`00
3@3oool20?l000/0oooo0`3o000@0?ooo`80o`004@3oool30?l001D0oooo00<0o`000?ooo`3oool0
1P3oool20?l00180oooo0P3o000:0?ooo`<0o`0000@0oooo0?l0003o0000o`00@P3oool00`000000
oooo0?ooo`110?ooo`<0o`0000<0oooo0?l0003o0000203oool20?l000<0oooo00<0o`000?ooo`3o
ool03@3oool20?l001h0oooo0P3o000I0?ooo`030?l0003oool0oooo00P0oooo0P3o000?0?ooo`80
o`009P3oool000d0oooo0`3o000:0?ooo`80o`004P3oool00`3o0000oooo0?ooo`0?0?ooo`80o`00
5P3oool20?l000L0oooo0P3o000B0?ooo`80o`002P3oool40?l000030?ooo`3o0000o`000480oooo
00<000000?ooo`3oool0@@3oool20?l00080oooo0P3o00080?ooo`80o`000P3oool20?l000l0oooo
0P3o000N0?ooo`80o`00603oool20?l000X0oooo0P3o000?0?ooo`80o`009P3oool000h0oooo0P3o
000:0?ooo`80o`004P3oool20?l00100oooo0P3o000G0?ooo`80o`001P3oool20?l00180oooo0P3o
000:0?ooo`@0o`0000<0oooo0?l0003o0000@P3oool00`000000oooo0?ooo`100?ooo`<0o`0000@0
oooo0?l0003o0000o`00203oool20?l000030?ooo`3o0000o`000100oooo0P3o000N0?ooo`80o`00
5`3oool20?l000/0oooo0P3o000?0?ooo`80o`009P3oool000h0oooo0P3o000:0?ooo`80o`004`3o
ool20?l000h0oooo0`3o000H0?ooo`030?l0003oool0oooo00<0oooo0`3o000B0?ooo`80o`002P3o
ool40?l000040?ooo`3o0000o`000?l00440oooo00<000000?ooo`3oool0@03oool20?l00080oooo
0P3o00090?ooo`80o`0000<0oooo0?l0003oool0403oool20?l001h0oooo0P3o000G0?ooo`030?l0
003oool0oooo00X0oooo0P3o000>0?ooo`80o`009`3oool000h0oooo0P3o000:0?ooo`80o`00503o
ool00`3o0000oooo0?ooo`0<0?ooo`80o`006@3oool20?l000@0oooo0P3o000C0?ooo`80o`002P3o
ool40?l00080oooo0P3o00110?ooo`030000003oool0oooo0400oooo0P3o0000103oool0o`000?l0
003o00090?ooo`@0o`004@3oool20?l001h0oooo0P3o000F0?ooo`80o`003@3oool20?l000d0oooo
0P3o000W0?ooo`003P3oool30?l000T0oooo0P3o000D0?ooo`80o`003@3oool20?l001X0oooo0P3o
00030?ooo`80o`004`3oool20?l000/0oooo103o00000`3oool0o`000?l000110?ooo`030000003o
ool0oooo03l0oooo0`3o0000103oool0o`000?l0003o00090?ooo`<0o`004P3oool20?l001l0oooo
0P3o000E0?ooo`030?l0003oool0oooo00`0oooo0P3o000=0?ooo`80o`009`3oool000l0oooo0P3o
00090?ooo`80o`005@3oool00`3o0000oooo0?ooo`0;0?ooo`80o`006`3oool20?l00080oooo0P3o
000C0?ooo`80o`002`3oool20?l000030?ooo`3o0000o`0000<0o`00@03oool00`000000oooo0?oo
o`0o0?ooo`80o`0000<0oooo0?l0003o00000P3o00090?ooo`80o`004`3oool20?l001l0oooo0P3o
000D0?ooo`80o`003P3oool20?l000d0oooo0P3o000W0?ooo`003`3oool20?l000T0oooo0P3o000E
0?ooo`80o`002`3oool30?l001`0oooo00<0o`000?ooo`3oool00P3o000C0?ooo`80o`002`3oool3
0?l000030?ooo`3o0000oooo0080o`00@03oool00`000000oooo0?ooo`0n0?ooo`<0o`0000@0oooo
0?l0003o0000o`002@3oool30?l001@0oooo0P3o000N0?ooo`80o`004`3oool20?l000l0oooo0P3o
000<0?ooo`<0o`009`3oool000l0oooo0P3o00090?ooo`80o`005P3oool20?l000X0oooo0P3o000M
0?ooo`80o`0000<0oooo0?l0003o00004`3oool20?l000`0oooo0P3o00000`3oool0o`000?l00002
0?l00400oooo00<000000?ooo`3oool0?P3oool20?l000030?ooo`3o0000o`000080o`002@3oool3
0?l001@0oooo0P3o000N0?ooo`80o`004`3oool00`3o0000oooo0?ooo`0>0?ooo`80o`00303oool2
0?l002P0oooo000?0?ooo`<0o`001`3oool20?l001P0oooo0P3o00090?ooo`80o`007P3oool40?l0
01<0oooo0P3o000<0?ooo`80o`000P3oool40?l003l0oooo00<000000?ooo`3oool0?P3oool20?l0
00030?ooo`3o0000oooo0080o`00203oool40?l001@0oooo0P3o000N0?ooo`80o`004P3oool20?l0
0140oooo0P3o000;0?ooo`80o`00:03oool00100oooo0P3o00070?ooo`80o`00603oool30?l000P0
oooo0P3o000O0?ooo`<0o`00503oool20?l000/0oooo0P3o00020?ooo`@0o`00?`3oool00`000000
oooo0?ooo`0n0?ooo`050?l0003oool0o`000?l0003oool00P3o00070?ooo`D0o`00503oool20?l0
01h0oooo0P3o000A0?ooo`80o`004P3oool20?l000/0oooo0P3o000X0?ooo`00403oool20?l000L0
oooo0P3o000I0?ooo`80o`00203oool20?l001l0oooo0`3o000D0?ooo`80o`00303oool20?l00080
oooo0`3o000o0?ooo`030000003oool0oooo03d0oooo103o00020?ooo`80o`001P3oool30?l00003
0?ooo`3o0000o`0001@0oooo0P3o000O0?ooo`80o`003`3oool30?l00180oooo0P3o000;0?ooo`80
o`00:03oool00100oooo0`3o00060?ooo`80o`006P3oool20?l000L0oooo0P3o000O0?ooo`@0o`00
4`3oool20?l000`0oooo0P3o00030?ooo`80o`00?`3oool00`000000oooo0?ooo`0m0?ooo`030?l0
003oool0o`0000<0oooo0P3o00050?ooo`<0o`000P3oool20?l001@0oooo0P3o000O0?ooo`80o`00
3`3oool20?l001<0oooo0P3o000:0?ooo`<0o`00:03oool00140oooo0P3o00060?ooo`80o`006P3o
ool30?l000H0oooo0P3o000O0?ooo`D0o`004P3oool20?l000`0oooo0P3o00030?ooo`<0o`00?P3o
ool00`000000oooo0?ooo`0l0?ooo`@0o`000P3oool20?l000D0oooo0`3o00030?ooo`80o`00503o
ool20?l001l0oooo0P3o000>0?ooo`80o`00503oool20?l000X0oooo0P3o000Y0?ooo`004@3oool2
0?l000H0oooo0P3o000K0?ooo`<0o`00103oool20?l00200oooo0P3o0000103oool0o`000?l0003o
000A0?ooo`80o`00303oool20?l000@0oooo0P3o000n0?ooo`030000003oool0oooo03`0oooo0`3o
00030?ooo`80o`001@3oool20?l000@0oooo0P3o000D0?ooo`80o`007`3oool20?l000d0oooo0`3o
000D0?ooo`80o`002@3oool30?l002T0oooo000A0?ooo`80o`001P3oool20?l001`0oooo0`3o0003
0?ooo`80o`00803oool20?l00080oooo0`3o000@0?ooo`80o`00303oool20?l000D0oooo0P3o000m
0?ooo`030000003oool0oooo03/0oooo0`3o00040?ooo`80o`00103oool20?l000D0oooo0P3o000D
0?ooo`80o`007`3oool20?l000`0oooo0`3o000E0?ooo`80o`002@3oool20?l002X0oooo000A0?oo
o`<0o`001@3oool20?l001d0oooo0P3o00030?ooo`80o`00803oool20?l000<0oooo0`3o000?0?oo
o`80o`00303oool30?l000@0oooo0`3o000l0?ooo`030000003oool0oooo03/0oooo0P3o00040?oo
o`<0o`000`3oool30?l000D0oooo0P3o000D0?ooo`80o`007`3oool20?l000/0oooo0`3o000F0?oo
o`80o`002@3oool20?l002X0oooo000B0?ooo`80o`001@3oool20?l001h0oooo0P3o00020?ooo`80
o`00803oool20?l000@0oooo0`3o000>0?ooo`80o`003@3oool20?l000D0oooo0P3o000l0?ooo`03
0000003oool0oooo03X0oooo0`3o00040?ooo`80o`000`3oool30?l000H0oooo0P3o000E0?ooo`80
o`007`3oool20?l000X0oooo0P3o000G0?ooo`80o`00203oool30?l002X0oooo000B0?ooo`80o`00
1@3oool20?l001h0oooo0`3o00000`3oool0o`000?l0000P0?ooo`80o`001@3oool30?l000h0oooo
0P3o000<0?ooo`80o`001P3oool20?l003/0oooo00<000000?ooo`3oool0>P3oool20?l000D0oooo
0P3o00020?ooo`<0o`001`3oool20?l001D0oooo0P3o000O0?ooo`80o`002@3oool20?l001P0oooo
0P3o00080?ooo`80o`00:`3oool00180oooo0`3o00040?ooo`80o`007`3oool50?l00200oooo0P3o
00060?ooo`<0o`003@3oool20?l000`0oooo0`3o00050?ooo`<0o`00>P3oool00`000000oooo0?oo
o`0i0?ooo`80o`001@3oool30?l000040?ooo`3o0000o`000?l000L0oooo0P3o000F0?ooo`80o`00
7`3oool20?l000P0oooo0`3o000H0?ooo`80o`001`3oool30?l002/0oooo000C0?ooo`80o`00103o
ool20?l00200oooo103o000P0?ooo`80o`001`3oool30?l000`0oooo0P3o000=0?ooo`80o`001P3o
ool30?l003T0oooo00<000000?ooo`3oool0>03oool30?l000D0oooo0P3o0000103oool0o`000?l0
003o00080?ooo`80o`005P3oool20?l001l0oooo0P3o00070?ooo`<0o`006@3oool20?l000L0oooo
0P3o000/0?ooo`004`3oool30?l000<0oooo0P3o000Q0?ooo`80o`008@3oool20?l000P0oooo0`3o
000;0?ooo`80o`003@3oool20?l000L0oooo0`3o000h0?ooo`030000003oool0oooo03L0oooo0`3o
00050?ooo`H0o`002@3oool20?l001H0oooo0P3o000O0?ooo`80o`001P3oool30?l001X0oooo0P3o
00070?ooo`80o`00;03oool001@0oooo0P3o00030?ooo`80o`008@3oool30?l001l0oooo0P3o000:
0?ooo`<0o`002P3oool20?l000d0oooo0`3o00070?ooo`<0o`00=`3oool00`000000oooo0?ooo`0f
0?ooo`<0o`001P3oool50?l000X0oooo0P3o000F0?ooo`80o`007`3oool20?l000H0oooo0P3o000K
0?ooo`80o`001P3oool30?l002`0oooo000D0?ooo`80o`000`3oool20?l00240oooo103o000N0?oo
o`80o`002`3oool30?l000T0oooo0P3o000>0?ooo`80o`001`3oool30?l003L0oooo00<000000?oo
o`3oool0=@3oool30?l000L0oooo103o000;0?ooo`80o`005P3oool20?l00200oooo0P3o00040?oo
o`80o`00703oool20?l000H0oooo0P3o000]0?ooo`00503oool30?l00080oooo0P3o000Q0?ooo`D0
o`007@3oool20?l000`0oooo0`3o00080?ooo`80o`003P3oool30?l000L0oooo0`3o000f0?ooo`03
0000003oool0oooo03@0oooo103o00060?ooo`@0o`00303oool20?l001H0oooo0P3o000P0?ooo`80
o`000`3oool30?l001`0oooo0P3o00050?ooo`<0o`00;@3oool001D0oooo0P3o00000`3oool0o`00
0?l0000R0?ooo`80o`0000@0oooo0?l0003o0000o`00703oool20?l000d0oooo0`3o00080?ooo`80
o`003P3oool20?l000P0oooo0`3o000e0?ooo`030000003oool0oooo03<0oooo103o00070?ooo`<0
o`003@3oool20?l001H0oooo0P3o000P0?ooo`80o`000P3oool30?l001d0oooo0P3o00050?ooo`80
o`00;P3oool001D0oooo1@3o000R0?ooo`80o`000P3oool20?l001`0oooo0P3o000>0?ooo`@0o`00
1P3oool20?l000h0oooo0P3o00080?ooo`@0o`00=03oool00`000000oooo0?ooo`0c0?ooo`<0o`00
1`3oool30?l000h0oooo0P3o000F0?ooo`80o`00803oool20?l000040?ooo`3o0000o`000?l001h0
oooo0P3o00050?ooo`80o`00;P3oool001H0oooo103o000R0?ooo`80o`000`3oool20?l001/0oooo
0P3o000?0?ooo`@0o`001@3oool20?l000l0oooo00<0o`000?ooo`3oool01`3oool40?l003<0oooo
00<000000?ooo`3oool0<P3oool40?l000H0oooo0`3o000?0?ooo`80o`005P3oool20?l00200oooo
1@3o000O0?ooo`80o`001@3oool00`3o0000oooo0?ooo`0]0?ooo`005P3oool40?l00240oooo0P3o
00040?ooo`<0o`006P3oool20?l00140oooo0`3o00040?ooo`80o`003`3oool20?l000P0oooo1@3o
000b0?ooo`030000003oool0oooo0340oooo103o00050?ooo`D0o`003P3oool30?l001H0oooo0P3o
000P0?ooo`@0o`00803oool20?l000@0oooo0P3o000_0?ooo`005`3oool30?l00240oooo0P3o0005
0?ooo`<0o`006@3oool20?l00180oooo0`3o00030?ooo`80o`00403oool00`3o0000oooo0?ooo`07
0?ooo`D0o`00<@3oool00`000000oooo0?ooo`0`0?ooo`D0o`00103oool50?l000l0oooo0P3o000G
0?ooo`80o`00803oool30?l00240oooo0P3o00040?ooo`030?l0003oool0oooo02h0oooo000G0?oo
o`<0o`008@3oool20?l000H0oooo0`3o000H0?ooo`80o`004`3oool30?l00080oooo0P3o000@0?oo
o`80o`002@3oool00`3o0000oooo0?l000030?l002l0oooo00<000000?ooo`3oool0;`3oool50?l0
00@0oooo0`3o00000`3oool0o`000?l0000?0?ooo`80o`005`3oool20?l00200oooo0`3o000Q0?oo
o`80o`000`3oool20?l00300oooo000H0?ooo`80o`008@3oool20?l000L0oooo0`3o000G0?ooo`80
o`00503oool30?l000040?ooo`3o0000o`000?l00100oooo00<0o`000?ooo`3oool01`3oool20?l0
00030?ooo`3o0000o`000080o`00;P3oool00`000000oooo0?ooo`0^0?ooo`D0o`00103oool30?l0
00030?ooo`3o0000o`000100oooo0P3o000G0?ooo`80o`007`3oool30?l00280oooo0P3o00030?oo
o`030?l0003oool0oooo02l0oooo000H0?ooo`80o`008@3oool20?l000P0oooo103o000E0?ooo`80
o`005@3oool60?l00100oooo0P3o00090?ooo`80o`000P3oool30?l002d0oooo00<000000?ooo`3o
ool0;@3oool60?l00080oooo103o00020?ooo`80o`003`3oool30?l001L0oooo0P3o000M0?ooo`D0
o`008P3oool20?l00080oooo0P3o000a0?ooo`00603oool30?l00200oooo0P3o00090?ooo`@0o`00
503oool20?l001H0oooo1@3o000A0?ooo`80o`002@3oool20?l00080oooo0`3o000/0?ooo`030000
003oool0oooo02`0oooo1P3o00020?ooo`@0o`000`3oool00`3o0000oooo0?ooo`0>0?ooo`80o`00
603oool20?l001`0oooo1P3o000R0?ooo`80o`000P3oool00`3o0000oooo0?ooo`0`0?ooo`006@3o
ool20?l00200oooo0P3o000;0?ooo`<0o`004`3oool20?l001P0oooo0`3o000B0?ooo`030?l0003o
ool0oooo00L0oooo0`3o00020?ooo`<0o`00:`3oool00`000000oooo0?ooo`0Z0?ooo`L0o`000P3o
ool30?l000@0oooo0P3o000@0?ooo`80o`00603oool20?l001/0oooo0`3o00020?ooo`80o`008P3o
ool20?l00080oooo00<0o`000?ooo`3oool0<03oool001T0oooo0`3o000N0?ooo`80o`003@3oool3
0?l00180oooo0P3o000I0?ooo`@0o`00403oool20?l000T0oooo0`3o00020?ooo`<0o`00:P3oool0
0`000000oooo0?ooo`0Y0?ooo`@0o`0000@0oooo0?l0003o0000oooo103o00050?ooo`030?l0003o
ool0oooo00l0oooo0P3o000H0?ooo`80o`006P3oool30?l000<0oooo0P3o000R0?ooo`80o`0000<0
oooo0?l0003o0000<P3oool001T0oooo0`3o000O0?ooo`80o`003@3oool30?l00140oooo0P3o000J
0?ooo`@0o`00403oool00`3o0000oooo0?ooo`080?ooo`<0o`000P3oool40?l002P0oooo00<00000
0?ooo`3oool09`3oool40?l00080oooo1`3o00050?ooo`80o`00403oool30?l001P0oooo0P3o000H
0?ooo`@0o`00103oool20?l00280oooo0P3o00000`3oool0o`000?ooo`0b0?ooo`006@3oool40?l0
01h0oooo0P3o000>0?ooo`<0o`00403oool20?l001X0oooo1P3o000>0?ooo`80o`002P3oool20?l0
00<0oooo103o000W0?ooo`030000003oool0oooo02H0oooo103o00020?ooo`H0o`001`3oool00`3o
0000oooo0?ooo`0?0?ooo`80o`006@3oool20?l001L0oooo103o00050?ooo`80o`008P3oool40?l0
03<0oooo000I0?ooo`80o`0000<0oooo0?l0003o00007@3oool20?l000l0oooo0`3o000?0?ooo`80
o`006P3oool80?l000d0oooo00<0o`000?ooo`3oool02@3oool20?l000@0oooo103o000U0?ooo`03
0000003oool0oooo02@0oooo103o00030?ooo`D0o`00203oool20?l00140oooo0P3o000H0?ooo`80
o`005`3oool30?l000L0oooo0P3o000R0?ooo`<0o`00=03oool001X0oooo0P3o00000`3oool0o`00
0?ooo`0L0?ooo`80o`00403oool40?l000d0oooo0P3o000K0?ooo`80o`000P3oool40?l000`0oooo
0P3o000:0?ooo`<0o`00103oool40?l002@0oooo00<000000?ooo`3oool08`3oool40?l000<0oooo
103o000:0?ooo`030?l0003oool0oooo0100oooo0P3o000H0?ooo`80o`005P3oool30?l000P0oooo
0P3o000Q0?ooo`@0o`00=03oool001X0oooo0P3o00000`3oool0o`000?l0000L0?ooo`80o`004@3o
ool40?l000d0oooo0P3o000J0?ooo`80o`00103oool40?l000/0oooo00<0o`000?ooo`3oool02@3o
ool30?l000D0oooo103o000R0?ooo`030000003oool0oooo0240oooo103o00030?ooo`D0o`002P3o
ool20?l00140oooo0`3o000H0?ooo`80o`00503oool40?l000T0oooo0P3o000Q0?ooo`<0o`00=@3o
ool001X0oooo0P3o00020?ooo`030?l0003oool0oooo01X0oooo0P3o000C0?ooo`<0o`00303oool2
0?l001X0oooo0P3o00050?ooo`D0o`002@3oool20?l000/0oooo0`3o00050?ooo`@0o`008@3oool0
0`000000oooo0?ooo`0P0?ooo`@0o`0000<0oooo0?l0003o0000103o000<0?ooo`030?l0003oool0
oooo0100oooo0P3o000I0?ooo`80o`004`3oool40?l000X0oooo0P3o000Q0?ooo`<0o`00=@3oool0
01X0oooo0P3o00020?ooo`80o`006`3oool20?l001@0oooo0`3o000;0?ooo`80o`006P3oool30?l0
00H0oooo103o00090?ooo`80o`002`3oool30?l000H0oooo103o000O0?ooo`030000003oool0oooo
01h0oooo303o000<0?ooo`80o`004@3oool30?l001T0oooo0P3o000B0?ooo`<0o`00303oool20?l0
0240oooo0P3o000f0?ooo`006P3oool20?l000<0oooo0P3o000J0?ooo`80o`005@3oool40?l000T0
oooo0P3o000K0?ooo`80o`00203oool40?l000P0oooo00<0o`000?ooo`3oool02P3oool30?l000H0
oooo1@3o000M0?ooo`030000003oool0oooo01`0oooo3@3o000<0?ooo`80o`004P3oool20?l001X0
oooo0P3o000@0?ooo`@0o`003@3oool20?l00240oooo0P3o000f0?ooo`006`3oool20?l000<0oooo
00<0o`000?ooo`3oool0603oool20?l001H0oooo103o00080?ooo`80o`006`3oool20?l000T0oooo
1@3o00060?ooo`80o`00303oool40?l000H0oooo103o000L0?ooo`030000003oool0oooo01/0oooo
203o0000103oool0o`000?l0003o000=0?ooo`80o`004`3oool20?l001T0oooo0P3o000@0?ooo`@0
o`003P3oool20?l00200oooo0`3o000f0?ooo`006`3oool20?l000<0oooo0P3o000I0?ooo`80o`00
603oool40?l000H0oooo0P3o000K0?ooo`80o`002`3oool60?l000@0oooo00<0o`000?ooo`3oool0
2`3oool40?l000L0oooo103o000J0?ooo`030000003oool0oooo01T0oooo203o00020?ooo`<0o`00
3P3oool00`3o0000oooo0?ooo`0A0?ooo`<0o`006@3oool20?l000h0oooo103o000@0?ooo`80o`00
7`3oool40?l003H0oooo000K0?ooo`80o`00103oool20?l001P0oooo0P3o000I0?ooo`@0o`001P3o
ool20?l001/0oooo00<0o`000?ooo`3oool02`3oool60?l00080oooo0P3o000>0?ooo`<0o`001`3o
ool50?l001P0oooo00<000000?ooo`3oool05P3oool70?l000@0oooo103o000>0?ooo`80o`004`3o
ool20?l001X0oooo0P3o000=0?ooo`@0o`004@3oool20?l001h0oooo0P3o00000`3oool0o`000?l0
000f0?ooo`006`3oool20?l000D0oooo0P3o000G0?ooo`80o`006`3oool40?l000@0oooo0P3o000K
0?ooo`80o`003`3oool50?l000030?ooo`3o0000o`0000h0oooo0`3o00080?ooo`D0o`005P3oool0
0`000000oooo0?ooo`0C0?ooo`L0o`001P3oool40?l000h0oooo0P3o000C0?ooo`<0o`006P3oool2
0?l000`0oooo0`3o000C0?ooo`80o`007P3oool00`3o0000oooo0?ooo`020?l003H0oooo000K0?oo
o`80o`001P3oool00`3o0000oooo0?ooo`0E0?ooo`80o`00703oool40?l000<0oooo0P3o000L0?oo
o`030?l0003oool0oooo00l0oooo1P3o000?0?ooo`@0o`00203oool60?l001<0oooo00<000000?oo
o`3oool03P3oool90?l000P0oooo0`3o000?0?ooo`80o`00503oool20?l001/0oooo0P3o000:0?oo
o`@0o`00503oool20?l001d0oooo0P3o00000`3oool0o`000?l0000g0?ooo`00703oool20?l000D0
oooo0P3o000F0?ooo`80o`007P3oool40?l000030?ooo`3o0000o`0001`0oooo0P3o000B0?ooo`H0
o`003P3oool40?l000T0oooo1P3o000A0?ooo`030000003oool0oooo00P0oooo303o00090?ooo`@0
o`003`3oool30?l001@0oooo0P3o000K0?ooo`80o`002@3oool40?l001D0oooo0P3o000L0?ooo`80
o`000P3oool20?l003L0oooo000L0?ooo`80o`001P3oool20?l001D0oooo0P3o000O0?ooo`H0o`00
7@3oool00`3o0000oooo0?ooo`0C0?ooo`H0o`003@3oool30?l000/0oooo1P3o000>0?ooo`030000
003oool0oooo00<0oooo3`3o000:0?ooo`@0o`003`3oool30?l001D0oooo0P3o000K0?ooo`80o`00
203oool30?l001L0oooo0P3o000L0?ooo`040?l0003oool0oooo0?ooo`80o`00=`3oool001`0oooo
0P3o00070?ooo`80o`005@3oool20?l00200oooo103o000M0?ooo`030?l0003oool0oooo01@0oooo
2@3o000:0?ooo`<0o`00303oool60?l000/0oooo4`3o000;0?ooo`@0o`004@3oool20?l001D0oooo
0P3o000L0?ooo`80o`001P3oool40?l001P0oooo0P3o000K0?ooo`80o`000`3oool20?l003L0oooo
000L0?ooo`80o`001`3oool30?l001@0oooo0P3o000R0?ooo`@0o`006`3oool20?l001H0oooo0P3o
00020?ooo`P0o`001`3oool40?l000d0oooo203o00060?ooo`L0o`000P3oool70?l000d0oooo103o
000A0?ooo`80o`005P3oool00`3o0000oooo0?ooo`0K0?ooo`80o`001@3oool40?l001T0oooo0P3o
000J0?ooo`80o`000`3oool30?l003L0oooo000L0?ooo`80o`00203oool30?l001<0oooo0P3o000S
0?ooo`@0o`006`3oool00`3o0000oooo0?ooo`0E0?ooo`80o`001@3oool70?l000D0oooo103o000>
0?ooo`X0o`000`3oool00`000000oooo0?ooo`020?ooo`L0o`003P3oool40?l00180oooo0`3o000E
0?ooo`80o`007@3oool20?l000<0oooo103o000K0?ooo`80o`006@3oool20?l000@0oooo0P3o000h
0?ooo`007@3oool20?l000P0oooo0`3o000B0?ooo`80o`008`3oool60?l001T0oooo0P3o000F0?oo
o`<0o`00203oool>0?l00180oooo403o000@0?ooo`@0o`004P3oool30?l001H0oooo00<0o`000?oo
o`3oool06`3oool30?l000030?ooo`3o0000o`0000<0o`00703oool20?l001P0oooo0`3o00040?oo
o`80o`00>03oool001d0oooo0P3o00090?ooo`<0o`004@3oool20?l002<0oooo0P3o00000`3oool0
o`000?l000030?l001P0oooo00<0o`000?ooo`3oool05@3oool30?l000X0oooo:@3o000B0?ooo`@0
o`004`3oool30?l001L0oooo00<0o`000?ooo`3oool06`3oool20?l000030?ooo`3o0000o`000080
o`007P3oool20?l001L0oooo0`3o00050?ooo`80o`00>03oool001d0oooo0P3o000:0?ooo`<0o`00
403oool20?l002<0oooo0P3o00030?ooo`D0o`005P3oool20?l001L0oooo0`3o000A0?oooaX0o`00
0P3oool00`000000oooo0?ooo`0B0?ooo`D0o`004`3oool30?l001L0oooo0P3o000M0?ooo`D0o`00
803oool20?l001H0oooo0`3o00050?ooo`<0o`00>03oool001d0oooo0P3o000;0?ooo`<0o`003`3o
ool20?l002<0oooo0P3o00050?ooo`H0o`00503oool00`3o0000oooo0?ooo`0F0?ooo`<0o`004`3o
ool40?l001D0oooo00<000000?ooo`3oool0403oool50?l001D0oooo0P3o000H0?ooo`030?l0003o
ool0oooo01/0oooo1@3o000Q0?ooo`80o`005@3oool30?l000H0oooo0P3o000i0?ooo`007@3oool3
0?l000/0oooo0`3o000>0?ooo`80o`008`3oool30?l000H0oooo1P3o000B0?ooo`80o`00603oool2
0?l001D0oooo103o000C0?ooo`030000003oool0oooo00h0oooo1@3o000F0?ooo`80o`00603oool2
0?l001/0oooo1@3o000S0?ooo`80o`005@3oool20?l000L0oooo0P3o000i0?ooo`007P3oool20?l0
00`0oooo0`3o000=0?ooo`80o`00903oool20?l000T0oooo1@3o000A0?ooo`030?l0003oool0oooo
01L0oooo0P3o000E0?ooo`D0o`004@3oool00`000000oooo0?ooo`0<0?ooo`D0o`005`3oool30?l0
01P0oooo00<0o`000?ooo`3oool0603oool70?l002<0oooo0P3o000D0?ooo`80o`001`3oool30?l0
03T0oooo000N0?ooo`80o`003@3oool30?l000`0oooo0P3o000T0?ooo`80o`002`3oool50?l000l0
oooo0P3o000H0?ooo`<0o`005P3oool50?l000l0oooo00<000000?ooo`3oool02P3oool50?l001P0
oooo0`3o000H0?ooo`80o`006@3oool40?l000030?ooo`3o0000o`0002<0oooo0P3o000D0?ooo`<0
o`001`3oool20?l003X0oooo000N0?ooo`<0o`003@3oool30?l000/0oooo0P3o000T0?ooo`80o`00
3@3oool50?l000h0oooo00<0o`000?ooo`3oool05`3oool30?l001L0oooo1@3o000=0?ooo`030000
003oool0oooo00P0oooo1@3o000I0?ooo`<0o`006@3oool00`3o0000oooo0?ooo`0F0?ooo`@0o`00
0`3oool20?l002<0oooo0P3o000C0?ooo`<0o`001`3oool30?l003X0oooo000O0?ooo`80o`003P3o
ool30?l000X0oooo0P3o000T0?ooo`<0o`003P3oool60?l000/0oooo0P3o000I0?ooo`<0o`00603o
ool60?l000X0oooo00<000000?ooo`3oool01P3oool50?l001X0oooo0`3o000I0?ooo`80o`005P3o
ool50?l000@0oooo0P3o000S0?ooo`80o`004P3oool30?l000P0oooo0P3o000k0?ooo`007`3oool3
0?l000h0oooo0`3o00090?ooo`80o`009@3oool20?l00100oooo1P3o000:0?ooo`030?l0003oool0
oooo01P0oooo0`3o000I0?ooo`H0o`00203oool00`000000oooo0?ooo`030?ooo`H0o`006`3oool3
0?l001T0oooo0P3o000D0?ooo`H0o`001@3oool30?l002<0oooo0P3o000A0?ooo`<0o`002@3oool2
0?l003/0oooo000P0?ooo`80o`003`3oool30?l000T0oooo0P3o000T0?ooo`80o`004`3oool60?l0
00L0oooo00<0o`000?ooo`3oool06@3oool30?l001/0oooo1@3o00060?ooo`040000003oool0oooo
0?ooo`H0o`00703oool30?l001X0oooo00<0o`000?ooo`3oool0403oool60?l000P0oooo0P3o000T
0?ooo`80o`00403oool30?l000T0oooo0`3o000k0?ooo`00803oool20?l00100oooo0`3o00080?oo
o`80o`00903oool30?l001@0oooo203o00030?ooo`80o`006`3oool30?l001`0oooo1P3o00030?oo
o`030000003o0000o`0000@0o`007P3oool30?l001X0oooo0P3o000>0?ooo`L0o`002`3oool20?l0
02@0oooo0P3o000?0?ooo`<0o`002P3oool20?l003`0oooo000P0?ooo`<0o`00403oool30?l000L0
oooo0P3o000U0?ooo`80o`00603oool70?l000030?ooo`3o0000oooo01/0oooo0`3o000M0?ooo`/0
o`007`3oool40?l001/0oooo00<0o`000?ooo`3oool02P3oool70?l000d0oooo0`3o000T0?ooo`80
o`003P3oool30?l000/0oooo0P3o000l0?ooo`008@3oool20?l00140oooo0`3o00060?ooo`80o`00
9@3oool20?l001`0oooo1P3o000L0?ooo`<0o`007@3oool80?l00200oooo103o000K0?ooo`80o`00
2@3oool60?l00140oooo0P3o000T0?ooo`80o`003@3oool40?l000/0oooo0`3o000l0?ooo`008@3o
ool30?l00140oooo0`3o00060?ooo`80o`00903oool20?l001l0oooo1P3o000J0?ooo`<0o`006@3o
ool60?l000030?ooo`3o0000o`0000D0o`00703oool30?l001d0oooo00<0o`000?ooo`3oool0103o
ool70?l001@0oooo0P3o000T0?ooo`80o`00303oool40?l000`0oooo0P3o000m0?ooo`008P3oool2
0?l00180oooo0`3o00050?ooo`80o`00903oool30?l00200oooo2@3o000F0?ooo`<0o`00503oool7
0?l000H0oooo00<000000?l0003o00001@3o000H0?ooo`<0o`007@3oool20?l00080oooo203o000F
0?ooo`<0o`00903oool20?l000/0oooo0`3o000=0?ooo`<0o`00?@3oool00280oooo0P3o000C0?oo
o`<0o`00103oool20?l002D0oooo0P3o000Q0?ooo`030?l0003oool0o`0000d0o`003`3oool30?l0
00/0oooo303o00090?ooo`030000003oool0oooo0080oooo2P3o000@0?ooo`<0o`007P3oool80?l0
01X0oooo0P3o000U0?ooo`80o`002P3oool30?l000h0oooo0P3o000n0?ooo`008`3oool00`3o0000
oooo0?ooo`0B0?ooo`@0o`000P3oool20?l002D0oooo0P3o000Q0?ooo`80o`001P3ooolB0?l000H0
oooo0`3o00000`3oool0o`000?l0000?0?l000d0oooo00<000000?ooo`3oool01@3oool;0?l000/0
oooo0`3o000G0?ooo``0o`007P3oool20?l002@0oooo0`3o00090?ooo`<0o`003`3oool20?l003h0
oooo000S0?ooo`80o`00503oool40?l000030?ooo`3o0000o`0002D0oooo0`3o000Q0?ooo`030?l0
003oool0oooo00`0oooo7@3o000E0?ooo`030000003oool0oooo00`0oooo203o00060?ooo`<0o`00
403oool@0?l00240oooo0`3o000T0?ooo`80o`002@3oool30?l00100oooo00<0o`000?ooo`3oool0
?@3oool002@0oooo00<0o`000?ooo`3oool0503oool30?l000030?ooo`3o0000o`0002D0oooo0P3o
000Q0?ooo`80o`005`3oool;0?l001d0oooo00<000000?ooo`3oool0403ooolU0?l000H0oooo00<0
o`000?ooo`3oool0803oool20?l002D0oooo0P3o00080?ooo`<0o`00403oool20?l003l0oooo000T
0?ooo`80o`005P3oool50?l002D0oooo0P3o000R0?ooo`80o`007`3oool40?l001/0oooo00<00000
0?ooo`3oool0503ooolI0?l000d0oooo0P3o000R0?ooo`80o`009@3oool20?l000H0oooo103o000A
0?ooo`030?l0003oool0oooo03h0oooo000U0?ooo`80o`005P3oool40?l002D0oooo0`3o000R0?oo
o`030?l0003oool0oooo01h0oooo103o000J0?ooo`030000003oool0oooo01D0oooo103o000Q0?oo
o`030?l0003oool0oooo0200oooo0`3o000T0?ooo`<0o`001@3oool40?l00140oooo0P3o00100?oo
o`009P3oool00`3o0000oooo0?ooo`0F0?ooo`<0o`009@3oool20?l00280oooo0P3o000Q0?ooo`@0
o`00603oool00`000000oooo0?ooo`0D0?ooo`@0o`008@3oool20?l00280oooo0P3o000U0?ooo`80
o`001@3oool30?l001<0oooo00<0o`000?ooo`3oool0?`3oool002H0oooo0P3o000G0?ooo`D0o`00
8`3oool30?l00280oooo0P3o000Q0?ooo`@0o`005`3oool00`000000oooo0?ooo`0B0?ooo`@0o`00
8P3oool20?l00280oooo0`3o000U0?ooo`80o`00103oool30?l001<0oooo0P3o00110?ooo`009`3o
ool00`3o0000oooo0?ooo`0F0?ooo`D0o`008`3oool20?l002<0oooo00<0o`000?ooo`3oool08@3o
ool40?l001D0oooo00<000000?ooo`3oool04@3oool40?l00280oooo0P3o000S0?ooo`80o`009P3o
ool20?l00080oooo103o000D0?ooo`030?l0003oool0oooo0400oooo000W0?ooo`80o`005`3oool2
0?l000030?ooo`3o0000o`000080o`008@3oool20?l002<0oooo0P3o000S0?ooo`@0o`00503oool0
0`000000oooo0?ooo`0?0?ooo`@0o`00903oool00`3o0000oooo0?ooo`0R0?ooo`80o`009@3oool3
0?l000030?ooo`3o0000o`000080o`00503oool20?l00480oooo000X0?ooo`030?l0003oool0oooo
01D0oooo0`3o00000`3oool0o`000?l000020?l00200oooo0`3o000S0?ooo`80o`00903oool40?l0
0180oooo00<000000?ooo`3oool03P3oool40?l002@0oooo0P3o000S0?ooo`<0o`009@3oool20?l0
00040?ooo`3o0000o`000?l001H0oooo00<0o`000?ooo`3oool0@@3oool002P0oooo0P3o000G0?oo
o`80o`000`3oool40?l001l0oooo0P3o000T0?ooo`030?l0003oool0oooo02<0oooo103o000A0?oo
o`030000003oool0oooo00`0oooo103o000U0?ooo`80o`00903oool20?l002H0oooo1@3o000F0?oo
o`80o`00@`3oool002T0oooo0P3o000F0?ooo`80o`00103oool50?l001d0oooo0`3o000S0?ooo`80
o`009P3oool40?l000l0oooo00<000000?ooo`3oool02P3oool50?l002D0oooo0P3o000U0?ooo`80
o`009P3oool40?l001L0oooo00<0o`000?ooo`3oool0@P3oool002X0oooo00<0o`000?ooo`3oool0
503oool30?l000D0oooo1@3o000L0?ooo`80o`00903oool20?l002H0oooo103o000>0?ooo`030000
003oool0oooo00P0oooo1@3o000V0?ooo`80o`009P3oool00`3o0000oooo0?ooo`0S0?ooo`@0o`00
603oool20?l004@0oooo000Z0?ooo`80o`005P3oool20?l000L0oooo103o000K0?ooo`80o`009@3o
ool20?l002L0oooo103o000<0?ooo`030000003oool0oooo00H0oooo1@3o000X0?ooo`030?l0003o
ool0oooo02@0oooo0P3o000S0?ooo`D0o`006@3oool00`3o0000oooo0?ooo`130?ooo`00:`3oool0
0`3o0000oooo0?ooo`0D0?ooo`<0o`00203oool40?l001T0oooo0`3o000U0?ooo`030?l0003oool0
oooo02H0oooo1@3o000:0?ooo`030000003oool0oooo00@0oooo1@3o000Y0?ooo`80o`009P3oool0
0`3o0000oooo0?ooo`0Q0?ooo`H0o`00603oool20?l004D0oooo000[0?ooo`80o`005P3oool20?l0
00T0oooo1@3o000H0?ooo`80o`009@3oool20?l002T0oooo103o00090?ooo`030000003oool0oooo
0080oooo1@3o000Z0?ooo`80o`009P3oool20?l00240oooo103o00000`3oool0o`000?l0000H0?oo
o`80o`00AP3oool002`0oooo0P3o000E0?ooo`80o`002`3oool50?l001H0oooo0`3o000U0?ooo`80
o`00:P3oool40?l000L0oooo00<000000?ooo`3oool01@3o000[0?ooo`80o`009`3oool00`3o0000
oooo0?ooo`0O0?ooo`@0o`000P3oool20?l001P0oooo00<0o`000?ooo`3oool0A@3oool002d0oooo
00<0o`000?ooo`3oool04`3oool30?l000`0oooo1P3o000D0?ooo`80o`009P3oool00`3o0000oooo
0?ooo`0Y0?ooo`D0o`001@3oool00`000000o`000?l000030?l002d0oooo00<0o`000?ooo`3oool0
9@3oool20?l001l0oooo103o00030?ooo`<0o`005`3oool20?l004L0oooo000]0?ooo`80o`005@3o
ool20?l000h0oooo1P3o000B0?ooo`80o`009P3oool20?l002`0oooo1@3o00020?ooo`D0o`00;P3o
ool20?l002L0oooo00<0o`000?ooo`3oool0703oool50?l000@0oooo0P3o000H0?ooo`030?l0003o
ool0oooo04H0oooo000^0?ooo`80o`00503oool20?l00140oooo1@3o000A0?ooo`80o`009P3oool2
0?l002d0oooo203o000_0?ooo`80o`00:03oool00`3o0000oooo0?ooo`0J0?ooo`D0o`001P3oool2
0?l001L0oooo0P3o00180?ooo`00;`3oool20?l001@0oooo00<0o`000?ooo`3oool04@3oool50?l0
00l0oooo0P3o000W0?ooo`80o`00;03oool60?l000030000003oool0oooo02d0oooo0P3o000X0?oo
o`80o`006@3oool60?l000P0oooo00<0o`000?ooo`3oool05@3oool20?l004T0oooo000`0?ooo`03
0?l0003oool0oooo0180oooo0P3o000D0?ooo`H0o`003@3oool00`3o0000oooo0?ooo`0U0?ooo`<0
o`00:03oool<0?l002`0oooo0P3o000Y0?ooo`030?l0003oool0oooo01H0oooo1P3o00090?ooo`80
o`005`3oool00`3o0000oooo0?ooo`180?ooo`00<03oool20?l001@0oooo00<0o`000?ooo`3oool0
503oool70?l000X0oooo0P3o000W0?ooo`<0o`009@3oool60?l000@0oooo1P3o000Y0?ooo`<0o`00
:03oool20?l001H0oooo1@3o000<0?ooo`030?l0003oool0oooo01D0oooo0P3o001:0?ooo`00<@3o
ool20?l001<0oooo0P3o000I0?ooo`L0o`001`3oool00`3o0000oooo0?ooo`0V0?ooo`<0o`008@3o
ool60?l000P0oooo00<000000?ooo`3o00001@3o000U0?ooo`<0o`00:@3oool00`3o0000oooo0?oo
o`0C0?ooo`D0o`003@3oool20?l001L0oooo00<0o`000?ooo`3oool0B@3oool00380oooo00<0o`00
0?ooo`3oool04P3oool00`3o0000oooo0?ooo`0J0?ooo`L0o`00103oool20?l002P0oooo0`3o000M
0?ooo`L0o`002P3oool010000000oooo0?ooo`3oool70?l00240oooo0`3o000Y0?ooo`80o`004@3o
ool70?l000l0oooo00<0o`000?ooo`3oool05@3oool20?l004/0oooo000b0?ooo`80o`004`3oool2
0?l001l0oooo1`3o00000`3oool0o`000?ooo`0X0?ooo`<0o`00603oool70?l000h0oooo00<00000
0?ooo`3oool0103oool70?l001d0oooo0`3o000Z0?ooo`030?l0003oool0oooo00`0oooo203o000B
0?ooo`030?l0003oool0oooo01@0oooo0P3o001<0?ooo`00<`3oool20?l001<0oooo00<0o`000?oo
o`3oool0803oool80?l002P0oooo0`3o000C0?ooo`P0o`004@3oool00`000000oooo0?ooo`070?oo
o`L0o`006@3oool30?l002X0oooo0P3o000;0?ooo`L0o`005@3oool20?l001D0oooo0P3o001=0?oo
o`00=03oool20?l00180oooo00<0o`000?ooo`3oool0903oool80?l002D0oooo0`3o000<0?ooo`X0
o`005@3oool00`000000oooo0?ooo`0;0?ooo`H0o`005@3oool30?l002/0oooo00<0o`000?ooo`3o
ool01P3oool70?l001T0oooo00<0o`000?ooo`3oool04`3oool30?l004d0oooo000e0?ooo`80o`00
4@3oool20?l002L0oooo303o000P0?ooo`<0o`001@3oool<0?l001T0oooo00<000000?ooo`3oool0
3P3oool70?l00100oooo0`3o000[0?ooo`80o`00103oool80?l001/0oooo0P3o000D0?ooo`<0o`00
CP3oool003D0oooo0`3o000A0?ooo`030?l0003oool0oooo02H0oooo00<0o`000?ooo`3oool00P3o
ool;0?l001P0oooo4@3o000O0?ooo`030000003oool0oooo0140oooo1`3o000<0?ooo`<0o`00:`3o
ool20?l000030?ooo`3o0000o`0000H0o`007`3oool00`3o0000oooo0?ooo`0B0?ooo`<0o`00C`3o
ool003H0oooo0`3o000@0?ooo`80o`009`3oool20?l000T0oooo:03o000U0?ooo`030000003oool0
oooo01@0oooo2@3o00060?ooo`<0o`00:`3oool80?l00280oooo0P3o000C0?ooo`<0o`00D03oool0
03L0oooo0`3o000@0?ooo`030?l0003oool0oooo02H0oooo00<0o`000?ooo`3oool0303ooolH0?l0
00H0oooo0`3o000W0?ooo`030000003oool0oooo01L0oooo3P3o000V0?ooo`X0o`009P3oool00`3o
0000oooo0?ooo`0A0?ooo`<0o`00D@3oool003P0oooo0`3o000?0?ooo`80o`009`3oool20?l002`0
oooo0`3o000V0?ooo`030000003oool0oooo01d0oooo2`3o000L0?ooo`h0o`00:03oool20?l001<0
oooo0P3o001B0?ooo`00>@3oool30?l000l0oooo00<0o`000?ooo`3oool09P3oool00`3o0000oooo
0?ooo`0[0?ooo`<0o`009@3oool00`000000oooo0?ooo`0O0?ooob`0o`001@3oool20?l002P0oooo
00<0o`000?ooo`3oool04@3oool20?l005<0oooo000j0?ooo`@0o`003@3oool20?l002L0oooo0P3o
000]0?ooo`@0o`008`3oool00`000000oooo0?ooo`0N0?ooo`@0o`001P3ooolL0?l000`0oooo00<0
o`000?ooo`3oool09P3oool20?l00180oooo0`3o001C0?ooo`00>`3oool40?l000d0oooo00<0o`00
0?ooo`3oool09P3oool20?l002d0oooo103o000R0?ooo`030000003oool0oooo01d0oooo0`3o000_
0?ooo`80o`00:03oool00`3o0000oooo0?ooo`0@0?ooo`<0o`00E03oool003d0oooo0`3o000<0?oo
o`80o`00:03oool20?l002h0oooo0`3o000Q0?ooo`030000003oool0oooo01`0oooo0`3o000_0?oo
o`80o`00:03oool20?l00140oooo0`3o001E0?ooo`00?P3oool30?l000`0oooo0P3o000X0?ooo`03
0?l0003oool0oooo02d0oooo0`3o000P0?ooo`030000003oool0oooo01/0oooo0`3o000_0?ooo`80
o`00:03oool20?l00140oooo0`3o001F0?ooo`00?`3oool30?l000`0oooo00<0o`000?ooo`3oool0
9P3oool20?l002l0oooo0`3o000O0?ooo`030000003oool0oooo01T0oooo103o000`0?ooo`030?l0
003oool0oooo02L0oooo00<0o`000?ooo`3oool03`3oool30?l005L0oooo00100?ooo`<0o`002`3o
ool20?l002P0oooo0P3o000_0?ooo`<0o`007P3oool00`000000oooo0?ooo`0H0?ooo`@0o`00<03o
ool20?l002P0oooo0P3o000@0?ooo`<0o`00F03oool00440oooo0`3o000;0?ooo`030?l0003oool0
oooo02L0oooo0P3o000_0?ooo`@0o`00703oool00`000000oooo0?ooo`0F0?ooo`@0o`00<@3oool2
0?l002T0oooo00<0o`000?ooo`3oool03P3oool30?l005T0oooo00120?ooo`@0o`002@3oool20?l0
02T0oooo00<0o`000?ooo`3oool0;P3oool40?l001/0oooo00<000000?ooo`3oool05@3oool40?l0
0340oooo0P3o000Y0?ooo`80o`003`3oool30?l005X0oooo00130?ooo`@0o`002@3oool20?l002P0
oooo0P3o000a0?ooo`@0o`006@3oool00`000000oooo0?ooo`0C0?ooo`@0o`00<`3oool00`3o0000
oooo0?ooo`0X0?ooo`030?l0003oool0oooo00`0oooo103o001K0?ooo`00A@3oool30?l000T0oooo
00<0o`000?ooo`3oool09`3oool20?l00340oooo103o000H0?ooo`030000003oool0oooo0180oooo
103o000c0?ooo`80o`00:@3oool20?l000d0oooo103o001L0?ooo`00AP3oool30?l000P0oooo0P3o
000Y0?ooo`80o`00<P3oool30?l001L0oooo00<000000?ooo`3oool0403oool40?l003@0oooo0P3o
000Z0?ooo`030?l0003oool0oooo00/0oooo0`3o001N0?ooo`00A`3oool40?l000L0oooo00<0o`00
0?ooo`3oool0:03oool00`3o0000oooo0?ooo`0a0?ooo`@0o`005@3oool00`000000oooo0?ooo`0?
0?ooo`@0o`00=03oool20?l002X0oooo0P3o000<0?ooo`<0o`00G`3oool004P0oooo103o00060?oo
o`80o`00:@3oool20?l003<0oooo103o000D0?ooo`030000003oool0oooo00d0oooo103o000e0?oo
o`80o`00:P3oool20?l000`0oooo0`3o001P0?ooo`00BP3oool30?l000H0oooo0P3o000Y0?ooo`80
o`00=03oool40?l00180oooo00<000000?ooo`3oool0303oool40?l003D0oooo0`3o000Y0?ooo`80
o`00303oool30?l00640oooo001;0?ooo`@0o`001@3oool20?l002T0oooo0P3o000d0?ooo`@0o`00
4@3oool00`000000oooo0?ooo`0:0?ooo`@0o`00=P3oool30?l002X0oooo00<0o`000?ooo`3oool0
2@3oool40?l00680oooo001<0?ooo`@0o`001@3oool00`3o0000oooo0?ooo`0X0?ooo`030?l0003o
ool0oooo03@0oooo0`3o000@0?ooo`030000003oool0oooo00T0oooo103o000f0?ooo`<0o`00:P3o
ool20?l000X0oooo103o001S0?ooo`00CP3oool40?l000<0oooo0P3o000Y0?ooo`80o`00=P3oool4
0?l000h0oooo00<000000?ooo`3oool01`3oool40?l003L0oooo0`3o000Z0?ooo`80o`002@3oool4
0?l006D0oooo001?0?ooo`D0o`000P3oool20?l002T0oooo0P3o000f0?ooo`@0o`003@3oool00`00
0000oooo0?ooo`060?ooo`@0o`00>03oool20?l002X0oooo0P3o00080?ooo`D0o`00IP3oool00540
oooo1@3o00000`3oool0o`000?ooo`0Y0?ooo`80o`00=`3oool40?l000/0oooo00<000000?ooo`3o
ool0103oool40?l003T0oooo0P3o000[0?ooo`030?l0003oool0oooo00H0oooo103o001X0?ooo`00
D`3oool60?l002X0oooo0P3o000g0?ooo`@0o`002P3oool00`000000oooo0?ooo`020?ooo`D0o`00
>@3oool30?l002X0oooo0P3o00060?ooo`@0o`00JP3oool005D0oooo1@3o000Y0?ooo`<0o`00>03o
ool40?l000P0oooo00<000000?ooo`3o00001@3o000j0?ooo`<0o`00:P3oool20?l000H0oooo103o
001[0?ooo`00EP3oool50?l002T0oooo0`3o000h0?ooo`D0o`001P3oool60?l003/0oooo0`3o000Z
0?ooo`80o`001@3oool40?l006d0oooo001H0?ooo`D0o`00:03oool30?l003T0oooo1@3o00020?oo
o`D0o`00?@3oool30?l002X0oooo0P3o00040?ooo`D0o`00KP3oool005X0oooo1@3o000W0?ooo`<0
o`00>P3oool80?l003h0oooo0`3o000Z0?ooo`<0o`000P3oool50?l00700oooo001K0?ooo`L0o`00
9@3oool20?l003X0oooo203o000m0?ooo`<0o`00:P3oool30?l000030?ooo`3o0000o`0000<0o`00
LP3oool005`0oooo203o000T0?ooo`80o`00=`3oool60?l000030?ooo`3o0000o`0000<0o`00>P3o
ool30?l002X0oooo203o001d0?ooo`00G@3oool30?l000030?ooo`3o0000o`0000@0o`008@3oool3
0?l003<0oooo1P3o00060?ooo`D0o`00=P3oool40?l002X0oooo1`3o001f0?ooo`00GP3oool20?l0
00<0oooo1P3o000P0?ooo`<0o`00<03oool60?l000P0oooo00<000000?ooo`3o00001@3o000b0?oo
o`@0o`00:P3oool60?l007P0oooo001O0?ooo`80o`001@3oool60?l001h0oooo0`3o000/0?ooo`H0
o`002`3oool010000000oooo0?ooo`3oool60?l002l0oooo0`3o000[0?ooo`D0o`00NP3oool005l0
oooo0`3o00060?ooo`P0o`006`3oool30?l002L0oooo1`3o000>0?ooo`030000003oool0oooo00@0
oooo1P3o000[0?ooo`<0o`00:@3oool60?l007`0oooo001P0?ooo`<0o`00203oool90?l001P0oooo
0`3o000R0?ooo`P0o`004@3oool00`000000oooo0?ooo`060?ooo`L0o`009`3oool30?l002L0oooo
203o001m0?ooo`00H@3oool30?l000`0oooo203o000E0?ooo`<0o`006`3oool:0?l001D0oooo00<0
00000?ooo`3oool02P3oool70?l00280oooo0`3o000V0?ooo`T0o`00OP3oool00680oooo0`3o000?
0?ooo``0o`003P3oool40?l00180oooo3@3o000I0?ooo`030000003oool0oooo00d0oooo203o000M
0?ooo`<0o`00903oool60?l00080oooo0`3o001o0?ooo`00H`3oool30?l00180oooo3`3o00080?oo
o`@0o`002P3oool>0?l001l0oooo00<000000?ooo`3oool04@3oool80?l001P0oooo0`3o000R0?oo
o`L0o`000`3oool30?l00800oooo001T0?ooo`<0o`006@3ooolT0?l002H0oooo00<000000?ooo`3o
ool05@3oool70?l001@0oooo0`3o000M0?ooo`X0o`001@3oool30?l00840oooo001U0?ooo`@0o`00
7P3ooolF0?l002d0oooo00<000000?ooo`3oool06@3oool:0?l000`0oooo0`3o000G0?ooo`d0o`00
203oool30?l00880oooo001V0?ooo`@0o`00:@3oool40?l003<0oooo00<000000?ooo`3oool0703o
ool=0?l000@0oooo103o000@0?ooo`l0o`00303oool40?l008<0oooo001X0?ooo`<0o`00:@3oool4
0?l00380oooo00<000000?ooo`3oool08`3ooolV0?l00180oooo103o00240?ooo`00J@3oool30?l0
02X0oooo0`3o000a0?ooo`030000003oool0oooo02T0oooo603o000I0?ooo`<0o`00QP3oool006X0
oooo103o000Y0?ooo`@0o`00;`3oool00`000000oooo0?ooo`0Z0?ooo`<0o`00;03oool30?l008L0
oooo001[0?ooo`@0o`00:@3oool40?l002h0oooo00<000000?ooo`3oool0:@3oool30?l002`0oooo
0`3o00280?ooo`00K@3oool30?l002X0oooo103o000/0?ooo`030000003oool0oooo02L0oooo103o
000/0?ooo`<0o`00R@3oool006h0oooo103o000Y0?ooo`@0o`00:`3oool00`000000oooo0?ooo`0V
0?ooo`@0o`00:`3oool40?l008X0oooo001_0?ooo`@0o`00:P3oool30?l002X0oooo00<000000?oo
o`3oool0903oool40?l002`0oooo103o002;0?ooo`00L@3oool40?l002T0oooo103o000X0?ooo`03
0000003oool0oooo0280oooo1@3o000/0?ooo`<0o`00S@3oool00780oooo1@3o000X0?ooo`@0o`00
9`3oool00`000000oooo0?ooo`0P0?ooo`D0o`00;03oool40?l008h0oooo001d0?ooo`D0o`00:03o
ool40?l002D0oooo00<000000?ooo`3oool07`3oool40?l002`0oooo1@3o002?0?ooo`00MP3oool4
0?l002P0oooo103o000T0?ooo`030000003oool0oooo01d0oooo103o000/0?ooo`D0o`00T@3oool0
07P0oooo103o000X0?ooo`@0o`008P3oool00`000000oooo0?ooo`0K0?ooo`D0o`00:`3oool50?l0
09<0oooo001i0?ooo`D0o`009`3oool50?l00200oooo00<000000?ooo`3oool06@3oool50?l002`0
oooo103o002E0?ooo`00N`3oool50?l002L0oooo1@3o000N0?ooo`030000003oool0oooo01L0oooo
1@3o000/0?ooo`@0o`00U`3oool007d0oooo1@3o000W0?ooo`D0o`00703oool00`000000oooo0?oo
o`0E0?ooo`D0o`00;03oool50?l009P0oooo001o0?ooo`H0o`009P3oool50?l001X0oooo00<00000
0?ooo`3oool04`3oool50?l002`0oooo1@3o002J0?ooo`00P@3oool60?l002H0oooo1@3o000H0?oo
o`030000003oool0oooo0140oooo1@3o000/0?ooo`D0o`00W03oool008@0oooo1@3o000V0?ooo`D0
o`005P3oool00`000000oooo0?ooo`0>0?ooo`H0o`00:`3oool60?l009h0oooo00260?ooo`H0o`00
9@3oool60?l001<0oooo00<000000?ooo`3oool02`3oool70?l002/0oooo1P3o002P0?ooo`00R03o
ool60?l002D0oooo1`3o000@0?ooo`030000003oool0oooo00T0oooo1P3o000[0?ooo`H0o`00X`3o
ool008/0oooo1P3o000V0?ooo`H0o`003@3oool00`000000oooo0?ooo`060?ooo`H0o`00;03oool6
0?l00:D0oooo002=0?ooo`L0o`009P3oool60?l000X0oooo00<000000?ooo`3oool00P3oool80?l0
02/0oooo1P3o002X0?ooo`00T@3oool70?l002D0oooo1`3o00060?ooo`030000003o0000o`0000H0
o`00:`3oool80?l00:X0oooo002D0?ooo`L0o`009@3oool?0?l002/0oooo203o002^0?ooo`00V03o
ool:0?l001d0oooo3@3o000Z0?ooo`P0o`00/P3oool009/0oooo3@3o000@0?ooo`h0o`000P3oool7
0?l002<0oooo203o002f0?ooo`00XP3ooolM0?l000/0oooo00<000000?ooo`3o00002P3o000C0?oo
o``0o`00^P3oool00:P0oooo4@3o000A0?ooo`030000003oool0oooo0080oooo8`3o002n0?ooo`00
bP3oool00`000000oooo0?ooo`0:0?oooa<0o`00aP3oool00<X0oooo00<000000?ooo`3oool0h`3o
ool00<X0oooo00<000000?ooo`3oool0h`3oool00<X0oooo00<000000?ooo`3oool0h`3oool00<X0
oooo00<000000?ooo`3oool0h`3oool00<X0oooo00<000000?ooo`3oool0h`3oool00<X0oooo00<0
00000?ooo`3oool0h`3oool00<X0oooo00<000000?ooo`3oool0h`3oool00<X0oooo00<000000?oo
o`3oool0h`3oool00<X0oooo00<000000?ooo`3oool0h`3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3o
ool00<H0oooo00<0oono07@0000000000P0000000`00M;l0oooo0?ooo`3R0?ooo`00b@3oool00`3o
_g@007Bo0?ooo`3T0?ooo`00bP3oool00`2LB4P0W=oo0?ooo`3S0?ooo`00b@3oool00`3ookl0M000
001d_`3T0?ooo`00b@3oool0103OW4P007Bo0;md001d_ooS0?ooo`00b@3oool0102LB4P0W=oo0?oO
W018B9cS0?ooo`00b03oool01P3o_g@007Bo0?ooo`3oool0_g@007Boon80oooo00380?ooo`0609a8
B02Lgol0oooo0?ooo`3ogi`0B4RLhP3oool00<L0oooo00P0_g@00000000007@0_ooo0?oo_`1d0000
0000001d_n40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-67.5219, -65.587, 0.499087, \
0.4901}}],

Cell[BoxData[
    \("After more revolutions, Yes or No?"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("Finished"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[12]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[12]="]
}, Open  ]],

Cell["\<\

In this example we see, highly emphasized by the smallness of the orbit and \
by its large eccentricity the phenomenon of perastron advance.\
\>", "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
With a = 10 , \[Epsilon] = 0.1
\
\>", "Subsection"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(periastro\)\)\)], "Input",
  CellLabel->"In[13]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("We make a comparison between orbits in Newton's Theory"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("and in Schwarzschild geometry"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("Input of geometrical parameters"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("PLOT of the ORBIT with the following parameters:"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    InterpretationBox[\("Semilatus rectum =  "\[InvisibleSpace]10\
\[InvisibleSpace]"m"\),
      SequenceForm[ "Semilatus rectum =  ", 10, "m"],
      Editable->False]], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    InterpretationBox[\("eccentricity =  "\[InvisibleSpace]0.1`\),
      SequenceForm[ "eccentricity =  ", .10000000000000001],
      Editable->False]], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("Keplerian orbit with these parameters"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.547617 0.0476192 0.309017 0.0295785 [
[1.025 .30902 0 -6.28125 ]
[1.025 .30902 10 6.28125 ]
[.54762 .64303 -5 0 ]
[.54762 .64303 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .30902 m
1 .30902 L
s
gsave
1.025 .30902 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.54762 0 m
.54762 .61803 L
s
gsave
.54762 .64303 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.006 w
.97619 .30902 m
.97618 .31108 L
.97615 .31296 L
.97609 .31513 L
.97601 .31718 L
.97581 .32082 L
.97551 .32477 L
.97508 .32913 L
.97451 .33373 L
.97319 .34199 L
.97144 .35048 L
.96944 .35841 L
.96357 .37634 L
.95572 .39438 L
.94691 .41062 L
.92148 .44598 L
.89324 .47499 L
.85619 .50434 L
.81536 .52953 L
.76622 .55303 L
.71073 .57293 L
.68371 .58053 L
.65422 .58746 L
.62619 .5928 L
.59468 .59744 L
.58064 .59907 L
.56545 .60053 L
.55101 .60163 L
.53776 .60239 L
.53062 .60271 L
.52271 .60298 L
.51873 .60309 L
.51444 .60318 L
.51038 .60325 L
.50665 .60329 L
.50316 .60331 L
.49992 .60332 L
.49635 .60331 L
.49254 .60328 L
.48853 .60323 L
.48474 .60317 L
.47765 .60299 L
.46967 .60272 L
.46122 .60234 L
.44605 .60142 L
.42975 .6001 L
.41184 .59823 L
.37986 .5938 L
.35094 .58853 L
.28768 .57244 L
Mistroke
.23323 .5528 L
.17868 .52622 L
.13273 .49635 L
.09144 .4602 L
.07439 .44102 L
.05858 .41941 L
.04719 .40011 L
.03723 .37839 L
.03345 .36796 L
.0301 .35669 L
.02758 .34598 L
.02584 .33619 L
.02507 .33042 L
.02452 .32508 L
.02429 .32229 L
.02409 .31921 L
.02401 .31766 L
.02394 .316 L
.02389 .31442 L
.02385 .31298 L
.02381 .31032 L
.02381 .30786 L
.02385 .30515 L
.02389 .30363 L
.02393 .30226 L
.02406 .29947 L
.02424 .29646 L
.0247 .291 L
.02527 .28593 L
.02605 .2805 L
.02785 .27073 L
.03068 .25918 L
.03391 .24871 L
.04302 .22627 L
.05423 .20551 L
.08283 .16709 L
.11679 .13431 L
.15767 .10444 L
.20933 .0759 L
.26284 .05381 L
.29191 .0443 L
.32465 .03539 L
.35437 .02882 L
.38664 .02318 L
.40465 .02068 L
.42109 .01878 L
.43674 .01732 L
.45333 .01613 L
.46059 .01572 L
.46838 .01536 L
Mistroke
.47285 .01519 L
.47693 .01506 L
.48108 .01495 L
.48493 .01486 L
.48839 .0148 L
.49207 .01476 L
.49615 .01472 L
.49984 .01472 L
.50334 .01472 L
.50712 .01475 L
.51069 .01479 L
.51396 .01484 L
.51775 .01492 L
.5218 .01502 L
.5291 .01527 L
.53776 .01564 L
.54562 .01607 L
.56263 .01727 L
.5786 .01875 L
.60793 .02237 L
.63841 .02742 L
.69106 .03944 L
.74326 .05601 L
.78842 .07484 L
.83346 .09892 L
.86987 .12365 L
.90194 .1512 L
.93069 .18348 L
.95162 .2157 L
.96057 .23427 L
.96697 .25138 L
.971 .26567 L
.97369 .27892 L
.97472 .28587 L
.97518 .28987 L
.97553 .29352 L
.97582 .29738 L
.97593 .29937 L
.97604 .30153 L
.97611 .30352 L
.97615 .30537 L
.97618 .30714 L
.97619 .30902 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 177.938},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`00012R000`400?l00000o`00003og@3oool0
0`000000oooo0?ooo`3@0?ooo`00g@3oool00`000000oooo0?ooo`3@0?ooo`00g@3oool00`000000
oooo0?ooo`3@0?ooo`00g@3oool00`000000oooo0?ooo`3@0?ooo`00g@3oool00`000000oooo0?oo
o`3@0?ooo`00_`3ooolK000000<0oooo00<000000?ooo`3oool0d03oool00:`0oooo?@0000370?oo
o`00YP3ooolJ000001T0oooo6`00002l0?ooo`00W`3oool=00000340oooo00<000000?ooo`3oool0
2@3ooolA00000;H0oooo002I0?ooo`d00000=`3oool00`000000oooo0?ooo`0D0?ooo``00000/03o
ool009<0oooo3000000n0?ooo`030000003oool0oooo01X0oooo2P00002/0?ooo`00S@3oool<0000
04@0oooo00<000000?ooo`3oool0803oool800000:P0oooo00270?ooo``00000BP3oool00`000000
oooo0?ooo`0T0?ooo`P00000Y03oool008@0oooo2@00001@0?ooo`030000003oool0oooo02P0oooo
2000002P0?ooo`00P@3oool7000005D0oooo00<000000?ooo`3oool0;03oool8000009`0oooo001n
0?ooo`L00000F03oool00`000000oooo0?ooo`0`0?ooo`P00000V03oool007/0oooo1`00001K0?oo
o`030000003oool0oooo03@0oooo1`00002E0?ooo`00N03oool7000005h0oooo00<000000?ooo`3o
ool0>03oool600000980oooo001d0?ooo`L00000HP3oool00`000000oooo0?ooo`0k0?ooo`L00000
SP3oool00700oooo2000001U0?ooo`030000003oool0oooo03h0oooo1`00002;0?ooo`00KP3oool6
000006T0oooo00<000000?ooo`3oool0@P3oool6000008P0oooo001[0?ooo`H00000K03oool00`00
0000oooo0?ooo`150?ooo`L00000Q03oool006T0oooo1P00001^0?ooo`030000003oool0oooo04P0
oooo1P0000220?ooo`00I`3oool500000740oooo00<000000?ooo`3oool0B`3oool6000007l0oooo
001T0?ooo`H00000L`3oool00`000000oooo0?ooo`1=0?ooo`H00000O@3oool00680oooo1P00001e
0?ooo`030000003oool0oooo0500oooo1P00001j0?ooo`00H03oool5000007P0oooo00<000000?oo
o`3oool0DP3oool6000007P0oooo001M0?ooo`H00000NP3oool00`000000oooo0?ooo`1E0?ooo`H0
0000M@3oool005/0oooo1P00001l0?ooo`030000003oool0oooo05L0oooo1P00001c0?ooo`00F@3o
ool5000007l0oooo00<000000?ooo`3oool0FP3oool400000780oooo001G0?ooo`D00000P@3oool0
0`000000oooo0?ooo`1L0?ooo`@00000L03oool005H0oooo100000230?ooo`030000003oool0oooo
05d0oooo1@00001^0?ooo`00E03oool4000008D0oooo00<000000?ooo`3oool0G`3oool4000006d0
oooo001B0?ooo`D00000QP3oool00`000000oooo0?ooo`1Q0?ooo`@00000J`3oool00500oooo1@00
00280?ooo`030000003oool0oooo0680oooo1@00001Y0?ooo`00CP3oool5000008X0oooo00<00000
0?ooo`3oool0I03oool5000006L0oooo001<0?ooo`D00000S03oool00`000000oooo0?ooo`1V0?oo
o`@00000IP3oool004/0oooo1000002>0?ooo`030000003oool0oooo06P0oooo1000001T0?ooo`00
B@3oool400000900oooo00<000000?ooo`3oool0J@3oool500000680oooo00170?ooo`D00000T@3o
ool00`000000oooo0?ooo`1[0?ooo`@00000H@3oool004H0oooo1000002C0?ooo`030000003oool0
oooo06d0oooo1000001O0?ooo`00A03oool4000009D0oooo00<000000?ooo`3oool0KP3oool40000
05h0oooo00130?ooo`@00000UP3oool00`000000oooo0?ooo`1`0?ooo`@00000G03oool00440oooo
1000002H0?ooo`030000003oool0oooo0740oooo1000001K0?ooo`00@03oool4000009T0oooo00<0
00000?ooo`3oool0L`3oool4000005T0oooo000n0?ooo`@00000V`3oool00`000000oooo0?ooo`1d
0?ooo`@00000F03oool003d0oooo1000002L0?ooo`030000003oool0oooo07H0oooo1000001F0?oo
o`00>`3oool4000009h0oooo00<000000?ooo`3oool0M`3oool4000005D0oooo000j0?ooo`@00000
W`3oool00`000000oooo0?ooo`1i0?ooo`<00000E03oool003P0oooo1000002Q0?ooo`030000003o
ool0oooo07X0oooo0`00001C0?ooo`00=`3oool400000:80oooo00<000000?ooo`3oool0N`3oool3
00000580oooo000f0?ooo`<00000Y03oool00`000000oooo0?ooo`1l0?ooo`<00000D@3oool003D0
oooo0`00002U0?ooo`030000003oool0oooo07d0oooo1000001?0?ooo`00=03oool300000:H0oooo
00<000000?ooo`3oool0OP3oool4000004h0oooo000c0?ooo`<00000Y`3oool00`000000oooo0?oo
o`200?ooo`<00000C@3oool00380oooo0`00002X0?ooo`030000003oool0oooo0840oooo0`00001<
0?ooo`00<@3oool300000:T0oooo00<000000?ooo`3oool0PP3oool3000004/0oooo000`0?ooo`<0
0000ZP3oool00`000000oooo0?ooo`230?ooo`<00000BP3oool002l0oooo0`00002[0?ooo`030000
003oool0oooo08@0oooo0`0000190?ooo`00;P3oool300000:`0oooo00<000000?ooo`3oool0Q@3o
ool3000004P0oooo000]0?ooo`<00000[@3oool00`000000oooo0?ooo`260?ooo`<00000A`3oool0
02`0oooo0`00002^0?ooo`030000003oool0oooo08L0oooo0`0000160?ooo`00:`3oool300000:l0
oooo00<000000?ooo`3oool0R03oool3000004D0oooo000Z0?ooo`<00000/03oool00`000000oooo
0?ooo`290?ooo`800000A@3oool002X0oooo0P00002a0?ooo`030000003oool0oooo08X0oooo0P00
00140?ooo`00:@3oool200000;80oooo00<000000?ooo`3oool0RP3oool3000004<0oooo000X0?oo
o`800000/`3oool00`000000oooo0?ooo`2;0?ooo`<00000@P3oool002L0oooo0P00002d0?ooo`03
0000003oool0oooo08`0oooo0`0000110?ooo`009`3oool00`000000oooo0?ooo`2c0?ooo`030000
003oool0oooo08d0oooo0`0000100?ooo`009P3oool200000;D0oooo00<000000?ooo`3oool0SP3o
ool3000003l0oooo000U0?ooo`800000]P3oool00`000000oooo0?ooo`2?0?ooo`800000?`3oool0
02@0oooo0P00002g0?ooo`030000003oool0oooo0900oooo0P00000n0?ooo`00903oool00`000000
oooo0?ooo`2f0?ooo`030000003oool0oooo0940oooo0P00000m0?ooo`008`3oool200000;P0oooo
00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`0k0?ooo`008P3oool200000;T0oooo00<0
00000?ooo`3oool0TP3oool2000003`0oooo000R0?ooo`030000003oool0oooo0;P0oooo00<00000
0?ooo`3oool0T`3oool2000003/0oooo000Q0?ooo`800000^P3oool00`000000oooo0?ooo`2D0?oo
o`030000003oool0oooo03T0oooo000P0?ooo`800000^`3oool00`000000oooo0?ooo`2D0?ooo`80
0000>P3oool001l0oooo0P00002l0?ooo`030000003oool0oooo09D0oooo0P00000i0?ooo`007`3o
ool00`000000oooo0?ooo`2k0?ooo`030000003oool0oooo09H0oooo00<000000?ooo`3oool0=`3o
ool001h0oooo0P00002m0?ooo`030000003oool0oooo09H0oooo0P00000h0?ooo`007P3oool00`00
0000oooo0?ooo`2l0?ooo`030000003oool0oooo09L0oooo0P00000g0?ooo`007@3oool200000;h0
oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`0e0?ooo`007@3oool00`000000oooo
0?ooo`2m0?ooo`030000003oool0oooo09P0oooo0P00000f0?ooo`00703oool200000;l0oooo00<0
00000?ooo`3oool0V@3oool00`000000oooo0?ooo`0d0?ooo`00703oool00`000000oooo0?ooo`2n
0?ooo`030000003oool0oooo09T0oooo0P00000e0?ooo`006`3oool200000<00oooo00<000000?oo
o`3oool0VP3oool00`000000oooo0?ooo`0c0?ooo`006`3oool00`000000oooo0?ooo`2o0?ooo`03
0000003oool0oooo09X0oooo0P00000d0?ooo`006P3oool200000<40oooo00<000000?ooo`3oool0
V`3oool00`000000oooo0?ooo`0b0?ooo`006P3oool200000<40oooo00<000000?ooo`3oool0V`3o
ool2000003<0oooo000I0?ooo`<00000`@3oool00`000000oooo0?ooo`2L0?ooo`030000003oool0
oooo0340oooo000I0?ooo`800000`P3oool00`000000oooo0?ooo`2L0?ooo`800000<P3oool001P0
oooo0`0000320?ooo`030000003oool0oooo09`0oooo0P00000b0?ooo`00603oool200000<<0oooo
00<000000?ooo`3oool0W03oool300000340oooo000H0?ooo`800000``3oool00`000000oooo0?oo
o`2M0?ooo`800000<@3oool001P0oooo00<000000?ooo`3oool0`P3oool00`000000oooo0?ooo`2M
0?ooo`800000<@3oool001L0oooo0P0000340?ooo`030000003oool0oooo09d0oooo0`00000`0?oo
o`005`3oool00`000000oooo0?ooo`330?ooo`030000003oool0oooo09h0oooo0P00000`0?ooo`00
5P3oool200000<D0oooo00<000000?ooo`3oool0WP3oool200000300oooo000F0?ooo`030000003o
ool0oooo0<@0oooo00<000000?ooo`3oool0WP3oool3000002l0oooo000E0?ooo`800000aP3oool0
0`000000oooo0?ooo`2O0?ooo`800000;`3oool001D0oooo0P0000360?ooo`030000003oool0oooo
09l0oooo0P00000_0?ooo`005@3oool200000<H0oooo00<000000?ooo`3oool0W`3oool2000002l0
oooo000E0?ooo`800000aP3oool00`000000oooo0?ooo`2P0?ooo`800000;P3oool001@0oooo0P00
00370?ooo`030000003oool0oooo0:00oooo0P00000^0?ooo`00503oool200000<L0oooo00<00000
0?ooo`3oool0X03oool2000002h0oooo000D0?ooo`800000a`3oool00`000000oooo0?ooo`2P0?oo
o`800000;P3oool001@0oooo0P0000370?ooo`030000003oool0oooo0:00oooo0P00000^0?ooo`00
503oool200000<L0oooo00<000000?ooo`3oool0X03oool2000002h0oooo000D0?ooo`030000003o
ool0oooo0<H0oooo00<000000?ooo`3oool0X03oool2000002h0oooo000C0?ooo`800000b03oool0
0`000000oooo0?ooo`2P0?ooo`800000;P3oool001<0oooo0P0000380?ooo`030000003oool0oooo
0:00oooo0P00000^0?ooo`004`3oool200000<P0oooo00<000000?ooo`3oool0X03oool2000002h0
oooo000C0?ooo`800000b03oool00`000000oooo0?ooo`2P0?ooo`800000;P3oool001<0oooo0P00
00380?ooo`030000003oool0oooo0:00oooo0`00000]0?ooo`004`3oool200000<P0oooo00<00000
0?ooo`3oool0X@3oool2000002d0oooo000C0?ooo`800000b03oool00`000000oooo0?ooo`2Q0?oo
o`800000503oool01P3OW4P0000000000000M;l0oooo0;md0080000000<0B9cO0?ooo`3oool03P3o
ool001<0oooo0P0000380?ooo`030000003oool0oooo0:40oooo0P00000E0?ooo`070?noM0000000
M;oo0?ooo`3o_g@0000007Boo`0A0?ooo`002`3ooooo0000088000003@3oool01@3ookl0M01804Qd
B01807@0_ooo0180oooo000C0?ooo`800000b03oool00`000000oooo0?ooo`2Q0?ooo`8000005`3o
ool00`2LB000B4Q80018W00C0?ooo`004`3oool200000<P0oooo00<000000?ooo`3oool0X@3oool2
000001D0oooo00L0oono07@00018W=l0oooo0=nLB00007@0_ooo0140oooo000C0?ooo`800000b03o
ool00`000000oooo0?ooo`2Q0?ooo`800000503oool02@3ogi`0B00000000000M;l0oooo0;md0000
0000001809cOo`0@0?ooo`004`3oool200000<P0oooo00<000000?ooo`3oool0X@3oool2000002d0
oooo000C0?ooo`800000b03oool00`000000oooo0?ooo`2Q0?ooo`030000003oool0oooo02`0oooo
000C0?ooo`800000b03oool00`000000oooo0?ooo`2P0?ooo`800000;P3oool001<0oooo0P000038
0?ooo`030000003oool0oooo0:00oooo0P00000^0?ooo`004`3oool200000<P0oooo00<000000?oo
o`3oool0X03oool2000002h0oooo000D0?ooo`030000003oool0oooo0<H0oooo00<000000?ooo`3o
ool0X03oool2000002h0oooo000D0?ooo`800000a`3oool00`000000oooo0?ooo`2P0?ooo`800000
;P3oool001D0oooo00<000000?ooo`3oool0a@3oool00`000000oooo0?ooo`2P0?ooo`800000;P3o
ool001@0oooo0P0000370?ooo`030000003oool0oooo0:00oooo0P00000^0?ooo`00503oool20000
0<L0oooo00<000000?ooo`3oool0W`3oool3000002h0oooo000D0?ooo`800000a`3oool00`000000
oooo0?ooo`2O0?ooo`800000;`3oool001@0oooo0`0000360?ooo`030000003oool0oooo09l0oooo
0P00000_0?ooo`005@3oool200000<H0oooo00<000000?ooo`3oool0W`3oool2000002l0oooo000E
0?ooo`800000aP3oool00`000000oooo0?ooo`2O0?ooo`800000;`3oool001D0oooo0P0000360?oo
o`030000003oool0oooo09l0oooo0P00000_0?ooo`005@3oool300000<D0oooo00<000000?ooo`3o
ool0WP3oool3000002l0oooo000F0?ooo`800000a@3oool00`000000oooo0?ooo`2N0?ooo`800000
<03oool001H0oooo0P0000350?ooo`030000003oool0oooo09h0oooo0P00000`0?ooo`005P3oool2
00000<D0oooo00<000000?ooo`3oool0W@3oool300000300oooo000G0?ooo`030000003oool0oooo
0<<0oooo00<000000?ooo`3oool0W@3oool200000340oooo000G0?ooo`800000a03oool00`000000
oooo0?ooo`2M0?ooo`800000<@3oool001P0oooo00<000000?ooo`3oool0`P3oool00`000000oooo
0?ooo`2M0?ooo`800000<@3oool001P0oooo0P0000330?ooo`030000003oool0oooo09`0oooo0`00
000a0?ooo`006@3oool00`000000oooo0?ooo`310?ooo`030000003oool0oooo09`0oooo0P00000b
0?ooo`006@3oool200000<80oooo00<000000?ooo`3oool0V`3oool300000380oooo000J0?ooo`03
0000003oool0oooo0<00oooo00<000000?ooo`3oool0V`3oool2000003<0oooo000J0?ooo`800000
`@3oool00`000000oooo0?ooo`2K0?ooo`800000<`3oool001/0oooo00<000000?ooo`3oool0_`3o
ool00`000000oooo0?ooo`2J0?ooo`<00000<`3oool001/0oooo0P0000300?ooo`030000003oool0
oooo09X0oooo0P00000d0?ooo`00703oool00`000000oooo0?ooo`2n0?ooo`030000003oool0oooo
09X0oooo00<000000?ooo`3oool0<`3oool001`0oooo0P00002o0?ooo`030000003oool0oooo09T0
oooo0P00000e0?ooo`007@3oool00`000000oooo0?ooo`2m0?ooo`030000003oool0oooo09P0oooo
0P00000f0?ooo`007@3oool200000;h0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?oo
o`0e0?ooo`007P3oool00`000000oooo0?ooo`2l0?ooo`030000003oool0oooo09L0oooo0P00000g
0?ooo`007P3oool200000;d0oooo00<000000?ooo`3oool0UP3oool2000003P0oooo000O0?ooo`03
0000003oool0oooo0;/0oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`0g0?ooo`00
7`3oool200000;`0oooo00<000000?ooo`3oool0U@3oool2000003T0oooo000P0?ooo`030000003o
ool0oooo0;X0oooo00<000000?ooo`3oool0U03oool2000003X0oooo000P0?ooo`800000^`3oool0
0`000000oooo0?ooo`2D0?ooo`030000003oool0oooo03T0oooo000Q0?ooo`030000003oool0oooo
0;T0oooo00<000000?ooo`3oool0T`3oool2000003/0oooo000Q0?ooo`800000^P3oool00`000000
oooo0?ooo`2B0?ooo`800000?03oool00280oooo0P00002i0?ooo`030000003oool0oooo0980oooo
00<000000?ooo`3oool0>`3oool002<0oooo0P00002h0?ooo`030000003oool0oooo0940oooo0P00
000m0?ooo`00903oool00`000000oooo0?ooo`2f0?ooo`030000003oool0oooo0940oooo00<00000
0?ooo`3oool0?03oool002@0oooo0P00002g0?ooo`030000003oool0oooo0900oooo0P00000n0?oo
o`009@3oool200000;H0oooo00<000000?ooo`3oool0S`3oool2000003l0oooo000V0?ooo`800000
]@3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo03h0oooo000W0?ooo`800000]03o
ool00`000000oooo0?ooo`2>0?ooo`800000@03oool002L0oooo0`00002c0?ooo`030000003oool0
oooo08d0oooo0P0000110?ooo`00:03oool300000;80oooo00<000000?ooo`3oool0S03oool20000
0480oooo000Y0?ooo`<00000/@3oool00`000000oooo0?ooo`2;0?ooo`<00000@P3oool002X0oooo
0`00002`0?ooo`030000003oool0oooo08X0oooo0`0000130?ooo`00:`3oool300000:l0oooo00<0
00000?ooo`3oool0R@3oool3000004@0oooo000/0?ooo`<00000[P3oool00`000000oooo0?ooo`28
0?ooo`<00000A@3oool002d0oooo0`00002]0?ooo`030000003oool0oooo08L0oooo0`0000160?oo
o`00;P3oool300000:`0oooo00<000000?ooo`3oool0QP3oool3000004L0oooo000_0?ooo`<00000
Z`3oool00`000000oooo0?ooo`250?ooo`<00000B03oool00300oooo1000002Y0?ooo`030000003o
ool0oooo08@0oooo0`0000190?ooo`00<@3oool400000:P0oooo00<000000?ooo`3oool0P`3oool3
000004X0oooo000c0?ooo`<00000Y`3oool00`000000oooo0?ooo`220?ooo`<00000B`3oool003@0
oooo0`00002V0?ooo`030000003oool0oooo0840oooo0`00001<0?ooo`00=@3oool300000:D0oooo
00<000000?ooo`3oool0O`3oool4000004d0oooo000f0?ooo`<00000Y03oool00`000000oooo0?oo
o`1n0?ooo`@00000CP3oool003L0oooo0`00002S0?ooo`030000003oool0oooo07d0oooo0`00001@
0?ooo`00>03oool400000:40oooo00<000000?ooo`3oool0O03oool300000540oooo000i0?ooo`@0
0000X03oool00`000000oooo0?ooo`1j0?ooo`@00000DP3oool003/0oooo0`00002O0?ooo`030000
003oool0oooo07T0oooo1000001C0?ooo`00?03oool3000009h0oooo00<000000?ooo`3oool0N03o
ool3000005D0oooo000m0?ooo`<00000W@3oool00`000000oooo0?ooo`1g0?ooo`<00000EP3oool0
03h0oooo1000002K0?ooo`030000003oool0oooo07D0oooo1000001G0?ooo`00?`3oool4000009X0
oooo00<000000?ooo`3oool0M03oool4000005P0oooo00110?ooo`@00000V03oool00`000000oooo
0?ooo`1b0?ooo`@00000FP3oool00480oooo1000002G0?ooo`030000003oool0oooo0740oooo1000
001K0?ooo`00A03oool3000009H0oooo00<000000?ooo`3oool0K`3oool4000005d0oooo00150?oo
o`@00000U03oool00`000000oooo0?ooo`1^0?ooo`@00000GP3oool004H0oooo1000002C0?ooo`03
0000003oool0oooo06`0oooo1000001P0?ooo`00B03oool400000940oooo00<000000?ooo`3oool0
JP3oool500000640oooo00190?ooo`@00000T03oool00`000000oooo0?ooo`1Y0?ooo`@00000H`3o
ool004/0oooo1000002>0?ooo`030000003oool0oooo06L0oooo1000001U0?ooo`00C03oool40000
08d0oooo00<000000?ooo`3oool0IP3oool4000006H0oooo001>0?ooo`@00000R`3oool00`000000
oooo0?ooo`1T0?ooo`@00000J03oool004l0oooo1@0000290?ooo`030000003oool0oooo0680oooo
1@00001Y0?ooo`00D@3oool5000008L0oooo00<000000?ooo`3oool0H03oool5000006/0oooo001C
0?ooo`D00000Q@3oool00`000000oooo0?ooo`1N0?ooo`D00000K@3oool005D0oooo1@0000230?oo
o`030000003oool0oooo05`0oooo1@00001_0?ooo`00E`3oool600000800oooo00<000000?ooo`3o
ool0F@3oool600000740oooo001I0?ooo`H00000OP3oool00`000000oooo0?ooo`1G0?ooo`H00000
L`3oool005`0oooo1@00001l0?ooo`030000003oool0oooo05D0oooo1@00001f0?ooo`00GP3oool5
000007X0oooo00<000000?ooo`3oool0D`3oool5000007P0oooo001P0?ooo`D00000N03oool00`00
0000oooo0?ooo`1A0?ooo`D00000NP3oool00680oooo1P00001e0?ooo`030000003oool0oooo04h0
oooo1P00001l0?ooo`00I03oool6000007<0oooo00<000000?ooo`3oool0C03oool6000007h0oooo
001W0?ooo`H00000L03oool00`000000oooo0?ooo`190?ooo`H00000P@3oool006T0oooo1P00001^
0?ooo`030000003oool0oooo04H0oooo1`0000230?ooo`00K03oool6000006/0oooo00<000000?oo
o`3oool0A03oool6000008H0oooo001^0?ooo`L00000J03oool00`000000oooo0?ooo`110?ooo`H0
0000R@3oool00740oooo1P00001V0?ooo`030000003oool0oooo03l0oooo1P00002;0?ooo`00M03o
ool6000006<0oooo00<000000?ooo`3oool0?03oool6000008h0oooo001f0?ooo`L00000H03oool0
0`000000oooo0?ooo`0i0?ooo`L00000T03oool007T0oooo2000001L0?ooo`030000003oool0oooo
03D0oooo1`00002D0?ooo`00O@3oool8000005P0oooo00<000000?ooo`3oool0<@3oool8000009L0
oooo00210?ooo`P00000E03oool00`000000oooo0?ooo`0/0?ooo`T00000V`3oool008D0oooo2000
001@0?ooo`030000003oool0oooo02H0oooo2`00002O0?ooo`00R@3oool8000004`0oooo00<00000
0?ooo`3oool08@3oool;00000:@0oooo002=0?ooo`X00000AP3oool00`000000oooo0?ooo`0K0?oo
o`/00000ZP3oool00940oooo300000100?ooo`030000003oool0oooo01D0oooo3000002_0?ooo`00
U`3ooolB000003@0oooo00<000000?ooo`3oool03`3oool<00000;D0oooo002M0?oooa<00000;@3o
ool00`000000oooo0?ooo`0:0?ooo`/00000^`3oool00:T0oooo3@00000W0?oooa800000`@3oool0
0;00oooo>P0000360?ooo`00]P3ooolX00000=80oooo003M0?ooo`030000003oool0oooo0=00oooo
003M0?ooo`030000003oool0oooo0=00oooo003M0?ooo`030000003oool0oooo0=00oooo003M0?oo
o`030000003oool0oooo0=00oooo003M0?ooo`030000003oool0oooo0=00oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo
003o0?oook40oooo003H0?ooo`030?oo_`1d000000000080000000<007Bo0?ooo`3oool0d03oool0
0=/0oooo00<0okmd001d_`3oool0dP3oool00=`0oooo00<0W4Q809cOo`3oool0d@3oool00=/0oooo
00<0oono07@00000M;l0dP3oool00=/0oooo00@0gia8001d_`2oM000M;ood@3oool00=/0oooo00@0
W4Q809cOo`3ogi`0B4RLd@3oool00=X0oooo00H0okmd001d_`3oool0oooo0;md001d_oo@0?ooo`00
fP3oool01P2LB4P0W=oo0?ooo`3oool0omnL04Q8W=00oooo003I0?ooo`080;md00000000001d0;oo
o`3ookl0M00000000000M;o?0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00
o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00o`3ooona0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 431}, {265.875, 0}} -> {-12.1076, -10.4475, \
0.081996, 0.132008}}],

Cell[BoxData[
    \("==========================="\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("The Schwarzschild orbit with the same parameters"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    InterpretationBox[\("After "\[InvisibleSpace]1\[InvisibleSpace]" \
revolutions"\),
      SequenceForm[ "After ", 1, " revolutions"],
      Editable->False]], "Print",
  CellLabel->"From In[13]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.285739 0.0951853 0.348623 0.0697298 [
[1.025 .34862 0 -6.28125 ]
[1.025 .34862 10 6.28125 ]
[.28574 1.025 -5 0 ]
[.28574 1.025 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .34862 m
1 .34862 L
s
gsave
1.025 .34862 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.28574 0 m
.28574 1 L
s
gsave
.28574 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.006 w
.28574 .97619 m
.29238 .97617 L
.29843 .9761 L
.3054 .97598 L
.312 .97582 L
.32371 .97542 L
.33642 .97482 L
.35039 .97397 L
.36516 .97283 L
.39157 .97021 L
.41863 .96672 L
.44377 .96275 L
.50005 .95118 L
.5557 .93588 L
.60467 .91894 L
.70656 .87133 L
.78386 .82063 L
.85438 .7574 L
.90679 .69174 L
.9297 .6534 L
.94647 .61797 L
.9595 .582 L
.96814 .54877 L
.9714 .5314 L
.97401 .51238 L
.97493 .50282 L
.97533 .49757 L
.97564 .49261 L
.97587 .488 L
.97596 .48557 L
.97605 .483 L
.97615 .47846 L
.97619 .47426 L
.97619 .47024 L
.97613 .46585 L
.97601 .46127 L
.97585 .45702 L
.97566 .45304 L
.97544 .44943 L
.97483 .44134 L
.97397 .43268 L
.9728 .42334 L
.97007 .40654 L
.9668 .3909 L
.96261 .37456 L
.95329 .34589 L
.94078 .31602 L
.92467 .28518 L
.88914 .23314 L
.83915 .17949 L
Mistroke
.78451 .13559 L
.72534 .09932 L
.66717 .07211 L
.6327 .05925 L
.59986 .04902 L
.57041 .04141 L
.53807 .03467 L
.50563 .02957 L
.48801 .02747 L
.47166 .02595 L
.46381 .02536 L
.45642 .0249 L
.44971 .02454 L
.44262 .02425 L
.43897 .02412 L
.43495 .02401 L
.4313 .02393 L
.42788 .02387 L
.42388 .02383 L
.42022 .02381 L
.41621 .02381 L
.412 .02384 L
.40807 .0239 L
.40586 .02394 L
.40383 .02398 L
.39616 .0242 L
.38922 .02448 L
.38193 .02486 L
.36691 .02591 L
.35063 .02745 L
.32234 .0312 L
.29671 .03582 L
.2677 .04254 L
.24139 .05014 L
.19551 .0673 L
.15176 .08941 L
.11667 .11271 L
.08675 .13845 L
.06044 .1687 L
.04228 .19809 L
.03482 .2148 L
.03214 .22221 L
.0297 .23011 L
.0277 .23795 L
.02624 .24504 L
.02512 .25212 L
.02473 .25529 L
.02439 .25877 L
.0241 .26251 L
.02399 .26455 L
Mistroke
.02391 .26645 L
.02385 .26822 L
.02382 .26984 L
.02381 .2717 L
.02382 .27347 L
.02386 .27536 L
.02389 .27641 L
.02392 .27737 L
.02401 .27922 L
.02411 .28096 L
.02441 .28485 L
.02486 .28903 L
.02589 .29598 L
.02716 .30236 L
.03108 .31647 L
.03624 .32963 L
.04312 .343 L
.05073 .35474 L
.06016 .36664 L
.07997 .38573 L
.10206 .40111 L
.11408 .40762 L
.1274 .41359 L
.14004 .41819 L
.15171 .42159 L
.16286 .42412 L
.1745 .42603 L
.18065 .42675 L
.18617 .42723 L
.18921 .42742 L
.1908 .4275 L
.19247 .42757 L
.19393 .42762 L
.1947 .42764 L
.19553 .42766 L
.19698 .42768 L
.19833 .42769 L
.19976 .42769 L
.20108 .42769 L
.20252 .42766 L
.20333 .42765 L
.20405 .42763 L
.20539 .42759 L
.20682 .42753 L
.20939 .4274 L
.21189 .42724 L
.21451 .42703 L
.21911 .42656 L
.22445 .42585 L
.22918 .42506 L
Mistroke
.23932 .42284 L
.2481 .42027 L
.2558 .41745 L
.26347 .41399 L
.27078 .40996 L
.28171 .40204 L
.28574 .39825 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0
oooo>P3oool007@0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0oooo>P3oool007@0oooo00<000000?oo
o`3oool0o`3ooolj0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000
003oool0oooo0?l0oooo>P3oool007@0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool0
0`000000oooo0?ooo`0N0?ooobD0o`00mP3oool007@0oooo00<000000?ooo`3oool05`3ooolh0?l0
0>X0oooo001d0?ooo`030000003oool0oooo00`0oooo4P3o000T0?oooa/0o`00g03oool007@0oooo
00<000000?ooo`3oool01`3oool@0?l003P0oooo503o003F0?ooo`00M03oool00`000000oooo0?oo
o`020?ooo`X0o`00D@3oool;0?l00=40oooo001d0?ooo`030000003o0000o`0000L0o`00G03oool9
0?l00<d0oooo001a0?ooo`P0o`00IP3oool80?l00<T0oooo001]0?ooo`P0o`00KP3oool80?l00<D0
oooo001Z0?ooo`L0o`000`3oool00`000000oooo0?ooo`1`0?ooo`P0o`00`@3oool006H0oooo1`3o
00070?ooo`030000003oool0oooo07@0oooo203o002m0?ooo`00HP3oool80?l000X0oooo00<00000
0?ooo`3oool0N03oool80?l00;T0oooo001O0?ooo`L0o`003P3oool00`000000oooo0?ooo`1l0?oo
o`L0o`00]P3oool005d0oooo1P3o000A0?ooo`030000003oool0oooo0800oooo1P3o002c0?ooo`00
FP3oool60?l001@0oooo00<000000?ooo`3oool0P`3oool60?l00;00oooo001H0?ooo`H0o`005P3o
ool00`000000oooo0?ooo`260?ooo`L0o`00[03oool005D0oooo1P3o000I0?ooo`030000003oool0
oooo08T0oooo1`3o002Y0?ooo`00D`3oool60?l001/0oooo00<000000?ooo`3oool0S03oool60?l0
0:L0oooo001@0?ooo`H0o`007P3oool00`000000oooo0?ooo`2?0?ooo`H0o`00Y03oool004h0oooo
1P3o000P0?ooo`030000003oool0oooo0940oooo1`3o002Q0?ooo`00B`3oool60?l002<0oooo00<0
00000?ooo`3oool0U03oool60?l009l0oooo00190?ooo`H0o`009@3oool00`000000oooo0?ooo`2G
0?ooo`D0o`00W@3oool004L0oooo1@3o000X0?ooo`030000003oool0oooo09T0oooo1@3o002K0?oo
o`00A@3oool50?l002X0oooo00<000000?ooo`3oool0V`3oool50?l009T0oooo00120?ooo`H0o`00
;03oool00`000000oooo0?ooo`2M0?ooo`D0o`00U`3oool00400oooo1P3o000^0?ooo`030000003o
ool0oooo09l0oooo1P3o002D0?ooo`00?P3oool50?l00340oooo00<000000?ooo`3oool0X@3oool6
0?l00980oooo000m0?ooo`@0o`00<`3oool00`000000oooo0?ooo`2T0?ooo`D0o`00T03oool003/0
oooo103o000e0?ooo`030000003oool0oooo0:H0oooo1@3o002>0?ooo`00>P3oool40?l003H0oooo
00<000000?ooo`3oool0Z03oool50?l008`0oooo000h0?ooo`@0o`00>03oool00`000000oooo0?oo
o`2Z0?ooo`D0o`00RP3oool003L0oooo103o000i0?ooo`030000003oool0oooo0:`0oooo1@3o0028
0?ooo`00=P3oool30?l003/0oooo00<000000?ooo`3oool0[P3oool40?l008L0oooo000d0?ooo`@0
o`00?03oool00`000000oooo0?ooo`2`0?ooo`@0o`00Q@3oool003<0oooo103o000m0?ooo`030000
003oool0oooo0;40oooo103o00240?ooo`00<@3oool40?l003l0oooo00<000000?ooo`3oool0/`3o
ool40?l00880oooo000`0?ooo`@0o`00@03oool00`000000oooo0?ooo`2d0?ooo`D0o`00P03oool0
02l0oooo0`3o00120?ooo`030000003oool0oooo0;H0oooo103o001o0?ooo`00;P3oool30?l004<0
oooo00<000000?ooo`3oool0^03oool40?l007d0oooo000/0?ooo`@0o`00A03oool00`000000oooo
0?ooo`2i0?ooo`@0o`00O03oool002/0oooo103o00150?ooo`030000003oool0oooo0;/0oooo103o
001j0?ooo`00:P3oool30?l004L0oooo00<000000?ooo`3oool0_03oool50?l007P0oooo000Y0?oo
o`<0o`00B03oool00`000000oooo0?ooo`2n0?ooo`@0o`00M`3oool002P0oooo0`3o00190?ooo`03
0000003oool0oooo0<00oooo103o001e0?ooo`009P3oool40?l004X0oooo00<000000?ooo`3oool0
`@3oool40?l007@0oooo000U0?ooo`@0o`00B`3oool00`000000oooo0?ooo`330?ooo`@0o`00LP3o
ool002@0oooo0`3o001=0?ooo`030000003oool0oooo0<@0oooo103o001a0?ooo`008`3oool30?l0
04h0oooo00<000000?ooo`3oool0aP3oool30?l00700oooo000R0?ooo`<0o`00C`3oool00`000000
oooo0?ooo`370?ooo`@0o`00KP3oool00240oooo0`3o001@0?ooo`030000003oool0oooo0<P0oooo
103o001]0?ooo`008@3oool20?l00540oooo00<000000?ooo`3oool0bP3oool30?l006`0oooo000P
0?ooo`80o`00DP3oool00`000000oooo0?ooo`3;0?ooo`<0o`00J`3oool001l0oooo0`3o001B0?oo
o`030000003oool0oooo0<`0oooo103o001Y0?ooo`007P3oool30?l005<0oooo00<000000?ooo`3o
ool0c@3oool40?l006P0oooo000M0?ooo`<0o`00E03oool00`000000oooo0?ooo`3?0?ooo`<0o`00
I`3oool001`0oooo0`3o001E0?ooo`030000003oool0oooo0=00oooo0`3o001V0?ooo`00703oool2
0?l005H0oooo00<000000?ooo`3oool0d@3oool30?l006D0oooo000K0?ooo`80o`00E`3oool00`00
0000oooo0?ooo`3B0?ooo`@0o`00H`3oool001X0oooo0`3o001G0?ooo`030000003oool0oooo0=<0
oooo103o001R0?ooo`006P3oool20?l005P0oooo00<000000?ooo`3oool0e@3oool30?l00640oooo
000I0?ooo`80o`00F@3oool00`000000oooo0?ooo`3F0?ooo`<0o`00H03oool001P0oooo0P3o001J
0?ooo`030000003oool0oooo0=L0oooo103o001N0?ooo`00603oool00`3o0000oooo0?ooo`1I0?oo
o`030000003oool0oooo0=P0oooo103o001M0?ooo`005`3oool20?l005/0oooo00<000000?ooo`3o
ool0fP3oool30?l005`0oooo000F0?ooo`80o`00G03oool00`000000oooo0?ooo`3K0?ooo`<0o`00
F`3oool001H0oooo00<0o`000?ooo`3oool0F`3oool00`000000oooo0?ooo`3L0?ooo`<0o`00FP3o
ool001D0oooo0P3o001M0?ooo`030000003oool0oooo0=d0oooo0`3o001I0?ooo`00503oool20?l0
05h0oooo00<000000?ooo`3oool0gP3oool30?l005P0oooo000D0?ooo`030?l0003oool0oooo05d0
oooo00<000000?ooo`3oool0g`3oool30?l005L0oooo000C0?ooo`80o`00G`3oool00`000000oooo
0?ooo`3P0?ooo`<0o`00EP3oool00180oooo0P3o001P0?ooo`030000003oool0oooo0>40oooo0`3o
001E0?ooo`004P3oool00`3o0000oooo0?ooo`1O0?ooo`030000003oool0oooo0>80oooo0`3o001D
0?ooo`004@3oool20?l00640oooo00<000000?ooo`3oool0h`3oool30?l005<0oooo000@0?ooo`<0
o`00H@3oool00`000000oooo0?ooo`3T0?ooo`<0o`00DP3oool00100oooo0P3o001R0?ooo`030000
003oool0oooo0>D0oooo0P3o001B0?ooo`00403oool20?l00680oooo00<000000?ooo`3oool0iP3o
ool20?l00540oooo000?0?ooo`<0o`00HP3oool00`000000oooo0?ooo`3V0?ooo`<0o`00D03oool0
00l0oooo0P3o001S0?ooo`030000003oool0oooo0>L0oooo0`3o001?0?ooo`003P3oool30?l006<0
oooo00<000000?ooo`3oool0j03oool30?l004h0oooo000>0?ooo`80o`00I03oool00`000000oooo
0?ooo`3Y0?ooo`<0o`00C@3oool000h0oooo0P3o001T0?ooo`030000003oool0oooo0>X0oooo0`3o
001<0?ooo`003@3oool30?l006@0oooo00<000000?ooo`3oool0j`3oool30?l004/0oooo000=0?oo
o`80o`00I@3oool00`000000oooo0?ooo`3/0?ooo`<0o`00BP3oool000d0oooo0P3o001U0?ooo`03
0000003oool0oooo0>d0oooo0`3o00190?ooo`00303oool30?l006D0oooo00<000000?ooo`3oool0
kP3oool30?l004P0oooo000<0?ooo`80o`00IP3oool00`000000oooo0?ooo`3_0?ooo`80o`00B03o
ool000`0oooo0P3o001V0?ooo`030000003oool0oooo0?00oooo0P3o00170?ooo`00303oool20?l0
06H0oooo00<000000?ooo`3oool0l@3oool20?l004H0oooo000<0?ooo`80o`00IP3oool00`000000
oooo0?ooo`3b0?ooo`030?l0003oool0oooo04@0oooo000<0?ooo`80o`00IP3oool00`000000oooo
0?ooo`3b0?ooo`80o`00A@3oool000/0oooo0`3o001V0?ooo`030000003oool0oooo0?<0oooo0P3o
00140?ooo`002`3oool20?l006L0oooo00<000000?ooo`3oool0m03oool00`3o0000oooo0?ooo`12
0?ooo`002`3oool20?l006L0oooo00<000000?ooo`3oool0m03oool20?l004<0oooo000;0?ooo`80
o`00I`3oool00`000000oooo0?ooo`3e0?ooo`80o`00@P3oool000X0oooo0`3o001W0?ooo`030000
003oool0oooo0?H0oooo00<0o`000?ooo`3oool0@03oool000X0oooo0P3o001X0?ooo`030000003o
ool0oooo0?H0oooo0P3o00110?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0m`3oool2
0?l00400oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3h0?ooo`030?l0003oool0oooo
03h0oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3h0?ooo`80o`00?`3oool000X0oooo
0P3o001X0?ooo`030000003oool0oooo0?T0oooo0P3o000n0?ooo`002P3oool20?l006P0oooo00<0
00000?ooo`3oool0nP3oool00`3o0000oooo0?ooo`0l0?ooo`002P3oool20?l006P0oooo00<00000
0?ooo`3oool0nP3oool20?l003d0oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3k0?oo
o`80o`00?03oool000X0oooo0P3o001X0?ooo`030000003oool0oooo0?`0oooo00<0o`000?ooo`3o
ool0>P3oool000X0oooo0P3o001X0?ooo`030000003oool0oooo0?`0oooo0P3o000k0?ooo`002P3o
ool20?l006P0oooo00<000000?ooo`3oool0o@3oool20?l003X0oooo000:0?ooo`80o`00J03oool0
0`000000oooo0?ooo`3n0?ooo`030?l0003oool0oooo03P0oooo000:0?ooo`80o`00J03oool00`00
0000oooo0?ooo`3n0?ooo`80o`00>@3oool000X0oooo0`3o001W0?ooo`030000003oool0oooo0?l0
oooo00<0o`000?ooo`3oool0=`3oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?l0oooo
0P3o000h0?ooo`002`3oool20?l006L0oooo00<000000?ooo`3oool0o`3oool10?ooo`030?l0003o
ool0oooo03H0oooo000;0?ooo`80o`00I`3oool00`000000oooo0?ooo`3o0?ooo`40oooo0P3o000g
0?ooo`002`3oool20?l006L0oooo00<000000?ooo`3oool0o`3oool20?ooo`030?l0003oool0oooo
03D0oooo000;0?ooo`<0o`00IP3oool00`000000oooo0?ooo`3o0?ooo`80oooo0P3o000f0?ooo`00
303oool20?l006H0oooo00<000000?ooo`3oool0o`3oool30?ooo`80o`00=@3oool000`0oooo0P3o
001V0?ooo`030000003oool0oooo0?l0oooo103oool00`3o0000oooo0?ooo`0c0?ooo`00303oool3
0?l006D0oooo00<000000?ooo`3oool0o`3oool40?ooo`80o`00=03oool000d0oooo0P3o001U0?oo
o`030000003oool0oooo0?l0oooo1@3oool00`3o0000oooo0?ooo`0b0?ooo`003@3oool20?l006D0
oooo00<000000?ooo`3oool0o`3oool50?ooo`80o`00<`3oool000d0oooo0`3o001T0?ooo`030000
003oool0oooo0?l0oooo1P3oool00`3o0000oooo0?ooo`0a0?ooo`003P3oool20?l006@0oooo00<0
00000?ooo`3oool0o`3oool60?ooo`80o`00<P3oool000h0oooo0P3o001T0?ooo`030000003oool0
oooo0?l0oooo1P3oool20?l00380oooo000>0?ooo`<0o`00H`3oool00`000000oooo0?ooo`3o0?oo
o`L0oooo0P3o000a0?ooo`003`3oool20?l006<0oooo00<000000?ooo`3oool0o`3oool70?ooo`80
o`00<@3oool00100oooo00<0o`000?ooo`3oool0H@3oool00`000000oooo0?ooo`3o0?ooo`L0oooo
0`3o000`0?ooo`00403oool20?l00680oooo00<000000?ooo`3oool0o`3oool80?ooo`80o`00<03o
ool00140oooo00<0o`000?ooo`3oool0H03oool00`000000oooo0?ooo`3o0?ooo`P0oooo0`3o000_
0?ooo`004@3oool20?l00640oooo00<000000?ooo`3oool0o`3oool90?ooo`80o`00;`3oool00180
oooo0P3o001P0?ooo`030000003oool0oooo0?l0oooo2@3oool20?l002l0oooo000C0?ooo`030?l0
003oool0oooo05h0oooo00<000000?ooo`3oool0o`3oool90?ooo`<0o`007`3oool01P3OW4P00000
00000000M;l0oooo0;md0080000000<0B9cO0?ooo`3oool0103oool001<0oooo0P3o001O0?ooo`03
0000003oool0oooo0?l0oooo2P3oool20?l00200oooo00L0okmd0000001d_ol0oooo0?noM0000000
M;oo00L0oooo000D0?ooo`030?l0003oool0oooo05d0oooo00<000000?ooo`3oool0o`3oool:0?oo
o`<0o`00803oool01@3ookl0M01804QdB01807@0_ooo00P0oooo00000`3oool000000000000A0000
0080o`00o`00001/00000080o`004P00000?0?ooo`0309a80018B4P004RL00T0oooo000E0?ooo`80
o`00G@3oool00`000000oooo0?ooo`3o0?ooo`/0oooo0P3o000O0?ooo`070?oo_`1d0000B9cO0?oo
o`3OW4P0001d0;ooo`070?ooo`005P3oool20?l005`0oooo00<000000?ooo`3oool0o`3oool;0?oo
o`80o`007P3oool02@3ogi`0B00000000000M;l0oooo0;md00000000001809cOo`060?ooo`005P3o
ool30?l005/0oooo00<000000?ooo`3oool0o`3oool;0?ooo`<0o`00;03oool001L0oooo0P3o001K
0?ooo`030000003oool0oooo0?l0oooo303oool20?l002`0oooo000H0?ooo`80o`00FP3oool00`00
0000oooo0?ooo`3o0?ooo``0oooo0P3o000/0?ooo`00603oool30?l005T0oooo00<000000?ooo`3o
ool0o`3oool<0?ooo`<0o`00:`3oool001T0oooo0`3o001H0?ooo`030000003oool0oooo0?l0oooo
3@3oool20?l002/0oooo000J0?ooo`<0o`00E`3oool00`000000oooo0?ooo`3o0?ooo`d0oooo0P3o
000[0?ooo`006`3oool30?l005H0oooo00<000000?ooo`3oool0o`3oool=0?ooo`80o`00:`3oool0
01`0oooo0`3o001E0?ooo`030000003oool0oooo0?l0oooo3@3oool30?l002X0oooo000M0?ooo`<0
o`00E03oool00`000000oooo0?ooo`3o0?ooo`h0oooo0P3o000Z0?ooo`007P3oool30?l005<0oooo
00<000000?ooo`3oool0o`3oool>0?ooo`80o`00:P3oool001l0oooo0`3o001B0?ooo`030000003o
ool0oooo0?l0oooo3P3oool20?l002X0oooo000P0?ooo`<0o`00D@3oool00`000000oooo0?ooo`3o
0?ooo`h0oooo0`3o000Y0?ooo`008@3oool30?l00500oooo00<000000?ooo`3oool0o`3oool?0?oo
o`80o`00:@3oool00280oooo103o001>0?ooo`030000003oool0oooo0?l0oooo3`3oool20?l002T0
oooo000S0?ooo`@0o`00C@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo0P3o000Y0?ooo`009@3o
ool30?l004`0oooo00<000000?ooo`3oool0o`3oool@0?ooo`80o`00:03oool002H0oooo103o001:
0?ooo`030?l0003oool0oooo0?l0oooo403oool20?l002P0oooo000W0?ooo`@0o`00B03oool30?l0
0?l0oooo4@3oool20?l002P0oooo000Y0?ooo`@0o`00A03oool40?l00?l0oooo4P3oool20?l002P0
oooo000Z0?ooo`H0o`00@03oool40?l000030000003oool0oooo0?l0oooo403oool20?l002P0oooo
000/0?ooo`H0o`00?03oool40?l00080oooo00<000000?ooo`3oool0o`3oool@0?ooo`<0o`009`3o
ool002l0oooo1@3o000h0?ooo`D0o`000`3oool00`000000oooo0?ooo`3o0?oooa40oooo0P3o000W
0?ooo`00<@3oool50?l003D0oooo103o00050?ooo`030000003oool0oooo0?l0oooo4@3oool20?l0
02L0oooo000c0?ooo`D0o`00<03oool50?l000L0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`80
o`009`3oool003D0oooo1P3o000Z0?ooo`L0o`00203oool00`000000oooo0?ooo`3o0?oooa40oooo
0`3o000V0?ooo`00=`3oool70?l002D0oooo1P3o000;0?ooo`030000003oool0oooo0?l0oooo4P3o
ool20?l002H0oooo000j0?ooo`T0o`006`3oool0103o0000oooo0?ooo`3oool40?l000h0oooo00<0
00000?ooo`3oool0o`3ooolB0?ooo`80o`009P3oool003h0oooo2P3o000D0?ooo`P0o`00403oool0
0`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00@`3ooolP0?l00140oooo00<000000?oo
o`3oool0o`3ooolB0?ooo`80o`009P3oool004P0oooo5@3o000G0?ooo`030000003oool0oooo0?l0
oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l0
02H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool30?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool00`3o0000oooo0?ooo`0T0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa80oooo
0P3o000V0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00M03oool00`000000oooo0?ooo`3o0?oo
oa80oooo0P3o000V0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00
M03oool00`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00M03oool00`000000oooo0?oo
o`3o0?oooa80oooo0P3o000V0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa80oooo0P3o000V
0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00M03oool00`000000
oooo0?ooo`3o0?oooa80oooo0P3o000V0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa40oooo
0P3o000W0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa40oooo0P3o000W0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?oooa40oooo0P3o000W0?ooo`00M03oool00`000000oooo0?ooo`3o0?oo
oa40oooo0P3o000W0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa40oooo0P3o000W0?ooo`00
M03oool00`000000oooo0?ooo`3o0?oooa40oooo0P3o000W0?ooo`00M03oool00`000000oooo0?oo
o`3o0?oooa40oooo0P3o000W0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa00oooo0P3o000X
0?ooo`00M03oool00`000000oooo0?ooo`3o0?oooa00oooo0P3o000X0?ooo`00M03oool00`000000
oooo0?ooo`3o0?oooa00oooo0P3o000X0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`l0oooo
0`3o000X0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`l0oooo0P3o000Y0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo0P3o000Y0?ooo`00M03oool00`000000oooo0?ooo`3o0?oo
o`l0oooo0P3o000Y0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`h0oooo0`3o000Y0?ooo`00
M03oool00`000000oooo0?ooo`3o0?ooo`h0oooo0P3o000Z0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooo`h0oooo0P3o000Z0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`d0oooo0`3o000Z
0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`d0oooo0P3o000[0?ooo`00M03oool00`000000
oooo0?ooo`3o0?ooo`d0oooo0P3o000[0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`d0oooo
0P3o000[0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo``0oooo0`3o000[0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?ooo``0oooo0P3o000/0?ooo`00M03oool00`000000oooo0?ooo`3o0?oo
o``0oooo0P3o000/0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`/0oooo0`3o000/0?ooo`00
M03oool00`000000oooo0?ooo`3o0?ooo`/0oooo0P3o000]0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooo`/0oooo0P3o000]0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`X0oooo0`3o000]
0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`X0oooo0P3o000^0?ooo`00M03oool00`000000
oooo0?ooo`3o0?ooo`T0oooo0`3o000^0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`T0oooo
0P3o000_0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`T0oooo0P3o000_0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?ooo`P0oooo0`3o000_0?ooo`00M03oool00`000000oooo0?ooo`3o0?oo
o`P0oooo0P3o000`0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`P0oooo0P3o000`0?ooo`00
M03oool00`000000oooo0?ooo`3o0?ooo`P0oooo00<0o`000?ooo`3oool0;`3oool007@0oooo00<0
00000?ooo`3oool0o`3oool70?ooo`80o`00<@3oool007@0oooo00<000000?ooo`3oool0o`3oool7
0?ooo`030?l0003oool0oooo0300oooo001d0?ooo`030000003oool0oooo0?l0oooo1P3oool20?l0
0380oooo001d0?ooo`030000003oool0oooo0?l0oooo1P3oool00`3o0000oooo0?ooo`0a0?ooo`00
M03oool00`000000oooo0?ooo`3o0?ooo`D0oooo0P3o000c0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooo`D0oooo00<0o`000?ooo`3oool0<P3oool007@0oooo00<000000?ooo`3oool0o`3oool4
0?ooo`80o`00=03oool007@0oooo00<000000?ooo`3oool0o`3oool40?ooo`030?l0003oool0oooo
03<0oooo001d0?ooo`030000003oool0oooo0?l0oooo0`3oool20?l003D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo0`3oool00`3o0000oooo0?ooo`0d0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooo`80oooo0P3o000f0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`80oooo00<0o`00
0?ooo`3oool0=@3oool007@0oooo00<000000?ooo`3oool0o`3oool10?ooo`80o`00=`3oool007@0
oooo00<000000?ooo`3oool0o`3oool10?ooo`030?l0003oool0oooo03H0oooo001d0?ooo`030000
003oool0oooo0?l0oooo0P3o000h0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooo`030?l0003o
ool0oooo03L0oooo001d0?ooo`030000003oool0oooo0?h0oooo0P3o000i0?ooo`00M03oool00`00
0000oooo0?ooo`3m0?ooo`80o`00>P3oool007@0oooo00<000000?ooo`3oool0o@3oool00`3o0000
oooo0?ooo`0i0?ooo`00M03oool00`000000oooo0?ooo`3l0?ooo`80o`00>`3oool007@0oooo00<0
00000?ooo`3oool0o03oool00`3o0000oooo0?ooo`0j0?ooo`00M03oool00`000000oooo0?ooo`3k
0?ooo`80o`00?03oool007@0oooo00<000000?ooo`3oool0n`3oool00`3o0000oooo0?ooo`0k0?oo
o`00M03oool00`000000oooo0?ooo`3j0?ooo`80o`00?@3oool007@0oooo00<000000?ooo`3oool0
nP3oool00`3o0000oooo0?ooo`0l0?ooo`00M03oool00`000000oooo0?ooo`3i0?ooo`80o`00?P3o
ool007@0oooo00<000000?ooo`3oool0n03oool20?l003l0oooo001d0?ooo`030000003oool0oooo
0?P0oooo00<0o`000?ooo`3oool0?P3oool007@0oooo00<000000?ooo`3oool0m`3oool20?l00400
oooo001d0?ooo`030000003oool0oooo0?H0oooo0P3o00110?ooo`00M03oool00`000000oooo0?oo
o`3e0?ooo`<0o`00@@3oool007@0oooo00<000000?ooo`3oool0m@3oool20?l00480oooo001d0?oo
o`030000003oool0oooo0?@0oooo0P3o00130?ooo`00M03oool00`000000oooo0?ooo`3c0?ooo`<0
o`00@`3oool007@0oooo00<000000?ooo`3oool0lP3oool30?l004@0oooo001d0?ooo`030000003o
ool0oooo0?40oooo0`3o00150?ooo`00M03oool00`000000oooo0?ooo`3a0?ooo`80o`00AP3oool0
07@0oooo00<000000?ooo`3oool0l03oool20?l004L0oooo001d0?ooo`030000003oool0oooo0>l0
oooo0`3o00170?ooo`00M03oool00`000000oooo0?ooo`3^0?ooo`<0o`00B03oool007@0oooo00<0
00000?ooo`3oool0k@3oool30?l004T0oooo001d0?ooo`030000003oool0oooo0>`0oooo0`3o001:
0?ooo`00M03oool00`000000oooo0?ooo`3/0?ooo`80o`00B`3oool007@0oooo00<000000?ooo`3o
ool0j`3oool20?l004`0oooo001d0?ooo`030000003oool0oooo0>X0oooo0`3o001<0?ooo`00M03o
ool00`000000oooo0?ooo`3Y0?ooo`<0o`00C@3oool007@0oooo00<000000?ooo`3oool0j03oool3
0?l004h0oooo001d0?ooo`030000003oool0oooo0>P0oooo0P3o001?0?ooo`00M03oool00`000000
oooo0?ooo`3W0?ooo`80o`00D03oool007@0oooo00<000000?ooo`3oool0iP3oool30?l00500oooo
001d0?ooo`030000003oool0oooo0>D0oooo0`3o001A0?ooo`00M03oool00`000000oooo0?ooo`3T
0?ooo`<0o`00DP3oool007@0oooo00<000000?ooo`3oool0i03oool20?l005<0oooo001d0?ooo`03
0000003oool0oooo0><0oooo0P3o001D0?ooo`00M03oool00`000000oooo0?ooo`3R0?ooo`<0o`00
E03oool007@0oooo00<000000?ooo`3oool0h@3oool30?l005D0oooo001d0?ooo`030000003oool0
oooo0>00oooo0`3o001F0?ooo`00M03oool00`000000oooo0?ooo`3O0?ooo`<0o`00E`3oool007@0
oooo00<000000?ooo`3oool0gP3oool30?l005P0oooo001d0?ooo`030000003oool0oooo0=`0oooo
103o001I0?ooo`00M03oool00`000000oooo0?ooo`3K0?ooo`@0o`00FP3oool007@0oooo00<00000
0?ooo`3oool0fP3oool30?l005`0oooo001d0?ooo`030000003oool0oooo0=T0oooo0`3o001M0?oo
o`00M03oool00`000000oooo0?ooo`3H0?ooo`<0o`00GP3oool007@0oooo00<000000?ooo`3oool0
e`3oool30?l005l0oooo001d0?ooo`030000003oool0oooo0=H0oooo0`3o001P0?ooo`00M03oool0
0`000000oooo0?ooo`3E0?ooo`<0o`00H@3oool007@0oooo00<000000?ooo`3oool0d`3oool40?l0
0680oooo001d0?ooo`030000003oool0oooo0=80oooo103o001S0?ooo`00M03oool00`000000oooo
0?ooo`3A0?ooo`<0o`00I@3oool007@0oooo00<000000?ooo`3oool0d03oool30?l006H0oooo001d
0?ooo`030000003oool0oooo0<l0oooo0`3o001W0?ooo`00M03oool00`000000oooo0?ooo`3>0?oo
o`<0o`00J03oool007@0oooo00<000000?ooo`3oool0c@3oool30?l006T0oooo001d0?ooo`030000
003oool0oooo0<`0oooo0`3o001Z0?ooo`00M03oool00`000000oooo0?ooo`3:0?ooo`@0o`00J`3o
ool007@0oooo00<000000?ooo`3oool0b@3oool40?l006`0oooo001d0?ooo`030000003oool0oooo
0<P0oooo0`3o001^0?ooo`00M03oool00`000000oooo0?ooo`370?ooo`<0o`00K`3oool007@0oooo
00<000000?ooo`3oool0aP3oool30?l00700oooo001d0?ooo`030000003oool0oooo0<D0oooo0`3o
001a0?ooo`00M03oool00`000000oooo0?ooo`330?ooo`@0o`00LP3oool007@0oooo00<000000?oo
o`3oool0`P3oool40?l007<0oooo001d0?ooo`030000003oool0oooo0<00oooo103o001e0?ooo`00
M03oool00`000000oooo0?ooo`2o0?ooo`@0o`00MP3oool007@0oooo00<000000?ooo`3oool0_@3o
ool40?l007P0oooo001d0?ooo`030000003oool0oooo0;`0oooo103o001i0?ooo`00M03oool00`00
0000oooo0?ooo`2j0?ooo`@0o`00N`3oool007@0oooo00<000000?ooo`3oool0^@3oool40?l007`0
oooo001d0?ooo`030000003oool0oooo0;L0oooo103o001n0?ooo`00M03oool00`000000oooo0?oo
o`2f0?ooo`@0o`00O`3oool007@0oooo00<000000?ooo`3oool0]03oool40?l00840oooo001d0?oo
o`030000003oool0oooo0;<0oooo103o00220?ooo`00M03oool00`000000oooo0?ooo`2a0?ooo`@0
o`00Q03oool007@0oooo00<000000?ooo`3oool0/03oool40?l008D0oooo001d0?ooo`030000003o
ool0oooo0:h0oooo103o00270?ooo`00M03oool00`000000oooo0?ooo`2]0?ooo`@0o`00R03oool0
07@0oooo00<000000?ooo`3oool0Z`3oool40?l008X0oooo001d0?ooo`030000003oool0oooo0:X0
oooo103o002;0?ooo`00M03oool00`000000oooo0?ooo`2X0?ooo`@0o`00S@3oool007@0oooo00<0
00000?ooo`3oool0Y`3oool40?l008h0oooo001d0?ooo`030000003oool0oooo0:D0oooo103o002@
0?ooo`00M03oool00`000000oooo0?ooo`2S0?ooo`D0o`00T@3oool007@0oooo00<000000?ooo`3o
ool0X@3oool50?l009<0oooo001d0?ooo`030000003oool0oooo09h0oooo1P3o002E0?ooo`00M03o
ool00`000000oooo0?ooo`2L0?ooo`H0o`00U`3oool007@0oooo00<000000?ooo`3oool0VP3oool5
0?l009X0oooo001d0?ooo`030000003oool0oooo09P0oooo1@3o002L0?ooo`00M03oool00`000000
oooo0?ooo`2F0?ooo`D0o`00WP3oool007@0oooo00<000000?ooo`3oool0U03oool50?l00:00oooo
001d0?ooo`030000003oool0oooo0940oooo1P3o002R0?ooo`00M03oool00`000000oooo0?ooo`2?
0?ooo`H0o`00Y03oool007@0oooo00<000000?ooo`3oool0S@3oool50?l00:L0oooo001d0?ooo`03
0000003oool0oooo08/0oooo1@3o002Y0?ooo`00M03oool00`000000oooo0?ooo`290?ooo`D0o`00
Z`3oool007@0oooo00<000000?ooo`3oool0Q`3oool50?l00:d0oooo001d0?ooo`030000003oool0
oooo08@0oooo1P3o002_0?ooo`00M03oool00`000000oooo0?ooo`220?ooo`H0o`00/@3oool007@0
oooo00<000000?ooo`3oool0P03oool50?l00;@0oooo001d0?ooo`030000003oool0oooo07h0oooo
1@3o002f0?ooo`00M03oool00`000000oooo0?ooo`1k0?ooo`H0o`00^03oool007@0oooo00<00000
0?ooo`3oool0N03oool70?l00;X0oooo001d0?ooo`030000003oool0oooo07D0oooo1`3o002m0?oo
o`00M03oool00`000000oooo0?ooo`1c0?ooo`H0o`00`03oool007@0oooo00<000000?ooo`3oool0
L03oool60?l00<<0oooo001d0?ooo`030000003oool0oooo06d0oooo1`3o00350?ooo`00M03oool0
0`000000oooo0?ooo`1Z0?ooo`L0o`00b03oool007@0oooo00<000000?ooo`3oool0I`3oool70?l0
0</0oooo001d0?ooo`030000003oool0oooo06<0oooo1`3o003?0?ooo`00M03oool00`000000oooo
0?ooo`1O0?ooo`P0o`00dP3oool007@0oooo00<000000?ooo`3oool0F`3oool80?l00=H0oooo001d
0?ooo`030000003oool0oooo05L0oooo203o003J0?ooo`00M03oool00`000000oooo0?ooo`1C0?oo
o`P0o`00gP3oool007@0oooo00<000000?ooo`3oool0C`3oool80?l00>80oooo001d0?ooo`030000
003oool0oooo04/0oooo203o003V0?ooo`00M03oool00`000000oooo0?ooo`160?ooo`T0o`00jP3o
ool007@0oooo00<000000?ooo`3oool0@P3oool90?l00>h0oooo001d0?ooo`030000003oool0oooo
03d0oooo2@3o003c0?ooo`00M03oool00`000000oooo0?ooo`0c0?ooo`l0o`00m`3oool007@0oooo
00<000000?ooo`3oool0;P3oool?0?l00?`0oooo001d0?ooo`030000003oool0oooo02P0oooo2`3o
003o0?ooo`L0oooo001d0?ooo`030000003oool0oooo01d0oooo4@3o003o0?ooo``0oooo001d0?oo
o`030000003oool0oooo00d0oooo6`3o003o0?oooa80oooo001c0?ooob40o`00o`3ooolM0?ooo`00
L`3ooolA0?l00?l0oooo;@3oool007@0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool0
0`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0oooo>P3oool007@0
oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo
001d0?ooo`030000003oool0oooo0?l0oooo>P3oool007@0oooo00<000000?ooo`3oool0o`3ooolj
0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0
oooo>P3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00700oooo00<0oono07@0000000000P000000
0`00M;l0oooo0?ooo`3o0?ooocT0oooo001c0?ooo`030?noM000M;l0oooo0?l0oooo>`3oool007@0
oooo00<0W4Q809cOo`3oool0o`3ooolj0?ooo`00L`3oool00`3ookl0M000001d_`3o0?oooc/0oooo
001c0?ooo`040=nLB000M;l0_g@007Boool0oooo>P3oool007<0oooo00@0W4Q809cOo`3ogi`0B4RL
o`3ooolj0?ooo`00LP3oool01P3o_g@007Bo0?ooo`3oool0_g@007Boool0oooo>@3oool00780oooo
00H0W4Q809cOo`3oool0oooo0?oOW018B9co0?ooocT0oooo001a0?ooo`080;md00000000001d0;oo
o`3ookl0M00000000000M;oo0?ooocP0oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40
oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-3.05219, -4.9997, 0.0391911, \
0.0534982}}],

Cell[BoxData[
    \("After more revolutions, Yes or No?"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    InterpretationBox[\("After "\[InvisibleSpace]2\[InvisibleSpace]" \
revolutions"\),
      SequenceForm[ "After ", 2, " revolutions"],
      Editable->False]], "Print",
  CellLabel->"From In[13]:="],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.285742 0.0951866 0.501881 0.10263 [
[1.025 .50188 0 -6.28125 ]
[1.025 .50188 10 6.28125 ]
[.28574 1.025 -5 0 ]
[.28574 1.025 5 12.5625 ]
[ 0 0 0 0 ]
[ 1 1 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
0 .50188 m
1 .50188 L
s
gsave
1.025 .50188 -61 -10.2813 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
1.000 setlinewidth
grestore
.28574 0 m
.28574 1 L
s
gsave
.28574 1.025 -66 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 20.5625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 12.813 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(y) show
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 1 L
0 1 L
closepath
clip
newpath
1 0 0 r
.006 w
.90935 1 m
.92861 .95348 L
.9471 .89613 L
.96011 .84248 L
.96573 .81215 L
.96982 .78425 L
.97257 .75982 L
.97379 .74583 L
.97469 .73309 L
.97541 .71966 L
.97571 .71229 L
.97593 .70531 L
.97616 .69295 L
.97619 .67955 L
.97602 .66762 L
.9757 .65646 L
.97517 .64428 L
.97438 .6312 L
.97339 .61829 L
.97211 .60479 L
.96926 .58085 L
.96235 .53868 L
.95226 .4938 L
.93784 .44482 L
.92148 .40051 L
.88439 .32324 L
.83627 .24906 L
.77641 .18012 L
.71947 .13038 L
.65318 .08681 L
.61887 .06929 L
.58163 .05373 L
.54633 .0421 L
.51411 .03402 L
.49783 .03084 L
.48257 .02839 L
.47415 .02727 L
.46508 .02623 L
.45756 .02551 L
.44935 .02487 L
.44158 .0244 L
.43436 .02409 L
.42676 .02388 L
.41867 .02381 L
.41117 .02387 L
.40411 .02405 L
.3978 .02431 L
.39098 .02469 L
.38297 .02527 L
.37551 .02595 L
Mistroke
.35868 .02797 L
.34253 .03055 L
.32544 .03399 L
.2954 .04189 L
.26893 .05092 L
.21776 .07459 L
.17491 .10197 L
.13357 .13704 L
.09649 .17907 L
.06801 .22271 L
.05588 .24655 L
.04521 .27215 L
.03766 .29476 L
.0313 .31962 L
.02913 .3305 L
.02722 .34212 L
.02582 .35303 L
.02486 .36292 L
.02448 .36811 L
.0242 .37297 L
.02398 .37827 L
.02384 .38397 L
.02381 .38958 L
.02383 .39239 L
.02388 .39546 L
.02405 .40086 L
.02428 .40587 L
.02461 .4109 L
.02499 .41563 L
.02589 .42439 L
.02714 .43369 L
.02881 .4436 L
.03341 .46404 L
.03976 .48463 L
.04699 .50283 L
.05458 .51847 L
.07205 .54637 L
.09378 .57149 L
.11584 .58998 L
.13783 .60319 L
.15044 .60878 L
.16186 .6127 L
.16816 .61441 L
.17493 .6159 L
.18127 .61697 L
.18406 .61734 L
.18703 .61766 L
.18981 .6179 L
.19233 .61807 L
.19484 .61818 L
Mistroke
.1972 .61825 L
.19993 .61826 L
.20244 .61822 L
.20517 .61812 L
.20803 .61794 L
.21056 .61773 L
.21325 .61744 L
.21804 .61677 L
.22361 .61573 L
.22857 .61455 L
.23809 .61158 L
.24758 .60759 L
.26276 .5986 L
.27075 .59218 L
.27735 .58565 L
.28245 .57954 L
.28721 .57263 L
.29079 .56626 L
.29385 .55943 L
.29521 .5557 L
.29626 .55233 L
.29713 .54896 L
.29778 .5459 L
.29824 .54315 L
.2986 .54028 L
.29875 .53868 L
.29885 .5372 L
.29891 .53588 L
.29895 .53449 L
.29895 .53327 L
.29893 .53195 L
.29888 .5306 L
.2988 .52937 L
.29871 .52823 L
.29861 .52722 L
.29832 .52501 L
.29794 .52284 L
.29745 .52057 L
.29622 .51639 L
.29489 .51303 L
.29353 .51033 L
.29043 .50577 L
.28885 .50408 L
.2876 .50301 L
.28664 .50234 L
.28603 .50201 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
Mistroke
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
Mistroke
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
.28574 .50188 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  CellLabel->"From In[13]:=",
  ImageSize->{288, 288},
  ImageMargins->{{0, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006`0001/2000`400?l00000o`00003oo`3ooona
0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0
oooo>P3oool007@0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool00`000000oooo0?oo
o`3o0?ooocX0oooo001d0?ooo`030000003oool0oooo0?l0oooo>P3oool007@0oooo00<000000?oo
o`3oool0o`3ooolj0?ooo`00M03oool00`000000oooo0?ooo`3o0?ooocX0oooo001d0?ooo`030000
003oool0oooo0?l0oooo>P3oool007@0oooo00<000000?ooo`3oool0o`3ooolj0?ooo`00M03oool0
0`000000oooo0?ooo`0Q0?ooo`030?l0003oool0oooo01`0o`00n@3oool007@0oooo00<000000?oo
o`3oool06`3ooolb0?l00>`0oooo001d0?ooo`030000003oool0oooo01@0oooo403o000K0?oooa@0
o`00iP3oool007@0oooo00<000000?ooo`3oool03@3oool>0?l00340oooo3@3o003P0?ooo`00M03o
ool00`000000oooo0?ooo`090?ooo`/0o`00?`3oool;0?l00=/0oooo001d0?ooo`030000003oool0
oooo00D0oooo203o001<0?ooo`T0o`00e`3oool007@0oooo00@000000?ooo`3oool0oooo203o001E
0?ooo`P0o`00d`3oool007@0oooo00<000000?l0003o00001@3o001M0?ooo`P0o`00c`3oool007<0
oooo1P3o001T0?ooo`L0o`00c03oool00700oooo1P3o001Z0?ooo`H0o`00bP3oool006h0oooo1P3o
00000`000000oooo0?ooo`1/0?ooo`H0o`00a`3oool006`0oooo1@3o00030?ooo`030000003oool0
oooo06h0oooo1`3o00340?ooo`00J@3oool60?l000D0oooo00<000000?ooo`3oool0L@3oool60?l0
0<80oooo001W0?ooo`H0o`001`3oool00`000000oooo0?ooo`1d0?ooo`H0o`00_`3oool006D0oooo
1@3o000:0?ooo`030000003oool0oooo07H0oooo1P3o002m0?ooo`00HP3oool60?l000`0oooo00<0
00000?ooo`3oool0N@3oool60?l00;X0oooo001P0?ooo`H0o`003P3oool00`000000oooo0?ooo`1k
0?ooo`H0o`00^03oool005h0oooo1@3o000A0?ooo`030000003oool0oooo07h0oooo1P3o002e0?oo
o`00F`3oool60?l001<0oooo00<000000?ooo`3oool0P03oool60?l00;<0oooo001I0?ooo`H0o`00
5@3oool00`000000oooo0?ooo`230?ooo`D0o`00/@3oool005P0oooo103o000H0?ooo`030000003o
ool0oooo08D0oooo1@3o002_0?ooo`00EP3oool40?l001X0oooo00<000000?ooo`3oool0Q`3oool5
0?l00:d0oooo001E0?ooo`@0o`006`3oool00`000000oooo0?ooo`290?ooo`D0o`00Z`3oool005<0
oooo103o000M0?ooo`030000003oool0oooo08/0oooo1@3o002Y0?ooo`00DP3oool40?l001h0oooo
00<000000?ooo`3oool0S@3oool50?l00:L0oooo001@0?ooo`@0o`00803oool00`000000oooo0?oo
o`2?0?ooo`@0o`00YP3oool004l0oooo103o000Q0?ooo`030000003oool0oooo0940oooo103o002T
0?ooo`00CP3oool30?l002<0oooo00<000000?ooo`3oool0TP3oool40?l00:<0oooo001<0?ooo`@0
o`00903oool00`000000oooo0?ooo`2D0?ooo`@0o`00X@3oool004/0oooo103o000U0?ooo`030000
003oool0oooo09D0oooo103o002P0?ooo`00B@3oool40?l002L0oooo00<000000?ooo`3oool0U`3o
ool40?l009h0oooo00180?ooo`@0o`00:03oool00`000000oooo0?ooo`2H0?ooo`@0o`00W@3oool0
04L0oooo0`3o000Z0?ooo`030000003oool0oooo09X0oooo103o002K0?ooo`00AP3oool30?l002/0
oooo00<000000?ooo`3oool0V`3oool40?l009X0oooo00140?ooo`@0o`00;03oool00`000000oooo
0?ooo`2M0?ooo`@0o`00V03oool004<0oooo103o000]0?ooo`030000003oool0oooo09h0oooo103o
002G0?ooo`00@P3oool30?l002l0oooo00<000000?ooo`3oool0X03oool40?l009D0oooo00110?oo
o`<0o`00<03oool00`000000oooo0?ooo`2Q0?ooo`@0o`00U03oool003l0oooo103o000a0?ooo`03
0000003oool0oooo0:<0oooo103o002B0?ooo`00?P3oool40?l00380oooo00<000000?ooo`3oool0
Y03oool40?l00940oooo000m0?ooo`<0o`00=03oool00`000000oooo0?ooo`2V0?ooo`@0o`00S`3o
ool003`0oooo0`3o000e0?ooo`030000003oool0oooo0:L0oooo103o002>0?ooo`00>`3oool30?l0
03H0oooo00<000000?ooo`3oool0Z@3oool40?l008`0oooo000i0?ooo`@0o`00=`3oool00`000000
oooo0?ooo`2Z0?ooo`@0o`00R`3oool003P0oooo103o000h0?ooo`030000003oool0oooo0:`0oooo
0`3o002:0?ooo`00=`3oool30?l003X0oooo00<000000?ooo`3oool0[@3oool30?l008T0oooo000f
0?ooo`<0o`00>`3oool00`000000oooo0?ooo`2^0?ooo`@0o`00Q`3oool003D0oooo0`3o000l0?oo
o`030000003oool0oooo0:l0oooo103o00260?ooo`00=03oool30?l003d0oooo00<000000?ooo`3o
ool0/@3oool30?l008D0oooo000c0?ooo`<0o`00?P3oool00`000000oooo0?ooo`2b0?ooo`<0o`00
Q03oool003<0oooo0P3o000o0?ooo`030000003oool0oooo0;<0oooo0`3o00230?ooo`00<P3oool2
0?l00400oooo00<000000?ooo`3oool0]03oool30?l00880oooo000a0?ooo`<0o`00@03oool00`00
0000oooo0?ooo`2e0?ooo`<0o`00P@3oool00300oooo0`3o00110?ooo`030000003oool0oooo0;H0
oooo103o001o0?ooo`00;`3oool30?l00480oooo00<000000?ooo`3oool0]`3oool40?l007h0oooo
000^0?ooo`<0o`00@`3oool00`000000oooo0?ooo`2i0?ooo`<0o`00O@3oool002d0oooo0`3o0014
0?ooo`030000003oool0oooo0;X0oooo0`3o001l0?ooo`00;03oool30?l004D0oooo00<000000?oo
o`3oool0^`3oool30?l007/0oooo000/0?ooo`80o`00AP3oool00`000000oooo0?ooo`2l0?ooo`<0
o`00NP3oool002/0oooo0P3o00170?ooo`030000003oool0oooo0;d0oooo103o001h0?ooo`00:P3o
ool30?l004L0oooo00<000000?ooo`3oool0_P3oool40?l007L0oooo000Y0?ooo`<0o`00B03oool0
0`000000oooo0?ooo`300?ooo`<0o`00MP3oool002P0oooo0`3o00190?ooo`030000003oool0oooo
0<40oooo0`3o001e0?ooo`00:03oool20?l004X0oooo00<000000?ooo`3oool0`P3oool30?l007@0
oooo000W0?ooo`80o`00B`3oool00`000000oooo0?ooo`330?ooo`<0o`00L`3oool002H0oooo0P3o
001<0?ooo`030000003oool0oooo0<@0oooo0`3o001b0?ooo`009P3oool00`3o0000oooo0?ooo`1;
0?ooo`030000003oool0oooo0<D0oooo0P3o001b0?ooo`009@3oool20?l004d0oooo00<000000?oo
o`3oool0aP3oool20?l00740oooo000T0?ooo`80o`00CP3oool00`000000oooo0?ooo`360?ooo`<0
o`00L03oool002@0oooo00<0o`000?ooo`3oool0C@3oool00`000000oooo0?ooo`370?ooo`<0o`00
K`3oool002<0oooo0P3o001?0?ooo`030000003oool0oooo0<P0oooo0`3o001^0?ooo`008P3oool2
0?l00500oooo00<000000?ooo`3oool0b@3oool30?l006d0oooo000R0?ooo`030?l0003oool0oooo
04l0oooo00<000000?ooo`3oool0bP3oool30?l006`0oooo000Q0?ooo`80o`00D@3oool00`000000
oooo0?ooo`3;0?ooo`80o`00K03oool00240oooo00<0o`000?ooo`3oool0D03oool00`000000oooo
0?ooo`3<0?ooo`80o`00J`3oool00200oooo0P3o001B0?ooo`030000003oool0oooo0<`0oooo0`3o
001Z0?ooo`007`3oool20?l005<0oooo00<000000?ooo`3oool0c@3oool30?l006T0oooo000O0?oo
o`030?l0003oool0oooo0580oooo00<000000?ooo`3oool0cP3oool30?l006P0oooo000N0?ooo`80
o`00E03oool00`000000oooo0?ooo`3?0?ooo`<0o`00I`3oool001d0oooo0P3o001E0?ooo`030000
003oool0oooo0=00oooo0`3o001V0?ooo`007@3oool00`3o0000oooo0?ooo`1D0?ooo`030000003o
ool0oooo0=40oooo0P3o001V0?ooo`00703oool20?l005H0oooo00<000000?ooo`3oool0dP3oool2
0?l006D0oooo000L0?ooo`030?l0003oool0oooo05D0oooo00<000000?ooo`3oool0dP3oool30?l0
06@0oooo000K0?ooo`80o`00E`3oool00`000000oooo0?ooo`3C0?ooo`<0o`00H`3oool001/0oooo
00<0o`000?ooo`3oool0EP3oool00`000000oooo0?ooo`3D0?ooo`<0o`00HP3oool001X0oooo0P3o
001H0?ooo`030000003oool0oooo0=D0oooo0`3o001Q0?ooo`006P3oool00`3o0000oooo0?ooo`1G
0?ooo`030000003oool0oooo0=H0oooo0`3o001P0?ooo`006@3oool20?l005T0oooo00<000000?oo
o`3oool0e`3oool20?l00600oooo000I0?ooo`030?l0003oool0oooo05P0oooo00<000000?ooo`3o
ool0f03oool20?l005l0oooo000H0?ooo`80o`00FP3oool00`000000oooo0?ooo`3H0?ooo`<0o`00
GP3oool001P0oooo00<0o`000?ooo`3oool0F@3oool00`000000oooo0?ooo`3I0?ooo`<0o`00G@3o
ool001L0oooo0P3o001K0?ooo`030000003oool0oooo0=X0oooo0P3o001M0?ooo`005`3oool20?l0
05/0oooo00<000000?ooo`3oool0f`3oool20?l005`0oooo000F0?ooo`80o`00G03oool00`000000
oooo0?ooo`3L0?ooo`80o`00F`3oool001H0oooo0P3o001L0?ooo`030000003oool0oooo0=d0oooo
00<0o`000?ooo`3oool0F@3oool001D0oooo0`3o001L0?ooo`030000003oool0oooo0=d0oooo0P3o
001J0?ooo`005@3oool20?l005d0oooo00<000000?ooo`3oool0gP3oool20?l005T0oooo000D0?oo
o`<0o`00G@3oool00`000000oooo0?ooo`3O0?ooo`030?l0003oool0oooo05L0oooo000D0?ooo`80
o`00GP3oool00`000000oooo0?ooo`3O0?ooo`80o`00F03oool001@0oooo0P3o001N0?ooo`030000
003oool0oooo0>00oooo0P3o001G0?ooo`004`3oool30?l005h0oooo00<000000?ooo`3oool0h@3o
ool00`3o0000oooo0?ooo`1E0?ooo`004`3oool20?l005l0oooo00<000000?ooo`3oool0h@3oool2
0?l005H0oooo000C0?ooo`80o`00G`3oool00`000000oooo0?ooo`3R0?ooo`80o`00E@3oool00180
oooo0`3o001O0?ooo`030000003oool0oooo0><0oooo00<0o`000?ooo`3oool0D`3oool00180oooo
0P3o001P0?ooo`030000003oool0oooo0><0oooo0P3o001D0?ooo`004P3oool20?l00600oooo00<0
00000?ooo`3oool0i03oool00`3o0000oooo0?ooo`1B0?ooo`004@3oool30?l00600oooo00<00000
0?ooo`3oool0i03oool20?l005<0oooo000A0?ooo`80o`00H@3oool00`000000oooo0?ooo`3U0?oo
o`80o`00DP3oool00140oooo0P3o001Q0?ooo`030000003oool0oooo0>H0oooo00<0o`000?ooo`3o
ool0D03oool00100oooo0`3o001Q0?ooo`030000003oool0oooo0>H0oooo0P3o001A0?ooo`00403o
ool20?l00680oooo00<000000?ooo`3oool0i`3oool20?l00500oooo000@0?ooo`80o`00HP3oool0
0`000000oooo0?ooo`3X0?ooo`030?l0003oool0oooo04h0oooo000?0?ooo`<0o`00HP3oool00`00
0000oooo0?ooo`3X0?ooo`80o`00C`3oool000l0oooo0P3o001S0?ooo`030000003oool0oooo0>T0
oooo0P3o001>0?ooo`003`3oool20?l006<0oooo00<000000?ooo`3oool0jP3oool00`3o0000oooo
0?ooo`1<0?ooo`003`3oool20?l006<0oooo00<000000?ooo`3oool0jP3oool20?l004d0oooo000>
0?ooo`<0o`00H`3oool00`000000oooo0?ooo`3[0?ooo`80o`00C03oool000h0oooo0P3o001T0?oo
o`030000003oool0oooo0>`0oooo00<0o`000?ooo`3oool0BP3oool000h0oooo0P3o001T0?ooo`03
0000003oool0oooo0>`0oooo0P3o001;0?ooo`003@3oool30?l006@0oooo00<000000?ooo`3oool0
k@3oool20?l004X0oooo000=0?ooo`80o`00I@3oool00`000000oooo0?ooo`3^0?ooo`030?l0003o
ool0oooo04P0oooo000=0?ooo`80o`00I@3oool00`000000oooo0?ooo`3^0?ooo`80o`00B@3oool0
00d0oooo0P3o001U0?ooo`030000003oool0oooo0>l0oooo00<0o`000?ooo`3oool0A`3oool000`0
oooo0`3o001U0?ooo`030000003oool0oooo0>l0oooo0P3o00180?ooo`00303oool20?l006H0oooo
00<000000?ooo`3oool0l03oool00`3o0000oooo0?ooo`160?ooo`00303oool20?l006H0oooo00<0
00000?ooo`3oool0l03oool20?l004L0oooo000<0?ooo`80o`00IP3oool00`000000oooo0?ooo`3a
0?ooo`030?l0003oool0oooo04D0oooo000<0?ooo`80o`00IP3oool00`000000oooo0?ooo`3a0?oo
o`80o`00AP3oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?80oooo00<0o`000?ooo`3o
ool0A03oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?80oooo00<0o`000?ooo`3oool0
A03oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?80oooo0P3o00150?ooo`002`3oool2
0?l006L0oooo00<000000?ooo`3oool0l`3oool00`3o0000oooo0?ooo`130?ooo`002`3oool20?l0
06L0oooo00<000000?ooo`3oool0l`3oool20?l004@0oooo000;0?ooo`80o`00I`3oool00`000000
oooo0?ooo`3d0?ooo`030?l0003oool0oooo0480oooo000;0?ooo`80o`00I`3oool00`000000oooo
0?ooo`3d0?ooo`80o`00@`3oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?D0oooo00<0
o`000?ooo`3oool0@@3oool000X0oooo0`3o001W0?ooo`030000003oool0oooo0?D0oooo0P3o0012
0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0mP3oool00`3o0000oooo0?ooo`100?oo
o`002P3oool20?l006P0oooo00<000000?ooo`3oool0mP3oool20?l00440oooo000:0?ooo`80o`00
J03oool00`000000oooo0?ooo`3g0?ooo`030?l0003oool0oooo03l0oooo000:0?ooo`80o`00J03o
ool00`000000oooo0?ooo`3g0?ooo`80o`00@03oool000X0oooo0P3o001X0?ooo`030000003oool0
oooo0?P0oooo00<0o`000?ooo`3oool0?P3oool000X0oooo0P3o001X0?ooo`030000003oool0oooo
0?P0oooo0P3o000o0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0n@3oool00`3o0000
oooo0?ooo`0m0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0n@3oool00`3o0000oooo
0?ooo`0m0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0n@3oool20?l003h0oooo000:
0?ooo`80o`00J03oool00`000000oooo0?ooo`3j0?ooo`030?l0003oool0oooo03`0oooo000:0?oo
o`80o`00J03oool00`000000oooo0?ooo`3j0?ooo`80o`00?@3oool000X0oooo0P3o001X0?ooo`03
0000003oool0oooo0?/0oooo00<0o`000?ooo`3oool0>`3oool000X0oooo0P3o001X0?ooo`030000
003oool0oooo0?/0oooo0P3o000l0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0o03o
ool00`3o0000oooo0?ooo`0j0?ooo`002P3oool20?l006P0oooo00<000000?ooo`3oool0o03oool2
0?l003/0oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3m0?ooo`030?l0003oool0oooo
03T0oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3m0?ooo`80o`00>P3oool000X0oooo
0P3o001X0?ooo`030000003oool0oooo0?d0oooo0P3o000j0?ooo`002P3oool20?l006P0oooo00<0
00000?ooo`3oool0oP3oool20?l003T0oooo000:0?ooo`80o`00J03oool00`000000oooo0?ooo`3n
0?ooo`80o`00>@3oool000X0oooo0P3o001X0?ooo`030000003oool0oooo0?h0oooo0`3o000h0?oo
o`002P3oool30?l006L0oooo00<000000?ooo`3oool0o`3oool20?l003P0oooo000;0?ooo`80o`00
I`3oool00`000000oooo0?ooo`3o0?ooo`<0o`00=`3oool000/0oooo0P3o001W0?ooo`030000003o
ool0oooo0?l0oooo0@3oool20?l003L0oooo000;0?ooo`80o`00I`3oool00`000000oooo0?ooo`3o
0?ooo`40oooo0P3o000g0?ooo`002`3oool20?l006L0oooo00<000000?ooo`3oool0o`3oool10?oo
o`<0o`00=P3oool000/0oooo0P3o001W0?ooo`030000003oool0oooo0?l0oooo0P3oool20?l003H0
oooo000;0?ooo`80o`00I`3oool00`000000oooo0?ooo`3o0?ooo`80oooo0`3o000e0?ooo`002`3o
ool30?l006H0oooo00<000000?ooo`3oool0o`3oool30?ooo`80o`00=@3oool000`0oooo0P3o001V
0?ooo`030000003oool0oooo0?l0oooo0`3oool20?l003D0oooo000<0?ooo`80o`00IP3oool00`00
0000oooo0?ooo`3o0?ooo`<0oooo0`3o000d0?ooo`00303oool20?l006H0oooo00<000000?ooo`3o
ool0o`3oool40?ooo`80o`00=03oool000`0oooo0`3o001U0?ooo`030000003oool0oooo0?l0oooo
103oool30?l003<0oooo000=0?ooo`80o`00I@3oool00`000000oooo0?ooo`3o0?ooo`D0oooo0P3o
000c0?ooo`003@3oool20?l006D0oooo00<000000?ooo`3oool0o`3oool50?ooo`80o`00<`3oool0
00d0oooo0P3o001U0?ooo`030000003oool0oooo0?l0oooo1@3oool20?l003<0oooo000=0?ooo`<0
o`00I03oool00`000000oooo0?ooo`3o0?ooo`D0oooo0`3o000b0?ooo`003P3oool20?l006@0oooo
00<000000?ooo`3oool0o`3oool60?ooo`80o`00<P3oool000h0oooo0P3o001T0?ooo`030000003o
ool0oooo0?l0oooo1P3oool20?l00380oooo000>0?ooo`80o`00I03oool00`000000oooo0?ooo`3o
0?ooo`H0oooo0P3o000b0?ooo`003P3oool30?l006<0oooo00<000000?ooo`3oool0o`3oool60?oo
o`<0o`00<@3oool000l0oooo0P3o001S0?ooo`030000003oool0oooo0?l0oooo1`3oool20?l00340
oooo000?0?ooo`80o`00H`3oool00`000000oooo0?ooo`3o0?ooo`L0oooo0P3o000a0?ooo`003`3o
ool20?l006<0oooo00<000000?ooo`3oool0o`3oool70?ooo`80o`00<@3oool000l0oooo0`3o001R
0?ooo`030000003oool0oooo0?l0oooo1`3oool30?l00300oooo000@0?ooo`80o`00HP3oool00`00
0000oooo0?ooo`3o0?ooo`P0oooo0P3o000`0?ooo`00403oool20?l00680oooo00<000000?ooo`3o
ool0o`3oool80?ooo`80o`00<03oool00100oooo0P3o001R0?ooo`030000003oool0oooo0?l0oooo
203oool20?l00300oooo000@0?ooo`<0o`00H@3oool00`000000oooo0?ooo`3o0?ooo`P0oooo0`3o
000_0?ooo`004@3oool20?l00640oooo00<000000?ooo`3oool0o`3oool90?ooo`80o`00;`3oool0
0140oooo0P3o001Q0?ooo`030000003oool0oooo0?l0oooo2@3oool20?l002l0oooo000A0?ooo`<0
o`00H03oool00`000000oooo0?ooo`3o0?ooo`T0oooo0P3o000_0?ooo`004P3oool20?l00600oooo
00<000000?ooo`3oool0o`3oool90?ooo`<0o`00;P3oool00180oooo0`3o001O0?ooo`030000003o
ool0oooo0?l0oooo2P3oool20?l001l0oooo00H0gia800000000000007Bo0?ooo`2oM00200000003
04RLg`3oool0oooo00@0oooo000C0?ooo`80o`00G`3oool00`000000oooo0?ooo`3o0?ooo`X0oooo
0P3o000P0?ooo`070?noM0000000M;oo0?ooo`3o_g@0000007Boo`070?ooo`0000<0oooo00000000
0000400000020?l005h000000`3o003o000000/000000P3o000C000000h0oooo00D0oono07@0B018
M4P0B01d0;ooo`080?ooo`00503oool00`3o0000oooo0?ooo`1L0?ooo`@0o`00o`3oool:0?ooo`80
o`008P3oool00`2LB000B4Q80018W0090?ooo`00503oool20?l005h0oooo0`3o003o0?ooo`X0oooo
0`3o000O0?ooo`070?oo_`1d0000B9cO0?ooo`3OW4P0001d0;ooo`070?ooo`005@3oool00`3o0000
oooo0?ooo`1L0?ooo`040000003oool0o`000?l00?l0oooo2P3oool20?l001h0oooo00T0omnL04P0
0000000007Bo0?ooo`2oM00000000000B02Lgol01P3oool001D0oooo0P3o001M0?ooo`030000003o
ool0oooo0080o`00o`3oool90?ooo`80o`00;@3oool001H0oooo00<0o`000?ooo`3oool0F`3oool0
0`000000oooo0?ooo`030?l00?l0oooo203oool20?l002d0oooo000F0?ooo`80o`00G03oool01000
0000oooo0?ooo`3oool20?l00?l0oooo203oool30?l002`0oooo000G0?ooo`030?l0003oool0oooo
05X0oooo00@000000?ooo`3oool0oooo0P3o003o0?ooo`T0oooo0P3o000/0?ooo`005`3oool20?l0
05/0oooo00@000000?ooo`3oool0oooo0P3o003o0?ooo`T0oooo0P3o000/0?ooo`00603oool20?l0
05X0oooo00@000000?ooo`3oool0oooo0P3o003o0?ooo`T0oooo0P3o000/0?ooo`006@3oool00`3o
0000oooo0?ooo`1H0?ooo`040000003oool0oooo0?ooo`<0o`00o`3oool80?ooo`80o`00;03oool0
01T0oooo0P3o001I0?ooo`030000003oool0oooo0080oooo0P3o003o0?ooo`P0oooo0`3o000[0?oo
o`006P3oool00`3o0000oooo0?ooo`1G0?ooo`030000003oool0oooo0080oooo0P3o003o0?ooo`T0
oooo0P3o000[0?ooo`006P3oool20?l005P0oooo00<000000?ooo`3oool00P3oool20?l00?l0oooo
2@3oool20?l002/0oooo000K0?ooo`80o`00E`3oool00`000000oooo0?ooo`020?ooo`80o`00o`3o
ool90?ooo`80o`00:`3oool001`0oooo00<0o`000?ooo`3oool0E@3oool00`000000oooo0?ooo`02
0?ooo`80o`00o`3oool90?ooo`80o`00:`3oool001`0oooo0P3o001F0?ooo`040000003oool0oooo
0?ooo`<0o`00o`3oool:0?ooo`80o`00:P3oool001d0oooo0P3o001E0?ooo`040000003oool0oooo
0?ooo`80o`00o`3oool;0?ooo`80o`00:P3oool001h0oooo0P3o001D0?ooo`040000003oool0oooo
0?ooo`80o`00o`3oool;0?ooo`80o`00:P3oool001h0oooo0`3o001C0?ooo`040000003oool0oooo
0?ooo`80o`00o`3oool;0?ooo`80o`00:P3oool001l0oooo0`3o001B0?ooo`040000003oool0oooo
0?ooo`80o`00o`3oool;0?ooo`80o`00:P3oool00200oooo0`3o001A0?ooo`040000003oool0oooo
0?ooo`80o`00o`3oool<0?ooo`80o`00:@3oool00240oooo0P3o001A0?ooo`030000003oool0oooo
00<0o`00o`3oool<0?ooo`80o`00:@3oool00280oooo0P3o001@0?ooo`030000003oool0oooo0080
o`00o`3oool=0?ooo`80o`00:@3oool00280oooo0`3o001?0?ooo`030000003oool0oooo0080o`00
o`3oool=0?ooo`80o`00:@3oool002<0oooo0`3o001>0?ooo`040000003oool0o`000?l00?l0oooo
3P3oool20?l002T0oooo000T0?ooo`<0o`00C@3oool00`000000oooo0?l0003o0?ooo`l0oooo0P3o
000Y0?ooo`009@3oool30?l004`0oooo00<000000?l0003o0000o`3oool@0?ooo`80o`00:03oool0
02H0oooo0`3o001;0?ooo`030000003o0000o`000?l0oooo403oool20?l002P0oooo000W0?ooo`<0
o`00BP3oool00`000000o`000?ooo`3o0?oooa00oooo0P3o000X0?ooo`00:03oool30?l004T0oooo
0P3o003o0?oooa40oooo0P3o000X0?ooo`00:@3oool30?l004L0oooo0P3o003o0?oooa80oooo0P3o
000X0?ooo`00:P3oool40?l004@0oooo0P3o00000`000000oooo0?ooo`3o0?oooa00oooo0P3o000X
0?ooo`00:`3oool40?l00480oooo0`3o00000`000000oooo0?ooo`3o0?oooa40oooo0P3o000W0?oo
o`00;@3oool30?l00400oooo0`3o00000`3oool000000?ooo`3o0?oooa80oooo0P3o000W0?ooo`00
;P3oool30?l003h0oooo0`3o00020?ooo`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo
000_0?ooo`@0o`00>`3oool30?l000<0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`80o`009`3o
ool00300oooo1@3o000g0?ooo`@0o`00103oool00`000000oooo0?ooo`3o0?oooa40oooo0P3o000W
0?ooo`00<P3oool40?l003D0oooo103o00050?ooo`030000003oool0oooo0?l0oooo4@3oool20?l0
02L0oooo000d0?ooo`@0o`00<@3oool40?l000L0oooo00<000000?ooo`3oool0o`3ooolA0?ooo`80
o`009`3oool003D0oooo1@3o000^0?ooo`@0o`00203oool00`000000oooo0?ooo`3o0?oooa40oooo
0P3o000W0?ooo`00=`3oool50?l002X0oooo103o000:0?ooo`030000003oool0oooo0?l0oooo4@3o
ool20?l002L0oooo000i0?ooo`H0o`009P3oool40?l000/0oooo00<000000?ooo`3oool0o`3ooolA
0?ooo`80o`009`3oool003/0oooo1P3o000P0?ooo`H0o`003@3oool00`000000oooo0?ooo`3o0?oo
oa80oooo0P3o000V0?ooo`00?P3oool60?l001/0oooo1P3o000?0?ooo`030000003oool0oooo0?l0
oooo4P3oool20?l002H0oooo00100?ooo`H0o`005`3oool50?l00180oooo00<000000?ooo`3oool0
o`3ooolB0?ooo`80o`009P3oool004<0oooo203o000>0?ooo`L0o`00503oool00`000000oooo0?oo
o`3o0?oooa80oooo0P3o000V0?ooo`00A@3ooolI0?l001H0oooo00<000000?ooo`3oool0o`3ooolB
0?ooo`80o`009P3oool004X0oooo403o000J0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l0
02H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3o
ool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l0
02D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3o
ool20?l002D0oooo001d0?ooo`030000003oool0oooo0?l0oooo4`3oool20?l002D0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l0
02H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3o
ool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4P3oool20?l002H0oooo001d0?ooo`030000003oool0oooo0?l0
oooo4@3oool20?l002L0oooo001d0?ooo`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo
001d0?ooo`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo001d0?ooo`030000003oool0
oooo0?l0oooo4@3oool20?l002L0oooo001d0?ooo`030000003oool0oooo0?l0oooo4@3oool20?l0
02L0oooo001d0?ooo`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo001d0?ooo`030000
003oool0oooo0?l0oooo4@3oool20?l002L0oooo001d0?ooo`030000003oool0oooo0?l0oooo4@3o
ool20?l002L0oooo001d0?ooo`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo001d0?oo
o`030000003oool0oooo0?l0oooo4@3oool20?l002L0oooo001d0?ooo`030000003oool0oooo0?l0
oooo403oool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0oooo403oool20?l002P0oooo
001d0?ooo`030000003oool0oooo0?l0oooo403oool20?l002P0oooo001d0?ooo`030000003oool0
oooo0?l0oooo403oool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0oooo403oool20?l0
02P0oooo001d0?ooo`030000003oool0oooo0?l0oooo403oool20?l002P0oooo001d0?ooo`030000
003oool0oooo0?l0oooo403oool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0oooo403o
ool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0oooo403oool20?l002P0oooo001d0?oo
o`030000003oool0oooo0?l0oooo403oool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0
oooo403oool20?l002P0oooo001d0?ooo`030000003oool0oooo0?l0oooo3`3oool20?l002T0oooo
001d0?ooo`030000003oool0oooo0?l0oooo3`3oool20?l002T0oooo001d0?ooo`030000003oool0
oooo0?l0oooo3`3oool20?l002T0oooo001d0?ooo`030000003oool0oooo0?l0oooo3`3oool20?l0
02T0oooo001d0?ooo`030000003oool0oooo0?l0oooo3P3oool30?l002T0oooo001d0?ooo`030000
003oool0oooo0?l0oooo3P3oool20?l002X0oooo001d0?ooo`030000003oool0oooo0?l0oooo3P3o
ool20?l002X0oooo001d0?ooo`030000003oool0oooo0?l0oooo3P3oool20?l002X0oooo001d0?oo
o`030000003oool0oooo0?l0oooo3@3oool30?l002X0oooo001d0?ooo`030000003oool0oooo0?l0
oooo3@3oool20?l002/0oooo001d0?ooo`030000003oool0oooo0?l0oooo3@3oool20?l002/0oooo
001d0?ooo`030000003oool0oooo0?l0oooo3@3oool20?l002/0oooo001d0?ooo`030000003oool0
oooo0?l0oooo303oool30?l002/0oooo001d0?ooo`030000003oool0oooo0?l0oooo303oool20?l0
02`0oooo001d0?ooo`030000003oool0oooo0?l0oooo303oool20?l002`0oooo001d0?ooo`030000
003oool0oooo0?l0oooo303oool20?l002`0oooo001d0?ooo`030000003oool0oooo0?l0oooo2`3o
ool30?l002`0oooo001d0?ooo`030000003oool0oooo0?l0oooo2`3oool20?l002d0oooo001d0?oo
o`030000003oool0oooo0?l0oooo2`3oool20?l002d0oooo001d0?ooo`030000003oool0oooo0?l0
oooo2`3oool20?l002d0oooo001d0?ooo`030000003oool0oooo0?l0oooo2`3oool20?l002d0oooo
001d0?ooo`030000003oool0oooo0?l0oooo2P3oool30?l002d0oooo001d0?ooo`030000003oool0
oooo0?l0oooo2P3oool20?l002h0oooo001d0?ooo`030000003oool0oooo0?l0oooo2P3oool20?l0
02h0oooo001d0?ooo`030000003oool0oooo0?l0oooo2P3oool20?l002h0oooo001d0?ooo`030000
003oool0oooo0?l0oooo2@3oool30?l002h0oooo001d0?ooo`030000003oool0oooo0?l0oooo2@3o
ool20?l002l0oooo001d0?ooo`030000003oool0oooo0?l0oooo2@3oool20?l002l0oooo001d0?oo
o`030000003oool0oooo0?l0oooo2@3oool20?l002l0oooo001d0?ooo`030000003oool0oooo0?l0
oooo2@3oool20?l002l0oooo001d0?ooo`030000003oool0oooo0?l0oooo203oool30?l002l0oooo
001d0?ooo`030000003oool0oooo0?l0oooo203oool20?l00300oooo001d0?ooo`030000003oool0
oooo0?l0oooo203oool20?l00300oooo001d0?ooo`030000003oool0oooo0?l0oooo203oool20?l0
0300oooo001d0?ooo`030000003oool0oooo0?l0oooo1`3oool30?l00300oooo001d0?ooo`030000
003oool0oooo0?l0oooo1`3oool20?l00340oooo001d0?ooo`030000003oool0oooo0?l0oooo1`3o
ool20?l00340oooo001d0?ooo`030000003oool0oooo0?l0oooo1P3oool30?l00340oooo001d0?oo
o`030000003oool0oooo0?l0oooo1P3oool20?l00380oooo001d0?ooo`030000003oool0oooo0?l0
oooo1P3oool20?l00380oooo001d0?ooo`030000003oool0oooo0?l0oooo1P3oool20?l00380oooo
001d0?ooo`030000003oool0oooo0?l0oooo1@3oool30?l00380oooo001d0?ooo`030000003oool0
oooo0?l0oooo1@3oool20?l003<0oooo001d0?ooo`030000003oool0oooo0?l0oooo1@3oool20?l0
03<0oooo001d0?ooo`030000003oool0oooo0?l0oooo103oool30?l003<0oooo001d0?ooo`030000
003oool0oooo0?l0oooo103oool20?l003@0oooo001d0?ooo`030000003oool0oooo0?l0oooo103o
ool20?l003@0oooo001d0?ooo`030000003oool0oooo0?l0oooo0`3oool30?l003@0oooo001d0?oo
o`030000003oool0oooo0?l0oooo0`3oool20?l003D0oooo001d0?ooo`030000003oool0oooo0?l0
oooo0`3oool20?l003D0oooo001d0?ooo`030000003oool0oooo0?l0oooo0P3oool30?l003D0oooo
001d0?ooo`030000003oool0oooo0?l0oooo0P3oool20?l003H0oooo001d0?ooo`030000003oool0
oooo0?l0oooo0P3oool20?l003H0oooo001d0?ooo`030000003oool0oooo0?l0oooo0P3oool20?l0
03H0oooo001d0?ooo`030000003oool0oooo0?l0oooo0@3oool30?l003H0oooo001d0?ooo`030000
003oool0oooo0?l0oooo0@3oool20?l003L0oooo001d0?ooo`030000003oool0oooo0?l0oooo0@3o
ool20?l003L0oooo001d0?ooo`030000003oool0oooo0?l0oooo0`3o000g0?ooo`00M03oool00`00
0000oooo0?ooo`3o0?ooo`80o`00>03oool007@0oooo00<000000?ooo`3oool0oP3oool30?l003P0
oooo001d0?ooo`030000003oool0oooo0?h0oooo0P3o000i0?ooo`00M03oool00`000000oooo0?oo
o`3n0?ooo`80o`00>@3oool007@0oooo00<000000?ooo`3oool0o@3oool30?l003T0oooo001d0?oo
o`030000003oool0oooo0?d0oooo0P3o000j0?ooo`00M03oool00`000000oooo0?ooo`3l0?ooo`<0
o`00>P3oool007@0oooo00<000000?ooo`3oool0o03oool20?l003/0oooo001d0?ooo`030000003o
ool0oooo0?`0oooo0P3o000k0?ooo`00M03oool00`000000oooo0?ooo`3k0?ooo`<0o`00>`3oool0
07@0oooo00<000000?ooo`3oool0n`3oool20?l003`0oooo001d0?ooo`030000003oool0oooo0?X0
oooo0`3o000l0?ooo`00M03oool00`000000oooo0?ooo`3j0?ooo`80o`00?@3oool007@0oooo00<0
00000?ooo`3oool0n@3oool30?l003d0oooo001d0?ooo`030000003oool0oooo0?T0oooo0P3o000n
0?ooo`00M03oool00`000000oooo0?ooo`3i0?ooo`80o`00?P3oool007@0oooo00<000000?ooo`3o
ool0n03oool30?l003h0oooo001d0?ooo`030000003oool0oooo0?P0oooo0P3o000o0?ooo`00M03o
ool00`000000oooo0?ooo`3g0?ooo`<0o`00?`3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0
oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00?l0oooo/@3oool00700
oooo00<0oono07@0000000000P0000000`00M;l0oooo0?ooo`3o0?ooocT0oooo001c0?ooo`030?no
M000M;l0oooo0?l0oooo>`3oool007@0oooo00<0W4Q809cOo`3oool0o`3ooolj0?ooo`00L`3oool0
0`3ookl0M000001d_`3o0?oooc/0oooo001c0?ooo`040=nLB000M;l0_g@007Boool0oooo>P3oool0
07<0oooo00@0W4Q809cOo`3ogi`0B4RLo`3ooolj0?ooo`00LP3oool01P3o_g@007Bo0?ooo`3oool0
_g@007Boool0oooo>@3oool00780oooo00H0W4Q809cOo`3oool0oooo0?oOW018B9co0?ooocT0oooo
001a0?ooo`080;md00000000001d0;ooo`3ookl0M00000000000M;oo0?ooocP0oooo003o0?oook40
oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40oooo003o0?oook40
oooo003o0?oook40oooo0000\
\>"],
  ImageRangeCache->{{{0, 431}, {431, 0}} -> {-3.05218, -4.89025, 0.0391906, \
0.0363482}}],

Cell[BoxData[
    \("After more revolutions, Yes or No?"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("Finished"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \("---------------------------"\)], "Print",
  CellLabel->"From In[13]:="],

Cell[BoxData[
    \({Null}\)], "Output",
  CellLabel->"Out[13]="]
}, Open  ]],

Cell["\<\

In this example the test particle placed at distance of  only 10 \
Schwarzschild radius falls into the black hole in only two revolutions if its \
eccentricity is different from zero, no matter how small.\
\>", "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
FrontEndVersion->"5.2 for Microsoft Windows",
ScreenRectangle->{{0, 1440}, {0, 813}},
WindowSize->{1264, 679},
WindowMargins->{{0, Automatic}, {Automatic, 0}},
Magnification->1.5,
StyleDefinitions -> "HelpBrowser.nb"
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 58, 0, 155, "Title"],
Cell[1837, 55, 268, 6, 64, "Text"],

Cell[CellGroupData[{
Cell[2130, 65, 99, 3, 132, "Section"],

Cell[CellGroupData[{
Cell[2254, 72, 65, 3, 89, "Subsection"],

Cell[CellGroupData[{
Cell[2344, 79, 98, 2, 66, "Input"],
Cell[2445, 83, 92, 2, 32, "Print"],
Cell[2540, 87, 119, 2, 32, "Print"],
Cell[2662, 91, 94, 2, 32, "Print"],
Cell[2759, 95, 92, 2, 32, "Print"],
Cell[2854, 99, 96, 2, 32, "Print"],
Cell[2953, 103, 92, 2, 32, "Print"],
Cell[3048, 107, 113, 2, 32, "Print"],
Cell[3164, 111, 222, 5, 32, "Print"],
Cell[3389, 118, 205, 4, 32, "Print"],
Cell[3597, 124, 92, 2, 32, "Print"],
Cell[3692, 128, 102, 2, 32, "Print"],
Cell[3797, 132, 22435, 493, 276, 5035, 273, "GraphicsData", "PostScript", \
"Graphics"],
Cell[26235, 627, 92, 2, 32, "Print"],
Cell[26330, 631, 113, 2, 32, "Print"],
Cell[26446, 635, 92, 2, 32, "Print"],
Cell[26541, 639, 214, 5, 32, "Print"],
Cell[26758, 646, 32313, 618, 441, 5043, 276, "GraphicsData", "PostScript", \
"Graphics"],
Cell[59074, 1266, 99, 2, 32, "Print"],
Cell[59176, 1270, 92, 2, 32, "Print"],
Cell[59271, 1274, 214, 5, 32, "Print"],
Cell[59488, 1281, 49618, 978, 441, 7881, 457, "GraphicsData", "PostScript", \
"Graphics"],
Cell[109109, 2261, 99, 2, 32, "Print"],
Cell[109211, 2265, 92, 2, 32, "Print"],
Cell[109306, 2269, 216, 5, 32, "Print"],
Cell[109525, 2276, 93431, 1820, 441, 13741, 831, "GraphicsData", \
"PostScript", "Graphics"],
Cell[202959, 4098, 99, 2, 32, "Print"],
Cell[203061, 4102, 73, 2, 32, "Print"],
Cell[203137, 4106, 92, 2, 32, "Print"],
Cell[203232, 4110, 65, 2, 38, "Output"]
}, Open  ]],
Cell[203312, 4115, 165, 4, 64, "Text"]
}, Open  ]],

Cell[CellGroupData[{
Cell[203514, 4124, 61, 3, 89, "Subsection"],

Cell[CellGroupData[{
Cell[203600, 4131, 98, 2, 66, "Input"],
Cell[203701, 4135, 92, 2, 32, "Print"],
Cell[203796, 4139, 119, 2, 32, "Print"],
Cell[203918, 4143, 94, 2, 32, "Print"],
Cell[204015, 4147, 92, 2, 32, "Print"],
Cell[204110, 4151, 96, 2, 32, "Print"],
Cell[204209, 4155, 92, 2, 32, "Print"],
Cell[204304, 4159, 113, 2, 32, "Print"],
Cell[204420, 4163, 222, 5, 32, "Print"],
Cell[204645, 4170, 205, 4, 32, "Print"],
Cell[204853, 4176, 92, 2, 32, "Print"],
Cell[204948, 4180, 102, 2, 32, "Print"],
Cell[205053, 4184, 21440, 473, 276, 4907, 264, "GraphicsData", "PostScript", \
"Graphics"],
Cell[226496, 4659, 92, 2, 32, "Print"],
Cell[226591, 4663, 113, 2, 32, "Print"],
Cell[226707, 4667, 92, 2, 32, "Print"],
Cell[226802, 4671, 214, 5, 32, "Print"],
Cell[227019, 4678, 30216, 595, 441, 5096, 280, "GraphicsData", "PostScript", \
"Graphics"],
Cell[257238, 5275, 99, 2, 32, "Print"],
Cell[257340, 5279, 92, 2, 32, "Print"],
Cell[257435, 5283, 214, 5, 32, "Print"],
Cell[257652, 5290, 33577, 706, 441, 6479, 366, "GraphicsData", "PostScript", \
"Graphics"],
Cell[291232, 5998, 99, 2, 32, "Print"],
Cell[291334, 6002, 73, 2, 32, "Print"],
Cell[291410, 6006, 92, 2, 32, "Print"],
Cell[291505, 6010, 65, 2, 38, "Output"]
}, Open  ]],
Cell[291585, 6015, 229, 5, 86, "Text"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

