tiny <- 1E-6
# Our three scenarios
BE <- 1
UP <- 2
DOWN <- 3

# Maturity t, rel. change sup(t), re. change sdown(t)
# Durations shorter than 1 year have the same relative
# changes as duration 1
Shocks <- rbind(c(1, 70/100, -75/100),
                c(2, 70/100, -65/100),
                c(3, 64/100, -56/100),
                c(4, 59/100, -50/100),
                c(5, 55/100, -46/100),
                c(6, 52/100, -42/100),
                c(7, 49/100, -39/100),
                c(8, 47/100, -36/100),
                c(9, 44/100, -33/100),
                c(10, 42/100, -31/100),
                c(11, 39/100, -30/100),
                c(12, 37/100, -29/100),
                c(13, 35/100, -28/100),
                c(14, 34/100, -28/100),
                c(15, 33/100, -27/100),
                c(16, 31/100, -28/100),
                c(17, 30/100, -28/100),
                c(18, 29/100, -28/100),
                c(19, 27/100, -29/100),
                c(20, 26/100, -29/100),
                c(21, 26/100, -29/100),
                c(22, 26/100, -30/100),
                c(23, 26/100, -30/100),
                c(24, 26/100, -30/100),
                c(25, 26/100, -30/100),
                c(30, 25/100, -30/100))

T <- 8

Bonds <- c(1200, 500, 300, 100,   0,   0,   0,  0)
Repl <-  c( 500, 450, 300, 250, 200, 150, 100, 50)
RF_BE <- c( 0.5, 1.0, 1.2, 1.5, 2.0, 2.2, 2.3, 2.3)/100
Stat_Interest <- 0.5 / 100

## statutory provisions at thebeginning of the period
## are equal to the statutory provisions at the end of 
## the previous period
StatProv_BoP <- vector("numeric",T)
for (t in 1:T){
  StatProv_BoP[t] <- 
    sum( Repl[t:T] / (1+Stat_Interest)^(1:(T-t+1)) )
}

# Initialization of vectors and matrices
Assets <- c()
Bonus <- matrix(NA,3,T)
Liabs <- rep(NA,3)
NAV <- rep(NA,3)
D_NAV <- rep(NA,3)
ADJ_Liabs <- rep(NA,3)
ADJ_NAV <- rep(NA,3)
ADJ_D_NAV <- rep(NA,3)

# risk free rate for the three scenarios: BE, UP, DOWN
RF <- rbind(RF_BE,
            RF_BE * (1+Shocks[1:T,UP]),
            pmax(RF_BE +
                 pmin(RF_BE * Shocks[1:T,DOWN],
                      -0.01),
                 0) )

# The policyholders are credited 90% of risk free rate
for (i in c(BE,UP,DOWN)){
  Bonus[i,] <- 
     pmax(0, 0.9 * RF[i,] - Stat_Interest) *
           StatProv_BoP
}

for (i in c(BE,UP,DOWN)){
  Assets[i] <- sum(Bonds / cumprod(1+RF[i,]))
  # Without risk mitigation we use the best estimate
  # claims in all scenarios
  Liabs[i] <- 
    sum((Repl+Bonus[BE,]) / cumprod(1+RF[i,]))
  NAV[i] <- Assets[i]-Liabs[i]
  ADJ_Liabs[i] <- 
    sum((Repl+Bonus[i,]) / cumprod(1+RF[i,]))
  ADJ_NAV[i] <- Assets[i]-ADJ_Liabs[i]
}
for (i in c(UP,DOWN)){
  D_NAV[i] <- max(0,-(NAV[i]-NAV[BE]))
  ADJ_D_NAV[i] <- max(0,-(ADJ_NAV[i]-ADJ_NAV[BE]))
}

ADJ_SCR <- max(ADJ_D_NAV[UP],ADJ_D_NAV[DOWN],0)

# tiny rather than 0 to avert rounding problems
if (ADJ_SCR < tiny){  
  SCR <- 0
}else if (abs(ADJ_SCR-ADJ_D_NAV[UP]) < tiny){
  SCR <- D_NAV[UP]
}else{
  SCR <- D_NAV[DOWN]
}

FDB <- sum(Bonus[BE,]/cumprod(1+RF[BE,]))
ADJ <- -min(SCR-ADJ_SCR,FDB)
SCR_Final=SCR+ADJ


Results <- data.frame(row.names = c("BE","UP","DOWN"),
                      Assets,
                      Liabs,
                      NAV,
                      D_NAV,
                      ADJ_Liabs,
                      ADJ_NAV,
                      ADJ_D_NAV
                      )
names(Results) = (c("Assets",
                    "Liabs",
                    "NAV",
                    "D_NAV",
                    "ADJ_Liabs",
                    "ADJ_NAV",
                    "ADJ_D_NAV"))
print(round(Results,0))
SCR_Result <- data.frame(SCR,ADJ_SCR)
names(SCR_Result) <- c("SCR","ADJ_SCR")
print(SCR_Result)
print(FDB)
print(ADJ)
print(SCR_Final)
