# This will give reproducible results:
set.seed(2)

### Global constants
tiny <- 1E-6
# gross: before reinsurance, net: after reinsurance
gross <- 1; net <- 2
# The BU[[1]] represents Investments
# The first insurance BU has therefore index 2
FirstIns <- 2

strSep = ",";
strDec = ".";

# Global Projection Parameters
NoScen <- 10000
StartCapital <- 1400
FixedCosts <- 20
RiskFreeRate <- 0.03
ConfLevel <- 0.99

BU_Name <- c( "Investment",
             "Fire",
             "Indemnity",
             "Theft")
BU_Premium <- c( NA, 600, 300, 100)
BU_LossRatio <- c( NA, 0.75, 0.75, 0.75)
BU_CostRatio <- c( 0.005, 0.05, 0.05, 0.05)
BU_VarKoeff <- c( NA, 0.5, 0.6, 0.7)
BU_Investments_Mean <- 0.05
BU_Investments_Sd <- 0.02
BU_ReCeded <- c( 0.00, 0.25, 0.20, 0.20)
# Reinsurance commission = negative costs:
BU_ReCosts <- c( 0.00, -0.06, -0.06, -0.06) 
BU_KendalTau <- c( 0.0, 0.0, 0.0, 0.3, 0.2, 0.6)

