## Earned Premium
Prem <- array(NA, c(NoIns,2))
Prem_written<- array(NA, c(NoIns,2))
for (t in PY:CY){
  Prem_written[,t] <- (1-ReP_Q)*Prem_written_gross[,t]
  Prem[,t] <- Prem_written[,t]+UPR[,t]-UPR[,t+1]
}

# calculation of the variation coefficient
# for the net premium risk
s <-  sqrt(log(1 + VC_Y_gross^2))
m <- log(Mean_Y_gross) - s^2 / 2

aq <- ReNP_a/(1-ReP_Q)
hq <- ReNP_h/(1-ReP_Q)
  
Mean_Y <-(1-ReP_Q) * (  exp(m+s^2/2) - hq
                          - aq * plnorm(aq,m,s)
                          + (aq+hq) * plnorm(aq+hq,m,s)
                          + exp(m+s^2/2)
                            * plnorm(aq,m+s^2,s)
                          - exp(m+s^2/2)
                            * plnorm(aq+hq,m+s^2,s)
                          )
VC_Y <- sqrt((1-ReP_Q)^2 *
                 (
                  (exp(2*m+2*s^2)
                   - 2*hq*exp(m+s^2/2) + hq^2)
                  - aq^2 * plnorm(aq,m,s)
                  + (aq^2-hq^2) * plnorm(aq+hq,m,s)
                  + 2*hq*exp(m+s^2/2)
                    * plnorm(aq+hq,m+s^2,s)
                  + exp(2*m+2*s^2)
                    * plnorm(aq,m+2*s^2,s)
                  - exp(2*m+2*s^2)
                    * plnorm(aq+hq,m+2*s^2,s) 
                  ) / Mean_Y^2 -1
                 )
VC_Prem <- VC_Prem_gross * sqrt((1+VC_Y^2) / exp(s^2))

#Calculation of volume measured for premium and reserve
V_Prem <- c()
for (k in 1:NoIns){
   V_Prem[k] <- max(Prem_written[k,PY],
                    Prem_written[k,CY],
                    Prem[k,CY])+PremResPY[k]
 }

DiscountFactor <- 1
V_Res <- array(0,c(NoIns))
for (t in 1:t_runoff){
  DiscountFactor <- DiscountFactor/(1+Interest[t])
  V_Res <- ( V_Res +
            ResPY_undiscounted
            *beta[,t] * DiscountFactor )
}

# Calculation of the variation coefficient
# for the total premium reserve risk
sd_Prem <- V_Prem * VC_Prem
sd_Res <- V_Res * VC_Res
sd_PremRes <- c()
for (k in 1:NoIns){
  sd_PremRes[k] <- sqrt(c(sd_Prem[k],sd_Res[k])
                   %*% corr_PremRes %*%
                   c(sd_Prem[k],sd_Res[k]))
}
VC_PremRes <- sd_PremRes / (V_Prem+V_Res) 

Mean_PremRes_total <- sum(V_Prem) + sum(V_Res)
sd_PremRes_total <- sqrt( sd_PremRes
                          %*% corr_LoB_LoB %*%
                          sd_PremRes )
VC_PremRes_total <- sd_PremRes_total/Mean_PremRes_total

# Calculation of SCR components and their aggregation
SCR_PremRes <- (  Mean_PremRes_total
                 / sqrt( 1 + VC_PremRes_total^2 )
                * exp(sqrt(log(1 + VC_PremRes_total^2))
                      * qnorm(ConfLevel,0,1))
                )
SCR_Lapse <- max(NAV_BE-NAV_Up,NAV_BE-NAV_Down)
SCR_PremResLapse <- sqrt(c(SCR_PremRes,SCR_Lapse)
                         %*% corr_PremRes_Lapse %*%
                         c(SCR_PremRes,SCR_Lapse) )


Cat_P_Events <- t(CatSplit) %*% Prem_written_gross[,CY]
Cat_Loss <- Cat_P_Events*CatFactor
SCR_Cat <- sqrt( (sqrt(sum(Cat_Loss[CatSetA]^2))
                  + sum(Cat_Loss[CatSetB]))^2
                + sum(Cat_Loss[CatSetC]^2)
                + sum(Cat_Loss[CatSetD])^2
                )

SCR_PremResLapseCat <- sqrt(c(SCR_PremResLapse,SCR_Cat)
                        %*% corr_PremResLapse_Cat %*%
                        c(SCR_PremResLapse,SCR_Cat) )

