### Global constants
tiny <- 1E-6
# gross: before reinsurance, net: after reinsurance
gross <- 1; net <- 2

ConfLevel <- 0.995

# Following assignments make indexing more comfortable
NoIns <- 3
F <- 1 # Fire
L <- 2 # Liability
T <- 3 # Theft
PY <- 1 # Past Year
CY <- 2 # Current Year
NY <- 3 # Next Year

Ins_Name <- c("Fire", "Liability", "Theft")
Ins_No <- c(
            NA, #  1
            NA, #  2
            NA, #  3
             F, #  4
             L, #  5
            NA, #  6
            NA, #  7
            NA, #  8
             T, #  9
            NA, # 10
            NA, # 11
            NA  # 12
            )

#  Row Index: Lob_Name
#  Column index: Time (PY, CY, NY) 

# Gross written premium for PY and CY
Prem_written_gross <- rbind(c( 500, 600),
                            c( 250, 300),
                            c(  50, 100))

# Mean and variation coefficient of the cost per claim
# gross of reinsurance
Mean_Y_gross <- c(0.1, 0.1, 0.1)
VC_Y_gross <- c( 0.5, 0.6, 0.7)

# unearned premiums reserve for PY, CY, NY
# (net values)
UPR <- rbind(c( 50, 70, 75),
             c( 20, 40, 45),
             c(  5, 12, 15))

#Costs <- c( 0.05, 0.05, 0.05)

# Proportional reinsurance
ReP_Q <- c( 0.25, 0.20, 0.20)

# Non-proportional reinsurance
ReNP_a <- c( 0.2,   0,   0)
ReNP_h <- c( 0.5,   0,   0)

# Reserve pattern
t_runoff <- 6
beta <-  array(NA, c(NoIns,t_runoff))
beta_temp <- rbind(c(1, 0.6, 0.1, 0.0, 0.0, 0.0),
                   c(1, 0.9, 0.6, 0.2, 0.1, 0.0),
                   c(1, 0.4, 0.0, 0.0, 0.0, 0.0))
for (k in 1:NoIns) {
  beta[k,] <- beta_temp[k,]/sum(beta_temp[k,])
}

# Reserve and premium reserve: end of previous year
# (= beginning of current year)
ResPY_undiscounted <- c(200,150,20)
PremResPY <- c(0,0,0)

# Result from lapse scenarios: BE, Up, Down
NAV_BE <- 3000
NAV_Up <- 2800
NAV_Down <- 3100

### Quantities provided by EIOPA

# Risk free interest curve
Interest <- c(0.03, 0.031, 0.0315, 0.032, 0.032, 0.032)

# gross variation coefficient for premium risk
VC_Prem_gross <- c( 0.100, 0.150, 0.130)
# net variation coefficient for reserve risk
VC_Res <- c( 0.110, 0.110, 0.150)

#  Data for the catastrophe risk factor model
CatFactor <- c(1.75,
               1.13,
               1.20,
               0.30,
               1.75,
               1.00,
               0.40,
               0.85,
               1.39,
               0.40,
               2.50,
               2.50,
               2.50)
CatSet <-  list( c(2,4),
                 c(2,4),
                 c(2,4),
                 c(2),
                 c(4),
                 c(3),
                 c(1),
                 c(5),
                 c(6),
                 c(9),
                 c(10),
                 c(11),
                 c(12)
                )
# Sets of indices that reflect the structure of
# the SCR Cat square root formula
CatSetA <- c(1,2,3,5)
CatSetB <- c(11)
CatSetC <- c(4,7,8,9,10,12)
CatSetD <- c(6,13)

# Event i:            1    2    3    4    5    6    
#                     7    8    9   10   11   12   13
CatSplit <- rbind(c(0.1, 0.2, 0.3, 0.0, 0.4, 0.0,
                    0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0),
                  c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0),
                  c(0.0, 0.0, 0.0, 0.0, 0.0, 0.0,
                    0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0))

# Correlation matrices

# Correlation: premium risk and reserve risk
# same correlation for every LoB
corr_PremRes <- rbind(c( 1.0, 0.5),
                      c( 0.5, 1.0))

# Premium and reserve risk,
# correlation: lines of business
#                        F     H       D
corr_LoB_LoB <- rbind(c( 1.00,  0.25,  0.50), # F
                      c( 0.25,  1.00,  0.50), # H
                      c( 0.50,  0.50,  1.00)) # D              

# Correlation: premium/reserve risk and lapse risk
corr_PremRes_Lapse <- rbind(c(1,0),
                            c(0,1))
# Cat risk,
# correlation: lines of business
#                    F  H  D  
corr_Cat <- rbind(c( 1, 0, 0),  #  F
                  c( 0, 1, 0),  #  H
                  c( 0, 0, 1))  #  D


# Correlation: premium/reserve/lapse risk and cat risk
corr_PremResLapse_Cat <- rbind(c(1.00, 0.25),
                               c(0.25, 1.00))
