print("Company inputs:")
dIns <- data.frame(row.names = c("F","L","T"),
                   Prem_written_gross,
                   UPR,
                   Mean_Y_gross,
                   VC_Y_gross,
                   ReP_Q,
                   ReNP_a,
                   ReNP_h,
                   ResPY_undiscounted,
                   PremResPY)
names(dIns) = (c("Prem_written_gross[,PY]",
                 "Prem_written_gross[,CY]",
                 "UPR[,PY]",
                 "UPR[,CY]",
                 "UPR[,NY]",
                 "Mean_Y_gross",
                 "VC_Y_gross",
                 "ReP_Q",
                 "ReNP_a",
                 "ReNP_h",
                 "ResPY_undiscounted",
                 "PremResPY")
               )
print(dIns)

dInsCat <- data.frame(row.names = c("F","L","T"),
                   CatSplit)
names(dInsCat) = (c("lambda_1","lambda_2","lambda_3",
                    "lambda_4","lambda_5","lambda_6",
                    "lambda_7","lambda_8","lambda_9",
                    "lambda_10","lambda_11",
                    "lambda_12","lambda_13")
                  )
print(dInsCat)

print("")
print("Regulatory inputs:")

dEIOPA <- data.frame(row.names = c("F","L","T"),
                      VC_Prem_gross,
                      VC_Res,
                      corr_LoB_LoB)

names(dEIOPA) = (c("VC_Prem_gross",
                    "VC_Res",
                    "corr_LoB_LoB[,F]",
                    "corr_LoB_LoB[,L]",
                    "corr_LoB_LoB[,T]")
                  )
print(dEIOPA)

dEIOPACat <- data.frame(CatFactor,t(CatSet))
names(dEIOPACat) = (c("CatFactor",
                       "A_1","A_2","A_3","A_4","A_5",
                       "A_6","A_7","A_8","A_9","A_10",
                       "A_11","A_12","A_13")
                     )
print(dEIOPACat)


print("");print("Results")

dg <- 2

dResults <-  data.frame(row.names = c("F","L","T"),
                        round(Prem_written,dg),
                        round(Prem,dg),
                        round(m,dg),
                        round(s,dg),
                        round(Mean_Y,dg+1),
                        round(VC_Y,dg),
                        round(VC_Prem,dg+1),
                        round(V_Prem,dg),
                        round(V_Res,dg),
                        round(sd_Prem,dg),
                        round(sd_Res,dg),
                        round(VC_PremRes,dg+1))
names(dResults) = (c(
                     "Prem_written[,PY]",
                     "Prem_written[,CY]",
                     "Prem[,PY]",
                     "Prem[,CY]",
                     "m",
                     "s",
                     "Mean_Y",
                     "VC_Y",
                     "VC_Prem",
                     "V_Prem",
                     "V_Res",
                     "sd_Prem",
                     "sd_Res",
                     "VC_PremRes")
                   )
print(dResults)

print(paste("Mean_PremRes_total: ",
            round(Mean_PremRes_total,dg), sep=""))
print(paste("VC_PremRes_total: ",
            round(VC_PremRes_total,dg), sep=""))
print(paste("SCR_PremRes: ",
            round(SCR_PremRes,dg), sep=""))
print(paste("SCR_Lapse: ",
            round(SCR_Lapse,dg), sep=""))
print(paste("SCR_PremResLapse: ",
            round(SCR_PremResLapse,dg), sep=""))
print(paste("SCR_Cat: ",
            round(SCR_Cat,dg), sep=""))
print(paste("SCR_PremResLapseCat: ",
            round(SCR_PremResLapseCat,dg), sep=""))
                     
