require(copula)

NoBU <- length(BU_Name) # Number of business units
                        # including investments

# Structure for all business units, investments
# are always BU[[1]]
BU <- NULL  
for (j in 1:NoBU){
  # investments: different handling because of
  # different distributions
  if (j==1){ 
    tempDistrName <- "norm"
    tempDistrPar <- list(mean=BU_Investments_Mean,
                         sd=BU_Investments_Sd)
  }else{
    tempDistrName <- "lnorm"
    tempSdlog <- sqrt(log(1+BU_VarKoeff[j]^2));
    tempMeanlog <- (log(BU_LossRatio[j]*BU_Premium[j])
                    -tempSdlog^2/2);
    tempDistrPar <- list(meanlog=tempMeanlog,
                         sdlog=tempSdlog)
  }
  NextBU <- list(Name = BU_Name[j],
                 Premium=BU_Premium[j],
                 LossRatio=BU_LossRatio[j],
                 CostRatio = BU_CostRatio[j],
                 Distr = list(Name=tempDistrName,
                              NoArg = 2,
                              Par = tempDistrPar),
                 Q = list(Ceded=BU_ReCeded[j],
                          Costs=BU_ReCosts[j]))
  BU <- c(BU,list(NextBU))
}
NextBU <- NULL # Not needed any more

# Set-up of copula using functionality from the
# copula package
cop <- normalCopula(param =  sin( pi/2 * BU_KendalTau),
                    dim = NoBU,
                    dispstr = "un");
copMargin <- NULL
copMarginPar <- NULL
for (i in 1:NoBU){
    copMargin <- c(copMargin,BU[[i]]$Distr$Name)
    copMarginPar <- c(copMarginPar,
                      list(BU[[i]]$Distr$Par))
}
rDistribution <- rMvdc(NoScen,
                       mvdc(cop,
                            copMargin,
                            copMarginPar)
                       )

##### We will now calculate the profit for each run 

Profit <- list(BU = array(NA,dim=c(NoScen,NoBU,2)),
               total = array(NA,dim=c(NoScen,2)),
               BU.mean = array(NA,dim=c(NoBU,2)),
               total.mean = array(NA,dim=c(2)))

##### Premium ------------------------------------
#Premium <- NULL;
# BU index that corresponds to insurance index:
bu <- NULL
# Insurance index that corresponds to BU index: 
ins <- NULL 
for (j in FirstIns:NoBU){
  ins[j] <- j-FirstIns+1
  bu[ins[j]] <- j
}
NoIns <- length(bu)

Premium <- array(NA,dim=c(NoIns,2));
for (j in 1:NoIns){
 Premium[j,gross] <- BU[[bu[j]]]$Premium;
 Premium[j,net] <- (Premium[j,gross]
                    * (1-BU[[bu[j]]]$Q$Ceded));
}

# Investment assets
Assets <- array(NA,dim=c(2));
for (gn in gross:net){
  Assets[gn] <- StartCapital+sum(Premium[1:NoIns,gn])
}

##### Costs --------------------------------------
Costs <-  NULL;
Costs <- array(NA,dim=c(NoBU,2));

for (gn in gross:net){
  Costs[1,gn] <-  BU[[1]]$CostRatio * Assets[gn];
}
for (j in 1:NoIns){
  for (gn in gross:net){
    Costs[bu[j],gn] <- (BU[[bu[j]]]$CostRatio
                        * Premium[j,gross])
  }
  Costs[bu[j],net] <- (Costs[bu[j],net]
                       + BU[[bu[j]]]$Q$Costs
                         * (Premium[j,gross]
                            -Premium[j,net]))
}

##### Profit -------------------------------------
for (gn in gross:net){
  # rDistribution[,1] represents the relative
  # return from the investment 
  Profit$BU[,1,gn] <- ((rDistribution[,1]
                        -RiskFreeRate)
                       *Assets[gn]-Costs[1,gn])
}
for (j in 1:NoIns){
  Profit$BU[,bu[j],gross] <- ((1+RiskFreeRate)
                              *Premium[j,gross]
                              - rDistribution[,bu[j]]
                              - Costs[bu[j],gross])
  Profit$BU[,bu[j],net] <- ((1+RiskFreeRate)
                            *Premium[j,net]
                            - (1-BU[[bu[j]]]$Q$Ceded)
                            *rDistribution[,bu[j]]
                            - Costs[bu[j],net])
}
for (gn in gross:net){
  for (j in 1:NoBU){
    Profit$BU.mean[j,gn] <- (sum(Profit$BU[,j,gn])
                             /NoScen)
  }
}

for (gn in gross:net){
  Profit$total[,gn] <-  (RiskFreeRate * StartCapital
                         - FixedCosts)
  for (j in 1:NoBU){
    Profit$total[,gn] <- (Profit$total[,gn]
                          + Profit$BU[,j,gn])
  }
  Profit$total.mean[gn] <- (sum(Profit$total[,gn])
                            /NoScen)
}

#### We will now calculate the economic capital 
#### and the risk-adjusted return

EcoCap <- list(BU = array(NA,dim=c(NoBU,2)),
               total = array(NA,dim=c(1,2)))

RORAC <- list(BU = array(NA,dim=c(NoBU,2)),
              total = array(NA,dim=c(1,2)))

NotDefined <- -999

ES <- function(profit, perc){
  # Calculation of the expected shortfall
  quantiles <- profit[order(profit,c(1:length(profit)),
                            decreasing=FALSE)]
  result <- NA;
  if(!is.na(perc)){
    if (0 < perc & perc < 1){
      result <- sum(quantiles[1:ceiling(
                          (1-perc)*length(quantiles))])
      result <- -(result
                  / ceiling((1-perc)
                            *length(quantiles)))
    }else{
      warning(paste(" perc should be in ]0,1[,",
                    " perc = ", perc, sep=""))
    }
  }
  result
}

### Calculation of all economic capital values
for (gn in gross:net){
  for (j in 1:NoBU){
    EcoCap$BU[j,gn] <- ES(Profit$BU[,j,gn], ConfLevel)
  }
  EcoCap$total[gn] <-  ES(Profit$total[,gn], ConfLevel)
}

### Calculation of all RAROC values
for (gn in gross:net){
  for (j in 1:NoBU){
    if (EcoCap$BU[j,gn] <= tiny){
      RORAC$BU[j,gn] <- NotDefined
    }else{
      RORAC$BU[j,gn] <- (Profit$BU.mean[j,gn]
                         /EcoCap$BU[j,gn])
    }
  }
  if (EcoCap$total[gn] <= tiny){
    RORAC$total[gn] <- NotDefined
  }else{
    RORAC$total[gn] <- (Profit$total.mean[gn]
                        /EcoCap$total[gn])
  }
}
