program main

implicit none

integer ndivx, ndivy, ndivz, totnode, nt, maxfam, nnum, cnode, i, j, k, tt, nbnd
parameter(ndivx = 100)
parameter(ndivy = 10)
parameter(ndivz = 10)
parameter(nbnd = 0)
parameter (totnode = ndivx * ndivy * ndivz) 
parameter(nt = 535)
parameter(maxfam = 200)

real *8 length, width, thick, dx, delta, dens, emod, pratio, smod, area, vol, bc 
real *8 sedload1, sedload2, sedload3, dt, totime, ctime, idist, fac, radij, nlength, dforce1, dforce2, dforce3 
real *8 pi, tmpdx, tmpvol, tmpcx, tmpux, tmpcy, tmpuy, tmpcz, tmpuz, dmgpar1, dmgpar2, theta, phi 
real *8 scr, scx, scy, scz, coordx, coordy, coordz, cn, cn1, cn2, appres, alpha, dtemp, scr0
real *8 dcont, dfshtemp, dfshort
integer cnt

real *8 coord(totnode,3), pforce(totnode,3), pforceold(totnode,3), bforce(totnode,3), stendens(totnode,3), dmg(totnode,1)
real *8 fncst(totnode,3), disp(totnode,3), vel(totnode,3), velhalfold(totnode,3), velhalf(totnode,3), andisp(totnode,3)
real *8 acc(totnode,3), massvec(totnode,3)
integer numfam(totnode,1), pointfam(totnode,1), nodefam(10000000,1), alflag(totnode,1), mat(totnode,1), fail(totnode,maxfam)
integer numfamnew(totnode,1), pointfamnew(totnode,1), nodefamnew(10000000,1)

pi = dacos(-1.0d0)

!coord: Material point locations
do i = 1, totnode 
	coord(i,1) = 0.0d0
	coord(i,2) = 0.0d0
	coord(i,3) = 0.0d0
	numfam(i,1) = 0
    numfamnew(i,1) = 0
	pointfam(i,1) = 0
    pointfamnew(i,1) = 0
	pforce(i,1) = 0.0d0
	pforce(i,2) = 0.0d0
	pforce(i,3) = 0.0d0
	pforceold(i,1) = 0.0d0
	pforceold(i,2) = 0.0d0
	pforceold(i,3) = 0.0d0
	bforce(i,1) = 0.0d0
	bforce(i,2) = 0.0d0
	bforce(i,3) = 0.0d0
	stendens(i,1) = 0.0d0
	stendens(i,2) = 0.0d0
	stendens(i,3) = 0.0d0
	fncst(i,1) = 1.0d0
	fncst(i,2) = 1.0d0 
	fncst(i,3) = 1.0d0 
	disp(i,1) = 0.0d0
	disp(i,2) = 0.0d0
	disp(i,3) = 0.0d0
	vel(i,1) = 0.0d0
	vel(i,2) = 0.0d0
	vel(i,3) = 0.0d0
	velhalfold(i,1) = 0.0d0
	velhalfold(i,2) = 0.0d0
	velhalfold(i,3) = 0.0d0
	velhalf(i,1) = 0.0d0
	velhalf(i,2) = 0.0d0
	velhalf(i,3) = 0.0d0
	acc(i,1) = 0.0d0
	acc(i,2) = 0.0d0
	acc(i,3) = 0.0d0
	massvec(i,1) = 0.0d0
	massvec(i,2) = 0.0d0
	massvec(i,3) = 0.0d0
    andisp(i,1) = 0.0d0
    andisp(i,2) = 0.0d0
    andisp(i,3) = 0.0d0
    alflag(i,1) = 0
    mat(i,1) = 0
	do j = 1, maxfam
		fail(i,j) = 0
    enddo
    dmg(i,1) = 0.0d0
enddo

do i = 1, 1000000
	nodefam(i,1) = 0
    nodefamnew(i,1) = 0
enddo

!length: Total length of the plate
length = 0.1d0
!width: Total width of the plate
width = 0.01d0
!thick: Total thickness of the plate
thick = 0.01d0
!dx: Incremental distance
dx = length / ndivx
!delta: Horizon
delta = 3.015d0 * dx
!dens: Density
dens = 2700.0d0
!emod: Elastic modulus
emod = 75.0d9
!pratio: Poisson's ratio
pratio = 1.0d0 / 4.0d0
!smod: Shear modulus
smod = emod / (2.0d0 * (1.0d0 + pratio))
!alpha: Coefficient of thermal expansion
alpha = 23.0d-6
!dtemp: Temperature change
dtemp = 0.0d0
!area: Cross-sectional area
area = dx * dx
!vol: Volume of a material point
vol = area * dx
!bc: Bond constant 
bc = 12.0d0 * emod / (pi * (delta**4))
!sedload1: Strain energy density for the first loading
sedload1 = 0.0d0    
!sedload2: Strain energy density for the second loading
sedload2 = 0.0d0   
!sedload2: Strain energy density for the third loading
sedload3 = 0.0d0 
!dt: Time interval
dt = 0.8d0 * dsqrt(2.0d0*dens*dx/(4.0d0/3.0d0*pi*delta**3*bc))
!totime: Total time
totime = nt * dt
!ctime: Current time
ctime = 0.0d0
!idist: Initial distance
idist = 0.0d0
!fac: Volume correction factor
fac = 0.0d0
!radij: Material point radius
radij = dx / 2.0d0
!nnum: Material point number
nnum = 0
!cnode: Current material point
cnode = 0
!Length of deformed bond
nlength  = 0.0d0
!dforce1: x component of the PD force between two material points
dforce1 = 0.0d0
!dforce2: y component of the PD force between two material points
dforce2 = 0.0d0
!dforce3: z component of the PD force between two material points
dforce3 = 0.0d0
!cnt:boundary condition count
cnt = 0
!appres: Applied pressure
appres = 200.0d6
scr0 = 1000.0d0
dcont = 0.0d0
dfshtemp = 0.0d0 
dfshort = 0.0d0

!Initialization of fail flag array
!1 means no failure, 0 means failure of the PD bond
do i = 1,totnode
	do j = 1,maxfam
		fail(i,j) = 1
    enddo
enddo

!Specification of the locations of material points
!Material points of the bar
do i = 1,ndivx
    do j = 1,ndivy
        do k = 1,ndivz
            coordx = -1.0d0 / 2.0d0 * length + (dx / 2.0d0) + (i - 1) * dx
            coordy = -1.0d0 / 2.0d0 * width + (dx / 2.0d0) + (j - 1) * dx
            coordz = -1.0d0 / 2.0d0 * thick + (dx / 2.0d0) + (k - 1) * dx
            nnum = nnum + 1
            coord(nnum,1) = coordx
            coord(nnum,2) = coordy
            coord(nnum,3) = coordz
            if (coordx.lt.0.0d0) then
                mat(nnum,1) = 1
            else
                mat(nnum,1) = 2
            endif
        enddo        
    enddo
enddo



!Determination of material points inside the horizon of each material point
do i = 1,totnode
    if (i.eq.1) then 
        pointfam(i,1) = 1
    else
        pointfam(i,1) = pointfam(i-1,1) + numfam(i-1,1)
    endif
    do j = 1,totnode
        idist = dsqrt((coord(j,1) - coord(i,1))**2 + (coord(j,2) - coord(i,2))**2 + (coord(j,3) - coord(i,3))**2) 
        if (i.ne.j.and.mat(i,1).eq.mat(j,1)) then
            if(idist.le.delta) then
                numfam(i,1) = numfam(i,1) + 1
                nodefam(pointfam(i,1)+numfam(i,1)-1,1) = j
            endif
        endif
    enddo
enddo

!Determination of surface correction factors 
!Three different loading conditions are considered

!Loading 1

sedload1 = 0.6d0 * emod * 1.0d-6

do i = 1,totnode
	if (mat(i,1).eq.1) then
		disp(i,1) = 0.001d0 * (coord(i,1) + length / 4.0d0) 
	else
		disp(i,1) = 0.001d0 * (coord(i,1) - length / 4.0d0) 
	endif
	disp(i,2) = 0.0d0
	disp(i,3) = 0.0d0
enddo

do i = 1,totnode
    stendens(i,1) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif      
           
        stendens(i,1) = stendens(i,1) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac  
    enddo
    !Calculation of surface correction factor in x direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,1) = sedload1 / stendens(i,1)
enddo

!Loading 2

sedload2 = 0.6d0 * emod * 1.0d-6

do i = 1,totnode
    disp(i,1) = 0.0d0
    disp(i,2) = 0.001d0 * coord(i,2) 
    disp(i,3) = 0.0d0
enddo

do i = 1,totnode
    stendens(i,2) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif  
            
        stendens(i,2) = stendens(i,2) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in y direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,2) = sedload2 / stendens(i,2)
enddo

!Loading 3

sedload3 = 0.6d0 * emod * 1.0d-6

do i = 1,totnode
    disp(i,1) = 0.0d0
    disp(i,2) = 0.0d0
    disp(i,3) = 0.001d0 * coord(i,3) 
enddo

do i = 1,totnode
    stendens(i,3) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif
            
        stendens(i,3) = stendens(i,3) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in z direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,3) = sedload3 / stendens(i,3)
enddo
       
!Initialization of displacements and velocities
do i = 1,totnode
    if (mat(i,1).eq.1) then
        vel(i,1) = 10.0d0
    else
        vel(i,1) = -10.0d0
    endif
    disp(i,1) = 0.0d0
    vel(i,2) = 0.0d0
    disp(i,2) = 0.0d0 
    vel(i,3) = 0.0d0
    disp(i,3) = 0.0d0 
enddo

open(41,file='nodelefthist2p.txt')
open(42,file='noderighthist2p.txt')
open(43,file='centerline2p.txt')


!Time integration
do tt = 1,nt
    write(*,*) 'tt = ', tt

    do i = 1,totnode
        dmgpar1 = 0.0d0
        dmgpar2 = 0.0d0
        pforce(i,1) = 0.0d0
        pforce(i,2) = 0.0d0
        pforce(i,3) = 0.0d0
        do j = 1,numfam(i,1)            
                cnode = nodefam(pointfam(i,1)+j-1,1)
                idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
                nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
                
                !Volume correction
                if (idist.le.delta-radij) then
                    fac = 1.0d0
                elseif (idist.le.delta+radij) then
                    fac = (delta+radij-idist)/(2.0d0*radij)
                else
                    fac = 0.0d0
                endif
                 if (dabs(coord(cnode,3) - coord(i,3)) <= 1.0d-10) then
                    if (dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
						theta = 0.0d0
					elseif (dabs(coord(cnode,1) - coord(i,1)) <= 1.0d-10) then
						theta = 90.0d0 * pi / 180.0d0
					else
						theta = datan(dabs(coord(cnode,2) - coord(i,2)) / dabs(coord(cnode,1) - coord(i,1)))
					endif
					phi = 90.0d0 * pi / 180.0d0

					scx = (fncst(i,1) + fncst(cnode,1)) / 2.0d0
					scy = (fncst(i,2) + fncst(cnode,2)) / 2.0d0
					scz = (fncst(i,3) + fncst(cnode,3)) / 2.0d0
					scr = 1.0d0/(((dcos(theta)*dsin(phi))**2/(scx)**2)+((dsin(theta)*dsin(phi))**2/(scy)**2)+((dcos(phi))**2/(scz)**2))
					scr = dsqrt(scr)
				elseif (dabs(coord(cnode,1) - coord(i,1)) <= 1.0d-10.and.dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
					scz = (fncst(i,3) + fncst(cnode,3)) / 2.0d0
				    scr = scz
                else
                    theta = datan(dabs(coord(cnode,2) - coord(i,2)) / dabs(coord(cnode,1) - coord(i,1)))
					phi = dacos(dabs(coord(cnode,3) - coord(i,3)) / idist)

					scx = (fncst(i,1) + fncst(cnode,1)) / 2.0d0
					scy = (fncst(i,2) + fncst(cnode,2)) / 2.0d0
					scz = (fncst(i,3) + fncst(cnode,3)) / 2.0d0
					scr = 1.0d0/(((dcos(theta)*dsin(phi))**2/(scx)**2)+((dsin(theta)*dsin(phi))**2/(scy)**2)+((dcos(phi))**2/(scz)**2))
					scr = dsqrt(scr)
                endif                
                
                if (fail(i,j).eq.1) then              
                    !Calculation of the peridynamic forces in x, y and z 
                    !directions acting on material point i due to material point j
                    dforce1 = bc * ((nlength - idist) / idist - (alpha * dtemp)) * vol * scr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength 
                    dforce2 = bc * ((nlength - idist) / idist - (alpha * dtemp)) * vol * scr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength
                    dforce3 = bc * ((nlength - idist) / idist - (alpha * dtemp)) * vol * scr * fac * (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3)) / nlength
                else
                    dforce1 = 0.0d0
                    dforce2 = 0.0d0
                    dforce3 = 0.0d0
                endif
                    
                pforce(i,1) = pforce(i,1) + dforce1      
                pforce(i,2) = pforce(i,2) + dforce2  
                pforce(i,3) = pforce(i,3) + dforce3  

                !if (dabs((nlength - idist) / idist) > scr0) then
                !    fail(i,j) = 0 
                !endif 					 
                            
                dmgpar1 = dmgpar1 + fail(i,j) * vol * fac
                dmgpar2 = dmgpar2 + vol * fac 
        enddo
        dmg(i,1) = 1.0d0 - dmgpar1 / dmgpar2
    enddo
 
    !Determination of material points inside the horizon of each material point
    do i = 1,totnode
        pointfamnew(i,1) = 0
        numfamnew(i,1) = 0
    enddo
    do i = 1,totnode
        if (i.eq.1) then 
            pointfamnew(i,1) = 1
        else
            pointfamnew(i,1) = pointfamnew(i-1,1) + numfamnew(i-1,1)
        endif
        do j = 1,totnode
            nlength = dsqrt((coord(j,1) + disp(j,1) - coord(i,1) - disp(i,1))**2 + (coord(j,2) + disp(j,2) - coord(i,2) - disp(i,2))**2 + (coord(j,3) + disp(j,3) - coord(i,3) - disp(i,3))**2)
            if (i.ne.j.and.mat(i,1).ne.mat(j,1)) then
                if(nlength.le.delta) then
                    numfamnew(i,1) = numfamnew(i,1) + 1
                    nodefamnew(pointfamnew(i,1)+numfamnew(i,1)-1,1) = j
                endif
            endif
        enddo
    enddo 
    
    do i = 1,totnode
        do j = 1,numfamnew(i,1)            
                cnode = nodefamnew(pointfamnew(i,1)+j-1,1)
                idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
                nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
                dcont = min(1.35d0*dx,0.9d0*idist)
                
                !Calculation of the peridynamic forces in x, y and z 
                !directions acting on material point i due to material point j
                dfshtemp = 5.0d0 * bc / dx * (nlength - dx)              
                dfshort = min(0.0d0,dfshtemp)
                dforce1 = dfshort * vol * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength 
                dforce2 = dfshort * vol * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength
                dforce3 = dfshort * vol * (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3)) / nlength
                
                pforce(i,1) = pforce(i,1) + dforce1      
                pforce(i,2) = pforce(i,2) + dforce2  
                pforce(i,3) = pforce(i,3) + dforce3  
        enddo
    enddo
    
    do i = 1,totnode
        !Calculation of acceleration of material point i
        acc(i,1) = (pforce(i,1) + bforce(i,1)) / dens
        acc(i,2) = (pforce(i,2) + bforce(i,2)) / dens 
        acc(i,3) = (pforce(i,3) + bforce(i,3)) / dens
        !Calculation of velocity of material point i
        !by integrating the acceleration of material point i
        vel(i,1) = vel(i,1) + acc(i,1) * dt
        vel(i,2) = vel(i,2) + acc(i,2) * dt
        vel(i,3) = vel(i,3) + acc(i,3) * dt
        !Calculation of displacement of material point i
        !by integrating the velocity of material point i
        disp(i,1) = disp(i,1) + vel(i,1) * dt
        disp(i,2) = disp(i,2) + vel(i,2) * dt
        disp(i,3) = disp(i,3) + vel(i,3) * dt        
    enddo

	ctime = tt * dt
    
    write(41,888) ctime, coord(2456,1), coord(2456,2), coord(2456,3), disp(2456,1), disp(2456,2), disp(2456,3), vel(2456,1), vel(2456,2), vel(2456,3) 
    write(42,888) ctime, coord(7556,1), coord(7556,2), coord(7556,3), disp(7556,1), disp(7556,2), disp(7556,3), vel(7556,1), vel(7556,2), vel(7556,3) 
    
	if (tt.eq.nt) then
		open(26,file = 'cxci2p.m')
		open(27,file = 'cyci2p.m')
		open(28,file = 'czci2p.m')
		open(29,file = 'uxci2p.m')
		open(30,file = 'uyci2p.m')
		open(31,file = 'uzci2p.m')
		open(32,file = 'vxci2p.m')
		open(33,file = 'vyci2p.m')
		open(34,file = 'vzci2p.m')
		open(35,file = 'dmgci2p.m')

		do i = 1, totnode
			if (i.eq.1) then
                write(26,222) coord(i,1)
                write(27,223) coord(i,2)
                write(28,224) coord(i,3)
                write(29,333) disp(i,1)
                write(30,334) disp(i,2)
                write(31,335) disp(i,3)
                write(32,444) vel(i,1)
                write(33,445) vel(i,2)
                write(34,446) vel(i,3)
                write(35,666) dmg(i,1)                  
            elseif (i.eq.totnode) then
                write(26,777) coord(i,1)
                write(27,777) coord(i,2)
                write(28,777) coord(i,3)
                write(29,777) disp(i,1)
                write(30,777) disp(i,2)
                write(31,777) disp(i,3)
                write(32,777) vel(i,1)
                write(33,777) vel(i,2)
                write(34,777) vel(i,3)
                write(35,777) dmg(i,1)           
            else
                write(26,111) coord(i,1)
                write(27,111) coord(i,2)
                write(28,111) coord(i,3)
                write(29,111) disp(i,1)
                write(30,111) disp(i,2)
                write(31,111) disp(i,3)
                write(32,111) vel(i,1)
                write(33,111) vel(i,2)
                write(34,111) vel(i,3)
                write(35,111) dmg(i,1)
            endif
            
            if ((dabs(coord(i,2)-dx/2.0d0).le.1.0d-8).and.(dabs(coord(i,3)-dx/2.0d0).le.1.0d-8)) then
                write(43,999) coord(i,1), coord(i,2), coord(i,3), disp(i,1), disp(i,2), disp(i,3), vel(i,1), vel(i,2), vel(i,3)    
            endif
            
        enddo
    endif
enddo


111 format(e12.5,3x,';')
222 format('xcoord=[',3x,e12.5,3x,';')
223 format('ycoord=[',3x,e12.5,3x,';')
224 format('zcoord=[',3x,e12.5,3x,';')
333 format('dispx=[',3x,e12.5,3x,';')
334 format('dispy=[',3x,e12.5,3x,';')
335 format('dispz=[',3x,e12.5,3x,';')
444 format('velx=[',3x,e12.5,3x,';')
445 format('vely=[',3x,e12.5,3x,';')
446 format('velz=[',3x,e12.5,3x,';')
666 format('dmg=[',3x,e12.5,3x,';')
777 format(e12.5,3x,'];')    
888 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5)    
999 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5) 


close(26)
close(27)
close(28)
close(29)
close(30)
close(31)
close(32)
close(33)
close(34)
close(35)

close(41)
close(42)
close(43)
    
end program main