program main

implicit none

integer ndivx, ndivy, ndivz, ntotnode, nt, maxfam, nnum, cnode, i, j, k, tt, nbnd
parameter(ndivx = 200)
parameter(ndivy = 100)
parameter(ndivz = 1)
parameter(nbnd = 0)
parameter (ntotnode = ndivx * ndivy * ndivz) 
parameter(nt = 2000)
parameter(maxfam = 100)

real *8 length, width, thick, dx, delta, dens, emod, pratio, area, vol, bc, radius
real *8 sedload1, sedload2, sedload3, dt, totime, ctime, idist, fac, radij, nlength, dforce1, dforce2, dforce3 
real *8 pi, tmpdx, tmpvol, tmpcx, tmpux, tmpcy, tmpuy, tmpcz, tmpuz, dmgpar1, dmgpar2, theta, phi 
real *8 scr, scx, scy, scz, coordx, coordy, coordz, cn, cn1, cn2, appres, alpha, dtemp, scr0
real *8 dcont, dfshtemp, dfshort, crad
integer cnt, totnode
!penetrator parameters
real *8 pendiam, penrad, penvx, penvy, penvz, penccx, penccy, penccz, penicx, penicy, penicz
real *8 penax, penay, penaz, penalx, penaly, penalz, penux, penuy, penuz, penwx, penwy, penwz, pentx, penty, pentz
real *8 pentfx, pentfy, pentfz, pentmx, pentmy, pentmz, newpx, newpy, newpz, dpenx, dpeny, dpenz, dpend
real *8 dpux, dpuy, dpuz, dprx, dpry, dprz, dpcx, dpcy, dpcz, olddispx, olddispy, olddispz, oldvelx, oldvely, oldvelz
real *8 dpenfx, dpenfy, dpenfz, dpenmx, dpenmy, dpenmz, penmass


real *8 coord(ntotnode,3), pforce(ntotnode,3), pforceold(ntotnode,3), bforce(ntotnode,3), stendens(ntotnode,3), dmg(ntotnode,1)
real *8 fncst(ntotnode,3), fncstold(ntotnode,3), disp(ntotnode,3), vel(ntotnode,3), velhalfold(ntotnode,3), velhalf(ntotnode,3), andisp(ntotnode,3)
real *8 acc(ntotnode,3), massvec(ntotnode,3), olddisp(ntotnode,3), oldvel(ntotnode,3)
integer numfam(ntotnode,1), pointfam(ntotnode,1), nodefam(80000000,1), alflag(ntotnode,1), mat(ntotnode,1), fail(ntotnode,maxfam)
integer numfamnew(ntotnode,1), pointfamnew(ntotnode,1), nodefamnew(80000000,1)

pi = dacos(-1.0d0)

!coord: Material point locations
do i = 1, ntotnode 
	coord(i,1) = 0.0d0
	coord(i,2) = 0.0d0
	coord(i,3) = 0.0d0
	numfam(i,1) = 0
    numfamnew(i,1) = 0
	pointfam(i,1) = 0
    pointfamnew(i,1) = 0
	pforce(i,1) = 0.0d0
	pforce(i,2) = 0.0d0
	pforce(i,3) = 0.0d0
	pforceold(i,1) = 0.0d0
	pforceold(i,2) = 0.0d0
	pforceold(i,3) = 0.0d0
	bforce(i,1) = 0.0d0
	bforce(i,2) = 0.0d0
	bforce(i,3) = 0.0d0
	stendens(i,1) = 0.0d0
	stendens(i,2) = 0.0d0
	stendens(i,3) = 0.0d0
	fncst(i,1) = 1.0d0
	fncstold(i,1) = 1.0d0  
	fncst(i,2) = 1.0d0
	fncstold(i,2) = 1.0d0 
	fncst(i,3) = 1.0d0
	fncstold(i,3) = 1.0d0 
	disp(i,1) = 0.0d0
	disp(i,2) = 0.0d0
	disp(i,3) = 0.0d0
	olddisp(i,1) = 0.0d0
	olddisp(i,2) = 0.0d0
	olddisp(i,3) = 0.0d0
	vel(i,1) = 0.0d0
	vel(i,2) = 0.0d0
	vel(i,3) = 0.0d0
	oldvel(i,1) = 0.0d0
	oldvel(i,2) = 0.0d0
	oldvel(i,3) = 0.0d0
	velhalfold(i,1) = 0.0d0
	velhalfold(i,2) = 0.0d0
	velhalfold(i,3) = 0.0d0
	velhalf(i,1) = 0.0d0
	velhalf(i,2) = 0.0d0
	velhalf(i,3) = 0.0d0
	acc(i,1) = 0.0d0
	acc(i,2) = 0.0d0
	acc(i,3) = 0.0d0
	massvec(i,1) = 0.0d0
	massvec(i,2) = 0.0d0
	massvec(i,3) = 0.0d0
    andisp(i,1) = 0.0d0
    andisp(i,2) = 0.0d0
    andisp(i,3) = 0.0d0
    alflag(i,1) = 0
    mat(i,1) = 0
	do j = 1, maxfam
		fail(i,j) = 0
    enddo
    dmg(i,1) = 0.0d0
enddo

do i = 1, 1000000
	nodefam(i,1) = 0
    nodefamnew(i,1) = 0
enddo

!length: Total length of the plate
length = 0.2d0
!width: Total width of the plate
width = 0.1d0
!thick: Total thickness of the plate
thick = 0.009d0
!dx: Incremental distance
dx = length / ndivx
!delta: Horizon
delta = 3.015d0 * dx
!dens: Density
dens = 8000.0d0
!emod: Elastic modulus
emod = 191.0d9
!pratio: Poisson's ratio
pratio = 1.0d0 / 3.0d0
!dtemp: Temperature change
dtemp = 0.0d0
!area: Cross-sectional area
area = dx * dx
!vol: Volume of a material point
vol = area * thick
!bc: Bond constant 
bc = 9.0d0 * emod / (pi * thick * (delta**3))
!sedload1: Strain energy density for the first loading
sedload1 = 0.0d0    
!sedload2: Strain energy density for the second loading
sedload2 = 0.0d0   
!sedload2: Strain energy density for the third loading
sedload3 = 0.0d0 
!dt: Time interval
dt = 1.0d-7
!totime: Total time
totime = nt * dt
!ctime: Current time
ctime = 0.0d0
!idist: Initial distance
idist = 0.0d0
!fac: Volume correction factor
fac = 0.0d0
!radij: Material point radius
radij = dx / 2.0d0
!nnum: Material point number
nnum = 0
!cnode: Current material point
cnode = 0
!Length of deformed bond
nlength  = 0.0d0
!dforce1: x component of the PD force between two material points
dforce1 = 0.0d0
!dforce2: y component of the PD force between two material points
dforce2 = 0.0d0
!dforce3: z component of the PD force between two material points
dforce3 = 0.0d0
!cnt:boundary condition count
cnt = 0
scr0 = 1.0d0
dcont = 0.0d0
dfshtemp = 0.0d0 
dfshort = 0.0d0
crad = 0.0d0

pendiam = 0.05d0 
penrad = pendiam / 2.0d0
penmass = 1.57d0
penvx = 0.0d0 
penvy = -32.0d0 
penvz = 0.0d0 
penccx = 0.0d0 
penccy = 0.0d0 
penccz = 0.0d0
penicx = 0.0d0 
penicy = width / 2.0d0 + penrad - 0.999d0 * dx / 2.0d0  
penicz = 0.0d0
penax = 0.0d0 
penay = 0.0d0 
penaz = 0.0d0 
penalx = 0.0d0 
penaly = 0.0d0 
penalz = 0.0d0 
penux = 0.0d0 
penuy = 0.0d0 
penuz = 0.0d0 
penwx = 0.0d0 
penwy = 0.0d0 
penwz = 0.0d0 
pentx = 0.0d0 
penty = 0.0d0 
pentz = 0.0d0
pentfx = 0.0d0
pentfy = 0.0d0 
pentfz = 0.0d0 
pentmx = 0.0d0 
pentmy = 0.0d0 
pentmz = 0.0d0 
newpx = 0.0d0 
newpy = 0.0d0 
newpz = 0.0d0 
dpenx = 0.0d0 
dpeny = 0.0d0 
dpenz = 0.0d0 
dpend = 0.0d0
dpux = 0.0d0 
dpuy = 0.0d0 
dpuz = 0.0d0 
dprx = 0.0d0 
dpry = 0.0d0 
dprz = 0.0d0 
dpcx = 0.0d0 
dpcy = 0.0d0 
dpcz = 0.0d0 
olddispx = 0.0d0 
olddispy = 0.0d0 
olddispz = 0.0d0 
oldvelx = 0.0d0 
oldvely = 0.0d0 
oldvelz = 0.0d0
dpenfx = 0.0d0 
dpenfy = 0.0d0 
dpenfz = 0.0d0 
dpenmx = 0.0d0 
dpenmy = 0.0d0 
dpenmz = 0.0d0 

!Initialization of fail flag array
!1 means no failure, 0 means failure of the PD bond
do i = 1,ntotnode
	do j = 1,maxfam
		fail(i,j) = 1
    enddo
enddo

!Specification of the locations of material points
!Material points of the bar
do i = 1,ndivx
    do j = 1,ndivy
            nnum = nnum + 1
            coordx = -1.0d0 / 2.0d0 * length + (dx / 2.0d0) + (i - 1) * dx
            coordy = -1.0d0 / 2.0d0 * width + (dx / 2.0d0) + (j - 1) * dx
            coordz = 0.0d0
            coord(nnum,1) = coordx
            coord(nnum,2) = coordy
            coord(nnum,3) = coordz
    enddo
enddo

totnode = nnum

!Determination of material points inside the horizon of each material point
do i = 1,totnode
    if (i.eq.1) then 
        pointfam(i,1) = 1
    else
        pointfam(i,1) = pointfam(i-1,1) + numfam(i-1,1)
    endif
    do j = 1,totnode
        idist = dsqrt((coord(j,1) - coord(i,1))**2 + (coord(j,2) - coord(i,2))**2 + (coord(j,3) - coord(i,3))**2) 
        if (i.ne.j) then
            if(idist.le.delta) then
                numfam(i,1) = numfam(i,1) + 1
                nodefam(pointfam(i,1)+numfam(i,1)-1,1) = j
            endif
        endif
    enddo
enddo

!Determination of surface correction factors 
!Two different loading conditions are considered

!Loading 1

sedload1 = 9.0d0 / 16.0d0 * emod * 1.0d-6

do i = 1,totnode
    disp(i,1) = 0.001d0 * coord(i,1) 
    disp(i,2) = 0.0d0
    disp(i,3) = 0.0d0
enddo

do i = 1,totnode
    stendens(i,1) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif     
            
        stendens(i,1) = stendens(i,1) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in x direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,1) = sedload1 / stendens(i,1)
enddo
    
!Loading 2

sedload2 = 9.0d0 / 16.0d0 * emod * 1.0d-6

do i = 1,totnode
    disp(i,1) = 0.0d0
    disp(i,2) = 0.001d0 * coord(i,2)
    disp(i,3) = 0.0d0
enddo

do i = 1,totnode
    stendens(i,2) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif
            
        stendens(i,2) = stendens(i,2) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in y direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,2) = sedload2 / stendens(i,2)
enddo
       
!Initialization of displacements and velocities
do i = 1,totnode
    vel(i,1) = 0.0d0
    disp(i,1) = 0.0d0
    vel(i,2) = 0.0d0
    disp(i,2) = 0.0d0 
    vel(i,3) = 0.0d0
    disp(i,3) = 0.0d0 
enddo

open(41,file='centralxri.txt')
open(42,file='centralyri.txt')
open(43,file='centernoderi.txt')

!Time integration
do tt = 1,nt
    write(*,*) 'tt = ', tt

    do i = 1,totnode
        dmgpar1 = 0.0d0
        dmgpar2 = 0.0d0
        pforce(i,1) = 0.0d0
        pforce(i,2) = 0.0d0
        pforce(i,3) = 0.0d0
        do j = 1,numfam(i,1)            
                cnode = nodefam(pointfam(i,1)+j-1,1)
                idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2 + (coord(cnode,3) - coord(i,3))**2)
                nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2 + (coord(cnode,3) + disp(cnode,3) - coord(i,3) - disp(i,3))**2)
                
                !Volume correction
                if (idist.le.delta-radij) then
                    fac = 1.0d0
                elseif (idist.le.delta+radij) then
                    fac = (delta+radij-idist)/(2.0d0*radij)
                else
                    fac = 0.0d0
                endif

                if (dabs(coord(cnode,2) - coord(i,2)).le.1.0d-10) then
                    theta = 0.0d0
                elseif (dabs(coord(cnode,1) - coord(i,1)).le.1.0d-10) then
                    theta = 90.0d0 * pi / 180.0d0
                else
                    theta = datan(dabs(coord(cnode,2) - coord(i,2)) / dabs(coord(cnode,1) - coord(i,1)))
                endif
                scx = (fncst(i,1) + fncst(cnode,1)) / 2.0d0
                scy = (fncst(i,2) + fncst(cnode,2)) / 2.0d0
                !Compute the surface correction factor of the bond
                scr = 1.0d0 / (((dcos(theta))**2.0d0 / (scx)**2.0d0) + ((dsin(theta))**2.0d0 / (scy)**2.0d0))
                scr = dsqrt(scr)
                
                if (fail(i,j).eq.1) then              
                    !Calculation of the peridynamic forces in x, y and z 
                    !directions acting on material point i due to material point j
                    dforce1 = bc * ((nlength - idist) / idist) * vol * scr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength 
                    dforce2 = bc * ((nlength - idist) / idist) * vol * scr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength
                    dforce3 = 0.0d0
                else
                    dforce1 = 0.0d0
                    dforce2 = 0.0d0
                    dforce3 = 0.0d0
                endif
                    
                pforce(i,1) = pforce(i,1) + dforce1      
                pforce(i,2) = pforce(i,2) + dforce2  
                pforce(i,3) = pforce(i,3) + dforce3  

                !if (dabs((nlength - idist) / idist) > scr0) then
                !    fail(i,j) = 0 
                !endif 					 
                            
                dmgpar1 = dmgpar1 + fail(i,j) * vol * fac
                dmgpar2 = dmgpar2 + vol * fac 
        enddo
        dmg(i,1) = 1.0d0 - dmgpar1 / dmgpar2
    enddo
    
    do i = 1,totnode
        !Calculation of acceleration of material point i
        acc(i,1) = (pforce(i,1) + bforce(i,1)) / dens
        acc(i,2) = (pforce(i,2) + bforce(i,2)) / dens 
        acc(i,3) = 0.0d0
        !Calculation of velocity of material point i
        !by integrating the acceleration of material point i
        oldvel(i,1) = vel(i,1)
        oldvel(i,2) = vel(i,2)
        oldvel(i,3) = 0.0d0
        vel(i,1) = vel(i,1) + acc(i,1) * dt
        vel(i,2) = vel(i,2) + acc(i,2) * dt
        vel(i,3) = 0.0d0
        !Calculation of displacement of material point i
        !by integrating the velocity of material point i
        olddisp(i,1) = disp(i,1)
        olddisp(i,2) = disp(i,2)
        olddisp(i,3) = 0.0d0
        disp(i,1) = disp(i,1) + vel(i,1) * dt
        disp(i,2) = disp(i,2) + vel(i,2) * dt
        disp(i,3) = 0.0d0
    enddo
    
    !penetrator contact - start
    !real *8 pendiam, penrad, penvx, penvy, penvz, penccx, penccy, penccz, penicx, penicy, penicz
    !real *8 penax, penay, penaz, penalx, penaly, penalz, penux, penuy, penuz, penwx, penwy, penwz, pentx, penty, pentz 

    pentfx = 0.0d0
    pentfy = 0.0d0
    pentfz = 0.0d0
    pentmx = 0.0d0
    pentmy = 0.0d0
    pentmz = 0.0d0    
    
    ctime = tt * dt
    
    penccx = penicx + penux
    penccy = penicy + penuy
    penccz = 0.0d0
    
    write(*,*) ctime, penccx, penccy, penccz

    do i = 1,totnode
        newpx = coord(i,1) + disp(i,1)
        newpy = coord(i,2) + disp(i,2)
        newpz = 0.0d0
        dpenx = newpx - penccx
        dpeny = newpy - penccy
        dpenz = 0.0d0
        dpend = dsqrt(dpenx * dpenx + dpeny * dpeny + dpenz * dpenz)
        
        if (dpend.lt.penrad) then
            dpux = dpenx / dpend
            dpuy = dpeny / dpend
            dpuz = dpenz / dpend
            dprx = dpux * penrad
            dpry = dpuy * penrad
            dprz = dpuz * penrad            
            dpcx = penccx + dprx 
            dpcy = penccy + dpry 
            dpcz = 0.0d0 
            olddispx = disp(i,1)
            olddispy = disp(i,2)
            olddispz = 0.0d0
            oldvelx = vel(i,1)
            oldvely = vel(i,2)
            oldvelz = 0.0d0
            disp(i,1) = dpcx - coord(i,1)
            disp(i,2) = dpcy - coord(i,2)
            disp(i,3) = 0.0d0
            vel(i,1) = (disp(i,1) - olddisp(i,1)) / dt
            vel(i,2) = (disp(i,2) - olddisp(i,2)) / dt
            vel(i,3) = 0.0d0
            dpenfx = -1.0d0 * dens * (vel(i,1) - oldvelx) / dt * vol
            dpenfy = -1.0d0 * dens * (vel(i,2) - oldvely) / dt * vol
            dpenfz = 0.0d0
            dpenmx = dpry * dpenfz - dprz * dpenfy
            dpenmy = dprz * dpenfx - dprx * dpenfz
            dpenmz = dprx * dpenfy - dpry * dpenfx
            pentfx = pentfx + dpenfx
            pentfy = pentfy + dpenfy
            pentfz = 0.0d0
            pentmx = 0.0d0
            pentmy = 0.0d0
            pentmz = pentmz + dpenmz            
        endif
        
    enddo
    
    penax = pentfx / penmass
    penay = pentfy / penmass
    penaz = 0.0d0
    
    penvx = penvx + penax * dt
    penvy = penvy + penay * dt
    penvz = 0.0d0

    penux = penux + penvx * dt
    penuy = penuy + penvy * dt
    penuz = 0.0d0
    
    write(*,999) tt, pentfx, pentfy, pentfz 
    
    !penetrator contact - end

	ctime = tt * dt
    
    write(43,888) ctime, coord(10051,1), coord(10051,2), coord(10051,3), disp(10051,1), disp(10051,2), disp(10051,3), vel(10051,1), vel(10051,2), vel(10051,3) 
    
	if (tt.eq.nt) then
		open(26,file = 'cxcnf.m')
		open(27,file = 'cycnf.m')
		open(28,file = 'czcnf.m')
		open(29,file = 'uxcnf.m')
		open(30,file = 'uycnf.m')
		open(31,file = 'uzcnf.m')
		open(32,file = 'vxcnf.m')
		open(33,file = 'vycnf.m')
		open(34,file = 'vzcnf.m')
		open(35,file = 'dmgcnf.m')

		do i = 1, totnode
			if (i.eq.1) then
                write(26,222) coord(i,1)
                write(27,223) coord(i,2)
                write(28,224) coord(i,3)
                write(29,333) disp(i,1)
                write(30,334) disp(i,2)
                write(31,335) disp(i,3)
                write(32,444) vel(i,1)
                write(33,445) vel(i,2)
                write(34,446) vel(i,3)
                write(35,666) dmg(i,1)                  
            elseif (i.eq.totnode) then
                write(26,777) coord(i,1)
                write(27,777) coord(i,2)
                write(28,777) coord(i,3)
                write(29,777) disp(i,1)
                write(30,777) disp(i,2)
                write(31,777) disp(i,3)
                write(32,777) vel(i,1)
                write(33,777) vel(i,2)
                write(34,777) vel(i,3)
                write(35,777) dmg(i,1)           
            else
                write(26,111) coord(i,1)
                write(27,111) coord(i,2)
                write(28,111) coord(i,3)
                write(29,111) disp(i,1)
                write(30,111) disp(i,2)
                write(31,111) disp(i,3)
                write(32,111) vel(i,1)
                write(33,111) vel(i,2)
                write(34,111) vel(i,3)
                write(35,111) dmg(i,1)
            endif
            
            if ((dabs(coord(i,2)-dx/2.0d0).le.1.0d-8)) then
                write(41,889) coord(i,1), coord(i,2), coord(i,3), disp(i,1), disp(i,2), disp(i,3), vel(i,1), vel(i,2), vel(i,3)    
            endif

            if ((dabs(coord(i,1)-dx/2.0d0).le.1.0d-8)) then
                write(42,889) coord(i,1), coord(i,2), coord(i,3), disp(i,1), disp(i,2), disp(i,3), vel(i,1), vel(i,2), vel(i,3)    
            endif
            
		enddo
    endif
enddo


111 format(e12.5,3x,';')
222 format('xcoord=[',3x,e12.5,3x,';')
223 format('ycoord=[',3x,e12.5,3x,';')
224 format('zcoord=[',3x,e12.5,3x,';')
333 format('dispx=[',3x,e12.5,3x,';')
334 format('dispy=[',3x,e12.5,3x,';')
335 format('dispz=[',3x,e12.5,3x,';')
444 format('velx=[',3x,e12.5,3x,';')
445 format('vely=[',3x,e12.5,3x,';')
446 format('velz=[',3x,e12.5,3x,';')
666 format('dmg=[',3x,e12.5,3x,';')
777 format(e12.5,3x,'];')    
888 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5)    
889 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5) 
999 format(i8,3x,e12.5,3x,e12.5,3x,e12.5)
    
close(26)
close(27)
close(28)
close(29)
close(30)
close(31)
close(32)
close(33)
close(34)
close(35)

close(41)
close(42)
close(43)
    
end program main