program main

implicit none

integer ndivx, ndivy, totnode, nt, maxfam, nnum, cnode, i, j, tt, nbnd
!ndivx: Number of divisions in x direction - except boundary region
parameter(ndivx = 100)
!ndivy: Number of divisions in y direction - except boundary region
parameter(ndivy = 50)
!nbnd: Number of divisions in the boundary region
parameter(nbnd = 0)
!totnode: Total number of material points
parameter (totnode = ndivx * ndivy) 
!nt: Total number of time step
parameter(nt = 4000)
!maxfam: Maximum number of material points inside a horizon of a material point
parameter(maxfam = 100)

real *8 length, width, thick, dx, delta, dens, emod, pratio, area, vol, bc 
real *8 sedload1, sedload2, dt, totime, ctime, idist, fac, radij, nlength, dforce1, dforce2 
real *8 pi, tmpdx, tmpvol, tmpcx, tmpux, tmpcy, tmpuy, dmgpar1, dmgpar2, theta 
real *8 scr, scx, scy, coordx, coordy, cn, cn1, cn2, appres, alpha, dtemp

real *8 coord(totnode,2), pforce(totnode,2), pforceold(totnode,2), bforce(totnode,2), stendens(totnode,2)
real *8 fncst(totnode,2), fncstold(totnode,2), disp(totnode,2), vel(totnode,2), velhalfold(totnode,2), velhalf(totnode,2), andisp(totnode,2)
real *8 acc(totnode,2), massvec(totnode,2)
integer numfam(totnode,1), pointfam(totnode,1), nodefam(10000000,1)

pi = dacos(-1.0d0)

!coord: Material point locations
do i = 1, totnode 
    !coord: Material point locations, 1:x-coord, 2:y-coord
	coord(i,1) = 0.0d0
	coord(i,2) = 0.0d0
    !numfam: Number of family members of each material point
	numfam(i,1) = 0
    !pointfam: index array to find the family members in nodefam array
	pointfam(i,1) = 0
    !pforce: total peridynamic force acting on a material point, 1:x-coord, 2:y-coord
	pforce(i,1) = 0.0d0
	pforce(i,2) = 0.0d0
    !pforceold: total peridynamic force acting on a material point in the previous time step
    !1:x-coord, 2:y-coord
	pforceold(i,1) = 0.0d0
	pforceold(i,2) = 0.0d0
    !bforce: body load acting on a material point, 1:x-coord, 2:y-coord
	bforce(i,1) = 0.0d0
	bforce(i,2) = 0.0d0
    !stendens: strain energy of a material point, 1:loading 1, 2:loading 2
	stendens(i,1) = 0.0d0
	stendens(i,2) = 0.0d0
    !fncst: surface correction factors of a material point, 1:loading 1, 2:loading 2
	fncst(i,1) = 1.0d0
	fncstold(i,1) = 1.0d0  
	fncst(i,2) = 1.0d0
	fncstold(i,2) = 1.0d0  
    !disp: displacement of a material point, 1:x-coord, 2:y-coord 
	disp(i,1) = 0.0d0
	disp(i,2) = 0.0d0
    !vel: velocity of a material point, 1:x-coord, 2:y-coord
	vel(i,1) = 0.0d0
	vel(i,2) = 0.0d0
	velhalfold(i,1) = 0.0d0
	velhalfold(i,2) = 0.0d0
	velhalf(i,1) = 0.0d0
	velhalf(i,2) = 0.0d0
    !acc: acceleration of a material point, 1:x-coord, 2:y-coord 
	acc(i,1) = 0.0d0
	acc(i,2) = 0.0d0
    !massvec: massvector for adaptive dynamic relaxation, 1:x-coord, 2:y-coord
	massvec(i,1) = 0.0d0
	massvec(i,2) = 0.0d0
    !andisp: analytical displacements for results, 1:x-coord, 2:y-coord
    andisp(i,1) = 0.0d0
    andisp(i,2) = 0.0d0
enddo

do i = 1, 1000000
    !nodefam: array containing family members of all material points
	nodefam(i,1) = 0
enddo

!length: Total length of the plate
length = 1.0d0
!width: Total width of the plate
width = 0.5d0
!dx: Spacing between material points
dx = length / ndivx
!thick: Total thickness of the plate
thick = dx
!delta: Horizon
delta = 3.015d0 * dx
!dens: Density
dens = 7850.0d0
!emod: Elastic modulus
emod = 200.0d9
!pratio: Poisson's ratio
pratio = 1.0d0 / 3.0d0
!alpha: Coefficient of thermal expansion
alpha = 23.0d-6
!dtemp: Temperature change
dtemp = 50.0d0
!area: Cross-sectional area
area = dx * dx
!vol: Volume of a material point
vol = area * dx
!bc: Bond constant 
bc = 9.0d0 * emod / (pi * thick * (delta**3))
!sedload1: Strain energy density for the first loading
sedload1 = 9.0d0 / 16.0d0 * emod * 1.0d-6   
!sedload2: Strain energy density for the second loading
sedload2 = 9.0d0 / 16.0d0 * emod * 1.0d-6 
!dt: Time interval
dt = 1.0d0
!totime: Total time
totime = nt * dt
!ctime: Current time
ctime = 0.0d0
!idist: Initial distance
idist = 0.0d0
!fac: Volume correction factor
fac = 0.0d0
!radij: Material point radius
radij = dx / 2.0d0
!nnum: Material point number
nnum = 0
!cnode: Current material point
cnode = 0
!Length of deformed bond
nlength  = 0.0d0
!dforce1: x component of the PD force between two material points
dforce1 = 0.0d0
!dforce2: y component of the PD force between two material points
dforce2 = 0.0d0
!appres: Applied pressure
appres = 200.0d6

!Specification of the locations of material points
!Material points of the bar
do i = 1,ndivx
    do j = 1,ndivy
        coordx = -1.0d0 /2.0d0 * length + (dx / 2.0d0) + (i - 1) * dx
        coordy = -1.0d0 /2.0d0 * width + (dx / 2.0d0) + (j - 1) * dx
        nnum = nnum + 1
        coord(nnum,1) = coordx
        coord(nnum,2) = coordy
    enddo
enddo

!Determination of material points inside the horizon of each material point
do i = 1,totnode
    if (i.eq.1) then 
        pointfam(i,1) = 1
    else
        pointfam(i,1) = pointfam(i-1,1) + numfam(i-1,1)
    endif
    do j = 1,totnode
        idist = dsqrt((coord(j,1) - coord(i,1))**2 + (coord(j,2) - coord(i,2))**2)
        if (i.ne.j) then
            if(idist.le.delta) then
                numfam(i,1) = numfam(i,1) + 1
                nodefam(pointfam(i,1)+numfam(i,1)-1,1) = j
            endif
        endif
    enddo
enddo

!Determination of surface correction factors 
!Loading 1
do i = 1,totnode
    disp(i,1) = 0.001d0 * coord(i,1)
    disp(i,2) = 0.0d0
enddo

do i = 1,totnode
    stendens(i,1) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif    
           
        stendens(i,1) = stendens(i,1) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in x direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,1) = sedload1 / stendens(i,1)
enddo
    
!Loading 2
do i = 1,totnode
    disp(i,1) = 0.0d0
    disp(i,2) = 0.001d0 * coord(i,2)
enddo

do i = 1,totnode
    stendens(i,2) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
        if (idist.le.delta-radij) then
            fac = 1.0d0
        elseif (idist.le.delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif
                       
        stendens(i,2) = stendens(i,2) + 0.5d0 * 0.5d0 * bc * ((nlength - idist) / idist)**2 * idist * vol * fac 
    enddo
    !Calculation of surface correction factor in y direction 
    !by finding the ratio of the analytical strain energy density value
    !to the strain energy density value obtained from PD Theory
    fncst(i,2) = sedload2 / stendens(i,2)
enddo
       
!Initialization of displacements and velocities
do i = 1,totnode
    vel(i,1) = 0.0d0
    disp(i,1) = 0.0d0 
    vel(i,2) = 0.0d0
    disp(i,2) = 0.0d0 
enddo

!Stable mass vector computation
do i = 1,totnode
   !5 is a safety factor
   massvec(i,1) = 0.25d0 * dt * dt * (pi * (delta)**2 * thick) * bc / dx * 5.0d0
   massvec(i,2) = 0.25d0 * dt * dt * (pi * (delta)**2 * thick) * bc / dx * 5.0d0
enddo

!Time integration
do tt = 1,nt
    write(*,*) 'tt = ', tt

    do i = 1,totnode
        pforce(i,1) = 0.0d0
        pforce(i,2) = 0.0d0
        do j = 1,numfam(i,1)            
                cnode = nodefam(pointfam(i,1)+j-1,1)
                idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
                nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
                
                !Volume correction
                if (idist.le.delta-radij) then
                    fac = 1.0d0
                elseif (idist.le.delta+radij) then
                    fac = (delta+radij-idist)/(2.0d0*radij)
                else
                    fac = 0.0d0
                endif

                if (dabs(coord(cnode,2) - coord(i,2)).le.1.0d-10) then
                    theta = 0.0d0
                elseif (dabs(coord(cnode,1) - coord(i,1)).le.1.0d-10) then
                    theta = 90.0d0 * pi / 180.0d0
                else
                    theta = datan(dabs(coord(cnode,2) - coord(i,2)) / dabs(coord(cnode,1) - coord(i,1)))
                endif

                !Determination of the surface correction between two material points
                scx = (fncst(i,1) + fncst(cnode,1)) / 2.0d0
                scy = (fncst(i,2) + fncst(cnode,2)) / 2.0d0
                scr = 1.0d0 / (((dcos(theta))**2.0d0 / (scx)**2.0d0) + ((dsin(theta))**2.0d0 / (scy)**2.0d0))
                scr = dsqrt(scr)
               
                !Calculation of the peridynamic force in x and y directions 
                !acting on a material point i due to a material point j
                dforce1 = bc * ((nlength - idist) / idist - (alpha * dtemp)) * vol * scr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength 
                dforce2 = bc * ((nlength - idist) / idist - (alpha * dtemp)) * vol * scr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength
                
                pforce(i,1) = pforce(i,1) + dforce1      
                pforce(i,2) = pforce(i,2) + dforce2  
        enddo
    enddo
    
    !Adaptive dynamic relaxation
    cn = 0.0d0
	cn1 = 0.0d0
	cn2 = 0.0d0
	do i = 1,totnode
        if (velhalfold(i,1).ne.0.0d0) then
            cn1 = cn1 - disp(i,1) * disp(i,1) * (pforce(i,1) / massvec(i,1) - pforceold(i,1) / massvec(i,1)) / (dt * velhalfold(i,1))
        endif
        if (velhalfold(i,2).ne.0.0d0) then
            cn1 = cn1 - disp(i,2) * disp(i,2) * (pforce(i,2) / massvec(i,2) - pforceold(i,2) / massvec(i,2)) / (dt * velhalfold(i,2))
        endif
		cn2 = cn2 + disp(i,1) * disp(i,1)
		cn2 = cn2 + disp(i,2) * disp(i,2)
    enddo

	if (cn2.ne.0.0d0) then
        if ((cn1 / cn2) > 0.0d0) then 
            cn = 2.0d0 * dsqrt(cn1 / cn2)
        else
            cn = 0.0d0
        endif
    else
        cn = 0.0d0
    endif

	if (cn > 2.0d0) then
		cn = 1.9d0
	endif

	do i = 1,totnode
        ! Integrate acceleration over time. 
		if (tt.eq.1) then
            velhalf(i,1) = 1.0d0 * dt / massvec(i,1) * (pforce(i,1) + bforce(i,1)) / 2.0d0	
            velhalf(i,2) = 1.0d0 * dt / massvec(i,2) * (pforce(i,2) + bforce(i,2)) / 2.0d0
        else	
            velhalf(i,1) = ((2.0d0 - cn * dt) * velhalfold(i,1) + 2.0d0 * dt / massvec(i,1) * (pforce(i,1) + bforce(i,1))) / (2.0d0 + cn * dt)
            velhalf(i,2) = ((2.0d0 - cn * dt) * velhalfold(i,2) + 2.0d0 * dt / massvec(i,2) * (pforce(i,2) + bforce(i,2))) / (2.0d0 + cn * dt)
        endif
   
        vel(i,1) = 0.5d0 * (velhalfold(i,1) + velhalf(i,1))	
        vel(i,2) = 0.5d0 * (velhalfold(i,2) + velhalf(i,2))	
        disp(i,1) = disp(i,1) + velhalf(i,1) * dt	
        disp(i,2) = disp(i,2) + velhalf(i,2) * dt	

        velhalfold(i,1) = velhalf(i,1)
        velhalfold(i,2) = velhalf(i,2)
		pforceold(i,1) = pforce(i,1)
		pforceold(i,2) = pforce(i,2)
    enddo    
    
    !Adaptive dynamic relaxation
    
	if (tt.eq.nt) then
        !printing results to an output file
		open(26,file = 'coord_disp_pd_nt.txt')

		do i = 1, ndivx*ndivy
			write(26,111) coord(i,1), coord(i,2), disp(i,1), disp(i,2)
		enddo

		close(26)

        open(27,file = 'horizontal_disps.txt')

		do i = 1, ndivx*ndivy
            if (dabs(coord(i,2) - (dx / 2.0d0)).le.1.0d-8) then
                andisp(i,1) = alpha * dtemp * coord(i,1)
                andisp(i,2) = alpha * dtemp * coord(i,2)
			    write(27,222) coord(i,1), coord(i,2), disp(i,1), disp(i,2), andisp(i,1), andisp(i,2)
            endif
		enddo

		close(27)
        
        open(28,file = 'vertical_disps.txt')

		do i = 1, ndivx*ndivy
            if (dabs(coord(i,1) - (dx / 2.0d0)).le.1.0d-8) then
                andisp(i,1) = alpha * dtemp * coord(i,1)
                andisp(i,2) = alpha * dtemp * coord(i,2)
			    write(28,222) coord(i,1), coord(i,2), disp(i,1), disp(i,2), andisp(i,1), andisp(i,2)
            endif
		enddo

		close(28)
	endif

enddo

111 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5)
222 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5)

end program main