program main

implicit none

integer ndivx, ndivy, totnode, nt, maxfam
!ndivx: Number of divisions in x direction - except boundary region
parameter (ndivx = 240)
!ndivy: Number of divisions in y direction - except boundary region
parameter (ndivy = 120)
!totnode: Total number of material points
parameter (totnode = ndivx*ndivy)
!nt: Total number of time step
parameter (nt = 4000)
!maxfam: Maximum number of material points inside a horizon of a material point
parameter (maxfam = 100)
real *8 coord(totnode,2)
integer numfam(totnode,1), pointfam(totnode,1), nodefam(1000000,1)
real *8 length, width, thick, dx, delta, dens, emod1, emod2
real *8 pratio12, pratio21, area, vol, bcf, bcm 
real *8 pforce(totnode,2), pforceold(totnode,2), bforce(totnode,2), stendensf(totnode,2), stendensm(totnode,2)
real *8 sedloadf1, sedloadf2, sedloadm1, sedloadm2
real *8 fncstf(totnode,2), fncstm(totnode,2), fncstfold(totnode,2), fncstmold(totnode,2) 
real *8 disp(totnode,2), vel(totnode,2) 
real *8 velhalfold(totnode,2), velhalf(totnode,2), acc(totnode,2), massvec(totnode,2), andisp(totnode,2)
real *8 dt, totime, ctime, idist, enddisp(nt,1), endtime(nt,1)
real *8 fac, radij 
integer nnum, i, j, tt, cnode 
real *8 nlength, dforce1, dforce2, pi, tmpout
integer tmpout2
logical tmpout3
real *8 q11, q12, q22, q66
real *8 dforce1f, dforce2f, dforce1m, dforce2m 
real *8 theta, scfx, scfy, scfr, scmx, scmy, scmr 
real *8	cn, cn1, cn2, cs, sn
real *8 alpha, dtemp, alphaxx, alphayy, alphaxy

!!!inputs
pi = dacos(-1.0d0)

!length: Total length of the lamina
length = 0.1524d0
!width: Total width of the lamina
width = 0.0762d0
!thick: Thickness of the lamina
thick = 1.651d-4
!dx: Spacing between material points
dx = length / ndivx
!delta: Horizon
delta = 3.015d0 * dx
!dens: Density
dens = 8000.0d0
!emod1: Elastic modulus in fiber direction
emod1 = 159.96d9
!emod2: Elastic modulus in matrix direction
emod2 = 8.96d9
!pratio12 = In-plane Poisson's ratio
pratio12 = 1.0d0 / 3.0d0
!pratio21 = Poisson's ratio
pratio21 = emod2 / emod1 * pratio12
!Q11: Element of stiffness matrix
q11 = emod1 / (1.0d0 - pratio21 * pratio12)
!Q12: Element of stiffness matrix
q12 = pratio12 * emod2 / (1.0d0 - pratio21 * pratio12)
!Q22: Element of stiffness matrix
q22 = emod2 / (1.0d0 - pratio21 * pratio12)
!Q66: Element of stiffness matrix
q66 = q12
theta = 0.0d0*pi/180.d0
cs = dcos(theta)
sn = dsin(theta)
!area: Cross-sectional area
area = dx * dx
!vol: Volume of a material point
vol = area * thick
!bcf: Bond constant fiber
bcf = 2.0d0 * 29.0d0 / 4.0d0 * (q11 - q22) / (pi * thick * delta**3)
!bcm: Bond constant matrix
bcm = 8.0d0 * q22 / (pi * thick * delta**3)
!sedload1: Strain energy density for the first loading
sedloadf1 = 0.5d0 * (q11 - q22) * (0.001d0)**2
sedloadm1 = 0.5d0 * (q22) * (0.001d0)**2
!sedload2: Strain energy density for the second loading
sedloadf2 = 0.0d0
sedloadm2 = 0.5d0 * (q22) * (0.001d0)**2
!dt: Time interval
dt = 1.0d0
!totime: Total time
totime = nt * dt
!ctime: Current time
ctime = 0.0d0
!idist: Initial distance
idist = 0.0d0
!fac: Volume correction factor
fac = 0.0d0
!radij: Node radius
radij = dx / 2.0d0
!nnum: Node number
nnum = 0
!cnode: Current material point
cnode = 0
!Length of deformed bond
nlength = 0.0d0
!dforce1: x component of the PD force between two material points
dforce1 = 0.0d0
!dforce2: y component of the PD force between two material points
dforce2 = 0.0d0
tmpout = 0.0d0
tmpout2 = 0
tmpout3 = .FALSE.

alpha = 0.0d0
!dtemp: Temperature change
dtemp = 50.0d0
!alphaxx: coefficient of thermal expansion in fiber direction
alphaxx = -1.52d-6
!alphayy: coefficient of thermal expansion in matrix direction
alphayy = 34.3d-6
alphaxy = 0.0d0

do i = 1, totnode
    !coord: Material point locations, 1:x-coord, 2:y-coord
	coord(i,1) = 0.0d0
	coord(i,2) = 0.0d0
    !numfam: Number of family members of each material point
	numfam(i,1) = 0
    !pointfam: index array to find the family members in nodefam array
	pointfam(i,1) = 0
    !pforce: total peridynamic force acting on a material point, 1:x-coord, 2:y-coord
    pforce(i,1) = 0.0d0
    pforce(i,2) = 0.0d0
    !bforce: body load acting on a material point, 1:x-coord, 2:y-coord
	bforce(i,1) = 0.0d0
    bforce(i,2) = 0.0d0
    !stendens: strain energy of fiber bonds associated with a material point, 1:loading 1, 2:loading 2
	stendensf(i,1) = 0.0d0
	stendensf(i,2) = 0.0d0
    !stendens: strain energy of matrix bonds associated with a material point, 1:loading 1, 2:loading 2
	stendensm(i,1) = 0.0d0
	stendensm(i,2) = 0.0d0
    !fncst: surface correction factor of fiber bonds associated with a material point, 1:loading 1, 2:loading 2
	fncstf(i,1) = 1.0d0
	fncstf(i,2) = 1.0d0
	fncstfold(i,1) = 1.0d0
	fncstfold(i,2) = 1.0d0
    !fncst: surface correction factor of fiber bonds associated with a material point, 1:loading 1, 2:loading 2
	fncstm(i,1) = 1.0d0
	fncstm(i,2) = 1.0d0
	fncstmold(i,1) = 1.0d0
	fncstmold(i,2) = 1.0d0
    !disp: displacement of a material point, 1:x-coord, 2:y-coord
	disp(i,1) = 0.0d0
	disp(i,2) = 0.0d0
    !andisp: analytical displacements for results, 1:x-coord, 2:y-coord
	andisp(i,1) = 0.0d0
	andisp(i,2) = 0.0d0
    !vel: velocity of a material point, 1:x-coord, 2:y-coord
	vel(i,1) = 0.0d0
	vel(i,2) = 0.0d0
    !acc: acceleration of a material point, 1:x-coord, 2:y-coord 
	acc(i,1) = 0.0d0
	acc(i,2) = 0.0d0
    !massvec: massvector for adaptive dynamic relaxation, 1:x-coord, 2:y-coord
	massvec(i,1) = 0.0d0
	massvec(i,2) = 0.0d0
	velhalfold(i,1) = 0.0d0
	velhalfold(i,2) = 0.0d0
    !pforceold: total peridynamic force acting on a material point in the previous time step
    !1:x-coord, 2:y-coord
	pforceold(i,1) = 0.0d0
	pforceold(i,2) = 0.0d0
	velhalf(i,1) = 0.0d0
	velhalf(i,2) = 0.0d0
enddo

do i = 1, 1000000
    !nodefam: array containing family members of all material points
	nodefam(i,1) = 0
enddo

do i = 1, nt
	enddisp(i,1) = 0.0d0
	endtime(i,1) = 0.0d0
enddo

cnode = 0

dforce1f = 0.0d0
dforce2f = 0.0d0
dforce1m = 0.0d0
dforce2m = 0.0d0
theta = 0.0d0
scfx = 0.0d0
scfy = 0.0d0
scfr = 0.0d0
scmx = 0.0d0
scmy = 0.0d0
scmr = 0.0d0

cn = 0.0d0
cn1 = 0.0d0
cn2 = 0.0d0
!!!inputs

!Specification of the locations of material points
!Material points of the lamina
do i = 1,ndivx
    do j = 1,ndivy
        nnum = nnum + 1
        coord(nnum,1) = (-1.0d0 * length / 2.0d0) + (dx / 2.0d0) + (i-1) * dx
        coord(nnum,2) = (-1.0d0 * width / 2.0d0) + (dx / 2.0d0) + (j-1) * dx
    enddo
enddo

do i = 1,totnode
    if (i.eq.1) then
        pointfam(i,1) = 1
    else
        pointfam(i,1) = pointfam(i-1,1) + numfam(i-1,1)
    endif
    do j = 1,totnode
        idist = dsqrt((coord(j,1) - coord(i,1))**2 + (coord(j,2) - coord(i,2))**2)
        if(i.ne.j) then
            if(idist <= delta) then
                numfam(i,1) = numfam(i,1) + 1
                nodefam(pointfam(i,1)+numfam(i,1)-1,1) = j
            endif
        endif
    enddo
enddo

!Determination of surface correction factors 
!loading 1
do i = 1,totnode
    disp(i,1) = 0.001d0 * coord(i,1)
    disp(i,2) = 0.0d0
enddo

do i = 1,totnode
    stendensf(i,1) = 0.0d0
    stendensm(i,1) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
        if (idist <= delta-radij) then
            fac = 1.0d0
        elseif (idist <= delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif
                       
        if (dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
            stendensf(i,1) = stendensf(i,1) + 0.5d0 * 0.5d0 * bcf * ((nlength - idist) / idist)**2 * idist * vol * fac 
            stendensm(i,1) = stendensm(i,1) + 0.5d0 * 0.5d0 * bcm * ((nlength - idist) / idist)**2 * idist * vol * fac 
        else
            stendensm(i,1) = stendensm(i,1) + 0.5d0 * 0.5d0 * bcm * ((nlength - idist) / idist)**2 * idist * vol * fac 
        endif          
    enddo
    fncstf(i,1) = sedloadf1 / stendensf(i,1)
    fncstm(i,1) = sedloadm1 / stendensm(i,1)
enddo
    
!loading 2
do i = 1,totnode
    disp(i,1) = 0.0d0
    disp(i,2) = 0.001d0 * coord(i,2)
enddo

do i = 1,totnode
    stendensf(i,2) = 0.0d0
    stendensm(i,2) = 0.0d0
    do j = 1,numfam(i,1)
        cnode = nodefam(pointfam(i,1)+j-1,1)
        idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
        nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
        if (idist <= delta-radij) then
            fac = 1.0d0
        elseif (idist <= delta+radij) then
            fac = (delta+radij-idist)/(2.0d0*radij)
        else
            fac = 0.0d0
        endif
                       
        if (dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
            stendensf(i,2) = stendensf(i,2) + 0.5d0 * 0.5d0 * bcf * ((nlength - idist) / idist)**2 * idist * vol * fac 
            stendensm(i,2) = stendensm(i,2) + 0.5d0 * 0.5d0 * bcm * ((nlength - idist) / idist)**2 * idist * vol * fac 
        else
            stendensm(i,2) = stendensm(i,2) + 0.5d0 * 0.5d0 * bcm * ((nlength - idist) / idist)**2 * idist * vol * fac 
        endif          
    enddo
    fncstm(i,2) = sedloadm2 / stendensm(i,2)
enddo
    
!initial displacement
do i = 1,totnode
        vel(i,1) = 0.0d0
        vel(i,2) = 0.0d0
        disp(i,1) = 0.0d0
        disp(i,2) = 0.0d0         
enddo

!Stable mass vector computation
do i = 1,totnode
   !5 is a safety factor
   massvec(i,1) = 0.25 * dt * dt * (pi * delta**2 * thick) * bcf / dx * 5.0d0
   massvec(i,2) = 0.25 * dt * dt * (pi * delta**2 * thick) * bcf / dx * 5.0d0
enddo

open(26,file = 'damage1000.txt')
open(27,file = 'damage2000.txt')
open(28,file = 'damage3000.txt')
open(29,file = 'damage4000.txt')

do tt = 1,nt
    ctime = tt * dt
    do i = 1,totnode
		pforce(i,1) = 0.0d0
		pforce(i,2) = 0.0d0
        do j = 1,numfam(i,1)          
            cnode = nodefam(pointfam(i,1)+j-1,1)
            idist = dsqrt((coord(cnode,1) - coord(i,1))**2 + (coord(cnode,2) - coord(i,2))**2)
            nlength = dsqrt((coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1))**2 + (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2))**2)
            if (idist <= delta-radij) then
                fac = 1.0d0
            elseif (idist <= delta+radij) then
                fac = (delta+radij-idist)/(2.0d0*radij)
            else
                fac = 0.0d0
            endif
            if (dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
                theta = 0.0d0
            elseif (dabs(coord(cnode,1) - coord(i,1)) <= 1.0d-10) then
                theta = 90.0d0 * pi / 180.0d0
            else
                theta = datan(dabs(coord(cnode,2) - coord(i,2)) / dabs(coord(cnode,1) - coord(i,1)))
            endif
            !Determination of the surface correction between two material points
            scfx = (fncstf(i,1) + fncstf(cnode,1)) / 2.0d0
            scfy = (fncstf(i,2) + fncstf(cnode,2)) / 2.0d0
            scfr = 1.0d0 / ((dcos(theta))**2 / (scfx)**2)
            scfr = dsqrt(scfr)
            scmx = (fncstm(i,1) + fncstm(cnode,1)) / 2.0d0
            scmy = (fncstm(i,2) + fncstm(cnode,2)) / 2.0d0
            scmr = 1.0d0 / (((dcos(theta))**2 / (scmx)**2) + ((dsin(theta))**2 / (scmy)**2))
            scmr = dsqrt(scmr)
                
            alpha = alphaxx * (dcos(theta))**2 + alphayy * (dsin(theta))**2 + alphaxy * dsin(theta) * dcos(theta)
                
            if (dabs(coord(cnode,2) - coord(i,2)) <= 1.0d-10) then
                dforce1f = bcf * ((nlength - idist) / idist - alpha * dtemp) * vol * scfr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength             
				dforce2f = bcf * ((nlength - idist) / idist - alpha * dtemp) * vol * scfr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength             
				dforce1m = bcm * ((nlength - idist) / idist - alpha * dtemp) * vol * scmr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength                               
				dforce2m = bcm * ((nlength - idist) / idist - alpha * dtemp) * vol * scmr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength             

				pforce(i,1) = pforce(i,1) + dforce1f + dforce1m    
				pforce(i,2) = pforce(i,2) + dforce2f + dforce2m             
            else
                dforce1m = bcm * ((nlength - idist) / idist - alpha * dtemp) * vol * scmr * fac * (coord(cnode,1) + disp(cnode,1) - coord(i,1) - disp(i,1)) / nlength             
                dforce2m = bcm * ((nlength - idist) / idist - alpha * dtemp) * vol * scmr * fac * (coord(cnode,2) + disp(cnode,2) - coord(i,2) - disp(i,2)) / nlength             
					
                pforce(i,1) = pforce(i,1) + dforce1m             
                pforce(i,2) = pforce(i,2) + dforce2m                              
            endif         
        enddo
    enddo
    
    !Adaptive dynamic relaxation
    cn = 0.0d0
	cn1 = 0.0d0
	cn2 = 0.0d0
	do i = 1, totnode
        if (velhalfold(i,1).ne.0.0d0) then
            cn1 = cn1 - disp(i,1) * disp(i,1) * (pforce(i,1) / massvec(i,1) - pforceold(i,1) / massvec(i,1)) / (dt * velhalfold(i,1))
        endif
        if (velhalfold(i,2).ne.0.0d0) then
            cn1 = cn1 - disp(i,2) * disp(i,2) * (pforce(i,2) / massvec(i,2) - pforceold(i,2) / massvec(i,2)) / (dt * velhalfold(i,2))
        endif
		cn2 = cn2 + disp(i,1) * disp(i,1)
		cn2 = cn2 + disp(i,2) * disp(i,2)
    enddo

	if (cn2.ne.0.0d0) then
        if ((cn1 / cn2) > 0.0d0) then
            cn = 2.0d0 * dsqrt(cn1 / cn2)
        else
            cn = 0.0d0
        endif
    else
        cn = 0.0d0
    endif

	if (cn > 2.0d0) then
		cn = 1.9d0
	endif

	do i = 1, totnode
        ! Integrate acceleration over time. 
		if (tt == 1) then
            velhalf(i,1) = 1.0d0 * dt / massvec(i,1) * (pforce(i,1) + bforce(i,1)) / 2.0d0		
			velhalf(i,2) = 1.0d0 * dt / massvec(i,2) * (pforce(i,2) + bforce(i,2)) / 2.0d0		
        else	
            velhalf(i,1) = ((2.0d0 - cn * dt) * velhalfold(i,1) + 2.0d0 * dt / massvec(i,1) * (pforce(i,1) + bforce(i,1))) / (2.0d0 + cn * dt)
			velhalf(i,2) = ((2.0d0 - cn * dt) * velhalfold(i,2) + 2.0d0 * dt / massvec(i,2) * (pforce(i,2) + bforce(i,2))) / (2.0d0 + cn * dt)
		endif
		vel(i,1) = 0.5d0 * (velhalfold(i,1) + velhalf(i,1))	
		vel(i,2) = 0.5d0 * (velhalfold(i,2) + velhalf(i,2))	
		disp(i,1) = disp(i,1) + velhalf(i,1) * dt
		disp(i,2) = disp(i,2) + velhalf(i,2) * dt			

        velhalfold(i,1) = velhalf(i,1)
		velhalfold(i,2) = velhalf(i,2)
		pforceold(i,1) = pforce(i,1)
		pforceold(i,2) = pforce(i,2)
    enddo
    !Adaptive dynamic relaxation

    endtime(tt,1) = ctime
	if (tt.eq.1000) then
		do i = 1, totnode
			write(26,111) coord(i,1), coord(i,2), disp(i,1), disp(i,2)
		enddo
	elseif (tt.eq.2000) then
		do i = 1, totnode
			write(27,111) coord(i,1), coord(i,2), disp(i,1), disp(i,2)
		enddo
	elseif (tt.eq.3000) then
		do i = 1, totnode
			write(28,111) coord(i,1), coord(i,2), disp(i,1), disp(i,2)
		enddo
	elseif (tt.eq.4000) then
		do i = 1, totnode
			write(29,111) coord(i,1), coord(i,2), disp(i,1), disp(i,2)
        enddo

        open(30,file = 'horizontal_disps.txt')

		do i = 1, totnode
            if (dabs(coord(i,2) - (dx / 2.0d0)).le.1.0d-8) then
                andisp(i,1) = alphaxx * dtemp * coord(i,1)
                andisp(i,2) = alphayy * dtemp * coord(i,2)
			    write(30,222) coord(i,1), coord(i,2), disp(i,1), disp(i,2), andisp(i,1), andisp(i,2)
            endif
		enddo

		close(30)
        
        open(31,file = 'vertical_disps.txt')

		do i = 1, totnode
            if (dabs(coord(i,1) - (dx / 2.0d0)).le.1.0d-8) then
                andisp(i,1) = alphaxx * dtemp * coord(i,1)
                andisp(i,2) = alphayy * dtemp * coord(i,2)
			    write(31,222) coord(i,1), coord(i,2), disp(i,1), disp(i,2), andisp(i,1), andisp(i,2)
            endif
		enddo

		close(31)
	endif
enddo


111 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5)
222 format(e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5,3x,e12.5)
close(26)
close(27)
close(28)
close(29)

end program main
