function U = reference_solution_2_28(x,y,Nterms)
    %This function computes the expression (2.28) of the book on the 2D grid
    %generated by the 1D grids x and y.
    %The sum is computed for all couple of m and n in [1:2:(2*Nterms-1)]
    %A total of Nterms^2 are accumulated.
    %
    %Copyright (c) 2013, Francisco Chinesta (Ecole Centrale de Nantes), Roland Keunings (Universite catholique de Louvain), Adrien Leygue(CNRS)
    %Author: Adrien Leygue.
    %All rights reserved.
    %See License file for more details
    
    
    %all values of m and n
    idx = fliplr(1:2:(2*Nterms-1));
    
    %reshape x and y respectively to line and column vectors
    x = reshape(x,[1 numel(x)]);
    y = reshape(y,[numel(y) 1]);
    
    %auxilliary variables for readability
    Lx = x(end);
    Ly = y(end);
    
    %compute all (m,n) pairs
    [M,N] = meshgrid(idx,idx);
    M = M(:);
    N = N(:);
    %compute the scalar factor of each term
    FACT = (16*(Lx^2*Ly^2)*ones(size(M)))./(pi^4*(Ly^2*M.^2+Lx^2*N.^2).*M.*N);
    
    %reorder the terms to accumulate the smaller ones first
    [~ ,p] = sort(FACT(:));
    M = M(p);
    N = N(p);
    FACT = FACT(p);
    
    %Perform the sum of all terms
    U = zeros(numel(y),numel(x));
    for i=1:numel(p)
        U = U+sin(N(i)*pi*y/Ly)*sin(M(i)*pi*x/Lx)*FACT(i);
    end
    
end
