-- SPATIAL DATABASE FOR GPS WILDLIFE TRACKING DATA, F. Urbano and F. Cagnacci (eds.)
-- DOI: 10.1007/978-3-319-03743-1_4, Springer International Publishing Switzerland 2014

-- Definition of the constraints on the raster tables

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_nodata_values_rast CHECK (_raster_constraint_nodata_values(rast)::numeric(16,10)[] = '{-32768}'::numeric(16,10)[]);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_num_bands_rast CHECK (st_numbands(rast) = 1);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_out_db_rast CHECK (_raster_constraint_out_db(rast) = '{f}'::boolean[]);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_pixel_types_rast CHECK (_raster_constraint_pixel_types(rast) = '{16BSI}'::text[]);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_same_alignment_rast CHECK (st_samealignment(rast, '01000000004F1BE8B4814E4B3F4F1BE8B4814E4BBF52B81E85EBD1254014AE47E17A14474000000000000000000000000000000000E610000001000100'::raster));

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_scalex_rast CHECK (st_scalex(rast)::numeric(16,10) = 0.000833333333333333::numeric(16,10));

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_scaley_rast CHECK (st_scaley(rast)::numeric(16,10) = (-0.000833333333333333)::numeric(16,10));

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_srid_rast CHECK (st_srid(rast) = 4326);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_width_rast CHECK (st_width(rast) = 20);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_height_rast CHECK (st_height(rast) = 20);

ALTER TABLE env_data.srtm_dem
  ADD CONSTRAINT enforce_max_extent_rast CHECK (st_coveredby(st_convexhull(rast), '0103000020E6100000010000000500000052B81E85EBD1254036D069039DF6464052B81E85EBD1254014AE47E17A14474052B81E85EB51264014AE47E17A14474052B81E85EB51264036D069039DF6464052B81E85EBD1254036D069039DF64640'::geometry));


ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_height_rast CHECK (st_height(rast) = 20);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_max_extent_rast CHECK (st_coveredby(st_convexhull(rast), '0103000020DB0B000001000000050000000000000010C1504100000000085D43410000000010C15041000000000088434100000000A4D25041000000000088434100000000A4D2504100000000085D43410000000010C1504100000000085D4341'::geometry));

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_nodata_values_rast CHECK (_raster_constraint_nodata_values(rast)::numeric(16,10)[] = '{0}'::numeric(16,10)[]);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_num_bands_rast CHECK (st_numbands(rast) = 1);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_out_db_rast CHECK (_raster_constraint_out_db(rast) = '{f}'::boolean[]);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_pixel_types_rast CHECK (_raster_constraint_pixel_types(rast) = '{8BUI}'::text[]);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_same_alignment_rast CHECK (st_samealignment(rast, '0100000000000000000000594000000000000059C00000000010C15041000000000088434100000000000000000000000000000000DB0B000001000100'::raster));

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_scalex_rast CHECK (st_scalex(rast)::numeric(16,10) = 100::numeric(16,10));

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_scaley_rast CHECK (st_scaley(rast)::numeric(16,10) = (-100)::numeric(16,10));

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_srid_rast CHECK (st_srid(rast) = 3035);

ALTER TABLE env_data.corine_land_cover
  ADD CONSTRAINT enforce_width_rast CHECK (st_width(rast) = 20);


ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_height_rast CHECK (st_height(rast) = 20);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_max_extent_rast CHECK (st_coveredby(st_convexhull(rast), '0103000020E610000001000000050000009AB22EC95CB82540DA84C5F2F8F246409AB22EC95CB82540989537D1F81247401117DBFF5B782640989537D1F81247401117DBFF5B782640DA84C5F2F8F246409AB22EC95CB82540DA84C5F2F8F24640'::geometry));

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_nodata_values_rast CHECK (_raster_constraint_nodata_values(rast)::numeric(16,10)[] = '{-3000}'::numeric(16,10)[]);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_num_bands_rast CHECK (st_numbands(rast) = 1);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_out_db_rast CHECK (_raster_constraint_out_db(rast) = '{f}'::boolean[]);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_pixel_types_rast CHECK (_raster_constraint_pixel_types(rast) = '{16BSI}'::text[]);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_same_alignment_rast CHECK (st_samealignment(rast, '0100000000E9A9C42BFF10613FE6A9C42BFF1061BF9AB22EC95CB82540989537D1F812474000000000000000000000000000000000E610000001000100'::raster));

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_scalex_rast CHECK (st_scalex(rast)::numeric(16,10) = 0.0020833::numeric(16,10));

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_scaley_rast CHECK (st_scaley(rast)::numeric(16,10) = (-0.0020833)::numeric(16,10));

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_srid_rast CHECK (st_srid(rast) = 4326);

ALTER TABLE env_data.ndvi_modis
  ADD CONSTRAINT enforce_width_rast CHECK (st_width(rast) = 20);
