%Forward 2D lifting biorthogonal wavelet  transform
function y=BW_anal_2D(x,Par, DeTr,pol_dis_qint)
% x--  input signal of size [2^J,2^J]
% DeTr-- number of decomp. levels
 %Par--spline order
% pol_dis_qint=1--polynom. interp. spline; =2--discr. interp. spline; =3--quasi-interp. spline 
%Par=33 --extended quadratic quasiinterp. spline
y=zeros(size(x));
q=sqrt(2);
[ve,ho]=size(x); J=log2(ve);
z=fft2(x); 
 
for j=1:DeTr
ii=1:2^(J-j+1 );

[ze,zo]=down_lif(z,Par,pol_dis_qint);
 z=[ze*q, zo/q]';
 [ze,zo]=down_lif(z,Par,pol_dis_qint);
 z=[ze*q, zo/q]';
 [a1,a2]=havsvB(z); 
 [z, a12]=havshB(a1);[a21, a22]=havshB(a2);
  
 fa12=real(ifft2(a12)); 
 fa22=real(ifft2(a22)); 
fa21=real(ifft2(a21)); 
 y(ii,ii)=[z fa12; fa21 fa22];
 
end
z=real(ifft2(z));
y(ii,ii)=[z fa12;fa21 fa22];


% Copyright (c) 2013. Valery A. Zheludev